/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import net.sf.clipsrules.jni.FactInstance;
import net.sf.clipsrules.jni.Module;
import net.sf.clipsrules.jni.SlotValue;
import net.sf.clipsrules.jni.examples.ide.FactInstanceTableModel;
import net.sf.clipsrules.jni.examples.ide.ModuleTableModel;
import net.sf.clipsrules.jni.examples.ide.SlotValueTableModel;

public class EntityBrowserFrame
extends JInternalFrame
implements ActionListener,
ListSelectionListener {
    private JFrame browserFrame;
    private JTable modulesTable;
    private JTable entityTable;
    private JTable slotsTable;
    private ModuleTableModel modulesModel;
    private FactInstanceTableModel entityModel;
    private SlotValueTableModel slotsModel;
    private JScrollPane modulesPane;
    private JScrollPane entitiesPane;
    private JScrollPane slotsPane;
    private JSplitPane entitiesSlotsPane;
    private JSplitPane contentPane;
    private JTextField searchField;
    private JCheckBox displayDefaultedValuesCheckBox;
    private List<Module> modules;
    private List<FactInstance> entities;
    private HashMap<Long, BitSet> scopes;
    private String entityName;
    private String lastModule;
    private int lastModuleRow;
    private String lastEntity;
    private int lastEntityRow;
    public static final String BROWSER_SELECTION_ACTION = "BrowserSelectionAction";
    private static final String DISPLAY_DEFAULTED_VALUES_ACTION = "DisplayDefaultedValues";
    private ActionListener actionTarget = null;

    EntityBrowserFrame(String string, String string2, String string3, int n, Font font) {
        this(new ArrayList<Module>(), new ArrayList<FactInstance>(), new HashMap<Long, BitSet>(), string, string2, string3, n, font);
    }

    EntityBrowserFrame(List<Module> list, List<FactInstance> list2, HashMap<Long, BitSet> hashMap, String string, String string2, String string3, int n, Font font) {
        super(string + " Browser #" + n, true, true, true, true);
        this.entityName = string;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setSize(600, 200);
        this.setMinimumSize(new Dimension(450, 150));
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(600, 40));
        this.displayDefaultedValuesCheckBox = new JCheckBox("Display Defaulted Values");
        this.displayDefaultedValuesCheckBox.setEnabled(true);
        this.displayDefaultedValuesCheckBox.setActionCommand(DISPLAY_DEFAULTED_VALUES_ACTION);
        this.displayDefaultedValuesCheckBox.addActionListener(this);
        jPanel.add(this.displayDefaultedValuesCheckBox);
        JLabel jLabel = new JLabel("Search:  ");
        this.searchField = new JTextField(20);
        this.searchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EntityBrowserFrame.this.performSearch();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(jLabel);
        jPanel2.add(this.searchField);
        jPanel.add(jPanel2);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addComponent(this.displayDefaultedValuesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(jPanel2));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.displayDefaultedValuesCheckBox).addComponent(jPanel2));
        this.getContentPane().add(jPanel);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        this.modulesModel = new ModuleTableModel();
        this.modulesTable = new JTable(this.modulesModel);
        this.modulesTable.setSelectionMode(0);
        this.modulesTable.getSelectionModel().addListSelectionListener(this);
        this.modulesTable.getTableHeader().setReorderingAllowed(false);
        this.modulesTable.getColumnModel().getColumn(0).setCellRenderer(defaultTableCellRenderer);
        this.modulesPane = new JScrollPane(this.modulesTable);
        this.entityModel = new FactInstanceTableModel(string2, string3);
        this.entityTable = new JTable(this.entityModel);
        this.entityTable.setSelectionMode(0);
        this.entityTable.getSelectionModel().addListSelectionListener(this);
        this.entityTable.getTableHeader().setReorderingAllowed(false);
        TableRowSorter<FactInstanceTableModel> tableRowSorter = new TableRowSorter<FactInstanceTableModel>(this.entityModel);
        RowFilter<FactInstanceTableModel, Integer> rowFilter = new RowFilter<FactInstanceTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends FactInstanceTableModel, ? extends Integer> entry) {
                FactInstanceTableModel factInstanceTableModel = entry.getModel();
                FactInstance factInstance = factInstanceTableModel.getFactInstance(entry.getIdentifier());
                int n = EntityBrowserFrame.this.modulesTable.getSelectedRow();
                if (n == -1) {
                    return true;
                }
                n = EntityBrowserFrame.this.modulesTable.convertRowIndexToModel(n);
                BitSet bitSet = (BitSet)EntityBrowserFrame.this.scopes.get(factInstance.getTypeAddress());
                if (bitSet.get(n)) {
                    return factInstance.searchForString(EntityBrowserFrame.this.searchField.getText());
                }
                return false;
            }
        };
        tableRowSorter.setRowFilter(rowFilter);
        this.entityTable.setRowSorter(tableRowSorter);
        this.entitiesPane = new JScrollPane(this.entityTable);
        this.entityTable.getColumnModel().getColumn(0).setMinWidth(65);
        this.entityTable.getColumnModel().getColumn(0).setPreferredWidth(75);
        this.entityTable.getColumnModel().getColumn(1).setPreferredWidth(75);
        this.entityTable.getColumnModel().getColumn(0).setCellRenderer(defaultTableCellRenderer);
        this.entityTable.getColumnModel().getColumn(1).setCellRenderer(defaultTableCellRenderer);
        this.slotsModel = new SlotValueTableModel();
        this.slotsTable = new JTable(this.slotsModel);
        this.slotsTable.setSelectionMode(0);
        this.slotsTable.getSelectionModel().addListSelectionListener(this);
        this.slotsTable.getTableHeader().setReorderingAllowed(false);
        TableRowSorter<SlotValueTableModel> tableRowSorter2 = new TableRowSorter<SlotValueTableModel>(this.slotsModel);
        RowFilter<SlotValueTableModel, Integer> rowFilter2 = new RowFilter<SlotValueTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SlotValueTableModel, ? extends Integer> entry) {
                if (EntityBrowserFrame.this.displayDefaultedValuesCheckBox.isSelected()) {
                    return true;
                }
                SlotValueTableModel slotValueTableModel = entry.getModel();
                SlotValue slotValue = slotValueTableModel.getSlotValue(entry.getIdentifier());
                return !slotValue.isDefault();
            }
        };
        tableRowSorter2.setRowFilter(rowFilter2);
        this.slotsTable.setRowSorter(tableRowSorter2);
        this.slotsPane = new JScrollPane(this.slotsTable);
        this.slotsTable.getColumnModel().getColumn(0).setMinWidth(65);
        this.slotsTable.getColumnModel().getColumn(0).setPreferredWidth(75);
        this.slotsTable.getColumnModel().getColumn(1).setPreferredWidth(75);
        this.slotsTable.getColumnModel().getColumn(0).setCellRenderer(defaultTableCellRenderer);
        this.slotsTable.getColumnModel().getColumn(1).setCellRenderer(defaultTableCellRenderer);
        this.entitiesSlotsPane = new JSplitPane(1, this.entitiesPane, this.slotsPane);
        this.entitiesSlotsPane.setOneTouchExpandable(true);
        this.entitiesSlotsPane.setDividerLocation(200);
        this.entitiesSlotsPane.setDividerSize(15);
        this.entitiesSlotsPane.setPreferredSize(new Dimension(400, 160));
        this.entitiesSlotsPane.setAlignmentX(0.5f);
        this.contentPane = new JSplitPane(1, this.modulesPane, this.entitiesSlotsPane);
        this.contentPane.setOneTouchExpandable(true);
        this.contentPane.setDividerLocation(125);
        this.contentPane.setDividerSize(15);
        this.contentPane.setPreferredSize(new Dimension(600, 160));
        this.contentPane.setAlignmentX(0.5f);
        this.getContentPane().add(this.contentPane);
        this.lastModule = null;
        this.lastModuleRow = -1;
        this.lastEntity = null;
        this.lastEntityRow = -1;
        this.assignData(list, list2, hashMap);
        this.assignFont(font);
        this.pack();
    }

    public void assignFont(Font font) {
        FontMetrics fontMetrics = this.modulesTable.getFontMetrics(font);
        int n = fontMetrics.getHeight() + 2;
        this.modulesTable.setFont(font);
        this.modulesTable.setRowHeight(n);
        this.modulesTable.getTableHeader().setFont(font);
        this.entityTable.setFont(font);
        this.entityTable.setRowHeight(n);
        this.entityTable.getTableHeader().setFont(font);
        this.slotsTable.setFont(font);
        this.slotsTable.setRowHeight(n);
        this.slotsTable.getTableHeader().setFont(font);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setActionTarget(ActionListener actionListener) {
        this.actionTarget = actionListener;
    }

    public void assignData(List<Module> list, List<FactInstance> list2, HashMap<Long, BitSet> hashMap) {
        this.saveSelection();
        this.modules = list;
        this.entities = list2;
        this.scopes = hashMap;
        this.modulesModel.setModules(list);
        if (this.modules.size() == 0) {
            this.entityModel.setItems(null);
            this.slotsModel.setItem(null);
        } else {
            this.entityModel.setItems(this.entities);
            this.slotsModel.setItem(null);
        }
        this.restoreSelection();
    }

    private void saveSelection() {
        Object object;
        int n = this.modulesTable.getSelectedRow();
        if (n != -1) {
            this.lastModuleRow = n;
            n = this.modulesTable.convertRowIndexToModel(n);
            object = this.modules.get(n);
            this.lastModule = ((Module)object).getModuleName();
        } else {
            this.lastModule = null;
            this.lastModuleRow = -1;
        }
        n = this.entityTable.getSelectedRow();
        if (n != -1) {
            this.lastEntityRow = n;
            n = this.entityTable.convertRowIndexToModel(n);
            object = this.entities.get(n);
            this.lastEntity = ((FactInstance)object).getName();
        } else {
            this.lastEntity = null;
            this.lastEntityRow = -1;
        }
    }

    private void restoreSelection() {
        int n;
        int n2;
        boolean bl;
        int n3;
        if (this.lastModuleRow == -1) {
            if (this.modulesTable.getRowCount() > 0) {
                this.modulesTable.setRowSelectionInterval(0, 0);
            }
        } else {
            Module module;
            n3 = this.modulesTable.getRowCount();
            bl = false;
            if (this.lastModuleRow < n3 && (module = this.modules.get(n2 = this.modulesTable.convertRowIndexToModel(this.lastModuleRow))).getModuleName().equals(this.lastModule)) {
                this.modulesTable.setRowSelectionInterval(this.lastModuleRow, this.lastModuleRow);
                bl = true;
            }
            if (!bl) {
                for (n = 0; n < n3; ++n) {
                    n2 = this.modulesTable.convertRowIndexToModel(n);
                    module = this.modules.get(n2);
                    if (!module.getModuleName().equals(this.lastModule)) continue;
                    bl = true;
                    this.modulesTable.setRowSelectionInterval(n, n);
                    break;
                }
            }
            if (!bl) {
                this.lastEntityRow = -1;
                this.lastEntity = null;
                if (n3 > 0) {
                    if (this.lastModuleRow < n3) {
                        this.modulesTable.setRowSelectionInterval(this.lastModuleRow, this.lastModuleRow);
                    } else {
                        this.modulesTable.setRowSelectionInterval(n3 - 1, n3 - 1);
                    }
                }
            }
        }
        if (this.lastEntityRow == -1) {
            if (this.entityTable.getRowCount() > 0) {
                FactInstance factInstance = this.entities.get(0);
                this.entityTable.setRowSelectionInterval(0, 0);
                this.slotsModel.setItem(factInstance);
            }
        } else {
            FactInstance factInstance;
            n3 = this.entityTable.getRowCount();
            bl = false;
            if (this.lastEntityRow < n3 && (factInstance = this.entities.get(n2 = this.entityTable.convertRowIndexToModel(this.lastEntityRow))).getName().equals(this.lastEntity)) {
                this.entityTable.setRowSelectionInterval(this.lastEntityRow, this.lastEntityRow);
                this.slotsModel.setItem(factInstance);
                bl = true;
            }
            if (!bl) {
                for (n = 0; n < n3; ++n) {
                    n2 = this.entityTable.convertRowIndexToModel(n);
                    factInstance = this.entities.get(n2);
                    if (!factInstance.getName().equals(this.lastEntity)) continue;
                    bl = true;
                    this.entityTable.setRowSelectionInterval(n, n);
                    this.slotsModel.setItem(factInstance);
                    break;
                }
            }
            if (!bl && n3 > 0) {
                if (this.lastEntityRow < n3) {
                    factInstance = this.entities.get(this.lastEntityRow);
                    this.entityTable.setRowSelectionInterval(this.lastEntityRow, this.lastEntityRow);
                    this.slotsModel.setItem(factInstance);
                } else {
                    factInstance = this.entities.get(n3 - 1);
                    this.entityTable.setRowSelectionInterval(n3 - 1, n3 - 1);
                    this.slotsModel.setItem(factInstance);
                }
            }
        }
        this.lastModuleRow = -1;
        this.lastModule = null;
        this.lastEntity = null;
        this.lastEntityRow = -1;
    }

    public long selectedEntityConstruct() {
        int n = this.entityTable.getSelectedRow();
        if (n == -1) {
            return -1L;
        }
        n = this.entityTable.convertRowIndexToModel(n);
        FactInstance factInstance = this.entities.get(n);
        return factInstance.getTypeAddress();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource().equals(this.modulesTable.getSelectionModel())) {
            int n = this.modulesTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            n = this.modulesTable.convertRowIndexToModel(n);
            this.entityModel.fireTableDataChanged();
            if (this.entityTable.getRowCount() != 0) {
                this.entityTable.setRowSelectionInterval(0, 0);
            }
        } else if (listSelectionEvent.getSource().equals(this.entityTable.getSelectionModel())) {
            int n = this.entityTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            n = this.entityTable.convertRowIndexToModel(n);
            if (this.entities.size() == 0) {
                this.slotsModel.setItem(null);
            } else {
                FactInstance factInstance = this.entities.get(n);
                this.slotsModel.setItem(factInstance);
            }
        }
        this.actionPerformed(new ActionEvent(this, 2000, BROWSER_SELECTION_ACTION));
    }

    private void performSearch() {
        this.entityModel.fireTableDataChanged();
        if (this.entityTable.getRowCount() != 0) {
            this.entityTable.setRowSelectionInterval(0, 0);
        } else {
            this.slotsModel.setItem(null);
        }
    }

    public void onActionPerformed(ActionEvent actionEvent) throws Exception {
        if (actionEvent.getActionCommand().equals(BROWSER_SELECTION_ACTION)) {
            if (this.actionTarget == null) {
                return;
            }
            this.actionTarget.actionPerformed(actionEvent);
        } else if (actionEvent.getActionCommand().equals(DISPLAY_DEFAULTED_VALUES_ACTION)) {
            this.slotsModel.fireTableDataChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.onActionPerformed(actionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

