/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sf.clipsrules.jni.examples.ide.DialogFrame;
import net.sf.clipsrules.jni.examples.ide.IDEPreferences;

public class EnvironmentMenu
extends JMenu
implements MenuListener {
    private DialogFrame dialogWindow;
    private ClearAction clearAction;
    private LoadConstructsAction loadConstructsAction;
    private LoadBatchAction loadBatchAction;
    private SetDirectoryAction setDirectoryAction;
    private ResetAction resetAction;
    private RunAction runAction;
    private HaltRulesAction haltRulesAction;
    private HaltExecutionAction haltExecutionAction;
    private ClearScrollbackAction clearScrollbackAction;
    private JMenuItem jmiClear = null;
    private JMenuItem jmiLoadConstructs = null;
    private JMenuItem jmiLoadBatch = null;
    private JMenuItem jmiSetDirectory = null;
    private JMenuItem jmiReset = null;
    private JMenuItem jmiRun = null;
    private JMenuItem jmiHaltRules = null;
    private JMenuItem jmiHaltExecution = null;
    private JMenuItem jmiClearScrollback = null;
    private IDEPreferences preferences;

    EnvironmentMenu(IDEPreferences iDEPreferences) {
        super("Environment");
        this.preferences = iDEPreferences;
        this.addMenuListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(76, 128);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(76, 192);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(82, 128);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(82, 192);
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(46, 128);
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(46, 192);
        this.clearAction = new ClearAction("Clear");
        this.loadConstructsAction = new LoadConstructsAction("Load Constructs...");
        this.loadBatchAction = new LoadBatchAction("Load Batch...");
        this.setDirectoryAction = new SetDirectoryAction("Set Directory...");
        this.resetAction = new ResetAction("Reset");
        this.runAction = new RunAction("Run");
        this.haltRulesAction = new HaltRulesAction("Halt Rules");
        this.haltExecutionAction = new HaltExecutionAction("Halt Execution");
        this.clearScrollbackAction = new ClearScrollbackAction("Clear Scrollback");
        this.jmiClear = new JMenuItem(this.clearAction);
        this.add(this.jmiClear);
        this.jmiLoadConstructs = new JMenuItem(this.loadConstructsAction);
        this.jmiLoadConstructs.setAccelerator(keyStroke);
        this.add(this.jmiLoadConstructs);
        this.jmiLoadBatch = new JMenuItem(this.loadBatchAction);
        this.jmiLoadBatch.setAccelerator(keyStroke2);
        this.add(this.jmiLoadBatch);
        this.jmiSetDirectory = new JMenuItem(this.setDirectoryAction);
        this.add(this.jmiSetDirectory);
        this.addSeparator();
        this.jmiReset = new JMenuItem(this.resetAction);
        this.jmiReset.setAccelerator(keyStroke3);
        this.add(this.jmiReset);
        this.jmiRun = new JMenuItem(this.runAction);
        this.jmiRun.setAccelerator(keyStroke4);
        this.add(this.jmiRun);
        this.jmiHaltRules = new JMenuItem(this.haltRulesAction);
        this.jmiHaltRules.setAccelerator(keyStroke5);
        this.add(this.jmiHaltRules);
        this.jmiHaltExecution = new JMenuItem(this.haltExecutionAction);
        this.jmiHaltExecution.setAccelerator(keyStroke6);
        this.add(this.jmiHaltExecution);
        this.addSeparator();
        this.jmiClearScrollback = new JMenuItem(this.clearScrollbackAction);
        this.add(this.jmiClearScrollback);
    }

    public void setDialog(DialogFrame dialogFrame) {
        this.dialogWindow = dialogFrame;
    }

    private void loadConstructs() {
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Constructs File", "clp");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        File file = this.preferences.getCurrentDirectory();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setApproveButtonText("Load");
        jFileChooser.setDialogTitle("Load Constructs");
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        File file2 = jFileChooser.getSelectedFile();
        file = jFileChooser.getCurrentDirectory();
        this.preferences.setCurrentDirectory(file);
        if (this.dialogWindow.setDirectory(file)) {
            this.dialogWindow.replaceCommand("(load \"" + file2.getName() + "\")\n");
            this.preferences.saveCurrentDirectory(file);
        } else {
            this.dialogWindow.replaceCommand("(load \"" + file2.getAbsolutePath() + "\")\n");
        }
    }

    private void loadBatch() {
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Batch File", "bat", "tst");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        File file = this.preferences.getCurrentDirectory();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setApproveButtonText("Load");
        jFileChooser.setDialogTitle("Load Batch");
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        File file2 = jFileChooser.getSelectedFile();
        file = jFileChooser.getCurrentDirectory();
        this.preferences.setCurrentDirectory(file);
        if (this.dialogWindow.setDirectory(file)) {
            this.dialogWindow.replaceCommand("(batch \"" + file2.getName() + "\")\n");
            this.preferences.saveCurrentDirectory(file);
        } else {
            this.dialogWindow.replaceCommand("(batch \"" + file2.getAbsolutePath() + "\")\n");
        }
    }

    private void setDirectory() {
        JFileChooser jFileChooser = new JFileChooser();
        File file = this.preferences.getCurrentDirectory();
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setApproveButtonText("Set");
        jFileChooser.setDialogTitle("Set Directory");
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        File file2 = jFileChooser.getSelectedFile();
        file = file2.getAbsoluteFile();
        this.preferences.setCurrentDirectory(file);
        if (this.dialogWindow.setDirectory(file)) {
            this.preferences.saveCurrentDirectory(file);
        }
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (jMenuItem == null) continue;
            jMenuItem.setEnabled(true);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        if (this.dialogWindow.isExecuting()) {
            this.jmiClear.setEnabled(false);
            this.jmiLoadConstructs.setEnabled(false);
            this.jmiLoadBatch.setEnabled(false);
            this.jmiSetDirectory.setEnabled(false);
            this.jmiReset.setEnabled(false);
            this.jmiRun.setEnabled(false);
            this.jmiHaltRules.setEnabled(true);
            this.jmiHaltExecution.setEnabled(true);
            this.jmiClearScrollback.setEnabled(false);
        } else {
            this.jmiClear.setEnabled(true);
            this.jmiLoadConstructs.setEnabled(true);
            this.jmiLoadBatch.setEnabled(true);
            this.jmiSetDirectory.setEnabled(true);
            this.jmiReset.setEnabled(true);
            this.jmiRun.setEnabled(true);
            this.jmiHaltRules.setEnabled(false);
            this.jmiHaltExecution.setEnabled(false);
            this.jmiClearScrollback.setEnabled(true);
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (jMenuItem == null) continue;
            jMenuItem.setEnabled(true);
        }
    }

    class ClearScrollbackAction
    extends AbstractAction {
        public ClearScrollbackAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!EnvironmentMenu.this.dialogWindow.isExecuting()) {
                EnvironmentMenu.this.dialogWindow.clearScrollback();
            }
        }
    }

    class HaltExecutionAction
    extends AbstractAction {
        public HaltExecutionAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EnvironmentMenu.this.dialogWindow.isExecuting()) {
                EnvironmentMenu.this.dialogWindow.haltExecution();
            }
        }
    }

    class HaltRulesAction
    extends AbstractAction {
        public HaltRulesAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EnvironmentMenu.this.dialogWindow.isExecuting()) {
                EnvironmentMenu.this.dialogWindow.haltRules();
            }
        }
    }

    class RunAction
    extends AbstractAction {
        public RunAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!EnvironmentMenu.this.dialogWindow.isExecuting()) {
                EnvironmentMenu.this.dialogWindow.replaceCommand("(run)\n");
            }
        }
    }

    class ResetAction
    extends AbstractAction {
        public ResetAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!EnvironmentMenu.this.dialogWindow.isExecuting()) {
                EnvironmentMenu.this.dialogWindow.replaceCommand("(reset)\n");
            }
        }
    }

    class SetDirectoryAction
    extends AbstractAction {
        public SetDirectoryAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!EnvironmentMenu.this.dialogWindow.isExecuting()) {
                EnvironmentMenu.this.setDirectory();
            }
        }
    }

    class LoadBatchAction
    extends AbstractAction {
        public LoadBatchAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!EnvironmentMenu.this.dialogWindow.isExecuting()) {
                EnvironmentMenu.this.loadBatch();
            }
        }
    }

    class LoadConstructsAction
    extends AbstractAction {
        public LoadConstructsAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!EnvironmentMenu.this.dialogWindow.isExecuting()) {
                EnvironmentMenu.this.loadConstructs();
            }
        }
    }

    class ClearAction
    extends AbstractAction {
        public ClearAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!EnvironmentMenu.this.dialogWindow.isExecuting()) {
                EnvironmentMenu.this.dialogWindow.replaceCommand("(clear)\n");
            }
        }
    }
}

