/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.implCommon.weighers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/implCommon/weighers/PreferKotlinxLibrariesWeigher;", "Lcom/intellij/psi/util/proximity/ProximityWeigher;", "<init>", "()V", "preferredPackages", "", "", "preferredClasses", "weigh", "", "element", "Lcom/intellij/psi/PsiElement;", "location", "Lcom/intellij/psi/util/ProximityLocation;", "Weight", "kotlin.completion.impl.shared"})
@ApiStatus.Internal
public final class PreferKotlinxLibrariesWeigher
extends ProximityWeigher {
    @NotNull
    private final Set<String> preferredPackages = SetsKt.setOf((Object)"kotlinx.datetime");
    @NotNull
    private final Set<String> preferredClasses = SetsKt.setOf((Object)"kotlinx.coroutines.flow.Flow");

    @Nullable
    public Comparable<?> weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        PsiElement psiElement = location.getPosition();
        if (!Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getLanguage() : null), (Object)KotlinLanguage.INSTANCE)) {
            return null;
        }
        KtElement ktElement = element instanceof KtElement ? (KtElement)element : null;
        if (ktElement == null) {
            return (Comparable)((Object)Weight.OTHER);
        }
        KtElement ktElement2 = ktElement;
        Object object = JavaPsiUtils.getKotlinFqName((PsiElement)ktElement2);
        if (object == null || (object = object.asString()) == null) {
            return (Comparable)((Object)Weight.OTHER);
        }
        Object fqn = object;
        if (this.preferredClasses.contains(fqn)) {
            return (Comparable)((Object)Weight.KOTLINX);
        }
        String packageFqn = StringsKt.substringBeforeLast$default((String)fqn, (char)'.', null, (int)2, null);
        if (this.preferredPackages.contains(packageFqn)) {
            return (Comparable)((Object)Weight.KOTLINX);
        }
        return (Comparable)((Object)Weight.OTHER);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/completion/implCommon/weighers/PreferKotlinxLibrariesWeigher$Weight;", "", "<init>", "(Ljava/lang/String;I)V", "OTHER", "KOTLINX", "kotlin.completion.impl.shared"})
    private static final class Weight
    extends Enum<Weight> {
        public static final /* enum */ Weight OTHER = new Weight();
        public static final /* enum */ Weight KOTLINX = new Weight();
        private static final /* synthetic */ Weight[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Weight[] values() {
            return (Weight[])$VALUES.clone();
        }

        public static Weight valueOf(String value) {
            return Enum.valueOf(Weight.class, value);
        }

        @NotNull
        public static EnumEntries<Weight> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = weightArray = new Weight[]{Weight.OTHER, Weight.KOTLINX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

