/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.kotlin.idea.base.projectStructure.NewKotlinFileHook;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurationService;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/NewKotlinFileConfigurationHook;", "Lorg/jetbrains/kotlin/idea/base/projectStructure/NewKotlinFileHook;", "<init>", "()V", "postProcess", "", "createdElement", "Lorg/jetbrains/kotlin/psi/KtFile;", "module", "Lcom/intellij/openapi/module/Module;", "kotlin.project-configuration"})
public final class NewKotlinFileConfigurationHook
extends NewKotlinFileHook {
    @Override
    public void postProcess(@NotNull KtFile createdElement, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)createdElement, (String)"createdElement");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = createdElement.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)moduleFileIndex, (String)"getFileIndex(...)");
        ModuleFileIndex fileIndex = moduleFileIndex;
        if (!fileIndex.isUnderSourceRootOfType(virtualFile2, JavaModuleSourceRootTypes.SOURCES)) {
            return;
        }
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KotlinProjectConfigurationService.Companion.getInstance(project).runAutoConfigurationIfPossible(module);
    }
}

