/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k2.notifications;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.scripting.KotlinBaseScriptingBundle;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\f\u0010\u0010\u001a\u00020\r*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\r*\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/notifications/MainKtsScriptNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "shouldBeExecutable", "", "isMainKtsScript", "virtualFile", "hasShebangComment", "Lcom/intellij/psi/PsiFile;", "isShebangComment", "Lcom/intellij/psi/PsiElement;", "Companion", "kotlin.base.scripting.k2"})
@SourceDebugExtension(value={"SMAP\nMainKtsScriptNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainKtsScriptNotificationProvider.kt\norg/jetbrains/kotlin/idea/core/script/k2/notifications/MainKtsScriptNotificationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n808#2,11:63\n1761#2,3:74\n*S KotlinDebug\n*F\n+ 1 MainKtsScriptNotificationProvider.kt\norg/jetbrains/kotlin/idea/core/script/k2/notifications/MainKtsScriptNotificationProvider\n*L\n57#1:63,11\n58#1:74,3\n*E\n"})
public final class MainKtsScriptNotificationProvider
implements EditorNotificationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MAIN_KTS = "main.kts";

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.isMainKtsScript(file) || !FileUtils.isKotlinFileType(file)) {
            return null;
        }
        return arg_0 -> MainKtsScriptNotificationProvider.collectNotificationData$lambda$2(this, file, project, arg_0);
    }

    private final boolean shouldBeExecutable(VirtualFile file, Project project) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return false;
        }
        KtFile ktFile3 = ktFile2;
        return this.hasShebangComment((PsiFile)ktFile3) && !new File(file.getPath()).canExecute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMainKtsScript(VirtualFile virtualFile) {
        if (Intrinsics.areEqual((Object)virtualFile.getName(), (Object)MAIN_KTS)) return true;
        String string = virtualFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".main.kts", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasShebangComment(PsiFile $this$hasShebangComment) {
        boolean bl;
        block4: {
            void $this$filterIsInstanceTo$iv$iv;
            JBIterable jBIterable = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)$this$hasShebangComment)).withTraversal(TreeTraversal.LEAVES_DFS)).traverse();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
            Iterable $this$filterIsInstance$iv = (Iterable)jBIterable;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiComment)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement element = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!this.isShebangComment(element)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isShebangComment(PsiElement $this$isShebangComment) {
        return $this$isShebangComment instanceof PsiComment && ((PsiComment)$this$isShebangComment).getTokenType() == KtTokens.SHEBANG_COMMENT;
    }

    private static final void collectNotificationData$lambda$2$lambda$1$lambda$0(VirtualFile $file, Project $project) {
        new File($file.getPath()).setExecutable(true);
        EditorNotifications.getInstance((Project)$project).updateNotifications($file);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$2(MainKtsScriptNotificationProvider this$0, VirtualFile $file, Project $project, FileEditor fileEditor) {
        EditorNotificationPanel editorNotificationPanel;
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        if (this$0.shouldBeExecutable($file, $project)) {
            EditorNotificationPanel editorNotificationPanel2;
            EditorNotificationPanel $this$collectNotificationData_u24lambda_u242_u24lambda_u241 = editorNotificationPanel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
            boolean bl = false;
            $this$collectNotificationData_u24lambda_u242_u24lambda_u241.text(KotlinBaseScriptingBundle.message("notification.main.kts.unable.execute", new Object[0]));
            $this$collectNotificationData_u24lambda_u242_u24lambda_u241.createActionLabel(KotlinBaseScriptingBundle.message("notification.main.kts.make.executable", new Object[0]), () -> MainKtsScriptNotificationProvider.collectNotificationData$lambda$2$lambda$1$lambda$0($file, $project));
            editorNotificationPanel = editorNotificationPanel2;
        } else {
            editorNotificationPanel = null;
        }
        return editorNotificationPanel;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/notifications/MainKtsScriptNotificationProvider$Companion;", "", "<init>", "()V", "MAIN_KTS", "", "kotlin.base.scripting.k2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

