/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.JavaFormatterUtil;
import com.intellij.psi.formatter.java.TextLineBlock;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBlockBlock
extends AbstractJavaBlock {
    private final Indent myIndent;

    public TextBlockBlock(ASTNode textBlock, Wrap wrap, AlignmentStrategy alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, @NotNull FormattingMode formattingMode) {
        if (formattingMode == null) {
            TextBlockBlock.$$$reportNull$$$0(0);
        }
        super(textBlock, wrap, alignment, indent, settings, javaSettings, formattingMode);
        this.myIndent = indent;
    }

    protected List<Block> buildChildren() {
        if (this.getFormattingMode() != FormattingMode.REFORMAT) {
            return Collections.emptyList();
        }
        int offset = this.myNode.getStartOffset();
        Alignment alignment = this.createChildAlignment();
        List<TextRange> textRanges = this.extractLinesRanges();
        ArrayList<Block> children = new ArrayList<Block>(textRanges.size());
        for (int i = 0; i < textRanges.size(); ++i) {
            TextRange range = textRanges.get(i).shiftRight(offset);
            Indent indent = i == 0 ? Indent.getNoneIndent() : Indent.getContinuationIndent();
            children.add(new TextLineBlock(range, alignment, indent, null));
        }
        return children;
    }

    @NotNull
    private List<TextRange> extractLinesRanges() {
        PsiLiteralExpression literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)this.myNode.getPsi(), PsiLiteralExpression.class);
        if (literal == null || !literal.isTextBlock()) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                TextBlockBlock.$$$reportNull$$$0(1);
            }
            return list;
        }
        int indent = PsiLiteralUtil.getTextBlockIndent(literal);
        if (indent == -1) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                TextBlockBlock.$$$reportNull$$$0(2);
            }
            return list;
        }
        String text = literal.getText();
        List<TextRange> list = JavaFormatterUtil.extractTextRangesFromLiteralText(text, indent);
        if (list == null) {
            TextBlockBlock.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            TextBlockBlock.$$$reportNull$$$0(4);
        }
        return null;
    }

    @Override
    public Indent getIndent() {
        return this.myIndent;
    }

    @Override
    public boolean isLeaf() {
        return this.getFormattingMode() != FormattingMode.REFORMAT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/TextBlockBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/TextBlockBlock";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLinesRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

