/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.plots.export;

import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.kotlin.jupyter.plots.i18n.KotlinNotebookPlotsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a0\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\r\u001a\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u001a\u001a\u0010\u0013\u001a\u00020\b*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001a\u0011\u0010\u0016\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0017*\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"KANDY_NOTIFICATIONS_GROUP", "", "kandyGroup", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "getKandyGroup", "()Lcom/intellij/notification/NotificationGroup;", "showPlotExportFailedNotification", "", "throwable", "", "showPlotSaveNotification", "savedFiles", "", "Ljava/io/File;", "skippedFiles", "errors", "showPlotExportedNotification", "file", "addPlotOpenAction", "Lcom/intellij/notification/Notification;", "files", "asDescription", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.kotlin.jupyter.plots"})
@SourceDebugExtension(value={"SMAP\nnotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 notifications.kt\ncom/intellij/kotlin/jupyter/plots/export/NotificationsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class NotificationsKt {
    @NotNull
    private static final String KANDY_NOTIFICATIONS_GROUP = "Kandy plot export";

    private static final NotificationGroup getKandyGroup() {
        return NotificationGroupManager.getInstance().getNotificationGroup(KANDY_NOTIFICATIONS_GROUP);
    }

    public static final void showPlotExportFailedNotification(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Notification notification = NotificationsKt.getKandyGroup().createNotification(KotlinNotebookPlotsBundle.message("kotlin.notebook.outputs.kandy.export.failed.notification.message", new Object[0]), NotificationsKt.asDescription(throwable), NotificationType.ERROR);
        Notifications.Bus.notify((Notification)notification);
    }

    public static final void showPlotSaveNotification(@NotNull Collection<? extends File> savedFiles, @NotNull Collection<? extends File> skippedFiles, @NotNull Collection<? extends Throwable> errors) {
        Serializable singleError;
        File singleFile;
        Serializable it;
        Intrinsics.checkNotNullParameter(savedFiles, (String)"savedFiles");
        Intrinsics.checkNotNullParameter(skippedFiles, (String)"skippedFiles");
        Intrinsics.checkNotNullParameter(errors, (String)"errors");
        boolean allExportsSucceeded = errors.isEmpty() && skippedFiles.isEmpty();
        boolean allExportsFailed = !errors.isEmpty() && savedFiles.isEmpty();
        boolean allExportsSkipped = !allExportsFailed && savedFiles.isEmpty();
        File file = (File)CollectionsKt.singleOrNull((Iterable)savedFiles);
        if (file != null) {
            File file2;
            it = file2 = file;
            boolean bl = false;
            v1 = allExportsSucceeded ? file2 : null;
        } else {
            v1 = singleFile = null;
        }
        if (singleFile != null) {
            NotificationsKt.showPlotExportedNotification(singleFile);
            return;
        }
        Throwable throwable = (Throwable)CollectionsKt.singleOrNull((Iterable)errors);
        if (throwable != null) {
            Serializable it2 = it = throwable;
            boolean bl = false;
            v3 = allExportsFailed ? it : null;
        } else {
            v3 = singleError = null;
        }
        if (singleError != null) {
            NotificationsKt.showPlotExportFailedNotification(singleError);
            return;
        }
        NotificationType notificationType = allExportsSucceeded ? NotificationType.INFORMATION : (allExportsSkipped ? NotificationType.WARNING : NotificationType.ERROR);
        String notificationTitle = allExportsSucceeded ? KotlinNotebookPlotsBundle.message("kotlin.notebook.outputs.kandy.export.all.succeeded.notification.message", new Object[0]) : (allExportsFailed ? KotlinNotebookPlotsBundle.message("kotlin.notebook.outputs.kandy.export.all.failed.notification.message", new Object[0]) : (allExportsSkipped ? KotlinNotebookPlotsBundle.message("kotlin.notebook.outputs.kandy.export.all.skipped.notification.message", new Object[0]) : KotlinNotebookPlotsBundle.message("kotlin.notebook.outputs.kandy.export.some.failed.notification.message", new Object[0])));
        Throwable throwable2 = (Throwable)CollectionsKt.firstOrNull((Iterable)errors);
        String notificationContent = throwable2 != null ? NotificationsKt.asDescription(throwable2) : null;
        Notification notification = notificationContent == null ? NotificationsKt.getKandyGroup().createNotification(notificationTitle, notificationType) : NotificationsKt.getKandyGroup().createNotification(notificationTitle, notificationContent, notificationType);
        NotificationsKt.addPlotOpenAction(notification, savedFiles);
        Notifications.Bus.notify((Notification)notification);
    }

    private static final void showPlotExportedNotification(File file) {
        NotificationGroup notificationGroup = NotificationsKt.getKandyGroup();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"getName(...)");
        Notification notification = notificationGroup.createNotification(KotlinNotebookPlotsBundle.message("kotlin.notebook.outputs.kandy.export.notification.message", objectArray), NotificationType.INFORMATION);
        NotificationsKt.addPlotOpenAction(notification, CollectionsKt.listOf((Object)file));
        Notifications.Bus.notify((Notification)notification);
    }

    private static final void addPlotOpenAction(Notification $this$addPlotOpenAction, Collection<? extends File> files) {
        File file = (File)CollectionsKt.firstOrNull((Iterable)files);
        if (file == null) {
            return;
        }
        File file2 = file;
        DumbAwareAction dumbAwareAction = files.size() > 1 ? NotificationAction.create((String)KotlinNotebookPlotsBundle.message("kotlin.notebook.outputs.kandy.export.notification.action.open.multiple", new Object[0]), arg_0 -> NotificationsKt.addPlotOpenAction$lambda$3(arg_0 -> NotificationsKt.addPlotOpenAction$lambda$2(file2, arg_0), arg_0)) : NotificationAction.create((String)KotlinNotebookPlotsBundle.message("kotlin.notebook.outputs.kandy.export.notification.action.open", new Object[0]), arg_0 -> NotificationsKt.addPlotOpenAction$lambda$5(arg_0 -> NotificationsKt.addPlotOpenAction$lambda$4(file2, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)dumbAwareAction);
        DumbAwareAction action = dumbAwareAction;
        $this$addPlotOpenAction.addAction((AnAction)action);
    }

    private static final String asDescription(Throwable $this$asDescription) {
        String string;
        if ($this$asDescription instanceof FileAlreadyExistsException) {
            Object[] objectArray = new Object[]{((FileAlreadyExistsException)$this$asDescription).getFile()};
            string = KotlinNotebookPlotsBundle.message("kotlin.notebook.outputs.kandy.export.failed.already.exists.message", objectArray);
        } else {
            string = ExceptionsKt.stackTraceToString((Throwable)$this$asDescription);
        }
        return string;
    }

    private static final Unit addPlotOpenAction$lambda$2(File $file, AnActionEvent anActionEvent) {
        RevealFileAction.openFile((File)$file);
        return Unit.INSTANCE;
    }

    private static final void addPlotOpenAction$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit addPlotOpenAction$lambda$4(File $file, AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        String string = $file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        OpenFileAction.Companion.openFile(string, project2);
        return Unit.INSTANCE;
    }

    private static final void addPlotOpenAction$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

