/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.fix.actions;

import JTrrntzip.SimpleTorrentZipOptions;
import JTrrntzip.TorrentZip;
import JTrrntzip.TrrntZipStatus;
import java.io.IOException;
import java.util.EnumSet;
import jrm.profile.data.Container;
import jrm.profile.fix.actions.ContainerAction;
import jrm.profile.scan.options.FormatOptions;
import jrm.ui.progress.Progress;
import jrm.ui.progress.ProgressHandler;
import org.apache.commons.text.StringEscapeUtils;

public class TZipContainer
extends ContainerAction {
    public TZipContainer(Container container, FormatOptions format) {
        super(container, format);
    }

    @Override
    public boolean doAction(ProgressHandler handler) {
        if (this.container.getType() == Container.Type.ZIP && this.format == FormatOptions.TZIP) {
            handler.setProgress(this.toHTML(this.toNoBR(String.format(StringEscapeUtils.escapeHtml4((String)"TorrentZipping %s [%s]"), this.toBlue(this.container.m.getFullName(this.container.file.getName())), this.toPurple(this.container.m.getDescription())))));
            try {
                EnumSet<TrrntZipStatus> status;
                if (this.container.file.exists() && !(status = new TorrentZip(new Progress.ProgressTZipCallBack(handler), new SimpleTorrentZipOptions()).Process(this.container.file)).contains(TrrntZipStatus.ValidTrrntzip)) {
                    System.out.format("%-64s => %s\n", this.container.file, status.toString());
                }
                handler.setProgress("");
                return true;
            }
            catch (IOException e) {
                System.err.println(this.container.file);
                e.printStackTrace();
                handler.setProgress("");
            }
        }
        return false;
    }
}

