/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.manager;

import java.io.File;
import java.io.IOException;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import jrm.profile.manager.Dir;
import jrm.ui.profile.manager.DirNode;
import org.apache.commons.io.FileUtils;

public class DirTreeModel
extends DefaultTreeModel
implements TreeModelListener {
    public DirTreeModel(DirNode root) {
        super(root);
        this.addTreeModelListener(this);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        DirNode node = (DirNode)e.getTreePath().getLastPathComponent();
        try {
            int index = e.getChildIndices()[0];
            DirNode child_node = (DirNode)node.getChildAt(index);
            if (child_node.getUserObject() instanceof String) {
                File newdir = new File(node.getDir().getFile(), child_node.getUserObject().toString());
                File olddir = child_node.getDir().getFile();
                if (olddir.renameTo(newdir)) {
                    child_node.setDir(new Dir(newdir));
                }
                child_node.setUserObject(child_node.getDir());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        try {
            int index = e.getChildIndices()[0];
            Object[] children = e.getChildren();
            DirNode child = (DirNode)children[index];
            FileUtils.deleteDirectory(child.getDir().getFile());
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }
}

