// This file was automatically generated by genny.
// Any changes will be lost if this file is regenerated.
// see https://github.com/cheekybits/genny

package figtree

import (
	"encoding/json"
	"fmt"
)

type BoolOption struct {
	Source  string
	Defined bool
	Value   bool
}

func NewBoolOption(dflt bool) BoolOption {
	return BoolOption{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o BoolOption) IsDefined() bool {
	return o.Defined
}

func (o *BoolOption) SetSource(source string) {
	o.Source = source
}

func (o *BoolOption) GetSource() string {
	return o.Source
}

func (o BoolOption) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *BoolOption) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *BoolOption) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(bool); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *BoolOption) SetValue(v interface{}) error {
	if val, ok := v.(bool); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *BoolOption) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *BoolOption) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o BoolOption) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   bool
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o BoolOption) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   bool
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o BoolOption) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapBoolOption map[string]BoolOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapBoolOption) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := BoolOption{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapBoolOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapBoolOption) String() string {
	return fmt.Sprintf("%v", map[string]BoolOption(o))
}

func (o MapBoolOption) Map() map[string]bool {
	tmp := map[string]bool{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapBoolOption) WriteAnswer(name string, value interface{}) error {
	tmp := BoolOption{}
	if v, ok := value.(bool); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapBoolOption) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListBoolOption []BoolOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListBoolOption) Set(value string) error {
	val := BoolOption{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListBoolOption) WriteAnswer(name string, value interface{}) error {
	tmp := BoolOption{}
	if v, ok := value.(bool); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListBoolOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListBoolOption) String() string {
	return fmt.Sprintf("%v", []BoolOption(o))
}

func (o ListBoolOption) Append(values ...bool) ListBoolOption {
	results := o
	for _, val := range values {
		results = append(results, NewBoolOption(val))
	}
	return results
}

func (o ListBoolOption) Slice() []bool {
	tmp := []bool{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListBoolOption) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type ByteOption struct {
	Source  string
	Defined bool
	Value   byte
}

func NewByteOption(dflt byte) ByteOption {
	return ByteOption{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o ByteOption) IsDefined() bool {
	return o.Defined
}

func (o *ByteOption) SetSource(source string) {
	o.Source = source
}

func (o *ByteOption) GetSource() string {
	return o.Source
}

func (o ByteOption) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *ByteOption) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *ByteOption) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(byte); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *ByteOption) SetValue(v interface{}) error {
	if val, ok := v.(byte); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *ByteOption) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *ByteOption) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o ByteOption) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   byte
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o ByteOption) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   byte
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o ByteOption) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapByteOption map[string]ByteOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapByteOption) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := ByteOption{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapByteOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapByteOption) String() string {
	return fmt.Sprintf("%v", map[string]ByteOption(o))
}

func (o MapByteOption) Map() map[string]byte {
	tmp := map[string]byte{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapByteOption) WriteAnswer(name string, value interface{}) error {
	tmp := ByteOption{}
	if v, ok := value.(byte); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapByteOption) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListByteOption []ByteOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListByteOption) Set(value string) error {
	val := ByteOption{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListByteOption) WriteAnswer(name string, value interface{}) error {
	tmp := ByteOption{}
	if v, ok := value.(byte); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListByteOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListByteOption) String() string {
	return fmt.Sprintf("%v", []ByteOption(o))
}

func (o ListByteOption) Append(values ...byte) ListByteOption {
	results := o
	for _, val := range values {
		results = append(results, NewByteOption(val))
	}
	return results
}

func (o ListByteOption) Slice() []byte {
	tmp := []byte{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListByteOption) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Complex128Option struct {
	Source  string
	Defined bool
	Value   complex128
}

func NewComplex128Option(dflt complex128) Complex128Option {
	return Complex128Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Complex128Option) IsDefined() bool {
	return o.Defined
}

func (o *Complex128Option) SetSource(source string) {
	o.Source = source
}

func (o *Complex128Option) GetSource() string {
	return o.Source
}

func (o Complex128Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Complex128Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Complex128Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(complex128); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Complex128Option) SetValue(v interface{}) error {
	if val, ok := v.(complex128); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Complex128Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Complex128Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Complex128Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   complex128
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Complex128Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   complex128
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Complex128Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapComplex128Option map[string]Complex128Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapComplex128Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Complex128Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapComplex128Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapComplex128Option) String() string {
	return fmt.Sprintf("%v", map[string]Complex128Option(o))
}

func (o MapComplex128Option) Map() map[string]complex128 {
	tmp := map[string]complex128{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapComplex128Option) WriteAnswer(name string, value interface{}) error {
	tmp := Complex128Option{}
	if v, ok := value.(complex128); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapComplex128Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListComplex128Option []Complex128Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListComplex128Option) Set(value string) error {
	val := Complex128Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListComplex128Option) WriteAnswer(name string, value interface{}) error {
	tmp := Complex128Option{}
	if v, ok := value.(complex128); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListComplex128Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListComplex128Option) String() string {
	return fmt.Sprintf("%v", []Complex128Option(o))
}

func (o ListComplex128Option) Append(values ...complex128) ListComplex128Option {
	results := o
	for _, val := range values {
		results = append(results, NewComplex128Option(val))
	}
	return results
}

func (o ListComplex128Option) Slice() []complex128 {
	tmp := []complex128{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListComplex128Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Complex64Option struct {
	Source  string
	Defined bool
	Value   complex64
}

func NewComplex64Option(dflt complex64) Complex64Option {
	return Complex64Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Complex64Option) IsDefined() bool {
	return o.Defined
}

func (o *Complex64Option) SetSource(source string) {
	o.Source = source
}

func (o *Complex64Option) GetSource() string {
	return o.Source
}

func (o Complex64Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Complex64Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Complex64Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(complex64); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Complex64Option) SetValue(v interface{}) error {
	if val, ok := v.(complex64); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Complex64Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Complex64Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Complex64Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   complex64
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Complex64Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   complex64
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Complex64Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapComplex64Option map[string]Complex64Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapComplex64Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Complex64Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapComplex64Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapComplex64Option) String() string {
	return fmt.Sprintf("%v", map[string]Complex64Option(o))
}

func (o MapComplex64Option) Map() map[string]complex64 {
	tmp := map[string]complex64{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapComplex64Option) WriteAnswer(name string, value interface{}) error {
	tmp := Complex64Option{}
	if v, ok := value.(complex64); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapComplex64Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListComplex64Option []Complex64Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListComplex64Option) Set(value string) error {
	val := Complex64Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListComplex64Option) WriteAnswer(name string, value interface{}) error {
	tmp := Complex64Option{}
	if v, ok := value.(complex64); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListComplex64Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListComplex64Option) String() string {
	return fmt.Sprintf("%v", []Complex64Option(o))
}

func (o ListComplex64Option) Append(values ...complex64) ListComplex64Option {
	results := o
	for _, val := range values {
		results = append(results, NewComplex64Option(val))
	}
	return results
}

func (o ListComplex64Option) Slice() []complex64 {
	tmp := []complex64{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListComplex64Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type ErrorOption struct {
	Source  string
	Defined bool
	Value   error
}

func NewErrorOption(dflt error) ErrorOption {
	return ErrorOption{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o ErrorOption) IsDefined() bool {
	return o.Defined
}

func (o *ErrorOption) SetSource(source string) {
	o.Source = source
}

func (o *ErrorOption) GetSource() string {
	return o.Source
}

func (o ErrorOption) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *ErrorOption) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *ErrorOption) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(error); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *ErrorOption) SetValue(v interface{}) error {
	if val, ok := v.(error); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *ErrorOption) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *ErrorOption) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o ErrorOption) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   error
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o ErrorOption) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   error
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o ErrorOption) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapErrorOption map[string]ErrorOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapErrorOption) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := ErrorOption{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapErrorOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapErrorOption) String() string {
	return fmt.Sprintf("%v", map[string]ErrorOption(o))
}

func (o MapErrorOption) Map() map[string]error {
	tmp := map[string]error{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapErrorOption) WriteAnswer(name string, value interface{}) error {
	tmp := ErrorOption{}
	if v, ok := value.(error); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapErrorOption) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListErrorOption []ErrorOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListErrorOption) Set(value string) error {
	val := ErrorOption{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListErrorOption) WriteAnswer(name string, value interface{}) error {
	tmp := ErrorOption{}
	if v, ok := value.(error); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListErrorOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListErrorOption) String() string {
	return fmt.Sprintf("%v", []ErrorOption(o))
}

func (o ListErrorOption) Append(values ...error) ListErrorOption {
	results := o
	for _, val := range values {
		results = append(results, NewErrorOption(val))
	}
	return results
}

func (o ListErrorOption) Slice() []error {
	tmp := []error{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListErrorOption) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Float32Option struct {
	Source  string
	Defined bool
	Value   float32
}

func NewFloat32Option(dflt float32) Float32Option {
	return Float32Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Float32Option) IsDefined() bool {
	return o.Defined
}

func (o *Float32Option) SetSource(source string) {
	o.Source = source
}

func (o *Float32Option) GetSource() string {
	return o.Source
}

func (o Float32Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Float32Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Float32Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(float32); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Float32Option) SetValue(v interface{}) error {
	if val, ok := v.(float32); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Float32Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Float32Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Float32Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   float32
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Float32Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   float32
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Float32Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapFloat32Option map[string]Float32Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapFloat32Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Float32Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapFloat32Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapFloat32Option) String() string {
	return fmt.Sprintf("%v", map[string]Float32Option(o))
}

func (o MapFloat32Option) Map() map[string]float32 {
	tmp := map[string]float32{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapFloat32Option) WriteAnswer(name string, value interface{}) error {
	tmp := Float32Option{}
	if v, ok := value.(float32); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapFloat32Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListFloat32Option []Float32Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListFloat32Option) Set(value string) error {
	val := Float32Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListFloat32Option) WriteAnswer(name string, value interface{}) error {
	tmp := Float32Option{}
	if v, ok := value.(float32); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListFloat32Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListFloat32Option) String() string {
	return fmt.Sprintf("%v", []Float32Option(o))
}

func (o ListFloat32Option) Append(values ...float32) ListFloat32Option {
	results := o
	for _, val := range values {
		results = append(results, NewFloat32Option(val))
	}
	return results
}

func (o ListFloat32Option) Slice() []float32 {
	tmp := []float32{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListFloat32Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Float64Option struct {
	Source  string
	Defined bool
	Value   float64
}

func NewFloat64Option(dflt float64) Float64Option {
	return Float64Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Float64Option) IsDefined() bool {
	return o.Defined
}

func (o *Float64Option) SetSource(source string) {
	o.Source = source
}

func (o *Float64Option) GetSource() string {
	return o.Source
}

func (o Float64Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Float64Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Float64Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(float64); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Float64Option) SetValue(v interface{}) error {
	if val, ok := v.(float64); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Float64Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Float64Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Float64Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   float64
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Float64Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   float64
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Float64Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapFloat64Option map[string]Float64Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapFloat64Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Float64Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapFloat64Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapFloat64Option) String() string {
	return fmt.Sprintf("%v", map[string]Float64Option(o))
}

func (o MapFloat64Option) Map() map[string]float64 {
	tmp := map[string]float64{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapFloat64Option) WriteAnswer(name string, value interface{}) error {
	tmp := Float64Option{}
	if v, ok := value.(float64); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapFloat64Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListFloat64Option []Float64Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListFloat64Option) Set(value string) error {
	val := Float64Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListFloat64Option) WriteAnswer(name string, value interface{}) error {
	tmp := Float64Option{}
	if v, ok := value.(float64); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListFloat64Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListFloat64Option) String() string {
	return fmt.Sprintf("%v", []Float64Option(o))
}

func (o ListFloat64Option) Append(values ...float64) ListFloat64Option {
	results := o
	for _, val := range values {
		results = append(results, NewFloat64Option(val))
	}
	return results
}

func (o ListFloat64Option) Slice() []float64 {
	tmp := []float64{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListFloat64Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type IntOption struct {
	Source  string
	Defined bool
	Value   int
}

func NewIntOption(dflt int) IntOption {
	return IntOption{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o IntOption) IsDefined() bool {
	return o.Defined
}

func (o *IntOption) SetSource(source string) {
	o.Source = source
}

func (o *IntOption) GetSource() string {
	return o.Source
}

func (o IntOption) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *IntOption) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *IntOption) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(int); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *IntOption) SetValue(v interface{}) error {
	if val, ok := v.(int); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *IntOption) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *IntOption) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o IntOption) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   int
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o IntOption) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   int
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o IntOption) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapIntOption map[string]IntOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapIntOption) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := IntOption{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapIntOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapIntOption) String() string {
	return fmt.Sprintf("%v", map[string]IntOption(o))
}

func (o MapIntOption) Map() map[string]int {
	tmp := map[string]int{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapIntOption) WriteAnswer(name string, value interface{}) error {
	tmp := IntOption{}
	if v, ok := value.(int); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapIntOption) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListIntOption []IntOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListIntOption) Set(value string) error {
	val := IntOption{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListIntOption) WriteAnswer(name string, value interface{}) error {
	tmp := IntOption{}
	if v, ok := value.(int); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListIntOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListIntOption) String() string {
	return fmt.Sprintf("%v", []IntOption(o))
}

func (o ListIntOption) Append(values ...int) ListIntOption {
	results := o
	for _, val := range values {
		results = append(results, NewIntOption(val))
	}
	return results
}

func (o ListIntOption) Slice() []int {
	tmp := []int{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListIntOption) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Int16Option struct {
	Source  string
	Defined bool
	Value   int16
}

func NewInt16Option(dflt int16) Int16Option {
	return Int16Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Int16Option) IsDefined() bool {
	return o.Defined
}

func (o *Int16Option) SetSource(source string) {
	o.Source = source
}

func (o *Int16Option) GetSource() string {
	return o.Source
}

func (o Int16Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Int16Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Int16Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(int16); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Int16Option) SetValue(v interface{}) error {
	if val, ok := v.(int16); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Int16Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Int16Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Int16Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   int16
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Int16Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   int16
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Int16Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapInt16Option map[string]Int16Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapInt16Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Int16Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapInt16Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapInt16Option) String() string {
	return fmt.Sprintf("%v", map[string]Int16Option(o))
}

func (o MapInt16Option) Map() map[string]int16 {
	tmp := map[string]int16{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapInt16Option) WriteAnswer(name string, value interface{}) error {
	tmp := Int16Option{}
	if v, ok := value.(int16); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapInt16Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListInt16Option []Int16Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListInt16Option) Set(value string) error {
	val := Int16Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListInt16Option) WriteAnswer(name string, value interface{}) error {
	tmp := Int16Option{}
	if v, ok := value.(int16); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListInt16Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListInt16Option) String() string {
	return fmt.Sprintf("%v", []Int16Option(o))
}

func (o ListInt16Option) Append(values ...int16) ListInt16Option {
	results := o
	for _, val := range values {
		results = append(results, NewInt16Option(val))
	}
	return results
}

func (o ListInt16Option) Slice() []int16 {
	tmp := []int16{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListInt16Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Int32Option struct {
	Source  string
	Defined bool
	Value   int32
}

func NewInt32Option(dflt int32) Int32Option {
	return Int32Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Int32Option) IsDefined() bool {
	return o.Defined
}

func (o *Int32Option) SetSource(source string) {
	o.Source = source
}

func (o *Int32Option) GetSource() string {
	return o.Source
}

func (o Int32Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Int32Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Int32Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(int32); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Int32Option) SetValue(v interface{}) error {
	if val, ok := v.(int32); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Int32Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Int32Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Int32Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   int32
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Int32Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   int32
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Int32Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapInt32Option map[string]Int32Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapInt32Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Int32Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapInt32Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapInt32Option) String() string {
	return fmt.Sprintf("%v", map[string]Int32Option(o))
}

func (o MapInt32Option) Map() map[string]int32 {
	tmp := map[string]int32{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapInt32Option) WriteAnswer(name string, value interface{}) error {
	tmp := Int32Option{}
	if v, ok := value.(int32); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapInt32Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListInt32Option []Int32Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListInt32Option) Set(value string) error {
	val := Int32Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListInt32Option) WriteAnswer(name string, value interface{}) error {
	tmp := Int32Option{}
	if v, ok := value.(int32); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListInt32Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListInt32Option) String() string {
	return fmt.Sprintf("%v", []Int32Option(o))
}

func (o ListInt32Option) Append(values ...int32) ListInt32Option {
	results := o
	for _, val := range values {
		results = append(results, NewInt32Option(val))
	}
	return results
}

func (o ListInt32Option) Slice() []int32 {
	tmp := []int32{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListInt32Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Int64Option struct {
	Source  string
	Defined bool
	Value   int64
}

func NewInt64Option(dflt int64) Int64Option {
	return Int64Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Int64Option) IsDefined() bool {
	return o.Defined
}

func (o *Int64Option) SetSource(source string) {
	o.Source = source
}

func (o *Int64Option) GetSource() string {
	return o.Source
}

func (o Int64Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Int64Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Int64Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(int64); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Int64Option) SetValue(v interface{}) error {
	if val, ok := v.(int64); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Int64Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Int64Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Int64Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   int64
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Int64Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   int64
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Int64Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapInt64Option map[string]Int64Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapInt64Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Int64Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapInt64Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapInt64Option) String() string {
	return fmt.Sprintf("%v", map[string]Int64Option(o))
}

func (o MapInt64Option) Map() map[string]int64 {
	tmp := map[string]int64{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapInt64Option) WriteAnswer(name string, value interface{}) error {
	tmp := Int64Option{}
	if v, ok := value.(int64); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapInt64Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListInt64Option []Int64Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListInt64Option) Set(value string) error {
	val := Int64Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListInt64Option) WriteAnswer(name string, value interface{}) error {
	tmp := Int64Option{}
	if v, ok := value.(int64); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListInt64Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListInt64Option) String() string {
	return fmt.Sprintf("%v", []Int64Option(o))
}

func (o ListInt64Option) Append(values ...int64) ListInt64Option {
	results := o
	for _, val := range values {
		results = append(results, NewInt64Option(val))
	}
	return results
}

func (o ListInt64Option) Slice() []int64 {
	tmp := []int64{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListInt64Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Int8Option struct {
	Source  string
	Defined bool
	Value   int8
}

func NewInt8Option(dflt int8) Int8Option {
	return Int8Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Int8Option) IsDefined() bool {
	return o.Defined
}

func (o *Int8Option) SetSource(source string) {
	o.Source = source
}

func (o *Int8Option) GetSource() string {
	return o.Source
}

func (o Int8Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Int8Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Int8Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(int8); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Int8Option) SetValue(v interface{}) error {
	if val, ok := v.(int8); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Int8Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Int8Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Int8Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   int8
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Int8Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   int8
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Int8Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapInt8Option map[string]Int8Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapInt8Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Int8Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapInt8Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapInt8Option) String() string {
	return fmt.Sprintf("%v", map[string]Int8Option(o))
}

func (o MapInt8Option) Map() map[string]int8 {
	tmp := map[string]int8{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapInt8Option) WriteAnswer(name string, value interface{}) error {
	tmp := Int8Option{}
	if v, ok := value.(int8); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapInt8Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListInt8Option []Int8Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListInt8Option) Set(value string) error {
	val := Int8Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListInt8Option) WriteAnswer(name string, value interface{}) error {
	tmp := Int8Option{}
	if v, ok := value.(int8); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListInt8Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListInt8Option) String() string {
	return fmt.Sprintf("%v", []Int8Option(o))
}

func (o ListInt8Option) Append(values ...int8) ListInt8Option {
	results := o
	for _, val := range values {
		results = append(results, NewInt8Option(val))
	}
	return results
}

func (o ListInt8Option) Slice() []int8 {
	tmp := []int8{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListInt8Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type RuneOption struct {
	Source  string
	Defined bool
	Value   rune
}

func NewRuneOption(dflt rune) RuneOption {
	return RuneOption{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o RuneOption) IsDefined() bool {
	return o.Defined
}

func (o *RuneOption) SetSource(source string) {
	o.Source = source
}

func (o *RuneOption) GetSource() string {
	return o.Source
}

func (o RuneOption) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *RuneOption) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *RuneOption) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(rune); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *RuneOption) SetValue(v interface{}) error {
	if val, ok := v.(rune); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *RuneOption) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *RuneOption) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o RuneOption) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   rune
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o RuneOption) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   rune
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o RuneOption) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapRuneOption map[string]RuneOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapRuneOption) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := RuneOption{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapRuneOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapRuneOption) String() string {
	return fmt.Sprintf("%v", map[string]RuneOption(o))
}

func (o MapRuneOption) Map() map[string]rune {
	tmp := map[string]rune{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapRuneOption) WriteAnswer(name string, value interface{}) error {
	tmp := RuneOption{}
	if v, ok := value.(rune); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapRuneOption) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListRuneOption []RuneOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListRuneOption) Set(value string) error {
	val := RuneOption{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListRuneOption) WriteAnswer(name string, value interface{}) error {
	tmp := RuneOption{}
	if v, ok := value.(rune); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListRuneOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListRuneOption) String() string {
	return fmt.Sprintf("%v", []RuneOption(o))
}

func (o ListRuneOption) Append(values ...rune) ListRuneOption {
	results := o
	for _, val := range values {
		results = append(results, NewRuneOption(val))
	}
	return results
}

func (o ListRuneOption) Slice() []rune {
	tmp := []rune{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListRuneOption) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type StringOption struct {
	Source  string
	Defined bool
	Value   string
}

func NewStringOption(dflt string) StringOption {
	return StringOption{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o StringOption) IsDefined() bool {
	return o.Defined
}

func (o *StringOption) SetSource(source string) {
	o.Source = source
}

func (o *StringOption) GetSource() string {
	return o.Source
}

func (o StringOption) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *StringOption) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *StringOption) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(string); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *StringOption) SetValue(v interface{}) error {
	if val, ok := v.(string); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *StringOption) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *StringOption) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o StringOption) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   string
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o StringOption) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   string
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o StringOption) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapStringOption map[string]StringOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapStringOption) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := StringOption{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapStringOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapStringOption) String() string {
	return fmt.Sprintf("%v", map[string]StringOption(o))
}

func (o MapStringOption) Map() map[string]string {
	tmp := map[string]string{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapStringOption) WriteAnswer(name string, value interface{}) error {
	tmp := StringOption{}
	if v, ok := value.(string); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapStringOption) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListStringOption []StringOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListStringOption) Set(value string) error {
	val := StringOption{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListStringOption) WriteAnswer(name string, value interface{}) error {
	tmp := StringOption{}
	if v, ok := value.(string); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListStringOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListStringOption) String() string {
	return fmt.Sprintf("%v", []StringOption(o))
}

func (o ListStringOption) Append(values ...string) ListStringOption {
	results := o
	for _, val := range values {
		results = append(results, NewStringOption(val))
	}
	return results
}

func (o ListStringOption) Slice() []string {
	tmp := []string{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListStringOption) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type UintOption struct {
	Source  string
	Defined bool
	Value   uint
}

func NewUintOption(dflt uint) UintOption {
	return UintOption{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o UintOption) IsDefined() bool {
	return o.Defined
}

func (o *UintOption) SetSource(source string) {
	o.Source = source
}

func (o *UintOption) GetSource() string {
	return o.Source
}

func (o UintOption) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *UintOption) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *UintOption) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(uint); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *UintOption) SetValue(v interface{}) error {
	if val, ok := v.(uint); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *UintOption) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *UintOption) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o UintOption) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   uint
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o UintOption) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   uint
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o UintOption) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapUintOption map[string]UintOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapUintOption) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := UintOption{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapUintOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapUintOption) String() string {
	return fmt.Sprintf("%v", map[string]UintOption(o))
}

func (o MapUintOption) Map() map[string]uint {
	tmp := map[string]uint{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapUintOption) WriteAnswer(name string, value interface{}) error {
	tmp := UintOption{}
	if v, ok := value.(uint); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapUintOption) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListUintOption []UintOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListUintOption) Set(value string) error {
	val := UintOption{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListUintOption) WriteAnswer(name string, value interface{}) error {
	tmp := UintOption{}
	if v, ok := value.(uint); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListUintOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListUintOption) String() string {
	return fmt.Sprintf("%v", []UintOption(o))
}

func (o ListUintOption) Append(values ...uint) ListUintOption {
	results := o
	for _, val := range values {
		results = append(results, NewUintOption(val))
	}
	return results
}

func (o ListUintOption) Slice() []uint {
	tmp := []uint{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListUintOption) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Uint16Option struct {
	Source  string
	Defined bool
	Value   uint16
}

func NewUint16Option(dflt uint16) Uint16Option {
	return Uint16Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Uint16Option) IsDefined() bool {
	return o.Defined
}

func (o *Uint16Option) SetSource(source string) {
	o.Source = source
}

func (o *Uint16Option) GetSource() string {
	return o.Source
}

func (o Uint16Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Uint16Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Uint16Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(uint16); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Uint16Option) SetValue(v interface{}) error {
	if val, ok := v.(uint16); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Uint16Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Uint16Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Uint16Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   uint16
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Uint16Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   uint16
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Uint16Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapUint16Option map[string]Uint16Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapUint16Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Uint16Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapUint16Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapUint16Option) String() string {
	return fmt.Sprintf("%v", map[string]Uint16Option(o))
}

func (o MapUint16Option) Map() map[string]uint16 {
	tmp := map[string]uint16{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapUint16Option) WriteAnswer(name string, value interface{}) error {
	tmp := Uint16Option{}
	if v, ok := value.(uint16); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapUint16Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListUint16Option []Uint16Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListUint16Option) Set(value string) error {
	val := Uint16Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListUint16Option) WriteAnswer(name string, value interface{}) error {
	tmp := Uint16Option{}
	if v, ok := value.(uint16); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListUint16Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListUint16Option) String() string {
	return fmt.Sprintf("%v", []Uint16Option(o))
}

func (o ListUint16Option) Append(values ...uint16) ListUint16Option {
	results := o
	for _, val := range values {
		results = append(results, NewUint16Option(val))
	}
	return results
}

func (o ListUint16Option) Slice() []uint16 {
	tmp := []uint16{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListUint16Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Uint32Option struct {
	Source  string
	Defined bool
	Value   uint32
}

func NewUint32Option(dflt uint32) Uint32Option {
	return Uint32Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Uint32Option) IsDefined() bool {
	return o.Defined
}

func (o *Uint32Option) SetSource(source string) {
	o.Source = source
}

func (o *Uint32Option) GetSource() string {
	return o.Source
}

func (o Uint32Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Uint32Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Uint32Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(uint32); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Uint32Option) SetValue(v interface{}) error {
	if val, ok := v.(uint32); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Uint32Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Uint32Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Uint32Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   uint32
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Uint32Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   uint32
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Uint32Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapUint32Option map[string]Uint32Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapUint32Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Uint32Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapUint32Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapUint32Option) String() string {
	return fmt.Sprintf("%v", map[string]Uint32Option(o))
}

func (o MapUint32Option) Map() map[string]uint32 {
	tmp := map[string]uint32{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapUint32Option) WriteAnswer(name string, value interface{}) error {
	tmp := Uint32Option{}
	if v, ok := value.(uint32); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapUint32Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListUint32Option []Uint32Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListUint32Option) Set(value string) error {
	val := Uint32Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListUint32Option) WriteAnswer(name string, value interface{}) error {
	tmp := Uint32Option{}
	if v, ok := value.(uint32); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListUint32Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListUint32Option) String() string {
	return fmt.Sprintf("%v", []Uint32Option(o))
}

func (o ListUint32Option) Append(values ...uint32) ListUint32Option {
	results := o
	for _, val := range values {
		results = append(results, NewUint32Option(val))
	}
	return results
}

func (o ListUint32Option) Slice() []uint32 {
	tmp := []uint32{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListUint32Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Uint64Option struct {
	Source  string
	Defined bool
	Value   uint64
}

func NewUint64Option(dflt uint64) Uint64Option {
	return Uint64Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Uint64Option) IsDefined() bool {
	return o.Defined
}

func (o *Uint64Option) SetSource(source string) {
	o.Source = source
}

func (o *Uint64Option) GetSource() string {
	return o.Source
}

func (o Uint64Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Uint64Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Uint64Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(uint64); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Uint64Option) SetValue(v interface{}) error {
	if val, ok := v.(uint64); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Uint64Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Uint64Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Uint64Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   uint64
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Uint64Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   uint64
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Uint64Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapUint64Option map[string]Uint64Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapUint64Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Uint64Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapUint64Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapUint64Option) String() string {
	return fmt.Sprintf("%v", map[string]Uint64Option(o))
}

func (o MapUint64Option) Map() map[string]uint64 {
	tmp := map[string]uint64{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapUint64Option) WriteAnswer(name string, value interface{}) error {
	tmp := Uint64Option{}
	if v, ok := value.(uint64); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapUint64Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListUint64Option []Uint64Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListUint64Option) Set(value string) error {
	val := Uint64Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListUint64Option) WriteAnswer(name string, value interface{}) error {
	tmp := Uint64Option{}
	if v, ok := value.(uint64); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListUint64Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListUint64Option) String() string {
	return fmt.Sprintf("%v", []Uint64Option(o))
}

func (o ListUint64Option) Append(values ...uint64) ListUint64Option {
	results := o
	for _, val := range values {
		results = append(results, NewUint64Option(val))
	}
	return results
}

func (o ListUint64Option) Slice() []uint64 {
	tmp := []uint64{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListUint64Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type Uint8Option struct {
	Source  string
	Defined bool
	Value   uint8
}

func NewUint8Option(dflt uint8) Uint8Option {
	return Uint8Option{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o Uint8Option) IsDefined() bool {
	return o.Defined
}

func (o *Uint8Option) SetSource(source string) {
	o.Source = source
}

func (o *Uint8Option) GetSource() string {
	return o.Source
}

func (o Uint8Option) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *Uint8Option) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *Uint8Option) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(uint8); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *Uint8Option) SetValue(v interface{}) error {
	if val, ok := v.(uint8); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *Uint8Option) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *Uint8Option) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o Uint8Option) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   uint8
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o Uint8Option) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   uint8
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o Uint8Option) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapUint8Option map[string]Uint8Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapUint8Option) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := Uint8Option{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapUint8Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapUint8Option) String() string {
	return fmt.Sprintf("%v", map[string]Uint8Option(o))
}

func (o MapUint8Option) Map() map[string]uint8 {
	tmp := map[string]uint8{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapUint8Option) WriteAnswer(name string, value interface{}) error {
	tmp := Uint8Option{}
	if v, ok := value.(uint8); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapUint8Option) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListUint8Option []Uint8Option

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListUint8Option) Set(value string) error {
	val := Uint8Option{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListUint8Option) WriteAnswer(name string, value interface{}) error {
	tmp := Uint8Option{}
	if v, ok := value.(uint8); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListUint8Option) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListUint8Option) String() string {
	return fmt.Sprintf("%v", []Uint8Option(o))
}

func (o ListUint8Option) Append(values ...uint8) ListUint8Option {
	results := o
	for _, val := range values {
		results = append(results, NewUint8Option(val))
	}
	return results
}

func (o ListUint8Option) Slice() []uint8 {
	tmp := []uint8{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListUint8Option) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}

type UintptrOption struct {
	Source  string
	Defined bool
	Value   uintptr
}

func NewUintptrOption(dflt uintptr) UintptrOption {
	return UintptrOption{
		Source:  "default",
		Defined: true,
		Value:   dflt,
	}
}

func (o UintptrOption) IsDefined() bool {
	return o.Defined
}

func (o *UintptrOption) SetSource(source string) {
	o.Source = source
}

func (o *UintptrOption) GetSource() string {
	return o.Source
}

func (o UintptrOption) GetValue() interface{} {
	return o.Value
}

// This is useful with kingpin option parser
func (o *UintptrOption) Set(s string) error {
	err := convertString(s, &o.Value)
	if err != nil {
		return err
	}
	o.Source = "override"
	o.Defined = true
	return nil
}

// This is useful with survey prompting library
func (o *UintptrOption) WriteAnswer(name string, value interface{}) error {
	if v, ok := value.(uintptr); ok {
		o.Value = v
		o.Defined = true
		o.Source = "prompt"
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, o.Value, value)
}

func (o *UintptrOption) SetValue(v interface{}) error {
	if val, ok := v.(uintptr); ok {
		o.Value = val
		o.Defined = true
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", v, o.Value, v)
}

func (o *UintptrOption) UnmarshalYAML(unmarshal func(interface{}) error) error {
	if err := unmarshal(&o.Value); err != nil {
		return err
	}
	o.Source = "yaml"
	o.Defined = true
	return nil
}

func (o *UintptrOption) UnmarshalJSON(b []byte) error {
	if err := json.Unmarshal(b, &o.Value); err != nil {
		return err
	}
	o.Source = "json"
	o.Defined = true
	return nil
}

func (o UintptrOption) MarshalYAML() (interface{}, error) {
	if StringifyValue {
		return o.Value, nil
	}
	// need a copy of this struct without the MarshalYAML interface attached
	return struct {
		Value   uintptr
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	}, nil
}

func (o UintptrOption) MarshalJSON() ([]byte, error) {
	if StringifyValue {
		return json.Marshal(o.Value)
	}
	// need a copy of this struct without the MarshalJSON interface attached
	return json.Marshal(struct {
		Value   uintptr
		Source  string
		Defined bool
	}{
		Value:   o.Value,
		Source:  o.Source,
		Defined: o.Defined,
	})
}

// String is required for kingpin to generate usage with this datatype
func (o UintptrOption) String() string {
	if StringifyValue {
		return fmt.Sprintf("%v", o.Value)
	}
	return fmt.Sprintf("{Source:%s Defined:%t Value:%v}", o.Source, o.Defined, o.Value)
}

type MapUintptrOption map[string]UintptrOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *MapUintptrOption) Set(value string) error {
	parts := stringMapRegex.Split(value, 2)
	if len(parts) != 2 {
		return fmt.Errorf("expected KEY=VALUE got '%s'", value)
	}
	val := UintptrOption{}
	val.Set(parts[1])
	(*o)[parts[0]] = val
	return nil
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o MapUintptrOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o MapUintptrOption) String() string {
	return fmt.Sprintf("%v", map[string]UintptrOption(o))
}

func (o MapUintptrOption) Map() map[string]uintptr {
	tmp := map[string]uintptr{}
	for k, v := range o {
		tmp[k] = v.Value
	}
	return tmp
}

// This is useful with survey prompting library
func (o *MapUintptrOption) WriteAnswer(name string, value interface{}) error {
	tmp := UintptrOption{}
	if v, ok := value.(uintptr); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		(*o)[name] = tmp
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

func (o MapUintptrOption) IsDefined() bool {
	// true if the map has any keys
	if len(o) > 0 {
		return true
	}
	return false
}

type ListUintptrOption []UintptrOption

// Set is required for kingpin interfaces to allow command line params
// to be set to our map datatype
func (o *ListUintptrOption) Set(value string) error {
	val := UintptrOption{}
	val.Set(value)
	*o = append(*o, val)
	return nil
}

// This is useful with survey prompting library
func (o *ListUintptrOption) WriteAnswer(name string, value interface{}) error {
	tmp := UintptrOption{}
	if v, ok := value.(uintptr); ok {
		tmp.Value = v
		tmp.Defined = true
		tmp.Source = "prompt"
		*o = append(*o, tmp)
		return nil
	}
	return fmt.Errorf("Got %T expected %T type: %v", value, tmp.Value, value)
}

// IsCumulative is required for kingpin interfaces to allow multiple values
// to be set on the data structure.
func (o ListUintptrOption) IsCumulative() bool {
	return true
}

// String is required for kingpin to generate usage with this datatype
func (o ListUintptrOption) String() string {
	return fmt.Sprintf("%v", []UintptrOption(o))
}

func (o ListUintptrOption) Append(values ...uintptr) ListUintptrOption {
	results := o
	for _, val := range values {
		results = append(results, NewUintptrOption(val))
	}
	return results
}

func (o ListUintptrOption) Slice() []uintptr {
	tmp := []uintptr{}
	for _, elem := range o {
		tmp = append(tmp, elem.Value)
	}
	return tmp
}

func (o ListUintptrOption) IsDefined() bool {
	// true if the list is not empty
	if len(o) > 0 {
		return true
	}
	return false
}
