package cassandra

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBackupPlans invokes the cassandra.DescribeBackupPlans API synchronously
func (client *Client) DescribeBackupPlans(request *DescribeBackupPlansRequest) (response *DescribeBackupPlansResponse, err error) {
	response = CreateDescribeBackupPlansResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBackupPlansWithChan invokes the cassandra.DescribeBackupPlans API asynchronously
func (client *Client) DescribeBackupPlansWithChan(request *DescribeBackupPlansRequest) (<-chan *DescribeBackupPlansResponse, <-chan error) {
	responseChan := make(chan *DescribeBackupPlansResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBackupPlans(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBackupPlansWithCallback invokes the cassandra.DescribeBackupPlans API asynchronously
func (client *Client) DescribeBackupPlansWithCallback(request *DescribeBackupPlansRequest, callback func(response *DescribeBackupPlansResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBackupPlansResponse
		var err error
		defer close(result)
		response, err = client.DescribeBackupPlans(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBackupPlansRequest is the request struct for api DescribeBackupPlans
type DescribeBackupPlansRequest struct {
	*requests.RpcRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// DescribeBackupPlansResponse is the response struct for api DescribeBackupPlans
type DescribeBackupPlansResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	BackupPlans BackupPlans `json:"BackupPlans" xml:"BackupPlans"`
}

// CreateDescribeBackupPlansRequest creates a request to invoke DescribeBackupPlans API
func CreateDescribeBackupPlansRequest() (request *DescribeBackupPlansRequest) {
	request = &DescribeBackupPlansRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cassandra", "2019-01-01", "DescribeBackupPlans", "Cassandra", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBackupPlansResponse creates a response to parse from DescribeBackupPlans response
func CreateDescribeBackupPlansResponse() (response *DescribeBackupPlansResponse) {
	response = &DescribeBackupPlansResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
