package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPipelineStepLog invokes the devops_rdc.GetPipelineStepLog API synchronously
func (client *Client) GetPipelineStepLog(request *GetPipelineStepLogRequest) (response *GetPipelineStepLogResponse, err error) {
	response = CreateGetPipelineStepLogResponse()
	err = client.DoAction(request, response)
	return
}

// GetPipelineStepLogWithChan invokes the devops_rdc.GetPipelineStepLog API asynchronously
func (client *Client) GetPipelineStepLogWithChan(request *GetPipelineStepLogRequest) (<-chan *GetPipelineStepLogResponse, <-chan error) {
	responseChan := make(chan *GetPipelineStepLogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPipelineStepLog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPipelineStepLogWithCallback invokes the devops_rdc.GetPipelineStepLog API asynchronously
func (client *Client) GetPipelineStepLogWithCallback(request *GetPipelineStepLogRequest, callback func(response *GetPipelineStepLogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPipelineStepLogResponse
		var err error
		defer close(result)
		response, err = client.GetPipelineStepLog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPipelineStepLogRequest is the request struct for api GetPipelineStepLog
type GetPipelineStepLogRequest struct {
	*requests.RpcRequest
	Offset     requests.Integer `position:"Body" name:"Offset"`
	UserPk     string           `position:"Body" name:"UserPk"`
	OrgId      string           `position:"Body" name:"OrgId"`
	PipelineId requests.Integer `position:"Body" name:"PipelineId"`
	JobId      requests.Integer `position:"Body" name:"JobId"`
	StepIndex  string           `position:"Body" name:"StepIndex"`
	Limit      requests.Integer `position:"Body" name:"Limit"`
}

// GetPipelineStepLogResponse is the response struct for api GetPipelineStepLog
type GetPipelineStepLogResponse struct {
	*responses.BaseResponse
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Object       Object `json:"Object" xml:"Object"`
}

// CreateGetPipelineStepLogRequest creates a request to invoke GetPipelineStepLog API
func CreateGetPipelineStepLogRequest() (request *GetPipelineStepLogRequest) {
	request = &GetPipelineStepLogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "GetPipelineStepLog", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPipelineStepLogResponse creates a response to parse from GetPipelineStepLog response
func CreateGetPipelineStepLogResponse() (response *GetPipelineStepLogResponse) {
	response = &GetPipelineStepLogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
