package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetBackendServers invokes the ens.SetBackendServers API synchronously
func (client *Client) SetBackendServers(request *SetBackendServersRequest) (response *SetBackendServersResponse, err error) {
	response = CreateSetBackendServersResponse()
	err = client.DoAction(request, response)
	return
}

// SetBackendServersWithChan invokes the ens.SetBackendServers API asynchronously
func (client *Client) SetBackendServersWithChan(request *SetBackendServersRequest) (<-chan *SetBackendServersResponse, <-chan error) {
	responseChan := make(chan *SetBackendServersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetBackendServers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetBackendServersWithCallback invokes the ens.SetBackendServers API asynchronously
func (client *Client) SetBackendServersWithCallback(request *SetBackendServersRequest, callback func(response *SetBackendServersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetBackendServersResponse
		var err error
		defer close(result)
		response, err = client.SetBackendServers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetBackendServersRequest is the request struct for api SetBackendServers
type SetBackendServersRequest struct {
	*requests.RpcRequest
	BackendServers *[]SetBackendServersBackendServers `position:"Query" name:"BackendServers"  type:"Json"`
	LoadBalancerId string                             `position:"Query" name:"LoadBalancerId"`
}

// SetBackendServersBackendServers is a repeated param struct in SetBackendServersRequest
type SetBackendServersBackendServers struct {
	Weight   string `name:"Weight"`
	Type     string `name:"Type"`
	ServerId string `name:"ServerId"`
}

// SetBackendServersResponse is the response struct for api SetBackendServers
type SetBackendServersResponse struct {
	*responses.BaseResponse
	RequestId      string                            `json:"RequestId" xml:"RequestId"`
	BackendServers BackendServersInSetBackendServers `json:"BackendServers" xml:"BackendServers"`
}

// CreateSetBackendServersRequest creates a request to invoke SetBackendServers API
func CreateSetBackendServersRequest() (request *SetBackendServersRequest) {
	request = &SetBackendServersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "SetBackendServers", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetBackendServersResponse creates a response to parse from SetBackendServers response
func CreateSetBackendServersResponse() (response *SetBackendServersResponse) {
	response = &SetBackendServersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
