package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceType invokes the hbase.ModifyInstanceType API synchronously
func (client *Client) ModifyInstanceType(request *ModifyInstanceTypeRequest) (response *ModifyInstanceTypeResponse, err error) {
	response = CreateModifyInstanceTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceTypeWithChan invokes the hbase.ModifyInstanceType API asynchronously
func (client *Client) ModifyInstanceTypeWithChan(request *ModifyInstanceTypeRequest) (<-chan *ModifyInstanceTypeResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceTypeWithCallback invokes the hbase.ModifyInstanceType API asynchronously
func (client *Client) ModifyInstanceTypeWithCallback(request *ModifyInstanceTypeRequest, callback func(response *ModifyInstanceTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceTypeResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceTypeRequest is the request struct for api ModifyInstanceType
type ModifyInstanceTypeRequest struct {
	*requests.RpcRequest
	ClusterId          string `position:"Query" name:"ClusterId"`
	MasterInstanceType string `position:"Query" name:"MasterInstanceType"`
	CoreInstanceType   string `position:"Query" name:"CoreInstanceType"`
}

// ModifyInstanceTypeResponse is the response struct for api ModifyInstanceType
type ModifyInstanceTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateModifyInstanceTypeRequest creates a request to invoke ModifyInstanceType API
func CreateModifyInstanceTypeRequest() (request *ModifyInstanceTypeRequest) {
	request = &ModifyInstanceTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "ModifyInstanceType", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceTypeResponse creates a response to parse from ModifyInstanceType response
func CreateModifyInstanceTypeResponse() (response *ModifyInstanceTypeResponse) {
	response = &ModifyInstanceTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
