package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectHipKeypointXRay invokes the imageprocess.DetectHipKeypointXRay API synchronously
func (client *Client) DetectHipKeypointXRay(request *DetectHipKeypointXRayRequest) (response *DetectHipKeypointXRayResponse, err error) {
	response = CreateDetectHipKeypointXRayResponse()
	err = client.DoAction(request, response)
	return
}

// DetectHipKeypointXRayWithChan invokes the imageprocess.DetectHipKeypointXRay API asynchronously
func (client *Client) DetectHipKeypointXRayWithChan(request *DetectHipKeypointXRayRequest) (<-chan *DetectHipKeypointXRayResponse, <-chan error) {
	responseChan := make(chan *DetectHipKeypointXRayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectHipKeypointXRay(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectHipKeypointXRayWithCallback invokes the imageprocess.DetectHipKeypointXRay API asynchronously
func (client *Client) DetectHipKeypointXRayWithCallback(request *DetectHipKeypointXRayRequest, callback func(response *DetectHipKeypointXRayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectHipKeypointXRayResponse
		var err error
		defer close(result)
		response, err = client.DetectHipKeypointXRay(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectHipKeypointXRayRequest is the request struct for api DetectHipKeypointXRay
type DetectHipKeypointXRayRequest struct {
	*requests.RpcRequest
	OrgName    string `position:"Body" name:"OrgName"`
	TracerId   string `position:"Body" name:"TracerId"`
	DataFormat string `position:"Body" name:"DataFormat"`
	OrgId      string `position:"Body" name:"OrgId"`
	ImageUrl   string `position:"Body" name:"ImageUrl"`
}

// DetectHipKeypointXRayResponse is the response struct for api DetectHipKeypointXRay
type DetectHipKeypointXRayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetectHipKeypointXRayRequest creates a request to invoke DetectHipKeypointXRay API
func CreateDetectHipKeypointXRayRequest() (request *DetectHipKeypointXRayRequest) {
	request = &DetectHipKeypointXRayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "DetectHipKeypointXRay", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectHipKeypointXRayResponse creates a response to parse from DetectHipKeypointXRay response
func CreateDetectHipKeypointXRayResponse() (response *DetectHipKeypointXRayResponse) {
	response = &DetectHipKeypointXRayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
