package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPredictDoc invokes the nlp_automl.GetPredictDoc API synchronously
func (client *Client) GetPredictDoc(request *GetPredictDocRequest) (response *GetPredictDocResponse, err error) {
	response = CreateGetPredictDocResponse()
	err = client.DoAction(request, response)
	return
}

// GetPredictDocWithChan invokes the nlp_automl.GetPredictDoc API asynchronously
func (client *Client) GetPredictDocWithChan(request *GetPredictDocRequest) (<-chan *GetPredictDocResponse, <-chan error) {
	responseChan := make(chan *GetPredictDocResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPredictDoc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPredictDocWithCallback invokes the nlp_automl.GetPredictDoc API asynchronously
func (client *Client) GetPredictDocWithCallback(request *GetPredictDocRequest, callback func(response *GetPredictDocResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPredictDocResponse
		var err error
		defer close(result)
		response, err = client.GetPredictDoc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPredictDocRequest is the request struct for api GetPredictDoc
type GetPredictDocRequest struct {
	*requests.RpcRequest
	Product string           `position:"Query" name:"Product"`
	DocId   requests.Integer `position:"Query" name:"DocId"`
}

// GetPredictDocResponse is the response struct for api GetPredictDoc
type GetPredictDocResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ResultContent string `json:"ResultContent" xml:"ResultContent"`
	Status        int    `json:"Status" xml:"Status"`
	XLIFFInfo     string `json:"XLIFFInfo" xml:"XLIFFInfo"`
}

// CreateGetPredictDocRequest creates a request to invoke GetPredictDoc API
func CreateGetPredictDocRequest() (request *GetPredictDocRequest) {
	request = &GetPredictDocRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-07-01", "GetPredictDoc", "nlpautoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPredictDocResponse creates a response to parse from GetPredictDoc response
func CreateGetPredictDocResponse() (response *GetPredictDocResponse) {
	response = &GetPredictDocResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
