package reid

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListActionData invokes the reid.ListActionData API synchronously
// api document: https://help.aliyun.com/api/reid/listactiondata.html
func (client *Client) ListActionData(request *ListActionDataRequest) (response *ListActionDataResponse, err error) {
	response = CreateListActionDataResponse()
	err = client.DoAction(request, response)
	return
}

// ListActionDataWithChan invokes the reid.ListActionData API asynchronously
// api document: https://help.aliyun.com/api/reid/listactiondata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListActionDataWithChan(request *ListActionDataRequest) (<-chan *ListActionDataResponse, <-chan error) {
	responseChan := make(chan *ListActionDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListActionData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListActionDataWithCallback invokes the reid.ListActionData API asynchronously
// api document: https://help.aliyun.com/api/reid/listactiondata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListActionDataWithCallback(request *ListActionDataRequest, callback func(response *ListActionDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListActionDataResponse
		var err error
		defer close(result)
		response, err = client.ListActionData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListActionDataRequest is the request struct for api ListActionData
type ListActionDataRequest struct {
	*requests.RpcRequest
	EndTime           requests.Integer `position:"Body" name:"EndTime"`
	StartTime         requests.Integer `position:"Body" name:"StartTime"`
	StoreId           requests.Integer `position:"Body" name:"StoreId"`
	PageNumber        requests.Integer `position:"Body" name:"PageNumber"`
	PageSize          requests.Integer `position:"Body" name:"PageSize"`
	FilterInvalidData requests.Boolean `position:"Body" name:"FilterInvalidData"`
}

// ListActionDataResponse is the response struct for api ListActionData
type ListActionDataResponse struct {
	*responses.BaseResponse
	RequestId    string                  `json:"RequestId" xml:"RequestId"`
	Success      bool                    `json:"Success" xml:"Success"`
	CursorTime   int64                   `json:"CursorTime" xml:"CursorTime"`
	ErrorCode    string                  `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string                  `json:"ErrorMessage" xml:"ErrorMessage"`
	PageNumber   int                     `json:"PageNumber" xml:"PageNumber"`
	TotalCount   int64                   `json:"TotalCount" xml:"TotalCount"`
	PageSize     int                     `json:"PageSize" xml:"PageSize"`
	Actions      ActionsInListActionData `json:"Actions" xml:"Actions"`
}

// CreateListActionDataRequest creates a request to invoke ListActionData API
func CreateListActionDataRequest() (request *ListActionDataRequest) {
	request = &ListActionDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("reid", "2019-09-28", "ListActionData", "1.1.8.2", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListActionDataResponse creates a response to parse from ListActionData response
func CreateListActionDataResponse() (response *ListActionDataResponse) {
	response = &ListActionDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
