package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveSkillGroup invokes the scsp.RemoveSkillGroup API synchronously
func (client *Client) RemoveSkillGroup(request *RemoveSkillGroupRequest) (response *RemoveSkillGroupResponse, err error) {
	response = CreateRemoveSkillGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveSkillGroupWithChan invokes the scsp.RemoveSkillGroup API asynchronously
func (client *Client) RemoveSkillGroupWithChan(request *RemoveSkillGroupRequest) (<-chan *RemoveSkillGroupResponse, <-chan error) {
	responseChan := make(chan *RemoveSkillGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveSkillGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveSkillGroupWithCallback invokes the scsp.RemoveSkillGroup API asynchronously
func (client *Client) RemoveSkillGroupWithCallback(request *RemoveSkillGroupRequest, callback func(response *RemoveSkillGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveSkillGroupResponse
		var err error
		defer close(result)
		response, err = client.RemoveSkillGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveSkillGroupRequest is the request struct for api RemoveSkillGroup
type RemoveSkillGroupRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Body"`
	ClientToken  string `position:"Body"`
	SkillGroupId string `position:"Body"`
}

// RemoveSkillGroupResponse is the response struct for api RemoveSkillGroup
type RemoveSkillGroupResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateRemoveSkillGroupRequest creates a request to invoke RemoveSkillGroup API
func CreateRemoveSkillGroupRequest() (request *RemoveSkillGroupRequest) {
	request = &RemoveSkillGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "RemoveSkillGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateRemoveSkillGroupResponse creates a response to parse from RemoveSkillGroup response
func CreateRemoveSkillGroupResponse() (response *RemoveSkillGroupResponse) {
	response = &RemoveSkillGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
