package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRegisteredServiceEndpoints invokes the servicemesh.GetRegisteredServiceEndpoints API synchronously
func (client *Client) GetRegisteredServiceEndpoints(request *GetRegisteredServiceEndpointsRequest) (response *GetRegisteredServiceEndpointsResponse, err error) {
	response = CreateGetRegisteredServiceEndpointsResponse()
	err = client.DoAction(request, response)
	return
}

// GetRegisteredServiceEndpointsWithChan invokes the servicemesh.GetRegisteredServiceEndpoints API asynchronously
func (client *Client) GetRegisteredServiceEndpointsWithChan(request *GetRegisteredServiceEndpointsRequest) (<-chan *GetRegisteredServiceEndpointsResponse, <-chan error) {
	responseChan := make(chan *GetRegisteredServiceEndpointsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRegisteredServiceEndpoints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRegisteredServiceEndpointsWithCallback invokes the servicemesh.GetRegisteredServiceEndpoints API asynchronously
func (client *Client) GetRegisteredServiceEndpointsWithCallback(request *GetRegisteredServiceEndpointsRequest, callback func(response *GetRegisteredServiceEndpointsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRegisteredServiceEndpointsResponse
		var err error
		defer close(result)
		response, err = client.GetRegisteredServiceEndpoints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRegisteredServiceEndpointsRequest is the request struct for api GetRegisteredServiceEndpoints
type GetRegisteredServiceEndpointsRequest struct {
	*requests.RpcRequest
	Namespace     string `position:"Query" name:"Namespace"`
	Name          string `position:"Query" name:"Name"`
	ServiceMeshId string `position:"Query" name:"ServiceMeshId"`
}

// GetRegisteredServiceEndpointsResponse is the response struct for api GetRegisteredServiceEndpoints
type GetRegisteredServiceEndpointsResponse struct {
	*responses.BaseResponse
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	ServiceEndpoints []ServiceEndpoint `json:"ServiceEndpoints" xml:"ServiceEndpoints"`
}

// CreateGetRegisteredServiceEndpointsRequest creates a request to invoke GetRegisteredServiceEndpoints API
func CreateGetRegisteredServiceEndpointsRequest() (request *GetRegisteredServiceEndpointsRequest) {
	request = &GetRegisteredServiceEndpointsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "GetRegisteredServiceEndpoints", "servicemesh", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetRegisteredServiceEndpointsResponse creates a response to parse from GetRegisteredServiceEndpoints response
func CreateGetRegisteredServiceEndpointsResponse() (response *GetRegisteredServiceEndpointsResponse) {
	response = &GetRegisteredServiceEndpointsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
