package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSubscriptionPrice invokes the sgw.DescribeSubscriptionPrice API synchronously
func (client *Client) DescribeSubscriptionPrice(request *DescribeSubscriptionPriceRequest) (response *DescribeSubscriptionPriceResponse, err error) {
	response = CreateDescribeSubscriptionPriceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSubscriptionPriceWithChan invokes the sgw.DescribeSubscriptionPrice API asynchronously
func (client *Client) DescribeSubscriptionPriceWithChan(request *DescribeSubscriptionPriceRequest) (<-chan *DescribeSubscriptionPriceResponse, <-chan error) {
	responseChan := make(chan *DescribeSubscriptionPriceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSubscriptionPrice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSubscriptionPriceWithCallback invokes the sgw.DescribeSubscriptionPrice API asynchronously
func (client *Client) DescribeSubscriptionPriceWithCallback(request *DescribeSubscriptionPriceRequest, callback func(response *DescribeSubscriptionPriceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSubscriptionPriceResponse
		var err error
		defer close(result)
		response, err = client.DescribeSubscriptionPrice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSubscriptionPriceRequest is the request struct for api DescribeSubscriptionPrice
type DescribeSubscriptionPriceRequest struct {
	*requests.RpcRequest
	GatewayClass             string           `position:"Query" name:"GatewayClass"`
	CacheSSDSize             requests.Integer `position:"Query" name:"CacheSSDSize"`
	PeriodUnit               string           `position:"Query" name:"PeriodUnit"`
	PeriodQuantity           requests.Integer `position:"Query" name:"PeriodQuantity"`
	SecurityToken            string           `position:"Query" name:"SecurityToken"`
	CacheCloudEfficiencySize requests.Integer `position:"Query" name:"CacheCloudEfficiencySize"`
}

// DescribeSubscriptionPriceResponse is the response struct for api DescribeSubscriptionPrice
type DescribeSubscriptionPriceResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	Success    bool    `json:"Success" xml:"Success"`
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	Currency   string  `json:"Currency" xml:"Currency"`
	TradePrice float64 `json:"TradePrice" xml:"TradePrice"`
}

// CreateDescribeSubscriptionPriceRequest creates a request to invoke DescribeSubscriptionPrice API
func CreateDescribeSubscriptionPriceRequest() (request *DescribeSubscriptionPriceRequest) {
	request = &DescribeSubscriptionPriceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeSubscriptionPrice", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSubscriptionPriceResponse creates a response to parse from DescribeSubscriptionPrice response
func CreateDescribeSubscriptionPriceResponse() (response *DescribeSubscriptionPriceResponse) {
	response = &DescribeSubscriptionPriceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
