#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/sem.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <signal.h>
#include <gtk/gtk.h>
#include "pop_common.h"
#include "pop.h"

int main(int argc, char *argv[])
{
  struct sockaddr_in my_addr;    // my address information                   
  gint   socket_fd, yes=1,sin_size;
  gtk_init (&argc, &argv); /* init gtk+ */

  /* setup sockaddr with useful values*/
  my_addr.sin_family = AF_INET;         /* host byte order*/                 
  my_addr.sin_port = htons(CP_PORT);     /* short, network byte order */       
  my_addr.sin_addr.s_addr = INADDR_ANY; /* automatically fill with my IP */   
  memset(&(my_addr.sin_zero), '\0', 8); /* zero the rest of the struct*/    


  /***********************/
  /* SETUP SERVER SOCKET */
  if( (socket_fd=socket(AF_INET,SOCK_STREAM,0)) <0 ) errquit("socket register failed");
  if(setsockopt(socket_fd,SOL_SOCKET,SO_REUSEADDR,&yes,sizeof(int)) <0) errquit("setsockopt failed");
  if ( (bind(socket_fd, (struct sockaddr *)&my_addr, sizeof(struct sockaddr))) <0) errquit("bind failed");
  if (listen(socket_fd, 100) <0) errquit("listen failed");
  
  /*get gtk+ to monitor the server socket*/
  g_io_add_watch( g_io_channel_unix_new (socket_fd),G_IO_IN,socket_handler,(gpointer)NULL);

  /*hand control to gtk_main*/
  if(fork()==0) gtk_main();
}

gboolean socket_handler(GIOChannel *source, GIOCondition condition, gpointer data)
{
  GtkWidget *dialog;
  struct sockaddr_in their_addr; // connector's address information          
  socklen_t socklen;
  int   len,connect_fd=0;
  gchar readbuf[CP_MSGSIZE],*buf="", *text, instruction[4],*store;
 

  socklen = sizeof(their_addr);
  if ((connect_fd = accept(g_io_channel_unix_get_fd (source), (struct sockaddr *)&their_addr,&socklen)) < 0) errquit("accept failed");


  do{
    len=read(connect_fd, readbuf,sizeof(readbuf));
    if(len>1)
      {
	readbuf[len-1]='\0';
	buf=g_strconcat(buf,readbuf,NULL);
      }
  }while(len==CP_MSGSIZE);
  close(connect_fd);

  /* A  valid [j|c]pop message block needs at least six chars 
     namely three intruction chars the colon, and a \n\0 */
  if(len>6)
    {
      strncpy(instruction,buf,3);
      instruction[3]='\0';
      if(strcmp(instruction,"MSG")==0)
	{
	  text=buf+4;
	  dialog = gtk_message_dialog_new( NULL,0,GTK_MESSAGE_INFO,GTK_BUTTONS_OK,"Message From: %s\n %s",inet_ntoa(their_addr.sin_addr),text);
	  gtk_dialog_add_button           (GTK_DIALOG(dialog), GTK_STOCK_COPY,1);
	  
	  /* Store the text in a pool of memory in case we need 
	     to retrive it for the "copy" button */
	  store = g_malloc(sizeof(text));
	  store = g_strdup(text);

	  /*lodge a signal handler to cope with buttons being pressed*/
	  g_signal_connect(dialog,"response", G_CALLBACK (response_handler),store);

	  
	  gtk_widget_show(dialog);
	
	}
    }

  return TRUE;
}

void sigchld_handler(int s)
{
  printf("Cpop child process died.\n");
  wait(0);
}
void response_handler (GtkObject *dialog, gint arg1, gpointer data)
{

  if(arg1==1)
    {	  
      gtk_clipboard_set_text(gtk_clipboard_get(GDK_SELECTION_PRIMARY),data,-1);
    }
  else
    {
      g_free(data);
      gtk_object_destroy(dialog);
    }
}
