package linux

import (
	"reflect"
	"testing"
)

func TestDiskStats(t *testing.T) {

	var expected = []DiskStat{
		{8, 0, "sda", 408408680, 130632009, 4314826058, 420257268, 1096727, 1393188, 17797821, 100425864, 0, 28419096, 520607448},
		{8, 1, "sda1", 408408656, 130632009, 4314825866, 420257172, 833896, 1393188, 17797821, 97461104, 0, 27780028, 517642756},
		{8, 32, "sdc", 783343, 36781, 110773558, 4017272, 361505, 12583190, 103537696, 36551180, 1, 2894524, 40572548},
		{8, 33, "sdc1", 782412, 36169, 110761218, 4013708, 355897, 12581496, 103518680, 36525596, 1, 2871296, 40543408},
		{8, 34, "sdc2", 2, 0, 4, 516, 0, 0, 0, 0, 0, 516, 516},
		{8, 37, "sdc5", 683, 612, 10360, 2088, 683, 1694, 19016, 1368, 0, 2436, 3452},
		{8, 16, "sdb", 312308426, 182345841, 3959499204, 361778396, 1106171, 1389910, 17845949, 43843528, 0, 29961500, 405464444},
		{8, 17, "sdb1", 312308273, 182345841, 3959497980, 361778280, 843340, 1389910, 17845949, 41908056, 0, 29850872, 403529168},
		{8, 48, "sdd", 417146071, 77508205, 3959480897, 326427168, 1111215, 1414930, 18087405, 81691580, 0, 24858444, 407955392},
		{8, 49, "sdd1", 417145917, 77508205, 3959479665, 326427124, 848384, 1414930, 18087405, 78896812, 0, 24244124, 405160740},
		{8, 96, "sdg", 235527286, 259133373, 3959571171, 622690468, 1103264, 1412477, 18003005, 55607916, 0, 40736480, 678171012},
		{8, 97, "sdg1", 235527254, 259133373, 3959570915, 622690416, 840433, 1412477, 18003005, 53727712, 0, 40290036, 676291336},
		{8, 112, "sdh", 236183930, 258478518, 3959539350, 736661480, 1102696, 1417936, 18042109, 234611108, 3, 168077436, 1235195636},
		{8, 113, "sdh1", 236183899, 258478518, 3959539102, 736661420, 839866, 1417936, 18042109, 231864320, 2, 167583296, 1106678880},
		{8, 128, "sdi", 241879666, 252778748, 3959567060, 565428444, 1077187, 1403162, 17722541, 139558580, 0, 39615292, 704848044},
		{8, 129, "sdi1", 241879648, 252778748, 3959566916, 565428432, 814356, 1403162, 17722541, 136947936, 0, 39169104, 702237520},
		{8, 144, "sdj", 239842786, 254815073, 3959571267, 605240464, 1093790, 1412969, 17933493, 217510180, 0, 40249492, 822590992},
		{8, 145, "sdj1", 239842768, 254815073, 3959571123, 605240444, 830959, 1412969, 17933493, 214796948, 0, 39767160, 819880212},
		{8, 176, "sdl", 108207, 237256, 2854160, 13616744, 68344261, 905844149, 7819441640, 2108756004, 0, 54571620, 2128460032},
		{8, 177, "sdl1", 107707, 237243, 2850056, 13611560, 64425824, 421281850, 3912412464, 135188688, 0, 40488396, 154892008},
		{8, 64, "sde", 244185799, 250469327, 3959527864, 359434792, 1100737, 1407009, 17939589, 49226088, 0, 38876124, 408523288},
		{8, 65, "sde1", 244185781, 250469327, 3959527720, 359434700, 837906, 1407009, 17939589, 47151748, 0, 38603948, 406448252},
		{8, 80, "sdf", 240921831, 253733300, 3959498760, 353025952, 1128792, 1408474, 18175485, 53618980, 0, 38840468, 406489356},
		{8, 81, "sdf1", 240921678, 253733300, 3959497536, 353025840, 865961, 1408474, 18175485, 51534252, 0, 38585732, 404403848},
		{8, 160, "sdk", 236490604, 258168217, 3959527459, 1334815348, 1130766, 1411015, 18211397, 41485768, 0, 47199324, 1376168140},
		{8, 161, "sdk1", 236490587, 258168217, 3959527323, 1334815288, 867935, 1411015, 18211397, 39843692, 0, 46972288, 1374525752},
		{7, 0, "loop0", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		{7, 1, "loop1", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		{7, 2, "loop2", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		{7, 3, "loop3", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		{7, 4, "loop4", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		{7, 5, "loop5", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		{7, 6, "loop6", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		{7, 7, "loop7", 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
		{9, 2, "md2", 796135, 0, 31381793, 0, 1575830, 0, 72485781, 0, 0, 0, 0},
		{253, 0, "dm-0", 795799, 0, 31379112, 17971064, 1316610, 0, 72485909, 3892582864, 4, 144707052, 5470248},
	}

	stats, err := ReadDiskStats("proc/diskstats")
	if err != nil {
		t.Fatal("disk stat read fail")
	}
	if !reflect.DeepEqual(stats, expected) {
		t.Error("not equal to expected")
	}
}
