// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2/session.proto

package dialogflow // import "google.golang.org/genproto/googleapis/cloud/dialogflow/v2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _struct "github.com/golang/protobuf/ptypes/struct"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import status "google.golang.org/genproto/googleapis/rpc/status"
import latlng "google.golang.org/genproto/googleapis/type/latlng"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Type of the response message.
type StreamingRecognitionResult_MessageType int32

const (
	// Not specified. Should never be used.
	StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED StreamingRecognitionResult_MessageType = 0
	// Message contains a (possibly partial) transcript.
	StreamingRecognitionResult_TRANSCRIPT StreamingRecognitionResult_MessageType = 1
	// Event indicates that the server has detected the end of the user's speech
	// utterance and expects no additional speech. Therefore, the server will
	// not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection. This message is only sent if
	// `single_utterance` was set to `true`, and is not used otherwise.
	StreamingRecognitionResult_END_OF_SINGLE_UTTERANCE StreamingRecognitionResult_MessageType = 2
)

var StreamingRecognitionResult_MessageType_name = map[int32]string{
	0: "MESSAGE_TYPE_UNSPECIFIED",
	1: "TRANSCRIPT",
	2: "END_OF_SINGLE_UTTERANCE",
}
var StreamingRecognitionResult_MessageType_value = map[string]int32{
	"MESSAGE_TYPE_UNSPECIFIED": 0,
	"TRANSCRIPT":               1,
	"END_OF_SINGLE_UTTERANCE":  2,
}

func (x StreamingRecognitionResult_MessageType) String() string {
	return proto.EnumName(StreamingRecognitionResult_MessageType_name, int32(x))
}
func (StreamingRecognitionResult_MessageType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{7, 0}
}

// The request to detect user's intent.
type DetectIntentRequest struct {
	// Required. The name of the session this query is sent to. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>`. It's up to the API
	// caller to choose an appropriate session ID. It can be a random number or
	// some type of user identifier (preferably hashed). The length of the session
	// ID must not exceed 36 bytes.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Optional. The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config
	//     which instructs the speech recognizer how to process the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Optional. Instructs the speech synthesizer how to generate the output
	// audio. If this field is not set and agent-level speech synthesizer is not
	// configured, no output audio is generated.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Optional. The natural language speech audio to be processed. This field
	// should be populated iff `query_input` is set to an input audio config.
	// A single request can contain up to 1 minute of speech audio data.
	InputAudio           []byte   `protobuf:"bytes,5,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectIntentRequest) Reset()         { *m = DetectIntentRequest{} }
func (m *DetectIntentRequest) String() string { return proto.CompactTextString(m) }
func (*DetectIntentRequest) ProtoMessage()    {}
func (*DetectIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{0}
}
func (m *DetectIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectIntentRequest.Unmarshal(m, b)
}
func (m *DetectIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectIntentRequest.Marshal(b, m, deterministic)
}
func (dst *DetectIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectIntentRequest.Merge(dst, src)
}
func (m *DetectIntentRequest) XXX_Size() int {
	return xxx_messageInfo_DetectIntentRequest.Size(m)
}
func (m *DetectIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DetectIntentRequest proto.InternalMessageInfo

func (m *DetectIntentRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *DetectIntentRequest) GetQueryParams() *QueryParameters {
	if m != nil {
		return m.QueryParams
	}
	return nil
}

func (m *DetectIntentRequest) GetQueryInput() *QueryInput {
	if m != nil {
		return m.QueryInput
	}
	return nil
}

func (m *DetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

func (m *DetectIntentRequest) GetInputAudio() []byte {
	if m != nil {
		return m.InputAudio
	}
	return nil
}

// The message returned from the DetectIntent method.
type DetectIntentResponse struct {
	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The selected results of the conversational query or event processing.
	// See `alternative_query_results` for additional potential results.
	QueryResult *QueryResult `protobuf:"bytes,2,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// Specifies the status of the webhook request.
	WebhookStatus *status.Status `protobuf:"bytes,3,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// Note: The output audio is generated based on the values of default platform
	// text responses found in the `query_result.fulfillment_messages` field. If
	// multiple default text responses exist, they will be concatenated when
	// generating audio. If no default platform text responses exist, the
	// generated audio content will be empty.
	OutputAudio []byte `protobuf:"bytes,4,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// The config used by the speech synthesizer to generate the output audio.
	OutputAudioConfig    *OutputAudioConfig `protobuf:"bytes,6,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DetectIntentResponse) Reset()         { *m = DetectIntentResponse{} }
func (m *DetectIntentResponse) String() string { return proto.CompactTextString(m) }
func (*DetectIntentResponse) ProtoMessage()    {}
func (*DetectIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{1}
}
func (m *DetectIntentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectIntentResponse.Unmarshal(m, b)
}
func (m *DetectIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectIntentResponse.Marshal(b, m, deterministic)
}
func (dst *DetectIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectIntentResponse.Merge(dst, src)
}
func (m *DetectIntentResponse) XXX_Size() int {
	return xxx_messageInfo_DetectIntentResponse.Size(m)
}
func (m *DetectIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DetectIntentResponse proto.InternalMessageInfo

func (m *DetectIntentResponse) GetResponseId() string {
	if m != nil {
		return m.ResponseId
	}
	return ""
}

func (m *DetectIntentResponse) GetQueryResult() *QueryResult {
	if m != nil {
		return m.QueryResult
	}
	return nil
}

func (m *DetectIntentResponse) GetWebhookStatus() *status.Status {
	if m != nil {
		return m.WebhookStatus
	}
	return nil
}

func (m *DetectIntentResponse) GetOutputAudio() []byte {
	if m != nil {
		return m.OutputAudio
	}
	return nil
}

func (m *DetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

// Represents the parameters of the conversational query.
type QueryParameters struct {
	// Optional. The time zone of this conversational query from the
	// [time zone database](https://www.iana.org/time-zones), e.g.,
	// America/New_York, Europe/Paris. If not provided, the time zone specified in
	// agent settings is used.
	TimeZone string `protobuf:"bytes,1,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Optional. The geo location of this conversational query.
	GeoLocation *latlng.LatLng `protobuf:"bytes,2,opt,name=geo_location,json=geoLocation,proto3" json:"geo_location,omitempty"`
	// Optional. The collection of contexts to be activated before this query is
	// executed.
	Contexts []*Context `protobuf:"bytes,3,rep,name=contexts,proto3" json:"contexts,omitempty"`
	// Optional. Specifies whether to delete all contexts in the current session
	// before the new ones are activated.
	ResetContexts bool `protobuf:"varint,4,opt,name=reset_contexts,json=resetContexts,proto3" json:"reset_contexts,omitempty"`
	// Optional. Additional session entity types to replace or extend developer
	// entity types with. The entity synonyms apply to all languages and persist
	// for the session of this query.
	SessionEntityTypes []*SessionEntityType `protobuf:"bytes,5,rep,name=session_entity_types,json=sessionEntityTypes,proto3" json:"session_entity_types,omitempty"`
	// Optional. This field can be used to pass custom data into the webhook
	// associated with the agent. Arbitrary JSON objects are supported.
	Payload *_struct.Struct `protobuf:"bytes,6,opt,name=payload,proto3" json:"payload,omitempty"`
	// Optional. Configures the type of sentiment analysis to perform. If not
	// provided, sentiment analysis is not performed.
	SentimentAnalysisRequestConfig *SentimentAnalysisRequestConfig `protobuf:"bytes,10,opt,name=sentiment_analysis_request_config,json=sentimentAnalysisRequestConfig,proto3" json:"sentiment_analysis_request_config,omitempty"`
	XXX_NoUnkeyedLiteral           struct{}                        `json:"-"`
	XXX_unrecognized               []byte                          `json:"-"`
	XXX_sizecache                  int32                           `json:"-"`
}

func (m *QueryParameters) Reset()         { *m = QueryParameters{} }
func (m *QueryParameters) String() string { return proto.CompactTextString(m) }
func (*QueryParameters) ProtoMessage()    {}
func (*QueryParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{2}
}
func (m *QueryParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryParameters.Unmarshal(m, b)
}
func (m *QueryParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryParameters.Marshal(b, m, deterministic)
}
func (dst *QueryParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryParameters.Merge(dst, src)
}
func (m *QueryParameters) XXX_Size() int {
	return xxx_messageInfo_QueryParameters.Size(m)
}
func (m *QueryParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryParameters.DiscardUnknown(m)
}

var xxx_messageInfo_QueryParameters proto.InternalMessageInfo

func (m *QueryParameters) GetTimeZone() string {
	if m != nil {
		return m.TimeZone
	}
	return ""
}

func (m *QueryParameters) GetGeoLocation() *latlng.LatLng {
	if m != nil {
		return m.GeoLocation
	}
	return nil
}

func (m *QueryParameters) GetContexts() []*Context {
	if m != nil {
		return m.Contexts
	}
	return nil
}

func (m *QueryParameters) GetResetContexts() bool {
	if m != nil {
		return m.ResetContexts
	}
	return false
}

func (m *QueryParameters) GetSessionEntityTypes() []*SessionEntityType {
	if m != nil {
		return m.SessionEntityTypes
	}
	return nil
}

func (m *QueryParameters) GetPayload() *_struct.Struct {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *QueryParameters) GetSentimentAnalysisRequestConfig() *SentimentAnalysisRequestConfig {
	if m != nil {
		return m.SentimentAnalysisRequestConfig
	}
	return nil
}

// Represents the query input. It can contain either:
//
// 1.  An audio config which
//     instructs the speech recognizer how to process the speech audio.
//
// 2.  A conversational query in the form of text,.
//
// 3.  An event that specifies which intent to trigger.
type QueryInput struct {
	// Required. The input specification.
	//
	// Types that are valid to be assigned to Input:
	//	*QueryInput_AudioConfig
	//	*QueryInput_Text
	//	*QueryInput_Event
	Input                isQueryInput_Input `protobuf_oneof:"input"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *QueryInput) Reset()         { *m = QueryInput{} }
func (m *QueryInput) String() string { return proto.CompactTextString(m) }
func (*QueryInput) ProtoMessage()    {}
func (*QueryInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{3}
}
func (m *QueryInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryInput.Unmarshal(m, b)
}
func (m *QueryInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryInput.Marshal(b, m, deterministic)
}
func (dst *QueryInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryInput.Merge(dst, src)
}
func (m *QueryInput) XXX_Size() int {
	return xxx_messageInfo_QueryInput.Size(m)
}
func (m *QueryInput) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryInput.DiscardUnknown(m)
}

var xxx_messageInfo_QueryInput proto.InternalMessageInfo

type isQueryInput_Input interface {
	isQueryInput_Input()
}

type QueryInput_AudioConfig struct {
	AudioConfig *InputAudioConfig `protobuf:"bytes,1,opt,name=audio_config,json=audioConfig,proto3,oneof"`
}

type QueryInput_Text struct {
	Text *TextInput `protobuf:"bytes,2,opt,name=text,proto3,oneof"`
}

type QueryInput_Event struct {
	Event *EventInput `protobuf:"bytes,3,opt,name=event,proto3,oneof"`
}

func (*QueryInput_AudioConfig) isQueryInput_Input() {}

func (*QueryInput_Text) isQueryInput_Input() {}

func (*QueryInput_Event) isQueryInput_Input() {}

func (m *QueryInput) GetInput() isQueryInput_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (m *QueryInput) GetAudioConfig() *InputAudioConfig {
	if x, ok := m.GetInput().(*QueryInput_AudioConfig); ok {
		return x.AudioConfig
	}
	return nil
}

func (m *QueryInput) GetText() *TextInput {
	if x, ok := m.GetInput().(*QueryInput_Text); ok {
		return x.Text
	}
	return nil
}

func (m *QueryInput) GetEvent() *EventInput {
	if x, ok := m.GetInput().(*QueryInput_Event); ok {
		return x.Event
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*QueryInput) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _QueryInput_OneofMarshaler, _QueryInput_OneofUnmarshaler, _QueryInput_OneofSizer, []interface{}{
		(*QueryInput_AudioConfig)(nil),
		(*QueryInput_Text)(nil),
		(*QueryInput_Event)(nil),
	}
}

func _QueryInput_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*QueryInput)
	// input
	switch x := m.Input.(type) {
	case *QueryInput_AudioConfig:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AudioConfig); err != nil {
			return err
		}
	case *QueryInput_Text:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Text); err != nil {
			return err
		}
	case *QueryInput_Event:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Event); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("QueryInput.Input has unexpected type %T", x)
	}
	return nil
}

func _QueryInput_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*QueryInput)
	switch tag {
	case 1: // input.audio_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(InputAudioConfig)
		err := b.DecodeMessage(msg)
		m.Input = &QueryInput_AudioConfig{msg}
		return true, err
	case 2: // input.text
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TextInput)
		err := b.DecodeMessage(msg)
		m.Input = &QueryInput_Text{msg}
		return true, err
	case 3: // input.event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EventInput)
		err := b.DecodeMessage(msg)
		m.Input = &QueryInput_Event{msg}
		return true, err
	default:
		return false, nil
	}
}

func _QueryInput_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*QueryInput)
	// input
	switch x := m.Input.(type) {
	case *QueryInput_AudioConfig:
		s := proto.Size(x.AudioConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *QueryInput_Text:
		s := proto.Size(x.Text)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *QueryInput_Event:
		s := proto.Size(x.Event)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Represents the result of conversational query or event processing.
type QueryResult struct {
	// The original conversational query text:
	// - If natural language text was provided as input, `query_text` contains
	//   a copy of the input.
	// - If natural language speech audio was provided as input, `query_text`
	//   contains the speech recognition result. If speech recognizer produced
	//   multiple alternatives, a particular one is picked.
	// - If an event was provided as input, `query_text` is not set.
	QueryText string `protobuf:"bytes,1,opt,name=query_text,json=queryText,proto3" json:"query_text,omitempty"`
	// The language that was triggered during intent detection.
	// See [Language
	// Support](https://cloud.google.com/dialogflow-enterprise/docs/reference/language)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,15,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The Speech recognition confidence between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. The default of 0.0 is a sentinel value indicating that confidence
	// was not set.
	//
	// This field is not guaranteed to be accurate or set. In particular this
	// field isn't set for StreamingDetectIntent since the streaming endpoint has
	// separate confidence estimates per portion of the audio in
	// StreamingRecognitionResult.
	SpeechRecognitionConfidence float32 `protobuf:"fixed32,2,opt,name=speech_recognition_confidence,json=speechRecognitionConfidence,proto3" json:"speech_recognition_confidence,omitempty"`
	// The action name from the matched intent.
	Action string `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// The collection of extracted parameters.
	Parameters *_struct.Struct `protobuf:"bytes,4,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// This field is set to:
	// - `false` if the matched intent has required parameters and not all of
	//    the required parameter values have been collected.
	// - `true` if all required parameter values have been collected, or if the
	//    matched intent doesn't contain any required parameters.
	AllRequiredParamsPresent bool `protobuf:"varint,5,opt,name=all_required_params_present,json=allRequiredParamsPresent,proto3" json:"all_required_params_present,omitempty"`
	// The text to be pronounced to the user or shown on the screen.
	// Note: This is a legacy field, `fulfillment_messages` should be preferred.
	FulfillmentText string `protobuf:"bytes,6,opt,name=fulfillment_text,json=fulfillmentText,proto3" json:"fulfillment_text,omitempty"`
	// The collection of rich messages to present to the user.
	FulfillmentMessages []*Intent_Message `protobuf:"bytes,7,rep,name=fulfillment_messages,json=fulfillmentMessages,proto3" json:"fulfillment_messages,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `source` field returned in the webhook response.
	WebhookSource string `protobuf:"bytes,8,opt,name=webhook_source,json=webhookSource,proto3" json:"webhook_source,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `payload` field returned in the webhook response.
	WebhookPayload *_struct.Struct `protobuf:"bytes,9,opt,name=webhook_payload,json=webhookPayload,proto3" json:"webhook_payload,omitempty"`
	// The collection of output contexts. If applicable,
	// `output_contexts.parameters` contains entries with name
	// `<parameter name>.original` containing the original parameter values
	// before the query.
	OutputContexts []*Context `protobuf:"bytes,10,rep,name=output_contexts,json=outputContexts,proto3" json:"output_contexts,omitempty"`
	// The intent that matched the conversational query. Some, not
	// all fields are filled in this message, including but not limited to:
	// `name`, `display_name` and `webhook_state`.
	Intent *Intent `protobuf:"bytes,11,opt,name=intent,proto3" json:"intent,omitempty"`
	// The intent detection confidence. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	// If there are `multiple knowledge_answers` messages, this value is set to
	// the greatest `knowledgeAnswers.match_confidence` value in the list.
	IntentDetectionConfidence float32 `protobuf:"fixed32,12,opt,name=intent_detection_confidence,json=intentDetectionConfidence,proto3" json:"intent_detection_confidence,omitempty"`
	// The free-form diagnostic info. For example, this field could contain
	// webhook call latency. The string keys of the Struct's fields map can change
	// without notice.
	DiagnosticInfo *_struct.Struct `protobuf:"bytes,14,opt,name=diagnostic_info,json=diagnosticInfo,proto3" json:"diagnostic_info,omitempty"`
	// The sentiment analysis result, which depends on the
	// `sentiment_analysis_request_config` specified in the request.
	SentimentAnalysisResult *SentimentAnalysisResult `protobuf:"bytes,17,opt,name=sentiment_analysis_result,json=sentimentAnalysisResult,proto3" json:"sentiment_analysis_result,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                 `json:"-"`
	XXX_unrecognized        []byte                   `json:"-"`
	XXX_sizecache           int32                    `json:"-"`
}

func (m *QueryResult) Reset()         { *m = QueryResult{} }
func (m *QueryResult) String() string { return proto.CompactTextString(m) }
func (*QueryResult) ProtoMessage()    {}
func (*QueryResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{4}
}
func (m *QueryResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResult.Unmarshal(m, b)
}
func (m *QueryResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResult.Marshal(b, m, deterministic)
}
func (dst *QueryResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResult.Merge(dst, src)
}
func (m *QueryResult) XXX_Size() int {
	return xxx_messageInfo_QueryResult.Size(m)
}
func (m *QueryResult) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResult.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResult proto.InternalMessageInfo

func (m *QueryResult) GetQueryText() string {
	if m != nil {
		return m.QueryText
	}
	return ""
}

func (m *QueryResult) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *QueryResult) GetSpeechRecognitionConfidence() float32 {
	if m != nil {
		return m.SpeechRecognitionConfidence
	}
	return 0
}

func (m *QueryResult) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *QueryResult) GetParameters() *_struct.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *QueryResult) GetAllRequiredParamsPresent() bool {
	if m != nil {
		return m.AllRequiredParamsPresent
	}
	return false
}

func (m *QueryResult) GetFulfillmentText() string {
	if m != nil {
		return m.FulfillmentText
	}
	return ""
}

func (m *QueryResult) GetFulfillmentMessages() []*Intent_Message {
	if m != nil {
		return m.FulfillmentMessages
	}
	return nil
}

func (m *QueryResult) GetWebhookSource() string {
	if m != nil {
		return m.WebhookSource
	}
	return ""
}

func (m *QueryResult) GetWebhookPayload() *_struct.Struct {
	if m != nil {
		return m.WebhookPayload
	}
	return nil
}

func (m *QueryResult) GetOutputContexts() []*Context {
	if m != nil {
		return m.OutputContexts
	}
	return nil
}

func (m *QueryResult) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (m *QueryResult) GetIntentDetectionConfidence() float32 {
	if m != nil {
		return m.IntentDetectionConfidence
	}
	return 0
}

func (m *QueryResult) GetDiagnosticInfo() *_struct.Struct {
	if m != nil {
		return m.DiagnosticInfo
	}
	return nil
}

func (m *QueryResult) GetSentimentAnalysisResult() *SentimentAnalysisResult {
	if m != nil {
		return m.SentimentAnalysisResult
	}
	return nil
}

// The top-level message sent by the client to the
// `StreamingDetectIntent` method.
//
// Multiple request messages should be sent in order:
//
// 1.  The first message must contain `session`, `query_input` plus optionally
//     `query_params` and/or `single_utterance`. The message must not contain `input_audio`.
//
// 2.  If `query_input` was set to a streaming input audio config,
//     all subsequent messages must contain only `input_audio`.
//     Otherwise, finish the request stream.
type StreamingDetectIntentRequest struct {
	// Required. The name of the session the query is sent to.
	// Format of the session name:
	// `projects/<Project ID>/agent/sessions/<Session ID>`. It’s up to the API
	// caller to choose an appropriate `Session ID`. It can be a random number or
	// some type of user identifier (preferably hashed). The length of the session
	// ID must not exceed 36 characters.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Optional. The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config which instructs the speech recognizer how to process
	//     the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Optional. If `false` (default), recognition does not cease until the
	// client closes the stream.
	// If `true`, the recognizer will detect a single spoken utterance in input
	// audio. Recognition ceases when it detects the audio's voice has
	// stopped or paused. In this case, once a detected intent is received, the
	// client should close the stream and start a new request with a new stream as
	// needed.
	// This setting is ignored when `query_input` is a piece of text or an event.
	SingleUtterance bool `protobuf:"varint,4,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	// Optional. Instructs the speech synthesizer how to generate the output
	// audio. If this field is not set and agent-level speech synthesizer is not
	// configured, no output audio is generated.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,5,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Optional. The input audio content to be recognized. Must be sent if
	// `query_input` was set to a streaming input audio config. The complete audio
	// over all streaming messages must not exceed 1 minute.
	InputAudio           []byte   `protobuf:"bytes,6,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingDetectIntentRequest) Reset()         { *m = StreamingDetectIntentRequest{} }
func (m *StreamingDetectIntentRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingDetectIntentRequest) ProtoMessage()    {}
func (*StreamingDetectIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{5}
}
func (m *StreamingDetectIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingDetectIntentRequest.Unmarshal(m, b)
}
func (m *StreamingDetectIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingDetectIntentRequest.Marshal(b, m, deterministic)
}
func (dst *StreamingDetectIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingDetectIntentRequest.Merge(dst, src)
}
func (m *StreamingDetectIntentRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingDetectIntentRequest.Size(m)
}
func (m *StreamingDetectIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingDetectIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingDetectIntentRequest proto.InternalMessageInfo

func (m *StreamingDetectIntentRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *StreamingDetectIntentRequest) GetQueryParams() *QueryParameters {
	if m != nil {
		return m.QueryParams
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetQueryInput() *QueryInput {
	if m != nil {
		return m.QueryInput
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetSingleUtterance() bool {
	if m != nil {
		return m.SingleUtterance
	}
	return false
}

func (m *StreamingDetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetInputAudio() []byte {
	if m != nil {
		return m.InputAudio
	}
	return nil
}

// The top-level message returned from the
// `StreamingDetectIntent` method.
//
// Multiple response messages can be returned in order:
//
// 1.  If the input was set to streaming audio, the first one or more messages
//     contain `recognition_result`. Each `recognition_result` represents a more
//     complete transcript of what the user said. The last `recognition_result`
//     has `is_final` set to `true`.
//
// 2.  The next message contains `response_id`, `query_result`
//     and optionally `webhook_status` if a WebHook was called.
type StreamingDetectIntentResponse struct {
	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The result of speech recognition.
	RecognitionResult *StreamingRecognitionResult `protobuf:"bytes,2,opt,name=recognition_result,json=recognitionResult,proto3" json:"recognition_result,omitempty"`
	// The result of the conversational query or event processing.
	QueryResult *QueryResult `protobuf:"bytes,3,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// Specifies the status of the webhook request.
	WebhookStatus *status.Status `protobuf:"bytes,4,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	// The audio data bytes encoded as specified in the request.
	OutputAudio []byte `protobuf:"bytes,5,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// Instructs the speech synthesizer how to generate the output audio. This
	// field is populated from the agent-level speech synthesizer configuration,
	// if enabled.
	OutputAudioConfig    *OutputAudioConfig `protobuf:"bytes,6,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamingDetectIntentResponse) Reset()         { *m = StreamingDetectIntentResponse{} }
func (m *StreamingDetectIntentResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingDetectIntentResponse) ProtoMessage()    {}
func (*StreamingDetectIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{6}
}
func (m *StreamingDetectIntentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingDetectIntentResponse.Unmarshal(m, b)
}
func (m *StreamingDetectIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingDetectIntentResponse.Marshal(b, m, deterministic)
}
func (dst *StreamingDetectIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingDetectIntentResponse.Merge(dst, src)
}
func (m *StreamingDetectIntentResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingDetectIntentResponse.Size(m)
}
func (m *StreamingDetectIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingDetectIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingDetectIntentResponse proto.InternalMessageInfo

func (m *StreamingDetectIntentResponse) GetResponseId() string {
	if m != nil {
		return m.ResponseId
	}
	return ""
}

func (m *StreamingDetectIntentResponse) GetRecognitionResult() *StreamingRecognitionResult {
	if m != nil {
		return m.RecognitionResult
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetQueryResult() *QueryResult {
	if m != nil {
		return m.QueryResult
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetWebhookStatus() *status.Status {
	if m != nil {
		return m.WebhookStatus
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetOutputAudio() []byte {
	if m != nil {
		return m.OutputAudio
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

// Contains a speech recognition result corresponding to a portion of the audio
// that is currently being processed or an indication that this is the end
// of the single requested utterance.
//
// Example:
//
// 1.  transcript: "tube"
//
// 2.  transcript: "to be a"
//
// 3.  transcript: "to be"
//
// 4.  transcript: "to be or not to be"
//     is_final: true
//
// 5.  transcript: " that's"
//
// 6.  transcript: " that is"
//
// 7.  message_type: `MESSAGE_TYPE_END_OF_SINGLE_UTTERANCE`
//
// 8.  transcript: " that is the question"
//     is_final: true
//
// Only two of the responses contain final results (#4 and #8 indicated by
// `is_final: true`). Concatenating these generates the full transcript: "to be
// or not to be that is the question".
//
// In each response we populate:
//
// *  for `MESSAGE_TYPE_TRANSCRIPT`: `transcript` and possibly `is_final`.
//
// *  for `MESSAGE_TYPE_END_OF_SINGLE_UTTERANCE`: only `message_type`.
type StreamingRecognitionResult struct {
	// Type of the result message.
	MessageType StreamingRecognitionResult_MessageType `protobuf:"varint,1,opt,name=message_type,json=messageType,proto3,enum=google.cloud.dialogflow.v2.StreamingRecognitionResult_MessageType" json:"message_type,omitempty"`
	// Transcript text representing the words that the user spoke.
	// Populated if and only if `message_type` = `MESSAGE_TYPE_TRANSCRIPT`.
	Transcript string `protobuf:"bytes,2,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// If `false`, the `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, the recognizer will not return
	// any further hypotheses about this piece of the audio. May only be populated
	// for `message_type` = `MESSAGE_TYPE_TRANSCRIPT`.
	IsFinal bool `protobuf:"varint,3,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// The Speech confidence between 0.0 and 1.0 for the current portion of audio.
	// A higher number indicates an estimated greater likelihood that the
	// recognized words are correct. The default of 0.0 is a sentinel value
	// indicating that confidence was not set.
	//
	// This field is typically only provided if `is_final` is true and you should
	// not rely on it being accurate or even set.
	Confidence           float32  `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingRecognitionResult) Reset()         { *m = StreamingRecognitionResult{} }
func (m *StreamingRecognitionResult) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognitionResult) ProtoMessage()    {}
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{7}
}
func (m *StreamingRecognitionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognitionResult.Unmarshal(m, b)
}
func (m *StreamingRecognitionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognitionResult.Marshal(b, m, deterministic)
}
func (dst *StreamingRecognitionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognitionResult.Merge(dst, src)
}
func (m *StreamingRecognitionResult) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognitionResult.Size(m)
}
func (m *StreamingRecognitionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognitionResult.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognitionResult proto.InternalMessageInfo

func (m *StreamingRecognitionResult) GetMessageType() StreamingRecognitionResult_MessageType {
	if m != nil {
		return m.MessageType
	}
	return StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED
}

func (m *StreamingRecognitionResult) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *StreamingRecognitionResult) GetIsFinal() bool {
	if m != nil {
		return m.IsFinal
	}
	return false
}

func (m *StreamingRecognitionResult) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Represents the natural language text to be processed.
type TextInput struct {
	// Required. The UTF-8 encoded natural language text to be processed.
	// Text length must not exceed 256 characters.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Required. The language of this conversational query. See [Language
	// Support](https://cloud.google.com/dialogflow-enterprise/docs/reference/language)
	// for a list of the currently supported language codes. Note that queries in
	// the same session do not necessarily need to specify the same language.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextInput) Reset()         { *m = TextInput{} }
func (m *TextInput) String() string { return proto.CompactTextString(m) }
func (*TextInput) ProtoMessage()    {}
func (*TextInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{8}
}
func (m *TextInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextInput.Unmarshal(m, b)
}
func (m *TextInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextInput.Marshal(b, m, deterministic)
}
func (dst *TextInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextInput.Merge(dst, src)
}
func (m *TextInput) XXX_Size() int {
	return xxx_messageInfo_TextInput.Size(m)
}
func (m *TextInput) XXX_DiscardUnknown() {
	xxx_messageInfo_TextInput.DiscardUnknown(m)
}

var xxx_messageInfo_TextInput proto.InternalMessageInfo

func (m *TextInput) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *TextInput) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Events allow for matching intents by event name instead of the natural
// language input. For instance, input `<event: { name: "welcome_event",
// parameters: { name: "Sam" } }>` can trigger a personalized welcome response.
// The parameter `name` may be used by the agent in the response:
// `"Hello #welcome_event.name! What can I do for you today?"`.
type EventInput struct {
	// Required. The unique identifier of the event.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The collection of parameters associated with the event.
	Parameters *_struct.Struct `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Required. The language of this query. See [Language
	// Support](https://cloud.google.com/dialogflow-enterprise/docs/reference/language)
	// for a list of the currently supported language codes. Note that queries in
	// the same session do not necessarily need to specify the same language.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventInput) Reset()         { *m = EventInput{} }
func (m *EventInput) String() string { return proto.CompactTextString(m) }
func (*EventInput) ProtoMessage()    {}
func (*EventInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{9}
}
func (m *EventInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventInput.Unmarshal(m, b)
}
func (m *EventInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventInput.Marshal(b, m, deterministic)
}
func (dst *EventInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventInput.Merge(dst, src)
}
func (m *EventInput) XXX_Size() int {
	return xxx_messageInfo_EventInput.Size(m)
}
func (m *EventInput) XXX_DiscardUnknown() {
	xxx_messageInfo_EventInput.DiscardUnknown(m)
}

var xxx_messageInfo_EventInput proto.InternalMessageInfo

func (m *EventInput) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EventInput) GetParameters() *_struct.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *EventInput) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Configures the types of sentiment analysis to perform.
type SentimentAnalysisRequestConfig struct {
	// Optional. Instructs the service to perform sentiment analysis on
	// `query_text`. If not provided, sentiment analysis is not performed on
	// `query_text`.
	AnalyzeQueryTextSentiment bool     `protobuf:"varint,1,opt,name=analyze_query_text_sentiment,json=analyzeQueryTextSentiment,proto3" json:"analyze_query_text_sentiment,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *SentimentAnalysisRequestConfig) Reset()         { *m = SentimentAnalysisRequestConfig{} }
func (m *SentimentAnalysisRequestConfig) String() string { return proto.CompactTextString(m) }
func (*SentimentAnalysisRequestConfig) ProtoMessage()    {}
func (*SentimentAnalysisRequestConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{10}
}
func (m *SentimentAnalysisRequestConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Unmarshal(m, b)
}
func (m *SentimentAnalysisRequestConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Marshal(b, m, deterministic)
}
func (dst *SentimentAnalysisRequestConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SentimentAnalysisRequestConfig.Merge(dst, src)
}
func (m *SentimentAnalysisRequestConfig) XXX_Size() int {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Size(m)
}
func (m *SentimentAnalysisRequestConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SentimentAnalysisRequestConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SentimentAnalysisRequestConfig proto.InternalMessageInfo

func (m *SentimentAnalysisRequestConfig) GetAnalyzeQueryTextSentiment() bool {
	if m != nil {
		return m.AnalyzeQueryTextSentiment
	}
	return false
}

// The result of sentiment analysis as configured by
// `sentiment_analysis_request_config`.
type SentimentAnalysisResult struct {
	// The sentiment analysis result for `query_text`.
	QueryTextSentiment   *Sentiment `protobuf:"bytes,1,opt,name=query_text_sentiment,json=queryTextSentiment,proto3" json:"query_text_sentiment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *SentimentAnalysisResult) Reset()         { *m = SentimentAnalysisResult{} }
func (m *SentimentAnalysisResult) String() string { return proto.CompactTextString(m) }
func (*SentimentAnalysisResult) ProtoMessage()    {}
func (*SentimentAnalysisResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{11}
}
func (m *SentimentAnalysisResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SentimentAnalysisResult.Unmarshal(m, b)
}
func (m *SentimentAnalysisResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SentimentAnalysisResult.Marshal(b, m, deterministic)
}
func (dst *SentimentAnalysisResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SentimentAnalysisResult.Merge(dst, src)
}
func (m *SentimentAnalysisResult) XXX_Size() int {
	return xxx_messageInfo_SentimentAnalysisResult.Size(m)
}
func (m *SentimentAnalysisResult) XXX_DiscardUnknown() {
	xxx_messageInfo_SentimentAnalysisResult.DiscardUnknown(m)
}

var xxx_messageInfo_SentimentAnalysisResult proto.InternalMessageInfo

func (m *SentimentAnalysisResult) GetQueryTextSentiment() *Sentiment {
	if m != nil {
		return m.QueryTextSentiment
	}
	return nil
}

// The sentiment, such as positive/negative feeling or association, for a unit
// of analysis, such as the query text.
type Sentiment struct {
	// Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// A non-negative number in the [0, +inf) range, which represents the absolute
	// magnitude of sentiment, regardless of score (positive or negative).
	Magnitude            float32  `protobuf:"fixed32,2,opt,name=magnitude,proto3" json:"magnitude,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Sentiment) Reset()         { *m = Sentiment{} }
func (m *Sentiment) String() string { return proto.CompactTextString(m) }
func (*Sentiment) ProtoMessage()    {}
func (*Sentiment) Descriptor() ([]byte, []int) {
	return fileDescriptor_session_b0ebae769d2249cb, []int{12}
}
func (m *Sentiment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Sentiment.Unmarshal(m, b)
}
func (m *Sentiment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Sentiment.Marshal(b, m, deterministic)
}
func (dst *Sentiment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sentiment.Merge(dst, src)
}
func (m *Sentiment) XXX_Size() int {
	return xxx_messageInfo_Sentiment.Size(m)
}
func (m *Sentiment) XXX_DiscardUnknown() {
	xxx_messageInfo_Sentiment.DiscardUnknown(m)
}

var xxx_messageInfo_Sentiment proto.InternalMessageInfo

func (m *Sentiment) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *Sentiment) GetMagnitude() float32 {
	if m != nil {
		return m.Magnitude
	}
	return 0
}

func init() {
	proto.RegisterType((*DetectIntentRequest)(nil), "google.cloud.dialogflow.v2.DetectIntentRequest")
	proto.RegisterType((*DetectIntentResponse)(nil), "google.cloud.dialogflow.v2.DetectIntentResponse")
	proto.RegisterType((*QueryParameters)(nil), "google.cloud.dialogflow.v2.QueryParameters")
	proto.RegisterType((*QueryInput)(nil), "google.cloud.dialogflow.v2.QueryInput")
	proto.RegisterType((*QueryResult)(nil), "google.cloud.dialogflow.v2.QueryResult")
	proto.RegisterType((*StreamingDetectIntentRequest)(nil), "google.cloud.dialogflow.v2.StreamingDetectIntentRequest")
	proto.RegisterType((*StreamingDetectIntentResponse)(nil), "google.cloud.dialogflow.v2.StreamingDetectIntentResponse")
	proto.RegisterType((*StreamingRecognitionResult)(nil), "google.cloud.dialogflow.v2.StreamingRecognitionResult")
	proto.RegisterType((*TextInput)(nil), "google.cloud.dialogflow.v2.TextInput")
	proto.RegisterType((*EventInput)(nil), "google.cloud.dialogflow.v2.EventInput")
	proto.RegisterType((*SentimentAnalysisRequestConfig)(nil), "google.cloud.dialogflow.v2.SentimentAnalysisRequestConfig")
	proto.RegisterType((*SentimentAnalysisResult)(nil), "google.cloud.dialogflow.v2.SentimentAnalysisResult")
	proto.RegisterType((*Sentiment)(nil), "google.cloud.dialogflow.v2.Sentiment")
	proto.RegisterEnum("google.cloud.dialogflow.v2.StreamingRecognitionResult_MessageType", StreamingRecognitionResult_MessageType_name, StreamingRecognitionResult_MessageType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SessionsClient is the client API for Sessions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SessionsClient interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error)
}

type sessionsClient struct {
	cc *grpc.ClientConn
}

func NewSessionsClient(cc *grpc.ClientConn) SessionsClient {
	return &sessionsClient{cc}
}

func (c *sessionsClient) DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error) {
	out := new(DetectIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2.Sessions/DetectIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Sessions_serviceDesc.Streams[0], "/google.cloud.dialogflow.v2.Sessions/StreamingDetectIntent", opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsStreamingDetectIntentClient{stream}
	return x, nil
}

type Sessions_StreamingDetectIntentClient interface {
	Send(*StreamingDetectIntentRequest) error
	Recv() (*StreamingDetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsStreamingDetectIntentClient) Send(m *StreamingDetectIntentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentClient) Recv() (*StreamingDetectIntentResponse, error) {
	m := new(StreamingDetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SessionsServer is the server API for Sessions service.
type SessionsServer interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error
}

func RegisterSessionsServer(s *grpc.Server, srv SessionsServer) {
	s.RegisterService(&_Sessions_serviceDesc, srv)
}

func _Sessions_DetectIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).DetectIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2.Sessions/DetectIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).DetectIntent(ctx, req.(*DetectIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_StreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SessionsServer).StreamingDetectIntent(&sessionsStreamingDetectIntentServer{stream})
}

type Sessions_StreamingDetectIntentServer interface {
	Send(*StreamingDetectIntentResponse) error
	Recv() (*StreamingDetectIntentRequest, error)
	grpc.ServerStream
}

type sessionsStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsStreamingDetectIntentServer) Send(m *StreamingDetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentServer) Recv() (*StreamingDetectIntentRequest, error) {
	m := new(StreamingDetectIntentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Sessions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Sessions",
	HandlerType: (*SessionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DetectIntent",
			Handler:    _Sessions_DetectIntent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingDetectIntent",
			Handler:       _Sessions_StreamingDetectIntent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/dialogflow/v2/session.proto",
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2/session.proto", fileDescriptor_session_b0ebae769d2249cb)
}

var fileDescriptor_session_b0ebae769d2249cb = []byte{
	// 1581 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0x4b, 0x73, 0x1b, 0xc7,
	0x11, 0xe6, 0x82, 0x2f, 0xa0, 0x01, 0x91, 0xd4, 0x90, 0x09, 0xc1, 0x87, 0x18, 0x09, 0x2a, 0x45,
	0x14, 0x13, 0x61, 0x15, 0x28, 0xa5, 0x44, 0x54, 0xe9, 0x41, 0x02, 0x20, 0x85, 0x14, 0x45, 0x41,
	0x0b, 0x2a, 0x0f, 0x55, 0xa9, 0xb6, 0x56, 0x8b, 0xc1, 0x6a, 0x93, 0xc5, 0xcc, 0x72, 0x67, 0x96,
	0x12, 0x95, 0x4a, 0x0e, 0xa9, 0xca, 0x1f, 0xb0, 0xcb, 0x27, 0xdf, 0x7c, 0xf4, 0xc9, 0x07, 0x1f,
	0x7c, 0xf4, 0xd1, 0x77, 0x57, 0xf9, 0x17, 0xd8, 0x17, 0xff, 0x02, 0x1f, 0x7c, 0x70, 0xed, 0xcc,
	0x2c, 0xb0, 0x24, 0x81, 0x25, 0xad, 0x92, 0x7d, 0xf0, 0x0d, 0xd3, 0xf3, 0x75, 0x4f, 0xef, 0x37,
	0xdd, 0xdf, 0x74, 0x01, 0x56, 0x1d, 0x4a, 0x1d, 0x0f, 0xeb, 0xb6, 0x47, 0xc3, 0xb6, 0xde, 0x76,
	0x2d, 0x8f, 0x3a, 0x1d, 0x8f, 0xbe, 0xd2, 0x0f, 0x2a, 0x3a, 0xc3, 0x8c, 0xb9, 0x94, 0x94, 0xfd,
	0x80, 0x72, 0x8a, 0x16, 0x25, 0xb2, 0x2c, 0x90, 0xe5, 0x3e, 0xb2, 0x7c, 0x50, 0x59, 0x5c, 0x56,
	0x51, 0x2c, 0xdf, 0xd5, 0x2d, 0x42, 0x28, 0xb7, 0xb8, 0x4b, 0x09, 0x93, 0x9e, 0x8b, 0x0b, 0x89,
	0xdd, 0x00, 0x33, 0x1a, 0x06, 0x36, 0x56, 0x5b, 0xd7, 0x53, 0x8e, 0xb7, 0xc2, 0xb6, 0x4b, 0x4d,
	0x9b, 0x92, 0x8e, 0xeb, 0x28, 0x78, 0x5a, 0xb6, 0x36, 0x25, 0x1c, 0xbf, 0xe6, 0x0a, 0x79, 0x35,
	0x05, 0xe9, 0x12, 0x8e, 0x49, 0x0c, 0xfc, 0xe3, 0xe9, 0x04, 0x98, 0x98, 0x70, 0x97, 0x1f, 0x9a,
	0xfc, 0xd0, 0x8f, 0xf3, 0x8e, 0x3f, 0x58, 0xac, 0x5e, 0x84, 0x1d, 0x9d, 0xf1, 0x20, 0xb4, 0xe3,
	0x98, 0xf3, 0x6a, 0x37, 0xf0, 0x6d, 0x9d, 0x71, 0x8b, 0x87, 0x31, 0x13, 0x45, 0xb5, 0x11, 0x45,
	0xd2, 0x3d, 0x8b, 0x7b, 0x44, 0x7d, 0x59, 0xe9, 0x8b, 0x0c, 0xcc, 0xd6, 0x30, 0xc7, 0x36, 0x6f,
	0x88, 0xec, 0x0c, 0xbc, 0x1f, 0x62, 0xc6, 0x51, 0x11, 0x26, 0x55, 0x16, 0x45, 0xed, 0xa2, 0xb6,
	0x9a, 0x33, 0xe2, 0x25, 0xda, 0x85, 0xc2, 0x7e, 0x88, 0x83, 0x43, 0xd3, 0xb7, 0x02, 0xab, 0xcb,
	0x8a, 0x99, 0x8b, 0xda, 0x6a, 0xbe, 0xf2, 0xbb, 0xf2, 0xf0, 0x6b, 0x2a, 0x3f, 0x89, 0xf0, 0xcd,
	0x08, 0x8e, 0x39, 0x0e, 0x98, 0x91, 0xdf, 0xef, 0x19, 0x18, 0xda, 0x06, 0xb9, 0x34, 0x5d, 0xe2,
	0x87, 0xbc, 0x38, 0x2a, 0xc2, 0xfd, 0xf6, 0xd4, 0x70, 0x8d, 0x08, 0x6d, 0xc0, 0x7e, 0xef, 0x37,
	0x7a, 0x0e, 0xb3, 0x34, 0xe4, 0x7e, 0xc8, 0xcd, 0xe4, 0x0d, 0x16, 0xc7, 0x44, 0xc0, 0xeb, 0x69,
	0x01, 0x1f, 0x0b, 0xb7, 0x8d, 0xc8, 0xab, 0x2a, 0x9c, 0x8c, 0xf3, 0xf4, 0xb8, 0x09, 0xfd, 0x06,
	0xf2, 0x22, 0x43, 0x19, 0xbd, 0x38, 0x7e, 0x51, 0x5b, 0x2d, 0x18, 0x20, 0x4c, 0x02, 0x56, 0xfa,
	0x3c, 0x03, 0x73, 0x47, 0xa9, 0x64, 0x3e, 0x25, 0x0c, 0x47, 0x9e, 0x81, 0xfa, 0x6d, 0xba, 0x6d,
	0xc5, 0x27, 0xc4, 0xa6, 0x46, 0x1b, 0xfd, 0x25, 0xa6, 0x34, 0xc0, 0x2c, 0xf4, 0xb8, 0xa2, 0xf4,
	0xea, 0xa9, 0x1c, 0x18, 0x02, 0xae, 0xe8, 0x94, 0x0b, 0x74, 0x1b, 0xa6, 0x5e, 0xe1, 0x17, 0x2f,
	0x29, 0xfd, 0x97, 0x29, 0x4b, 0x40, 0x31, 0x8a, 0xe2, 0x68, 0x81, 0x6f, 0x97, 0x5b, 0x62, 0xc7,
	0x38, 0xa7, 0x90, 0x72, 0x89, 0x2e, 0x41, 0x21, 0x49, 0xa0, 0x60, 0xae, 0x60, 0xe4, 0x13, 0x54,
	0x0c, 0xe3, 0x78, 0xe2, 0xdd, 0x70, 0x5c, 0xfa, 0x76, 0x14, 0xa6, 0x8f, 0x15, 0x0b, 0x5a, 0x82,
	0x1c, 0x77, 0xbb, 0xd8, 0x7c, 0x43, 0x09, 0x56, 0xdc, 0x65, 0x23, 0xc3, 0x33, 0x4a, 0x30, 0xba,
	0x05, 0x05, 0x07, 0x53, 0xd3, 0xa3, 0xb6, 0xe8, 0x7c, 0xc5, 0xdc, 0x6c, 0x9c, 0x88, 0xe8, 0x9c,
	0x1d, 0x8b, 0xef, 0x10, 0xc7, 0xc8, 0x3b, 0x98, 0xee, 0x28, 0x1c, 0xba, 0x0f, 0x59, 0xd5, 0xb7,
	0x11, 0x3f, 0xa3, 0xab, 0xf9, 0xca, 0xe5, 0xb4, 0xe4, 0xab, 0x12, 0x6b, 0xf4, 0x9c, 0xd0, 0x15,
	0x98, 0x0a, 0x30, 0xc3, 0xdc, 0xec, 0x85, 0x89, 0xd8, 0xca, 0x1a, 0xe7, 0x84, 0xb5, 0x1a, 0xc3,
	0x4c, 0x98, 0x1b, 0xd0, 0xcc, 0xac, 0x38, 0x2e, 0xce, 0x4c, 0x25, 0xac, 0x25, 0xfd, 0xea, 0xc2,
	0x6d, 0xef, 0xd0, 0xc7, 0x06, 0x62, 0xc7, 0x4d, 0x0c, 0xfd, 0x01, 0x26, 0x7d, 0xeb, 0xd0, 0xa3,
	0x56, 0x5b, 0x5d, 0xc2, 0x7c, 0x1c, 0x33, 0x96, 0x88, 0x72, 0x4b, 0x48, 0x84, 0x11, 0xe3, 0xd0,
	0xff, 0x35, 0xb8, 0xc4, 0xa2, 0x6c, 0xba, 0x98, 0x70, 0xd3, 0x22, 0x96, 0x77, 0xc8, 0x5c, 0x66,
	0x06, 0xb2, 0xf3, 0xe3, 0x2b, 0x05, 0x11, 0x6d, 0x3d, 0x3d, 0x43, 0x15, 0x64, 0x43, 0xc5, 0x50,
	0xe2, 0xa1, 0xee, 0x77, 0x85, 0xa5, 0xee, 0x97, 0xbe, 0xd1, 0x00, 0xfa, 0xad, 0x8c, 0x9e, 0x40,
	0xe1, 0x48, 0x4d, 0x69, 0x22, 0x81, 0xdf, 0xa7, 0x25, 0xd0, 0x20, 0x47, 0xeb, 0xe7, 0xe1, 0x88,
	0x91, 0xb7, 0x12, 0x2d, 0x7b, 0x07, 0xc6, 0xa2, 0x6b, 0x50, 0x55, 0x71, 0x25, 0x2d, 0xd4, 0x1e,
	0x7e, 0xcd, 0x45, 0xb8, 0x87, 0x23, 0x86, 0x70, 0x42, 0xf7, 0x60, 0x1c, 0x1f, 0x60, 0x72, 0x26,
	0x45, 0xaa, 0x47, 0xc0, 0xd8, 0x5d, 0xba, 0x6d, 0x4e, 0xc2, 0xb8, 0x10, 0x87, 0xd2, 0x07, 0x93,
	0x90, 0x4f, 0xb4, 0x2b, 0xba, 0x00, 0x52, 0xb5, 0x4c, 0x91, 0x9b, 0xac, 0xe8, 0x9c, 0xb0, 0x44,
	0x49, 0xa0, 0xcb, 0x70, 0xce, 0xb3, 0x88, 0x13, 0x5a, 0x0e, 0x36, 0x6d, 0xda, 0xc6, 0xc5, 0x69,
	0x81, 0x28, 0xc4, 0xc6, 0x2a, 0x6d, 0x63, 0xb4, 0x09, 0x17, 0x98, 0x8f, 0xb1, 0xfd, 0xd2, 0x0c,
	0xb0, 0x4d, 0x1d, 0xe2, 0x46, 0x55, 0x2d, 0x99, 0x6b, 0x63, 0x62, 0x63, 0xf1, 0xc9, 0x19, 0x63,
	0x49, 0x82, 0x8c, 0x3e, 0xa6, 0xda, 0x83, 0xa0, 0x5f, 0xc3, 0x84, 0x65, 0x8b, 0xae, 0x19, 0x15,
	0x27, 0xa8, 0x15, 0xfa, 0x13, 0x80, 0xdf, 0x6b, 0x3f, 0x25, 0x9f, 0x43, 0xab, 0x2a, 0x01, 0x45,
	0x77, 0x61, 0xc9, 0xf2, 0x3c, 0x51, 0x48, 0x6e, 0x80, 0xdb, 0xea, 0x81, 0x30, 0xfd, 0xa8, 0x25,
	0x08, 0x17, 0x8a, 0x99, 0x35, 0x8a, 0x96, 0xe7, 0x19, 0x0a, 0x21, 0x5f, 0x80, 0xa6, 0xdc, 0x47,
	0xd7, 0x60, 0xa6, 0x13, 0x7a, 0x1d, 0xd7, 0xf3, 0x44, 0x61, 0x0a, 0x76, 0x26, 0x44, 0x66, 0xd3,
	0x09, 0xbb, 0xe0, 0xe8, 0x39, 0xcc, 0x25, 0xa1, 0x5d, 0xcc, 0x98, 0xe5, 0x60, 0x56, 0x9c, 0x14,
	0x6d, 0xb5, 0x96, 0x5e, 0x33, 0xe2, 0x11, 0x7e, 0x24, 0x5d, 0x8c, 0xd9, 0x44, 0x1c, 0x65, 0x13,
	0xcd, 0xdd, 0xd3, 0x50, 0x31, 0x35, 0x14, 0xb3, 0x22, 0x8f, 0x9e, 0x5e, 0x0a, 0x23, 0x7a, 0x00,
	0xd3, 0x31, 0x2c, 0xee, 0xc1, 0x5c, 0x3a, 0x5b, 0x71, 0xd8, 0xa6, 0x6a, 0xc5, 0x1d, 0x98, 0x56,
	0x72, 0xda, 0x93, 0x11, 0x38, 0xbb, 0x1a, 0x4d, 0x49, 0xdf, 0x9e, 0xd8, 0xac, 0xc3, 0x84, 0x1c,
	0x31, 0x8a, 0x79, 0x91, 0x46, 0xe9, 0x74, 0x1e, 0x0c, 0xe5, 0x81, 0xee, 0xc1, 0x92, 0xfc, 0x65,
	0xb6, 0xc5, 0x13, 0x76, 0xac, 0x9c, 0x0a, 0xa2, 0x9c, 0x16, 0x24, 0xa4, 0x16, 0x23, 0x12, 0xc5,
	0xf4, 0x00, 0xa6, 0xdb, 0xae, 0xe5, 0x10, 0xca, 0xb8, 0x6b, 0x9b, 0x2e, 0xe9, 0xd0, 0xe2, 0xd4,
	0x29, 0x5c, 0xf4, 0xf1, 0x0d, 0xd2, 0xa1, 0x88, 0xc2, 0xc2, 0x40, 0x55, 0x12, 0x2f, 0xe2, 0x79,
	0x11, 0xeb, 0xe6, 0x8f, 0x54, 0x23, 0xf1, 0x3a, 0xce, 0xb3, 0xc1, 0x1b, 0xa5, 0xef, 0x33, 0xb0,
	0xdc, 0xe2, 0x01, 0xb6, 0xba, 0x2e, 0x71, 0x7e, 0x21, 0x33, 0xd0, 0x35, 0x98, 0x61, 0x2e, 0x71,
	0x3c, 0x6c, 0x86, 0x9c, 0xe3, 0xc0, 0x8a, 0xee, 0x4e, 0x3e, 0x4c, 0xd3, 0xd2, 0xfe, 0x34, 0x36,
	0x0f, 0x7b, 0xca, 0xc7, 0x7f, 0x9a, 0x71, 0x69, 0xe2, 0xc4, 0xb8, 0xf4, 0xc9, 0x28, 0x5c, 0x18,
	0x42, 0xff, 0x59, 0xe7, 0x26, 0x0c, 0x28, 0x29, 0x7f, 0x47, 0xa6, 0xa7, 0x5b, 0xa9, 0xb5, 0x12,
	0x9f, 0x9b, 0x50, 0x46, 0x55, 0x2e, 0xe7, 0x83, 0xe3, 0xa6, 0x13, 0xe3, 0xd9, 0xe8, 0x3b, 0x1d,
	0xcf, 0xc6, 0xde, 0x76, 0x3c, 0x1b, 0xff, 0xd9, 0xc7, 0xb3, 0xcf, 0x32, 0xb0, 0x38, 0x9c, 0x3a,
	0x84, 0xa1, 0xa0, 0x94, 0x58, 0x4c, 0x39, 0xe2, 0xc2, 0xa6, 0x2a, 0x9b, 0x6f, 0x77, 0x11, 0xb1,
	0x42, 0x8b, 0xc9, 0x27, 0xdf, 0xed, 0x2f, 0xd0, 0x0a, 0x00, 0x0f, 0x2c, 0xc2, 0xec, 0xc0, 0xf5,
	0xe5, 0x6d, 0xe7, 0x8c, 0x84, 0x05, 0x2d, 0x40, 0xd6, 0x65, 0x66, 0xc7, 0x25, 0x96, 0x27, 0xae,
	0x2a, 0x6b, 0x4c, 0xba, 0x6c, 0x2b, 0x5a, 0x46, 0xae, 0x09, 0x51, 0x1b, 0x13, 0xa2, 0x96, 0xb0,
	0x94, 0xfe, 0x0e, 0xf9, 0xc4, 0xb1, 0x68, 0x19, 0x8a, 0x8f, 0xea, 0xad, 0xd6, 0xc6, 0x76, 0xdd,
	0xdc, 0xfb, 0x47, 0xb3, 0x6e, 0x3e, 0xdd, 0x6d, 0x35, 0xeb, 0xd5, 0xc6, 0x56, 0xa3, 0x5e, 0x9b,
	0x19, 0x41, 0x53, 0x00, 0x7b, 0xc6, 0xc6, 0x6e, 0xab, 0x6a, 0x34, 0x9a, 0x7b, 0x33, 0x1a, 0x5a,
	0x82, 0xf9, 0xfa, 0x6e, 0xcd, 0x7c, 0xbc, 0x65, 0xb6, 0x1a, 0xbb, 0xdb, 0x3b, 0x75, 0xf3, 0xe9,
	0xde, 0x5e, 0xdd, 0xd8, 0xd8, 0xad, 0xd6, 0x67, 0x32, 0xa5, 0x1a, 0xe4, 0x7a, 0x23, 0x06, 0x42,
	0x6a, 0x2e, 0x91, 0x15, 0x2d, 0xc7, 0x8d, 0x13, 0xcf, 0x7e, 0xe6, 0xe4, 0xb3, 0x5f, 0xfa, 0x2f,
	0x40, 0x7f, 0xd4, 0x88, 0xc2, 0x10, 0xab, 0x1b, 0x0f, 0xc5, 0xe2, 0xf7, 0xb1, 0xc7, 0x3b, 0x73,
	0xf6, 0xc7, 0xfb, 0xc4, 0xf9, 0xa3, 0x03, 0xce, 0xb7, 0x60, 0x25, 0x7d, 0xe8, 0x43, 0xf7, 0x61,
	0x59, 0x68, 0xf7, 0x1b, 0x6c, 0xf6, 0x87, 0x1c, 0xb3, 0x27, 0xc1, 0x22, 0xd7, 0xac, 0xb1, 0xa0,
	0x30, 0x4f, 0xe2, 0xa9, 0xa7, 0x17, 0xb5, 0x14, 0xc0, 0xfc, 0x10, 0x25, 0x47, 0x7f, 0x83, 0xb9,
	0xa1, 0x31, 0x4f, 0x19, 0xef, 0x7a, 0x21, 0x0d, 0xb4, 0x7f, 0xf2, 0xcc, 0xfb, 0x90, 0xeb, 0x2d,
	0xd0, 0x1c, 0x8c, 0x33, 0x9b, 0x06, 0x92, 0xd6, 0x8c, 0x21, 0x17, 0x68, 0x19, 0x72, 0x5d, 0x2b,
	0x2a, 0xd0, 0xb0, 0x1d, 0x0f, 0x57, 0x7d, 0x43, 0xe5, 0xab, 0x0c, 0x64, 0xd5, 0xbc, 0xce, 0xd0,
	0xa7, 0x1a, 0x14, 0x92, 0x7a, 0x86, 0xf4, 0xb4, 0xcc, 0x06, 0x3c, 0x3c, 0x8b, 0x37, 0xce, 0xee,
	0x20, 0xb5, 0xb0, 0xb4, 0xf1, 0xbf, 0x2f, 0xbf, 0x7e, 0x3f, 0x73, 0xa7, 0x74, 0x4b, 0x3f, 0xa8,
	0xe8, 0xff, 0x56, 0xcf, 0xd4, 0x5d, 0x3f, 0xa0, 0xff, 0xc4, 0x36, 0x67, 0xfa, 0x9a, 0x6e, 0x39,
	0x98, 0xf0, 0xf8, 0x8f, 0x05, 0xa6, 0xaf, 0xfd, 0x67, 0xbd, 0x9d, 0x88, 0xb3, 0xae, 0xad, 0xa1,
	0xf7, 0x34, 0xf8, 0xd5, 0x40, 0x3d, 0x46, 0x7f, 0x3e, 0x53, 0x07, 0x0f, 0xfa, 0x90, 0xdb, 0x6f,
	0xe1, 0xa9, 0xbe, 0x68, 0x64, 0x55, 0xbb, 0xa1, 0x6d, 0x7e, 0xa8, 0xc1, 0x8a, 0x4d, 0xbb, 0x29,
	0x61, 0x36, 0x0b, 0x8a, 0xf8, 0x66, 0x54, 0xdc, 0x4d, 0xed, 0x59, 0x4d, 0x61, 0x1d, 0x1a, 0x95,
	0x6e, 0x99, 0x06, 0x8e, 0xee, 0x60, 0x22, 0x4a, 0x5f, 0x97, 0x5b, 0x96, 0xef, 0xb2, 0x41, 0xff,
	0xbb, 0xdc, 0xe9, 0xaf, 0xbe, 0xd3, 0xb4, 0x8f, 0x32, 0x99, 0xda, 0xd6, 0xc7, 0x99, 0xc5, 0x6d,
	0x19, 0xae, 0x2a, 0x8e, 0xae, 0xf5, 0x8f, 0xfe, 0x6b, 0xe5, 0xc5, 0x84, 0x88, 0x7a, 0xf3, 0x87,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xad, 0xf5, 0x89, 0x0f, 0xcd, 0x12, 0x00, 0x00,
}
