// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/streetview/publish/v1/resources.proto

package publish

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Status of rights transfer.
type Photo_TransferStatus int32

const (
	// The status of this transfer is unspecified.
	Photo_TRANSFER_STATUS_UNKNOWN Photo_TransferStatus = 0
	// This photo has never been in a transfer.
	Photo_NEVER_TRANSFERRED Photo_TransferStatus = 1
	// This photo transfer has been initiated, but the receiver has not yet
	// responded.
	Photo_PENDING Photo_TransferStatus = 2
	// The photo transfer has been completed, and this photo has been
	// transferred to the recipient.
	Photo_COMPLETED Photo_TransferStatus = 3
	// The recipient rejected this photo transfer.
	Photo_REJECTED Photo_TransferStatus = 4
	// The photo transfer expired before the recipient took any action.
	Photo_EXPIRED Photo_TransferStatus = 5
	// The sender cancelled this photo transfer.
	Photo_CANCELLED Photo_TransferStatus = 6
	// The recipient owns this photo due to a rights transfer.
	Photo_RECEIVED_VIA_TRANSFER Photo_TransferStatus = 7
)

// Enum value maps for Photo_TransferStatus.
var (
	Photo_TransferStatus_name = map[int32]string{
		0: "TRANSFER_STATUS_UNKNOWN",
		1: "NEVER_TRANSFERRED",
		2: "PENDING",
		3: "COMPLETED",
		4: "REJECTED",
		5: "EXPIRED",
		6: "CANCELLED",
		7: "RECEIVED_VIA_TRANSFER",
	}
	Photo_TransferStatus_value = map[string]int32{
		"TRANSFER_STATUS_UNKNOWN": 0,
		"NEVER_TRANSFERRED":       1,
		"PENDING":                 2,
		"COMPLETED":               3,
		"REJECTED":                4,
		"EXPIRED":                 5,
		"CANCELLED":               6,
		"RECEIVED_VIA_TRANSFER":   7,
	}
)

func (x Photo_TransferStatus) Enum() *Photo_TransferStatus {
	p := new(Photo_TransferStatus)
	*p = x
	return p
}

func (x Photo_TransferStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Photo_TransferStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_streetview_publish_v1_resources_proto_enumTypes[0].Descriptor()
}

func (Photo_TransferStatus) Type() protoreflect.EnumType {
	return &file_google_streetview_publish_v1_resources_proto_enumTypes[0]
}

func (x Photo_TransferStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Photo_TransferStatus.Descriptor instead.
func (Photo_TransferStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{6, 0}
}

// Publication status of the photo in Google Maps.
type Photo_MapsPublishStatus int32

const (
	// The status of the photo is unknown.
	Photo_UNSPECIFIED_MAPS_PUBLISH_STATUS Photo_MapsPublishStatus = 0
	// The photo is published to the public through Google Maps.
	Photo_PUBLISHED Photo_MapsPublishStatus = 1
	// The photo has been rejected for an unknown reason.
	Photo_REJECTED_UNKNOWN Photo_MapsPublishStatus = 2
)

// Enum value maps for Photo_MapsPublishStatus.
var (
	Photo_MapsPublishStatus_name = map[int32]string{
		0: "UNSPECIFIED_MAPS_PUBLISH_STATUS",
		1: "PUBLISHED",
		2: "REJECTED_UNKNOWN",
	}
	Photo_MapsPublishStatus_value = map[string]int32{
		"UNSPECIFIED_MAPS_PUBLISH_STATUS": 0,
		"PUBLISHED":                       1,
		"REJECTED_UNKNOWN":                2,
	}
)

func (x Photo_MapsPublishStatus) Enum() *Photo_MapsPublishStatus {
	p := new(Photo_MapsPublishStatus)
	*p = x
	return p
}

func (x Photo_MapsPublishStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Photo_MapsPublishStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_streetview_publish_v1_resources_proto_enumTypes[1].Descriptor()
}

func (Photo_MapsPublishStatus) Type() protoreflect.EnumType {
	return &file_google_streetview_publish_v1_resources_proto_enumTypes[1]
}

func (x Photo_MapsPublishStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Photo_MapsPublishStatus.Descriptor instead.
func (Photo_MapsPublishStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{6, 1}
}

// Upload reference for media files.
type UploadRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. An upload reference should be unique for each user. It follows
	// the form:
	// "https://streetviewpublish.googleapis.com/media/user/{account_id}/photo/{upload_reference}"
	UploadUrl string `protobuf:"bytes,1,opt,name=upload_url,json=uploadUrl,proto3" json:"upload_url,omitempty"`
}

func (x *UploadRef) Reset() {
	*x = UploadRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UploadRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRef) ProtoMessage() {}

func (x *UploadRef) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadRef.ProtoReflect.Descriptor instead.
func (*UploadRef) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{0}
}

func (x *UploadRef) GetUploadUrl() string {
	if x != nil {
		return x.UploadUrl
	}
	return ""
}

// Identifier for a [Photo][google.streetview.publish.v1.Photo].
type PhotoId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A unique identifier for a photo.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *PhotoId) Reset() {
	*x = PhotoId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PhotoId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PhotoId) ProtoMessage() {}

func (x *PhotoId) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PhotoId.ProtoReflect.Descriptor instead.
func (*PhotoId) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{1}
}

func (x *PhotoId) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Level information containing level number and its corresponding name.
type Level struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Floor number, used for ordering. 0 indicates the ground level, 1 indicates
	// the first level above ground level, -1 indicates the first level under
	// ground level. Non-integer values are OK.
	Number float64 `protobuf:"fixed64,1,opt,name=number,proto3" json:"number,omitempty"`
	// Required. A name assigned to this Level, restricted to 3 characters.
	// Consider how the elevator buttons would be labeled for this level if there
	// was an elevator.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Level) Reset() {
	*x = Level{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Level) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Level) ProtoMessage() {}

func (x *Level) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Level.ProtoReflect.Descriptor instead.
func (*Level) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{2}
}

func (x *Level) GetNumber() float64 {
	if x != nil {
		return x.Number
	}
	return 0
}

func (x *Level) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Raw pose measurement for an entity.
type Pose struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Latitude and longitude pair of the pose, as explained here:
	// https://cloud.google.com/datastore/docs/reference/rest/Shared.Types/LatLng
	// When creating a [Photo][google.streetview.publish.v1.Photo], if the
	// latitude and longitude pair are not provided, the geolocation from the
	// exif header is used. A latitude and longitude pair not provided in the
	// photo or exif header causes the create photo process to fail.
	LatLngPair *latlng.LatLng `protobuf:"bytes,1,opt,name=lat_lng_pair,json=latLngPair,proto3" json:"lat_lng_pair,omitempty"`
	// Altitude of the pose in meters above WGS84 ellipsoid.
	// NaN indicates an unmeasured quantity.
	Altitude float64 `protobuf:"fixed64,2,opt,name=altitude,proto3" json:"altitude,omitempty"`
	// Compass heading, measured at the center of the photo in degrees clockwise
	// from North. Value must be >=0 and <360.
	// NaN indicates an unmeasured quantity.
	Heading float64 `protobuf:"fixed64,3,opt,name=heading,proto3" json:"heading,omitempty"`
	// Pitch, measured at the center of the photo in degrees. Value must be >=-90
	// and <= 90. A value of -90 means looking directly down, and a value of 90
	// means looking directly up.
	// NaN indicates an unmeasured quantity.
	Pitch float64 `protobuf:"fixed64,4,opt,name=pitch,proto3" json:"pitch,omitempty"`
	// Roll, measured in degrees. Value must be >= 0 and <360. A value of 0
	// means level with the horizon.
	// NaN indicates an unmeasured quantity.
	Roll float64 `protobuf:"fixed64,5,opt,name=roll,proto3" json:"roll,omitempty"`
	// Level (the floor in a building) used to configure vertical navigation.
	Level *Level `protobuf:"bytes,7,opt,name=level,proto3" json:"level,omitempty"`
	// The estimated horizontal accuracy of this pose in meters with 68%
	// confidence (one standard deviation). For example, on Android, this value is
	// available from this method:
	// https://developer.android.com/reference/android/location/Location#getAccuracy().
	// Other platforms have different methods of obtaining similar accuracy
	// estimations.
	AccuracyMeters float32 `protobuf:"fixed32,9,opt,name=accuracy_meters,json=accuracyMeters,proto3" json:"accuracy_meters,omitempty"`
}

func (x *Pose) Reset() {
	*x = Pose{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Pose) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pose) ProtoMessage() {}

func (x *Pose) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pose.ProtoReflect.Descriptor instead.
func (*Pose) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{3}
}

func (x *Pose) GetLatLngPair() *latlng.LatLng {
	if x != nil {
		return x.LatLngPair
	}
	return nil
}

func (x *Pose) GetAltitude() float64 {
	if x != nil {
		return x.Altitude
	}
	return 0
}

func (x *Pose) GetHeading() float64 {
	if x != nil {
		return x.Heading
	}
	return 0
}

func (x *Pose) GetPitch() float64 {
	if x != nil {
		return x.Pitch
	}
	return 0
}

func (x *Pose) GetRoll() float64 {
	if x != nil {
		return x.Roll
	}
	return 0
}

func (x *Pose) GetLevel() *Level {
	if x != nil {
		return x.Level
	}
	return nil
}

func (x *Pose) GetAccuracyMeters() float32 {
	if x != nil {
		return x.AccuracyMeters
	}
	return 0
}

// Place metadata for an entity.
type Place struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Place identifier, as described in
	// https://developers.google.com/places/place-id.
	PlaceId string `protobuf:"bytes,1,opt,name=place_id,json=placeId,proto3" json:"place_id,omitempty"`
	// Output-only. The name of the place, localized to the language_code.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Output-only. The language_code that the name is localized with. This should
	// be the language_code specified in the request, but may be a fallback.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *Place) Reset() {
	*x = Place{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Place) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place) ProtoMessage() {}

func (x *Place) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place.ProtoReflect.Descriptor instead.
func (*Place) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{4}
}

func (x *Place) GetPlaceId() string {
	if x != nil {
		return x.PlaceId
	}
	return ""
}

func (x *Place) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Place) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// A connection is the link from a source photo to a destination photo.
type Connection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The destination of the connection from the containing photo to
	// another photo.
	Target *PhotoId `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
}

func (x *Connection) Reset() {
	*x = Connection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{5}
}

func (x *Connection) GetTarget() *PhotoId {
	if x != nil {
		return x.Target
	}
	return nil
}

// Photo is used to store 360 photos along with photo metadata.
type Photo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required when updating a photo. Output only when creating a photo.
	// Identifier for the photo, which is unique among all photos in
	// Google.
	PhotoId *PhotoId `protobuf:"bytes,1,opt,name=photo_id,json=photoId,proto3" json:"photo_id,omitempty"`
	// Required when creating a photo. Input only. The resource URL where the
	// photo bytes are uploaded to.
	UploadReference *UploadRef `protobuf:"bytes,2,opt,name=upload_reference,json=uploadReference,proto3" json:"upload_reference,omitempty"`
	// Output only. The download URL for the photo bytes. This field is set only
	// when
	// [GetPhotoRequest.view][google.streetview.publish.v1.GetPhotoRequest.view]
	// is set to
	// [PhotoView.INCLUDE_DOWNLOAD_URL][google.streetview.publish.v1.PhotoView.INCLUDE_DOWNLOAD_URL].
	DownloadUrl string `protobuf:"bytes,3,opt,name=download_url,json=downloadUrl,proto3" json:"download_url,omitempty"`
	// Output only. The thumbnail URL for showing a preview of the given photo.
	ThumbnailUrl string `protobuf:"bytes,9,opt,name=thumbnail_url,json=thumbnailUrl,proto3" json:"thumbnail_url,omitempty"`
	// Output only. The share link for the photo.
	ShareLink string `protobuf:"bytes,11,opt,name=share_link,json=shareLink,proto3" json:"share_link,omitempty"`
	// Pose of the photo.
	Pose *Pose `protobuf:"bytes,4,opt,name=pose,proto3" json:"pose,omitempty"`
	// Connections to other photos. A connection represents the link from this
	// photo to another photo.
	Connections []*Connection `protobuf:"bytes,5,rep,name=connections,proto3" json:"connections,omitempty"`
	// Absolute time when the photo was captured.
	// When the photo has no exif timestamp, this is used to set a timestamp in
	// the photo metadata.
	CaptureTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=capture_time,json=captureTime,proto3" json:"capture_time,omitempty"`
	// Places where this photo belongs.
	Places []*Place `protobuf:"bytes,7,rep,name=places,proto3" json:"places,omitempty"`
	// Output only. View count of the photo.
	ViewCount int64 `protobuf:"varint,10,opt,name=view_count,json=viewCount,proto3" json:"view_count,omitempty"`
	// Output only. Status of rights transfer on this photo.
	TransferStatus Photo_TransferStatus `protobuf:"varint,12,opt,name=transfer_status,json=transferStatus,proto3,enum=google.streetview.publish.v1.Photo_TransferStatus" json:"transfer_status,omitempty"`
	// Output only. Status in Google Maps, whether this photo was published or
	// rejected.
	MapsPublishStatus Photo_MapsPublishStatus `protobuf:"varint,13,opt,name=maps_publish_status,json=mapsPublishStatus,proto3,enum=google.streetview.publish.v1.Photo_MapsPublishStatus" json:"maps_publish_status,omitempty"`
}

func (x *Photo) Reset() {
	*x = Photo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Photo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Photo) ProtoMessage() {}

func (x *Photo) ProtoReflect() protoreflect.Message {
	mi := &file_google_streetview_publish_v1_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Photo.ProtoReflect.Descriptor instead.
func (*Photo) Descriptor() ([]byte, []int) {
	return file_google_streetview_publish_v1_resources_proto_rawDescGZIP(), []int{6}
}

func (x *Photo) GetPhotoId() *PhotoId {
	if x != nil {
		return x.PhotoId
	}
	return nil
}

func (x *Photo) GetUploadReference() *UploadRef {
	if x != nil {
		return x.UploadReference
	}
	return nil
}

func (x *Photo) GetDownloadUrl() string {
	if x != nil {
		return x.DownloadUrl
	}
	return ""
}

func (x *Photo) GetThumbnailUrl() string {
	if x != nil {
		return x.ThumbnailUrl
	}
	return ""
}

func (x *Photo) GetShareLink() string {
	if x != nil {
		return x.ShareLink
	}
	return ""
}

func (x *Photo) GetPose() *Pose {
	if x != nil {
		return x.Pose
	}
	return nil
}

func (x *Photo) GetConnections() []*Connection {
	if x != nil {
		return x.Connections
	}
	return nil
}

func (x *Photo) GetCaptureTime() *timestamp.Timestamp {
	if x != nil {
		return x.CaptureTime
	}
	return nil
}

func (x *Photo) GetPlaces() []*Place {
	if x != nil {
		return x.Places
	}
	return nil
}

func (x *Photo) GetViewCount() int64 {
	if x != nil {
		return x.ViewCount
	}
	return 0
}

func (x *Photo) GetTransferStatus() Photo_TransferStatus {
	if x != nil {
		return x.TransferStatus
	}
	return Photo_TRANSFER_STATUS_UNKNOWN
}

func (x *Photo) GetMapsPublishStatus() Photo_MapsPublishStatus {
	if x != nil {
		return x.MapsPublishStatus
	}
	return Photo_UNSPECIFIED_MAPS_PUBLISH_STATUS
}

var File_google_streetview_publish_v1_resources_proto protoreflect.FileDescriptor

var file_google_streetview_publish_v1_resources_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76,
	0x69, 0x65, 0x77, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2f, 0x76, 0x31, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65,
	0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x2a, 0x0a, 0x09, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52,
	0x65, 0x66, 0x12, 0x1d, 0x0a, 0x0a, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72,
	0x6c, 0x22, 0x19, 0x0a, 0x07, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x33, 0x0a, 0x05,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0x81, 0x02, 0x0a, 0x04, 0x50, 0x6f, 0x73, 0x65, 0x12, 0x35, 0x0a, 0x0c, 0x6c, 0x61,
	0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c,
	0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x0a, 0x6c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x50, 0x61, 0x69,
	0x72, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x6c, 0x74, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x08, 0x61, 0x6c, 0x74, 0x69, 0x74, 0x75, 0x64, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x68, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x07,
	0x68, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x69, 0x74, 0x63, 0x68,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x70, 0x69, 0x74, 0x63, 0x68, 0x12, 0x12, 0x0a,
	0x04, 0x72, 0x6f, 0x6c, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x72, 0x6f, 0x6c,
	0x6c, 0x12, 0x39, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74,
	0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x27, 0x0a, 0x0f,
	0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0e, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x4d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x5b, 0x0a, 0x05, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x19,
	0x0a, 0x08, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x22, 0x4b, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3d, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74,
	0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x68, 0x6f, 0x74, 0x6f, 0x49, 0x64, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22,
	0xee, 0x07, 0x0a, 0x05, 0x50, 0x68, 0x6f, 0x74, 0x6f, 0x12, 0x40, 0x0a, 0x08, 0x70, 0x68, 0x6f,
	0x74, 0x6f, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68, 0x6f, 0x74, 0x6f,
	0x49, 0x64, 0x52, 0x07, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x10, 0x75,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x66, 0x52, 0x0f,
	0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55,
	0x72, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e, 0x61, 0x69, 0x6c, 0x5f,
	0x75, 0x72, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x68, 0x75, 0x6d, 0x62,
	0x6e, 0x61, 0x69, 0x6c, 0x55, 0x72, 0x6c, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x65,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x68, 0x61,
	0x72, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x36, 0x0a, 0x04, 0x70, 0x6f, 0x73, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74,
	0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x65, 0x52, 0x04, 0x70, 0x6f, 0x73, 0x65, 0x12, 0x4a,
	0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72,
	0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3d, 0x0a, 0x0c, 0x63, 0x61,
	0x70, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x63, 0x61,
	0x70, 0x74, 0x75, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x06, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x06,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x76, 0x69, 0x65, 0x77,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69,
	0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x68,
	0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x65, 0x0a, 0x13, 0x6d, 0x61, 0x70, 0x73, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x68, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x11, 0x6d, 0x61, 0x70, 0x73, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xa5, 0x01, 0x0a, 0x0e, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1b, 0x0a, 0x17,
	0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x45, 0x56,
	0x45, 0x52, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08,
	0x52, 0x45, 0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58,
	0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45,
	0x4c, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x43, 0x45, 0x49, 0x56,
	0x45, 0x44, 0x5f, 0x56, 0x49, 0x41, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x10,
	0x07, 0x22, 0x5d, 0x0a, 0x11, 0x4d, 0x61, 0x70, 0x73, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x23, 0x0a, 0x1f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x5f, 0x4d, 0x41, 0x50, 0x53, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49,
	0x53, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x50,
	0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x44, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45,
	0x4a, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x02,
	0x42, 0x8b, 0x01, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x65, 0x6f, 0x2e, 0x75, 0x67, 0x63, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69,
	0x65, 0x77, 0x2e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x2e, 0x76, 0x31, 0x42, 0x1a, 0x53,
	0x74, 0x72, 0x65, 0x65, 0x74, 0x56, 0x69, 0x65, 0x77, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x76, 0x69, 0x65, 0x77, 0x2f, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x2f, 0x76, 0x31, 0x3b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_streetview_publish_v1_resources_proto_rawDescOnce sync.Once
	file_google_streetview_publish_v1_resources_proto_rawDescData = file_google_streetview_publish_v1_resources_proto_rawDesc
)

func file_google_streetview_publish_v1_resources_proto_rawDescGZIP() []byte {
	file_google_streetview_publish_v1_resources_proto_rawDescOnce.Do(func() {
		file_google_streetview_publish_v1_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_streetview_publish_v1_resources_proto_rawDescData)
	})
	return file_google_streetview_publish_v1_resources_proto_rawDescData
}

var file_google_streetview_publish_v1_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_streetview_publish_v1_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_streetview_publish_v1_resources_proto_goTypes = []interface{}{
	(Photo_TransferStatus)(0),    // 0: google.streetview.publish.v1.Photo.TransferStatus
	(Photo_MapsPublishStatus)(0), // 1: google.streetview.publish.v1.Photo.MapsPublishStatus
	(*UploadRef)(nil),            // 2: google.streetview.publish.v1.UploadRef
	(*PhotoId)(nil),              // 3: google.streetview.publish.v1.PhotoId
	(*Level)(nil),                // 4: google.streetview.publish.v1.Level
	(*Pose)(nil),                 // 5: google.streetview.publish.v1.Pose
	(*Place)(nil),                // 6: google.streetview.publish.v1.Place
	(*Connection)(nil),           // 7: google.streetview.publish.v1.Connection
	(*Photo)(nil),                // 8: google.streetview.publish.v1.Photo
	(*latlng.LatLng)(nil),        // 9: google.type.LatLng
	(*timestamp.Timestamp)(nil),  // 10: google.protobuf.Timestamp
}
var file_google_streetview_publish_v1_resources_proto_depIdxs = []int32{
	9,  // 0: google.streetview.publish.v1.Pose.lat_lng_pair:type_name -> google.type.LatLng
	4,  // 1: google.streetview.publish.v1.Pose.level:type_name -> google.streetview.publish.v1.Level
	3,  // 2: google.streetview.publish.v1.Connection.target:type_name -> google.streetview.publish.v1.PhotoId
	3,  // 3: google.streetview.publish.v1.Photo.photo_id:type_name -> google.streetview.publish.v1.PhotoId
	2,  // 4: google.streetview.publish.v1.Photo.upload_reference:type_name -> google.streetview.publish.v1.UploadRef
	5,  // 5: google.streetview.publish.v1.Photo.pose:type_name -> google.streetview.publish.v1.Pose
	7,  // 6: google.streetview.publish.v1.Photo.connections:type_name -> google.streetview.publish.v1.Connection
	10, // 7: google.streetview.publish.v1.Photo.capture_time:type_name -> google.protobuf.Timestamp
	6,  // 8: google.streetview.publish.v1.Photo.places:type_name -> google.streetview.publish.v1.Place
	0,  // 9: google.streetview.publish.v1.Photo.transfer_status:type_name -> google.streetview.publish.v1.Photo.TransferStatus
	1,  // 10: google.streetview.publish.v1.Photo.maps_publish_status:type_name -> google.streetview.publish.v1.Photo.MapsPublishStatus
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_streetview_publish_v1_resources_proto_init() }
func file_google_streetview_publish_v1_resources_proto_init() {
	if File_google_streetview_publish_v1_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_streetview_publish_v1_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UploadRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PhotoId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Level); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Pose); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Place); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Connection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_streetview_publish_v1_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Photo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_streetview_publish_v1_resources_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_streetview_publish_v1_resources_proto_goTypes,
		DependencyIndexes: file_google_streetview_publish_v1_resources_proto_depIdxs,
		EnumInfos:         file_google_streetview_publish_v1_resources_proto_enumTypes,
		MessageInfos:      file_google_streetview_publish_v1_resources_proto_msgTypes,
	}.Build()
	File_google_streetview_publish_v1_resources_proto = out.File
	file_google_streetview_publish_v1_resources_proto_rawDesc = nil
	file_google_streetview_publish_v1_resources_proto_goTypes = nil
	file_google_streetview_publish_v1_resources_proto_depIdxs = nil
}
