// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudcontrolapi

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilResourceRequestSuccess uses the CloudControlApi API operation
// GetResourceRequestStatus to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *CloudControlApi) WaitUntilResourceRequestSuccess(input *GetResourceRequestStatusInput) error {
	return c.WaitUntilResourceRequestSuccessWithContext(aws.BackgroundContext(), input)
}

// WaitUntilResourceRequestSuccessWithContext is an extended version of WaitUntilResourceRequestSuccess.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudControlApi) WaitUntilResourceRequestSuccessWithContext(ctx aws.Context, input *GetResourceRequestStatusInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilResourceRequestSuccess",
		MaxAttempts: 720,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "ProgressEvent.OperationStatus",
				Expected: "SUCCESS",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "ProgressEvent.OperationStatus",
				Expected: "FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "ProgressEvent.OperationStatus",
				Expected: "CANCEL_COMPLETE",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetResourceRequestStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceRequestStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
