/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.ByteFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class ByteFilterInputStream
extends FilterInputStream {
    private final Thread worker;
    IOException byteFilterIOException;
    RuntimeException byteFilterRuntimeException;

    public ByteFilterInputStream(final InputStream in, final ByteFilter byteFilter) {
        super(new PipedInputStream());
        PipedOutputStream pos;
        try {
            pos = new PipedOutputStream((PipedInputStream)this.in);
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
        this.worker = new Thread("PipeFilterInputStream"){

            public void run() {
                try {
                    try {
                        byteFilter.run(in, pos);
                    }
                    catch (IOException ioe) {
                        ByteFilterInputStream.this.byteFilterIOException = ioe;
                        try {
                            pos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    catch (RuntimeException re) {
                        ByteFilterInputStream.this.byteFilterRuntimeException = re;
                        try {
                            pos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    try {
                        pos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        this.worker.start();
    }

    public int read() throws IOException {
        int n;
        byte[] buffer = new byte[1];
        do {
            if ((n = this.read(buffer)) == -1) {
                return -1;
            }
            if (n != 1) continue;
            return 0xFF & buffer[0];
        } while (n == 0);
        throw new IllegalStateException();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (this.byteFilterIOException != null) {
            IOException ioe = new IOException("ByteFilterInputStream: " + this.byteFilterIOException.getMessage());
            ioe.initCause(this.byteFilterIOException);
            throw ioe;
        }
        if (this.byteFilterRuntimeException != null) {
            throw new RuntimeException("ByteFilterInputStream: " + this.byteFilterRuntimeException.getMessage(), this.byteFilterRuntimeException);
        }
        return n;
    }

    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            while (true) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

