/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.RunnableWhichThrows;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoUtil {
    private IoUtil() {
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
        out.flush();
    }

    public static RunnableWhichThrows<IOException> copyRunnable(final InputStream in, final OutputStream out) {
        return new RunnableWhichThrows<IOException>(){

            @Override
            public void run() throws IOException {
                IoUtil.copy(in, out);
            }
        };
    }

    public static void copy(Reader r, Writer w) throws IOException {
        int n;
        char[] buffer = new char[4096];
        while ((n = r.read(buffer)) != -1) {
            w.write(buffer, 0, n);
        }
    }

    public static OutputStream tee(final OutputStream ... delegates) {
        return new OutputStream(){

            public void close() throws IOException {
                IOException caughtIOException = null;
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    try {
                        delegate.close();
                    }
                    catch (IOException ioe) {
                        caughtIOException = ioe;
                    }
                    ++n2;
                }
                if (caughtIOException != null) {
                    throw caughtIOException;
                }
            }

            public void flush() throws IOException {
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    delegate.flush();
                    ++n2;
                }
            }

            public void write(byte[] b) throws IOException {
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    delegate.write(b);
                    ++n2;
                }
            }

            public void write(byte[] b, int off, int len) throws IOException {
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    delegate.write(b, off, len);
                    ++n2;
                }
            }

            public void write(int b) throws IOException {
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    delegate.write(b);
                    ++n2;
                }
            }
        };
    }
}

