/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io.charstream;

import de.unkrig.commons.io.charstream.CharStream;
import de.unkrig.commons.io.charstream.UnexpectedCharacterException;
import java.io.IOException;
import java.io.Reader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderCharStream
implements CharStream<IOException> {
    private static final int NONE = -2;
    private final Reader r;
    private int next = -2;

    public ReaderCharStream(Reader r) {
        this.r = r;
    }

    @Override
    public int peek() throws IOException {
        if (this.next == -2) {
            this.next = this.r.read();
        }
        return this.next;
    }

    @Override
    public int peek(int distance) throws IOException {
        if (distance != 0) {
            throw new UnsupportedOperationException("Unsupported peek distance " + distance);
        }
        return this.peek();
    }

    @Override
    public boolean peek(char c) throws IOException {
        if (this.next == -2) {
            this.next = this.r.read();
        }
        return this.next == c;
    }

    @Override
    public int peek(String s) throws IOException {
        if (this.next == -2) {
            this.next = this.r.read();
        }
        return s.indexOf(this.next);
    }

    @Override
    public boolean peekNewline() throws IOException {
        if (this.next == -2) {
            this.next = this.r.read();
        }
        return this.next == 13 || this.next == 10;
    }

    @Override
    public char read() throws IOException, UnexpectedCharacterException {
        if (this.next == -2) {
            this.next = this.r.read();
        }
        if (this.next == -1) {
            throw new UnexpectedCharacterException("Unexpected end-of-input");
        }
        char res = (char)this.next;
        this.next = -2;
        return res;
    }

    @Override
    public void read(char c) throws IOException, UnexpectedCharacterException {
        char c2 = this.read();
        if (c2 != c) {
            throw new UnexpectedCharacterException("'" + c + "' expected instead of '" + c2 + "'");
        }
    }

    @Override
    public int read(String s) throws IOException, UnexpectedCharacterException {
        char c = this.read();
        int res = s.indexOf(c);
        if (res == -1) {
            throw new UnexpectedCharacterException("One of '" + s + "' expected instead of '" + c + "'");
        }
        return res;
    }

    @Override
    public void readNewline() throws IOException, UnexpectedCharacterException {
        if (this.next == -2) {
            this.next = this.r.read();
        }
        if (this.next == 13) {
            this.next = this.r.read();
            if (this.next == 10) {
                this.next = -2;
            }
            return;
        }
        if (this.next == 10) {
            this.next = -2;
            return;
        }
        throw new UnexpectedCharacterException("Newline expected instead of '" + (char)this.next + "'");
    }

    @Override
    public int peekRead() throws IOException {
        if (this.next == -2) {
            this.next = this.r.read();
        }
        return this.next;
    }

    @Override
    public boolean peekRead(char c) throws IOException {
        if (this.next == -2) {
            this.next = this.r.read();
        }
        if (this.next != -1 && (char)this.next == c) {
            this.next = -2;
            return true;
        }
        return false;
    }

    @Override
    public int peekRead(String s) throws IOException {
        int res;
        if (this.next == -2) {
            this.next = this.r.read();
        }
        if (this.next != -1 && (res = s.indexOf((char)this.next)) != -1) {
            this.next = -2;
            return res;
        }
        return -1;
    }

    @Override
    public boolean peekReadNewline() throws IOException {
        if (this.next == -2) {
            this.next = this.r.read();
        }
        if (this.next == 13) {
            this.next = this.r.read();
            if (this.next == 10) {
                this.next = -2;
            }
            return true;
        }
        if (this.next == 10) {
            this.next = -2;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAtEoi() throws IOException {
        if (this.next == -2) {
            this.next = this.r.read();
        }
        return this.next == -1;
    }

    @Override
    public void eoi() throws IOException, UnexpectedCharacterException {
        if (this.next == -2) {
            this.next = this.r.read();
        }
        if (this.next != -1) {
            throw new UnexpectedCharacterException("Unexpected trailing character '" + (char)this.next + "'");
        }
    }
}

