/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net;

import de.unkrig.commons.lang.RunnableWhichThrows;
import de.unkrig.commons.lang.Stoppable;
import de.unkrig.commons.lang.StoppableUtil;
import de.unkrig.commons.net.Server;
import de.unkrig.commons.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseProxy
implements RunnableWhichThrows<IOException>,
Stoppable {
    static final Logger LOGGER = Logger.getLogger(ReverseProxy.class.getName());
    private final Server server;

    public ReverseProxy(InetSocketAddress endpoint, int backlog, final InetSocketAddress serverAddress, final Proxy serverConnectionProxy, final int serverConnectionTimeout, final ProxyConnectionHandler proxyConnectionHandler) throws IOException {
        this.server = new Server(endpoint, backlog, new Server.ClientConnectionHandler(){

            public void handleConnection(InputStream clientIn, OutputStream clientOut, InetSocketAddress clientLocalSocketAddress, InetSocketAddress clientRemoteSocketAddress, Stoppable stoppable) throws IOException {
                Socket serverConnection = new Socket(serverConnectionProxy);
                LOGGER.fine("Connecting with " + serverAddress);
                long t = System.currentTimeMillis();
                try {
                    serverConnection.connect(serverAddress, serverConnectionTimeout);
                }
                catch (SocketTimeoutException ste) {
                    LOGGER.warning("Connecting with " + serverAddress + " timed out after " + (System.currentTimeMillis() - t) + " ms");
                    return;
                }
                catch (IOException ioe) {
                    throw ExceptionUtil.wrap("Connecting with " + serverAddress, ioe);
                }
                try {
                    InetSocketAddress serverLocalSocketAddress = (InetSocketAddress)serverConnection.getLocalSocketAddress();
                    InetSocketAddress serverRemoteSocketAddress = (InetSocketAddress)serverConnection.getRemoteSocketAddress();
                    LOGGER.fine("Connected " + serverLocalSocketAddress + " => " + serverRemoteSocketAddress);
                    proxyConnectionHandler.handleConnection(clientIn, clientOut, serverConnection.getInputStream(), serverConnection.getOutputStream(), clientLocalSocketAddress, clientRemoteSocketAddress, serverLocalSocketAddress, serverRemoteSocketAddress, StoppableUtil.toStoppable(serverConnection));
                }
                finally {
                    try {
                        serverConnection.close();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    @Override
    public void run() throws IOException {
        this.server.run();
    }

    @Override
    public void stop() {
        this.server.stop();
    }

    public static interface ProxyConnectionHandler {
        public void handleConnection(InputStream var1, OutputStream var2, InputStream var3, OutputStream var4, InetSocketAddress var5, InetSocketAddress var6, InetSocketAddress var7, InetSocketAddress var8, Stoppable var9) throws IOException;
    }
}

