/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net;

import de.unkrig.commons.lang.RunnableWhichThrows;
import de.unkrig.commons.lang.Stoppable;
import de.unkrig.commons.lang.StoppableUtil;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements RunnableWhichThrows<IOException>,
Stoppable {
    static final Logger LOGGER = Logger.getLogger(Server.class.getName());
    private final ServerSocket serverSocket;
    final ClientConnectionHandler clientConnectionHandler;
    private static final AtomicInteger connectionCount = new AtomicInteger();

    public Server(InetSocketAddress endpoint, int backlog, ClientConnectionHandler clientConnectionHandler) throws IOException {
        this.clientConnectionHandler = clientConnectionHandler;
        LOGGER.fine("Creating server socket on " + endpoint);
        this.serverSocket = new ServerSocket();
        try {
            this.serverSocket.bind(endpoint, backlog);
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrap("Binding server socket to " + endpoint, ioe);
        }
        LOGGER.fine(this.serverSocket + " created");
    }

    @Override
    public void run() throws IOException {
        while (true) {
            Socket clientConnection;
            LOGGER.fine("Accepting connections on " + this.serverSocket);
            try {
                clientConnection = this.serverSocket.accept();
            }
            catch (SocketTimeoutException ste) {
                LOGGER.fine(this.serverSocket + ": " + ste);
                continue;
            }
            catch (SocketException se) {
                if ("socket closed".equals(se.getMessage()) || "Socket closed".equals(se.getMessage()) || "Socket is closed".equals(se.getMessage())) {
                    LOGGER.fine(this.serverSocket + ": " + se);
                    return;
                }
                throw se;
            }
            try {
                int connectionNumber = connectionCount.incrementAndGet();
                LOGGER.fine("Client connection #" + connectionNumber + " accepted: " + clientConnection);
                final InputStream clientIn = clientConnection.getInputStream();
                final OutputStream clientOut = clientConnection.getOutputStream();
                final InetSocketAddress clientLocalSocketAddress = (InetSocketAddress)clientConnection.getLocalSocketAddress();
                final InetSocketAddress clientRemoteSocketAddress = (InetSocketAddress)clientConnection.getRemoteSocketAddress();
                ThreadUtil.runInBackground(new Runnable(){

                    public void run() {
                        try {
                            try {
                                Server.this.clientConnectionHandler.handleConnection(clientIn, clientOut, clientLocalSocketAddress, clientRemoteSocketAddress, StoppableUtil.toStoppable(clientConnection));
                            }
                            catch (SocketException se) {
                                if ("Connection reset".equals(se.getMessage())) {
                                    LOGGER.fine(se.getMessage());
                                } else if ("Broken pipe".equals(se.getMessage())) {
                                    LOGGER.fine(se.getMessage());
                                } else {
                                    LOGGER.log(Level.INFO, "Exception caught from client connection handler", se);
                                }
                                try {
                                    clientConnection.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                LOGGER.info("Client connection closed");
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.INFO, "Exception caught from client connection handler", e);
                                try {
                                    clientConnection.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                LOGGER.info("Client connection closed");
                            }
                        }
                        finally {
                            try {
                                clientConnection.close();
                            }
                            catch (Exception exception) {}
                            LOGGER.info("Client connection closed");
                        }
                    }
                }, "Connection #" + connectionNumber);
            }
            catch (IOException ioe) {
                try {
                    clientConnection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ioe;
            }
            catch (RuntimeException re) {
                try {
                    clientConnection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw re;
            }
        }
    }

    @Override
    public void stop() {
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface ClientConnectionHandler {
        public void handleConnection(InputStream var1, OutputStream var2, InetSocketAddress var3, InetSocketAddress var4, Stoppable var5) throws IOException;
    }
}

