/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.stringstream;

import de.unkrig.commons.io.objectstream.ObjectStream;
import de.unkrig.commons.io.objectstream.UnexpectedObjectException;
import de.unkrig.commons.util.ProducerUtil;
import de.unkrig.commons.util.ProducerWhichThrows;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringStream<E extends Throwable>
implements ObjectStream<String, E> {
    private ObjectStream<String, E> delegate;

    public StringStream(ProducerWhichThrows<String, E> delegate) {
        this.delegate = ProducerUtil.producerObjectStream(delegate);
    }

    public String[] peekRead(Pattern pattern) throws E {
        String s = this.delegate.peekRead();
        if (s == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(s);
        if (!matcher.matches()) {
            return null;
        }
        String[] groups = new String[matcher.groupCount()];
        int i = 0;
        while (i < groups.length) {
            groups[i] = matcher.group(i + 1);
            ++i;
        }
        return groups;
    }

    public String[] read(Pattern pattern) throws UnexpectedObjectException, E {
        String s = this.delegate.read();
        Matcher matcher = pattern.matcher(s);
        if (!matcher.matches()) {
            throw new UnexpectedObjectException(s);
        }
        String[] groups = new String[matcher.groupCount()];
        int i = 0;
        while (i < groups.length) {
            groups[i] = matcher.group(i + 1);
            ++i;
        }
        return groups;
    }

    @Override
    public boolean peek(Pattern pattern) throws E {
        String s = this.delegate.peek();
        return s != null && pattern.matcher(s).matches();
    }

    @Override
    public String peek() throws E {
        return this.delegate.peek();
    }

    @Override
    public String peek(int distance) throws E {
        return this.delegate.peek(distance);
    }

    @Override
    public boolean peek(String ref) throws E {
        return this.delegate.peek(ref);
    }

    public int peek(String[] refs) throws E {
        return this.delegate.peek((String[])refs);
    }

    @Override
    public String read() throws E, UnexpectedObjectException {
        return this.delegate.read();
    }

    @Override
    public void read(String ref) throws UnexpectedObjectException, E {
        this.delegate.read(ref);
    }

    public int read(String[] refs) throws UnexpectedObjectException, E {
        return this.delegate.read((String[])refs);
    }

    @Override
    public String peekRead() throws E {
        return this.delegate.peekRead();
    }

    @Override
    public boolean peekRead(String ref) throws E {
        return this.delegate.peekRead(ref);
    }

    public int peekRead(String[] refs) throws E {
        return this.delegate.peekRead((String[])refs);
    }

    @Override
    public boolean atEoi() throws E {
        return this.delegate.atEoi();
    }

    @Override
    public void eoi() throws UnexpectedObjectException, E {
        this.delegate.eoi();
    }
}

