/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.filter;

import de.unkrig.commons.lang.protocol.FunctionWhichThrows;
import de.unkrig.commons.lang.protocol.Functions;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.text.pattern.ExpressionMatchReplacer;
import de.unkrig.commons.text.pattern.PatternUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.filters.ChainableReader;

@NotNullByDefault(value=false)
public class ReplaceAllFilter
extends ProjectComponent
implements ChainableReader {
    @Nullable
    private Pattern pattern;
    private FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends IOException> matchReplacer;
    private List<PatternElement> patterns = new ArrayList<PatternElement>();

    public Reader chain(Reader reader) {
        Pattern pattern = this.pattern;
        FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends IOException> matchReplacer = this.matchReplacer;
        if (pattern != null || matchReplacer != null) {
            reader = ReplaceAllFilter.replaceAll(reader, pattern, matchReplacer);
        }
        for (PatternElement pe : this.patterns) {
            reader = ReplaceAllFilter.replaceAll(reader, pe.pattern, pe.matchReplacer);
        }
        return reader;
    }

    private static Reader replaceAll(Reader reader, @Nullable Pattern pattern, @Nullable FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends IOException> matchReplacer) {
        if (pattern == null) {
            throw new BuildException("Pattern missing");
        }
        if (matchReplacer == null) {
            throw new BuildException("Replacement string and expression missing");
        }
        return PatternUtil.replaceAllFilterReader(reader, pattern, matchReplacer);
    }

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public void setReplacementString(String replacementString) {
        if (this.matchReplacer != null) {
            throw new BuildException("More than one replacement");
        }
        this.matchReplacer = PatternUtil.replacementStringMatchReplacer(replacementString);
    }

    public void setReplacementExpression(String replacementExpression) {
        if (this.matchReplacer != null) {
            throw new BuildException("More than one replacement");
        }
        try {
            this.matchReplacer = Functions.asFunctionWhichThrows(ExpressionMatchReplacer.parse(replacementExpression));
        }
        catch (ParseException pe) {
            throw new BuildException((Throwable)pe);
        }
    }

    public void addConfiguredPattern(PatternElement element) {
        if (element.pattern == null) {
            throw new BuildException("Pattern missing");
        }
        if (element.matchReplacer == null) {
            throw new BuildException("Replacement string and expression missing");
        }
        this.patterns.add(element);
    }

    public static class PatternElement {
        @Nullable
        private Pattern pattern;
        @Nullable
        private FunctionWhichThrows<? super MatchResult, ? extends CharSequence, ? extends IOException> matchReplacer;

        public void setPattern(String pattern) {
            if (this.pattern != null) {
                throw new BuildException("\"pattern=...\" and \"<pattern>...</pattern>\" are mutually exclusive");
            }
            this.pattern = Pattern.compile(pattern);
        }

        public void setReplacementString(String replacementString) {
            if (this.matchReplacer != null) {
                throw new BuildException("More than one replacement");
            }
            this.matchReplacer = PatternUtil.replacementStringMatchReplacer(replacementString);
        }

        public void setReplacementExpression(String replacementExpression) {
            if (this.matchReplacer != null) {
                throw new BuildException("More than one replacement");
            }
            try {
                this.matchReplacer = Functions.asFunctionWhichThrows(ExpressionMatchReplacer.parse(replacementExpression));
            }
            catch (ParseException pe) {
                throw new BuildException((Throwable)pe);
            }
        }

        public void addText(String text) {
            if ((text = text.trim()).isEmpty()) {
                return;
            }
            this.setPattern(text);
        }
    }
}

