/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.antology.type.JsonAsProperties;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class JsonPropertyTask
extends Task {
    @Nullable
    private File file;
    private Charset charset = Charset.forName("UTF-8");
    private final JsonAsProperties jsonAsProperties = new JsonAsProperties();

    public void setProject(@Nullable Project project) {
        this.jsonAsProperties.setProject(project);
        super.setProject(project);
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setEncoding(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }

    public void setName(String namePrefix) {
        this.jsonAsProperties.setName(namePrefix);
    }

    public void execute() throws BuildException {
        try {
            if (this.file == null) {
                throw new BuildException("Attribute \"file=...\" missing");
            }
            FileInputStream is = new FileInputStream(this.file);
            try {
                this.jsonAsProperties.execute(new InputStreamReader((InputStream)is, this.charset));
                ((InputStream)is).close();
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

