/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Comparator;
import java.util.Map;

public final class Comparators {
    private static final Comparator<?> NATURAL_ORDER_COMPARATOR = new Comparator<Comparable<Object>>(){

        @Override
        @NotNullByDefault(value=false)
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return c1.compareTo(c2);
        }
    };

    private Comparators() {
    }

    public static <T extends Comparable<T>> Comparator<T> naturalOrderComparator() {
        Comparator<?> tmp = NATURAL_ORDER_COMPARATOR;
        return tmp;
    }

    public static <T extends Comparable<T>> int compareNullSafe(@Nullable T c1, @Nullable T c2) {
        return c1 == null ? (c2 == null ? 0 : -1) : (c2 == null ? 1 : c1.compareTo(c2));
    }

    public static <T> Comparator<T> nullSafeComparator(final Comparator<T> delegate) {
        return new Comparator<T>(){

            @Override
            public int compare(@Nullable T o1, @Nullable T o2) {
                return o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : delegate.compare(o1, o2));
            }
        };
    }

    public static <T> Comparator<Map.Entry<T, ?>> keyComparator(final Comparator<T> delegate) {
        return new Comparator<Map.Entry<T, ?>>(){

            @Override
            @NotNullByDefault(value=false)
            public int compare(Map.Entry<T, ?> e1, Map.Entry<T, ?> e2) {
                return delegate.compare(e1.getKey(), e2.getKey());
            }
        };
    }

    public static <T> Comparator<Map.Entry<?, T>> valueComparator(final Comparator<T> delegate) {
        return new Comparator<Map.Entry<?, T>>(){

            @Override
            @NotNullByDefault(value=false)
            public int compare(Map.Entry<?, T> e1, Map.Entry<?, T> e2) {
                return delegate.compare(e1.getValue(), e2.getValue());
            }
        };
    }
}

