---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux, cellules, tables 
---

# Comment modifier l'alignement des cellules de tableaux ?

Il est souvent nécessaire de modifier l'alignement d'une cellule `p` ("paragraphe") d'un tableau,
mais les problèmes à la fin d'une ligne de tableau sont fréquents. 
La structure suivante avec une cellule `p` risque de provoquer des erreurs 
indiquant un `\noalign` mal placé ou d'autres choses du même genre (voir ainsi 
"[](/2_programmation/erreurs/e/extra_alignment_tab_has_been_changed_to_cr)"). 

```{noedit}
... & \centering blabla ... \\
```

 Le problème est que la commande `\\` signifie différentes choses dans différentes circonstances : 
 l'environnement `tabular` en change la signification en une valeur à utiliser dans le tableau, 
 et `\centering`, `\raggedright` et `\raggedleft` en changent tous la signification 
 en quelque chose d'alors incompatible. 
 Notez que le problème ne se pose que pour la dernière cellule d'une ligne : 
 puisque chaque cellule est placée dans une boîte, 
 ses paramètres sont perdus au moment du `&` (ou `\\`) qui la termine.

Fut un temps, la signification de `\\` utilisée par l'environnement `tabular` n'était disponible 
que sous la forme d'une commande interne. De nos jours, sa valeur est désormais publique, 
et vous pouvez en principe l'utiliser explicitement (même si le nom de commande est un peu long) :

```{noedit}
... & \centering blabla ... \tabularnewline
```

L'extension <ctanpkg:array> fournit une commande \arraybackslash` qui redonne à `\\` 
sa signification correcte (dans le tableau). La commande peut alors être utilisée 
dans les spécifications du préambule du format de tableau de <ctanpkg:array> :

```{noedit}
\begin{tabular}{... >{\centering\arraybackslash}p{50mm}}
...
```

Les commandes `\tabularnewline` et `\arraybackslash` sont des ajouts plutôt récents à LaTeX 
et à l'extension <ctanpkg:array>, respectivement. 
Dans le cas improbable où aucune de ces commandes n'est disponible, 
l'utilisateur peut essayer l'ancienne solution qui préserve la signification de `\\` :

```{noedit}
\newcommand\astuce[1]{\let\temp=\\%
  #1%
  \let\\=\temp
}
```

Elle s'utilise dans un tableau comme :

```{noedit}
... & \astuce\centering blabla ... \\
```

De même, elle peut s'utiliser dans un préambule de tableau :

```{noedit}
\begin{tabular}{...>{\astuce\centering}p{5cm}}
```

:::{sources}
[How to alter the alignment of tabular cells](faquk:FAQ-tabcellalign)
:::