---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, symboles
              intégrale barrée, intégrale de Cauchy, symbole intégrale impropre
---

# Comment obtenir le symbole d'intégrale de la valeur principale de Cauchy ?

Également nommé "intégrale impropre", ce symbole est un signe 
d'intégrale "barré". Il n'apparaît dans aucune des polices habituellement 
disponibles pour les utilisateurs de LaTeX, mais il peut être créé à l'aide 
des commandes suivantes :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

  \def\Xint#1{\mathchoice
   {\XXint\displaystyle\textstyle{#1}}%
   {\XXint\textstyle\scriptstyle{#1}}%
   {\XXint\scriptstyle\scriptscriptstyle{#1}}%
   {\XXint\scriptscriptstyle\scriptscriptstyle{#1}}%
   \!\int}
  \def\XXint#1#2#3{{\setbox0=\hbox{$#1{#2#3}{\int}$}
     \vcenter{\hbox{$#2#3$}}\kern-.5\wd0}}
  \def\ddashint{\Xint=}
  \def\dashint{\Xint-}

\begin{document}
\Large
\[ \dashint{f(x) \mathrm{d} x} \]
\[ \ddashint{f(y) \mathrm{d} y} \]
\end{document}
```

La commande `\dashint` donne un symbole d'intégrale barré d'un simple trait, 
et `\ddashint` donne un symbole barré d'un double trait. On pourra noter ici 
l'utilisation de la commande `\mathchoice` afin que les commandes créées 
puissent bien s'adapter aux différents 
[styles mathématiques](/4_domaines_specialises/mathematiques/styles/les_huit_styles_mathematiques).


Notez que l'exemple ci-dessus charge l'extension <ctanpkg:mathtools> 
(ou <ctanpkg:amsmath>) pour autoriser l'ajustement de la taille 
du symbole d'intégrale si besoin (sur ce point, vous pouvez consulter 
la question 
"[](/4_domaines_specialises/mathematiques/symboles/polices/tailles_des_symboles_en_mode_mathematique)").


:::{sources}
- [The Principal Value Integral symbol](faquk:FAQ-prinvalint),
- [Valeur principale de Cauchy](wpfr:Valeur_principale_de_Cauchy).
:::