
[//000000001]: # (doctools::changelog \- Documentation tools)
[//000000002]: # (Generated from file 'changelog\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (Copyright &copy; 2003\-2013 Andreas Kupries <andreas\_kupries@users\.sourceforge\.net>)
[//000000004]: # (doctools::changelog\(n\) 1\.2 tcllib "Documentation tools")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

doctools::changelog \- Processing text in Emacs ChangeLog format

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [API](#section2)

  - [Bugs, Ideas, Feedback](#section3)

  - [Keywords](#keywords)

  - [Category](#category)

  - [Copyright](#copyright)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.5 9  
package require textutil  
package require doctools::changelog ?1\.2?  

[__::doctools::changelog::scan__ *text*](#1)  
[__::doctools::changelog::flatten__ *entries*](#2)  
[__::doctools::changelog::toDoctools__ *title* *module* *version* *entries*](#3)  
[__::doctools::changelog::merge__ *entries*\.\.\.](#4)  

# <a name='description'></a>DESCRIPTION

This package provides Tcl commands for the processing and reformatting of text
in the "ChangeLog" format generated by
__[emacs](\.\./\.\./\.\./\.\./index\.md\#emacs)__\.

# <a name='section2'></a>API

  - <a name='1'></a>__::doctools::changelog::scan__ *text*

    The command takes the *text* and parses it under the assumption that it
    contains a ChangeLog as generated by
    __[emacs](\.\./\.\./\.\./\.\./index\.md\#emacs)__\. It returns a data structure
    describing the contents of this ChangeLog\.

    This data structure is a list where each element describes one entry in the
    ChangeLog\. Each element/entry is then a list of three elements describing
    the date of the entry, its author, and the comments made, in this order\. The
    last item in each element/entry, the comments, is a list of sections\. Each
    section is described by a list containing two elements, a list of file
    names, and a string containing the true comment associated with the files of
    the section\.

            {
        	{
        	    date
        	    author
        	    {
        		{
        		    {file ...}
        		    commenttext
        		}
        		...
        	    }
        	}
        	{...}
            }

  - <a name='2'></a>__::doctools::changelog::flatten__ *entries*

    This command converts a list of entries as generated by __change::scan__
    above into a simpler list of plain text blocks each containing all the
    information of a single entry\.

  - <a name='3'></a>__::doctools::changelog::toDoctools__ *title* *module* *version* *entries*

    This command converts the pre\-parsed ChangeLog *entries* as generated by
    the command __::doctools::changelog::scan__ into a document in
    *[doctools](\.\./\.\./\.\./\.\./index\.md\#doctools)* format and returns it as
    the result of the command\.

    The other three arguments supply the information for the header of that
    document which is not available from the changelog itself\.

  - <a name='4'></a>__::doctools::changelog::merge__ *entries*\.\.\.

    Each argument of the command is assumed to be a pre\-parsed Changelog as
    generated by the command __::doctools::changelog::scan__\. This command
    merges all of them into a single structure, and collapses multiple entries
    for the same date and author into a single entry\. The new structure is
    returned as the result of the command\.

# <a name='section3'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *doctools* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='keywords'></a>KEYWORDS

[changelog](\.\./\.\./\.\./\.\./index\.md\#changelog),
[doctools](\.\./\.\./\.\./\.\./index\.md\#doctools),
[emacs](\.\./\.\./\.\./\.\./index\.md\#emacs)

# <a name='category'></a>CATEGORY

Documentation tools

# <a name='copyright'></a>COPYRIGHT

Copyright &copy; 2003\-2013 Andreas Kupries <andreas\_kupries@users\.sourceforge\.net>
