/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.chart;

import com.jgoodies.chart.AbstractChart;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.Paddings;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public final class ChartView<T> {
    private final AbstractChart<T> chart;
    private final boolean padded;
    private final String caption;
    private JLabel captionLabel;
    private T selection;

    public ChartView(AbstractChart<T> chart, boolean padded, String caption) {
        this.chart = chart;
        this.padded = padded;
        this.caption = caption;
        this.initComponents();
        this.initEventHandling();
    }

    private void initComponents() {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        if (this.caption != null) {
            this.captionLabel = factory.createHeaderLabel(this.caption);
        }
    }

    private void initEventHandling() {
        this.chart.addMouseListener(new ChartSelectionHandler());
    }

    public JComponent buildPanel() {
        JPanel panel = ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("fill:default:grow", new Object[0])).rows("p, f:p:g", new Object[0])).padding(this.padded ? Paddings.DLU14 : null)).add(this.caption != null, this.captionLabel).xy(1, 1, "center, top")).add(this.chart).xy(1, 2)).build();
        panel.setCursor(Cursor.getDefaultCursor());
        return panel;
    }

    public void addMotionAdapters() {
        this.chart.addMouseMotionListener(new ChartMotionHandler());
    }

    protected void doSelect() {
        this.chart.setCursor(Cursor.getDefaultCursor());
    }

    public AbstractChart<T> getChart() {
        return this.chart;
    }

    public T getSelectedValue() {
        return this.selection;
    }

    public boolean isSelectable(T data) {
        return null != data;
    }

    void setChartCursor(Point p) {
        T data = this.chart.getDataAt(p);
        int cursorType = this.isSelectable(data) ? 12 : 0;
        this.chart.setCursor(Cursor.getPredefinedCursor(cursorType));
    }

    public void setSelectedValue(T newSelection) {
        this.selection = newSelection;
    }

    public void setToolTipEnabled(boolean enabled) {
        this.getChart().setToolTipText(enabled ? "" : null);
    }

    private final class ChartMotionHandler
    extends MouseMotionAdapter {
        private ChartMotionHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ChartView.this.setChartCursor(e.getPoint());
        }
    }

    private final class ChartSelectionHandler
    extends MouseAdapter {
        private ChartSelectionHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point p;
            if (!SwingUtilities.isLeftMouseButton(e) || e.isPopupTrigger() || e.isConsumed()) {
                return;
            }
            AbstractChart aChart = (AbstractChart)e.getSource();
            Object data = aChart.getDataAt(p = e.getPoint());
            if (!ChartView.this.isSelectable(data)) {
                return;
            }
            ChartView.this.setSelectedValue(data);
            ChartView.this.doSelect();
            ChartView.this.setChartCursor(p);
        }
    }
}

