/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.misc;

import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.jsdl.action.ActionBuilder;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.basics.AbstractPane;
import com.jgoodies.dialogs.basics.BasicDialogResources;
import com.jgoodies.dialogs.basics.misc.TipOfTheDayModel;
import com.jgoodies.dialogs.core.AspectRatio;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.LayoutType;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.Verification;
import com.jgoodies.dialogs.core.pane.task.TaskPane;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.dialogs.core.util.JSDLUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.EventObject;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.UIManager;

public final class TipOfTheDayPane
extends AbstractPane {
    private final TipOfTheDayModel model;
    private JEditorPane contentPane;

    public TipOfTheDayPane(Preferences tipIndexPrefs, List<URL> tips) {
        this(new ListTipOfTheDayModel(tipIndexPrefs, tips));
    }

    public TipOfTheDayPane(Preferences tipIndexPrefs, ResourceMap tipResources, String tipResourceKeyPrefix) {
        this(new ResourceTipOfTheDayModel(tipIndexPrefs, tipResources, tipResourceKeyPrefix), null);
    }

    public TipOfTheDayPane(Preferences tipIndexPrefs, ResourceMap tipResources, String tipResourceKeyPrefix, ResourceMap paneResources) {
        this(new ResourceTipOfTheDayModel(tipIndexPrefs, tipResources, tipResourceKeyPrefix), paneResources);
    }

    public TipOfTheDayPane(TipOfTheDayModel model) {
        this(model, null);
    }

    public TipOfTheDayPane(TipOfTheDayModel model, ResourceMap resources) {
        super(resources);
        this.model = model;
        this.initComponents();
    }

    protected void initComponents() {
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        this.contentPane = (JEditorPane)factory.createStaticText("<html>Initial content</html>", new Object[0]);
        this.goNext();
    }

    public void showDialog(EventObject evt, Verification verification) {
        this.showDialog(JSDLUtils.getWindowFor(evt), verification);
    }

    public void showDialog(Component owner, Verification verification) {
        ((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder(this.buildPane(verification)).owner(owner)).title(this.getResources().getString("TipOfTheDayPane.title", new Object[0]), new Object[0])).showDialog();
    }

    public TaskPane buildPane(Verification verification) {
        return ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().mainInstructionIcon(UIManager.getIcon("OptionPane.informationIcon")).mainInstructionText(this.getResources().getString("TipOfTheDayPane.mainInstruction", new Object[0]), new Object[0]).content(this.contentPane).commitCommands(CommandValue.CLOSE).additionalCommands(this.getNextAction()).verification(verification).initialFocusVisible(false)).preferredWidth(PreferredWidth.MEDIUM)).aspectRatio(AspectRatio.NARROW)).layoutType(LayoutType.WIDE)).build();
    }

    private void onNextPerformed(ActionEvent e) {
        this.goNext();
    }

    private void goNext() {
        URL nextTip = this.model.nextTip();
        try {
            this.contentPane.setPage(nextTip);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).warning("Can't show tip URL: " + nextTip);
        }
    }

    private Action getNextAction() {
        return new ActionBuilder().handler(this::onNextPerformed).text(this.getResources().getString("TipOfTheDayPane.next.Action.text", new Object[0]), new Object[0]).accessibleName(this.getResources().getString("TipOfTheDayPane.next.Action.accessibleName", new Object[0])).build();
    }

    @Override
    protected Class<?> getResourceProviderClass() {
        return BasicDialogResources.class;
    }

    public static abstract class AbstractTipOfTheDayModel
    implements TipOfTheDayModel {
        private static final String TIP_INDEX_KEY = "tipIndex";
        private static final int TIP_INDEX_DEFAULT = 0;
        private final Preferences preferences;

        public AbstractTipOfTheDayModel(Preferences tipIndexPrefs) {
            this.preferences = tipIndexPrefs;
        }

        @Override
        public URL nextTip() {
            int index = this.getTipIndex();
            if (++index >= this.tipCount()) {
                index = 0;
            }
            this.setTipIndex(index);
            return this.getTip(index);
        }

        protected abstract URL getTip(int var1);

        protected abstract int tipCount();

        private int getTipIndex() {
            return this.preferences.getInt(TIP_INDEX_KEY, 0);
        }

        private void setTipIndex(int index) {
            this.preferences.putInt(TIP_INDEX_KEY, index);
        }
    }

    public static class ListTipOfTheDayModel
    extends AbstractTipOfTheDayModel {
        private final List<URL> tips;

        public ListTipOfTheDayModel(Preferences tipIndexPrefs, List<URL> tips) {
            super(tipIndexPrefs);
            this.tips = tips;
        }

        @Override
        protected URL getTip(int index) {
            return this.tips.get(index);
        }

        @Override
        protected int tipCount() {
            return this.tips.size();
        }
    }

    public static class ResourceTipOfTheDayModel
    extends AbstractTipOfTheDayModel {
        private final ResourceMap resources;
        private final String resourceKeyPrefix;

        public ResourceTipOfTheDayModel(Preferences tipIndexPrefs, ResourceMap resources, String resourceKeyPrefix) {
            super(tipIndexPrefs);
            this.resources = resources;
            this.resourceKeyPrefix = resourceKeyPrefix;
        }

        @Override
        protected URL getTip(int index) {
            String tipPathKey = this.resourceKeyPrefix + ".[" + index + ']';
            return this.resources.getURL(tipPathKey);
        }

        @Override
        protected int tipCount() {
            String tipCountKey = this.resourceKeyPrefix + ".tipCount";
            return this.resources.getInt(tipCountKey);
        }
    }
}

