/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.property;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.components.JGCardPanel;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.CoreDialogResources;
import com.jgoodies.dialogs.core.internal.PropertyPaneAction;
import com.jgoodies.dialogs.core.internal.TabInfo;
import com.jgoodies.dialogs.core.pane.property.PropertyPane;
import com.jgoodies.dialogs.core.pane.property.PropertyPaneModel;
import com.jgoodies.layout.builder.FormBuilder;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class TreePropertyPane
extends PropertyPane {
    private static final String UI_CLASS_ID = "JSDL.TreePropertyPaneUI";
    private final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(new TabInfo("Root", null));
    private final DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    private JTree tabTree;
    private JLabel titleLabel;
    private JGCardPanel cardPanel;

    public TreePropertyPane() {
        this(CommandValue.OK, CommandValue.CANCEL);
    }

    public TreePropertyPane(Object okObject, Object cancelObject) {
        this(new Object[]{okObject, cancelObject});
    }

    public TreePropertyPane(Object okObject, Object cancelObject, Object applyObject) {
        this(new Object[]{okObject, cancelObject, applyObject});
    }

    public TreePropertyPane(PropertyPaneModel model) {
        this(PropertyPaneAction.createOKCancelApplyActionsFor(model));
    }

    private TreePropertyPane(Object[] commitObjects) {
        super(null, commitObjects);
        this.setContent(this.buildContent());
    }

    public DefaultMutableTreeNode addTab(String plainTabText, JComponent tabComponent) {
        return this.addTabImpl(null, plainTabText, null, tabComponent);
    }

    public DefaultMutableTreeNode addTab(String plainTabText, String markedTitleText, JComponent tabComponent) {
        Preconditions.checkNotBlank(markedTitleText, "The %s must not be null, empty, or whitespace.", "title text");
        return this.addTabImpl(null, plainTabText, markedTitleText, tabComponent);
    }

    public DefaultMutableTreeNode addTab(DefaultMutableTreeNode parent, String plainTabText, JComponent tabComponent) {
        return this.addTabImpl(parent, plainTabText, null, tabComponent);
    }

    public DefaultMutableTreeNode addTab(DefaultMutableTreeNode parent, String plainTabText, String markedTitleText, JComponent tabComponent) {
        Preconditions.checkNotNull(parent, "The %s must not be null.", "parent");
        Preconditions.checkNotBlank(markedTitleText, "The %s must not be null, empty, or whitespace.", "title text");
        return this.addTabImpl(parent, plainTabText, markedTitleText, tabComponent);
    }

    DefaultMutableTreeNode addTabImpl(DefaultMutableTreeNode parent, String plainTabText, String markedTitleText, JComponent tabComponent) {
        Preconditions.checkNotNull(tabComponent, "The %s must not be null.", "tab component");
        Preconditions.checkNotBlank(plainTabText, "The %s must not be null, empty, or whitespace.", "tab text");
        this.cardPanel.add(plainTabText, tabComponent);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new TabInfo(plainTabText, markedTitleText));
        if (parent == null) {
            parent = this.rootNode;
        }
        parent.add(newNode);
        this.treeModel.nodesWereInserted(parent, new int[]{parent.getChildCount() - 1});
        if (parent != this.rootNode && this.tabTree.getSelectionCount() == 0) {
            this.tabTree.expandPath(new TreePath(parent.getPath()));
            this.tabTree.setSelectionPath(new TreePath(newNode.getPath()));
        }
        this.tabTree.setVisibleRowCount(this.tabTree.getRowCount());
        return newNode;
    }

    public void expandTopLevel() {
        Enumeration<TreeNode> e = this.rootNode.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)e.nextElement();
            this.tabTree.expandPath(new TreePath(treeNode.getPath()));
        }
    }

    public void setShowRootHandles(boolean b) {
        this.tabTree.setShowsRootHandles(b);
    }

    public void setSelectionRow(int rowIndex) {
        this.tabTree.setSelectionRow(rowIndex);
    }

    @Override
    protected String layoutGroup() {
        return "ListPropertyPane";
    }

    private void initComponents() {
        this.tabTree = new TabTree(this.treeModel);
        this.tabTree.getSelectionModel().setSelectionMode(1);
        this.tabTree.setRootVisible(false);
        this.tabTree.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.tabTree.setShowsRootHandles(true);
        this.tabTree.setCellRenderer(new TabTreeCellRenderer());
        this.tabTree.getAccessibleContext().setAccessibleName(CoreDialogResources.getString("TreePropertyPane.tabTree.accessibleName"));
        this.tabTree.getAccessibleContext().setAccessibleDescription(CoreDialogResources.getString("TreePropertyPane.tabTree.accessibleDescription"));
        this.titleLabel = JGComponentFactory.getCurrent().createLabel("Tab Title");
        this.titleLabel.setFont(UIManager.getFont("ListPropertyPane.tabTitle.font"));
        this.titleLabel.setForeground(UIManager.getColor("ListPropertyPane.tabTitle.foreground"));
        this.cardPanel = new JGCardPanel();
        this.cardPanel.setOpaque(false);
    }

    private void initEventHandling() {
        this.tabTree.getSelectionModel().addTreeSelectionListener(this::onTreeSelectionChanged);
    }

    private JComponent buildContent() {
        this.initComponents();
        this.initEventHandling();
        int gapListTabs = UIManager.getInt("ListPropertyPane.default.gap.listTabs");
        int gapTitleTabs = UIManager.getInt("ListPropertyPane.default.gap.titleTabs");
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("[75dlu,pref], %sdlu, pref:grow", gapListTabs)).rows("p, %sdlu, fill:[180dlu,p]:grow", gapTitleTabs)).add(this.tabTree).xywh(1, 1, 1, 3)).add(this.titleLabel).xy(3, 1)).add(this.cardPanel).xy(3, 3)).build();
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    private void onTreeSelectionChanged(TreeSelectionEvent evt) {
        TabInfo tab = this.getSelectedTab();
        if (tab != null) {
            this.setTabTitle(tab);
            this.setTab(tab);
        }
    }

    private TabInfo getSelectedTab() {
        TreePath selectionPath = this.tabTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        Object selection = selectionPath.getLastPathComponent();
        if (selection == null) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selection;
        return (TabInfo)selectedNode.getUserObject();
    }

    private void setTabTitle(TabInfo info) {
        if (info.getMarkedTitleText() != null) {
            MnemonicUtils.configure(this.titleLabel, info.getMarkedTitleText());
        } else {
            this.titleLabel.setText(info.getTabText());
        }
    }

    private void setTab(TabInfo info) {
        this.cardPanel.showCard(info.getTabText());
    }

    static final class TabTree
    extends JTree {
        TabTree(TreeModel model) {
            super(model);
        }

        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            TabInfo info = (TabInfo)node.getUserObject();
            return super.convertValueToText(info.getTabText(), selected, expanded, leaf, row, hasFocus);
        }
    }

    static final class TabTreeCellRenderer
    extends DefaultTreeCellRenderer {
        TabTreeCellRenderer() {
            this.setOpenIcon(null);
            this.setClosedIcon(null);
            this.setLeafIcon(null);
        }
    }
}

