/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tiles;

import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.internal.VisibilityUtils;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.fluent.tiles.AbstractTileView;
import com.jgoodies.fluent.tiles.ObjectTile;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.layout.CellConstraints;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class ObjectTileView
extends AbstractTileView<ObjectTile> {
    private JLabel titleLabel;
    private JTextArea subtitleArea;
    private JLabel numberLabel;
    private JLabel numberUnitLabel;

    public ObjectTileView(ObjectTile tile) {
        super(tile);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        Color foreground = ((ObjectTile)this.tile).getForeground();
        this.titleLabel = factory.createLabel();
        this.titleLabel.setFont(this.getTitleFont());
        this.titleLabel.setForeground(foreground);
        this.subtitleArea = (JTextArea)factory.createStaticText("Static text", new Object[0]);
        this.subtitleArea.setWrapStyleWord(true);
        this.subtitleArea.setLineWrap(true);
        this.subtitleArea.setFont(this.getBaseFont());
        this.subtitleArea.setForeground(foreground);
        this.numberLabel = factory.createLabel();
        this.numberLabel.setFont(this.getTitleFont());
        this.numberLabel.setForeground(foreground);
        this.numberUnitLabel = factory.createLabel();
        this.numberUnitLabel.setFont(this.getBaseFont());
        this.numberUnitLabel.setForeground(foreground);
    }

    @Override
    protected JPanel build() {
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("6epx, fill:pref:grow, 5epx", new Object[0])).rows("1epx, p, f:d:g, p, 4epx", new Object[0])).panel(this.panel)).border(this.outerBorder)).add(this.buildTitleBar()).xy(2, 2)).add(this.buildSubtitleBar()).xy(2, 3)).add(this.logoInContent(), this.logoLabel).at(new CellConstraints(2, 2, 1, 3, CellConstraints.CENTER, CellConstraints.CENTER, ((ObjectTile)this.tile).getLogoInsets()))).add(this.buildBrandingBar()).xy(2, 4)).build();
    }

    private JPanel buildTitleBar() {
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("left:0:grow, 2epx, pref", new Object[0])).rows("p", new Object[0])).add(this.titleLabel).xy(1, 1)).add(this.numberLabel).xy(3, 1)).build();
    }

    private JPanel buildSubtitleBar() {
        boolean hasUnit = Strings.isNotBlank(this.numberUnitLabel.getText());
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("left:default:grow, 0, 2epx, pref", new Object[0])).rows("top:d:g", new Object[0])).add(hasUnit, this.subtitleArea).xyw(1, 1, 2)).add(!hasUnit, this.subtitleArea).xyw(1, 1, 4)).add(this.numberUnitLabel).xy(4, 1)).build();
    }

    @Override
    protected boolean contentSet() {
        return Strings.isNotEmpty(((ObjectTile)this.getTile()).getTitle()) || Strings.isNotEmpty(((ObjectTile)this.getTile()).getSubtitle());
    }

    @Override
    protected void onTilePropertyChanged(PropertyChangeEvent evt) {
        super.onTilePropertyChanged(evt);
        if (ObjectTileView.matches(evt, "title", "foreground")) {
            VisibilityUtils.setTextAndVisibilityAndForeground(this.titleLabel, ((ObjectTile)this.tile).getTitle(), ((ObjectTile)this.tile).getForeground());
        }
        if (ObjectTileView.matches(evt, "subtitle", "foreground")) {
            String subtitle = ((ObjectTile)this.tile).getSubtitle();
            VisibilityUtils.setTextAndVisibilityAndForeground(this.subtitleArea, subtitle == null ? null : subtitle, ((ObjectTile)this.tile).getForeground());
        }
        if (ObjectTileView.matches(evt, "number", "foreground")) {
            VisibilityUtils.setTextAndVisibilityAndForeground(this.numberLabel, ((ObjectTile)this.tile).getNumber(), ((ObjectTile)this.tile).getForeground());
        }
        if (ObjectTileView.matches(evt, "numberUnit", "foreground")) {
            VisibilityUtils.setTextAndVisibilityAndForeground(this.numberUnitLabel, ((ObjectTile)this.tile).getNumberUnit(), ((ObjectTile)this.tile).getForeground());
        }
    }

    @Override
    protected int getEffectiveLogoSize() {
        return this.logoInContent() ? 32 : 16;
    }
}

