/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.shared.format;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;

public final class JDFormats {
    public static final Format KILOBYTE_FORMAT = new KilobytesFormat();
    public static final Format FILE_COUNT_FORMAT = new FileCountFormat();
    private static final Format DATE_FORMAT = JDFormats.createDateFormat();
    private static final Format DATE_TIME_FORMAT = JDFormats.createDateTimeFormat();
    private static final Format PERCENT_FORMAT = JDFormats.createPercentFormat();
    private static final Format PERCENT_FORMAT_CELL = JDFormats.createPercentFormatCell();
    private static final Format SIZE_FORMAT_LONG = JDFormats.createSizeFormatShort();
    private static final Format SIZE_FORMAT_FRACTION = JDFormats.createSizeFormatFraction();
    public static final Format COUNT_FORMAT_LONG = JDFormats.createCountFormatShort();
    private static final Format COUNT_FORMAT_FRACTION = JDFormats.createCountFormatFraction();
    private static final char SEPARATOR_CHAR = '\u202f';
    private static final ResourceMap RESOURCES = Application.getResourceMap(JDFormats.class);

    private JDFormats() {
    }

    public static String formatDate(long date) {
        return date == -1L ? "" : DATE_FORMAT.format(new Date(date));
    }

    public static String formatDateTime(Long date) {
        return date == null ? "" : DATE_TIME_FORMAT.format(new Date(date));
    }

    public static String formatPercent(double value) {
        if (value == 0.0) {
            return "\u2013";
        }
        if (value < 0.1) {
            return "< " + JDFormats.formatPercent0(0.1);
        }
        if (value == 1.0) {
            return "100\u202f%";
        }
        if (value > 0.999) {
            return "> " + JDFormats.formatPercent0(99.9);
        }
        return JDFormats.formatPercent0(value * 100.0);
    }

    private static String formatPercent0(double value) {
        return PERCENT_FORMAT.format(value) + '\u202f' + '%';
    }

    public static String formatPercentForCell(double value) {
        if (value == 0.0) {
            return "\u2013";
        }
        if (value < 0.1) {
            return "< " + JDFormats.formatPercentForCell0(0.1);
        }
        if (value == 1.0) {
            return "100";
        }
        if (value > 0.999) {
            return "> " + JDFormats.formatPercentForCell0(99.9);
        }
        return JDFormats.formatPercentForCell0(value * 100.0);
    }

    private static String formatPercentForCell0(double value) {
        return PERCENT_FORMAT.format(value);
    }

    public static String formatSize(long size) {
        if (size == 0L) {
            return "";
        }
        long kilobytes = (1023L + size) / 1024L;
        return JDFormats.formatFileSize0(kilobytes) + '\u202f' + JDFormats.sizeUnit(kilobytes);
    }

    public static String formatSizeForTreeCell(long size) {
        if (size < 0x100000L) {
            return "";
        }
        long kilobytes = (1023L + size) / 1024L;
        return JDFormats.formatFileSize0(kilobytes) + JDFormats.sizeTreeCellSpace(kilobytes) + JDFormats.sizeUnit(kilobytes);
    }

    public static String formatSizeForTableCell(Long size) {
        if (size == 0L) {
            return "";
        }
        long kilobytes = (1023L + size) / 1024L;
        return JDFormats.formatFileSize0(kilobytes) + JDFormats.sizeTableCellSpace(kilobytes) + JDFormats.sizeUnit(kilobytes);
    }

    public static String formatCount(long count) {
        if (count == 0L) {
            return null;
        }
        if (count < 0x100000L) {
            return JDFormats.formatCount0(count);
        }
        if (count < 0x40000000L) {
            return JDFormats.formatCount0((float)count / 1048576.0f) + '\u202f' + RESOURCES.getString("Formats.million", new Object[0]);
        }
        return JDFormats.formatCount0((float)count / 1.0737418E9f) + '\u202f' + RESOURCES.getString("Formats.billion", new Object[0]);
    }

    public static String formatCountForCell(Long count) {
        return JDFormats.formatCount0(count);
    }

    private static String formatFileSize0(long kilobytes) {
        if (kilobytes < 1024L) {
            return JDFormats.formatSize0(kilobytes);
        }
        if (kilobytes < 0x100000L) {
            return JDFormats.formatSize0((float)kilobytes / 1024.0f);
        }
        if (kilobytes < 0x40000000L) {
            return JDFormats.formatSize0((float)kilobytes / 1048576.0f);
        }
        if (kilobytes < 0x10000000000L) {
            return JDFormats.formatSize0((float)kilobytes / 1.0737418E9f);
        }
        return JDFormats.formatSize0((float)kilobytes / 1.0995116E12f);
    }

    private static String formatSize0(long kilobytes) {
        return SIZE_FORMAT_LONG.format(kilobytes);
    }

    private static String formatSize0(float sizeFraction) {
        return SIZE_FORMAT_FRACTION.format(Float.valueOf(sizeFraction));
    }

    private static String formatCount0(long count) {
        if (count == 0L) {
            return "";
        }
        return COUNT_FORMAT_LONG.format(count);
    }

    private static String formatCount0(float countFraction) {
        return COUNT_FORMAT_FRACTION.format(Float.valueOf(countFraction));
    }

    private static String sizeTableCellSpace(long kilobytes) {
        if (kilobytes < 1024L) {
            return " ";
        }
        if (kilobytes < 0x100000L) {
            return "   \u202f";
        }
        if (kilobytes < 0x40000000L) {
            return "           \u202f";
        }
        if (kilobytes < 0x10000000000L) {
            return "                  \u202f";
        }
        return "                         \u202f";
    }

    private static String sizeTreeCellSpace(long kilobytes) {
        if (kilobytes < 0x100000L) {
            return "\u202f";
        }
        if (kilobytes < 0x40000000L) {
            return "        \u202f";
        }
        if (kilobytes < 0x10000000000L) {
            return "               \u202f";
        }
        return "                      \u202f";
    }

    private static String sizeUnit(long kilobytes) {
        if (kilobytes < 1024L) {
            return "KB";
        }
        if (kilobytes < 0x100000L) {
            return "MB";
        }
        if (kilobytes < 0x40000000L) {
            return "GB";
        }
        if (kilobytes < 0x10000000000L) {
            return "TB";
        }
        return "PB";
    }

    private static Format createDateFormat() {
        return DateFormat.getDateInstance(3);
    }

    private static Format createDateTimeFormat() {
        return DateFormat.getDateTimeInstance(3, 3);
    }

    private static Format createPercentFormat() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(1);
        format.setMinimumFractionDigits(1);
        return format;
    }

    private static Format createPercentFormatCell() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(1);
        format.setMinimumFractionDigits(1);
        return format;
    }

    private static Format createSizeFormatShort() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setGroupingUsed(true);
        format.setMaximumFractionDigits(0);
        return format;
    }

    private static Format createSizeFormatFraction() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setGroupingUsed(true);
        format.setMaximumFractionDigits(1);
        format.setMinimumFractionDigits(1);
        return format;
    }

    private static Format createCountFormatShort() {
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(true);
        return format;
    }

    private static Format createCountFormatFraction() {
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(true);
        format.setMaximumFractionDigits(1);
        format.setMinimumFractionDigits(1);
        return format;
    }

    private static final class FileCountFormat
    extends Format {
        private FileCountFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            long value = (Long)obj;
            if (value == 0L) {
                return toAppendTo;
            }
            toAppendTo.append(JDFormats.formatCount(value));
            toAppendTo.append('\u202f');
            String key = value == 1L ? "Formats.file" : "Formats.files";
            toAppendTo.append(RESOURCES.getString(key, new Object[0]));
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException("KilobytesFormat can't parse.");
        }
    }

    private static final class KilobytesFormat
    extends Format {
        private KilobytesFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            long value = (Long)obj;
            toAppendTo.append(JDFormats.formatSize(value));
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException("KilobytesFormat can't parse.");
        }
    }
}

