/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.layout.layout;

import com.jgoodies.layout.layout.FormLayout;
import com.jgoodies.layout.layout.Size;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import java.util.Locale;

public enum ComponentSize implements Size
{
    MINIMUM(false),
    PREFERRED(false),
    DEFAULT(true);

    private final boolean compressible;

    private ComponentSize(boolean compressible) {
        this.compressible = compressible;
    }

    static ComponentSize decode(String str) {
        switch (str) {
            case "pref": 
            case "p": {
                return PREFERRED;
            }
            case "default": 
            case "d": {
                return DEFAULT;
            }
            case "min": 
            case "m": {
                return MINIMUM;
            }
        }
        return null;
    }

    @Override
    public int maximumSize(Container container, List<Component> components, FormLayout.ComponentSizeCache sizeCache, FormLayout.Measure minMeasure, FormLayout.Measure prefMeasure, FormLayout.Measure defaultMeasure, boolean horizontal) {
        FormLayout.Measure measure = this == MINIMUM ? minMeasure : (this == PREFERRED ? prefMeasure : defaultMeasure);
        int maximum = 0;
        for (Component c : components) {
            maximum = Math.max(maximum, measure.sizeOf(c, sizeCache));
        }
        return maximum;
    }

    @Override
    public boolean compressible() {
        return this.compressible;
    }

    public String toString() {
        return this.encode();
    }

    @Override
    public String encode() {
        return this.name().substring(0, 1).toLowerCase(Locale.ENGLISH);
    }
}

