/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;

public class NativeJavaPackage
extends ScriptableObject {
    static final long serialVersionUID = 7445054382212031523L;
    private String packageName;
    private transient ClassLoader classLoader;
    private Set<String> negativeCache = null;

    NativeJavaPackage(boolean bl, String string, ClassLoader classLoader) {
        this.packageName = string;
        this.classLoader = classLoader;
    }

    @Deprecated
    public NativeJavaPackage(String string, ClassLoader classLoader) {
        this(false, string, classLoader);
    }

    @Deprecated
    public NativeJavaPackage(String string) {
        this(false, string, Context.getCurrentContext().getApplicationClassLoader());
    }

    @Override
    public String getClassName() {
        return "JavaPackage";
    }

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return true;
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return false;
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        throw Context.reportRuntimeError0("msg.pkg.int");
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        return this.getPkgProperty(string, scriptable, true);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        return NOT_FOUND;
    }

    NativeJavaPackage forcePackage(String string, Scriptable scriptable) {
        Object object = super.get(string, (Scriptable)this);
        if (object != null && object instanceof NativeJavaPackage) {
            return (NativeJavaPackage)object;
        }
        String string2 = this.packageName.length() == 0 ? string : this.packageName + "." + string;
        NativeJavaPackage nativeJavaPackage = new NativeJavaPackage(true, string2, this.classLoader);
        ScriptRuntime.setObjectProtoAndParent(nativeJavaPackage, scriptable);
        super.put(string, (Scriptable)this, (Object)nativeJavaPackage);
        return nativeJavaPackage;
    }

    synchronized Object getPkgProperty(String string, Scriptable scriptable, boolean bl) {
        Serializable serializable;
        Object object = super.get(string, scriptable);
        if (object != NOT_FOUND) {
            return object;
        }
        if (this.negativeCache != null && this.negativeCache.contains(string)) {
            return null;
        }
        String string2 = this.packageName.length() == 0 ? string : this.packageName + '.' + string;
        Context context = Context.getContext();
        ClassShutter classShutter = context.getClassShutter();
        Object object2 = null;
        if (classShutter == null || classShutter.visibleToScripts(string2)) {
            serializable = null;
            serializable = this.classLoader != null ? Kit.classOrNull(this.classLoader, string2) : Kit.classOrNull(string2);
            if (serializable != null) {
                WrapFactory wrapFactory = context.getWrapFactory();
                object2 = wrapFactory.wrapJavaClass(context, NativeJavaPackage.getTopLevelScope(this), (Class<?>)serializable);
                object2.setPrototype(this.getPrototype());
            }
        }
        if (object2 == null) {
            if (bl) {
                serializable = new NativeJavaPackage(true, string2, this.classLoader);
                ScriptRuntime.setObjectProtoAndParent(serializable, this.getParentScope());
                object2 = serializable;
            } else {
                if (this.negativeCache == null) {
                    this.negativeCache = new HashSet<String>();
                }
                this.negativeCache.add(string);
            }
        }
        if (object2 != null) {
            super.put(string, scriptable, object2);
        }
        return object2;
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return this.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.classLoader = Context.getCurrentContext().getApplicationClassLoader();
    }

    public String toString() {
        return "[JavaPackage " + this.packageName + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof NativeJavaPackage) {
            NativeJavaPackage nativeJavaPackage = (NativeJavaPackage)object;
            return this.packageName.equals(nativeJavaPackage.packageName) && this.classLoader == nativeJavaPackage.classLoader;
        }
        return false;
    }

    public int hashCode() {
        return this.packageName.hashCode() ^ (this.classLoader == null ? 0 : this.classLoader.hashCode());
    }
}

