/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;

@Deprecated
public final class ConCatRepository {
    private File repositoryDirectory;
    private File outFile;
    private boolean forceOverwrite = false;

    public static void usage() {
        System.out.println("Usage: ");
        System.out.println(ConCatRepository.class.getSimpleName() + " JFR Repository directory [-o <outfile>]");
        System.out.println("optional -o: output filename");
        System.out.println("optional -f: force file overwrite");
    }

    public static void main(String[] stringArray) throws Exception {
        ConCatRepository conCatRepository = new ConCatRepository();
        conCatRepository.loadFiles(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFiles(String[] stringArray) throws IOException, FileNotFoundException {
        if (stringArray.length == 0) {
            this.repositoryDirectory = new File(".");
        } else if (!this.parseArgs(stringArray)) {
            return;
        }
        if (!this.repositoryDirectory.exists()) {
            ConCatRepository.usage();
            throw new FileNotFoundException("Could not find jfr repository " + this.repositoryDirectory);
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".jfr");
            }
        };
        Object[] objectArray = this.repositoryDirectory.list(filenameFilter);
        if (0 == objectArray.length) {
            ConCatRepository.usage();
            throw new FileNotFoundException("Could not find any incomplete flight recordings in the specified directory");
        }
        Arrays.sort(objectArray);
        if (null == this.outFile) {
            this.outFile = new File(((String)objectArray[0]).substring(0, ((String)objectArray[0]).indexOf(".")) + "-" + ((String)objectArray[objectArray.length - 1]).substring(0, ((String)objectArray[objectArray.length - 1]).indexOf(".")) + ".jfr");
        }
        if (this.outFile.exists() && !this.forceOverwrite) {
            throw new IOException("The specified file already exists " + this.outFile + ". Use -f to force override");
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.outFile), 4096);
        try {
            for (Object object : objectArray) {
                int n;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(this.repositoryDirectory + "/" + (String)object)), 4096);
                byte[] byArray = new byte[4096];
                while ((n = bufferedInputStream.read(byArray)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedInputStream.close();
            }
        }
        finally {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean parseArgs(String[] stringArray) {
        int n = 0;
        if (!stringArray[0].startsWith("-")) {
            this.repositoryDirectory = new File(stringArray[0]);
            ++n;
        } else {
            this.repositoryDirectory = new File(".");
        }
        try {
            char c;
            block6: while (n < stringArray.length) {
                c = stringArray[n].charAt(1);
                switch (c) {
                    case 'o': {
                        this.outFile = new File(stringArray[n + 1]);
                        n += 2;
                        continue block6;
                    }
                    case 'f': {
                        this.forceOverwrite = true;
                        ++n;
                        continue block6;
                    }
                }
            }
            return true;
            System.err.println("Unknown flag: " + c);
            ConCatRepository.usage();
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("To few arguments:");
            ConCatRepository.usage();
        }
        return true;
    }
}

