// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acmpca

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateCertificateAuthority = "CreateCertificateAuthority"

// CreateCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the CreateCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCertificateAuthority for more information on using the CreateCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCertificateAuthorityRequest method.
//    req, resp := client.CreateCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthority
func (c *ACMPCA) CreateCertificateAuthorityRequest(input *CreateCertificateAuthorityInput) (req *request.Request, output *CreateCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opCreateCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCertificateAuthorityInput{}
	}

	output = &CreateCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Creates a root or subordinate private certificate authority (CA). You must
// specify the CA configuration, an optional configuration for Online Certificate
// Status Protocol (OCSP) and/or a certificate revocation list (CRL), the CA
// type, and an optional idempotency token to avoid accidental creation of multiple
// CAs. The CA configuration specifies the name of the algorithm and key size
// to be used to create the CA private key, the type of signing algorithm that
// the CA uses, and X.500 subject information. The OCSP configuration can optionally
// specify a custom URL for the OCSP responder. The CRL configuration specifies
// the CRL expiration period in days (the validity period of the CRL), the Amazon
// S3 bucket that will contain the CRL, and a CNAME alias for the S3 bucket
// that is included in certificates issued by the CA. If successful, this action
// returns the Amazon Resource Name (ARN) of the CA.
//
// ACM Private CA assets that are stored in Amazon S3 can be protected with
// encryption. For more information, see Encrypting Your CRLs (https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption).
//
// Both PCA and the IAM principal must have permission to write to the S3 bucket
// that you specify. If the IAM principal making the call does not have permission
// to write to the bucket, then an exception is thrown. For more information,
// see Access policies for CRLs in Amazon S3 (https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation CreateCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * InvalidArgsException
//   One or more of the specified arguments was not valid.
//
//   * InvalidPolicyException
//   The resource policy is invalid or is missing a required statement. For general
//   information about IAM policy and statement structure, see Overview of JSON
//   Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
//
//   * InvalidTagException
//   The tag associated with the CA is not valid. The invalid argument is contained
//   in the message field.
//
//   * LimitExceededException
//   An ACM Private CA quota has been exceeded. See the exception message returned
//   to determine the quota that was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthority
func (c *ACMPCA) CreateCertificateAuthority(input *CreateCertificateAuthorityInput) (*CreateCertificateAuthorityOutput, error) {
	req, out := c.CreateCertificateAuthorityRequest(input)
	return out, req.Send()
}

// CreateCertificateAuthorityWithContext is the same as CreateCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) CreateCertificateAuthorityWithContext(ctx aws.Context, input *CreateCertificateAuthorityInput, opts ...request.Option) (*CreateCertificateAuthorityOutput, error) {
	req, out := c.CreateCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCertificateAuthorityAuditReport = "CreateCertificateAuthorityAuditReport"

// CreateCertificateAuthorityAuditReportRequest generates a "aws/request.Request" representing the
// client's request for the CreateCertificateAuthorityAuditReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCertificateAuthorityAuditReport for more information on using the CreateCertificateAuthorityAuditReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCertificateAuthorityAuditReportRequest method.
//    req, resp := client.CreateCertificateAuthorityAuditReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthorityAuditReport
func (c *ACMPCA) CreateCertificateAuthorityAuditReportRequest(input *CreateCertificateAuthorityAuditReportInput) (req *request.Request, output *CreateCertificateAuthorityAuditReportOutput) {
	op := &request.Operation{
		Name:       opCreateCertificateAuthorityAuditReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCertificateAuthorityAuditReportInput{}
	}

	output = &CreateCertificateAuthorityAuditReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCertificateAuthorityAuditReport API operation for AWS Certificate Manager Private Certificate Authority.
//
// Creates an audit report that lists every time that your CA private key is
// used. The report is saved in the Amazon S3 bucket that you specify on input.
// The IssueCertificate (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html)
// and RevokeCertificate (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html)
// actions use the private key.
//
// Both PCA and the IAM principal must have permission to write to the S3 bucket
// that you specify. If the IAM principal making the call does not have permission
// to write to the bucket, then an exception is thrown. For more information,
// see Access policies for CRLs in Amazon S3 (https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
//
// ACM Private CA assets that are stored in Amazon S3 can be protected with
// encryption. For more information, see Encrypting Your Audit Reports (https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuditReport.html#audit-report-encryption).
//
// You can generate a maximum of one report every 30 minutes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation CreateCertificateAuthorityAuditReport for usage and error information.
//
// Returned Error Types:
//   * RequestInProgressException
//   Your request is already in progress.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidArgsException
//   One or more of the specified arguments was not valid.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreateCertificateAuthorityAuditReport
func (c *ACMPCA) CreateCertificateAuthorityAuditReport(input *CreateCertificateAuthorityAuditReportInput) (*CreateCertificateAuthorityAuditReportOutput, error) {
	req, out := c.CreateCertificateAuthorityAuditReportRequest(input)
	return out, req.Send()
}

// CreateCertificateAuthorityAuditReportWithContext is the same as CreateCertificateAuthorityAuditReport with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCertificateAuthorityAuditReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) CreateCertificateAuthorityAuditReportWithContext(ctx aws.Context, input *CreateCertificateAuthorityAuditReportInput, opts ...request.Option) (*CreateCertificateAuthorityAuditReportOutput, error) {
	req, out := c.CreateCertificateAuthorityAuditReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePermission = "CreatePermission"

// CreatePermissionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePermission for more information on using the CreatePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePermissionRequest method.
//    req, resp := client.CreatePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreatePermission
func (c *ACMPCA) CreatePermissionRequest(input *CreatePermissionInput) (req *request.Request, output *CreatePermissionOutput) {
	op := &request.Operation{
		Name:       opCreatePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePermissionInput{}
	}

	output = &CreatePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreatePermission API operation for AWS Certificate Manager Private Certificate Authority.
//
// Grants one or more permissions on a private CA to the Certificate Manager
// (ACM) service principal (acm.amazonaws.com). These permissions allow ACM
// to issue and renew ACM certificates that reside in the same Amazon Web Services
// account as the CA.
//
// You can list current permissions with the ListPermissions (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html)
// action and revoke them with the DeletePermission (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html)
// action.
//
// About Permissions
//
//    * If the private CA and the certificates it issues reside in the same
//    account, you can use CreatePermission to grant permissions for ACM to
//    carry out automatic certificate renewals.
//
//    * For automatic certificate renewal to succeed, the ACM service principal
//    needs permissions to create, retrieve, and list certificates.
//
//    * If the private CA and the ACM certificates reside in different accounts,
//    then permissions cannot be used to enable automatic renewals. Instead,
//    the ACM certificate owner must set up a resource-based policy to enable
//    cross-account issuance and renewals. For more information, see Using a
//    Resource Based Policy with ACM Private CA (https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation CreatePermission for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * PermissionAlreadyExistsException
//   The designated permission has already been given to the user.
//
//   * LimitExceededException
//   An ACM Private CA quota has been exceeded. See the exception message returned
//   to determine the quota that was exceeded.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/CreatePermission
func (c *ACMPCA) CreatePermission(input *CreatePermissionInput) (*CreatePermissionOutput, error) {
	req, out := c.CreatePermissionRequest(input)
	return out, req.Send()
}

// CreatePermissionWithContext is the same as CreatePermission with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) CreatePermissionWithContext(ctx aws.Context, input *CreatePermissionInput, opts ...request.Option) (*CreatePermissionOutput, error) {
	req, out := c.CreatePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCertificateAuthority = "DeleteCertificateAuthority"

// DeleteCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCertificateAuthority for more information on using the DeleteCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCertificateAuthorityRequest method.
//    req, resp := client.DeleteCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeleteCertificateAuthority
func (c *ACMPCA) DeleteCertificateAuthorityRequest(input *DeleteCertificateAuthorityInput) (req *request.Request, output *DeleteCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCertificateAuthorityInput{}
	}

	output = &DeleteCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Deletes a private certificate authority (CA). You must provide the Amazon
// Resource Name (ARN) of the private CA that you want to delete. You can find
// the ARN by calling the ListCertificateAuthorities (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
// action.
//
// Deleting a CA will invalidate other CAs and certificates below it in your
// CA hierarchy.
//
// Before you can delete a CA that you have created and activated, you must
// disable it. To do this, call the UpdateCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html)
// action and set the CertificateAuthorityStatus parameter to DISABLED.
//
// Additionally, you can delete a CA if you are waiting for it to be created
// (that is, the status of the CA is CREATING). You can also delete it if the
// CA has been created but you haven't yet imported the signed certificate into
// ACM Private CA (that is, the status of the CA is PENDING_CERTIFICATE).
//
// When you successfully call DeleteCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html),
// the CA's status changes to DELETED. However, the CA won't be permanently
// deleted until the restoration period has passed. By default, if you do not
// set the PermanentDeletionTimeInDays parameter, the CA remains restorable
// for 30 days. You can set the parameter from 7 to 30 days. The DescribeCertificateAuthority
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html)
// action returns the time remaining in the restoration window of a private
// CA in the DELETED state. To restore an eligible CA, call the RestoreCertificateAuthority
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RestoreCertificateAuthority.html)
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation DeleteCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   A previous update to your private CA is still ongoing.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeleteCertificateAuthority
func (c *ACMPCA) DeleteCertificateAuthority(input *DeleteCertificateAuthorityInput) (*DeleteCertificateAuthorityOutput, error) {
	req, out := c.DeleteCertificateAuthorityRequest(input)
	return out, req.Send()
}

// DeleteCertificateAuthorityWithContext is the same as DeleteCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) DeleteCertificateAuthorityWithContext(ctx aws.Context, input *DeleteCertificateAuthorityInput, opts ...request.Option) (*DeleteCertificateAuthorityOutput, error) {
	req, out := c.DeleteCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePermission = "DeletePermission"

// DeletePermissionRequest generates a "aws/request.Request" representing the
// client's request for the DeletePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePermission for more information on using the DeletePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePermissionRequest method.
//    req, resp := client.DeletePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeletePermission
func (c *ACMPCA) DeletePermissionRequest(input *DeletePermissionInput) (req *request.Request, output *DeletePermissionOutput) {
	op := &request.Operation{
		Name:       opDeletePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePermissionInput{}
	}

	output = &DeletePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePermission API operation for AWS Certificate Manager Private Certificate Authority.
//
// Revokes permissions on a private CA granted to the Certificate Manager (ACM)
// service principal (acm.amazonaws.com).
//
// These permissions allow ACM to issue and renew ACM certificates that reside
// in the same Amazon Web Services account as the CA. If you revoke these permissions,
// ACM will no longer renew the affected certificates automatically.
//
// Permissions can be granted with the CreatePermission (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html)
// action and listed with the ListPermissions (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html)
// action.
//
// About Permissions
//
//    * If the private CA and the certificates it issues reside in the same
//    account, you can use CreatePermission to grant permissions for ACM to
//    carry out automatic certificate renewals.
//
//    * For automatic certificate renewal to succeed, the ACM service principal
//    needs permissions to create, retrieve, and list certificates.
//
//    * If the private CA and the ACM certificates reside in different accounts,
//    then permissions cannot be used to enable automatic renewals. Instead,
//    the ACM certificate owner must set up a resource-based policy to enable
//    cross-account issuance and renewals. For more information, see Using a
//    Resource Based Policy with ACM Private CA (https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation DeletePermission for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeletePermission
func (c *ACMPCA) DeletePermission(input *DeletePermissionInput) (*DeletePermissionOutput, error) {
	req, out := c.DeletePermissionRequest(input)
	return out, req.Send()
}

// DeletePermissionWithContext is the same as DeletePermission with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) DeletePermissionWithContext(ctx aws.Context, input *DeletePermissionInput, opts ...request.Option) (*DeletePermissionOutput, error) {
	req, out := c.DeletePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePolicy for more information on using the DeletePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePolicyRequest method.
//    req, resp := client.DeletePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeletePolicy
func (c *ACMPCA) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	output = &DeletePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicy API operation for AWS Certificate Manager Private Certificate Authority.
//
// Deletes the resource-based policy attached to a private CA. Deletion will
// remove any access that the policy has granted. If there is no policy attached
// to the private CA, this action will return successful.
//
// If you delete a policy that was applied through Amazon Web Services Resource
// Access Manager (RAM), the CA will be removed from all shares in which it
// was included.
//
// The Certificate Manager Service Linked Role that the policy supports is not
// affected when you delete the policy.
//
// The current policy can be shown with GetPolicy (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html)
// and updated with PutPolicy (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html).
//
// About Policies
//
//    * A policy grants access on a private CA to an Amazon Web Services customer
//    account, to Amazon Web Services Organizations, or to an Amazon Web Services
//    Organizations unit. Policies are under the control of a CA administrator.
//    For more information, see Using a Resource Based Policy with ACM Private
//    CA (https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
//
//    * A policy permits a user of Certificate Manager (ACM) to issue ACM certificates
//    signed by a CA in another account.
//
//    * For ACM to manage automatic renewal of these certificates, the ACM user
//    must configure a Service Linked Role (SLR). The SLR allows the ACM service
//    to assume the identity of the user, subject to confirmation against the
//    ACM Private CA policy. For more information, see Using a Service Linked
//    Role with ACM (https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
//
//    * Updates made in Amazon Web Services Resource Manager (RAM) are reflected
//    in policies. For more information, see Attach a Policy for Cross-Account
//    Access (https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   A previous update to your private CA is still ongoing.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * LockoutPreventedException
//   The current action was prevented because it would lock the caller out from
//   performing subsequent actions. Verify that the specified parameters would
//   not result in the caller being denied access to the resource.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DeletePolicy
func (c *ACMPCA) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	return out, req.Send()
}

// DeletePolicyWithContext is the same as DeletePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) DeletePolicyWithContext(ctx aws.Context, input *DeletePolicyInput, opts ...request.Option) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificateAuthority = "DescribeCertificateAuthority"

// DescribeCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificateAuthority for more information on using the DescribeCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificateAuthorityRequest method.
//    req, resp := client.DescribeCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthority
func (c *ACMPCA) DescribeCertificateAuthorityRequest(input *DescribeCertificateAuthorityInput) (req *request.Request, output *DescribeCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCertificateAuthorityInput{}
	}

	output = &DescribeCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Lists information about your private certificate authority (CA) or one that
// has been shared with you. You specify the private CA on input by its ARN
// (Amazon Resource Name). The output contains the status of your CA. This can
// be any of the following:
//
//    * CREATING - ACM Private CA is creating your private certificate authority.
//
//    * PENDING_CERTIFICATE - The certificate is pending. You must use your
//    ACM Private CA-hosted or on-premises root or subordinate CA to sign your
//    private CA CSR and then import it into PCA.
//
//    * ACTIVE - Your private CA is active.
//
//    * DISABLED - Your private CA has been disabled.
//
//    * EXPIRED - Your private CA certificate has expired.
//
//    * FAILED - Your private CA has failed. Your CA can fail because of problems
//    such a network outage or back-end Amazon Web Services failure or other
//    errors. A failed CA can never return to the pending state. You must create
//    a new CA.
//
//    * DELETED - Your private CA is within the restoration period, after which
//    it is permanently deleted. The length of time remaining in the CA's restoration
//    period is also included in this action's output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation DescribeCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthority
func (c *ACMPCA) DescribeCertificateAuthority(input *DescribeCertificateAuthorityInput) (*DescribeCertificateAuthorityOutput, error) {
	req, out := c.DescribeCertificateAuthorityRequest(input)
	return out, req.Send()
}

// DescribeCertificateAuthorityWithContext is the same as DescribeCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) DescribeCertificateAuthorityWithContext(ctx aws.Context, input *DescribeCertificateAuthorityInput, opts ...request.Option) (*DescribeCertificateAuthorityOutput, error) {
	req, out := c.DescribeCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificateAuthorityAuditReport = "DescribeCertificateAuthorityAuditReport"

// DescribeCertificateAuthorityAuditReportRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificateAuthorityAuditReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificateAuthorityAuditReport for more information on using the DescribeCertificateAuthorityAuditReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificateAuthorityAuditReportRequest method.
//    req, resp := client.DescribeCertificateAuthorityAuditReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthorityAuditReport
func (c *ACMPCA) DescribeCertificateAuthorityAuditReportRequest(input *DescribeCertificateAuthorityAuditReportInput) (req *request.Request, output *DescribeCertificateAuthorityAuditReportOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificateAuthorityAuditReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCertificateAuthorityAuditReportInput{}
	}

	output = &DescribeCertificateAuthorityAuditReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificateAuthorityAuditReport API operation for AWS Certificate Manager Private Certificate Authority.
//
// Lists information about a specific audit report created by calling the CreateCertificateAuthorityAuditReport
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html)
// action. Audit information is created every time the certificate authority
// (CA) private key is used. The private key is used when you call the IssueCertificate
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html)
// action or the RevokeCertificate (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html)
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation DescribeCertificateAuthorityAuditReport for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidArgsException
//   One or more of the specified arguments was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/DescribeCertificateAuthorityAuditReport
func (c *ACMPCA) DescribeCertificateAuthorityAuditReport(input *DescribeCertificateAuthorityAuditReportInput) (*DescribeCertificateAuthorityAuditReportOutput, error) {
	req, out := c.DescribeCertificateAuthorityAuditReportRequest(input)
	return out, req.Send()
}

// DescribeCertificateAuthorityAuditReportWithContext is the same as DescribeCertificateAuthorityAuditReport with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificateAuthorityAuditReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) DescribeCertificateAuthorityAuditReportWithContext(ctx aws.Context, input *DescribeCertificateAuthorityAuditReportInput, opts ...request.Option) (*DescribeCertificateAuthorityAuditReportOutput, error) {
	req, out := c.DescribeCertificateAuthorityAuditReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCertificate = "GetCertificate"

// GetCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCertificate for more information on using the GetCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCertificateRequest method.
//    req, resp := client.GetCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificate
func (c *ACMPCA) GetCertificateRequest(input *GetCertificateInput) (req *request.Request, output *GetCertificateOutput) {
	op := &request.Operation{
		Name:       opGetCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificateInput{}
	}

	output = &GetCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCertificate API operation for AWS Certificate Manager Private Certificate Authority.
//
// Retrieves a certificate from your private CA or one that has been shared
// with you. The ARN of the certificate is returned when you call the IssueCertificate
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html)
// action. You must specify both the ARN of your private CA and the ARN of the
// issued certificate when calling the GetCertificate action. You can retrieve
// the certificate if it is in the ISSUED state. You can call the CreateCertificateAuthorityAuditReport
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html)
// action to create a report that contains information about all of the certificates
// issued and revoked by your private CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation GetCertificate for usage and error information.
//
// Returned Error Types:
//   * RequestInProgressException
//   Your request is already in progress.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificate
func (c *ACMPCA) GetCertificate(input *GetCertificateInput) (*GetCertificateOutput, error) {
	req, out := c.GetCertificateRequest(input)
	return out, req.Send()
}

// GetCertificateWithContext is the same as GetCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GetCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) GetCertificateWithContext(ctx aws.Context, input *GetCertificateInput, opts ...request.Option) (*GetCertificateOutput, error) {
	req, out := c.GetCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCertificateAuthorityCertificate = "GetCertificateAuthorityCertificate"

// GetCertificateAuthorityCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetCertificateAuthorityCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCertificateAuthorityCertificate for more information on using the GetCertificateAuthorityCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCertificateAuthorityCertificateRequest method.
//    req, resp := client.GetCertificateAuthorityCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCertificate
func (c *ACMPCA) GetCertificateAuthorityCertificateRequest(input *GetCertificateAuthorityCertificateInput) (req *request.Request, output *GetCertificateAuthorityCertificateOutput) {
	op := &request.Operation{
		Name:       opGetCertificateAuthorityCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificateAuthorityCertificateInput{}
	}

	output = &GetCertificateAuthorityCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCertificateAuthorityCertificate API operation for AWS Certificate Manager Private Certificate Authority.
//
// Retrieves the certificate and certificate chain for your private certificate
// authority (CA) or one that has been shared with you. Both the certificate
// and the chain are base64 PEM-encoded. The chain does not include the CA certificate.
// Each certificate in the chain signs the one before it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation GetCertificateAuthorityCertificate for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCertificate
func (c *ACMPCA) GetCertificateAuthorityCertificate(input *GetCertificateAuthorityCertificateInput) (*GetCertificateAuthorityCertificateOutput, error) {
	req, out := c.GetCertificateAuthorityCertificateRequest(input)
	return out, req.Send()
}

// GetCertificateAuthorityCertificateWithContext is the same as GetCertificateAuthorityCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GetCertificateAuthorityCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) GetCertificateAuthorityCertificateWithContext(ctx aws.Context, input *GetCertificateAuthorityCertificateInput, opts ...request.Option) (*GetCertificateAuthorityCertificateOutput, error) {
	req, out := c.GetCertificateAuthorityCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCertificateAuthorityCsr = "GetCertificateAuthorityCsr"

// GetCertificateAuthorityCsrRequest generates a "aws/request.Request" representing the
// client's request for the GetCertificateAuthorityCsr operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCertificateAuthorityCsr for more information on using the GetCertificateAuthorityCsr
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCertificateAuthorityCsrRequest method.
//    req, resp := client.GetCertificateAuthorityCsrRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCsr
func (c *ACMPCA) GetCertificateAuthorityCsrRequest(input *GetCertificateAuthorityCsrInput) (req *request.Request, output *GetCertificateAuthorityCsrOutput) {
	op := &request.Operation{
		Name:       opGetCertificateAuthorityCsr,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificateAuthorityCsrInput{}
	}

	output = &GetCertificateAuthorityCsrOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCertificateAuthorityCsr API operation for AWS Certificate Manager Private Certificate Authority.
//
// Retrieves the certificate signing request (CSR) for your private certificate
// authority (CA). The CSR is created when you call the CreateCertificateAuthority
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
// action. Sign the CSR with your ACM Private CA-hosted or on-premises root
// or subordinate CA. Then import the signed certificate back into ACM Private
// CA by calling the ImportCertificateAuthorityCertificate (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html)
// action. The CSR is returned as a base64 PEM-encoded string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation GetCertificateAuthorityCsr for usage and error information.
//
// Returned Error Types:
//   * RequestInProgressException
//   Your request is already in progress.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCsr
func (c *ACMPCA) GetCertificateAuthorityCsr(input *GetCertificateAuthorityCsrInput) (*GetCertificateAuthorityCsrOutput, error) {
	req, out := c.GetCertificateAuthorityCsrRequest(input)
	return out, req.Send()
}

// GetCertificateAuthorityCsrWithContext is the same as GetCertificateAuthorityCsr with the addition of
// the ability to pass a context and additional request options.
//
// See GetCertificateAuthorityCsr for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) GetCertificateAuthorityCsrWithContext(ctx aws.Context, input *GetCertificateAuthorityCsrInput, opts ...request.Option) (*GetCertificateAuthorityCsrOutput, error) {
	req, out := c.GetCertificateAuthorityCsrRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPolicy for more information on using the GetPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPolicyRequest method.
//    req, resp := client.GetPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetPolicy
func (c *ACMPCA) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for AWS Certificate Manager Private Certificate Authority.
//
// Retrieves the resource-based policy attached to a private CA. If either the
// private CA resource or the policy cannot be found, this action returns a
// ResourceNotFoundException.
//
// The policy can be attached or updated with PutPolicy (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html)
// and removed with DeletePolicy (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html).
//
// About Policies
//
//    * A policy grants access on a private CA to an Amazon Web Services customer
//    account, to Amazon Web Services Organizations, or to an Amazon Web Services
//    Organizations unit. Policies are under the control of a CA administrator.
//    For more information, see Using a Resource Based Policy with ACM Private
//    CA (https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
//
//    * A policy permits a user of Certificate Manager (ACM) to issue ACM certificates
//    signed by a CA in another account.
//
//    * For ACM to manage automatic renewal of these certificates, the ACM user
//    must configure a Service Linked Role (SLR). The SLR allows the ACM service
//    to assume the identity of the user, subject to confirmation against the
//    ACM Private CA policy. For more information, see Using a Service Linked
//    Role with ACM (https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
//
//    * Updates made in Amazon Web Services Resource Manager (RAM) are reflected
//    in policies. For more information, see Attach a Policy for Cross-Account
//    Access (https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation GetPolicy for usage and error information.
//
// Returned Error Types:
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetPolicy
func (c *ACMPCA) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	return out, req.Send()
}

// GetPolicyWithContext is the same as GetPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) GetPolicyWithContext(ctx aws.Context, input *GetPolicyInput, opts ...request.Option) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportCertificateAuthorityCertificate = "ImportCertificateAuthorityCertificate"

// ImportCertificateAuthorityCertificateRequest generates a "aws/request.Request" representing the
// client's request for the ImportCertificateAuthorityCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportCertificateAuthorityCertificate for more information on using the ImportCertificateAuthorityCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportCertificateAuthorityCertificateRequest method.
//    req, resp := client.ImportCertificateAuthorityCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ImportCertificateAuthorityCertificate
func (c *ACMPCA) ImportCertificateAuthorityCertificateRequest(input *ImportCertificateAuthorityCertificateInput) (req *request.Request, output *ImportCertificateAuthorityCertificateOutput) {
	op := &request.Operation{
		Name:       opImportCertificateAuthorityCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportCertificateAuthorityCertificateInput{}
	}

	output = &ImportCertificateAuthorityCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ImportCertificateAuthorityCertificate API operation for AWS Certificate Manager Private Certificate Authority.
//
// Imports a signed private CA certificate into ACM Private CA. This action
// is used when you are using a chain of trust whose root is located outside
// ACM Private CA. Before you can call this action, the following preparations
// must in place:
//
// In ACM Private CA, call the CreateCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
// action to create the private CA that you plan to back with the imported certificate.
//
// Call the GetCertificateAuthorityCsr (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCsr.html)
// action to generate a certificate signing request (CSR).
//
// Sign the CSR using a root or intermediate CA hosted by either an on-premises
// PKI hierarchy or by a commercial CA.
//
// Create a certificate chain and copy the signed certificate and the certificate
// chain to your working directory.
//
// ACM Private CA supports three scenarios for installing a CA certificate:
//
//    * Installing a certificate for a root CA hosted by ACM Private CA.
//
//    * Installing a subordinate CA certificate whose parent authority is hosted
//    by ACM Private CA.
//
//    * Installing a subordinate CA certificate whose parent authority is externally
//    hosted.
//
// The following additional requirements apply when you import a CA certificate.
//
//    * Only a self-signed certificate can be imported as a root CA.
//
//    * A self-signed certificate cannot be imported as a subordinate CA.
//
//    * Your certificate chain must not include the private CA certificate that
//    you are importing.
//
//    * Your root CA must be the last certificate in your chain. The subordinate
//    certificate, if any, that your root CA signed must be next to last. The
//    subordinate certificate signed by the preceding subordinate CA must come
//    next, and so on until your chain is built.
//
//    * The chain must be PEM-encoded.
//
//    * The maximum allowed size of a certificate is 32 KB.
//
//    * The maximum allowed size of a certificate chain is 2 MB.
//
// Enforcement of Critical Constraints
//
// ACM Private CA allows the following extensions to be marked critical in the
// imported CA certificate or chain.
//
//    * Basic constraints (must be marked critical)
//
//    * Subject alternative names
//
//    * Key usage
//
//    * Extended key usage
//
//    * Authority key identifier
//
//    * Subject key identifier
//
//    * Issuer alternative name
//
//    * Subject directory attributes
//
//    * Subject information access
//
//    * Certificate policies
//
//    * Policy mappings
//
//    * Inhibit anyPolicy
//
// ACM Private CA rejects the following extensions when they are marked critical
// in an imported CA certificate or chain.
//
//    * Name constraints
//
//    * Policy constraints
//
//    * CRL distribution points
//
//    * Authority information access
//
//    * Freshest CRL
//
//    * Any other extension
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation ImportCertificateAuthorityCertificate for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   A previous update to your private CA is still ongoing.
//
//   * RequestInProgressException
//   Your request is already in progress.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidRequestException
//   The request action cannot be performed or is prohibited.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * MalformedCertificateException
//   One or more fields in the certificate are invalid.
//
//   * CertificateMismatchException
//   The certificate authority certificate you are importing does not comply with
//   conditions specified in the certificate that signed it.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ImportCertificateAuthorityCertificate
func (c *ACMPCA) ImportCertificateAuthorityCertificate(input *ImportCertificateAuthorityCertificateInput) (*ImportCertificateAuthorityCertificateOutput, error) {
	req, out := c.ImportCertificateAuthorityCertificateRequest(input)
	return out, req.Send()
}

// ImportCertificateAuthorityCertificateWithContext is the same as ImportCertificateAuthorityCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See ImportCertificateAuthorityCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ImportCertificateAuthorityCertificateWithContext(ctx aws.Context, input *ImportCertificateAuthorityCertificateInput, opts ...request.Option) (*ImportCertificateAuthorityCertificateOutput, error) {
	req, out := c.ImportCertificateAuthorityCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIssueCertificate = "IssueCertificate"

// IssueCertificateRequest generates a "aws/request.Request" representing the
// client's request for the IssueCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IssueCertificate for more information on using the IssueCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the IssueCertificateRequest method.
//    req, resp := client.IssueCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/IssueCertificate
func (c *ACMPCA) IssueCertificateRequest(input *IssueCertificateInput) (req *request.Request, output *IssueCertificateOutput) {
	op := &request.Operation{
		Name:       opIssueCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IssueCertificateInput{}
	}

	output = &IssueCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IssueCertificate API operation for AWS Certificate Manager Private Certificate Authority.
//
// Uses your private certificate authority (CA), or one that has been shared
// with you, to issue a client certificate. This action returns the Amazon Resource
// Name (ARN) of the certificate. You can retrieve the certificate by calling
// the GetCertificate (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html)
// action and specifying the ARN.
//
// You cannot use the ACM ListCertificateAuthorities action to retrieve the
// ARNs of the certificates that you issue by using ACM Private CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation IssueCertificate for usage and error information.
//
// Returned Error Types:
//   * LimitExceededException
//   An ACM Private CA quota has been exceeded. See the exception message returned
//   to determine the quota that was exceeded.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidArgsException
//   One or more of the specified arguments was not valid.
//
//   * MalformedCSRException
//   The certificate signing request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/IssueCertificate
func (c *ACMPCA) IssueCertificate(input *IssueCertificateInput) (*IssueCertificateOutput, error) {
	req, out := c.IssueCertificateRequest(input)
	return out, req.Send()
}

// IssueCertificateWithContext is the same as IssueCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See IssueCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) IssueCertificateWithContext(ctx aws.Context, input *IssueCertificateInput, opts ...request.Option) (*IssueCertificateOutput, error) {
	req, out := c.IssueCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCertificateAuthorities = "ListCertificateAuthorities"

// ListCertificateAuthoritiesRequest generates a "aws/request.Request" representing the
// client's request for the ListCertificateAuthorities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCertificateAuthorities for more information on using the ListCertificateAuthorities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCertificateAuthoritiesRequest method.
//    req, resp := client.ListCertificateAuthoritiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListCertificateAuthorities
func (c *ACMPCA) ListCertificateAuthoritiesRequest(input *ListCertificateAuthoritiesInput) (req *request.Request, output *ListCertificateAuthoritiesOutput) {
	op := &request.Operation{
		Name:       opListCertificateAuthorities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCertificateAuthoritiesInput{}
	}

	output = &ListCertificateAuthoritiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCertificateAuthorities API operation for AWS Certificate Manager Private Certificate Authority.
//
// Lists the private certificate authorities that you created by using the CreateCertificateAuthority
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation ListCertificateAuthorities for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The token specified in the NextToken argument is not valid. Use the token
//   returned from your previous call to ListCertificateAuthorities (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListCertificateAuthorities
func (c *ACMPCA) ListCertificateAuthorities(input *ListCertificateAuthoritiesInput) (*ListCertificateAuthoritiesOutput, error) {
	req, out := c.ListCertificateAuthoritiesRequest(input)
	return out, req.Send()
}

// ListCertificateAuthoritiesWithContext is the same as ListCertificateAuthorities with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertificateAuthorities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListCertificateAuthoritiesWithContext(ctx aws.Context, input *ListCertificateAuthoritiesInput, opts ...request.Option) (*ListCertificateAuthoritiesOutput, error) {
	req, out := c.ListCertificateAuthoritiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCertificateAuthoritiesPages iterates over the pages of a ListCertificateAuthorities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCertificateAuthorities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCertificateAuthorities operation.
//    pageNum := 0
//    err := client.ListCertificateAuthoritiesPages(params,
//        func(page *acmpca.ListCertificateAuthoritiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ACMPCA) ListCertificateAuthoritiesPages(input *ListCertificateAuthoritiesInput, fn func(*ListCertificateAuthoritiesOutput, bool) bool) error {
	return c.ListCertificateAuthoritiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCertificateAuthoritiesPagesWithContext same as ListCertificateAuthoritiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListCertificateAuthoritiesPagesWithContext(ctx aws.Context, input *ListCertificateAuthoritiesInput, fn func(*ListCertificateAuthoritiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCertificateAuthoritiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCertificateAuthoritiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCertificateAuthoritiesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissions = "ListPermissions"

// ListPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissions for more information on using the ListPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPermissionsRequest method.
//    req, resp := client.ListPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListPermissions
func (c *ACMPCA) ListPermissionsRequest(input *ListPermissionsInput) (req *request.Request, output *ListPermissionsOutput) {
	op := &request.Operation{
		Name:       opListPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionsInput{}
	}

	output = &ListPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissions API operation for AWS Certificate Manager Private Certificate Authority.
//
// List all permissions on a private CA, if any, granted to the Certificate
// Manager (ACM) service principal (acm.amazonaws.com).
//
// These permissions allow ACM to issue and renew ACM certificates that reside
// in the same Amazon Web Services account as the CA.
//
// Permissions can be granted with the CreatePermission (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html)
// action and revoked with the DeletePermission (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html)
// action.
//
// About Permissions
//
//    * If the private CA and the certificates it issues reside in the same
//    account, you can use CreatePermission to grant permissions for ACM to
//    carry out automatic certificate renewals.
//
//    * For automatic certificate renewal to succeed, the ACM service principal
//    needs permissions to create, retrieve, and list certificates.
//
//    * If the private CA and the ACM certificates reside in different accounts,
//    then permissions cannot be used to enable automatic renewals. Instead,
//    the ACM certificate owner must set up a resource-based policy to enable
//    cross-account issuance and renewals. For more information, see Using a
//    Resource Based Policy with ACM Private CA (https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation ListPermissions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidNextTokenException
//   The token specified in the NextToken argument is not valid. Use the token
//   returned from your previous call to ListCertificateAuthorities (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html).
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListPermissions
func (c *ACMPCA) ListPermissions(input *ListPermissionsInput) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	return out, req.Send()
}

// ListPermissionsWithContext is the same as ListPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListPermissionsWithContext(ctx aws.Context, input *ListPermissionsInput, opts ...request.Option) (*ListPermissionsOutput, error) {
	req, out := c.ListPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionsPages iterates over the pages of a ListPermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPermissions operation.
//    pageNum := 0
//    err := client.ListPermissionsPages(params,
//        func(page *acmpca.ListPermissionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ACMPCA) ListPermissionsPages(input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool) error {
	return c.ListPermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionsPagesWithContext same as ListPermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListPermissionsPagesWithContext(ctx aws.Context, input *ListPermissionsInput, fn func(*ListPermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListTags
func (c *ACMPCA) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for AWS Certificate Manager Private Certificate Authority.
//
// Lists the tags, if any, that are associated with your private CA or one that
// has been shared with you. Tags are labels that you can use to identify and
// organize your CAs. Each tag consists of a key and an optional value. Call
// the TagCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html)
// action to add one or more tags to your CA. Call the UntagCertificateAuthority
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html)
// action to remove tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListTags
func (c *ACMPCA) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsPages iterates over the pages of a ListTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTags operation.
//    pageNum := 0
//    err := client.ListTagsPages(params,
//        func(page *acmpca.ListTagsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ACMPCA) ListTagsPages(input *ListTagsInput, fn func(*ListTagsOutput, bool) bool) error {
	return c.ListTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsPagesWithContext same as ListTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) ListTagsPagesWithContext(ctx aws.Context, input *ListTagsInput, fn func(*ListTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutPolicy = "PutPolicy"

// PutPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPolicy for more information on using the PutPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutPolicyRequest method.
//    req, resp := client.PutPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/PutPolicy
func (c *ACMPCA) PutPolicyRequest(input *PutPolicyInput) (req *request.Request, output *PutPolicyOutput) {
	op := &request.Operation{
		Name:       opPutPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPolicyInput{}
	}

	output = &PutPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutPolicy API operation for AWS Certificate Manager Private Certificate Authority.
//
// Attaches a resource-based policy to a private CA.
//
// A policy can also be applied by sharing a private CA through Amazon Web Services
// Resource Access Manager (RAM). For more information, see Attach a Policy
// for Cross-Account Access (https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
//
// The policy can be displayed with GetPolicy (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html)
// and removed with DeletePolicy (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html).
//
// About Policies
//
//    * A policy grants access on a private CA to an Amazon Web Services customer
//    account, to Amazon Web Services Organizations, or to an Amazon Web Services
//    Organizations unit. Policies are under the control of a CA administrator.
//    For more information, see Using a Resource Based Policy with ACM Private
//    CA (https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
//
//    * A policy permits a user of Certificate Manager (ACM) to issue ACM certificates
//    signed by a CA in another account.
//
//    * For ACM to manage automatic renewal of these certificates, the ACM user
//    must configure a Service Linked Role (SLR). The SLR allows the ACM service
//    to assume the identity of the user, subject to confirmation against the
//    ACM Private CA policy. For more information, see Using a Service Linked
//    Role with ACM (https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
//
//    * Updates made in Amazon Web Services Resource Manager (RAM) are reflected
//    in policies. For more information, see Attach a Policy for Cross-Account
//    Access (https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation PutPolicy for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   A previous update to your private CA is still ongoing.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * InvalidPolicyException
//   The resource policy is invalid or is missing a required statement. For general
//   information about IAM policy and statement structure, see Overview of JSON
//   Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
//
//   * LockoutPreventedException
//   The current action was prevented because it would lock the caller out from
//   performing subsequent actions. Verify that the specified parameters would
//   not result in the caller being denied access to the resource.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/PutPolicy
func (c *ACMPCA) PutPolicy(input *PutPolicyInput) (*PutPolicyOutput, error) {
	req, out := c.PutPolicyRequest(input)
	return out, req.Send()
}

// PutPolicyWithContext is the same as PutPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) PutPolicyWithContext(ctx aws.Context, input *PutPolicyInput, opts ...request.Option) (*PutPolicyOutput, error) {
	req, out := c.PutPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreCertificateAuthority = "RestoreCertificateAuthority"

// RestoreCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the RestoreCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreCertificateAuthority for more information on using the RestoreCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreCertificateAuthorityRequest method.
//    req, resp := client.RestoreCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RestoreCertificateAuthority
func (c *ACMPCA) RestoreCertificateAuthorityRequest(input *RestoreCertificateAuthorityInput) (req *request.Request, output *RestoreCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opRestoreCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreCertificateAuthorityInput{}
	}

	output = &RestoreCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RestoreCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Restores a certificate authority (CA) that is in the DELETED state. You can
// restore a CA during the period that you defined in the PermanentDeletionTimeInDays
// parameter of the DeleteCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html)
// action. Currently, you can specify 7 to 30 days. If you did not specify a
// PermanentDeletionTimeInDays value, by default you can restore the CA at any
// time in a 30 day period. You can check the time remaining in the restoration
// period of a private CA in the DELETED state by calling the DescribeCertificateAuthority
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html)
// or ListCertificateAuthorities (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
// actions. The status of a restored CA is set to its pre-deletion status when
// the RestoreCertificateAuthority action returns. To change its status to ACTIVE,
// call the UpdateCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html)
// action. If the private CA was in the PENDING_CERTIFICATE state at deletion,
// you must use the ImportCertificateAuthorityCertificate (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html)
// action to import a certificate authority into the private CA before it can
// be activated. You cannot restore a CA after the restoration period has ended.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation RestoreCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RestoreCertificateAuthority
func (c *ACMPCA) RestoreCertificateAuthority(input *RestoreCertificateAuthorityInput) (*RestoreCertificateAuthorityOutput, error) {
	req, out := c.RestoreCertificateAuthorityRequest(input)
	return out, req.Send()
}

// RestoreCertificateAuthorityWithContext is the same as RestoreCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) RestoreCertificateAuthorityWithContext(ctx aws.Context, input *RestoreCertificateAuthorityInput, opts ...request.Option) (*RestoreCertificateAuthorityOutput, error) {
	req, out := c.RestoreCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeCertificate = "RevokeCertificate"

// RevokeCertificateRequest generates a "aws/request.Request" representing the
// client's request for the RevokeCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeCertificate for more information on using the RevokeCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeCertificateRequest method.
//    req, resp := client.RevokeCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RevokeCertificate
func (c *ACMPCA) RevokeCertificateRequest(input *RevokeCertificateInput) (req *request.Request, output *RevokeCertificateOutput) {
	op := &request.Operation{
		Name:       opRevokeCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeCertificateInput{}
	}

	output = &RevokeCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeCertificate API operation for AWS Certificate Manager Private Certificate Authority.
//
// Revokes a certificate that was issued inside ACM Private CA. If you enable
// a certificate revocation list (CRL) when you create or update your private
// CA, information about the revoked certificates will be included in the CRL.
// ACM Private CA writes the CRL to an S3 bucket that you specify. A CRL is
// typically updated approximately 30 minutes after a certificate is revoked.
// If for any reason the CRL update fails, ACM Private CA attempts makes further
// attempts every 15 minutes. With Amazon CloudWatch, you can create alarms
// for the metrics CRLGenerated and MisconfiguredCRLBucket. For more information,
// see Supported CloudWatch Metrics (https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCloudWatch.html).
//
// Both PCA and the IAM principal must have permission to write to the S3 bucket
// that you specify. If the IAM principal making the call does not have permission
// to write to the bucket, then an exception is thrown. For more information,
// see Access policies for CRLs in Amazon S3 (https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
//
// ACM Private CA also writes revocation information to the audit report. For
// more information, see CreateCertificateAuthorityAuditReport (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html).
//
// You cannot revoke a root CA self-signed certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation RevokeCertificate for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   A previous update to your private CA is still ongoing.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidRequestException
//   The request action cannot be performed or is prohibited.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * LimitExceededException
//   An ACM Private CA quota has been exceeded. See the exception message returned
//   to determine the quota that was exceeded.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * RequestAlreadyProcessedException
//   Your request has already been completed.
//
//   * RequestInProgressException
//   Your request is already in progress.
//
//   * RequestFailedException
//   The request has failed for an unspecified reason.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/RevokeCertificate
func (c *ACMPCA) RevokeCertificate(input *RevokeCertificateInput) (*RevokeCertificateOutput, error) {
	req, out := c.RevokeCertificateRequest(input)
	return out, req.Send()
}

// RevokeCertificateWithContext is the same as RevokeCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) RevokeCertificateWithContext(ctx aws.Context, input *RevokeCertificateInput, opts ...request.Option) (*RevokeCertificateOutput, error) {
	req, out := c.RevokeCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagCertificateAuthority = "TagCertificateAuthority"

// TagCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the TagCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagCertificateAuthority for more information on using the TagCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagCertificateAuthorityRequest method.
//    req, resp := client.TagCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/TagCertificateAuthority
func (c *ACMPCA) TagCertificateAuthorityRequest(input *TagCertificateAuthorityInput) (req *request.Request, output *TagCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opTagCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagCertificateAuthorityInput{}
	}

	output = &TagCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Adds one or more tags to your private CA. Tags are labels that you can use
// to identify and organize your Amazon Web Services resources. Each tag consists
// of a key and an optional value. You specify the private CA on input by its
// Amazon Resource Name (ARN). You specify the tag by using a key-value pair.
// You can apply a tag to just one private CA if you want to identify a specific
// characteristic of that CA, or you can apply the same tag to multiple private
// CAs if you want to filter for a common relationship among those CAs. To remove
// one or more tags, use the UntagCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html)
// action. Call the ListTags (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html)
// action to see what tags are associated with your CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation TagCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * InvalidTagException
//   The tag associated with the CA is not valid. The invalid argument is contained
//   in the message field.
//
//   * TooManyTagsException
//   You can associate up to 50 tags with a private CA. Exception information
//   is contained in the exception message field.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/TagCertificateAuthority
func (c *ACMPCA) TagCertificateAuthority(input *TagCertificateAuthorityInput) (*TagCertificateAuthorityOutput, error) {
	req, out := c.TagCertificateAuthorityRequest(input)
	return out, req.Send()
}

// TagCertificateAuthorityWithContext is the same as TagCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See TagCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) TagCertificateAuthorityWithContext(ctx aws.Context, input *TagCertificateAuthorityInput, opts ...request.Option) (*TagCertificateAuthorityOutput, error) {
	req, out := c.TagCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagCertificateAuthority = "UntagCertificateAuthority"

// UntagCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the UntagCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagCertificateAuthority for more information on using the UntagCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagCertificateAuthorityRequest method.
//    req, resp := client.UntagCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UntagCertificateAuthority
func (c *ACMPCA) UntagCertificateAuthorityRequest(input *UntagCertificateAuthorityInput) (req *request.Request, output *UntagCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opUntagCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagCertificateAuthorityInput{}
	}

	output = &UntagCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Remove one or more tags from your private CA. A tag consists of a key-value
// pair. If you do not specify the value portion of the tag when calling this
// action, the tag will be removed regardless of value. If you specify a value,
// the tag is removed only if it is associated with the specified value. To
// add tags to a private CA, use the TagCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html).
// Call the ListTags (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html)
// action to see what tags are associated with your CA.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation UntagCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * InvalidTagException
//   The tag associated with the CA is not valid. The invalid argument is contained
//   in the message field.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UntagCertificateAuthority
func (c *ACMPCA) UntagCertificateAuthority(input *UntagCertificateAuthorityInput) (*UntagCertificateAuthorityOutput, error) {
	req, out := c.UntagCertificateAuthorityRequest(input)
	return out, req.Send()
}

// UntagCertificateAuthorityWithContext is the same as UntagCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See UntagCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) UntagCertificateAuthorityWithContext(ctx aws.Context, input *UntagCertificateAuthorityInput, opts ...request.Option) (*UntagCertificateAuthorityOutput, error) {
	req, out := c.UntagCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCertificateAuthority = "UpdateCertificateAuthority"

// UpdateCertificateAuthorityRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCertificateAuthority operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCertificateAuthority for more information on using the UpdateCertificateAuthority
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCertificateAuthorityRequest method.
//    req, resp := client.UpdateCertificateAuthorityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UpdateCertificateAuthority
func (c *ACMPCA) UpdateCertificateAuthorityRequest(input *UpdateCertificateAuthorityInput) (req *request.Request, output *UpdateCertificateAuthorityOutput) {
	op := &request.Operation{
		Name:       opUpdateCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCertificateAuthorityInput{}
	}

	output = &UpdateCertificateAuthorityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCertificateAuthority API operation for AWS Certificate Manager Private Certificate Authority.
//
// Updates the status or configuration of a private certificate authority (CA).
// Your private CA must be in the ACTIVE or DISABLED state before you can update
// it. You can disable a private CA that is in the ACTIVE state or make a CA
// that is in the DISABLED state active again.
//
// Both PCA and the IAM principal must have permission to write to the S3 bucket
// that you specify. If the IAM principal making the call does not have permission
// to write to the bucket, then an exception is thrown. For more information,
// see Access policies for CRLs in Amazon S3 (https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html#s3-policies).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Certificate Manager Private Certificate Authority's
// API operation UpdateCertificateAuthority for usage and error information.
//
// Returned Error Types:
//   * ConcurrentModificationException
//   A previous update to your private CA is still ongoing.
//
//   * ResourceNotFoundException
//   A resource such as a private CA, S3 bucket, certificate, audit report, or
//   policy cannot be found.
//
//   * InvalidArgsException
//   One or more of the specified arguments was not valid.
//
//   * InvalidArnException
//   The requested Amazon Resource Name (ARN) does not refer to an existing resource.
//
//   * InvalidStateException
//   The state of the private CA does not allow this action to occur.
//
//   * InvalidPolicyException
//   The resource policy is invalid or is missing a required statement. For general
//   information about IAM policy and statement structure, see Overview of JSON
//   Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/UpdateCertificateAuthority
func (c *ACMPCA) UpdateCertificateAuthority(input *UpdateCertificateAuthorityInput) (*UpdateCertificateAuthorityOutput, error) {
	req, out := c.UpdateCertificateAuthorityRequest(input)
	return out, req.Send()
}

// UpdateCertificateAuthorityWithContext is the same as UpdateCertificateAuthority with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCertificateAuthority for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ACMPCA) UpdateCertificateAuthorityWithContext(ctx aws.Context, input *UpdateCertificateAuthorityInput, opts ...request.Option) (*UpdateCertificateAuthorityOutput, error) {
	req, out := c.UpdateCertificateAuthorityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains information about the certificate subject. The Subject field in
// the certificate identifies the entity that owns or controls the public key
// in the certificate. The entity can be a user, computer, device, or service.
// The Subject must contain an X.500 distinguished name (DN). A DN is a sequence
// of relative distinguished names (RDNs). The RDNs are separated by commas
// in the certificate.
type ASN1Subject struct {
	_ struct{} `type:"structure"`

	// For CA and end-entity certificates in a private PKI, the common name (CN)
	// can be any string within the length limit.
	//
	// Note: In publicly trusted certificates, the common name must be a fully qualified
	// domain name (FQDN) associated with the certificate subject.
	CommonName *string `type:"string"`

	// Two-digit code that specifies the country in which the certificate subject
	// located.
	Country *string `min:"2" type:"string"`

	// Contains a sequence of one or more X.500 relative distinguished names (RDNs),
	// each of which consists of an object identifier (OID) and a value. For more
	// information, see NIST’s definition of Object Identifier (OID) (https://csrc.nist.gov/glossary/term/Object_Identifier).
	//
	// Custom attributes cannot be used in combination with standard attributes.
	CustomAttributes []*CustomAttribute `min:"1" type:"list"`

	// Disambiguating information for the certificate subject.
	DistinguishedNameQualifier *string `type:"string"`

	// Typically a qualifier appended to the name of an individual. Examples include
	// Jr. for junior, Sr. for senior, and III for third.
	GenerationQualifier *string `type:"string"`

	// First name.
	GivenName *string `type:"string"`

	// Concatenation that typically contains the first letter of the GivenName,
	// the first letter of the middle name if one exists, and the first letter of
	// the Surname.
	Initials *string `type:"string"`

	// The locality (such as a city or town) in which the certificate subject is
	// located.
	Locality *string `type:"string"`

	// Legal name of the organization with which the certificate subject is affiliated.
	Organization *string `type:"string"`

	// A subdivision or unit of the organization (such as sales or finance) with
	// which the certificate subject is affiliated.
	OrganizationalUnit *string `type:"string"`

	// Typically a shortened version of a longer GivenName. For example, Jonathan
	// is often shortened to John. Elizabeth is often shortened to Beth, Liz, or
	// Eliza.
	Pseudonym *string `type:"string"`

	// The certificate serial number.
	SerialNumber *string `type:"string"`

	// State in which the subject of the certificate is located.
	State *string `type:"string"`

	// Family name. In the US and the UK, for example, the surname of an individual
	// is ordered last. In Asian cultures the surname is typically ordered first.
	Surname *string `type:"string"`

	// A title such as Mr. or Ms., which is pre-pended to the name to refer formally
	// to the certificate subject.
	Title *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ASN1Subject) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ASN1Subject) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ASN1Subject) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ASN1Subject"}
	if s.Country != nil && len(*s.Country) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Country", 2))
	}
	if s.CustomAttributes != nil && len(s.CustomAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomAttributes", 1))
	}
	if s.CustomAttributes != nil {
		for i, v := range s.CustomAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommonName sets the CommonName field's value.
func (s *ASN1Subject) SetCommonName(v string) *ASN1Subject {
	s.CommonName = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *ASN1Subject) SetCountry(v string) *ASN1Subject {
	s.Country = &v
	return s
}

// SetCustomAttributes sets the CustomAttributes field's value.
func (s *ASN1Subject) SetCustomAttributes(v []*CustomAttribute) *ASN1Subject {
	s.CustomAttributes = v
	return s
}

// SetDistinguishedNameQualifier sets the DistinguishedNameQualifier field's value.
func (s *ASN1Subject) SetDistinguishedNameQualifier(v string) *ASN1Subject {
	s.DistinguishedNameQualifier = &v
	return s
}

// SetGenerationQualifier sets the GenerationQualifier field's value.
func (s *ASN1Subject) SetGenerationQualifier(v string) *ASN1Subject {
	s.GenerationQualifier = &v
	return s
}

// SetGivenName sets the GivenName field's value.
func (s *ASN1Subject) SetGivenName(v string) *ASN1Subject {
	s.GivenName = &v
	return s
}

// SetInitials sets the Initials field's value.
func (s *ASN1Subject) SetInitials(v string) *ASN1Subject {
	s.Initials = &v
	return s
}

// SetLocality sets the Locality field's value.
func (s *ASN1Subject) SetLocality(v string) *ASN1Subject {
	s.Locality = &v
	return s
}

// SetOrganization sets the Organization field's value.
func (s *ASN1Subject) SetOrganization(v string) *ASN1Subject {
	s.Organization = &v
	return s
}

// SetOrganizationalUnit sets the OrganizationalUnit field's value.
func (s *ASN1Subject) SetOrganizationalUnit(v string) *ASN1Subject {
	s.OrganizationalUnit = &v
	return s
}

// SetPseudonym sets the Pseudonym field's value.
func (s *ASN1Subject) SetPseudonym(v string) *ASN1Subject {
	s.Pseudonym = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *ASN1Subject) SetSerialNumber(v string) *ASN1Subject {
	s.SerialNumber = &v
	return s
}

// SetState sets the State field's value.
func (s *ASN1Subject) SetState(v string) *ASN1Subject {
	s.State = &v
	return s
}

// SetSurname sets the Surname field's value.
func (s *ASN1Subject) SetSurname(v string) *ASN1Subject {
	s.Surname = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *ASN1Subject) SetTitle(v string) *ASN1Subject {
	s.Title = &v
	return s
}

// Provides access information used by the authorityInfoAccess and subjectInfoAccess
// extensions described in RFC 5280 (https://datatracker.ietf.org/doc/html/rfc5280).
type AccessDescription struct {
	_ struct{} `type:"structure"`

	// The location of AccessDescription information.
	//
	// AccessLocation is a required field
	AccessLocation *GeneralName `type:"structure" required:"true"`

	// The type and format of AccessDescription information.
	//
	// AccessMethod is a required field
	AccessMethod *AccessMethod `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDescription) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessDescription) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessDescription"}
	if s.AccessLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessLocation"))
	}
	if s.AccessMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessMethod"))
	}
	if s.AccessLocation != nil {
		if err := s.AccessLocation.Validate(); err != nil {
			invalidParams.AddNested("AccessLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessLocation sets the AccessLocation field's value.
func (s *AccessDescription) SetAccessLocation(v *GeneralName) *AccessDescription {
	s.AccessLocation = v
	return s
}

// SetAccessMethod sets the AccessMethod field's value.
func (s *AccessDescription) SetAccessMethod(v *AccessMethod) *AccessDescription {
	s.AccessMethod = v
	return s
}

// Describes the type and format of extension access. Only one of CustomObjectIdentifier
// or AccessMethodType may be provided. Providing both results in InvalidArgsException.
type AccessMethod struct {
	_ struct{} `type:"structure"`

	// Specifies the AccessMethod.
	AccessMethodType *string `type:"string" enum:"AccessMethodType"`

	// An object identifier (OID) specifying the AccessMethod. The OID must satisfy
	// the regular expression shown below. For more information, see NIST's definition
	// of Object Identifier (OID) (https://csrc.nist.gov/glossary/term/Object_Identifier).
	CustomObjectIdentifier *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessMethod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessMethod) GoString() string {
	return s.String()
}

// SetAccessMethodType sets the AccessMethodType field's value.
func (s *AccessMethod) SetAccessMethodType(v string) *AccessMethod {
	s.AccessMethodType = &v
	return s
}

// SetCustomObjectIdentifier sets the CustomObjectIdentifier field's value.
func (s *AccessMethod) SetCustomObjectIdentifier(v string) *AccessMethod {
	s.CustomObjectIdentifier = &v
	return s
}

// Contains X.509 certificate information to be placed in an issued certificate.
// An APIPassthrough or APICSRPassthrough template variant must be selected,
// or else this parameter is ignored.
//
// If conflicting or duplicate certificate information is supplied from other
// sources, ACM Private CA applies order of operation rules (https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations)
// to determine what information is used.
type ApiPassthrough struct {
	_ struct{} `type:"structure"`

	// Specifies X.509 extension information for a certificate.
	Extensions *Extensions `type:"structure"`

	// Contains information about the certificate subject. The Subject field in
	// the certificate identifies the entity that owns or controls the public key
	// in the certificate. The entity can be a user, computer, device, or service.
	// The Subject must contain an X.500 distinguished name (DN). A DN is a sequence
	// of relative distinguished names (RDNs). The RDNs are separated by commas
	// in the certificate.
	Subject *ASN1Subject `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiPassthrough) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiPassthrough) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApiPassthrough) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApiPassthrough"}
	if s.Extensions != nil {
		if err := s.Extensions.Validate(); err != nil {
			invalidParams.AddNested("Extensions", err.(request.ErrInvalidParams))
		}
	}
	if s.Subject != nil {
		if err := s.Subject.Validate(); err != nil {
			invalidParams.AddNested("Subject", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExtensions sets the Extensions field's value.
func (s *ApiPassthrough) SetExtensions(v *Extensions) *ApiPassthrough {
	s.Extensions = v
	return s
}

// SetSubject sets the Subject field's value.
func (s *ApiPassthrough) SetSubject(v *ASN1Subject) *ApiPassthrough {
	s.Subject = v
	return s
}

// Contains information about your private certificate authority (CA). Your
// private CA can issue and revoke X.509 digital certificates. Digital certificates
// verify that the entity named in the certificate Subject field owns or controls
// the public key contained in the Subject Public Key Info field. Call the CreateCertificateAuthority
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
// action to create your private CA. You must then call the GetCertificateAuthorityCertificate
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCertificate.html)
// action to retrieve a private CA certificate signing request (CSR). Sign the
// CSR with your ACM Private CA-hosted or on-premises root or subordinate CA
// certificate. Call the ImportCertificateAuthorityCertificate (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html)
// action to import the signed certificate into Certificate Manager (ACM).
type CertificateAuthority struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) for your private certificate authority (CA). The
	// format is 12345678-1234-1234-1234-123456789012 .
	Arn *string `min:"5" type:"string"`

	// Your private CA configuration.
	CertificateAuthorityConfiguration *CertificateAuthorityConfiguration `type:"structure"`

	// Date and time at which your private CA was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Reason the request to create your private CA failed.
	FailureReason *string `type:"string" enum:"FailureReason"`

	// Defines a cryptographic key management compliance standard used for handling
	// CA keys.
	//
	// Default: FIPS_140_2_LEVEL_3_OR_HIGHER
	//
	// Note: Amazon Web Services Region ap-northeast-3 supports only FIPS_140_2_LEVEL_2_OR_HIGHER.
	// You must explicitly specify this parameter and value when creating a CA in
	// that Region. Specifying a different value (or no value) results in an InvalidArgsException
	// with the message "A certificate authority cannot be created in this region
	// with the specified security standard."
	KeyStorageSecurityStandard *string `type:"string" enum:"KeyStorageSecurityStandard"`

	// Date and time at which your private CA was last updated.
	LastStateChangeAt *time.Time `type:"timestamp"`

	// Date and time after which your private CA certificate is not valid.
	NotAfter *time.Time `type:"timestamp"`

	// Date and time before which your private CA certificate is not valid.
	NotBefore *time.Time `type:"timestamp"`

	// The Amazon Web Services account ID that owns the certificate authority.
	OwnerAccount *string `min:"12" type:"string"`

	// The period during which a deleted CA can be restored. For more information,
	// see the PermanentDeletionTimeInDays parameter of the DeleteCertificateAuthorityRequest
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthorityRequest.html)
	// action.
	RestorableUntil *time.Time `type:"timestamp"`

	// Information about the Online Certificate Status Protocol (OCSP) configuration
	// or certificate revocation list (CRL) created and maintained by your private
	// CA.
	RevocationConfiguration *RevocationConfiguration `type:"structure"`

	// Serial number of your private CA.
	Serial *string `type:"string"`

	// Status of your private CA.
	Status *string `type:"string" enum:"CertificateAuthorityStatus"`

	// Type of your private CA.
	Type *string `type:"string" enum:"CertificateAuthorityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateAuthority) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateAuthority) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CertificateAuthority) SetArn(v string) *CertificateAuthority {
	s.Arn = &v
	return s
}

// SetCertificateAuthorityConfiguration sets the CertificateAuthorityConfiguration field's value.
func (s *CertificateAuthority) SetCertificateAuthorityConfiguration(v *CertificateAuthorityConfiguration) *CertificateAuthority {
	s.CertificateAuthorityConfiguration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CertificateAuthority) SetCreatedAt(v time.Time) *CertificateAuthority {
	s.CreatedAt = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CertificateAuthority) SetFailureReason(v string) *CertificateAuthority {
	s.FailureReason = &v
	return s
}

// SetKeyStorageSecurityStandard sets the KeyStorageSecurityStandard field's value.
func (s *CertificateAuthority) SetKeyStorageSecurityStandard(v string) *CertificateAuthority {
	s.KeyStorageSecurityStandard = &v
	return s
}

// SetLastStateChangeAt sets the LastStateChangeAt field's value.
func (s *CertificateAuthority) SetLastStateChangeAt(v time.Time) *CertificateAuthority {
	s.LastStateChangeAt = &v
	return s
}

// SetNotAfter sets the NotAfter field's value.
func (s *CertificateAuthority) SetNotAfter(v time.Time) *CertificateAuthority {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *CertificateAuthority) SetNotBefore(v time.Time) *CertificateAuthority {
	s.NotBefore = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *CertificateAuthority) SetOwnerAccount(v string) *CertificateAuthority {
	s.OwnerAccount = &v
	return s
}

// SetRestorableUntil sets the RestorableUntil field's value.
func (s *CertificateAuthority) SetRestorableUntil(v time.Time) *CertificateAuthority {
	s.RestorableUntil = &v
	return s
}

// SetRevocationConfiguration sets the RevocationConfiguration field's value.
func (s *CertificateAuthority) SetRevocationConfiguration(v *RevocationConfiguration) *CertificateAuthority {
	s.RevocationConfiguration = v
	return s
}

// SetSerial sets the Serial field's value.
func (s *CertificateAuthority) SetSerial(v string) *CertificateAuthority {
	s.Serial = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CertificateAuthority) SetStatus(v string) *CertificateAuthority {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *CertificateAuthority) SetType(v string) *CertificateAuthority {
	s.Type = &v
	return s
}

// Contains configuration information for your private certificate authority
// (CA). This includes information about the class of public key algorithm and
// the key pair that your private CA creates when it issues a certificate. It
// also includes the signature algorithm that it uses when issuing certificates,
// and its X.500 distinguished name. You must specify this information when
// you call the CreateCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
// action.
type CertificateAuthorityConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies information to be added to the extension section of the certificate
	// signing request (CSR).
	CsrExtensions *CsrExtensions `type:"structure"`

	// Type of the public key algorithm and size, in bits, of the key pair that
	// your CA creates when it issues a certificate. When you create a subordinate
	// CA, you must use a key algorithm supported by the parent CA.
	//
	// KeyAlgorithm is a required field
	KeyAlgorithm *string `type:"string" required:"true" enum:"KeyAlgorithm"`

	// Name of the algorithm your private CA uses to sign certificate requests.
	//
	// This parameter should not be confused with the SigningAlgorithm parameter
	// used to sign certificates when they are issued.
	//
	// SigningAlgorithm is a required field
	SigningAlgorithm *string `type:"string" required:"true" enum:"SigningAlgorithm"`

	// Structure that contains X.500 distinguished name information for your private
	// CA.
	//
	// Subject is a required field
	Subject *ASN1Subject `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateAuthorityConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateAuthorityConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CertificateAuthorityConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CertificateAuthorityConfiguration"}
	if s.KeyAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyAlgorithm"))
	}
	if s.SigningAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("SigningAlgorithm"))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}
	if s.CsrExtensions != nil {
		if err := s.CsrExtensions.Validate(); err != nil {
			invalidParams.AddNested("CsrExtensions", err.(request.ErrInvalidParams))
		}
	}
	if s.Subject != nil {
		if err := s.Subject.Validate(); err != nil {
			invalidParams.AddNested("Subject", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsrExtensions sets the CsrExtensions field's value.
func (s *CertificateAuthorityConfiguration) SetCsrExtensions(v *CsrExtensions) *CertificateAuthorityConfiguration {
	s.CsrExtensions = v
	return s
}

// SetKeyAlgorithm sets the KeyAlgorithm field's value.
func (s *CertificateAuthorityConfiguration) SetKeyAlgorithm(v string) *CertificateAuthorityConfiguration {
	s.KeyAlgorithm = &v
	return s
}

// SetSigningAlgorithm sets the SigningAlgorithm field's value.
func (s *CertificateAuthorityConfiguration) SetSigningAlgorithm(v string) *CertificateAuthorityConfiguration {
	s.SigningAlgorithm = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *CertificateAuthorityConfiguration) SetSubject(v *ASN1Subject) *CertificateAuthorityConfiguration {
	s.Subject = v
	return s
}

// The certificate authority certificate you are importing does not comply with
// conditions specified in the certificate that signed it.
type CertificateMismatchException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateMismatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CertificateMismatchException) GoString() string {
	return s.String()
}

func newErrorCertificateMismatchException(v protocol.ResponseMetadata) error {
	return &CertificateMismatchException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CertificateMismatchException) Code() string {
	return "CertificateMismatchException"
}

// Message returns the exception's message.
func (s *CertificateMismatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CertificateMismatchException) OrigErr() error {
	return nil
}

func (s *CertificateMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CertificateMismatchException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CertificateMismatchException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A previous update to your private CA is still ongoing.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateCertificateAuthorityAuditReportInput struct {
	_ struct{} `type:"structure"`

	// The format in which to create the report. This can be either JSON or CSV.
	//
	// AuditReportResponseFormat is a required field
	AuditReportResponseFormat *string `type:"string" required:"true" enum:"AuditReportResponseFormat"`

	// The Amazon Resource Name (ARN) of the CA to be audited. This is of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The name of the S3 bucket that will contain the audit report.
	//
	// S3BucketName is a required field
	S3BucketName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCertificateAuthorityAuditReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCertificateAuthorityAuditReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCertificateAuthorityAuditReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCertificateAuthorityAuditReportInput"}
	if s.AuditReportResponseFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("AuditReportResponseFormat"))
	}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuditReportResponseFormat sets the AuditReportResponseFormat field's value.
func (s *CreateCertificateAuthorityAuditReportInput) SetAuditReportResponseFormat(v string) *CreateCertificateAuthorityAuditReportInput {
	s.AuditReportResponseFormat = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *CreateCertificateAuthorityAuditReportInput) SetCertificateAuthorityArn(v string) *CreateCertificateAuthorityAuditReportInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CreateCertificateAuthorityAuditReportInput) SetS3BucketName(v string) *CreateCertificateAuthorityAuditReportInput {
	s.S3BucketName = &v
	return s
}

type CreateCertificateAuthorityAuditReportOutput struct {
	_ struct{} `type:"structure"`

	// An alphanumeric string that contains a report identifier.
	AuditReportId *string `min:"36" type:"string"`

	// The key that uniquely identifies the report file in your S3 bucket.
	S3Key *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCertificateAuthorityAuditReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCertificateAuthorityAuditReportOutput) GoString() string {
	return s.String()
}

// SetAuditReportId sets the AuditReportId field's value.
func (s *CreateCertificateAuthorityAuditReportOutput) SetAuditReportId(v string) *CreateCertificateAuthorityAuditReportOutput {
	s.AuditReportId = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *CreateCertificateAuthorityAuditReportOutput) SetS3Key(v string) *CreateCertificateAuthorityAuditReportOutput {
	s.S3Key = &v
	return s
}

type CreateCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// Name and bit size of the private key algorithm, the name of the signing algorithm,
	// and X.500 certificate subject information.
	//
	// CertificateAuthorityConfiguration is a required field
	CertificateAuthorityConfiguration *CertificateAuthorityConfiguration `type:"structure" required:"true"`

	// The type of the certificate authority.
	//
	// CertificateAuthorityType is a required field
	CertificateAuthorityType *string `type:"string" required:"true" enum:"CertificateAuthorityType"`

	// Custom string that can be used to distinguish between calls to the CreateCertificateAuthority
	// action. Idempotency tokens for CreateCertificateAuthority time out after
	// five minutes. Therefore, if you call CreateCertificateAuthority multiple
	// times with the same idempotency token within five minutes, ACM Private CA
	// recognizes that you are requesting only certificate authority and will issue
	// only one. If you change the idempotency token for each call, PCA recognizes
	// that you are requesting multiple certificate authorities.
	IdempotencyToken *string `min:"1" type:"string"`

	// Specifies a cryptographic key management compliance standard used for handling
	// CA keys.
	//
	// Default: FIPS_140_2_LEVEL_3_OR_HIGHER
	//
	// Note: FIPS_140_2_LEVEL_3_OR_HIGHER is not supported in Region ap-northeast-3.
	// When creating a CA in the ap-northeast-3, you must provide FIPS_140_2_LEVEL_2_OR_HIGHER
	// as the argument for KeyStorageSecurityStandard. Failure to do this results
	// in an InvalidArgsException with the message, "A certificate authority cannot
	// be created in this region with the specified security standard."
	KeyStorageSecurityStandard *string `type:"string" enum:"KeyStorageSecurityStandard"`

	// Contains information to enable Online Certificate Status Protocol (OCSP)
	// support, to enable a certificate revocation list (CRL), to enable both, or
	// to enable neither. The default is for both certificate validation mechanisms
	// to be disabled. For more information, see the OcspConfiguration (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html)
	// and CrlConfiguration (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html)
	// types.
	RevocationConfiguration *RevocationConfiguration `type:"structure"`

	// Key-value pairs that will be attached to the new private CA. You can associate
	// up to 50 tags with a private CA. For information using tags with IAM to manage
	// permissions, see Controlling Access Using IAM Tags (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCertificateAuthorityInput"}
	if s.CertificateAuthorityConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityConfiguration"))
	}
	if s.CertificateAuthorityType == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityType"))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.CertificateAuthorityConfiguration != nil {
		if err := s.CertificateAuthorityConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CertificateAuthorityConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RevocationConfiguration != nil {
		if err := s.RevocationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RevocationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityConfiguration sets the CertificateAuthorityConfiguration field's value.
func (s *CreateCertificateAuthorityInput) SetCertificateAuthorityConfiguration(v *CertificateAuthorityConfiguration) *CreateCertificateAuthorityInput {
	s.CertificateAuthorityConfiguration = v
	return s
}

// SetCertificateAuthorityType sets the CertificateAuthorityType field's value.
func (s *CreateCertificateAuthorityInput) SetCertificateAuthorityType(v string) *CreateCertificateAuthorityInput {
	s.CertificateAuthorityType = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateCertificateAuthorityInput) SetIdempotencyToken(v string) *CreateCertificateAuthorityInput {
	s.IdempotencyToken = &v
	return s
}

// SetKeyStorageSecurityStandard sets the KeyStorageSecurityStandard field's value.
func (s *CreateCertificateAuthorityInput) SetKeyStorageSecurityStandard(v string) *CreateCertificateAuthorityInput {
	s.KeyStorageSecurityStandard = &v
	return s
}

// SetRevocationConfiguration sets the RevocationConfiguration field's value.
func (s *CreateCertificateAuthorityInput) SetRevocationConfiguration(v *RevocationConfiguration) *CreateCertificateAuthorityInput {
	s.RevocationConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCertificateAuthorityInput) SetTags(v []*Tag) *CreateCertificateAuthorityInput {
	s.Tags = v
	return s
}

type CreateCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`

	// If successful, the Amazon Resource Name (ARN) of the certificate authority
	// (CA). This is of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	CertificateAuthorityArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *CreateCertificateAuthorityOutput) SetCertificateAuthorityArn(v string) *CreateCertificateAuthorityOutput {
	s.CertificateAuthorityArn = &v
	return s
}

type CreatePermissionInput struct {
	_ struct{} `type:"structure"`

	// The actions that the specified Amazon Web Services service principal can
	// use. These include IssueCertificate, GetCertificate, and ListPermissions.
	//
	// Actions is a required field
	Actions []*string `min:"1" type:"list" required:"true" enum:"ActionType"`

	// The Amazon Resource Name (ARN) of the CA that grants the permissions. You
	// can find the ARN by calling the ListCertificateAuthorities (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
	// action. This must have the following form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The Amazon Web Services service or identity that receives the permission.
	// At this time, the only valid principal is acm.amazonaws.com.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// The ID of the calling account.
	SourceAccount *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePermissionInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Actions != nil && len(s.Actions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Actions", 1))
	}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.SourceAccount != nil && len(*s.SourceAccount) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SourceAccount", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreatePermissionInput) SetActions(v []*string) *CreatePermissionInput {
	s.Actions = v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *CreatePermissionInput) SetCertificateAuthorityArn(v string) *CreatePermissionInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *CreatePermissionInput) SetPrincipal(v string) *CreatePermissionInput {
	s.Principal = &v
	return s
}

// SetSourceAccount sets the SourceAccount field's value.
func (s *CreatePermissionInput) SetSourceAccount(v string) *CreatePermissionInput {
	s.SourceAccount = &v
	return s
}

type CreatePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionOutput) GoString() string {
	return s.String()
}

// Contains configuration information for a certificate revocation list (CRL).
// Your private certificate authority (CA) creates base CRLs. Delta CRLs are
// not supported. You can enable CRLs for your new or an existing private CA
// by setting the Enabled parameter to true. Your private CA writes CRLs to
// an S3 bucket that you specify in the S3BucketName parameter. You can hide
// the name of your bucket by specifying a value for the CustomCname parameter.
// Your private CA copies the CNAME or the S3 bucket name to the CRL Distribution
// Points extension of each certificate it issues. Your S3 bucket policy must
// give write permission to ACM Private CA.
//
// ACM Private CA assets that are stored in Amazon S3 can be protected with
// encryption. For more information, see Encrypting Your CRLs (https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption).
//
// Your private CA uses the value in the ExpirationInDays parameter to calculate
// the nextUpdate field in the CRL. The CRL is refreshed prior to a certificate's
// expiration date or when a certificate is revoked. When a certificate is revoked,
// it appears in the CRL until the certificate expires, and then in one additional
// CRL after expiration, and it always appears in the audit report.
//
// A CRL is typically updated approximately 30 minutes after a certificate is
// revoked. If for any reason a CRL update fails, ACM Private CA makes further
// attempts every 15 minutes.
//
// CRLs contain the following fields:
//
//    * Version: The current version number defined in RFC 5280 is V2. The integer
//    value is 0x1.
//
//    * Signature Algorithm: The name of the algorithm used to sign the CRL.
//
//    * Issuer: The X.500 distinguished name of your private CA that issued
//    the CRL.
//
//    * Last Update: The issue date and time of this CRL.
//
//    * Next Update: The day and time by which the next CRL will be issued.
//
//    * Revoked Certificates: List of revoked certificates. Each list item contains
//    the following information. Serial Number: The serial number, in hexadecimal
//    format, of the revoked certificate. Revocation Date: Date and time the
//    certificate was revoked. CRL Entry Extensions: Optional extensions for
//    the CRL entry. X509v3 CRL Reason Code: Reason the certificate was revoked.
//
//    * CRL Extensions: Optional extensions for the CRL. X509v3 Authority Key
//    Identifier: Identifies the public key associated with the private key
//    used to sign the certificate. X509v3 CRL Number:: Decimal sequence number
//    for the CRL.
//
//    * Signature Algorithm: Algorithm used by your private CA to sign the CRL.
//
//    * Signature Value: Signature computed over the CRL.
//
// Certificate revocation lists created by ACM Private CA are DER-encoded. You
// can use the following OpenSSL command to list a CRL.
//
// openssl crl -inform DER -text -in crl_path -noout
//
// For more information, see Planning a certificate revocation list (CRL) (https://docs.aws.amazon.com/acm-pca/latest/userguide/crl-planning.html)
// in the Certificate Manager Private Certificate Authority (PCA) User Guide
type CrlConfiguration struct {
	_ struct{} `type:"structure"`

	// Name inserted into the certificate CRL Distribution Points extension that
	// enables the use of an alias for the CRL distribution point. Use this value
	// if you don't want the name of your S3 bucket to be public.
	CustomCname *string `type:"string"`

	// Boolean value that specifies whether certificate revocation lists (CRLs)
	// are enabled. You can use this value to enable certificate revocation for
	// a new CA when you call the CreateCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
	// action or for an existing CA when you call the UpdateCertificateAuthority
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html)
	// action.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Validity period of the CRL in days.
	ExpirationInDays *int64 `min:"1" type:"integer"`

	// Name of the S3 bucket that contains the CRL. If you do not provide a value
	// for the CustomCname argument, the name of your S3 bucket is placed into the
	// CRL Distribution Points extension of the issued certificate. You can change
	// the name of your bucket by calling the UpdateCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html)
	// operation. You must specify a bucket policy (https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-policies)
	// that allows ACM Private CA to write the CRL to your bucket.
	S3BucketName *string `min:"3" type:"string"`

	// Determines whether the CRL will be publicly readable or privately held in
	// the CRL Amazon S3 bucket. If you choose PUBLIC_READ, the CRL will be accessible
	// over the public internet. If you choose BUCKET_OWNER_FULL_CONTROL, only the
	// owner of the CRL S3 bucket can access the CRL, and your PKI clients may need
	// an alternative method of access.
	//
	// If no value is specified, the default is PUBLIC_READ.
	//
	// Note: This default can cause CA creation to fail in some circumstances. If
	// you have have enabled the Block Public Access (BPA) feature in your S3 account,
	// then you must specify the value of this parameter as BUCKET_OWNER_FULL_CONTROL,
	// and not doing so results in an error. If you have disabled BPA in S3, then
	// you can specify either BUCKET_OWNER_FULL_CONTROL or PUBLIC_READ as the value.
	//
	// For more information, see Blocking public access to the S3 bucket (https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#s3-bpa).
	S3ObjectAcl *string `type:"string" enum:"S3ObjectAcl"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrlConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrlConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CrlConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CrlConfiguration"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}
	if s.ExpirationInDays != nil && *s.ExpirationInDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExpirationInDays", 1))
	}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomCname sets the CustomCname field's value.
func (s *CrlConfiguration) SetCustomCname(v string) *CrlConfiguration {
	s.CustomCname = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *CrlConfiguration) SetEnabled(v bool) *CrlConfiguration {
	s.Enabled = &v
	return s
}

// SetExpirationInDays sets the ExpirationInDays field's value.
func (s *CrlConfiguration) SetExpirationInDays(v int64) *CrlConfiguration {
	s.ExpirationInDays = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CrlConfiguration) SetS3BucketName(v string) *CrlConfiguration {
	s.S3BucketName = &v
	return s
}

// SetS3ObjectAcl sets the S3ObjectAcl field's value.
func (s *CrlConfiguration) SetS3ObjectAcl(v string) *CrlConfiguration {
	s.S3ObjectAcl = &v
	return s
}

// Describes the certificate extensions to be added to the certificate signing
// request (CSR).
type CsrExtensions struct {
	_ struct{} `type:"structure"`

	// Indicates the purpose of the certificate and of the key contained in the
	// certificate.
	KeyUsage *KeyUsage `type:"structure"`

	// For CA certificates, provides a path to additional information pertaining
	// to the CA, such as revocation and policy. For more information, see Subject
	// Information Access (https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.2.2)
	// in RFC 5280.
	SubjectInformationAccess []*AccessDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsrExtensions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CsrExtensions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CsrExtensions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CsrExtensions"}
	if s.SubjectInformationAccess != nil {
		for i, v := range s.SubjectInformationAccess {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubjectInformationAccess", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *CsrExtensions) SetKeyUsage(v *KeyUsage) *CsrExtensions {
	s.KeyUsage = v
	return s
}

// SetSubjectInformationAccess sets the SubjectInformationAccess field's value.
func (s *CsrExtensions) SetSubjectInformationAccess(v []*AccessDescription) *CsrExtensions {
	s.SubjectInformationAccess = v
	return s
}

// Defines the X.500 relative distinguished name (RDN).
type CustomAttribute struct {
	_ struct{} `type:"structure"`

	// Specifies the object identifier (OID) of the attribute type of the relative
	// distinguished name (RDN).
	//
	// ObjectIdentifier is a required field
	ObjectIdentifier *string `type:"string" required:"true"`

	// Specifies the attribute value of relative distinguished name (RDN).
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomAttribute"}
	if s.ObjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectIdentifier"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *CustomAttribute) SetObjectIdentifier(v string) *CustomAttribute {
	s.ObjectIdentifier = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CustomAttribute) SetValue(v string) *CustomAttribute {
	s.Value = &v
	return s
}

// Specifies the X.509 extension information for a certificate.
//
// Extensions present in CustomExtensions follow the ApiPassthrough template
// rules (https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations).
type CustomExtension struct {
	_ struct{} `type:"structure"`

	// Specifies the critical flag of the X.509 extension.
	Critical *bool `type:"boolean"`

	// Specifies the object identifier (OID) of the X.509 extension. For more information,
	// see the Global OID reference database. (https://oidref.com/2.5.29)
	//
	// ObjectIdentifier is a required field
	ObjectIdentifier *string `type:"string" required:"true"`

	// Specifies the base64-encoded value of the X.509 extension.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomExtension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomExtension) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomExtension) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomExtension"}
	if s.ObjectIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectIdentifier"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCritical sets the Critical field's value.
func (s *CustomExtension) SetCritical(v bool) *CustomExtension {
	s.Critical = &v
	return s
}

// SetObjectIdentifier sets the ObjectIdentifier field's value.
func (s *CustomExtension) SetObjectIdentifier(v string) *CustomExtension {
	s.ObjectIdentifier = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CustomExtension) SetValue(v string) *CustomExtension {
	s.Value = &v
	return s
}

type DeleteCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
	// This must have the following form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The number of days to make a CA restorable after it has been deleted. This
	// can be anywhere from 7 to 30 days, with 30 being the default.
	PermanentDeletionTimeInDays *int64 `min:"7" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.PermanentDeletionTimeInDays != nil && *s.PermanentDeletionTimeInDays < 7 {
		invalidParams.Add(request.NewErrParamMinValue("PermanentDeletionTimeInDays", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *DeleteCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *DeleteCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetPermanentDeletionTimeInDays sets the PermanentDeletionTimeInDays field's value.
func (s *DeleteCertificateAuthorityInput) SetPermanentDeletionTimeInDays(v int64) *DeleteCertificateAuthorityInput {
	s.PermanentDeletionTimeInDays = &v
	return s
}

type DeleteCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCertificateAuthorityOutput) GoString() string {
	return s.String()
}

type DeletePermissionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the private CA that issued the permissions.
	// You can find the CA's ARN by calling the ListCertificateAuthorities (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
	// action. This must have the following form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The Amazon Web Services service or identity that will have its CA permissions
	// revoked. At this time, the only valid service principal is acm.amazonaws.com
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// The Amazon Web Services account that calls this action.
	SourceAccount *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePermissionInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.SourceAccount != nil && len(*s.SourceAccount) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SourceAccount", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *DeletePermissionInput) SetCertificateAuthorityArn(v string) *DeletePermissionInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *DeletePermissionInput) SetPrincipal(v string) *DeletePermissionInput {
	s.Principal = &v
	return s
}

// SetSourceAccount sets the SourceAccount field's value.
func (s *DeletePermissionInput) SetSourceAccount(v string) *DeletePermissionInput {
	s.SourceAccount = &v
	return s
}

type DeletePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionOutput) GoString() string {
	return s.String()
}

type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the private CA that will have its policy
	// deleted. You can find the CA's ARN by calling the ListCertificateAuthorities
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
	// action. The ARN value must have the form arn:aws:acm-pca:region:account:certificate-authority/01234567-89ab-cdef-0123-0123456789ab.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeletePolicyInput) SetResourceArn(v string) *DeletePolicyInput {
	s.ResourceArn = &v
	return s
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

type DescribeCertificateAuthorityAuditReportInput struct {
	_ struct{} `type:"structure"`

	// The report ID returned by calling the CreateCertificateAuthorityAuditReport
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html)
	// action.
	//
	// AuditReportId is a required field
	AuditReportId *string `min:"36" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the private CA. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificateAuthorityAuditReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificateAuthorityAuditReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificateAuthorityAuditReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificateAuthorityAuditReportInput"}
	if s.AuditReportId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuditReportId"))
	}
	if s.AuditReportId != nil && len(*s.AuditReportId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AuditReportId", 36))
	}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuditReportId sets the AuditReportId field's value.
func (s *DescribeCertificateAuthorityAuditReportInput) SetAuditReportId(v string) *DescribeCertificateAuthorityAuditReportInput {
	s.AuditReportId = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *DescribeCertificateAuthorityAuditReportInput) SetCertificateAuthorityArn(v string) *DescribeCertificateAuthorityAuditReportInput {
	s.CertificateAuthorityArn = &v
	return s
}

type DescribeCertificateAuthorityAuditReportOutput struct {
	_ struct{} `type:"structure"`

	// Specifies whether report creation is in progress, has succeeded, or has failed.
	AuditReportStatus *string `type:"string" enum:"AuditReportStatus"`

	// The date and time at which the report was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Name of the S3 bucket that contains the report.
	S3BucketName *string `min:"3" type:"string"`

	// S3 key that uniquely identifies the report file in your S3 bucket.
	S3Key *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificateAuthorityAuditReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificateAuthorityAuditReportOutput) GoString() string {
	return s.String()
}

// SetAuditReportStatus sets the AuditReportStatus field's value.
func (s *DescribeCertificateAuthorityAuditReportOutput) SetAuditReportStatus(v string) *DescribeCertificateAuthorityAuditReportOutput {
	s.AuditReportStatus = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeCertificateAuthorityAuditReportOutput) SetCreatedAt(v time.Time) *DescribeCertificateAuthorityAuditReportOutput {
	s.CreatedAt = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *DescribeCertificateAuthorityAuditReportOutput) SetS3BucketName(v string) *DescribeCertificateAuthorityAuditReportOutput {
	s.S3BucketName = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *DescribeCertificateAuthorityAuditReportOutput) SetS3Key(v string) *DescribeCertificateAuthorityAuditReportOutput {
	s.S3Key = &v
	return s
}

type DescribeCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *DescribeCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *DescribeCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

type DescribeCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`

	// A CertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CertificateAuthority.html)
	// structure that contains information about your private CA.
	CertificateAuthority *CertificateAuthority `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// SetCertificateAuthority sets the CertificateAuthority field's value.
func (s *DescribeCertificateAuthorityOutput) SetCertificateAuthority(v *CertificateAuthority) *DescribeCertificateAuthorityOutput {
	s.CertificateAuthority = v
	return s
}

// Describes an Electronic Data Interchange (EDI) entity as described in as
// defined in Subject Alternative Name (https://datatracker.ietf.org/doc/html/rfc5280)
// in RFC 5280.
type EdiPartyName struct {
	_ struct{} `type:"structure"`

	// Specifies the name assigner.
	NameAssigner *string `type:"string"`

	// Specifies the party name.
	//
	// PartyName is a required field
	PartyName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdiPartyName) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EdiPartyName) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EdiPartyName) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EdiPartyName"}
	if s.PartyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PartyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNameAssigner sets the NameAssigner field's value.
func (s *EdiPartyName) SetNameAssigner(v string) *EdiPartyName {
	s.NameAssigner = &v
	return s
}

// SetPartyName sets the PartyName field's value.
func (s *EdiPartyName) SetPartyName(v string) *EdiPartyName {
	s.PartyName = &v
	return s
}

// Specifies additional purposes for which the certified public key may be used
// other than basic purposes indicated in the KeyUsage extension.
type ExtendedKeyUsage struct {
	_ struct{} `type:"structure"`

	// Specifies a custom ExtendedKeyUsage with an object identifier (OID).
	ExtendedKeyUsageObjectIdentifier *string `type:"string"`

	// Specifies a standard ExtendedKeyUsage as defined as in RFC 5280 (https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.12).
	ExtendedKeyUsageType *string `type:"string" enum:"ExtendedKeyUsageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendedKeyUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendedKeyUsage) GoString() string {
	return s.String()
}

// SetExtendedKeyUsageObjectIdentifier sets the ExtendedKeyUsageObjectIdentifier field's value.
func (s *ExtendedKeyUsage) SetExtendedKeyUsageObjectIdentifier(v string) *ExtendedKeyUsage {
	s.ExtendedKeyUsageObjectIdentifier = &v
	return s
}

// SetExtendedKeyUsageType sets the ExtendedKeyUsageType field's value.
func (s *ExtendedKeyUsage) SetExtendedKeyUsageType(v string) *ExtendedKeyUsage {
	s.ExtendedKeyUsageType = &v
	return s
}

// Contains X.509 extension information for a certificate.
type Extensions struct {
	_ struct{} `type:"structure"`

	// Contains a sequence of one or more policy information terms, each of which
	// consists of an object identifier (OID) and optional qualifiers. For more
	// information, see NIST's definition of Object Identifier (OID) (https://csrc.nist.gov/glossary/term/Object_Identifier).
	//
	// In an end-entity certificate, these terms indicate the policy under which
	// the certificate was issued and the purposes for which it may be used. In
	// a CA certificate, these terms limit the set of policies for certification
	// paths that include this certificate.
	CertificatePolicies []*PolicyInformation `min:"1" type:"list"`

	// Contains a sequence of one or more X.509 extensions, each of which consists
	// of an object identifier (OID), a base64-encoded value, and the critical flag.
	// For more information, see the Global OID reference database. (https://oidref.com/2.5.29)
	//
	// The OID value of a CustomExtension (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CustomExtension.html)
	// must not match the OID of a predefined extension.
	CustomExtensions []*CustomExtension `min:"1" type:"list"`

	// Specifies additional purposes for which the certified public key may be used
	// other than basic purposes indicated in the KeyUsage extension.
	ExtendedKeyUsage []*ExtendedKeyUsage `min:"1" type:"list"`

	// Defines one or more purposes for which the key contained in the certificate
	// can be used. Default value for each option is false.
	KeyUsage *KeyUsage `type:"structure"`

	// The subject alternative name extension allows identities to be bound to the
	// subject of the certificate. These identities may be included in addition
	// to or in place of the identity in the subject field of the certificate.
	SubjectAlternativeNames []*GeneralName `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Extensions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Extensions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Extensions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Extensions"}
	if s.CertificatePolicies != nil && len(s.CertificatePolicies) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificatePolicies", 1))
	}
	if s.CustomExtensions != nil && len(s.CustomExtensions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomExtensions", 1))
	}
	if s.ExtendedKeyUsage != nil && len(s.ExtendedKeyUsage) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExtendedKeyUsage", 1))
	}
	if s.SubjectAlternativeNames != nil && len(s.SubjectAlternativeNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubjectAlternativeNames", 1))
	}
	if s.CertificatePolicies != nil {
		for i, v := range s.CertificatePolicies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CertificatePolicies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CustomExtensions != nil {
		for i, v := range s.CustomExtensions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomExtensions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SubjectAlternativeNames != nil {
		for i, v := range s.SubjectAlternativeNames {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SubjectAlternativeNames", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificatePolicies sets the CertificatePolicies field's value.
func (s *Extensions) SetCertificatePolicies(v []*PolicyInformation) *Extensions {
	s.CertificatePolicies = v
	return s
}

// SetCustomExtensions sets the CustomExtensions field's value.
func (s *Extensions) SetCustomExtensions(v []*CustomExtension) *Extensions {
	s.CustomExtensions = v
	return s
}

// SetExtendedKeyUsage sets the ExtendedKeyUsage field's value.
func (s *Extensions) SetExtendedKeyUsage(v []*ExtendedKeyUsage) *Extensions {
	s.ExtendedKeyUsage = v
	return s
}

// SetKeyUsage sets the KeyUsage field's value.
func (s *Extensions) SetKeyUsage(v *KeyUsage) *Extensions {
	s.KeyUsage = v
	return s
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *Extensions) SetSubjectAlternativeNames(v []*GeneralName) *Extensions {
	s.SubjectAlternativeNames = v
	return s
}

// Describes an ASN.1 X.400 GeneralName as defined in RFC 5280 (https://datatracker.ietf.org/doc/html/rfc5280).
// Only one of the following naming options should be provided. Providing more
// than one option results in an InvalidArgsException error.
type GeneralName struct {
	_ struct{} `type:"structure"`

	// Contains information about the certificate subject. The Subject field in
	// the certificate identifies the entity that owns or controls the public key
	// in the certificate. The entity can be a user, computer, device, or service.
	// The Subject must contain an X.500 distinguished name (DN). A DN is a sequence
	// of relative distinguished names (RDNs). The RDNs are separated by commas
	// in the certificate.
	DirectoryName *ASN1Subject `type:"structure"`

	// Represents GeneralName as a DNS name.
	DnsName *string `type:"string"`

	// Represents GeneralName as an EdiPartyName object.
	EdiPartyName *EdiPartyName `type:"structure"`

	// Represents GeneralName as an IPv4 or IPv6 address.
	IpAddress *string `type:"string"`

	// Represents GeneralName using an OtherName object.
	OtherName *OtherName `type:"structure"`

	// Represents GeneralName as an object identifier (OID).
	RegisteredId *string `type:"string"`

	// Represents GeneralName as an RFC 822 (https://datatracker.ietf.org/doc/html/rfc822)
	// email address.
	Rfc822Name *string `type:"string"`

	// Represents GeneralName as a URI.
	UniformResourceIdentifier *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneralName) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneralName) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeneralName) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeneralName"}
	if s.DirectoryName != nil {
		if err := s.DirectoryName.Validate(); err != nil {
			invalidParams.AddNested("DirectoryName", err.(request.ErrInvalidParams))
		}
	}
	if s.EdiPartyName != nil {
		if err := s.EdiPartyName.Validate(); err != nil {
			invalidParams.AddNested("EdiPartyName", err.(request.ErrInvalidParams))
		}
	}
	if s.OtherName != nil {
		if err := s.OtherName.Validate(); err != nil {
			invalidParams.AddNested("OtherName", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *GeneralName) SetDirectoryName(v *ASN1Subject) *GeneralName {
	s.DirectoryName = v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *GeneralName) SetDnsName(v string) *GeneralName {
	s.DnsName = &v
	return s
}

// SetEdiPartyName sets the EdiPartyName field's value.
func (s *GeneralName) SetEdiPartyName(v *EdiPartyName) *GeneralName {
	s.EdiPartyName = v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *GeneralName) SetIpAddress(v string) *GeneralName {
	s.IpAddress = &v
	return s
}

// SetOtherName sets the OtherName field's value.
func (s *GeneralName) SetOtherName(v *OtherName) *GeneralName {
	s.OtherName = v
	return s
}

// SetRegisteredId sets the RegisteredId field's value.
func (s *GeneralName) SetRegisteredId(v string) *GeneralName {
	s.RegisteredId = &v
	return s
}

// SetRfc822Name sets the Rfc822Name field's value.
func (s *GeneralName) SetRfc822Name(v string) *GeneralName {
	s.Rfc822Name = &v
	return s
}

// SetUniformResourceIdentifier sets the UniformResourceIdentifier field's value.
func (s *GeneralName) SetUniformResourceIdentifier(v string) *GeneralName {
	s.UniformResourceIdentifier = &v
	return s
}

type GetCertificateAuthorityCertificateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of your private CA. This is of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateAuthorityCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateAuthorityCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCertificateAuthorityCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCertificateAuthorityCertificateInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *GetCertificateAuthorityCertificateInput) SetCertificateAuthorityArn(v string) *GetCertificateAuthorityCertificateInput {
	s.CertificateAuthorityArn = &v
	return s
}

type GetCertificateAuthorityCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Base64-encoded certificate authority (CA) certificate.
	Certificate *string `type:"string"`

	// Base64-encoded certificate chain that includes any intermediate certificates
	// and chains up to root certificate that you used to sign your private CA certificate.
	// The chain does not include your private CA certificate. If this is a root
	// CA, the value will be null.
	CertificateChain *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateAuthorityCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateAuthorityCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *GetCertificateAuthorityCertificateOutput) SetCertificate(v string) *GetCertificateAuthorityCertificateOutput {
	s.Certificate = &v
	return s
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *GetCertificateAuthorityCertificateOutput) SetCertificateChain(v string) *GetCertificateAuthorityCertificateOutput {
	s.CertificateChain = &v
	return s
}

type GetCertificateAuthorityCsrInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called the CreateCertificateAuthority
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
	// action. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateAuthorityCsrInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateAuthorityCsrInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCertificateAuthorityCsrInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCertificateAuthorityCsrInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *GetCertificateAuthorityCsrInput) SetCertificateAuthorityArn(v string) *GetCertificateAuthorityCsrInput {
	s.CertificateAuthorityArn = &v
	return s
}

type GetCertificateAuthorityCsrOutput struct {
	_ struct{} `type:"structure"`

	// The base64 PEM-encoded certificate signing request (CSR) for your private
	// CA certificate.
	Csr *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateAuthorityCsrOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateAuthorityCsrOutput) GoString() string {
	return s.String()
}

// SetCsr sets the Csr field's value.
func (s *GetCertificateAuthorityCsrOutput) SetCsr(v string) *GetCertificateAuthorityCsrOutput {
	s.Csr = &v
	return s
}

type GetCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the issued certificate. The ARN contains the certificate serial
	// number and must be in the following form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012/certificate/286535153982981100925020015808220737245
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"5" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 5))
	}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *GetCertificateInput) SetCertificateArn(v string) *GetCertificateInput {
	s.CertificateArn = &v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *GetCertificateInput) SetCertificateAuthorityArn(v string) *GetCertificateInput {
	s.CertificateAuthorityArn = &v
	return s
}

type GetCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The base64 PEM-encoded certificate specified by the CertificateArn parameter.
	Certificate *string `type:"string"`

	// The base64 PEM-encoded certificate chain that chains up to the root CA certificate
	// that you used to sign your private CA certificate.
	CertificateChain *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *GetCertificateOutput) SetCertificate(v string) *GetCertificateOutput {
	s.Certificate = &v
	return s
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *GetCertificateOutput) SetCertificateChain(v string) *GetCertificateOutput {
	s.CertificateChain = &v
	return s
}

type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the private CA that will have its policy
	// retrieved. You can find the CA's ARN by calling the ListCertificateAuthorities
	// action.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetPolicyInput) SetResourceArn(v string) *GetPolicyInput {
	s.ResourceArn = &v
	return s
}

type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy attached to the private CA as a JSON document.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetPolicyOutput) SetPolicy(v string) *GetPolicyOutput {
	s.Policy = &v
	return s
}

type ImportCertificateAuthorityCertificateInput struct {
	_ struct{} `type:"structure"`

	// The PEM-encoded certificate for a private CA. This may be a self-signed certificate
	// in the case of a root CA, or it may be signed by another CA that you control.
	// Certificate is automatically base64 encoded/decoded by the SDK.
	//
	// Certificate is a required field
	Certificate []byte `min:"1" type:"blob" required:"true"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// A PEM-encoded file that contains all of your certificates, other than the
	// certificate you're importing, chaining up to your root CA. Your ACM Private
	// CA-hosted or on-premises root certificate is the last in the chain, and each
	// certificate in the chain signs the one preceding.
	//
	// This parameter must be supplied when you import a subordinate CA. When you
	// import a root CA, there is no chain.
	// CertificateChain is automatically base64 encoded/decoded by the SDK.
	CertificateChain []byte `type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCertificateAuthorityCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCertificateAuthorityCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportCertificateAuthorityCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportCertificateAuthorityCertificateInput"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.Certificate != nil && len(s.Certificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Certificate", 1))
	}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *ImportCertificateAuthorityCertificateInput) SetCertificate(v []byte) *ImportCertificateAuthorityCertificateInput {
	s.Certificate = v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *ImportCertificateAuthorityCertificateInput) SetCertificateAuthorityArn(v string) *ImportCertificateAuthorityCertificateInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *ImportCertificateAuthorityCertificateInput) SetCertificateChain(v []byte) *ImportCertificateAuthorityCertificateInput {
	s.CertificateChain = v
	return s
}

type ImportCertificateAuthorityCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCertificateAuthorityCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportCertificateAuthorityCertificateOutput) GoString() string {
	return s.String()
}

// One or more of the specified arguments was not valid.
type InvalidArgsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgsException) GoString() string {
	return s.String()
}

func newErrorInvalidArgsException(v protocol.ResponseMetadata) error {
	return &InvalidArgsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArgsException) Code() string {
	return "InvalidArgsException"
}

// Message returns the exception's message.
func (s *InvalidArgsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArgsException) OrigErr() error {
	return nil
}

func (s *InvalidArgsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArgsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArgsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested Amazon Resource Name (ARN) does not refer to an existing resource.
type InvalidArnException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArnException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArnException) GoString() string {
	return s.String()
}

func newErrorInvalidArnException(v protocol.ResponseMetadata) error {
	return &InvalidArnException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArnException) Code() string {
	return "InvalidArnException"
}

// Message returns the exception's message.
func (s *InvalidArnException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArnException) OrigErr() error {
	return nil
}

func (s *InvalidArnException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArnException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArnException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The token specified in the NextToken argument is not valid. Use the token
// returned from your previous call to ListCertificateAuthorities (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html).
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource policy is invalid or is missing a required statement. For general
// information about IAM policy and statement structure, see Overview of JSON
// Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
type InvalidPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPolicyException) GoString() string {
	return s.String()
}

func newErrorInvalidPolicyException(v protocol.ResponseMetadata) error {
	return &InvalidPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPolicyException) Code() string {
	return "InvalidPolicyException"
}

// Message returns the exception's message.
func (s *InvalidPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPolicyException) OrigErr() error {
	return nil
}

func (s *InvalidPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request action cannot be performed or is prohibited.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The state of the private CA does not allow this action to occur.
type InvalidStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidStateException) GoString() string {
	return s.String()
}

func newErrorInvalidStateException(v protocol.ResponseMetadata) error {
	return &InvalidStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidStateException) Code() string {
	return "InvalidStateException"
}

// Message returns the exception's message.
func (s *InvalidStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidStateException) OrigErr() error {
	return nil
}

func (s *InvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The tag associated with the CA is not valid. The invalid argument is contained
// in the message field.
type InvalidTagException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTagException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTagException) GoString() string {
	return s.String()
}

func newErrorInvalidTagException(v protocol.ResponseMetadata) error {
	return &InvalidTagException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTagException) Code() string {
	return "InvalidTagException"
}

// Message returns the exception's message.
func (s *InvalidTagException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTagException) OrigErr() error {
	return nil
}

func (s *InvalidTagException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTagException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTagException) RequestID() string {
	return s.RespMetadata.RequestID
}

type IssueCertificateInput struct {
	_ struct{} `type:"structure"`

	// Specifies X.509 certificate information to be included in the issued certificate.
	// An APIPassthrough or APICSRPassthrough template variant must be selected,
	// or else this parameter is ignored. For more information about using these
	// templates, see Understanding Certificate Templates (https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html).
	//
	// If conflicting or duplicate certificate information is supplied during certificate
	// issuance, ACM Private CA applies order of operation rules (https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html#template-order-of-operations)
	// to determine what information is used.
	ApiPassthrough *ApiPassthrough `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The certificate signing request (CSR) for the certificate you want to issue.
	// As an example, you can use the following OpenSSL command to create the CSR
	// and a 2048 bit RSA private key.
	//
	// openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem
	// -out csr/test_cert_.csr
	//
	// If you have a configuration file, you can then use the following OpenSSL
	// command. The usr_cert block in the configuration file contains your X509
	// version 3 extensions.
	//
	// openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048
	// -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr
	//
	// Note: A CSR must provide either a subject name or a subject alternative name
	// or the request will be rejected.
	// Csr is automatically base64 encoded/decoded by the SDK.
	//
	// Csr is a required field
	Csr []byte `min:"1" type:"blob" required:"true"`

	// Alphanumeric string that can be used to distinguish between calls to the
	// IssueCertificate action. Idempotency tokens for IssueCertificate time out
	// after one minute. Therefore, if you call IssueCertificate multiple times
	// with the same idempotency token within one minute, ACM Private CA recognizes
	// that you are requesting only one certificate and will issue only one. If
	// you change the idempotency token for each call, PCA recognizes that you are
	// requesting multiple certificates.
	IdempotencyToken *string `min:"1" type:"string"`

	// The name of the algorithm that will be used to sign the certificate to be
	// issued.
	//
	// This parameter should not be confused with the SigningAlgorithm parameter
	// used to sign a CSR in the CreateCertificateAuthority action.
	//
	// The specified signing algorithm family (RSA or ECDSA) much match the algorithm
	// family of the CA's secret key.
	//
	// SigningAlgorithm is a required field
	SigningAlgorithm *string `type:"string" required:"true" enum:"SigningAlgorithm"`

	// Specifies a custom configuration template to use when issuing a certificate.
	// If this parameter is not provided, ACM Private CA defaults to the EndEntityCertificate/V1
	// template. For CA certificates, you should choose the shortest path length
	// that meets your needs. The path length is indicated by the PathLenN portion
	// of the ARN, where N is the CA depth (https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaTerms.html#terms-cadepth).
	//
	// Note: The CA depth configured on a subordinate CA certificate must not exceed
	// the limit set by its parents in the CA hierarchy.
	//
	// For a list of TemplateArn values supported by ACM Private CA, see Understanding
	// Certificate Templates (https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html).
	TemplateArn *string `min:"5" type:"string"`

	// Information describing the end of the validity period of the certificate.
	// This parameter sets the “Not After” date for the certificate.
	//
	// Certificate validity is the period of time during which a certificate is
	// valid. Validity can be expressed as an explicit date and time when the certificate
	// expires, or as a span of time after issuance, stated in days, months, or
	// years. For more information, see Validity (https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5)
	// in RFC 5280.
	//
	// This value is unaffected when ValidityNotBefore is also specified. For example,
	// if Validity is set to 20 days in the future, the certificate will expire
	// 20 days from issuance time regardless of the ValidityNotBefore value.
	//
	// The end of the validity period configured on a certificate must not exceed
	// the limit set on its parents in the CA hierarchy.
	//
	// Validity is a required field
	Validity *Validity `type:"structure" required:"true"`

	// Information describing the start of the validity period of the certificate.
	// This parameter sets the “Not Before" date for the certificate.
	//
	// By default, when issuing a certificate, ACM Private CA sets the "Not Before"
	// date to the issuance time minus 60 minutes. This compensates for clock inconsistencies
	// across computer systems. The ValidityNotBefore parameter can be used to customize
	// the “Not Before” value.
	//
	// Unlike the Validity parameter, the ValidityNotBefore parameter is optional.
	//
	// The ValidityNotBefore value is expressed as an explicit date and time, using
	// the Validity type value ABSOLUTE. For more information, see Validity (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_Validity.html)
	// in this API reference and Validity (https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5)
	// in RFC 5280.
	ValidityNotBefore *Validity `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IssueCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IssueCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IssueCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IssueCertificateInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.Csr == nil {
		invalidParams.Add(request.NewErrParamRequired("Csr"))
	}
	if s.Csr != nil && len(s.Csr) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Csr", 1))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if s.SigningAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("SigningAlgorithm"))
	}
	if s.TemplateArn != nil && len(*s.TemplateArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateArn", 5))
	}
	if s.Validity == nil {
		invalidParams.Add(request.NewErrParamRequired("Validity"))
	}
	if s.ApiPassthrough != nil {
		if err := s.ApiPassthrough.Validate(); err != nil {
			invalidParams.AddNested("ApiPassthrough", err.(request.ErrInvalidParams))
		}
	}
	if s.Validity != nil {
		if err := s.Validity.Validate(); err != nil {
			invalidParams.AddNested("Validity", err.(request.ErrInvalidParams))
		}
	}
	if s.ValidityNotBefore != nil {
		if err := s.ValidityNotBefore.Validate(); err != nil {
			invalidParams.AddNested("ValidityNotBefore", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiPassthrough sets the ApiPassthrough field's value.
func (s *IssueCertificateInput) SetApiPassthrough(v *ApiPassthrough) *IssueCertificateInput {
	s.ApiPassthrough = v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *IssueCertificateInput) SetCertificateAuthorityArn(v string) *IssueCertificateInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCsr sets the Csr field's value.
func (s *IssueCertificateInput) SetCsr(v []byte) *IssueCertificateInput {
	s.Csr = v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *IssueCertificateInput) SetIdempotencyToken(v string) *IssueCertificateInput {
	s.IdempotencyToken = &v
	return s
}

// SetSigningAlgorithm sets the SigningAlgorithm field's value.
func (s *IssueCertificateInput) SetSigningAlgorithm(v string) *IssueCertificateInput {
	s.SigningAlgorithm = &v
	return s
}

// SetTemplateArn sets the TemplateArn field's value.
func (s *IssueCertificateInput) SetTemplateArn(v string) *IssueCertificateInput {
	s.TemplateArn = &v
	return s
}

// SetValidity sets the Validity field's value.
func (s *IssueCertificateInput) SetValidity(v *Validity) *IssueCertificateInput {
	s.Validity = v
	return s
}

// SetValidityNotBefore sets the ValidityNotBefore field's value.
func (s *IssueCertificateInput) SetValidityNotBefore(v *Validity) *IssueCertificateInput {
	s.ValidityNotBefore = v
	return s
}

type IssueCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the issued certificate and the certificate
	// serial number. This is of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012/certificate/286535153982981100925020015808220737245
	CertificateArn *string `min:"5" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IssueCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IssueCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *IssueCertificateOutput) SetCertificateArn(v string) *IssueCertificateOutput {
	s.CertificateArn = &v
	return s
}

// Defines one or more purposes for which the key contained in the certificate
// can be used. Default value for each option is false.
type KeyUsage struct {
	_ struct{} `type:"structure"`

	// Key can be used to sign CRLs.
	CRLSign *bool `type:"boolean"`

	// Key can be used to decipher data.
	DataEncipherment *bool `type:"boolean"`

	// Key can be used only to decipher data.
	DecipherOnly *bool `type:"boolean"`

	// Key can be used for digital signing.
	DigitalSignature *bool `type:"boolean"`

	// Key can be used only to encipher data.
	EncipherOnly *bool `type:"boolean"`

	// Key can be used in a key-agreement protocol.
	KeyAgreement *bool `type:"boolean"`

	// Key can be used to sign certificates.
	KeyCertSign *bool `type:"boolean"`

	// Key can be used to encipher data.
	KeyEncipherment *bool `type:"boolean"`

	// Key can be used for non-repudiation.
	NonRepudiation *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyUsage) GoString() string {
	return s.String()
}

// SetCRLSign sets the CRLSign field's value.
func (s *KeyUsage) SetCRLSign(v bool) *KeyUsage {
	s.CRLSign = &v
	return s
}

// SetDataEncipherment sets the DataEncipherment field's value.
func (s *KeyUsage) SetDataEncipherment(v bool) *KeyUsage {
	s.DataEncipherment = &v
	return s
}

// SetDecipherOnly sets the DecipherOnly field's value.
func (s *KeyUsage) SetDecipherOnly(v bool) *KeyUsage {
	s.DecipherOnly = &v
	return s
}

// SetDigitalSignature sets the DigitalSignature field's value.
func (s *KeyUsage) SetDigitalSignature(v bool) *KeyUsage {
	s.DigitalSignature = &v
	return s
}

// SetEncipherOnly sets the EncipherOnly field's value.
func (s *KeyUsage) SetEncipherOnly(v bool) *KeyUsage {
	s.EncipherOnly = &v
	return s
}

// SetKeyAgreement sets the KeyAgreement field's value.
func (s *KeyUsage) SetKeyAgreement(v bool) *KeyUsage {
	s.KeyAgreement = &v
	return s
}

// SetKeyCertSign sets the KeyCertSign field's value.
func (s *KeyUsage) SetKeyCertSign(v bool) *KeyUsage {
	s.KeyCertSign = &v
	return s
}

// SetKeyEncipherment sets the KeyEncipherment field's value.
func (s *KeyUsage) SetKeyEncipherment(v bool) *KeyUsage {
	s.KeyEncipherment = &v
	return s
}

// SetNonRepudiation sets the NonRepudiation field's value.
func (s *KeyUsage) SetNonRepudiation(v bool) *KeyUsage {
	s.NonRepudiation = &v
	return s
}

// An ACM Private CA quota has been exceeded. See the exception message returned
// to determine the quota that was exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCertificateAuthoritiesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response on each page. If additional items exist
	// beyond the number you specify, the NextToken element is sent in the response.
	// Use this NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `min:"1" type:"string"`

	// Use this parameter to filter the returned set of certificate authorities
	// based on their owner. The default is SELF.
	ResourceOwner *string `type:"string" enum:"ResourceOwner"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCertificateAuthoritiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCertificateAuthoritiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCertificateAuthoritiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCertificateAuthoritiesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCertificateAuthoritiesInput) SetMaxResults(v int64) *ListCertificateAuthoritiesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCertificateAuthoritiesInput) SetNextToken(v string) *ListCertificateAuthoritiesInput {
	s.NextToken = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *ListCertificateAuthoritiesInput) SetResourceOwner(v string) *ListCertificateAuthoritiesInput {
	s.ResourceOwner = &v
	return s
}

type ListCertificateAuthoritiesOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about each certificate authority you have created.
	CertificateAuthorities []*CertificateAuthority `type:"list"`

	// When the list is truncated, this value is present and should be used for
	// the NextToken parameter in a subsequent pagination request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCertificateAuthoritiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCertificateAuthoritiesOutput) GoString() string {
	return s.String()
}

// SetCertificateAuthorities sets the CertificateAuthorities field's value.
func (s *ListCertificateAuthoritiesOutput) SetCertificateAuthorities(v []*CertificateAuthority) *ListCertificateAuthoritiesOutput {
	s.CertificateAuthorities = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCertificateAuthoritiesOutput) SetNextToken(v string) *ListCertificateAuthoritiesOutput {
	s.NextToken = &v
	return s
}

type ListPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the private CA to inspect. You can find
	// the ARN by calling the ListCertificateAuthorities (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
	// action. This must be of the form: arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	// You can get a private CA's ARN by running the ListCertificateAuthorities
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
	// action.
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// When paginating results, use this parameter to specify the maximum number
	// of items to return in the response. If additional items exist beyond the
	// number you specify, the NextToken element is sent in the response. Use this
	// NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `min:"1" type:"integer"`

	// When paginating results, use this parameter in a subsequent request after
	// you receive a response with truncated results. Set it to the value of NextToken
	// from the response you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionsInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *ListPermissionsInput) SetCertificateAuthorityArn(v string) *ListPermissionsInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionsInput) SetMaxResults(v int64) *ListPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsInput) SetNextToken(v string) *ListPermissionsInput {
	s.NextToken = &v
	return s
}

type ListPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// When the list is truncated, this value is present and should be used for
	// the NextToken parameter in a subsequent pagination request.
	NextToken *string `min:"1" type:"string"`

	// Summary information about each permission assigned by the specified private
	// CA, including the action enabled, the policy provided, and the time of creation.
	Permissions []*Permission `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionsOutput) SetNextToken(v string) *ListPermissionsOutput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *ListPermissionsOutput) SetPermissions(v []*Permission) *ListPermissionsOutput {
	s.Permissions = v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called the CreateCertificateAuthority
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
	// action. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response. If additional items exist beyond the
	// number you specify, the NextToken element is sent in the response. Use this
	// NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of NextToken
	// from the response you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *ListTagsInput) SetCertificateAuthorityArn(v string) *ListTagsInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsInput) SetMaxResults(v int64) *ListTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsInput) SetNextToken(v string) *ListTagsInput {
	s.NextToken = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// When the list is truncated, this value is present and should be used for
	// the NextToken parameter in a subsequent pagination request.
	NextToken *string `min:"1" type:"string"`

	// The tags associated with your private CA.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOutput) SetNextToken(v string) *ListTagsOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsOutput) SetTags(v []*Tag) *ListTagsOutput {
	s.Tags = v
	return s
}

// The current action was prevented because it would lock the caller out from
// performing subsequent actions. Verify that the specified parameters would
// not result in the caller being denied access to the resource.
type LockoutPreventedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LockoutPreventedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LockoutPreventedException) GoString() string {
	return s.String()
}

func newErrorLockoutPreventedException(v protocol.ResponseMetadata) error {
	return &LockoutPreventedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LockoutPreventedException) Code() string {
	return "LockoutPreventedException"
}

// Message returns the exception's message.
func (s *LockoutPreventedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LockoutPreventedException) OrigErr() error {
	return nil
}

func (s *LockoutPreventedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LockoutPreventedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LockoutPreventedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The certificate signing request is invalid.
type MalformedCSRException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedCSRException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedCSRException) GoString() string {
	return s.String()
}

func newErrorMalformedCSRException(v protocol.ResponseMetadata) error {
	return &MalformedCSRException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MalformedCSRException) Code() string {
	return "MalformedCSRException"
}

// Message returns the exception's message.
func (s *MalformedCSRException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MalformedCSRException) OrigErr() error {
	return nil
}

func (s *MalformedCSRException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MalformedCSRException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MalformedCSRException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more fields in the certificate are invalid.
type MalformedCertificateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedCertificateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MalformedCertificateException) GoString() string {
	return s.String()
}

func newErrorMalformedCertificateException(v protocol.ResponseMetadata) error {
	return &MalformedCertificateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MalformedCertificateException) Code() string {
	return "MalformedCertificateException"
}

// Message returns the exception's message.
func (s *MalformedCertificateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MalformedCertificateException) OrigErr() error {
	return nil
}

func (s *MalformedCertificateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MalformedCertificateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MalformedCertificateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information to enable and configure Online Certificate Status Protocol
// (OCSP) for validating certificate revocation status.
//
// When you revoke a certificate, OCSP responses may take up to 60 minutes to
// reflect the new status.
type OcspConfiguration struct {
	_ struct{} `type:"structure"`

	// Flag enabling use of the Online Certificate Status Protocol (OCSP) for validating
	// certificate revocation status.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// By default, ACM Private CA injects an Amazon Web Services domain into certificates
	// being validated by the Online Certificate Status Protocol (OCSP). A customer
	// can alternatively use this object to define a CNAME specifying a customized
	// OCSP domain.
	//
	// Note: The value of the CNAME must not include a protocol prefix such as "http://"
	// or "https://".
	//
	// For more information, see Customizing Online Certificate Status Protocol
	// (OCSP) (https://docs.aws.amazon.com/acm-pca/latest/userguide/ocsp-customize.html)
	// in the Certificate Manager Private Certificate Authority (PCA) User Guide.
	OcspCustomCname *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OcspConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OcspConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OcspConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OcspConfiguration"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *OcspConfiguration) SetEnabled(v bool) *OcspConfiguration {
	s.Enabled = &v
	return s
}

// SetOcspCustomCname sets the OcspCustomCname field's value.
func (s *OcspConfiguration) SetOcspCustomCname(v string) *OcspConfiguration {
	s.OcspCustomCname = &v
	return s
}

// Defines a custom ASN.1 X.400 GeneralName using an object identifier (OID)
// and value. The OID must satisfy the regular expression shown below. For more
// information, see NIST's definition of Object Identifier (OID) (https://csrc.nist.gov/glossary/term/Object_Identifier).
type OtherName struct {
	_ struct{} `type:"structure"`

	// Specifies an OID.
	//
	// TypeId is a required field
	TypeId *string `type:"string" required:"true"`

	// Specifies an OID value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OtherName) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OtherName) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OtherName) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OtherName"}
	if s.TypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("TypeId"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTypeId sets the TypeId field's value.
func (s *OtherName) SetTypeId(v string) *OtherName {
	s.TypeId = &v
	return s
}

// SetValue sets the Value field's value.
func (s *OtherName) SetValue(v string) *OtherName {
	s.Value = &v
	return s
}

// Permissions designate which private CA actions can be performed by an Amazon
// Web Services service or entity. In order for ACM to automatically renew private
// certificates, you must give the ACM service principal all available permissions
// (IssueCertificate, GetCertificate, and ListPermissions). Permissions can
// be assigned with the CreatePermission (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html)
// action, removed with the DeletePermission (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html)
// action, and listed with the ListPermissions (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html)
// action.
type Permission struct {
	_ struct{} `type:"structure"`

	// The private CA actions that can be performed by the designated Amazon Web
	// Services service.
	Actions []*string `min:"1" type:"list" enum:"ActionType"`

	// The Amazon Resource Number (ARN) of the private CA from which the permission
	// was issued.
	CertificateAuthorityArn *string `min:"5" type:"string"`

	// The time at which the permission was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The name of the policy that is associated with the permission.
	Policy *string `min:"1" type:"string"`

	// The Amazon Web Services service or entity that holds the permission. At this
	// time, the only valid principal is acm.amazonaws.com.
	Principal *string `type:"string"`

	// The ID of the account that assigned the permission.
	SourceAccount *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Permission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Permission) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *Permission) SetActions(v []*string) *Permission {
	s.Actions = v
	return s
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *Permission) SetCertificateAuthorityArn(v string) *Permission {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Permission) SetCreatedAt(v time.Time) *Permission {
	s.CreatedAt = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *Permission) SetPolicy(v string) *Permission {
	s.Policy = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *Permission) SetPrincipal(v string) *Permission {
	s.Principal = &v
	return s
}

// SetSourceAccount sets the SourceAccount field's value.
func (s *Permission) SetSourceAccount(v string) *Permission {
	s.SourceAccount = &v
	return s
}

// The designated permission has already been given to the user.
type PermissionAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorPermissionAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &PermissionAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PermissionAlreadyExistsException) Code() string {
	return "PermissionAlreadyExistsException"
}

// Message returns the exception's message.
func (s *PermissionAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PermissionAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *PermissionAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PermissionAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PermissionAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines the X.509 CertificatePolicies extension.
type PolicyInformation struct {
	_ struct{} `type:"structure"`

	// Specifies the object identifier (OID) of the certificate policy under which
	// the certificate was issued. For more information, see NIST's definition of
	// Object Identifier (OID) (https://csrc.nist.gov/glossary/term/Object_Identifier).
	//
	// CertPolicyId is a required field
	CertPolicyId *string `type:"string" required:"true"`

	// Modifies the given CertPolicyId with a qualifier. ACM Private CA supports
	// the certification practice statement (CPS) qualifier.
	PolicyQualifiers []*PolicyQualifierInfo `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyInformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolicyInformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PolicyInformation"}
	if s.CertPolicyId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertPolicyId"))
	}
	if s.PolicyQualifiers != nil && len(s.PolicyQualifiers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyQualifiers", 1))
	}
	if s.PolicyQualifiers != nil {
		for i, v := range s.PolicyQualifiers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PolicyQualifiers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertPolicyId sets the CertPolicyId field's value.
func (s *PolicyInformation) SetCertPolicyId(v string) *PolicyInformation {
	s.CertPolicyId = &v
	return s
}

// SetPolicyQualifiers sets the PolicyQualifiers field's value.
func (s *PolicyInformation) SetPolicyQualifiers(v []*PolicyQualifierInfo) *PolicyInformation {
	s.PolicyQualifiers = v
	return s
}

// Modifies the CertPolicyId of a PolicyInformation object with a qualifier.
// ACM Private CA supports the certification practice statement (CPS) qualifier.
type PolicyQualifierInfo struct {
	_ struct{} `type:"structure"`

	// Identifies the qualifier modifying a CertPolicyId.
	//
	// PolicyQualifierId is a required field
	PolicyQualifierId *string `type:"string" required:"true" enum:"PolicyQualifierId"`

	// Defines the qualifier type. ACM Private CA supports the use of a URI for
	// a CPS qualifier in this field.
	//
	// Qualifier is a required field
	Qualifier *Qualifier `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyQualifierInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyQualifierInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PolicyQualifierInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PolicyQualifierInfo"}
	if s.PolicyQualifierId == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyQualifierId"))
	}
	if s.Qualifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Qualifier"))
	}
	if s.Qualifier != nil {
		if err := s.Qualifier.Validate(); err != nil {
			invalidParams.AddNested("Qualifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyQualifierId sets the PolicyQualifierId field's value.
func (s *PolicyQualifierInfo) SetPolicyQualifierId(v string) *PolicyQualifierInfo {
	s.PolicyQualifierId = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *PolicyQualifierInfo) SetQualifier(v *Qualifier) *PolicyQualifierInfo {
	s.Qualifier = v
	return s
}

type PutPolicyInput struct {
	_ struct{} `type:"structure"`

	// The path and file name of a JSON-formatted IAM policy to attach to the specified
	// private CA resource. If this policy does not contain all required statements
	// or if it includes any statement that is not allowed, the PutPolicy action
	// returns an InvalidPolicyException. For information about IAM policy and statement
	// structure, see Overview of JSON Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Number (ARN) of the private CA to associate with the
	// policy. The ARN of the CA can be found by calling the ListCertificateAuthorities
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
	// action.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutPolicyInput) SetPolicy(v string) *PutPolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutPolicyInput) SetResourceArn(v string) *PutPolicyInput {
	s.ResourceArn = &v
	return s
}

type PutPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPolicyOutput) GoString() string {
	return s.String()
}

// Defines a PolicyInformation qualifier. ACM Private CA supports the certification
// practice statement (CPS) qualifier (https://datatracker.ietf.org/doc/html/rfc5280#section-4.2.1.4)
// defined in RFC 5280.
type Qualifier struct {
	_ struct{} `type:"structure"`

	// Contains a pointer to a certification practice statement (CPS) published
	// by the CA.
	//
	// CpsUri is a required field
	CpsUri *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Qualifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Qualifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Qualifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Qualifier"}
	if s.CpsUri == nil {
		invalidParams.Add(request.NewErrParamRequired("CpsUri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCpsUri sets the CpsUri field's value.
func (s *Qualifier) SetCpsUri(v string) *Qualifier {
	s.CpsUri = &v
	return s
}

// Your request has already been completed.
type RequestAlreadyProcessedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestAlreadyProcessedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestAlreadyProcessedException) GoString() string {
	return s.String()
}

func newErrorRequestAlreadyProcessedException(v protocol.ResponseMetadata) error {
	return &RequestAlreadyProcessedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestAlreadyProcessedException) Code() string {
	return "RequestAlreadyProcessedException"
}

// Message returns the exception's message.
func (s *RequestAlreadyProcessedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestAlreadyProcessedException) OrigErr() error {
	return nil
}

func (s *RequestAlreadyProcessedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestAlreadyProcessedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestAlreadyProcessedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request has failed for an unspecified reason.
type RequestFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestFailedException) GoString() string {
	return s.String()
}

func newErrorRequestFailedException(v protocol.ResponseMetadata) error {
	return &RequestFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestFailedException) Code() string {
	return "RequestFailedException"
}

// Message returns the exception's message.
func (s *RequestFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestFailedException) OrigErr() error {
	return nil
}

func (s *RequestFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your request is already in progress.
type RequestInProgressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestInProgressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestInProgressException) GoString() string {
	return s.String()
}

func newErrorRequestInProgressException(v protocol.ResponseMetadata) error {
	return &RequestInProgressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestInProgressException) Code() string {
	return "RequestInProgressException"
}

// Message returns the exception's message.
func (s *RequestInProgressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestInProgressException) OrigErr() error {
	return nil
}

func (s *RequestInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestInProgressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestInProgressException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A resource such as a private CA, S3 bucket, certificate, audit report, or
// policy cannot be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RestoreCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called the CreateCertificateAuthority
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
	// action. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *RestoreCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *RestoreCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

type RestoreCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// Certificate revocation information used by the CreateCertificateAuthority
// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
// and UpdateCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html)
// actions. Your private certificate authority (CA) can configure Online Certificate
// Status Protocol (OCSP) support and/or maintain a certificate revocation list
// (CRL). OCSP returns validation information about certificates as requested
// by clients, and a CRL contains an updated list of certificates revoked by
// your CA. For more information, see RevokeCertificate (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html)
// and Setting up a certificate revocation method (https://docs.aws.amazon.com/acm-pca/latest/userguide/revocation-setup.html)
// in the Certificate Manager Private Certificate Authority (PCA) User Guide.
type RevocationConfiguration struct {
	_ struct{} `type:"structure"`

	// Configuration of the certificate revocation list (CRL), if any, maintained
	// by your private CA. A CRL is typically updated approximately 30 minutes after
	// a certificate is revoked. If for any reason a CRL update fails, ACM Private
	// CA makes further attempts every 15 minutes.
	CrlConfiguration *CrlConfiguration `type:"structure"`

	// Configuration of Online Certificate Status Protocol (OCSP) support, if any,
	// maintained by your private CA. When you revoke a certificate, OCSP responses
	// may take up to 60 minutes to reflect the new status.
	OcspConfiguration *OcspConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevocationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevocationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevocationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevocationConfiguration"}
	if s.CrlConfiguration != nil {
		if err := s.CrlConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CrlConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OcspConfiguration != nil {
		if err := s.OcspConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OcspConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrlConfiguration sets the CrlConfiguration field's value.
func (s *RevocationConfiguration) SetCrlConfiguration(v *CrlConfiguration) *RevocationConfiguration {
	s.CrlConfiguration = v
	return s
}

// SetOcspConfiguration sets the OcspConfiguration field's value.
func (s *RevocationConfiguration) SetOcspConfiguration(v *OcspConfiguration) *RevocationConfiguration {
	s.OcspConfiguration = v
	return s
}

type RevokeCertificateInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the private CA that issued the certificate
	// to be revoked. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// Serial number of the certificate to be revoked. This must be in hexadecimal
	// format. You can retrieve the serial number by calling GetCertificate (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html)
	// with the Amazon Resource Name (ARN) of the certificate you want and the ARN
	// of your private CA. The GetCertificate action retrieves the certificate in
	// the PEM format. You can use the following OpenSSL command to list the certificate
	// in text format and copy the hexadecimal serial number.
	//
	// openssl x509 -in file_path -text -noout
	//
	// You can also copy the serial number from the console or use the DescribeCertificate
	// (https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html)
	// action in the Certificate Manager API Reference.
	//
	// CertificateSerial is a required field
	CertificateSerial *string `type:"string" required:"true"`

	// Specifies why you revoked the certificate.
	//
	// RevocationReason is a required field
	RevocationReason *string `type:"string" required:"true" enum:"RevocationReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeCertificateInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.CertificateSerial == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateSerial"))
	}
	if s.RevocationReason == nil {
		invalidParams.Add(request.NewErrParamRequired("RevocationReason"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *RevokeCertificateInput) SetCertificateAuthorityArn(v string) *RevokeCertificateInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetCertificateSerial sets the CertificateSerial field's value.
func (s *RevokeCertificateInput) SetCertificateSerial(v string) *RevokeCertificateInput {
	s.CertificateSerial = &v
	return s
}

// SetRevocationReason sets the RevocationReason field's value.
func (s *RevokeCertificateInput) SetRevocationReason(v string) *RevokeCertificateInput {
	s.RevocationReason = &v
	return s
}

type RevokeCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeCertificateOutput) GoString() string {
	return s.String()
}

// Tags are labels that you can use to identify and organize your private CAs.
// Each tag consists of a key and an optional value. You can associate up to
// 50 tags with a private CA. To add one or more tags to a private CA, call
// the TagCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html)
// action. To remove a tag, call the UntagCertificateAuthority (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html)
// action.
type Tag struct {
	_ struct{} `type:"structure"`

	// Key (name) of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// List of tags to be associated with the CA.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *TagCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *TagCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagCertificateAuthorityInput) SetTags(v []*Tag) *TagCertificateAuthorityInput {
	s.Tags = v
	return s
}

type TagCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// You can associate up to 50 tags with a private CA. Exception information
// is contained in the exception message field.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority
	// (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// List of tags to be removed from the CA.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *UntagCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *UntagCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UntagCertificateAuthorityInput) SetTags(v []*Tag) *UntagCertificateAuthorityInput {
	s.Tags = v
	return s
}

type UntagCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagCertificateAuthorityOutput) GoString() string {
	return s.String()
}

type UpdateCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the private CA that issued the certificate
	// to be revoked. This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// Contains information to enable Online Certificate Status Protocol (OCSP)
	// support, to enable a certificate revocation list (CRL), to enable both, or
	// to enable neither. If this parameter is not supplied, existing capibilites
	// remain unchanged. For more information, see the OcspConfiguration (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_OcspConfiguration.html)
	// and CrlConfiguration (https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html)
	// types.
	RevocationConfiguration *RevocationConfiguration `type:"structure"`

	// Status of your private CA.
	Status *string `type:"string" enum:"CertificateAuthorityStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCertificateAuthorityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCertificateAuthorityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCertificateAuthorityInput"}
	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}
	if s.RevocationConfiguration != nil {
		if err := s.RevocationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RevocationConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAuthorityArn sets the CertificateAuthorityArn field's value.
func (s *UpdateCertificateAuthorityInput) SetCertificateAuthorityArn(v string) *UpdateCertificateAuthorityInput {
	s.CertificateAuthorityArn = &v
	return s
}

// SetRevocationConfiguration sets the RevocationConfiguration field's value.
func (s *UpdateCertificateAuthorityInput) SetRevocationConfiguration(v *RevocationConfiguration) *UpdateCertificateAuthorityInput {
	s.RevocationConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateCertificateAuthorityInput) SetStatus(v string) *UpdateCertificateAuthorityInput {
	s.Status = &v
	return s
}

type UpdateCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCertificateAuthorityOutput) GoString() string {
	return s.String()
}

// Validity specifies the period of time during which a certificate is valid.
// Validity can be expressed as an explicit date and time when the validity
// of a certificate starts or expires, or as a span of time after issuance,
// stated in days, months, or years. For more information, see Validity (https://datatracker.ietf.org/doc/html/rfc5280#section-4.1.2.5)
// in RFC 5280.
//
// ACM Private CA API consumes the Validity data type differently in two distinct
// parameters of the IssueCertificate action. The required parameter IssueCertificate:Validity
// specifies the end of a certificate's validity period. The optional parameter
// IssueCertificate:ValidityNotBefore specifies a customized starting time for
// the validity period.
type Validity struct {
	_ struct{} `type:"structure"`

	// Determines how ACM Private CA interprets the Value parameter, an integer.
	// Supported validity types include those listed below. Type definitions with
	// values include a sample input value and the resulting output.
	//
	// END_DATE: The specific date and time when the certificate will expire, expressed
	// using UTCTime (YYMMDDHHMMSS) or GeneralizedTime (YYYYMMDDHHMMSS) format.
	// When UTCTime is used, if the year field (YY) is greater than or equal to
	// 50, the year is interpreted as 19YY. If the year field is less than 50, the
	// year is interpreted as 20YY.
	//
	//    * Sample input value: 491231235959 (UTCTime format)
	//
	//    * Output expiration date/time: 12/31/2049 23:59:59
	//
	// ABSOLUTE: The specific date and time when the validity of a certificate will
	// start or expire, expressed in seconds since the Unix Epoch.
	//
	//    * Sample input value: 2524608000
	//
	//    * Output expiration date/time: 01/01/2050 00:00:00
	//
	// DAYS, MONTHS, YEARS: The relative time from the moment of issuance until
	// the certificate will expire, expressed in days, months, or years.
	//
	// Example if DAYS, issued on 10/12/2020 at 12:34:54 UTC:
	//
	//    * Sample input value: 90
	//
	//    * Output expiration date: 01/10/2020 12:34:54 UTC
	//
	// The minimum validity duration for a certificate using relative time (DAYS)
	// is one day. The minimum validity for a certificate using absolute time (ABSOLUTE
	// or END_DATE) is one second.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ValidityPeriodType"`

	// A long integer interpreted according to the value of Type, below.
	//
	// Value is a required field
	Value *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Validity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Validity) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Validity) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Validity"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && *s.Value < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *Validity) SetType(v string) *Validity {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Validity) SetValue(v int64) *Validity {
	s.Value = &v
	return s
}

const (
	// AccessMethodTypeCaRepository is a AccessMethodType enum value
	AccessMethodTypeCaRepository = "CA_REPOSITORY"

	// AccessMethodTypeResourcePkiManifest is a AccessMethodType enum value
	AccessMethodTypeResourcePkiManifest = "RESOURCE_PKI_MANIFEST"

	// AccessMethodTypeResourcePkiNotify is a AccessMethodType enum value
	AccessMethodTypeResourcePkiNotify = "RESOURCE_PKI_NOTIFY"
)

// AccessMethodType_Values returns all elements of the AccessMethodType enum
func AccessMethodType_Values() []string {
	return []string{
		AccessMethodTypeCaRepository,
		AccessMethodTypeResourcePkiManifest,
		AccessMethodTypeResourcePkiNotify,
	}
}

const (
	// ActionTypeIssueCertificate is a ActionType enum value
	ActionTypeIssueCertificate = "IssueCertificate"

	// ActionTypeGetCertificate is a ActionType enum value
	ActionTypeGetCertificate = "GetCertificate"

	// ActionTypeListPermissions is a ActionType enum value
	ActionTypeListPermissions = "ListPermissions"
)

// ActionType_Values returns all elements of the ActionType enum
func ActionType_Values() []string {
	return []string{
		ActionTypeIssueCertificate,
		ActionTypeGetCertificate,
		ActionTypeListPermissions,
	}
}

const (
	// AuditReportResponseFormatJson is a AuditReportResponseFormat enum value
	AuditReportResponseFormatJson = "JSON"

	// AuditReportResponseFormatCsv is a AuditReportResponseFormat enum value
	AuditReportResponseFormatCsv = "CSV"
)

// AuditReportResponseFormat_Values returns all elements of the AuditReportResponseFormat enum
func AuditReportResponseFormat_Values() []string {
	return []string{
		AuditReportResponseFormatJson,
		AuditReportResponseFormatCsv,
	}
}

const (
	// AuditReportStatusCreating is a AuditReportStatus enum value
	AuditReportStatusCreating = "CREATING"

	// AuditReportStatusSuccess is a AuditReportStatus enum value
	AuditReportStatusSuccess = "SUCCESS"

	// AuditReportStatusFailed is a AuditReportStatus enum value
	AuditReportStatusFailed = "FAILED"
)

// AuditReportStatus_Values returns all elements of the AuditReportStatus enum
func AuditReportStatus_Values() []string {
	return []string{
		AuditReportStatusCreating,
		AuditReportStatusSuccess,
		AuditReportStatusFailed,
	}
}

const (
	// CertificateAuthorityStatusCreating is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusCreating = "CREATING"

	// CertificateAuthorityStatusPendingCertificate is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusPendingCertificate = "PENDING_CERTIFICATE"

	// CertificateAuthorityStatusActive is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusActive = "ACTIVE"

	// CertificateAuthorityStatusDeleted is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusDeleted = "DELETED"

	// CertificateAuthorityStatusDisabled is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusDisabled = "DISABLED"

	// CertificateAuthorityStatusExpired is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusExpired = "EXPIRED"

	// CertificateAuthorityStatusFailed is a CertificateAuthorityStatus enum value
	CertificateAuthorityStatusFailed = "FAILED"
)

// CertificateAuthorityStatus_Values returns all elements of the CertificateAuthorityStatus enum
func CertificateAuthorityStatus_Values() []string {
	return []string{
		CertificateAuthorityStatusCreating,
		CertificateAuthorityStatusPendingCertificate,
		CertificateAuthorityStatusActive,
		CertificateAuthorityStatusDeleted,
		CertificateAuthorityStatusDisabled,
		CertificateAuthorityStatusExpired,
		CertificateAuthorityStatusFailed,
	}
}

const (
	// CertificateAuthorityTypeRoot is a CertificateAuthorityType enum value
	CertificateAuthorityTypeRoot = "ROOT"

	// CertificateAuthorityTypeSubordinate is a CertificateAuthorityType enum value
	CertificateAuthorityTypeSubordinate = "SUBORDINATE"
)

// CertificateAuthorityType_Values returns all elements of the CertificateAuthorityType enum
func CertificateAuthorityType_Values() []string {
	return []string{
		CertificateAuthorityTypeRoot,
		CertificateAuthorityTypeSubordinate,
	}
}

const (
	// ExtendedKeyUsageTypeServerAuth is a ExtendedKeyUsageType enum value
	ExtendedKeyUsageTypeServerAuth = "SERVER_AUTH"

	// ExtendedKeyUsageTypeClientAuth is a ExtendedKeyUsageType enum value
	ExtendedKeyUsageTypeClientAuth = "CLIENT_AUTH"

	// ExtendedKeyUsageTypeCodeSigning is a ExtendedKeyUsageType enum value
	ExtendedKeyUsageTypeCodeSigning = "CODE_SIGNING"

	// ExtendedKeyUsageTypeEmailProtection is a ExtendedKeyUsageType enum value
	ExtendedKeyUsageTypeEmailProtection = "EMAIL_PROTECTION"

	// ExtendedKeyUsageTypeTimeStamping is a ExtendedKeyUsageType enum value
	ExtendedKeyUsageTypeTimeStamping = "TIME_STAMPING"

	// ExtendedKeyUsageTypeOcspSigning is a ExtendedKeyUsageType enum value
	ExtendedKeyUsageTypeOcspSigning = "OCSP_SIGNING"

	// ExtendedKeyUsageTypeSmartCardLogin is a ExtendedKeyUsageType enum value
	ExtendedKeyUsageTypeSmartCardLogin = "SMART_CARD_LOGIN"

	// ExtendedKeyUsageTypeDocumentSigning is a ExtendedKeyUsageType enum value
	ExtendedKeyUsageTypeDocumentSigning = "DOCUMENT_SIGNING"

	// ExtendedKeyUsageTypeCertificateTransparency is a ExtendedKeyUsageType enum value
	ExtendedKeyUsageTypeCertificateTransparency = "CERTIFICATE_TRANSPARENCY"
)

// ExtendedKeyUsageType_Values returns all elements of the ExtendedKeyUsageType enum
func ExtendedKeyUsageType_Values() []string {
	return []string{
		ExtendedKeyUsageTypeServerAuth,
		ExtendedKeyUsageTypeClientAuth,
		ExtendedKeyUsageTypeCodeSigning,
		ExtendedKeyUsageTypeEmailProtection,
		ExtendedKeyUsageTypeTimeStamping,
		ExtendedKeyUsageTypeOcspSigning,
		ExtendedKeyUsageTypeSmartCardLogin,
		ExtendedKeyUsageTypeDocumentSigning,
		ExtendedKeyUsageTypeCertificateTransparency,
	}
}

const (
	// FailureReasonRequestTimedOut is a FailureReason enum value
	FailureReasonRequestTimedOut = "REQUEST_TIMED_OUT"

	// FailureReasonUnsupportedAlgorithm is a FailureReason enum value
	FailureReasonUnsupportedAlgorithm = "UNSUPPORTED_ALGORITHM"

	// FailureReasonOther is a FailureReason enum value
	FailureReasonOther = "OTHER"
)

// FailureReason_Values returns all elements of the FailureReason enum
func FailureReason_Values() []string {
	return []string{
		FailureReasonRequestTimedOut,
		FailureReasonUnsupportedAlgorithm,
		FailureReasonOther,
	}
}

const (
	// KeyAlgorithmRsa2048 is a KeyAlgorithm enum value
	KeyAlgorithmRsa2048 = "RSA_2048"

	// KeyAlgorithmRsa4096 is a KeyAlgorithm enum value
	KeyAlgorithmRsa4096 = "RSA_4096"

	// KeyAlgorithmEcPrime256v1 is a KeyAlgorithm enum value
	KeyAlgorithmEcPrime256v1 = "EC_prime256v1"

	// KeyAlgorithmEcSecp384r1 is a KeyAlgorithm enum value
	KeyAlgorithmEcSecp384r1 = "EC_secp384r1"
)

// KeyAlgorithm_Values returns all elements of the KeyAlgorithm enum
func KeyAlgorithm_Values() []string {
	return []string{
		KeyAlgorithmRsa2048,
		KeyAlgorithmRsa4096,
		KeyAlgorithmEcPrime256v1,
		KeyAlgorithmEcSecp384r1,
	}
}

const (
	// KeyStorageSecurityStandardFips1402Level2OrHigher is a KeyStorageSecurityStandard enum value
	KeyStorageSecurityStandardFips1402Level2OrHigher = "FIPS_140_2_LEVEL_2_OR_HIGHER"

	// KeyStorageSecurityStandardFips1402Level3OrHigher is a KeyStorageSecurityStandard enum value
	KeyStorageSecurityStandardFips1402Level3OrHigher = "FIPS_140_2_LEVEL_3_OR_HIGHER"
)

// KeyStorageSecurityStandard_Values returns all elements of the KeyStorageSecurityStandard enum
func KeyStorageSecurityStandard_Values() []string {
	return []string{
		KeyStorageSecurityStandardFips1402Level2OrHigher,
		KeyStorageSecurityStandardFips1402Level3OrHigher,
	}
}

const (
	// PolicyQualifierIdCps is a PolicyQualifierId enum value
	PolicyQualifierIdCps = "CPS"
)

// PolicyQualifierId_Values returns all elements of the PolicyQualifierId enum
func PolicyQualifierId_Values() []string {
	return []string{
		PolicyQualifierIdCps,
	}
}

const (
	// ResourceOwnerSelf is a ResourceOwner enum value
	ResourceOwnerSelf = "SELF"

	// ResourceOwnerOtherAccounts is a ResourceOwner enum value
	ResourceOwnerOtherAccounts = "OTHER_ACCOUNTS"
)

// ResourceOwner_Values returns all elements of the ResourceOwner enum
func ResourceOwner_Values() []string {
	return []string{
		ResourceOwnerSelf,
		ResourceOwnerOtherAccounts,
	}
}

const (
	// RevocationReasonUnspecified is a RevocationReason enum value
	RevocationReasonUnspecified = "UNSPECIFIED"

	// RevocationReasonKeyCompromise is a RevocationReason enum value
	RevocationReasonKeyCompromise = "KEY_COMPROMISE"

	// RevocationReasonCertificateAuthorityCompromise is a RevocationReason enum value
	RevocationReasonCertificateAuthorityCompromise = "CERTIFICATE_AUTHORITY_COMPROMISE"

	// RevocationReasonAffiliationChanged is a RevocationReason enum value
	RevocationReasonAffiliationChanged = "AFFILIATION_CHANGED"

	// RevocationReasonSuperseded is a RevocationReason enum value
	RevocationReasonSuperseded = "SUPERSEDED"

	// RevocationReasonCessationOfOperation is a RevocationReason enum value
	RevocationReasonCessationOfOperation = "CESSATION_OF_OPERATION"

	// RevocationReasonPrivilegeWithdrawn is a RevocationReason enum value
	RevocationReasonPrivilegeWithdrawn = "PRIVILEGE_WITHDRAWN"

	// RevocationReasonAACompromise is a RevocationReason enum value
	RevocationReasonAACompromise = "A_A_COMPROMISE"
)

// RevocationReason_Values returns all elements of the RevocationReason enum
func RevocationReason_Values() []string {
	return []string{
		RevocationReasonUnspecified,
		RevocationReasonKeyCompromise,
		RevocationReasonCertificateAuthorityCompromise,
		RevocationReasonAffiliationChanged,
		RevocationReasonSuperseded,
		RevocationReasonCessationOfOperation,
		RevocationReasonPrivilegeWithdrawn,
		RevocationReasonAACompromise,
	}
}

const (
	// S3ObjectAclPublicRead is a S3ObjectAcl enum value
	S3ObjectAclPublicRead = "PUBLIC_READ"

	// S3ObjectAclBucketOwnerFullControl is a S3ObjectAcl enum value
	S3ObjectAclBucketOwnerFullControl = "BUCKET_OWNER_FULL_CONTROL"
)

// S3ObjectAcl_Values returns all elements of the S3ObjectAcl enum
func S3ObjectAcl_Values() []string {
	return []string{
		S3ObjectAclPublicRead,
		S3ObjectAclBucketOwnerFullControl,
	}
}

const (
	// SigningAlgorithmSha256withecdsa is a SigningAlgorithm enum value
	SigningAlgorithmSha256withecdsa = "SHA256WITHECDSA"

	// SigningAlgorithmSha384withecdsa is a SigningAlgorithm enum value
	SigningAlgorithmSha384withecdsa = "SHA384WITHECDSA"

	// SigningAlgorithmSha512withecdsa is a SigningAlgorithm enum value
	SigningAlgorithmSha512withecdsa = "SHA512WITHECDSA"

	// SigningAlgorithmSha256withrsa is a SigningAlgorithm enum value
	SigningAlgorithmSha256withrsa = "SHA256WITHRSA"

	// SigningAlgorithmSha384withrsa is a SigningAlgorithm enum value
	SigningAlgorithmSha384withrsa = "SHA384WITHRSA"

	// SigningAlgorithmSha512withrsa is a SigningAlgorithm enum value
	SigningAlgorithmSha512withrsa = "SHA512WITHRSA"
)

// SigningAlgorithm_Values returns all elements of the SigningAlgorithm enum
func SigningAlgorithm_Values() []string {
	return []string{
		SigningAlgorithmSha256withecdsa,
		SigningAlgorithmSha384withecdsa,
		SigningAlgorithmSha512withecdsa,
		SigningAlgorithmSha256withrsa,
		SigningAlgorithmSha384withrsa,
		SigningAlgorithmSha512withrsa,
	}
}

const (
	// ValidityPeriodTypeEndDate is a ValidityPeriodType enum value
	ValidityPeriodTypeEndDate = "END_DATE"

	// ValidityPeriodTypeAbsolute is a ValidityPeriodType enum value
	ValidityPeriodTypeAbsolute = "ABSOLUTE"

	// ValidityPeriodTypeDays is a ValidityPeriodType enum value
	ValidityPeriodTypeDays = "DAYS"

	// ValidityPeriodTypeMonths is a ValidityPeriodType enum value
	ValidityPeriodTypeMonths = "MONTHS"

	// ValidityPeriodTypeYears is a ValidityPeriodType enum value
	ValidityPeriodTypeYears = "YEARS"
)

// ValidityPeriodType_Values returns all elements of the ValidityPeriodType enum
func ValidityPeriodType_Values() []string {
	return []string{
		ValidityPeriodTypeEndDate,
		ValidityPeriodTypeAbsolute,
		ValidityPeriodTypeDays,
		ValidityPeriodTypeMonths,
		ValidityPeriodTypeYears,
	}
}
