// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/kms"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To cancel deletion of a KMS key
//
// The following example cancels deletion of the specified KMS key.
func ExampleKMS_CancelKeyDeletion_shared00() {
	svc := kms.New(session.New())
	input := &kms.CancelKeyDeletionInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.CancelKeyDeletion(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To connect a custom key store to its CloudHSM cluster
//
// This example connects an AWS KMS custom key store to its AWS CloudHSM cluster. This
// operation does not return any data. To verify that the custom key store is connected,
// use the <code>DescribeCustomKeyStores</code> operation.
func ExampleKMS_ConnectCustomKeyStore_shared00() {
	svc := kms.New(session.New())
	input := &kms.ConnectCustomKeyStoreInput{
		CustomKeyStoreId: aws.String("cks-1234567890abcdef0"),
	}

	result, err := svc.ConnectCustomKeyStore(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeCloudHsmClusterNotActiveException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotActiveException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an alias
//
// The following example creates an alias for the specified KMS key.
func ExampleKMS_CreateAlias_shared00() {
	svc := kms.New(session.New())
	input := &kms.CreateAliasInput{
		AliasName:   aws.String("alias/ExampleAlias"),
		TargetKeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.CreateAlias(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeAlreadyExistsException:
				fmt.Println(kms.ErrCodeAlreadyExistsException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidAliasNameException:
				fmt.Println(kms.ErrCodeInvalidAliasNameException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an AWS CloudHSM custom key store
//
// This example creates a custom key store that is associated with an AWS CloudHSM cluster.
func ExampleKMS_CreateCustomKeyStore_shared00() {
	svc := kms.New(session.New())
	input := &kms.CreateCustomKeyStoreInput{
		CloudHsmClusterId:      aws.String("cluster-1a23b4cdefg"),
		CustomKeyStoreName:     aws.String("ExampleKeyStore"),
		KeyStorePassword:       aws.String("kmsPswd"),
		TrustAnchorCertificate: aws.String("<certificate-goes-here>"),
	}

	result, err := svc.CreateCustomKeyStore(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeCloudHsmClusterInUseException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInUseException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNameInUseException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNameInUseException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterNotFoundException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotFoundException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterNotActiveException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotActiveException, aerr.Error())
			case kms.ErrCodeIncorrectTrustAnchorException:
				fmt.Println(kms.ErrCodeIncorrectTrustAnchorException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a grant
//
// The following example creates a grant that allows the specified IAM role to encrypt
// data with the specified KMS key.
func ExampleKMS_CreateGrant_shared00() {
	svc := kms.New(session.New())
	input := &kms.CreateGrantInput{
		GranteePrincipal: aws.String("arn:aws:iam::111122223333:role/ExampleRole"),
		KeyId:            aws.String("arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab"),
		Operations: []*string{
			aws.String("Encrypt"),
			aws.String("Decrypt"),
		},
	}

	result, err := svc.CreateGrant(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a KMS key
//
// The following example creates a symmetric KMS key for encryption and decryption.
// No parameters are required for this operation.
func ExampleKMS_CreateKey_shared00() {
	svc := kms.New(session.New())
	input := &kms.CreateKeyInput{}

	result, err := svc.CreateKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(kms.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeTagException:
				fmt.Println(kms.ErrCodeTagException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an asymmetric RSA KMS key for encryption and decryption
//
// This example creates a KMS key that contains an asymmetric RSA key pair for encryption
// and decryption. The key spec and key usage can't be changed after the key is created.
func ExampleKMS_CreateKey_shared01() {
	svc := kms.New(session.New())
	input := &kms.CreateKeyInput{
		KeySpec:  aws.String("RSA_4096"),
		KeyUsage: aws.String("ENCRYPT_DECRYPT"),
	}

	result, err := svc.CreateKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(kms.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeTagException:
				fmt.Println(kms.ErrCodeTagException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an asymmetric elliptic curve KMS key for signing and verification
//
// This example creates a KMS key that contains an asymmetric elliptic curve (ECC) key
// pair for signing and verification. The key usage is required even though "SIGN_VERIFY"
// is the only valid value for ECC KMS keys. The key spec and key usage can't be changed
// after the key is created.
func ExampleKMS_CreateKey_shared02() {
	svc := kms.New(session.New())
	input := &kms.CreateKeyInput{
		KeySpec:  aws.String("ECC_NIST_P521"),
		KeyUsage: aws.String("SIGN_VERIFY"),
	}

	result, err := svc.CreateKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(kms.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeTagException:
				fmt.Println(kms.ErrCodeTagException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a multi-Region primary KMS key
//
// This example creates a multi-Region primary symmetric encryption key. Because the
// default values for all parameters create a symmetric encryption key, only the MultiRegion
// parameter is required for this KMS key.
func ExampleKMS_CreateKey_shared03() {
	svc := kms.New(session.New())
	input := &kms.CreateKeyInput{
		MultiRegion: aws.Bool(true),
	}

	result, err := svc.CreateKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(kms.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeTagException:
				fmt.Println(kms.ErrCodeTagException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a KMS key for imported key material
//
// This example creates a KMS key with no key material. When the operation is complete,
// you can import your own key material into the KMS key. To create this KMS key, set
// the Origin parameter to EXTERNAL.
func ExampleKMS_CreateKey_shared04() {
	svc := kms.New(session.New())
	input := &kms.CreateKeyInput{
		Origin: aws.String("EXTERNAL"),
	}

	result, err := svc.CreateKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(kms.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeTagException:
				fmt.Println(kms.ErrCodeTagException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a KMS key in a custom key store
//
// This example creates a KMS key in the specified custom key store. The operation creates
// the KMS key and its metadata in AWS KMS and the key material in the AWS CloudHSM
// cluster associated with the custom key store. This example requires the Origin and
// CustomKeyStoreId parameters.
func ExampleKMS_CreateKey_shared05() {
	svc := kms.New(session.New())
	input := &kms.CreateKeyInput{
		CustomKeyStoreId: aws.String("cks-1234567890abcdef0"),
		Origin:           aws.String("AWS_CLOUDHSM"),
	}

	result, err := svc.CreateKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(kms.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeTagException:
				fmt.Println(kms.ErrCodeTagException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HMAC KMS key
//
// This example creates a 384-bit symmetric HMAC KMS key. The GENERATE_VERIFY_MAC key
// usage value is required even though it's the only valid value for HMAC KMS keys.
// The key spec and key usage can't be changed after the key is created.
func ExampleKMS_CreateKey_shared06() {
	svc := kms.New(session.New())
	input := &kms.CreateKeyInput{
		KeySpec:  aws.String("HMAC_384"),
		KeyUsage: aws.String("GENERATE_VERIFY_MAC"),
	}

	result, err := svc.CreateKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(kms.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeTagException:
				fmt.Println(kms.ErrCodeTagException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To decrypt data
//
// The following example decrypts data that was encrypted with a KMS key.
func ExampleKMS_Decrypt_shared00() {
	svc := kms.New(session.New())
	input := &kms.DecryptInput{
		CiphertextBlob: []byte("<binary data>"),
		KeyId:          aws.String("arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.Decrypt(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeInvalidCiphertextException:
				fmt.Println(kms.ErrCodeInvalidCiphertextException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeIncorrectKeyException:
				fmt.Println(kms.ErrCodeIncorrectKeyException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete an alias
//
// The following example deletes the specified alias.
func ExampleKMS_DeleteAlias_shared00() {
	svc := kms.New(session.New())
	input := &kms.DeleteAliasInput{
		AliasName: aws.String("alias/ExampleAlias"),
	}

	result, err := svc.DeleteAlias(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a custom key store from AWS KMS
//
// This example deletes a custom key store from AWS KMS. This operation does not delete
// the AWS CloudHSM cluster that was associated with the CloudHSM cluster. This operation
// doesn't return any data. To verify that the operation was successful, use the DescribeCustomKeyStores
// operation.
func ExampleKMS_DeleteCustomKeyStore_shared00() {
	svc := kms.New(session.New())
	input := &kms.DeleteCustomKeyStoreInput{
		CustomKeyStoreId: aws.String("cks-1234567890abcdef0"),
	}

	result, err := svc.DeleteCustomKeyStore(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeCustomKeyStoreHasCMKsException:
				fmt.Println(kms.ErrCodeCustomKeyStoreHasCMKsException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete imported key material
//
// The following example deletes the imported key material from the specified KMS key.
func ExampleKMS_DeleteImportedKeyMaterial_shared00() {
	svc := kms.New(session.New())
	input := &kms.DeleteImportedKeyMaterialInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.DeleteImportedKeyMaterial(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get detailed information about custom key stores in the account and Region
//
// This example gets detailed information about all AWS KMS custom key stores in an
// AWS account and Region. To get all key stores, do not enter a custom key store name
// or ID.
func ExampleKMS_DescribeCustomKeyStores_shared00() {
	svc := kms.New(session.New())
	input := &kms.DescribeCustomKeyStoresInput{}

	result, err := svc.DescribeCustomKeyStores(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidMarkerException:
				fmt.Println(kms.ErrCodeInvalidMarkerException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get detailed information about a custom key store associated with a CloudHSM cluster.
//
// This example gets detailed information about a particular AWS KMS custom key store
// that is associate with an AWS CloudHSM cluster. To limit the output to a particular
// custom key store, provide the custom key store name or ID.
func ExampleKMS_DescribeCustomKeyStores_shared01() {
	svc := kms.New(session.New())
	input := &kms.DescribeCustomKeyStoresInput{
		CustomKeyStoreName: aws.String("ExampleKeyStore"),
	}

	result, err := svc.DescribeCustomKeyStores(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidMarkerException:
				fmt.Println(kms.ErrCodeInvalidMarkerException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get details about a KMS key
//
// The following example gets metadata for a symmetric encryption KMS key.
func ExampleKMS_DescribeKey_shared00() {
	svc := kms.New(session.New())
	input := &kms.DescribeKeyInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.DescribeKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get details about an RSA asymmetric KMS key
//
// The following example gets metadata for an asymmetric RSA KMS key used for signing
// and verification.
func ExampleKMS_DescribeKey_shared01() {
	svc := kms.New(session.New())
	input := &kms.DescribeKeyInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.DescribeKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get details about a multi-Region key
//
// The following example gets metadata for a multi-Region replica key. This multi-Region
// key is a symmetric encryption key. DescribeKey returns information about the primary
// key and all of its replicas.
func ExampleKMS_DescribeKey_shared02() {
	svc := kms.New(session.New())
	input := &kms.DescribeKeyInput{
		KeyId: aws.String("arn:aws:kms:ap-northeast-1:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab"),
	}

	result, err := svc.DescribeKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To get details about an HMAC KMS key
//
// The following example gets the metadata of an HMAC KMS key.
func ExampleKMS_DescribeKey_shared03() {
	svc := kms.New(session.New())
	input := &kms.DescribeKeyInput{
		KeyId: aws.String("arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.DescribeKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable a KMS key
//
// The following example disables the specified KMS key.
func ExampleKMS_DisableKey_shared00() {
	svc := kms.New(session.New())
	input := &kms.DisableKeyInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.DisableKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disable automatic rotation of key material
//
// The following example disables automatic annual rotation of the key material for
// the specified KMS key.
func ExampleKMS_DisableKeyRotation_shared00() {
	svc := kms.New(session.New())
	input := &kms.DisableKeyRotationInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.DisableKeyRotation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To disconnect a custom key store from its CloudHSM cluster
//
// This example disconnects an AWS KMS custom key store from its AWS CloudHSM cluster.
// This operation doesn't return any data. To verify that the custom key store is disconnected,
// use the <code>DescribeCustomKeyStores</code> operation.
func ExampleKMS_DisconnectCustomKeyStore_shared00() {
	svc := kms.New(session.New())
	input := &kms.DisconnectCustomKeyStoreInput{
		CustomKeyStoreId: aws.String("cks-1234567890abcdef0"),
	}

	result, err := svc.DisconnectCustomKeyStore(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable a KMS key
//
// The following example enables the specified KMS key.
func ExampleKMS_EnableKey_shared00() {
	svc := kms.New(session.New())
	input := &kms.EnableKeyInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.EnableKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable automatic rotation of key material
//
// The following example enables automatic annual rotation of the key material for the
// specified KMS key.
func ExampleKMS_EnableKeyRotation_shared00() {
	svc := kms.New(session.New())
	input := &kms.EnableKeyRotationInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.EnableKeyRotation(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To encrypt data
//
// The following example encrypts data with the specified KMS key.
func ExampleKMS_Encrypt_shared00() {
	svc := kms.New(session.New())
	input := &kms.EncryptInput{
		KeyId:     aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
		Plaintext: []byte("<binary data>"),
	}

	result, err := svc.Encrypt(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate a data key
//
// The following example generates a 256-bit symmetric data encryption key (data key)
// in two formats. One is the unencrypted (plainext) data key, and the other is the
// data key encrypted with the specified KMS key.
func ExampleKMS_GenerateDataKey_shared00() {
	svc := kms.New(session.New())
	input := &kms.GenerateDataKeyInput{
		KeyId:   aws.String("alias/ExampleAlias"),
		KeySpec: aws.String("AES_256"),
	}

	result, err := svc.GenerateDataKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate an RSA key pair for encryption and decryption
//
// This example generates an RSA data key pair for encryption and decryption. The operation
// returns a plaintext public key and private key, and a copy of the private key that
// is encrypted under a symmetric encryption KMS key that you specify.
func ExampleKMS_GenerateDataKeyPair_shared00() {
	svc := kms.New(session.New())
	input := &kms.GenerateDataKeyPairInput{
		KeyId:       aws.String("arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"),
		KeyPairSpec: aws.String("RSA_3072"),
	}

	result, err := svc.GenerateDataKeyPair(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate an asymmetric data key pair without a plaintext key
//
// This example returns an asymmetric elliptic curve (ECC) data key pair. The private
// key is encrypted under the symmetric encryption KMS key that you specify. This operation
// doesn't return a plaintext (unencrypted) private key.
func ExampleKMS_GenerateDataKeyPairWithoutPlaintext_shared00() {
	svc := kms.New(session.New())
	input := &kms.GenerateDataKeyPairWithoutPlaintextInput{
		KeyId:       aws.String("arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"),
		KeyPairSpec: aws.String("ECC_NIST_P521"),
	}

	result, err := svc.GenerateDataKeyPairWithoutPlaintext(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate an encrypted data key
//
// The following example generates an encrypted copy of a 256-bit symmetric data encryption
// key (data key). The data key is encrypted with the specified KMS key.
func ExampleKMS_GenerateDataKeyWithoutPlaintext_shared00() {
	svc := kms.New(session.New())
	input := &kms.GenerateDataKeyWithoutPlaintextInput{
		KeyId:   aws.String("alias/ExampleAlias"),
		KeySpec: aws.String("AES_256"),
	}

	result, err := svc.GenerateDataKeyWithoutPlaintext(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate an HMAC for a message
//
// This example generates an HMAC for a message, an HMAC KMS key, and a MAC algorithm.
// The algorithm must be supported by the specified HMAC KMS key.
func ExampleKMS_GenerateMac_shared00() {
	svc := kms.New(session.New())
	input := &kms.GenerateMacInput{
		KeyId:        aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
		MacAlgorithm: aws.String("HMAC_SHA_384"),
		Message:      []byte("Hello World"),
	}

	result, err := svc.GenerateMac(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To generate random data
//
// The following example generates 32 bytes of random data.
func ExampleKMS_GenerateRandom_shared00() {
	svc := kms.New(session.New())
	input := &kms.GenerateRandomInput{
		NumberOfBytes: aws.Int64(32),
	}

	result, err := svc.GenerateRandom(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve a key policy
//
// The following example retrieves the key policy for the specified KMS key.
func ExampleKMS_GetKeyPolicy_shared00() {
	svc := kms.New(session.New())
	input := &kms.GetKeyPolicyInput{
		KeyId:      aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
		PolicyName: aws.String("default"),
	}

	result, err := svc.GetKeyPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve the rotation status for a KMS key
//
// The following example retrieves the status of automatic annual rotation of the key
// material for the specified KMS key.
func ExampleKMS_GetKeyRotationStatus_shared00() {
	svc := kms.New(session.New())
	input := &kms.GetKeyRotationStatusInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.GetKeyRotationStatus(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retrieve the public key and import token for a KMS key
//
// The following example retrieves the public key and import token for the specified
// KMS key.
func ExampleKMS_GetParametersForImport_shared00() {
	svc := kms.New(session.New())
	input := &kms.GetParametersForImportInput{
		KeyId:             aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
		WrappingAlgorithm: aws.String("RSAES_OAEP_SHA_1"),
		WrappingKeySpec:   aws.String("RSA_2048"),
	}

	result, err := svc.GetParametersForImport(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To download the public key of an asymmetric KMS key
//
// This example gets the public key of an asymmetric RSA KMS key used for encryption
// and decryption. The operation returns the key spec, key usage, and encryption or
// signing algorithms to help you use the public key correctly outside of AWS KMS.
func ExampleKMS_GetPublicKey_shared00() {
	svc := kms.New(session.New())
	input := &kms.GetPublicKeyInput{
		KeyId: aws.String("arn:aws:kms:us-west-2:111122223333:key/0987dcba-09fe-87dc-65ba-ab0987654321"),
	}

	result, err := svc.GetPublicKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To import key material into a KMS key
//
// The following example imports key material into the specified KMS key.
func ExampleKMS_ImportKeyMaterial_shared00() {
	svc := kms.New(session.New())
	input := &kms.ImportKeyMaterialInput{
		EncryptedKeyMaterial: []byte("<binary data>"),
		ExpirationModel:      aws.String("KEY_MATERIAL_DOES_NOT_EXPIRE"),
		ImportToken:          []byte("<binary data>"),
		KeyId:                aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.ImportKeyMaterial(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			case kms.ErrCodeInvalidCiphertextException:
				fmt.Println(kms.ErrCodeInvalidCiphertextException, aerr.Error())
			case kms.ErrCodeIncorrectKeyMaterialException:
				fmt.Println(kms.ErrCodeIncorrectKeyMaterialException, aerr.Error())
			case kms.ErrCodeExpiredImportTokenException:
				fmt.Println(kms.ErrCodeExpiredImportTokenException, aerr.Error())
			case kms.ErrCodeInvalidImportTokenException:
				fmt.Println(kms.ErrCodeInvalidImportTokenException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list aliases
//
// The following example lists aliases.
func ExampleKMS_ListAliases_shared00() {
	svc := kms.New(session.New())
	input := &kms.ListAliasesInput{}

	result, err := svc.ListAliases(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidMarkerException:
				fmt.Println(kms.ErrCodeInvalidMarkerException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list grants for a KMS key
//
// The following example lists grants for the specified KMS key.
func ExampleKMS_ListGrants_shared00() {
	svc := kms.New(session.New())
	input := &kms.ListGrantsInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.ListGrants(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidMarkerException:
				fmt.Println(kms.ErrCodeInvalidMarkerException, aerr.Error())
			case kms.ErrCodeInvalidGrantIdException:
				fmt.Println(kms.ErrCodeInvalidGrantIdException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list key policies for a KMS key
//
// The following example lists key policies for the specified KMS key.
func ExampleKMS_ListKeyPolicies_shared00() {
	svc := kms.New(session.New())
	input := &kms.ListKeyPoliciesInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.ListKeyPolicies(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list KMS keys
//
// The following example lists KMS keys.
func ExampleKMS_ListKeys_shared00() {
	svc := kms.New(session.New())
	input := &kms.ListKeysInput{}

	result, err := svc.ListKeys(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidMarkerException:
				fmt.Println(kms.ErrCodeInvalidMarkerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list tags for a KMS key
//
// The following example lists tags for a KMS key.
func ExampleKMS_ListResourceTags_shared00() {
	svc := kms.New(session.New())
	input := &kms.ListResourceTagsInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.ListResourceTags(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeInvalidMarkerException:
				fmt.Println(kms.ErrCodeInvalidMarkerException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To list grants that the specified principal can retire
//
// The following example lists the grants that the specified principal (identity) can
// retire.
func ExampleKMS_ListRetirableGrants_shared00() {
	svc := kms.New(session.New())
	input := &kms.ListRetirableGrantsInput{
		RetiringPrincipal: aws.String("arn:aws:iam::111122223333:role/ExampleRole"),
	}

	result, err := svc.ListRetirableGrants(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidMarkerException:
				fmt.Println(kms.ErrCodeInvalidMarkerException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To attach a key policy to a KMS key
//
// The following example attaches a key policy to the specified KMS key.
func ExampleKMS_PutKeyPolicy_shared00() {
	svc := kms.New(session.New())
	input := &kms.PutKeyPolicyInput{
		KeyId:      aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
		Policy:     aws.String("{\n    \"Version\": \"2012-10-17\",\n    \"Id\": \"custom-policy-2016-12-07\",\n    \"Statement\": [\n        {\n            \"Sid\": \"Enable IAM User Permissions\",\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": \"arn:aws:iam::111122223333:root\"\n            },\n            \"Action\": \"kms:*\",\n            \"Resource\": \"*\"\n        },\n        {\n            \"Sid\": \"Allow access for Key Administrators\",\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": [\n                    \"arn:aws:iam::111122223333:user/ExampleAdminUser\",\n                    \"arn:aws:iam::111122223333:role/ExampleAdminRole\"\n                ]\n            },\n            \"Action\": [\n                \"kms:Create*\",\n                \"kms:Describe*\",\n                \"kms:Enable*\",\n                \"kms:List*\",\n                \"kms:Put*\",\n                \"kms:Update*\",\n                \"kms:Revoke*\",\n                \"kms:Disable*\",\n                \"kms:Get*\",\n                \"kms:Delete*\",\n                \"kms:ScheduleKeyDeletion\",\n                \"kms:CancelKeyDeletion\"\n            ],\n            \"Resource\": \"*\"\n        },\n        {\n            \"Sid\": \"Allow use of the key\",\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": \"arn:aws:iam::111122223333:role/ExamplePowerUserRole\"\n            },\n            \"Action\": [\n                \"kms:Encrypt\",\n                \"kms:Decrypt\",\n                \"kms:ReEncrypt*\",\n                \"kms:GenerateDataKey*\",\n                \"kms:DescribeKey\"\n            ],\n            \"Resource\": \"*\"\n        },\n        {\n            \"Sid\": \"Allow attachment of persistent resources\",\n            \"Effect\": \"Allow\",\n            \"Principal\": {\n                \"AWS\": \"arn:aws:iam::111122223333:role/ExamplePowerUserRole\"\n            },\n            \"Action\": [\n                \"kms:CreateGrant\",\n                \"kms:ListGrants\",\n                \"kms:RevokeGrant\"\n            ],\n            \"Resource\": \"*\",\n            \"Condition\": {\n                \"Bool\": {\n                    \"kms:GrantIsForAWSResource\": \"true\"\n                }\n            }\n        }\n    ]\n}\n"),
		PolicyName: aws.String("default"),
	}

	result, err := svc.PutKeyPolicy(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(kms.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To reencrypt data
//
// The following example reencrypts data with the specified KMS key.
func ExampleKMS_ReEncrypt_shared00() {
	svc := kms.New(session.New())
	input := &kms.ReEncryptInput{
		CiphertextBlob:   []byte("<binary data>"),
		DestinationKeyId: aws.String("0987dcba-09fe-87dc-65ba-ab0987654321"),
	}

	result, err := svc.ReEncrypt(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeInvalidCiphertextException:
				fmt.Println(kms.ErrCodeInvalidCiphertextException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeIncorrectKeyException:
				fmt.Println(kms.ErrCodeIncorrectKeyException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To replicate a multi-Region key in a different AWS Region
//
// This example creates a multi-Region replica key in us-west-2 of a multi-Region primary
// key in us-east-1.
func ExampleKMS_ReplicateKey_shared00() {
	svc := kms.New(session.New())
	input := &kms.ReplicateKeyInput{
		KeyId:         aws.String("arn:aws:kms:us-east-1:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab"),
		ReplicaRegion: aws.String("us-west-2"),
	}

	result, err := svc.ReplicateKey(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeAlreadyExistsException:
				fmt.Println(kms.ErrCodeAlreadyExistsException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeMalformedPolicyDocumentException:
				fmt.Println(kms.ErrCodeMalformedPolicyDocumentException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeTagException:
				fmt.Println(kms.ErrCodeTagException, aerr.Error())
			case kms.ErrCodeUnsupportedOperationException:
				fmt.Println(kms.ErrCodeUnsupportedOperationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To retire a grant
//
// The following example retires a grant.
func ExampleKMS_RetireGrant_shared00() {
	svc := kms.New(session.New())
	input := &kms.RetireGrantInput{
		GrantId: aws.String("0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60"),
		KeyId:   aws.String("arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.RetireGrant(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInvalidGrantIdException:
				fmt.Println(kms.ErrCodeInvalidGrantIdException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To revoke a grant
//
// The following example revokes a grant.
func ExampleKMS_RevokeGrant_shared00() {
	svc := kms.New(session.New())
	input := &kms.RevokeGrantInput{
		GrantId: aws.String("0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60"),
		KeyId:   aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.RevokeGrant(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeInvalidGrantIdException:
				fmt.Println(kms.ErrCodeInvalidGrantIdException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To schedule a KMS key for deletion
//
// The following example schedules the specified KMS key for deletion.
func ExampleKMS_ScheduleKeyDeletion_shared00() {
	svc := kms.New(session.New())
	input := &kms.ScheduleKeyDeletionInput{
		KeyId:               aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
		PendingWindowInDays: aws.Int64(7),
	}

	result, err := svc.ScheduleKeyDeletion(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To digitally sign a message with an asymmetric KMS key.
//
// This operation uses the private key in an asymmetric elliptic curve (ECC) KMS key
// to generate a digital signature for a given message.
func ExampleKMS_Sign_shared00() {
	svc := kms.New(session.New())
	input := &kms.SignInput{
		KeyId:            aws.String("alias/ECC_signing_key"),
		Message:          []byte("<message to be signed>"),
		MessageType:      aws.String("RAW"),
		SigningAlgorithm: aws.String("ECDSA_SHA_384"),
	}

	result, err := svc.Sign(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To tag a KMS key
//
// The following example tags a KMS key.
func ExampleKMS_TagResource_shared00() {
	svc := kms.New(session.New())
	input := &kms.TagResourceInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
		Tags: []*kms.Tag{
			{
				TagKey:   aws.String("Purpose"),
				TagValue: aws.String("Test"),
			},
		},
	}

	result, err := svc.TagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeTagException:
				fmt.Println(kms.ErrCodeTagException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove tags from a KMS key
//
// The following example removes tags from a KMS key.
func ExampleKMS_UntagResource_shared00() {
	svc := kms.New(session.New())
	input := &kms.UntagResourceInput{
		KeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
		TagKeys: []*string{
			aws.String("Purpose"),
			aws.String("CostCenter"),
		},
	}

	result, err := svc.UntagResource(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			case kms.ErrCodeTagException:
				fmt.Println(kms.ErrCodeTagException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update an alias
//
// The following example updates the specified alias to refer to the specified KMS key.
func ExampleKMS_UpdateAlias_shared00() {
	svc := kms.New(session.New())
	input := &kms.UpdateAliasInput{
		AliasName:   aws.String("alias/ExampleAlias"),
		TargetKeyId: aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.UpdateAlias(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeLimitExceededException:
				fmt.Println(kms.ErrCodeLimitExceededException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To edit the password of a custom key store
//
// This example tells KMS the password for the kmsuser crypto user in the AWS CloudHSM
// cluster that is associated with the AWS KMS custom key store. (It does not change
// the password in the CloudHSM cluster.) This operation does not return any data.
func ExampleKMS_UpdateCustomKeyStore_shared00() {
	svc := kms.New(session.New())
	input := &kms.UpdateCustomKeyStoreInput{
		CustomKeyStoreId: aws.String("cks-1234567890abcdef0"),
		KeyStorePassword: aws.String("ExamplePassword"),
	}

	result, err := svc.UpdateCustomKeyStore(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNameInUseException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNameInUseException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterNotFoundException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotFoundException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterNotRelatedException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotRelatedException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterNotActiveException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotActiveException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To edit the friendly name of a custom key store
//
// This example changes the friendly name of the AWS KMS custom key store to the name
// that you specify. This operation does not return any data. To verify that the operation
// worked, use the DescribeCustomKeyStores operation.
func ExampleKMS_UpdateCustomKeyStore_shared01() {
	svc := kms.New(session.New())
	input := &kms.UpdateCustomKeyStoreInput{
		CustomKeyStoreId:      aws.String("cks-1234567890abcdef0"),
		NewCustomKeyStoreName: aws.String("DevelopmentKeys"),
	}

	result, err := svc.UpdateCustomKeyStore(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNameInUseException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNameInUseException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterNotFoundException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotFoundException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterNotRelatedException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotRelatedException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterNotActiveException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotActiveException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate the custom key store with a different, but related, AWS CloudHSM cluster.
//
// This example changes the cluster that is associated with a custom key store to a
// related cluster, such as a different backup of the same cluster. This operation does
// not return any data. To verify that the operation worked, use the DescribeCustomKeyStores
// operation.
func ExampleKMS_UpdateCustomKeyStore_shared02() {
	svc := kms.New(session.New())
	input := &kms.UpdateCustomKeyStoreInput{
		CloudHsmClusterId: aws.String("cluster-1a23b4cdefg"),
		CustomKeyStoreId:  aws.String("cks-1234567890abcdef0"),
	}

	result, err := svc.UpdateCustomKeyStore(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeCustomKeyStoreNotFoundException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNotFoundException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreNameInUseException:
				fmt.Println(kms.ErrCodeCustomKeyStoreNameInUseException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterNotFoundException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotFoundException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterNotRelatedException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotRelatedException, aerr.Error())
			case kms.ErrCodeCustomKeyStoreInvalidStateException:
				fmt.Println(kms.ErrCodeCustomKeyStoreInvalidStateException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterNotActiveException:
				fmt.Println(kms.ErrCodeCloudHsmClusterNotActiveException, aerr.Error())
			case kms.ErrCodeCloudHsmClusterInvalidConfigurationException:
				fmt.Println(kms.ErrCodeCloudHsmClusterInvalidConfigurationException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To update the description of a KMS key
//
// The following example updates the description of the specified KMS key.
func ExampleKMS_UpdateKeyDescription_shared00() {
	svc := kms.New(session.New())
	input := &kms.UpdateKeyDescriptionInput{
		Description: aws.String("Example description that indicates the intended use of this KMS key."),
		KeyId:       aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
	}

	result, err := svc.UpdateKeyDescription(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeInvalidArnException:
				fmt.Println(kms.ErrCodeInvalidArnException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To use an asymmetric KMS key to verify a digital signature
//
// This operation uses the public key in an elliptic curve (ECC) asymmetric key to verify
// a digital signature within AWS KMS.
func ExampleKMS_Verify_shared00() {
	svc := kms.New(session.New())
	input := &kms.VerifyInput{
		KeyId:            aws.String("alias/ECC_signing_key"),
		Message:          []byte("<message to be verified>"),
		MessageType:      aws.String("RAW"),
		Signature:        []byte("<binary data>"),
		SigningAlgorithm: aws.String("ECDSA_SHA_384"),
	}

	result, err := svc.Verify(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeDependencyTimeoutException:
				fmt.Println(kms.ErrCodeDependencyTimeoutException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			case kms.ErrCodeKMSInvalidSignatureException:
				fmt.Println(kms.ErrCodeKMSInvalidSignatureException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To verify an HMAC
//
// This example verifies an HMAC for a particular message, HMAC KMS keys, and MAC algorithm.
// A value of 'true' in the MacValid value in the response indicates that the HMAC is
// valid.
func ExampleKMS_VerifyMac_shared00() {
	svc := kms.New(session.New())
	input := &kms.VerifyMacInput{
		KeyId:        aws.String("1234abcd-12ab-34cd-56ef-1234567890ab"),
		Mac:          []byte("<HMAC_TAG>"),
		MacAlgorithm: aws.String("HMAC_SHA_384"),
		Message:      []byte("Hello World"),
	}

	result, err := svc.VerifyMac(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case kms.ErrCodeNotFoundException:
				fmt.Println(kms.ErrCodeNotFoundException, aerr.Error())
			case kms.ErrCodeDisabledException:
				fmt.Println(kms.ErrCodeDisabledException, aerr.Error())
			case kms.ErrCodeKeyUnavailableException:
				fmt.Println(kms.ErrCodeKeyUnavailableException, aerr.Error())
			case kms.ErrCodeInvalidKeyUsageException:
				fmt.Println(kms.ErrCodeInvalidKeyUsageException, aerr.Error())
			case kms.ErrCodeInvalidGrantTokenException:
				fmt.Println(kms.ErrCodeInvalidGrantTokenException, aerr.Error())
			case kms.ErrCodeInternalException:
				fmt.Println(kms.ErrCodeInternalException, aerr.Error())
			case kms.ErrCodeKMSInvalidMacException:
				fmt.Println(kms.ErrCodeKMSInvalidMacException, aerr.Error())
			case kms.ErrCodeInvalidStateException:
				fmt.Println(kms.ErrCodeInvalidStateException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
