// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rekognition

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCompareFaces = "CompareFaces"

// CompareFacesRequest generates a "aws/request.Request" representing the
// client's request for the CompareFaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CompareFaces for more information on using the CompareFaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CompareFacesRequest method.
//    req, resp := client.CompareFacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) CompareFacesRequest(input *CompareFacesInput) (req *request.Request, output *CompareFacesOutput) {
	op := &request.Operation{
		Name:       opCompareFaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CompareFacesInput{}
	}

	output = &CompareFacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CompareFaces API operation for Amazon Rekognition.
//
// Compares a face in the source input image with each of the 100 largest faces
// detected in the target input image.
//
// If the source image contains multiple faces, the service detects the largest
// face and compares it with each face detected in the target image.
//
// CompareFaces uses machine learning algorithms, which are probabilistic. A
// false negative is an incorrect prediction that a face in the target image
// has a low similarity confidence score when compared to the face in the source
// image. To reduce the probability of false negatives, we recommend that you
// compare the target image against multiple source images. If you plan to use
// CompareFaces to make a decision that impacts an individual's rights, privacy,
// or access to services, we recommend that you pass the result to a human for
// review and further validation before taking action.
//
// You pass the input and target images either as base64-encoded image bytes
// or as references to images in an Amazon S3 bucket. If you use the AWS CLI
// to call Amazon Rekognition operations, passing image bytes isn't supported.
// The image must be formatted as a PNG or JPEG file.
//
// In response, the operation returns an array of face matches ordered by similarity
// score in descending order. For each face match, the response provides a bounding
// box of the face, facial landmarks, pose details (pitch, roll, and yaw), quality
// (brightness and sharpness), and confidence value (indicating the level of
// confidence that the bounding box contains a face). The response also provides
// a similarity score, which indicates how closely the faces match.
//
// By default, only faces with a similarity score of greater than or equal to
// 80% are returned in the response. You can change this value by specifying
// the SimilarityThreshold parameter.
//
// CompareFaces also returns an array of faces that don't match the source image.
// For each face, it returns a bounding box, confidence value, landmarks, pose
// details, and quality. The response also returns information about the face
// in the source image, including the bounding box of the face and confidence
// value.
//
// The QualityFilter input parameter allows you to filter out detected faces
// that don’t meet a required quality bar. The quality bar is based on a variety
// of common use cases. Use QualityFilter to set the quality bar by specifying
// LOW, MEDIUM, or HIGH. If you do not want to filter detected faces, specify
// NONE. The default value is NONE.
//
// If the image doesn't contain Exif metadata, CompareFaces returns orientation
// information for the source and target images. Use these values to display
// the images with the correct image orientation.
//
// If no faces are detected in the source or target images, CompareFaces returns
// an InvalidParameterException error.
//
// This is a stateless API operation. That is, data returned by this operation
// doesn't persist.
//
// For an example, see Comparing Faces in Images in the Amazon Rekognition Developer
// Guide.
//
// This operation requires permissions to perform the rekognition:CompareFaces
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation CompareFaces for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * ImageTooLargeException
//   The input image size exceeds the allowed limit. If you are calling DetectProtectiveEquipment,
//   the image size or resolution exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidImageFormatException
//   The provided image format is not supported.
//
func (c *Rekognition) CompareFaces(input *CompareFacesInput) (*CompareFacesOutput, error) {
	req, out := c.CompareFacesRequest(input)
	return out, req.Send()
}

// CompareFacesWithContext is the same as CompareFaces with the addition of
// the ability to pass a context and additional request options.
//
// See CompareFaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) CompareFacesWithContext(ctx aws.Context, input *CompareFacesInput, opts ...request.Option) (*CompareFacesOutput, error) {
	req, out := c.CompareFacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCollection = "CreateCollection"

// CreateCollectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCollection for more information on using the CreateCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCollectionRequest method.
//    req, resp := client.CreateCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) CreateCollectionRequest(input *CreateCollectionInput) (req *request.Request, output *CreateCollectionOutput) {
	op := &request.Operation{
		Name:       opCreateCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCollectionInput{}
	}

	output = &CreateCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCollection API operation for Amazon Rekognition.
//
// Creates a collection in an AWS Region. You can add faces to the collection
// using the IndexFaces operation.
//
// For example, you might create collections, one for each of your application
// users. A user can then index faces using the IndexFaces operation and persist
// results in a specific collection. Then, a user can search the collection
// for faces in the user-specific container.
//
// When you create a collection, it is associated with the latest version of
// the face model version.
//
// Collection names are case-sensitive.
//
// This operation requires permissions to perform the rekognition:CreateCollection
// action. If you want to tag your collection, you also require permission to
// perform the rekognition:TagResource operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation CreateCollection for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceAlreadyExistsException
//   A resource with the specified ID already exists.
//
//   * ServiceQuotaExceededException
//   The size of the collection exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
func (c *Rekognition) CreateCollection(input *CreateCollectionInput) (*CreateCollectionOutput, error) {
	req, out := c.CreateCollectionRequest(input)
	return out, req.Send()
}

// CreateCollectionWithContext is the same as CreateCollection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) CreateCollectionWithContext(ctx aws.Context, input *CreateCollectionInput, opts ...request.Option) (*CreateCollectionOutput, error) {
	req, out := c.CreateCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataset = "CreateDataset"

// CreateDatasetRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataset for more information on using the CreateDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatasetRequest method.
//    req, resp := client.CreateDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) CreateDatasetRequest(input *CreateDatasetInput) (req *request.Request, output *CreateDatasetOutput) {
	op := &request.Operation{
		Name:       opCreateDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatasetInput{}
	}

	output = &CreateDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataset API operation for Amazon Rekognition.
//
// Creates a new Amazon Rekognition Custom Labels dataset. You can create a
// dataset by using an Amazon Sagemaker format manifest file or by copying an
// existing Amazon Rekognition Custom Labels dataset.
//
// To create a training dataset for a project, specify train for the value of
// DatasetType. To create the test dataset for a project, specify test for the
// value of DatasetType.
//
// The response from CreateDataset is the Amazon Resource Name (ARN) for the
// dataset. Creating a dataset takes a while to complete. Use DescribeDataset
// to check the current status. The dataset created successfully if the value
// of Status is CREATE_COMPLETE.
//
// To check if any non-terminal errors occurred, call ListDatasetEntries and
// check for the presence of errors lists in the JSON Lines.
//
// Dataset creation fails if a terminal error occurs (Status = CREATE_FAILED).
// Currently, you can't access the terminal error information.
//
// For more information, see Creating dataset in the Amazon Rekognition Custom
// Labels Developer Guide.
//
// This operation requires permissions to perform the rekognition:CreateDataset
// action. If you want to copy an existing dataset, you also require permission
// to perform the rekognition:ListDatasetEntries action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation CreateDataset for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * ResourceAlreadyExistsException
//   A resource with the specified ID already exists.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
func (c *Rekognition) CreateDataset(input *CreateDatasetInput) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	return out, req.Send()
}

// CreateDatasetWithContext is the same as CreateDataset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) CreateDatasetWithContext(ctx aws.Context, input *CreateDatasetInput, opts ...request.Option) (*CreateDatasetOutput, error) {
	req, out := c.CreateDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a "aws/request.Request" representing the
// client's request for the CreateProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProject for more information on using the CreateProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProjectRequest method.
//    req, resp := client.CreateProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	output = &CreateProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProject API operation for Amazon Rekognition.
//
// Creates a new Amazon Rekognition Custom Labels project. A project is a group
// of resources (datasets, model versions) that you use to create and manage
// Amazon Rekognition Custom Labels models.
//
// This operation requires permissions to perform the rekognition:CreateProject
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation CreateProject for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	return out, req.Send()
}

// CreateProjectWithContext is the same as CreateProject with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) CreateProjectWithContext(ctx aws.Context, input *CreateProjectInput, opts ...request.Option) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProjectVersion = "CreateProjectVersion"

// CreateProjectVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateProjectVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProjectVersion for more information on using the CreateProjectVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProjectVersionRequest method.
//    req, resp := client.CreateProjectVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) CreateProjectVersionRequest(input *CreateProjectVersionInput) (req *request.Request, output *CreateProjectVersionOutput) {
	op := &request.Operation{
		Name:       opCreateProjectVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProjectVersionInput{}
	}

	output = &CreateProjectVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProjectVersion API operation for Amazon Rekognition.
//
// Creates a new version of a model and begins training. Models are managed
// as part of an Amazon Rekognition Custom Labels project. The response from
// CreateProjectVersion is an Amazon Resource Name (ARN) for the version of
// the model.
//
// Training uses the training and test datasets associated with the project.
// For more information, see Creating training and test dataset in the Amazon
// Rekognition Custom Labels Developer Guide.
//
// You can train a model in a project that doesn't have associated datasets
// by specifying manifest files in the TrainingData and TestingData fields.
//
// If you open the console after training a model with manifest files, Amazon
// Rekognition Custom Labels creates the datasets for you using the most recent
// manifest files. You can no longer train a model version for the project by
// specifying manifest files.
//
// Instead of training with a project without associated datasets, we recommend
// that you use the manifest files to create training and test datasets for
// the project.
//
// Training takes a while to complete. You can get the current status by calling
// DescribeProjectVersions. Training completed successfully if the value of
// the Status field is TRAINING_COMPLETED.
//
// If training fails, see Debugging a failed model training in the Amazon Rekognition
// Custom Labels developer guide.
//
// Once training has successfully completed, call DescribeProjectVersions to
// get the training results and evaluate the model. For more information, see
// Improving a trained Amazon Rekognition Custom Labels model in the Amazon
// Rekognition Custom Labels developers guide.
//
// After evaluating the model, you start the model by calling StartProjectVersion.
//
// This operation requires permissions to perform the rekognition:CreateProjectVersion
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation CreateProjectVersion for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ServiceQuotaExceededException
//   The size of the collection exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
func (c *Rekognition) CreateProjectVersion(input *CreateProjectVersionInput) (*CreateProjectVersionOutput, error) {
	req, out := c.CreateProjectVersionRequest(input)
	return out, req.Send()
}

// CreateProjectVersionWithContext is the same as CreateProjectVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProjectVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) CreateProjectVersionWithContext(ctx aws.Context, input *CreateProjectVersionInput, opts ...request.Option) (*CreateProjectVersionOutput, error) {
	req, out := c.CreateProjectVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStreamProcessor = "CreateStreamProcessor"

// CreateStreamProcessorRequest generates a "aws/request.Request" representing the
// client's request for the CreateStreamProcessor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStreamProcessor for more information on using the CreateStreamProcessor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStreamProcessorRequest method.
//    req, resp := client.CreateStreamProcessorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) CreateStreamProcessorRequest(input *CreateStreamProcessorInput) (req *request.Request, output *CreateStreamProcessorOutput) {
	op := &request.Operation{
		Name:       opCreateStreamProcessor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStreamProcessorInput{}
	}

	output = &CreateStreamProcessorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStreamProcessor API operation for Amazon Rekognition.
//
// Creates an Amazon Rekognition stream processor that you can use to detect
// and recognize faces or to detect labels in a streaming video.
//
// Amazon Rekognition Video is a consumer of live video from Amazon Kinesis
// Video Streams. There are two different settings for stream processors in
// Amazon Rekognition: detecting faces and detecting labels.
//
//    * If you are creating a stream processor for detecting faces, you provide
//    as input a Kinesis video stream (Input) and a Kinesis data stream (Output)
//    stream. You also specify the face recognition criteria in Settings. For
//    example, the collection containing faces that you want to recognize. After
//    you have finished analyzing a streaming video, use StopStreamProcessor
//    to stop processing.
//
//    * If you are creating a stream processor to detect labels, you provide
//    as input a Kinesis video stream (Input), Amazon S3 bucket information
//    (Output), and an Amazon SNS topic ARN (NotificationChannel). You can also
//    provide a KMS key ID to encrypt the data sent to your Amazon S3 bucket.
//    You specify what you want to detect in ConnectedHomeSettings, such as
//    people, packages and people, or pets, people, and packages. You can also
//    specify where in the frame you want Amazon Rekognition to monitor with
//    RegionsOfInterest. When you run the StartStreamProcessor operation on
//    a label detection stream processor, you input start and stop information
//    to determine the length of the processing time.
//
// Use Name to assign an identifier for the stream processor. You use Name to
// manage the stream processor. For example, you can start processing the source
// video by calling StartStreamProcessor with the Name field.
//
// This operation requires permissions to perform the rekognition:CreateStreamProcessor
// action. If you want to tag your stream processor, you also require permission
// to perform the rekognition:TagResource operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation CreateStreamProcessor for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ServiceQuotaExceededException
//   The size of the collection exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
func (c *Rekognition) CreateStreamProcessor(input *CreateStreamProcessorInput) (*CreateStreamProcessorOutput, error) {
	req, out := c.CreateStreamProcessorRequest(input)
	return out, req.Send()
}

// CreateStreamProcessorWithContext is the same as CreateStreamProcessor with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStreamProcessor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) CreateStreamProcessorWithContext(ctx aws.Context, input *CreateStreamProcessorInput, opts ...request.Option) (*CreateStreamProcessorOutput, error) {
	req, out := c.CreateStreamProcessorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCollection = "DeleteCollection"

// DeleteCollectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCollection for more information on using the DeleteCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCollectionRequest method.
//    req, resp := client.DeleteCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DeleteCollectionRequest(input *DeleteCollectionInput) (req *request.Request, output *DeleteCollectionOutput) {
	op := &request.Operation{
		Name:       opDeleteCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCollectionInput{}
	}

	output = &DeleteCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCollection API operation for Amazon Rekognition.
//
// Deletes the specified collection. Note that this operation removes all faces
// in the collection. For an example, see Deleting a collection (https://docs.aws.amazon.com/rekognition/latest/dg/delete-collection-procedure.html).
//
// This operation requires permissions to perform the rekognition:DeleteCollection
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DeleteCollection for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
func (c *Rekognition) DeleteCollection(input *DeleteCollectionInput) (*DeleteCollectionOutput, error) {
	req, out := c.DeleteCollectionRequest(input)
	return out, req.Send()
}

// DeleteCollectionWithContext is the same as DeleteCollection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DeleteCollectionWithContext(ctx aws.Context, input *DeleteCollectionInput, opts ...request.Option) (*DeleteCollectionOutput, error) {
	req, out := c.DeleteCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataset = "DeleteDataset"

// DeleteDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataset for more information on using the DeleteDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatasetRequest method.
//    req, resp := client.DeleteDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DeleteDatasetRequest(input *DeleteDatasetInput) (req *request.Request, output *DeleteDatasetOutput) {
	op := &request.Operation{
		Name:       opDeleteDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatasetInput{}
	}

	output = &DeleteDatasetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataset API operation for Amazon Rekognition.
//
// Deletes an existing Amazon Rekognition Custom Labels dataset. Deleting a
// dataset might take while. Use DescribeDataset to check the current status.
// The dataset is still deleting if the value of Status is DELETE_IN_PROGRESS.
// If you try to access the dataset after it is deleted, you get a ResourceNotFoundException
// exception.
//
// You can't delete a dataset while it is creating (Status = CREATE_IN_PROGRESS)
// or if the dataset is updating (Status = UPDATE_IN_PROGRESS).
//
// This operation requires permissions to perform the rekognition:DeleteDataset
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DeleteDataset for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
func (c *Rekognition) DeleteDataset(input *DeleteDatasetInput) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	return out, req.Send()
}

// DeleteDatasetWithContext is the same as DeleteDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DeleteDatasetWithContext(ctx aws.Context, input *DeleteDatasetInput, opts ...request.Option) (*DeleteDatasetOutput, error) {
	req, out := c.DeleteDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFaces = "DeleteFaces"

// DeleteFacesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFaces for more information on using the DeleteFaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFacesRequest method.
//    req, resp := client.DeleteFacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DeleteFacesRequest(input *DeleteFacesInput) (req *request.Request, output *DeleteFacesOutput) {
	op := &request.Operation{
		Name:       opDeleteFaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFacesInput{}
	}

	output = &DeleteFacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFaces API operation for Amazon Rekognition.
//
// Deletes faces from a collection. You specify a collection ID and an array
// of face IDs to remove from the collection.
//
// This operation requires permissions to perform the rekognition:DeleteFaces
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DeleteFaces for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
func (c *Rekognition) DeleteFaces(input *DeleteFacesInput) (*DeleteFacesOutput, error) {
	req, out := c.DeleteFacesRequest(input)
	return out, req.Send()
}

// DeleteFacesWithContext is the same as DeleteFaces with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DeleteFacesWithContext(ctx aws.Context, input *DeleteFacesInput, opts ...request.Option) (*DeleteFacesOutput, error) {
	req, out := c.DeleteFacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProject = "DeleteProject"

// DeleteProjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProject for more information on using the DeleteProject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProjectRequest method.
//    req, resp := client.DeleteProjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DeleteProjectRequest(input *DeleteProjectInput) (req *request.Request, output *DeleteProjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProjectInput{}
	}

	output = &DeleteProjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProject API operation for Amazon Rekognition.
//
// Deletes an Amazon Rekognition Custom Labels project. To delete a project
// you must first delete all models associated with the project. To delete a
// model, see DeleteProjectVersion.
//
// DeleteProject is an asynchronous operation. To check if the project is deleted,
// call DescribeProjects. The project is deleted when the project no longer
// appears in the response.
//
// This operation requires permissions to perform the rekognition:DeleteProject
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DeleteProject for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) DeleteProject(input *DeleteProjectInput) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	return out, req.Send()
}

// DeleteProjectWithContext is the same as DeleteProject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DeleteProjectWithContext(ctx aws.Context, input *DeleteProjectInput, opts ...request.Option) (*DeleteProjectOutput, error) {
	req, out := c.DeleteProjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProjectVersion = "DeleteProjectVersion"

// DeleteProjectVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProjectVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProjectVersion for more information on using the DeleteProjectVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProjectVersionRequest method.
//    req, resp := client.DeleteProjectVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DeleteProjectVersionRequest(input *DeleteProjectVersionInput) (req *request.Request, output *DeleteProjectVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteProjectVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteProjectVersionInput{}
	}

	output = &DeleteProjectVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProjectVersion API operation for Amazon Rekognition.
//
// Deletes an Amazon Rekognition Custom Labels model.
//
// You can't delete a model if it is running or if it is training. To check
// the status of a model, use the Status field returned from DescribeProjectVersions.
// To stop a running model call StopProjectVersion. If the model is training,
// wait until it finishes.
//
// This operation requires permissions to perform the rekognition:DeleteProjectVersion
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DeleteProjectVersion for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) DeleteProjectVersion(input *DeleteProjectVersionInput) (*DeleteProjectVersionOutput, error) {
	req, out := c.DeleteProjectVersionRequest(input)
	return out, req.Send()
}

// DeleteProjectVersionWithContext is the same as DeleteProjectVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProjectVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DeleteProjectVersionWithContext(ctx aws.Context, input *DeleteProjectVersionInput, opts ...request.Option) (*DeleteProjectVersionOutput, error) {
	req, out := c.DeleteProjectVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStreamProcessor = "DeleteStreamProcessor"

// DeleteStreamProcessorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStreamProcessor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStreamProcessor for more information on using the DeleteStreamProcessor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStreamProcessorRequest method.
//    req, resp := client.DeleteStreamProcessorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DeleteStreamProcessorRequest(input *DeleteStreamProcessorInput) (req *request.Request, output *DeleteStreamProcessorOutput) {
	op := &request.Operation{
		Name:       opDeleteStreamProcessor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStreamProcessorInput{}
	}

	output = &DeleteStreamProcessorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStreamProcessor API operation for Amazon Rekognition.
//
// Deletes the stream processor identified by Name. You assign the value for
// Name when you create the stream processor with CreateStreamProcessor. You
// might not be able to use the same name for a stream processor for a few seconds
// after calling DeleteStreamProcessor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DeleteStreamProcessor for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) DeleteStreamProcessor(input *DeleteStreamProcessorInput) (*DeleteStreamProcessorOutput, error) {
	req, out := c.DeleteStreamProcessorRequest(input)
	return out, req.Send()
}

// DeleteStreamProcessorWithContext is the same as DeleteStreamProcessor with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStreamProcessor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DeleteStreamProcessorWithContext(ctx aws.Context, input *DeleteStreamProcessorInput, opts ...request.Option) (*DeleteStreamProcessorOutput, error) {
	req, out := c.DeleteStreamProcessorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCollection = "DescribeCollection"

// DescribeCollectionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCollection for more information on using the DescribeCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCollectionRequest method.
//    req, resp := client.DescribeCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DescribeCollectionRequest(input *DescribeCollectionInput) (req *request.Request, output *DescribeCollectionOutput) {
	op := &request.Operation{
		Name:       opDescribeCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCollectionInput{}
	}

	output = &DescribeCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCollection API operation for Amazon Rekognition.
//
// Describes the specified collection. You can use DescribeCollection to get
// information, such as the number of faces indexed into a collection and the
// version of the model used by the collection for face detection.
//
// For more information, see Describing a Collection in the Amazon Rekognition
// Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DescribeCollection for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
func (c *Rekognition) DescribeCollection(input *DescribeCollectionInput) (*DescribeCollectionOutput, error) {
	req, out := c.DescribeCollectionRequest(input)
	return out, req.Send()
}

// DescribeCollectionWithContext is the same as DescribeCollection with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DescribeCollectionWithContext(ctx aws.Context, input *DescribeCollectionInput, opts ...request.Option) (*DescribeCollectionOutput, error) {
	req, out := c.DescribeCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDataset = "DescribeDataset"

// DescribeDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDataset for more information on using the DescribeDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDatasetRequest method.
//    req, resp := client.DescribeDatasetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DescribeDatasetRequest(input *DescribeDatasetInput) (req *request.Request, output *DescribeDatasetOutput) {
	op := &request.Operation{
		Name:       opDescribeDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDatasetInput{}
	}

	output = &DescribeDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDataset API operation for Amazon Rekognition.
//
// Describes an Amazon Rekognition Custom Labels dataset. You can get information
// such as the current status of a dataset and statistics about the images and
// labels in a dataset.
//
// This operation requires permissions to perform the rekognition:DescribeDataset
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DescribeDataset for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
func (c *Rekognition) DescribeDataset(input *DescribeDatasetInput) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	return out, req.Send()
}

// DescribeDatasetWithContext is the same as DescribeDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DescribeDatasetWithContext(ctx aws.Context, input *DescribeDatasetInput, opts ...request.Option) (*DescribeDatasetOutput, error) {
	req, out := c.DescribeDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProjectVersions = "DescribeProjectVersions"

// DescribeProjectVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProjectVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProjectVersions for more information on using the DescribeProjectVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProjectVersionsRequest method.
//    req, resp := client.DescribeProjectVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DescribeProjectVersionsRequest(input *DescribeProjectVersionsInput) (req *request.Request, output *DescribeProjectVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeProjectVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeProjectVersionsInput{}
	}

	output = &DescribeProjectVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProjectVersions API operation for Amazon Rekognition.
//
// Lists and describes the versions of a model in an Amazon Rekognition Custom
// Labels project. You can specify up to 10 model versions in ProjectVersionArns.
// If you don't specify a value, descriptions for all model versions in the
// project are returned.
//
// This operation requires permissions to perform the rekognition:DescribeProjectVersions
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DescribeProjectVersions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) DescribeProjectVersions(input *DescribeProjectVersionsInput) (*DescribeProjectVersionsOutput, error) {
	req, out := c.DescribeProjectVersionsRequest(input)
	return out, req.Send()
}

// DescribeProjectVersionsWithContext is the same as DescribeProjectVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProjectVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DescribeProjectVersionsWithContext(ctx aws.Context, input *DescribeProjectVersionsInput, opts ...request.Option) (*DescribeProjectVersionsOutput, error) {
	req, out := c.DescribeProjectVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeProjectVersionsPages iterates over the pages of a DescribeProjectVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeProjectVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeProjectVersions operation.
//    pageNum := 0
//    err := client.DescribeProjectVersionsPages(params,
//        func(page *rekognition.DescribeProjectVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) DescribeProjectVersionsPages(input *DescribeProjectVersionsInput, fn func(*DescribeProjectVersionsOutput, bool) bool) error {
	return c.DescribeProjectVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeProjectVersionsPagesWithContext same as DescribeProjectVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DescribeProjectVersionsPagesWithContext(ctx aws.Context, input *DescribeProjectVersionsInput, fn func(*DescribeProjectVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeProjectVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeProjectVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeProjectVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeProjects = "DescribeProjects"

// DescribeProjectsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProjects for more information on using the DescribeProjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeProjectsRequest method.
//    req, resp := client.DescribeProjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DescribeProjectsRequest(input *DescribeProjectsInput) (req *request.Request, output *DescribeProjectsOutput) {
	op := &request.Operation{
		Name:       opDescribeProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeProjectsInput{}
	}

	output = &DescribeProjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProjects API operation for Amazon Rekognition.
//
// Gets information about your Amazon Rekognition Custom Labels projects.
//
// This operation requires permissions to perform the rekognition:DescribeProjects
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DescribeProjects for usage and error information.
//
// Returned Error Types:
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) DescribeProjects(input *DescribeProjectsInput) (*DescribeProjectsOutput, error) {
	req, out := c.DescribeProjectsRequest(input)
	return out, req.Send()
}

// DescribeProjectsWithContext is the same as DescribeProjects with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DescribeProjectsWithContext(ctx aws.Context, input *DescribeProjectsInput, opts ...request.Option) (*DescribeProjectsOutput, error) {
	req, out := c.DescribeProjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeProjectsPages iterates over the pages of a DescribeProjects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeProjects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeProjects operation.
//    pageNum := 0
//    err := client.DescribeProjectsPages(params,
//        func(page *rekognition.DescribeProjectsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) DescribeProjectsPages(input *DescribeProjectsInput, fn func(*DescribeProjectsOutput, bool) bool) error {
	return c.DescribeProjectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeProjectsPagesWithContext same as DescribeProjectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DescribeProjectsPagesWithContext(ctx aws.Context, input *DescribeProjectsInput, fn func(*DescribeProjectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeProjectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeProjectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeProjectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeStreamProcessor = "DescribeStreamProcessor"

// DescribeStreamProcessorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStreamProcessor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStreamProcessor for more information on using the DescribeStreamProcessor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStreamProcessorRequest method.
//    req, resp := client.DescribeStreamProcessorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DescribeStreamProcessorRequest(input *DescribeStreamProcessorInput) (req *request.Request, output *DescribeStreamProcessorOutput) {
	op := &request.Operation{
		Name:       opDescribeStreamProcessor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStreamProcessorInput{}
	}

	output = &DescribeStreamProcessorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStreamProcessor API operation for Amazon Rekognition.
//
// Provides information about a stream processor created by CreateStreamProcessor.
// You can get information about the input and output streams, the input parameters
// for the face recognition being performed, and the current status of the stream
// processor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DescribeStreamProcessor for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) DescribeStreamProcessor(input *DescribeStreamProcessorInput) (*DescribeStreamProcessorOutput, error) {
	req, out := c.DescribeStreamProcessorRequest(input)
	return out, req.Send()
}

// DescribeStreamProcessorWithContext is the same as DescribeStreamProcessor with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStreamProcessor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DescribeStreamProcessorWithContext(ctx aws.Context, input *DescribeStreamProcessorInput, opts ...request.Option) (*DescribeStreamProcessorOutput, error) {
	req, out := c.DescribeStreamProcessorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectCustomLabels = "DetectCustomLabels"

// DetectCustomLabelsRequest generates a "aws/request.Request" representing the
// client's request for the DetectCustomLabels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectCustomLabels for more information on using the DetectCustomLabels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectCustomLabelsRequest method.
//    req, resp := client.DetectCustomLabelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DetectCustomLabelsRequest(input *DetectCustomLabelsInput) (req *request.Request, output *DetectCustomLabelsOutput) {
	op := &request.Operation{
		Name:       opDetectCustomLabels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectCustomLabelsInput{}
	}

	output = &DetectCustomLabelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectCustomLabels API operation for Amazon Rekognition.
//
// Detects custom labels in a supplied image by using an Amazon Rekognition
// Custom Labels model.
//
// You specify which version of a model version to use by using the ProjectVersionArn
// input parameter.
//
// You pass the input image as base64-encoded image bytes or as a reference
// to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
// Rekognition operations, passing image bytes is not supported. The image must
// be either a PNG or JPEG formatted file.
//
// For each object that the model version detects on an image, the API returns
// a (CustomLabel) object in an array (CustomLabels). Each CustomLabel object
// provides the label name (Name), the level of confidence that the image contains
// the object (Confidence), and object location information, if it exists, for
// the label on the image (Geometry).
//
// To filter labels that are returned, specify a value for MinConfidence. DetectCustomLabelsLabels
// only returns labels with a confidence that's higher than the specified value.
// The value of MinConfidence maps to the assumed threshold values created during
// training. For more information, see Assumed threshold in the Amazon Rekognition
// Custom Labels Developer Guide. Amazon Rekognition Custom Labels metrics expresses
// an assumed threshold as a floating point value between 0-1. The range of
// MinConfidence normalizes the threshold value to a percentage value (0-100).
// Confidence responses from DetectCustomLabels are also returned as a percentage.
// You can use MinConfidence to change the precision and recall or your model.
// For more information, see Analyzing an image in the Amazon Rekognition Custom
// Labels Developer Guide.
//
// If you don't specify a value for MinConfidence, DetectCustomLabels returns
// labels based on the assumed threshold of each label.
//
// This is a stateless API operation. That is, the operation does not persist
// any data.
//
// This operation requires permissions to perform the rekognition:DetectCustomLabels
// action.
//
// For more information, see Analyzing an image in the Amazon Rekognition Custom
// Labels Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DetectCustomLabels for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ResourceNotReadyException
//   The requested resource isn't ready. For example, this exception occurs when
//   you call DetectCustomLabels with a model version that isn't deployed.
//
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ImageTooLargeException
//   The input image size exceeds the allowed limit. If you are calling DetectProtectiveEquipment,
//   the image size or resolution exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidImageFormatException
//   The provided image format is not supported.
//
func (c *Rekognition) DetectCustomLabels(input *DetectCustomLabelsInput) (*DetectCustomLabelsOutput, error) {
	req, out := c.DetectCustomLabelsRequest(input)
	return out, req.Send()
}

// DetectCustomLabelsWithContext is the same as DetectCustomLabels with the addition of
// the ability to pass a context and additional request options.
//
// See DetectCustomLabels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DetectCustomLabelsWithContext(ctx aws.Context, input *DetectCustomLabelsInput, opts ...request.Option) (*DetectCustomLabelsOutput, error) {
	req, out := c.DetectCustomLabelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectFaces = "DetectFaces"

// DetectFacesRequest generates a "aws/request.Request" representing the
// client's request for the DetectFaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectFaces for more information on using the DetectFaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectFacesRequest method.
//    req, resp := client.DetectFacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DetectFacesRequest(input *DetectFacesInput) (req *request.Request, output *DetectFacesOutput) {
	op := &request.Operation{
		Name:       opDetectFaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectFacesInput{}
	}

	output = &DetectFacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectFaces API operation for Amazon Rekognition.
//
// Detects faces within an image that is provided as input.
//
// DetectFaces detects the 100 largest faces in the image. For each face detected,
// the operation returns face details. These details include a bounding box
// of the face, a confidence value (that the bounding box contains a face),
// and a fixed set of attributes such as facial landmarks (for example, coordinates
// of eye and mouth), presence of beard, sunglasses, and so on.
//
// The face-detection algorithm is most effective on frontal faces. For non-frontal
// or obscured faces, the algorithm might not detect the faces or might detect
// faces with lower confidence.
//
// You pass the input image either as base64-encoded image bytes or as a reference
// to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
// Rekognition operations, passing image bytes is not supported. The image must
// be either a PNG or JPEG formatted file.
//
// This is a stateless API operation. That is, the operation does not persist
// any data.
//
// This operation requires permissions to perform the rekognition:DetectFaces
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DetectFaces for usage and error information.
//
// Returned Error Types:
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ImageTooLargeException
//   The input image size exceeds the allowed limit. If you are calling DetectProtectiveEquipment,
//   the image size or resolution exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidImageFormatException
//   The provided image format is not supported.
//
func (c *Rekognition) DetectFaces(input *DetectFacesInput) (*DetectFacesOutput, error) {
	req, out := c.DetectFacesRequest(input)
	return out, req.Send()
}

// DetectFacesWithContext is the same as DetectFaces with the addition of
// the ability to pass a context and additional request options.
//
// See DetectFaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DetectFacesWithContext(ctx aws.Context, input *DetectFacesInput, opts ...request.Option) (*DetectFacesOutput, error) {
	req, out := c.DetectFacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectLabels = "DetectLabels"

// DetectLabelsRequest generates a "aws/request.Request" representing the
// client's request for the DetectLabels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectLabels for more information on using the DetectLabels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectLabelsRequest method.
//    req, resp := client.DetectLabelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DetectLabelsRequest(input *DetectLabelsInput) (req *request.Request, output *DetectLabelsOutput) {
	op := &request.Operation{
		Name:       opDetectLabels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectLabelsInput{}
	}

	output = &DetectLabelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectLabels API operation for Amazon Rekognition.
//
// Detects instances of real-world entities within an image (JPEG or PNG) provided
// as input. This includes objects like flower, tree, and table; events like
// wedding, graduation, and birthday party; and concepts like landscape, evening,
// and nature.
//
// For an example, see Analyzing images stored in an Amazon S3 bucket in the
// Amazon Rekognition Developer Guide.
//
// DetectLabels does not support the detection of activities. However, activity
// detection is supported for label detection in videos. For more information,
// see StartLabelDetection in the Amazon Rekognition Developer Guide.
//
// You pass the input image as base64-encoded image bytes or as a reference
// to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
// Rekognition operations, passing image bytes is not supported. The image must
// be either a PNG or JPEG formatted file.
//
// For each object, scene, and concept the API returns one or more labels. Each
// label provides the object name, and the level of confidence that the image
// contains the object. For example, suppose the input image has a lighthouse,
// the sea, and a rock. The response includes all three labels, one for each
// object.
//
// {Name: lighthouse, Confidence: 98.4629}
//
// {Name: rock,Confidence: 79.2097}
//
// {Name: sea,Confidence: 75.061}
//
// In the preceding example, the operation returns one label for each of the
// three objects. The operation can also return multiple labels for the same
// object in the image. For example, if the input image shows a flower (for
// example, a tulip), the operation might return the following three labels.
//
// {Name: flower,Confidence: 99.0562}
//
// {Name: plant,Confidence: 99.0562}
//
// {Name: tulip,Confidence: 99.0562}
//
// In this example, the detection algorithm more precisely identifies the flower
// as a tulip.
//
// In response, the API returns an array of labels. In addition, the response
// also includes the orientation correction. Optionally, you can specify MinConfidence
// to control the confidence threshold for the labels returned. The default
// is 55%. You can also add the MaxLabels parameter to limit the number of labels
// returned.
//
// If the object detected is a person, the operation doesn't provide the same
// facial details that the DetectFaces operation provides.
//
// DetectLabels returns bounding boxes for instances of common object labels
// in an array of Instance objects. An Instance object contains a BoundingBox
// object, for the location of the label on the image. It also includes the
// confidence by which the bounding box was detected.
//
// DetectLabels also returns a hierarchical taxonomy of detected labels. For
// example, a detected car might be assigned the label car. The label car has
// two parent labels: Vehicle (its parent) and Transportation (its grandparent).
// The response returns the entire list of ancestors for a label. Each ancestor
// is a unique label in the response. In the previous example, Car, Vehicle,
// and Transportation are returned as unique labels in the response.
//
// This is a stateless API operation. That is, the operation does not persist
// any data.
//
// This operation requires permissions to perform the rekognition:DetectLabels
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DetectLabels for usage and error information.
//
// Returned Error Types:
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ImageTooLargeException
//   The input image size exceeds the allowed limit. If you are calling DetectProtectiveEquipment,
//   the image size or resolution exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidImageFormatException
//   The provided image format is not supported.
//
func (c *Rekognition) DetectLabels(input *DetectLabelsInput) (*DetectLabelsOutput, error) {
	req, out := c.DetectLabelsRequest(input)
	return out, req.Send()
}

// DetectLabelsWithContext is the same as DetectLabels with the addition of
// the ability to pass a context and additional request options.
//
// See DetectLabels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DetectLabelsWithContext(ctx aws.Context, input *DetectLabelsInput, opts ...request.Option) (*DetectLabelsOutput, error) {
	req, out := c.DetectLabelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectModerationLabels = "DetectModerationLabels"

// DetectModerationLabelsRequest generates a "aws/request.Request" representing the
// client's request for the DetectModerationLabels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectModerationLabels for more information on using the DetectModerationLabels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectModerationLabelsRequest method.
//    req, resp := client.DetectModerationLabelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DetectModerationLabelsRequest(input *DetectModerationLabelsInput) (req *request.Request, output *DetectModerationLabelsOutput) {
	op := &request.Operation{
		Name:       opDetectModerationLabels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectModerationLabelsInput{}
	}

	output = &DetectModerationLabelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectModerationLabels API operation for Amazon Rekognition.
//
// Detects unsafe content in a specified JPEG or PNG format image. Use DetectModerationLabels
// to moderate images depending on your requirements. For example, you might
// want to filter images that contain nudity, but not images containing suggestive
// content.
//
// To filter images, use the labels returned by DetectModerationLabels to determine
// which types of content are appropriate.
//
// For information about moderation labels, see Detecting Unsafe Content in
// the Amazon Rekognition Developer Guide.
//
// You pass the input image either as base64-encoded image bytes or as a reference
// to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
// Rekognition operations, passing image bytes is not supported. The image must
// be either a PNG or JPEG formatted file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DetectModerationLabels for usage and error information.
//
// Returned Error Types:
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ImageTooLargeException
//   The input image size exceeds the allowed limit. If you are calling DetectProtectiveEquipment,
//   the image size or resolution exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidImageFormatException
//   The provided image format is not supported.
//
//   * HumanLoopQuotaExceededException
//   The number of in-progress human reviews you have has exceeded the number
//   allowed.
//
func (c *Rekognition) DetectModerationLabels(input *DetectModerationLabelsInput) (*DetectModerationLabelsOutput, error) {
	req, out := c.DetectModerationLabelsRequest(input)
	return out, req.Send()
}

// DetectModerationLabelsWithContext is the same as DetectModerationLabels with the addition of
// the ability to pass a context and additional request options.
//
// See DetectModerationLabels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DetectModerationLabelsWithContext(ctx aws.Context, input *DetectModerationLabelsInput, opts ...request.Option) (*DetectModerationLabelsOutput, error) {
	req, out := c.DetectModerationLabelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectProtectiveEquipment = "DetectProtectiveEquipment"

// DetectProtectiveEquipmentRequest generates a "aws/request.Request" representing the
// client's request for the DetectProtectiveEquipment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectProtectiveEquipment for more information on using the DetectProtectiveEquipment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectProtectiveEquipmentRequest method.
//    req, resp := client.DetectProtectiveEquipmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DetectProtectiveEquipmentRequest(input *DetectProtectiveEquipmentInput) (req *request.Request, output *DetectProtectiveEquipmentOutput) {
	op := &request.Operation{
		Name:       opDetectProtectiveEquipment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectProtectiveEquipmentInput{}
	}

	output = &DetectProtectiveEquipmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectProtectiveEquipment API operation for Amazon Rekognition.
//
// Detects Personal Protective Equipment (PPE) worn by people detected in an
// image. Amazon Rekognition can detect the following types of PPE.
//
//    * Face cover
//
//    * Hand cover
//
//    * Head cover
//
// You pass the input image as base64-encoded image bytes or as a reference
// to an image in an Amazon S3 bucket. The image must be either a PNG or JPG
// formatted file.
//
// DetectProtectiveEquipment detects PPE worn by up to 15 persons detected in
// an image.
//
// For each person detected in the image the API returns an array of body parts
// (face, head, left-hand, right-hand). For each body part, an array of detected
// items of PPE is returned, including an indicator of whether or not the PPE
// covers the body part. The API returns the confidence it has in each detection
// (person, PPE, body part and body part coverage). It also returns a bounding
// box (BoundingBox) for each detected person and each detected item of PPE.
//
// You can optionally request a summary of detected PPE items with the SummarizationAttributes
// input parameter. The summary provides the following information.
//
//    * The persons detected as wearing all of the types of PPE that you specify.
//
//    * The persons detected as not wearing all of the types PPE that you specify.
//
//    * The persons detected where PPE adornment could not be determined.
//
// This is a stateless API operation. That is, the operation does not persist
// any data.
//
// This operation requires permissions to perform the rekognition:DetectProtectiveEquipment
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DetectProtectiveEquipment for usage and error information.
//
// Returned Error Types:
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ImageTooLargeException
//   The input image size exceeds the allowed limit. If you are calling DetectProtectiveEquipment,
//   the image size or resolution exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidImageFormatException
//   The provided image format is not supported.
//
func (c *Rekognition) DetectProtectiveEquipment(input *DetectProtectiveEquipmentInput) (*DetectProtectiveEquipmentOutput, error) {
	req, out := c.DetectProtectiveEquipmentRequest(input)
	return out, req.Send()
}

// DetectProtectiveEquipmentWithContext is the same as DetectProtectiveEquipment with the addition of
// the ability to pass a context and additional request options.
//
// See DetectProtectiveEquipment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DetectProtectiveEquipmentWithContext(ctx aws.Context, input *DetectProtectiveEquipmentInput, opts ...request.Option) (*DetectProtectiveEquipmentOutput, error) {
	req, out := c.DetectProtectiveEquipmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectText = "DetectText"

// DetectTextRequest generates a "aws/request.Request" representing the
// client's request for the DetectText operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectText for more information on using the DetectText
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectTextRequest method.
//    req, resp := client.DetectTextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DetectTextRequest(input *DetectTextInput) (req *request.Request, output *DetectTextOutput) {
	op := &request.Operation{
		Name:       opDetectText,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectTextInput{}
	}

	output = &DetectTextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectText API operation for Amazon Rekognition.
//
// Detects text in the input image and converts it into machine-readable text.
//
// Pass the input image as base64-encoded image bytes or as a reference to an
// image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon Rekognition
// operations, you must pass it as a reference to an image in an Amazon S3 bucket.
// For the AWS CLI, passing image bytes is not supported. The image must be
// either a .png or .jpeg formatted file.
//
// The DetectText operation returns text in an array of TextDetection elements,
// TextDetections. Each TextDetection element provides information about a single
// word or line of text that was detected in the image.
//
// A word is one or more script characters that are not separated by spaces.
// DetectText can detect up to 100 words in an image.
//
// A line is a string of equally spaced words. A line isn't necessarily a complete
// sentence. For example, a driver's license number is detected as a line. A
// line ends when there is no aligned text after it. Also, a line ends when
// there is a large gap between words, relative to the length of the words.
// This means, depending on the gap between words, Amazon Rekognition may detect
// multiple lines in text aligned in the same direction. Periods don't represent
// the end of a line. If a sentence spans multiple lines, the DetectText operation
// returns multiple lines.
//
// To determine whether a TextDetection element is a line of text or a word,
// use the TextDetection object Type field.
//
// To be detected, text must be within +/- 90 degrees orientation of the horizontal
// axis.
//
// For more information, see Detecting text in the Amazon Rekognition Developer
// Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DetectText for usage and error information.
//
// Returned Error Types:
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ImageTooLargeException
//   The input image size exceeds the allowed limit. If you are calling DetectProtectiveEquipment,
//   the image size or resolution exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidImageFormatException
//   The provided image format is not supported.
//
func (c *Rekognition) DetectText(input *DetectTextInput) (*DetectTextOutput, error) {
	req, out := c.DetectTextRequest(input)
	return out, req.Send()
}

// DetectTextWithContext is the same as DetectText with the addition of
// the ability to pass a context and additional request options.
//
// See DetectText for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DetectTextWithContext(ctx aws.Context, input *DetectTextInput, opts ...request.Option) (*DetectTextOutput, error) {
	req, out := c.DetectTextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDistributeDatasetEntries = "DistributeDatasetEntries"

// DistributeDatasetEntriesRequest generates a "aws/request.Request" representing the
// client's request for the DistributeDatasetEntries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DistributeDatasetEntries for more information on using the DistributeDatasetEntries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DistributeDatasetEntriesRequest method.
//    req, resp := client.DistributeDatasetEntriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) DistributeDatasetEntriesRequest(input *DistributeDatasetEntriesInput) (req *request.Request, output *DistributeDatasetEntriesOutput) {
	op := &request.Operation{
		Name:       opDistributeDatasetEntries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DistributeDatasetEntriesInput{}
	}

	output = &DistributeDatasetEntriesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DistributeDatasetEntries API operation for Amazon Rekognition.
//
// Distributes the entries (images) in a training dataset across the training
// dataset and the test dataset for a project. DistributeDatasetEntries moves
// 20% of the training dataset images to the test dataset. An entry is a JSON
// Line that describes an image.
//
// You supply the Amazon Resource Names (ARN) of a project's training dataset
// and test dataset. The training dataset must contain the images that you want
// to split. The test dataset must be empty. The datasets must belong to the
// same project. To create training and test datasets for a project, call CreateDataset.
//
// Distributing a dataset takes a while to complete. To check the status call
// DescribeDataset. The operation is complete when the Status field for the
// training dataset and the test dataset is UPDATE_COMPLETE. If the dataset
// split fails, the value of Status is UPDATE_FAILED.
//
// This operation requires permissions to perform the rekognition:DistributeDatasetEntries
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation DistributeDatasetEntries for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotReadyException
//   The requested resource isn't ready. For example, this exception occurs when
//   you call DetectCustomLabels with a model version that isn't deployed.
//
func (c *Rekognition) DistributeDatasetEntries(input *DistributeDatasetEntriesInput) (*DistributeDatasetEntriesOutput, error) {
	req, out := c.DistributeDatasetEntriesRequest(input)
	return out, req.Send()
}

// DistributeDatasetEntriesWithContext is the same as DistributeDatasetEntries with the addition of
// the ability to pass a context and additional request options.
//
// See DistributeDatasetEntries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) DistributeDatasetEntriesWithContext(ctx aws.Context, input *DistributeDatasetEntriesInput, opts ...request.Option) (*DistributeDatasetEntriesOutput, error) {
	req, out := c.DistributeDatasetEntriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCelebrityInfo = "GetCelebrityInfo"

// GetCelebrityInfoRequest generates a "aws/request.Request" representing the
// client's request for the GetCelebrityInfo operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCelebrityInfo for more information on using the GetCelebrityInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCelebrityInfoRequest method.
//    req, resp := client.GetCelebrityInfoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) GetCelebrityInfoRequest(input *GetCelebrityInfoInput) (req *request.Request, output *GetCelebrityInfoOutput) {
	op := &request.Operation{
		Name:       opGetCelebrityInfo,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCelebrityInfoInput{}
	}

	output = &GetCelebrityInfoOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCelebrityInfo API operation for Amazon Rekognition.
//
// Gets the name and additional information about a celebrity based on their
// Amazon Rekognition ID. The additional information is returned as an array
// of URLs. If there is no additional information about the celebrity, this
// list is empty.
//
// For more information, see Getting information about a celebrity in the Amazon
// Rekognition Developer Guide.
//
// This operation requires permissions to perform the rekognition:GetCelebrityInfo
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation GetCelebrityInfo for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
func (c *Rekognition) GetCelebrityInfo(input *GetCelebrityInfoInput) (*GetCelebrityInfoOutput, error) {
	req, out := c.GetCelebrityInfoRequest(input)
	return out, req.Send()
}

// GetCelebrityInfoWithContext is the same as GetCelebrityInfo with the addition of
// the ability to pass a context and additional request options.
//
// See GetCelebrityInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetCelebrityInfoWithContext(ctx aws.Context, input *GetCelebrityInfoInput, opts ...request.Option) (*GetCelebrityInfoOutput, error) {
	req, out := c.GetCelebrityInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCelebrityRecognition = "GetCelebrityRecognition"

// GetCelebrityRecognitionRequest generates a "aws/request.Request" representing the
// client's request for the GetCelebrityRecognition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCelebrityRecognition for more information on using the GetCelebrityRecognition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCelebrityRecognitionRequest method.
//    req, resp := client.GetCelebrityRecognitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) GetCelebrityRecognitionRequest(input *GetCelebrityRecognitionInput) (req *request.Request, output *GetCelebrityRecognitionOutput) {
	op := &request.Operation{
		Name:       opGetCelebrityRecognition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCelebrityRecognitionInput{}
	}

	output = &GetCelebrityRecognitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCelebrityRecognition API operation for Amazon Rekognition.
//
// Gets the celebrity recognition results for a Amazon Rekognition Video analysis
// started by StartCelebrityRecognition.
//
// Celebrity recognition in a video is an asynchronous operation. Analysis is
// started by a call to StartCelebrityRecognition which returns a job identifier
// (JobId).
//
// When the celebrity recognition operation finishes, Amazon Rekognition Video
// publishes a completion status to the Amazon Simple Notification Service topic
// registered in the initial call to StartCelebrityRecognition. To get the results
// of the celebrity recognition analysis, first check that the status value
// published to the Amazon SNS topic is SUCCEEDED. If so, call GetCelebrityDetection
// and pass the job identifier (JobId) from the initial call to StartCelebrityDetection.
//
// For more information, see Working With Stored Videos in the Amazon Rekognition
// Developer Guide.
//
// GetCelebrityRecognition returns detected celebrities and the time(s) they
// are detected in an array (Celebrities) of CelebrityRecognition objects. Each
// CelebrityRecognition contains information about the celebrity in a CelebrityDetail
// object and the time, Timestamp, the celebrity was detected. This CelebrityDetail
// object stores information about the detected celebrity's face attributes,
// a face bounding box, known gender, the celebrity's name, and a confidence
// estimate.
//
// GetCelebrityRecognition only returns the default facial attributes (BoundingBox,
// Confidence, Landmarks, Pose, and Quality). The BoundingBox field only applies
// to the detected face instance. The other facial attributes listed in the
// Face object of the following response syntax are not returned. For more information,
// see FaceDetail in the Amazon Rekognition Developer Guide.
//
// By default, the Celebrities array is sorted by time (milliseconds from the
// start of the video). You can also sort the array by celebrity by specifying
// the value ID in the SortBy input parameter.
//
// The CelebrityDetail object includes the celebrity identifer and additional
// information urls. If you don't store the additional information urls, you
// can get them later by calling GetCelebrityInfo with the celebrity identifer.
//
// No information is returned for faces not recognized as celebrities.
//
// Use MaxResults parameter to limit the number of labels returned. If there
// are more results than specified in MaxResults, the value of NextToken in
// the operation response contains a pagination token for getting the next set
// of results. To get the next page of results, call GetCelebrityDetection and
// populate the NextToken request parameter with the token value returned from
// the previous call to GetCelebrityRecognition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation GetCelebrityRecognition for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) GetCelebrityRecognition(input *GetCelebrityRecognitionInput) (*GetCelebrityRecognitionOutput, error) {
	req, out := c.GetCelebrityRecognitionRequest(input)
	return out, req.Send()
}

// GetCelebrityRecognitionWithContext is the same as GetCelebrityRecognition with the addition of
// the ability to pass a context and additional request options.
//
// See GetCelebrityRecognition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetCelebrityRecognitionWithContext(ctx aws.Context, input *GetCelebrityRecognitionInput, opts ...request.Option) (*GetCelebrityRecognitionOutput, error) {
	req, out := c.GetCelebrityRecognitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCelebrityRecognitionPages iterates over the pages of a GetCelebrityRecognition operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCelebrityRecognition method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetCelebrityRecognition operation.
//    pageNum := 0
//    err := client.GetCelebrityRecognitionPages(params,
//        func(page *rekognition.GetCelebrityRecognitionOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) GetCelebrityRecognitionPages(input *GetCelebrityRecognitionInput, fn func(*GetCelebrityRecognitionOutput, bool) bool) error {
	return c.GetCelebrityRecognitionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCelebrityRecognitionPagesWithContext same as GetCelebrityRecognitionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetCelebrityRecognitionPagesWithContext(ctx aws.Context, input *GetCelebrityRecognitionInput, fn func(*GetCelebrityRecognitionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCelebrityRecognitionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCelebrityRecognitionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetCelebrityRecognitionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetContentModeration = "GetContentModeration"

// GetContentModerationRequest generates a "aws/request.Request" representing the
// client's request for the GetContentModeration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContentModeration for more information on using the GetContentModeration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetContentModerationRequest method.
//    req, resp := client.GetContentModerationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) GetContentModerationRequest(input *GetContentModerationInput) (req *request.Request, output *GetContentModerationOutput) {
	op := &request.Operation{
		Name:       opGetContentModeration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetContentModerationInput{}
	}

	output = &GetContentModerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContentModeration API operation for Amazon Rekognition.
//
// Gets the inappropriate, unwanted, or offensive content analysis results for
// a Amazon Rekognition Video analysis started by StartContentModeration. For
// a list of moderation labels in Amazon Rekognition, see Using the image and
// video moderation APIs (https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html#moderation-api).
//
// Amazon Rekognition Video inappropriate or offensive content detection in
// a stored video is an asynchronous operation. You start analysis by calling
// StartContentModeration which returns a job identifier (JobId). When analysis
// finishes, Amazon Rekognition Video publishes a completion status to the Amazon
// Simple Notification Service topic registered in the initial call to StartContentModeration.
// To get the results of the content analysis, first check that the status value
// published to the Amazon SNS topic is SUCCEEDED. If so, call GetContentModeration
// and pass the job identifier (JobId) from the initial call to StartContentModeration.
//
// For more information, see Working with Stored Videos in the Amazon Rekognition
// Devlopers Guide.
//
// GetContentModeration returns detected inappropriate, unwanted, or offensive
// content moderation labels, and the time they are detected, in an array, ModerationLabels,
// of ContentModerationDetection objects.
//
// By default, the moderated labels are returned sorted by time, in milliseconds
// from the start of the video. You can also sort them by moderated label by
// specifying NAME for the SortBy input parameter.
//
// Since video analysis can return a large number of results, use the MaxResults
// parameter to limit the number of labels returned in a single call to GetContentModeration.
// If there are more results than specified in MaxResults, the value of NextToken
// in the operation response contains a pagination token for getting the next
// set of results. To get the next page of results, call GetContentModeration
// and populate the NextToken request parameter with the value of NextToken
// returned from the previous call to GetContentModeration.
//
// For more information, see moderating content in the Amazon Rekognition Developer
// Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation GetContentModeration for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) GetContentModeration(input *GetContentModerationInput) (*GetContentModerationOutput, error) {
	req, out := c.GetContentModerationRequest(input)
	return out, req.Send()
}

// GetContentModerationWithContext is the same as GetContentModeration with the addition of
// the ability to pass a context and additional request options.
//
// See GetContentModeration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetContentModerationWithContext(ctx aws.Context, input *GetContentModerationInput, opts ...request.Option) (*GetContentModerationOutput, error) {
	req, out := c.GetContentModerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetContentModerationPages iterates over the pages of a GetContentModeration operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetContentModeration method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetContentModeration operation.
//    pageNum := 0
//    err := client.GetContentModerationPages(params,
//        func(page *rekognition.GetContentModerationOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) GetContentModerationPages(input *GetContentModerationInput, fn func(*GetContentModerationOutput, bool) bool) error {
	return c.GetContentModerationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetContentModerationPagesWithContext same as GetContentModerationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetContentModerationPagesWithContext(ctx aws.Context, input *GetContentModerationInput, fn func(*GetContentModerationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetContentModerationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetContentModerationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetContentModerationOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetFaceDetection = "GetFaceDetection"

// GetFaceDetectionRequest generates a "aws/request.Request" representing the
// client's request for the GetFaceDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFaceDetection for more information on using the GetFaceDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFaceDetectionRequest method.
//    req, resp := client.GetFaceDetectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) GetFaceDetectionRequest(input *GetFaceDetectionInput) (req *request.Request, output *GetFaceDetectionOutput) {
	op := &request.Operation{
		Name:       opGetFaceDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFaceDetectionInput{}
	}

	output = &GetFaceDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFaceDetection API operation for Amazon Rekognition.
//
// Gets face detection results for a Amazon Rekognition Video analysis started
// by StartFaceDetection.
//
// Face detection with Amazon Rekognition Video is an asynchronous operation.
// You start face detection by calling StartFaceDetection which returns a job
// identifier (JobId). When the face detection operation finishes, Amazon Rekognition
// Video publishes a completion status to the Amazon Simple Notification Service
// topic registered in the initial call to StartFaceDetection. To get the results
// of the face detection operation, first check that the status value published
// to the Amazon SNS topic is SUCCEEDED. If so, call GetFaceDetection and pass
// the job identifier (JobId) from the initial call to StartFaceDetection.
//
// GetFaceDetection returns an array of detected faces (Faces) sorted by the
// time the faces were detected.
//
// Use MaxResults parameter to limit the number of labels returned. If there
// are more results than specified in MaxResults, the value of NextToken in
// the operation response contains a pagination token for getting the next set
// of results. To get the next page of results, call GetFaceDetection and populate
// the NextToken request parameter with the token value returned from the previous
// call to GetFaceDetection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation GetFaceDetection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) GetFaceDetection(input *GetFaceDetectionInput) (*GetFaceDetectionOutput, error) {
	req, out := c.GetFaceDetectionRequest(input)
	return out, req.Send()
}

// GetFaceDetectionWithContext is the same as GetFaceDetection with the addition of
// the ability to pass a context and additional request options.
//
// See GetFaceDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetFaceDetectionWithContext(ctx aws.Context, input *GetFaceDetectionInput, opts ...request.Option) (*GetFaceDetectionOutput, error) {
	req, out := c.GetFaceDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetFaceDetectionPages iterates over the pages of a GetFaceDetection operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetFaceDetection method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetFaceDetection operation.
//    pageNum := 0
//    err := client.GetFaceDetectionPages(params,
//        func(page *rekognition.GetFaceDetectionOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) GetFaceDetectionPages(input *GetFaceDetectionInput, fn func(*GetFaceDetectionOutput, bool) bool) error {
	return c.GetFaceDetectionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetFaceDetectionPagesWithContext same as GetFaceDetectionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetFaceDetectionPagesWithContext(ctx aws.Context, input *GetFaceDetectionInput, fn func(*GetFaceDetectionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetFaceDetectionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFaceDetectionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetFaceDetectionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetFaceSearch = "GetFaceSearch"

// GetFaceSearchRequest generates a "aws/request.Request" representing the
// client's request for the GetFaceSearch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFaceSearch for more information on using the GetFaceSearch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFaceSearchRequest method.
//    req, resp := client.GetFaceSearchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) GetFaceSearchRequest(input *GetFaceSearchInput) (req *request.Request, output *GetFaceSearchOutput) {
	op := &request.Operation{
		Name:       opGetFaceSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFaceSearchInput{}
	}

	output = &GetFaceSearchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFaceSearch API operation for Amazon Rekognition.
//
// Gets the face search results for Amazon Rekognition Video face search started
// by StartFaceSearch. The search returns faces in a collection that match the
// faces of persons detected in a video. It also includes the time(s) that faces
// are matched in the video.
//
// Face search in a video is an asynchronous operation. You start face search
// by calling to StartFaceSearch which returns a job identifier (JobId). When
// the search operation finishes, Amazon Rekognition Video publishes a completion
// status to the Amazon Simple Notification Service topic registered in the
// initial call to StartFaceSearch. To get the search results, first check that
// the status value published to the Amazon SNS topic is SUCCEEDED. If so, call
// GetFaceSearch and pass the job identifier (JobId) from the initial call to
// StartFaceSearch.
//
// For more information, see Searching Faces in a Collection in the Amazon Rekognition
// Developer Guide.
//
// The search results are retured in an array, Persons, of PersonMatch objects.
// EachPersonMatch element contains details about the matching faces in the
// input collection, person information (facial attributes, bounding boxes,
// and person identifer) for the matched person, and the time the person was
// matched in the video.
//
// GetFaceSearch only returns the default facial attributes (BoundingBox, Confidence,
// Landmarks, Pose, and Quality). The other facial attributes listed in the
// Face object of the following response syntax are not returned. For more information,
// see FaceDetail in the Amazon Rekognition Developer Guide.
//
// By default, the Persons array is sorted by the time, in milliseconds from
// the start of the video, persons are matched. You can also sort by persons
// by specifying INDEX for the SORTBY input parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation GetFaceSearch for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) GetFaceSearch(input *GetFaceSearchInput) (*GetFaceSearchOutput, error) {
	req, out := c.GetFaceSearchRequest(input)
	return out, req.Send()
}

// GetFaceSearchWithContext is the same as GetFaceSearch with the addition of
// the ability to pass a context and additional request options.
//
// See GetFaceSearch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetFaceSearchWithContext(ctx aws.Context, input *GetFaceSearchInput, opts ...request.Option) (*GetFaceSearchOutput, error) {
	req, out := c.GetFaceSearchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetFaceSearchPages iterates over the pages of a GetFaceSearch operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetFaceSearch method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetFaceSearch operation.
//    pageNum := 0
//    err := client.GetFaceSearchPages(params,
//        func(page *rekognition.GetFaceSearchOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) GetFaceSearchPages(input *GetFaceSearchInput, fn func(*GetFaceSearchOutput, bool) bool) error {
	return c.GetFaceSearchPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetFaceSearchPagesWithContext same as GetFaceSearchPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetFaceSearchPagesWithContext(ctx aws.Context, input *GetFaceSearchInput, fn func(*GetFaceSearchOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetFaceSearchInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFaceSearchRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetFaceSearchOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetLabelDetection = "GetLabelDetection"

// GetLabelDetectionRequest generates a "aws/request.Request" representing the
// client's request for the GetLabelDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLabelDetection for more information on using the GetLabelDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLabelDetectionRequest method.
//    req, resp := client.GetLabelDetectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) GetLabelDetectionRequest(input *GetLabelDetectionInput) (req *request.Request, output *GetLabelDetectionOutput) {
	op := &request.Operation{
		Name:       opGetLabelDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetLabelDetectionInput{}
	}

	output = &GetLabelDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLabelDetection API operation for Amazon Rekognition.
//
// Gets the label detection results of a Amazon Rekognition Video analysis started
// by StartLabelDetection.
//
// The label detection operation is started by a call to StartLabelDetection
// which returns a job identifier (JobId). When the label detection operation
// finishes, Amazon Rekognition publishes a completion status to the Amazon
// Simple Notification Service topic registered in the initial call to StartlabelDetection.
// To get the results of the label detection operation, first check that the
// status value published to the Amazon SNS topic is SUCCEEDED. If so, call
// GetLabelDetection and pass the job identifier (JobId) from the initial call
// to StartLabelDetection.
//
// GetLabelDetection returns an array of detected labels (Labels) sorted by
// the time the labels were detected. You can also sort by the label name by
// specifying NAME for the SortBy input parameter.
//
// The labels returned include the label name, the percentage confidence in
// the accuracy of the detected label, and the time the label was detected in
// the video.
//
// The returned labels also include bounding box information for common objects,
// a hierarchical taxonomy of detected labels, and the version of the label
// model used for detection.
//
// Use MaxResults parameter to limit the number of labels returned. If there
// are more results than specified in MaxResults, the value of NextToken in
// the operation response contains a pagination token for getting the next set
// of results. To get the next page of results, call GetlabelDetection and populate
// the NextToken request parameter with the token value returned from the previous
// call to GetLabelDetection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation GetLabelDetection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) GetLabelDetection(input *GetLabelDetectionInput) (*GetLabelDetectionOutput, error) {
	req, out := c.GetLabelDetectionRequest(input)
	return out, req.Send()
}

// GetLabelDetectionWithContext is the same as GetLabelDetection with the addition of
// the ability to pass a context and additional request options.
//
// See GetLabelDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetLabelDetectionWithContext(ctx aws.Context, input *GetLabelDetectionInput, opts ...request.Option) (*GetLabelDetectionOutput, error) {
	req, out := c.GetLabelDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetLabelDetectionPages iterates over the pages of a GetLabelDetection operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetLabelDetection method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetLabelDetection operation.
//    pageNum := 0
//    err := client.GetLabelDetectionPages(params,
//        func(page *rekognition.GetLabelDetectionOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) GetLabelDetectionPages(input *GetLabelDetectionInput, fn func(*GetLabelDetectionOutput, bool) bool) error {
	return c.GetLabelDetectionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetLabelDetectionPagesWithContext same as GetLabelDetectionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetLabelDetectionPagesWithContext(ctx aws.Context, input *GetLabelDetectionInput, fn func(*GetLabelDetectionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetLabelDetectionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetLabelDetectionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetLabelDetectionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetPersonTracking = "GetPersonTracking"

// GetPersonTrackingRequest generates a "aws/request.Request" representing the
// client's request for the GetPersonTracking operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPersonTracking for more information on using the GetPersonTracking
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPersonTrackingRequest method.
//    req, resp := client.GetPersonTrackingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) GetPersonTrackingRequest(input *GetPersonTrackingInput) (req *request.Request, output *GetPersonTrackingOutput) {
	op := &request.Operation{
		Name:       opGetPersonTracking,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetPersonTrackingInput{}
	}

	output = &GetPersonTrackingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPersonTracking API operation for Amazon Rekognition.
//
// Gets the path tracking results of a Amazon Rekognition Video analysis started
// by StartPersonTracking.
//
// The person path tracking operation is started by a call to StartPersonTracking
// which returns a job identifier (JobId). When the operation finishes, Amazon
// Rekognition Video publishes a completion status to the Amazon Simple Notification
// Service topic registered in the initial call to StartPersonTracking.
//
// To get the results of the person path tracking operation, first check that
// the status value published to the Amazon SNS topic is SUCCEEDED. If so, call
// GetPersonTracking and pass the job identifier (JobId) from the initial call
// to StartPersonTracking.
//
// GetPersonTracking returns an array, Persons, of tracked persons and the time(s)
// their paths were tracked in the video.
//
// GetPersonTracking only returns the default facial attributes (BoundingBox,
// Confidence, Landmarks, Pose, and Quality). The other facial attributes listed
// in the Face object of the following response syntax are not returned.
//
// For more information, see FaceDetail in the Amazon Rekognition Developer
// Guide.
//
// By default, the array is sorted by the time(s) a person's path is tracked
// in the video. You can sort by tracked persons by specifying INDEX for the
// SortBy input parameter.
//
// Use the MaxResults parameter to limit the number of items returned. If there
// are more results than specified in MaxResults, the value of NextToken in
// the operation response contains a pagination token for getting the next set
// of results. To get the next page of results, call GetPersonTracking and populate
// the NextToken request parameter with the token value returned from the previous
// call to GetPersonTracking.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation GetPersonTracking for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) GetPersonTracking(input *GetPersonTrackingInput) (*GetPersonTrackingOutput, error) {
	req, out := c.GetPersonTrackingRequest(input)
	return out, req.Send()
}

// GetPersonTrackingWithContext is the same as GetPersonTracking with the addition of
// the ability to pass a context and additional request options.
//
// See GetPersonTracking for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetPersonTrackingWithContext(ctx aws.Context, input *GetPersonTrackingInput, opts ...request.Option) (*GetPersonTrackingOutput, error) {
	req, out := c.GetPersonTrackingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetPersonTrackingPages iterates over the pages of a GetPersonTracking operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetPersonTracking method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetPersonTracking operation.
//    pageNum := 0
//    err := client.GetPersonTrackingPages(params,
//        func(page *rekognition.GetPersonTrackingOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) GetPersonTrackingPages(input *GetPersonTrackingInput, fn func(*GetPersonTrackingOutput, bool) bool) error {
	return c.GetPersonTrackingPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetPersonTrackingPagesWithContext same as GetPersonTrackingPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetPersonTrackingPagesWithContext(ctx aws.Context, input *GetPersonTrackingInput, fn func(*GetPersonTrackingOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetPersonTrackingInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetPersonTrackingRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetPersonTrackingOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSegmentDetection = "GetSegmentDetection"

// GetSegmentDetectionRequest generates a "aws/request.Request" representing the
// client's request for the GetSegmentDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSegmentDetection for more information on using the GetSegmentDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSegmentDetectionRequest method.
//    req, resp := client.GetSegmentDetectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) GetSegmentDetectionRequest(input *GetSegmentDetectionInput) (req *request.Request, output *GetSegmentDetectionOutput) {
	op := &request.Operation{
		Name:       opGetSegmentDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSegmentDetectionInput{}
	}

	output = &GetSegmentDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSegmentDetection API operation for Amazon Rekognition.
//
// Gets the segment detection results of a Amazon Rekognition Video analysis
// started by StartSegmentDetection.
//
// Segment detection with Amazon Rekognition Video is an asynchronous operation.
// You start segment detection by calling StartSegmentDetection which returns
// a job identifier (JobId). When the segment detection operation finishes,
// Amazon Rekognition publishes a completion status to the Amazon Simple Notification
// Service topic registered in the initial call to StartSegmentDetection. To
// get the results of the segment detection operation, first check that the
// status value published to the Amazon SNS topic is SUCCEEDED. if so, call
// GetSegmentDetection and pass the job identifier (JobId) from the initial
// call of StartSegmentDetection.
//
// GetSegmentDetection returns detected segments in an array (Segments) of SegmentDetection
// objects. Segments is sorted by the segment types specified in the SegmentTypes
// input parameter of StartSegmentDetection. Each element of the array includes
// the detected segment, the precentage confidence in the acuracy of the detected
// segment, the type of the segment, and the frame in which the segment was
// detected.
//
// Use SelectedSegmentTypes to find out the type of segment detection requested
// in the call to StartSegmentDetection.
//
// Use the MaxResults parameter to limit the number of segment detections returned.
// If there are more results than specified in MaxResults, the value of NextToken
// in the operation response contains a pagination token for getting the next
// set of results. To get the next page of results, call GetSegmentDetection
// and populate the NextToken request parameter with the token value returned
// from the previous call to GetSegmentDetection.
//
// For more information, see Detecting video segments in stored video in the
// Amazon Rekognition Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation GetSegmentDetection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) GetSegmentDetection(input *GetSegmentDetectionInput) (*GetSegmentDetectionOutput, error) {
	req, out := c.GetSegmentDetectionRequest(input)
	return out, req.Send()
}

// GetSegmentDetectionWithContext is the same as GetSegmentDetection with the addition of
// the ability to pass a context and additional request options.
//
// See GetSegmentDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetSegmentDetectionWithContext(ctx aws.Context, input *GetSegmentDetectionInput, opts ...request.Option) (*GetSegmentDetectionOutput, error) {
	req, out := c.GetSegmentDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSegmentDetectionPages iterates over the pages of a GetSegmentDetection operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSegmentDetection method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetSegmentDetection operation.
//    pageNum := 0
//    err := client.GetSegmentDetectionPages(params,
//        func(page *rekognition.GetSegmentDetectionOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) GetSegmentDetectionPages(input *GetSegmentDetectionInput, fn func(*GetSegmentDetectionOutput, bool) bool) error {
	return c.GetSegmentDetectionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSegmentDetectionPagesWithContext same as GetSegmentDetectionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetSegmentDetectionPagesWithContext(ctx aws.Context, input *GetSegmentDetectionInput, fn func(*GetSegmentDetectionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSegmentDetectionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSegmentDetectionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetSegmentDetectionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTextDetection = "GetTextDetection"

// GetTextDetectionRequest generates a "aws/request.Request" representing the
// client's request for the GetTextDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTextDetection for more information on using the GetTextDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTextDetectionRequest method.
//    req, resp := client.GetTextDetectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) GetTextDetectionRequest(input *GetTextDetectionInput) (req *request.Request, output *GetTextDetectionOutput) {
	op := &request.Operation{
		Name:       opGetTextDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTextDetectionInput{}
	}

	output = &GetTextDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTextDetection API operation for Amazon Rekognition.
//
// Gets the text detection results of a Amazon Rekognition Video analysis started
// by StartTextDetection.
//
// Text detection with Amazon Rekognition Video is an asynchronous operation.
// You start text detection by calling StartTextDetection which returns a job
// identifier (JobId) When the text detection operation finishes, Amazon Rekognition
// publishes a completion status to the Amazon Simple Notification Service topic
// registered in the initial call to StartTextDetection. To get the results
// of the text detection operation, first check that the status value published
// to the Amazon SNS topic is SUCCEEDED. if so, call GetTextDetection and pass
// the job identifier (JobId) from the initial call of StartLabelDetection.
//
// GetTextDetection returns an array of detected text (TextDetections) sorted
// by the time the text was detected, up to 50 words per frame of video.
//
// Each element of the array includes the detected text, the precentage confidence
// in the acuracy of the detected text, the time the text was detected, bounding
// box information for where the text was located, and unique identifiers for
// words and their lines.
//
// Use MaxResults parameter to limit the number of text detections returned.
// If there are more results than specified in MaxResults, the value of NextToken
// in the operation response contains a pagination token for getting the next
// set of results. To get the next page of results, call GetTextDetection and
// populate the NextToken request parameter with the token value returned from
// the previous call to GetTextDetection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation GetTextDetection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) GetTextDetection(input *GetTextDetectionInput) (*GetTextDetectionOutput, error) {
	req, out := c.GetTextDetectionRequest(input)
	return out, req.Send()
}

// GetTextDetectionWithContext is the same as GetTextDetection with the addition of
// the ability to pass a context and additional request options.
//
// See GetTextDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetTextDetectionWithContext(ctx aws.Context, input *GetTextDetectionInput, opts ...request.Option) (*GetTextDetectionOutput, error) {
	req, out := c.GetTextDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTextDetectionPages iterates over the pages of a GetTextDetection operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTextDetection method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTextDetection operation.
//    pageNum := 0
//    err := client.GetTextDetectionPages(params,
//        func(page *rekognition.GetTextDetectionOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) GetTextDetectionPages(input *GetTextDetectionInput, fn func(*GetTextDetectionOutput, bool) bool) error {
	return c.GetTextDetectionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTextDetectionPagesWithContext same as GetTextDetectionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) GetTextDetectionPagesWithContext(ctx aws.Context, input *GetTextDetectionInput, fn func(*GetTextDetectionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTextDetectionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTextDetectionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTextDetectionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opIndexFaces = "IndexFaces"

// IndexFacesRequest generates a "aws/request.Request" representing the
// client's request for the IndexFaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IndexFaces for more information on using the IndexFaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the IndexFacesRequest method.
//    req, resp := client.IndexFacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) IndexFacesRequest(input *IndexFacesInput) (req *request.Request, output *IndexFacesOutput) {
	op := &request.Operation{
		Name:       opIndexFaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IndexFacesInput{}
	}

	output = &IndexFacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IndexFaces API operation for Amazon Rekognition.
//
// Detects faces in the input image and adds them to the specified collection.
//
// Amazon Rekognition doesn't save the actual faces that are detected. Instead,
// the underlying detection algorithm first detects the faces in the input image.
// For each face, the algorithm extracts facial features into a feature vector,
// and stores it in the backend database. Amazon Rekognition uses feature vectors
// when it performs face match and search operations using the SearchFaces and
// SearchFacesByImage operations.
//
// For more information, see Adding faces to a collection in the Amazon Rekognition
// Developer Guide.
//
// To get the number of faces in a collection, call DescribeCollection.
//
// If you're using version 1.0 of the face detection model, IndexFaces indexes
// the 15 largest faces in the input image. Later versions of the face detection
// model index the 100 largest faces in the input image.
//
// If you're using version 4 or later of the face model, image orientation information
// is not returned in the OrientationCorrection field.
//
// To determine which version of the model you're using, call DescribeCollection
// and supply the collection ID. You can also get the model version from the
// value of FaceModelVersion in the response from IndexFaces
//
// For more information, see Model Versioning in the Amazon Rekognition Developer
// Guide.
//
// If you provide the optional ExternalImageId for the input image you provided,
// Amazon Rekognition associates this ID with all faces that it detects. When
// you call the ListFaces operation, the response returns the external ID. You
// can use this external image ID to create a client-side index to associate
// the faces with each image. You can then use the index to find all faces in
// an image.
//
// You can specify the maximum number of faces to index with the MaxFaces input
// parameter. This is useful when you want to index the largest faces in an
// image and don't want to index smaller faces, such as those belonging to people
// standing in the background.
//
// The QualityFilter input parameter allows you to filter out detected faces
// that don’t meet a required quality bar. The quality bar is based on a variety
// of common use cases. By default, IndexFaces chooses the quality bar that's
// used to filter faces. You can also explicitly choose the quality bar. Use
// QualityFilter, to set the quality bar by specifying LOW, MEDIUM, or HIGH.
// If you do not want to filter detected faces, specify NONE.
//
// To use quality filtering, you need a collection associated with version 3
// of the face model or higher. To get the version of the face model associated
// with a collection, call DescribeCollection.
//
// Information about faces detected in an image, but not indexed, is returned
// in an array of UnindexedFace objects, UnindexedFaces. Faces aren't indexed
// for reasons such as:
//
//    * The number of faces detected exceeds the value of the MaxFaces request
//    parameter.
//
//    * The face is too small compared to the image dimensions.
//
//    * The face is too blurry.
//
//    * The image is too dark.
//
//    * The face has an extreme pose.
//
//    * The face doesn’t have enough detail to be suitable for face search.
//
// In response, the IndexFaces operation returns an array of metadata for all
// detected faces, FaceRecords. This includes:
//
//    * The bounding box, BoundingBox, of the detected face.
//
//    * A confidence value, Confidence, which indicates the confidence that
//    the bounding box contains a face.
//
//    * A face ID, FaceId, assigned by the service for each face that's detected
//    and stored.
//
//    * An image ID, ImageId, assigned by the service for the input image.
//
// If you request all facial attributes (by using the detectionAttributes parameter),
// Amazon Rekognition returns detailed facial attributes, such as facial landmarks
// (for example, location of eye and mouth) and other facial attributes. If
// you provide the same image, specify the same collection, and use the same
// external ID in the IndexFaces operation, Amazon Rekognition doesn't save
// duplicate face metadata.
//
// The input image is passed either as base64-encoded image bytes, or as a reference
// to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
// Rekognition operations, passing image bytes isn't supported. The image must
// be formatted as a PNG or JPEG file.
//
// This operation requires permissions to perform the rekognition:IndexFaces
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation IndexFaces for usage and error information.
//
// Returned Error Types:
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ImageTooLargeException
//   The input image size exceeds the allowed limit. If you are calling DetectProtectiveEquipment,
//   the image size or resolution exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * InvalidImageFormatException
//   The provided image format is not supported.
//
//   * ServiceQuotaExceededException
//   The size of the collection exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
func (c *Rekognition) IndexFaces(input *IndexFacesInput) (*IndexFacesOutput, error) {
	req, out := c.IndexFacesRequest(input)
	return out, req.Send()
}

// IndexFacesWithContext is the same as IndexFaces with the addition of
// the ability to pass a context and additional request options.
//
// See IndexFaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) IndexFacesWithContext(ctx aws.Context, input *IndexFacesInput, opts ...request.Option) (*IndexFacesOutput, error) {
	req, out := c.IndexFacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCollections = "ListCollections"

// ListCollectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListCollections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCollections for more information on using the ListCollections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCollectionsRequest method.
//    req, resp := client.ListCollectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) ListCollectionsRequest(input *ListCollectionsInput) (req *request.Request, output *ListCollectionsOutput) {
	op := &request.Operation{
		Name:       opListCollections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCollectionsInput{}
	}

	output = &ListCollectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCollections API operation for Amazon Rekognition.
//
// Returns list of collection IDs in your account. If the result is truncated,
// the response also provides a NextToken that you can use in the subsequent
// request to fetch the next set of collection IDs.
//
// For an example, see Listing collections in the Amazon Rekognition Developer
// Guide.
//
// This operation requires permissions to perform the rekognition:ListCollections
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation ListCollections for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
func (c *Rekognition) ListCollections(input *ListCollectionsInput) (*ListCollectionsOutput, error) {
	req, out := c.ListCollectionsRequest(input)
	return out, req.Send()
}

// ListCollectionsWithContext is the same as ListCollections with the addition of
// the ability to pass a context and additional request options.
//
// See ListCollections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) ListCollectionsWithContext(ctx aws.Context, input *ListCollectionsInput, opts ...request.Option) (*ListCollectionsOutput, error) {
	req, out := c.ListCollectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCollectionsPages iterates over the pages of a ListCollections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCollections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListCollections operation.
//    pageNum := 0
//    err := client.ListCollectionsPages(params,
//        func(page *rekognition.ListCollectionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) ListCollectionsPages(input *ListCollectionsInput, fn func(*ListCollectionsOutput, bool) bool) error {
	return c.ListCollectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCollectionsPagesWithContext same as ListCollectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) ListCollectionsPagesWithContext(ctx aws.Context, input *ListCollectionsInput, fn func(*ListCollectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCollectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCollectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCollectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatasetEntries = "ListDatasetEntries"

// ListDatasetEntriesRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasetEntries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasetEntries for more information on using the ListDatasetEntries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetEntriesRequest method.
//    req, resp := client.ListDatasetEntriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) ListDatasetEntriesRequest(input *ListDatasetEntriesInput) (req *request.Request, output *ListDatasetEntriesOutput) {
	op := &request.Operation{
		Name:       opListDatasetEntries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetEntriesInput{}
	}

	output = &ListDatasetEntriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasetEntries API operation for Amazon Rekognition.
//
// Lists the entries (images) within a dataset. An entry is a JSON Line that
// contains the information for a single image, including the image location,
// assigned labels, and object location bounding boxes. For more information,
// see Creating a manifest file (https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/md-manifest-files.html).
//
// JSON Lines in the response include information about non-terminal errors
// found in the dataset. Non terminal errors are reported in errors lists within
// each JSON Line. The same information is reported in the training and testing
// validation result manifests that Amazon Rekognition Custom Labels creates
// during model training.
//
// You can filter the response in variety of ways, such as choosing which labels
// to return and returning JSON Lines created after a specific date.
//
// This operation requires permissions to perform the rekognition:ListDatasetEntries
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation ListDatasetEntries for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ResourceNotReadyException
//   The requested resource isn't ready. For example, this exception occurs when
//   you call DetectCustomLabels with a model version that isn't deployed.
//
func (c *Rekognition) ListDatasetEntries(input *ListDatasetEntriesInput) (*ListDatasetEntriesOutput, error) {
	req, out := c.ListDatasetEntriesRequest(input)
	return out, req.Send()
}

// ListDatasetEntriesWithContext is the same as ListDatasetEntries with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasetEntries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) ListDatasetEntriesWithContext(ctx aws.Context, input *ListDatasetEntriesInput, opts ...request.Option) (*ListDatasetEntriesOutput, error) {
	req, out := c.ListDatasetEntriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetEntriesPages iterates over the pages of a ListDatasetEntries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasetEntries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasetEntries operation.
//    pageNum := 0
//    err := client.ListDatasetEntriesPages(params,
//        func(page *rekognition.ListDatasetEntriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) ListDatasetEntriesPages(input *ListDatasetEntriesInput, fn func(*ListDatasetEntriesOutput, bool) bool) error {
	return c.ListDatasetEntriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetEntriesPagesWithContext same as ListDatasetEntriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) ListDatasetEntriesPagesWithContext(ctx aws.Context, input *ListDatasetEntriesInput, fn func(*ListDatasetEntriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetEntriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetEntriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetEntriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDatasetLabels = "ListDatasetLabels"

// ListDatasetLabelsRequest generates a "aws/request.Request" representing the
// client's request for the ListDatasetLabels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDatasetLabels for more information on using the ListDatasetLabels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDatasetLabelsRequest method.
//    req, resp := client.ListDatasetLabelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) ListDatasetLabelsRequest(input *ListDatasetLabelsInput) (req *request.Request, output *ListDatasetLabelsOutput) {
	op := &request.Operation{
		Name:       opListDatasetLabels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDatasetLabelsInput{}
	}

	output = &ListDatasetLabelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDatasetLabels API operation for Amazon Rekognition.
//
// Lists the labels in a dataset. Amazon Rekognition Custom Labels uses labels
// to describe images. For more information, see Labeling images (https://docs.aws.amazon.com/rekognition/latest/customlabels-dg/md-labeling-images.html).
//
// Lists the labels in a dataset. Amazon Rekognition Custom Labels uses labels
// to describe images. For more information, see Labeling images in the Amazon
// Rekognition Custom Labels Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation ListDatasetLabels for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ResourceNotReadyException
//   The requested resource isn't ready. For example, this exception occurs when
//   you call DetectCustomLabels with a model version that isn't deployed.
//
func (c *Rekognition) ListDatasetLabels(input *ListDatasetLabelsInput) (*ListDatasetLabelsOutput, error) {
	req, out := c.ListDatasetLabelsRequest(input)
	return out, req.Send()
}

// ListDatasetLabelsWithContext is the same as ListDatasetLabels with the addition of
// the ability to pass a context and additional request options.
//
// See ListDatasetLabels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) ListDatasetLabelsWithContext(ctx aws.Context, input *ListDatasetLabelsInput, opts ...request.Option) (*ListDatasetLabelsOutput, error) {
	req, out := c.ListDatasetLabelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDatasetLabelsPages iterates over the pages of a ListDatasetLabels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDatasetLabels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDatasetLabels operation.
//    pageNum := 0
//    err := client.ListDatasetLabelsPages(params,
//        func(page *rekognition.ListDatasetLabelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) ListDatasetLabelsPages(input *ListDatasetLabelsInput, fn func(*ListDatasetLabelsOutput, bool) bool) error {
	return c.ListDatasetLabelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDatasetLabelsPagesWithContext same as ListDatasetLabelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) ListDatasetLabelsPagesWithContext(ctx aws.Context, input *ListDatasetLabelsInput, fn func(*ListDatasetLabelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDatasetLabelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDatasetLabelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDatasetLabelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFaces = "ListFaces"

// ListFacesRequest generates a "aws/request.Request" representing the
// client's request for the ListFaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFaces for more information on using the ListFaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFacesRequest method.
//    req, resp := client.ListFacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) ListFacesRequest(input *ListFacesInput) (req *request.Request, output *ListFacesOutput) {
	op := &request.Operation{
		Name:       opListFaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFacesInput{}
	}

	output = &ListFacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFaces API operation for Amazon Rekognition.
//
// Returns metadata for faces in the specified collection. This metadata includes
// information such as the bounding box coordinates, the confidence (that the
// bounding box contains a face), and face ID. For an example, see Listing Faces
// in a Collection in the Amazon Rekognition Developer Guide.
//
// This operation requires permissions to perform the rekognition:ListFaces
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation ListFaces for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
func (c *Rekognition) ListFaces(input *ListFacesInput) (*ListFacesOutput, error) {
	req, out := c.ListFacesRequest(input)
	return out, req.Send()
}

// ListFacesWithContext is the same as ListFaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListFaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) ListFacesWithContext(ctx aws.Context, input *ListFacesInput, opts ...request.Option) (*ListFacesOutput, error) {
	req, out := c.ListFacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFacesPages iterates over the pages of a ListFaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFaces operation.
//    pageNum := 0
//    err := client.ListFacesPages(params,
//        func(page *rekognition.ListFacesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) ListFacesPages(input *ListFacesInput, fn func(*ListFacesOutput, bool) bool) error {
	return c.ListFacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFacesPagesWithContext same as ListFacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) ListFacesPagesWithContext(ctx aws.Context, input *ListFacesInput, fn func(*ListFacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStreamProcessors = "ListStreamProcessors"

// ListStreamProcessorsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreamProcessors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreamProcessors for more information on using the ListStreamProcessors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStreamProcessorsRequest method.
//    req, resp := client.ListStreamProcessorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) ListStreamProcessorsRequest(input *ListStreamProcessorsInput) (req *request.Request, output *ListStreamProcessorsOutput) {
	op := &request.Operation{
		Name:       opListStreamProcessors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStreamProcessorsInput{}
	}

	output = &ListStreamProcessorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreamProcessors API operation for Amazon Rekognition.
//
// Gets a list of stream processors that you have created with CreateStreamProcessor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation ListStreamProcessors for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidPaginationTokenException
//   Pagination token in the request is not valid.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) ListStreamProcessors(input *ListStreamProcessorsInput) (*ListStreamProcessorsOutput, error) {
	req, out := c.ListStreamProcessorsRequest(input)
	return out, req.Send()
}

// ListStreamProcessorsWithContext is the same as ListStreamProcessors with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreamProcessors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) ListStreamProcessorsWithContext(ctx aws.Context, input *ListStreamProcessorsInput, opts ...request.Option) (*ListStreamProcessorsOutput, error) {
	req, out := c.ListStreamProcessorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStreamProcessorsPages iterates over the pages of a ListStreamProcessors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStreamProcessors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListStreamProcessors operation.
//    pageNum := 0
//    err := client.ListStreamProcessorsPages(params,
//        func(page *rekognition.ListStreamProcessorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Rekognition) ListStreamProcessorsPages(input *ListStreamProcessorsInput, fn func(*ListStreamProcessorsOutput, bool) bool) error {
	return c.ListStreamProcessorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStreamProcessorsPagesWithContext same as ListStreamProcessorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) ListStreamProcessorsPagesWithContext(ctx aws.Context, input *ListStreamProcessorsInput, fn func(*ListStreamProcessorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStreamProcessorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStreamProcessorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStreamProcessorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Rekognition.
//
// Returns a list of tags in an Amazon Rekognition collection, stream processor,
// or Custom Labels model.
//
// This operation requires permissions to perform the rekognition:ListTagsForResource
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRecognizeCelebrities = "RecognizeCelebrities"

// RecognizeCelebritiesRequest generates a "aws/request.Request" representing the
// client's request for the RecognizeCelebrities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RecognizeCelebrities for more information on using the RecognizeCelebrities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RecognizeCelebritiesRequest method.
//    req, resp := client.RecognizeCelebritiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) RecognizeCelebritiesRequest(input *RecognizeCelebritiesInput) (req *request.Request, output *RecognizeCelebritiesOutput) {
	op := &request.Operation{
		Name:       opRecognizeCelebrities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RecognizeCelebritiesInput{}
	}

	output = &RecognizeCelebritiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RecognizeCelebrities API operation for Amazon Rekognition.
//
// Returns an array of celebrities recognized in the input image. For more information,
// see Recognizing celebrities in the Amazon Rekognition Developer Guide.
//
// RecognizeCelebrities returns the 64 largest faces in the image. It lists
// the recognized celebrities in the CelebrityFaces array and any unrecognized
// faces in the UnrecognizedFaces array. RecognizeCelebrities doesn't return
// celebrities whose faces aren't among the largest 64 faces in the image.
//
// For each celebrity recognized, RecognizeCelebrities returns a Celebrity object.
// The Celebrity object contains the celebrity name, ID, URL links to additional
// information, match confidence, and a ComparedFace object that you can use
// to locate the celebrity's face on the image.
//
// Amazon Rekognition doesn't retain information about which images a celebrity
// has been recognized in. Your application must store this information and
// use the Celebrity ID property as a unique identifier for the celebrity. If
// you don't store the celebrity name or additional information URLs returned
// by RecognizeCelebrities, you will need the ID to identify the celebrity in
// a call to the GetCelebrityInfo operation.
//
// You pass the input image either as base64-encoded image bytes or as a reference
// to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
// Rekognition operations, passing image bytes is not supported. The image must
// be either a PNG or JPEG formatted file.
//
// For an example, see Recognizing celebrities in an image in the Amazon Rekognition
// Developer Guide.
//
// This operation requires permissions to perform the rekognition:RecognizeCelebrities
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation RecognizeCelebrities for usage and error information.
//
// Returned Error Types:
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidImageFormatException
//   The provided image format is not supported.
//
//   * ImageTooLargeException
//   The input image size exceeds the allowed limit. If you are calling DetectProtectiveEquipment,
//   the image size or resolution exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidImageFormatException
//   The provided image format is not supported.
//
func (c *Rekognition) RecognizeCelebrities(input *RecognizeCelebritiesInput) (*RecognizeCelebritiesOutput, error) {
	req, out := c.RecognizeCelebritiesRequest(input)
	return out, req.Send()
}

// RecognizeCelebritiesWithContext is the same as RecognizeCelebrities with the addition of
// the ability to pass a context and additional request options.
//
// See RecognizeCelebrities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) RecognizeCelebritiesWithContext(ctx aws.Context, input *RecognizeCelebritiesInput, opts ...request.Option) (*RecognizeCelebritiesOutput, error) {
	req, out := c.RecognizeCelebritiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchFaces = "SearchFaces"

// SearchFacesRequest generates a "aws/request.Request" representing the
// client's request for the SearchFaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchFaces for more information on using the SearchFaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchFacesRequest method.
//    req, resp := client.SearchFacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) SearchFacesRequest(input *SearchFacesInput) (req *request.Request, output *SearchFacesOutput) {
	op := &request.Operation{
		Name:       opSearchFaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SearchFacesInput{}
	}

	output = &SearchFacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchFaces API operation for Amazon Rekognition.
//
// For a given input face ID, searches for matching faces in the collection
// the face belongs to. You get a face ID when you add a face to the collection
// using the IndexFaces operation. The operation compares the features of the
// input face with faces in the specified collection.
//
// You can also search faces without indexing faces by using the SearchFacesByImage
// operation.
//
// The operation response returns an array of faces that match, ordered by similarity
// score with the highest similarity first. More specifically, it is an array
// of metadata for each face match that is found. Along with the metadata, the
// response also includes a confidence value for each face match, indicating
// the confidence that the specific face matches the input face.
//
// For an example, see Searching for a face using its face ID in the Amazon
// Rekognition Developer Guide.
//
// This operation requires permissions to perform the rekognition:SearchFaces
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation SearchFaces for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
func (c *Rekognition) SearchFaces(input *SearchFacesInput) (*SearchFacesOutput, error) {
	req, out := c.SearchFacesRequest(input)
	return out, req.Send()
}

// SearchFacesWithContext is the same as SearchFaces with the addition of
// the ability to pass a context and additional request options.
//
// See SearchFaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) SearchFacesWithContext(ctx aws.Context, input *SearchFacesInput, opts ...request.Option) (*SearchFacesOutput, error) {
	req, out := c.SearchFacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchFacesByImage = "SearchFacesByImage"

// SearchFacesByImageRequest generates a "aws/request.Request" representing the
// client's request for the SearchFacesByImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchFacesByImage for more information on using the SearchFacesByImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchFacesByImageRequest method.
//    req, resp := client.SearchFacesByImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) SearchFacesByImageRequest(input *SearchFacesByImageInput) (req *request.Request, output *SearchFacesByImageOutput) {
	op := &request.Operation{
		Name:       opSearchFacesByImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SearchFacesByImageInput{}
	}

	output = &SearchFacesByImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchFacesByImage API operation for Amazon Rekognition.
//
// For a given input image, first detects the largest face in the image, and
// then searches the specified collection for matching faces. The operation
// compares the features of the input face with faces in the specified collection.
//
// To search for all faces in an input image, you might first call the IndexFaces
// operation, and then use the face IDs returned in subsequent calls to the
// SearchFaces operation.
//
// You can also call the DetectFaces operation and use the bounding boxes in
// the response to make face crops, which then you can pass in to the SearchFacesByImage
// operation.
//
// You pass the input image either as base64-encoded image bytes or as a reference
// to an image in an Amazon S3 bucket. If you use the AWS CLI to call Amazon
// Rekognition operations, passing image bytes is not supported. The image must
// be either a PNG or JPEG formatted file.
//
// The response returns an array of faces that match, ordered by similarity
// score with the highest similarity first. More specifically, it is an array
// of metadata for each face match found. Along with the metadata, the response
// also includes a similarity indicating how similar the face is to the input
// face. In the response, the operation also returns the bounding box (and a
// confidence level that the bounding box contains a face) of the face that
// Amazon Rekognition used for the input image.
//
// If no faces are detected in the input image, SearchFacesByImage returns an
// InvalidParameterException error.
//
// For an example, Searching for a Face Using an Image in the Amazon Rekognition
// Developer Guide.
//
// The QualityFilter input parameter allows you to filter out detected faces
// that don’t meet a required quality bar. The quality bar is based on a variety
// of common use cases. Use QualityFilter to set the quality bar for filtering
// by specifying LOW, MEDIUM, or HIGH. If you do not want to filter detected
// faces, specify NONE. The default value is NONE.
//
// To use quality filtering, you need a collection associated with version 3
// of the face model or higher. To get the version of the face model associated
// with a collection, call DescribeCollection.
//
// This operation requires permissions to perform the rekognition:SearchFacesByImage
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation SearchFacesByImage for usage and error information.
//
// Returned Error Types:
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ImageTooLargeException
//   The input image size exceeds the allowed limit. If you are calling DetectProtectiveEquipment,
//   the image size or resolution exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * InvalidImageFormatException
//   The provided image format is not supported.
//
func (c *Rekognition) SearchFacesByImage(input *SearchFacesByImageInput) (*SearchFacesByImageOutput, error) {
	req, out := c.SearchFacesByImageRequest(input)
	return out, req.Send()
}

// SearchFacesByImageWithContext is the same as SearchFacesByImage with the addition of
// the ability to pass a context and additional request options.
//
// See SearchFacesByImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) SearchFacesByImageWithContext(ctx aws.Context, input *SearchFacesByImageInput, opts ...request.Option) (*SearchFacesByImageOutput, error) {
	req, out := c.SearchFacesByImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartCelebrityRecognition = "StartCelebrityRecognition"

// StartCelebrityRecognitionRequest generates a "aws/request.Request" representing the
// client's request for the StartCelebrityRecognition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCelebrityRecognition for more information on using the StartCelebrityRecognition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartCelebrityRecognitionRequest method.
//    req, resp := client.StartCelebrityRecognitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StartCelebrityRecognitionRequest(input *StartCelebrityRecognitionInput) (req *request.Request, output *StartCelebrityRecognitionOutput) {
	op := &request.Operation{
		Name:       opStartCelebrityRecognition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartCelebrityRecognitionInput{}
	}

	output = &StartCelebrityRecognitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartCelebrityRecognition API operation for Amazon Rekognition.
//
// Starts asynchronous recognition of celebrities in a stored video.
//
// Amazon Rekognition Video can detect celebrities in a video must be stored
// in an Amazon S3 bucket. Use Video to specify the bucket name and the filename
// of the video. StartCelebrityRecognition returns a job identifier (JobId)
// which you use to get the results of the analysis. When celebrity recognition
// analysis is finished, Amazon Rekognition Video publishes a completion status
// to the Amazon Simple Notification Service topic that you specify in NotificationChannel.
// To get the results of the celebrity recognition analysis, first check that
// the status value published to the Amazon SNS topic is SUCCEEDED. If so, call
// GetCelebrityRecognition and pass the job identifier (JobId) from the initial
// call to StartCelebrityRecognition.
//
// For more information, see Recognizing celebrities in the Amazon Rekognition
// Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StartCelebrityRecognition for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * IdempotentParameterMismatchException
//   A ClientRequestToken input parameter was reused with an operation, but at
//   least one of the other input parameters is different from the previous call
//   to the operation.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * VideoTooLargeException
//   The file size or duration of the supplied media is too large. The maximum
//   file size is 10GB. The maximum duration is 6 hours.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) StartCelebrityRecognition(input *StartCelebrityRecognitionInput) (*StartCelebrityRecognitionOutput, error) {
	req, out := c.StartCelebrityRecognitionRequest(input)
	return out, req.Send()
}

// StartCelebrityRecognitionWithContext is the same as StartCelebrityRecognition with the addition of
// the ability to pass a context and additional request options.
//
// See StartCelebrityRecognition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StartCelebrityRecognitionWithContext(ctx aws.Context, input *StartCelebrityRecognitionInput, opts ...request.Option) (*StartCelebrityRecognitionOutput, error) {
	req, out := c.StartCelebrityRecognitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartContentModeration = "StartContentModeration"

// StartContentModerationRequest generates a "aws/request.Request" representing the
// client's request for the StartContentModeration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartContentModeration for more information on using the StartContentModeration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartContentModerationRequest method.
//    req, resp := client.StartContentModerationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StartContentModerationRequest(input *StartContentModerationInput) (req *request.Request, output *StartContentModerationOutput) {
	op := &request.Operation{
		Name:       opStartContentModeration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartContentModerationInput{}
	}

	output = &StartContentModerationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartContentModeration API operation for Amazon Rekognition.
//
// Starts asynchronous detection of inappropriate, unwanted, or offensive content
// in a stored video. For a list of moderation labels in Amazon Rekognition,
// see Using the image and video moderation APIs (https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html#moderation-api).
//
// Amazon Rekognition Video can moderate content in a video stored in an Amazon
// S3 bucket. Use Video to specify the bucket name and the filename of the video.
// StartContentModeration returns a job identifier (JobId) which you use to
// get the results of the analysis. When content analysis is finished, Amazon
// Rekognition Video publishes a completion status to the Amazon Simple Notification
// Service topic that you specify in NotificationChannel.
//
// To get the results of the content analysis, first check that the status value
// published to the Amazon SNS topic is SUCCEEDED. If so, call GetContentModeration
// and pass the job identifier (JobId) from the initial call to StartContentModeration.
//
// For more information, see Moderating content in the Amazon Rekognition Developer
// Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StartContentModeration for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * IdempotentParameterMismatchException
//   A ClientRequestToken input parameter was reused with an operation, but at
//   least one of the other input parameters is different from the previous call
//   to the operation.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * VideoTooLargeException
//   The file size or duration of the supplied media is too large. The maximum
//   file size is 10GB. The maximum duration is 6 hours.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) StartContentModeration(input *StartContentModerationInput) (*StartContentModerationOutput, error) {
	req, out := c.StartContentModerationRequest(input)
	return out, req.Send()
}

// StartContentModerationWithContext is the same as StartContentModeration with the addition of
// the ability to pass a context and additional request options.
//
// See StartContentModeration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StartContentModerationWithContext(ctx aws.Context, input *StartContentModerationInput, opts ...request.Option) (*StartContentModerationOutput, error) {
	req, out := c.StartContentModerationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFaceDetection = "StartFaceDetection"

// StartFaceDetectionRequest generates a "aws/request.Request" representing the
// client's request for the StartFaceDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFaceDetection for more information on using the StartFaceDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartFaceDetectionRequest method.
//    req, resp := client.StartFaceDetectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StartFaceDetectionRequest(input *StartFaceDetectionInput) (req *request.Request, output *StartFaceDetectionOutput) {
	op := &request.Operation{
		Name:       opStartFaceDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFaceDetectionInput{}
	}

	output = &StartFaceDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFaceDetection API operation for Amazon Rekognition.
//
// Starts asynchronous detection of faces in a stored video.
//
// Amazon Rekognition Video can detect faces in a video stored in an Amazon
// S3 bucket. Use Video to specify the bucket name and the filename of the video.
// StartFaceDetection returns a job identifier (JobId) that you use to get the
// results of the operation. When face detection is finished, Amazon Rekognition
// Video publishes a completion status to the Amazon Simple Notification Service
// topic that you specify in NotificationChannel. To get the results of the
// face detection operation, first check that the status value published to
// the Amazon SNS topic is SUCCEEDED. If so, call GetFaceDetection and pass
// the job identifier (JobId) from the initial call to StartFaceDetection.
//
// For more information, see Detecting faces in a stored video in the Amazon
// Rekognition Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StartFaceDetection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * IdempotentParameterMismatchException
//   A ClientRequestToken input parameter was reused with an operation, but at
//   least one of the other input parameters is different from the previous call
//   to the operation.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * VideoTooLargeException
//   The file size or duration of the supplied media is too large. The maximum
//   file size is 10GB. The maximum duration is 6 hours.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) StartFaceDetection(input *StartFaceDetectionInput) (*StartFaceDetectionOutput, error) {
	req, out := c.StartFaceDetectionRequest(input)
	return out, req.Send()
}

// StartFaceDetectionWithContext is the same as StartFaceDetection with the addition of
// the ability to pass a context and additional request options.
//
// See StartFaceDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StartFaceDetectionWithContext(ctx aws.Context, input *StartFaceDetectionInput, opts ...request.Option) (*StartFaceDetectionOutput, error) {
	req, out := c.StartFaceDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFaceSearch = "StartFaceSearch"

// StartFaceSearchRequest generates a "aws/request.Request" representing the
// client's request for the StartFaceSearch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFaceSearch for more information on using the StartFaceSearch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartFaceSearchRequest method.
//    req, resp := client.StartFaceSearchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StartFaceSearchRequest(input *StartFaceSearchInput) (req *request.Request, output *StartFaceSearchOutput) {
	op := &request.Operation{
		Name:       opStartFaceSearch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartFaceSearchInput{}
	}

	output = &StartFaceSearchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFaceSearch API operation for Amazon Rekognition.
//
// Starts the asynchronous search for faces in a collection that match the faces
// of persons detected in a stored video.
//
// The video must be stored in an Amazon S3 bucket. Use Video to specify the
// bucket name and the filename of the video. StartFaceSearch returns a job
// identifier (JobId) which you use to get the search results once the search
// has completed. When searching is finished, Amazon Rekognition Video publishes
// a completion status to the Amazon Simple Notification Service topic that
// you specify in NotificationChannel. To get the search results, first check
// that the status value published to the Amazon SNS topic is SUCCEEDED. If
// so, call GetFaceSearch and pass the job identifier (JobId) from the initial
// call to StartFaceSearch. For more information, see Searching stored videos
// for faces (https://docs.aws.amazon.com/rekognition/latest/dg/procedure-person-search-videos.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StartFaceSearch for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * IdempotentParameterMismatchException
//   A ClientRequestToken input parameter was reused with an operation, but at
//   least one of the other input parameters is different from the previous call
//   to the operation.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * VideoTooLargeException
//   The file size or duration of the supplied media is too large. The maximum
//   file size is 10GB. The maximum duration is 6 hours.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) StartFaceSearch(input *StartFaceSearchInput) (*StartFaceSearchOutput, error) {
	req, out := c.StartFaceSearchRequest(input)
	return out, req.Send()
}

// StartFaceSearchWithContext is the same as StartFaceSearch with the addition of
// the ability to pass a context and additional request options.
//
// See StartFaceSearch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StartFaceSearchWithContext(ctx aws.Context, input *StartFaceSearchInput, opts ...request.Option) (*StartFaceSearchOutput, error) {
	req, out := c.StartFaceSearchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartLabelDetection = "StartLabelDetection"

// StartLabelDetectionRequest generates a "aws/request.Request" representing the
// client's request for the StartLabelDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartLabelDetection for more information on using the StartLabelDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartLabelDetectionRequest method.
//    req, resp := client.StartLabelDetectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StartLabelDetectionRequest(input *StartLabelDetectionInput) (req *request.Request, output *StartLabelDetectionOutput) {
	op := &request.Operation{
		Name:       opStartLabelDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartLabelDetectionInput{}
	}

	output = &StartLabelDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartLabelDetection API operation for Amazon Rekognition.
//
// Starts asynchronous detection of labels in a stored video.
//
// Amazon Rekognition Video can detect labels in a video. Labels are instances
// of real-world entities. This includes objects like flower, tree, and table;
// events like wedding, graduation, and birthday party; concepts like landscape,
// evening, and nature; and activities like a person getting out of a car or
// a person skiing.
//
// The video must be stored in an Amazon S3 bucket. Use Video to specify the
// bucket name and the filename of the video. StartLabelDetection returns a
// job identifier (JobId) which you use to get the results of the operation.
// When label detection is finished, Amazon Rekognition Video publishes a completion
// status to the Amazon Simple Notification Service topic that you specify in
// NotificationChannel.
//
// To get the results of the label detection operation, first check that the
// status value published to the Amazon SNS topic is SUCCEEDED. If so, call
// GetLabelDetection and pass the job identifier (JobId) from the initial call
// to StartLabelDetection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StartLabelDetection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * IdempotentParameterMismatchException
//   A ClientRequestToken input parameter was reused with an operation, but at
//   least one of the other input parameters is different from the previous call
//   to the operation.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * VideoTooLargeException
//   The file size or duration of the supplied media is too large. The maximum
//   file size is 10GB. The maximum duration is 6 hours.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) StartLabelDetection(input *StartLabelDetectionInput) (*StartLabelDetectionOutput, error) {
	req, out := c.StartLabelDetectionRequest(input)
	return out, req.Send()
}

// StartLabelDetectionWithContext is the same as StartLabelDetection with the addition of
// the ability to pass a context and additional request options.
//
// See StartLabelDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StartLabelDetectionWithContext(ctx aws.Context, input *StartLabelDetectionInput, opts ...request.Option) (*StartLabelDetectionOutput, error) {
	req, out := c.StartLabelDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPersonTracking = "StartPersonTracking"

// StartPersonTrackingRequest generates a "aws/request.Request" representing the
// client's request for the StartPersonTracking operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPersonTracking for more information on using the StartPersonTracking
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartPersonTrackingRequest method.
//    req, resp := client.StartPersonTrackingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StartPersonTrackingRequest(input *StartPersonTrackingInput) (req *request.Request, output *StartPersonTrackingOutput) {
	op := &request.Operation{
		Name:       opStartPersonTracking,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartPersonTrackingInput{}
	}

	output = &StartPersonTrackingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPersonTracking API operation for Amazon Rekognition.
//
// Starts the asynchronous tracking of a person's path in a stored video.
//
// Amazon Rekognition Video can track the path of people in a video stored in
// an Amazon S3 bucket. Use Video to specify the bucket name and the filename
// of the video. StartPersonTracking returns a job identifier (JobId) which
// you use to get the results of the operation. When label detection is finished,
// Amazon Rekognition publishes a completion status to the Amazon Simple Notification
// Service topic that you specify in NotificationChannel.
//
// To get the results of the person detection operation, first check that the
// status value published to the Amazon SNS topic is SUCCEEDED. If so, call
// GetPersonTracking and pass the job identifier (JobId) from the initial call
// to StartPersonTracking.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StartPersonTracking for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * IdempotentParameterMismatchException
//   A ClientRequestToken input parameter was reused with an operation, but at
//   least one of the other input parameters is different from the previous call
//   to the operation.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * VideoTooLargeException
//   The file size or duration of the supplied media is too large. The maximum
//   file size is 10GB. The maximum duration is 6 hours.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) StartPersonTracking(input *StartPersonTrackingInput) (*StartPersonTrackingOutput, error) {
	req, out := c.StartPersonTrackingRequest(input)
	return out, req.Send()
}

// StartPersonTrackingWithContext is the same as StartPersonTracking with the addition of
// the ability to pass a context and additional request options.
//
// See StartPersonTracking for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StartPersonTrackingWithContext(ctx aws.Context, input *StartPersonTrackingInput, opts ...request.Option) (*StartPersonTrackingOutput, error) {
	req, out := c.StartPersonTrackingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartProjectVersion = "StartProjectVersion"

// StartProjectVersionRequest generates a "aws/request.Request" representing the
// client's request for the StartProjectVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartProjectVersion for more information on using the StartProjectVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartProjectVersionRequest method.
//    req, resp := client.StartProjectVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StartProjectVersionRequest(input *StartProjectVersionInput) (req *request.Request, output *StartProjectVersionOutput) {
	op := &request.Operation{
		Name:       opStartProjectVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartProjectVersionInput{}
	}

	output = &StartProjectVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartProjectVersion API operation for Amazon Rekognition.
//
// Starts the running of the version of a model. Starting a model takes a while
// to complete. To check the current state of the model, use DescribeProjectVersions.
//
// Once the model is running, you can detect custom labels in new images by
// calling DetectCustomLabels.
//
// You are charged for the amount of time that the model is running. To stop
// a running model, call StopProjectVersion.
//
// This operation requires permissions to perform the rekognition:StartProjectVersion
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StartProjectVersion for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) StartProjectVersion(input *StartProjectVersionInput) (*StartProjectVersionOutput, error) {
	req, out := c.StartProjectVersionRequest(input)
	return out, req.Send()
}

// StartProjectVersionWithContext is the same as StartProjectVersion with the addition of
// the ability to pass a context and additional request options.
//
// See StartProjectVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StartProjectVersionWithContext(ctx aws.Context, input *StartProjectVersionInput, opts ...request.Option) (*StartProjectVersionOutput, error) {
	req, out := c.StartProjectVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSegmentDetection = "StartSegmentDetection"

// StartSegmentDetectionRequest generates a "aws/request.Request" representing the
// client's request for the StartSegmentDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSegmentDetection for more information on using the StartSegmentDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSegmentDetectionRequest method.
//    req, resp := client.StartSegmentDetectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StartSegmentDetectionRequest(input *StartSegmentDetectionInput) (req *request.Request, output *StartSegmentDetectionOutput) {
	op := &request.Operation{
		Name:       opStartSegmentDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSegmentDetectionInput{}
	}

	output = &StartSegmentDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSegmentDetection API operation for Amazon Rekognition.
//
// Starts asynchronous detection of segment detection in a stored video.
//
// Amazon Rekognition Video can detect segments in a video stored in an Amazon
// S3 bucket. Use Video to specify the bucket name and the filename of the video.
// StartSegmentDetection returns a job identifier (JobId) which you use to get
// the results of the operation. When segment detection is finished, Amazon
// Rekognition Video publishes a completion status to the Amazon Simple Notification
// Service topic that you specify in NotificationChannel.
//
// You can use the Filters (StartSegmentDetectionFilters) input parameter to
// specify the minimum detection confidence returned in the response. Within
// Filters, use ShotFilter (StartShotDetectionFilter) to filter detected shots.
// Use TechnicalCueFilter (StartTechnicalCueDetectionFilter) to filter technical
// cues.
//
// To get the results of the segment detection operation, first check that the
// status value published to the Amazon SNS topic is SUCCEEDED. if so, call
// GetSegmentDetection and pass the job identifier (JobId) from the initial
// call to StartSegmentDetection.
//
// For more information, see Detecting video segments in stored video in the
// Amazon Rekognition Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StartSegmentDetection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * IdempotentParameterMismatchException
//   A ClientRequestToken input parameter was reused with an operation, but at
//   least one of the other input parameters is different from the previous call
//   to the operation.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * VideoTooLargeException
//   The file size or duration of the supplied media is too large. The maximum
//   file size is 10GB. The maximum duration is 6 hours.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) StartSegmentDetection(input *StartSegmentDetectionInput) (*StartSegmentDetectionOutput, error) {
	req, out := c.StartSegmentDetectionRequest(input)
	return out, req.Send()
}

// StartSegmentDetectionWithContext is the same as StartSegmentDetection with the addition of
// the ability to pass a context and additional request options.
//
// See StartSegmentDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StartSegmentDetectionWithContext(ctx aws.Context, input *StartSegmentDetectionInput, opts ...request.Option) (*StartSegmentDetectionOutput, error) {
	req, out := c.StartSegmentDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartStreamProcessor = "StartStreamProcessor"

// StartStreamProcessorRequest generates a "aws/request.Request" representing the
// client's request for the StartStreamProcessor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartStreamProcessor for more information on using the StartStreamProcessor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartStreamProcessorRequest method.
//    req, resp := client.StartStreamProcessorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StartStreamProcessorRequest(input *StartStreamProcessorInput) (req *request.Request, output *StartStreamProcessorOutput) {
	op := &request.Operation{
		Name:       opStartStreamProcessor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartStreamProcessorInput{}
	}

	output = &StartStreamProcessorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartStreamProcessor API operation for Amazon Rekognition.
//
// Starts processing a stream processor. You create a stream processor by calling
// CreateStreamProcessor. To tell StartStreamProcessor which stream processor
// to start, use the value of the Name field specified in the call to CreateStreamProcessor.
//
// If you are using a label detection stream processor to detect labels, you
// need to provide a Start selector and a Stop selector to determine the length
// of the stream processing time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StartStreamProcessor for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) StartStreamProcessor(input *StartStreamProcessorInput) (*StartStreamProcessorOutput, error) {
	req, out := c.StartStreamProcessorRequest(input)
	return out, req.Send()
}

// StartStreamProcessorWithContext is the same as StartStreamProcessor with the addition of
// the ability to pass a context and additional request options.
//
// See StartStreamProcessor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StartStreamProcessorWithContext(ctx aws.Context, input *StartStreamProcessorInput, opts ...request.Option) (*StartStreamProcessorOutput, error) {
	req, out := c.StartStreamProcessorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTextDetection = "StartTextDetection"

// StartTextDetectionRequest generates a "aws/request.Request" representing the
// client's request for the StartTextDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTextDetection for more information on using the StartTextDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTextDetectionRequest method.
//    req, resp := client.StartTextDetectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StartTextDetectionRequest(input *StartTextDetectionInput) (req *request.Request, output *StartTextDetectionOutput) {
	op := &request.Operation{
		Name:       opStartTextDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTextDetectionInput{}
	}

	output = &StartTextDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTextDetection API operation for Amazon Rekognition.
//
// Starts asynchronous detection of text in a stored video.
//
// Amazon Rekognition Video can detect text in a video stored in an Amazon S3
// bucket. Use Video to specify the bucket name and the filename of the video.
// StartTextDetection returns a job identifier (JobId) which you use to get
// the results of the operation. When text detection is finished, Amazon Rekognition
// Video publishes a completion status to the Amazon Simple Notification Service
// topic that you specify in NotificationChannel.
//
// To get the results of the text detection operation, first check that the
// status value published to the Amazon SNS topic is SUCCEEDED. if so, call
// GetTextDetection and pass the job identifier (JobId) from the initial call
// to StartTextDetection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StartTextDetection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * IdempotentParameterMismatchException
//   A ClientRequestToken input parameter was reused with an operation, but at
//   least one of the other input parameters is different from the previous call
//   to the operation.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * InvalidS3ObjectException
//   Amazon Rekognition is unable to access the S3 object specified in the request.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * VideoTooLargeException
//   The file size or duration of the supplied media is too large. The maximum
//   file size is 10GB. The maximum duration is 6 hours.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
func (c *Rekognition) StartTextDetection(input *StartTextDetectionInput) (*StartTextDetectionOutput, error) {
	req, out := c.StartTextDetectionRequest(input)
	return out, req.Send()
}

// StartTextDetectionWithContext is the same as StartTextDetection with the addition of
// the ability to pass a context and additional request options.
//
// See StartTextDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StartTextDetectionWithContext(ctx aws.Context, input *StartTextDetectionInput, opts ...request.Option) (*StartTextDetectionOutput, error) {
	req, out := c.StartTextDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopProjectVersion = "StopProjectVersion"

// StopProjectVersionRequest generates a "aws/request.Request" representing the
// client's request for the StopProjectVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopProjectVersion for more information on using the StopProjectVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopProjectVersionRequest method.
//    req, resp := client.StopProjectVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StopProjectVersionRequest(input *StopProjectVersionInput) (req *request.Request, output *StopProjectVersionOutput) {
	op := &request.Operation{
		Name:       opStopProjectVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopProjectVersionInput{}
	}

	output = &StopProjectVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopProjectVersion API operation for Amazon Rekognition.
//
// Stops a running model. The operation might take a while to complete. To check
// the current status, call DescribeProjectVersions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StopProjectVersion for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) StopProjectVersion(input *StopProjectVersionInput) (*StopProjectVersionOutput, error) {
	req, out := c.StopProjectVersionRequest(input)
	return out, req.Send()
}

// StopProjectVersionWithContext is the same as StopProjectVersion with the addition of
// the ability to pass a context and additional request options.
//
// See StopProjectVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StopProjectVersionWithContext(ctx aws.Context, input *StopProjectVersionInput, opts ...request.Option) (*StopProjectVersionOutput, error) {
	req, out := c.StopProjectVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopStreamProcessor = "StopStreamProcessor"

// StopStreamProcessorRequest generates a "aws/request.Request" representing the
// client's request for the StopStreamProcessor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopStreamProcessor for more information on using the StopStreamProcessor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopStreamProcessorRequest method.
//    req, resp := client.StopStreamProcessorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) StopStreamProcessorRequest(input *StopStreamProcessorInput) (req *request.Request, output *StopStreamProcessorOutput) {
	op := &request.Operation{
		Name:       opStopStreamProcessor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopStreamProcessorInput{}
	}

	output = &StopStreamProcessorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopStreamProcessor API operation for Amazon Rekognition.
//
// Stops a running stream processor that was created by CreateStreamProcessor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation StopStreamProcessor for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) StopStreamProcessor(input *StopStreamProcessorInput) (*StopStreamProcessorOutput, error) {
	req, out := c.StopStreamProcessorRequest(input)
	return out, req.Send()
}

// StopStreamProcessorWithContext is the same as StopStreamProcessor with the addition of
// the ability to pass a context and additional request options.
//
// See StopStreamProcessor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) StopStreamProcessorWithContext(ctx aws.Context, input *StopStreamProcessorInput, opts ...request.Option) (*StopStreamProcessorOutput, error) {
	req, out := c.StopStreamProcessorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Rekognition.
//
// Adds one or more key-value tags to an Amazon Rekognition collection, stream
// processor, or Custom Labels model. For more information, see Tagging AWS
// Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
//
// This operation requires permissions to perform the rekognition:TagResource
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ServiceQuotaExceededException
//   The size of the collection exceeds the allowed limit. For more information,
//   see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
//   Developer Guide.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Rekognition.
//
// Removes one or more tags from an Amazon Rekognition collection, stream processor,
// or Custom Labels model.
//
// This operation requires permissions to perform the rekognition:UntagResource
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDatasetEntries = "UpdateDatasetEntries"

// UpdateDatasetEntriesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatasetEntries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatasetEntries for more information on using the UpdateDatasetEntries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDatasetEntriesRequest method.
//    req, resp := client.UpdateDatasetEntriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) UpdateDatasetEntriesRequest(input *UpdateDatasetEntriesInput) (req *request.Request, output *UpdateDatasetEntriesOutput) {
	op := &request.Operation{
		Name:       opUpdateDatasetEntries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDatasetEntriesInput{}
	}

	output = &UpdateDatasetEntriesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDatasetEntries API operation for Amazon Rekognition.
//
// Adds or updates one or more entries (images) in a dataset. An entry is a
// JSON Line which contains the information for a single image, including the
// image location, assigned labels, and object location bounding boxes. For
// more information, see Image-Level labels in manifest files and Object localization
// in manifest files in the Amazon Rekognition Custom Labels Developer Guide.
//
// If the source-ref field in the JSON line references an existing image, the
// existing image in the dataset is updated. If source-ref field doesn't reference
// an existing image, the image is added as a new image to the dataset.
//
// You specify the changes that you want to make in the Changes input parameter.
// There isn't a limit to the number JSON Lines that you can change, but the
// size of Changes must be less than 5MB.
//
// UpdateDatasetEntries returns immediatly, but the dataset update might take
// a while to complete. Use DescribeDataset to check the current status. The
// dataset updated successfully if the value of Status is UPDATE_COMPLETE.
//
// To check if any non-terminal errors occured, call ListDatasetEntries and
// check for the presence of errors lists in the JSON Lines.
//
// Dataset update fails if a terminal error occurs (Status = UPDATE_FAILED).
// Currently, you can't access the terminal error information from the Amazon
// Rekognition Custom Labels SDK.
//
// This operation requires permissions to perform the rekognition:UpdateDatasetEntries
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation UpdateDatasetEntries for usage and error information.
//
// Returned Error Types:
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * LimitExceededException
//   An Amazon Rekognition service limit was exceeded. For example, if you start
//   too many Amazon Rekognition Video jobs concurrently, calls to start operations
//   (StartLabelDetection, for example) will raise a LimitExceededException exception
//   (HTTP status code: 400) until the number of concurrently running jobs is
//   below the Amazon Rekognition service limit.
//
//   * ResourceInUseException
//   The specified resource is already being used.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
func (c *Rekognition) UpdateDatasetEntries(input *UpdateDatasetEntriesInput) (*UpdateDatasetEntriesOutput, error) {
	req, out := c.UpdateDatasetEntriesRequest(input)
	return out, req.Send()
}

// UpdateDatasetEntriesWithContext is the same as UpdateDatasetEntries with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatasetEntries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) UpdateDatasetEntriesWithContext(ctx aws.Context, input *UpdateDatasetEntriesInput, opts ...request.Option) (*UpdateDatasetEntriesOutput, error) {
	req, out := c.UpdateDatasetEntriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStreamProcessor = "UpdateStreamProcessor"

// UpdateStreamProcessorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStreamProcessor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStreamProcessor for more information on using the UpdateStreamProcessor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStreamProcessorRequest method.
//    req, resp := client.UpdateStreamProcessorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Rekognition) UpdateStreamProcessorRequest(input *UpdateStreamProcessorInput) (req *request.Request, output *UpdateStreamProcessorOutput) {
	op := &request.Operation{
		Name:       opUpdateStreamProcessor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStreamProcessorInput{}
	}

	output = &UpdateStreamProcessorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateStreamProcessor API operation for Amazon Rekognition.
//
// Allows you to update a stream processor. You can change some settings and
// regions of interest and delete certain parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Rekognition's
// API operation UpdateStreamProcessor for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You are not authorized to perform the action.
//
//   * InternalServerError
//   Amazon Rekognition experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   Amazon Rekognition is temporarily unable to process the request. Try your
//   call again.
//
//   * InvalidParameterException
//   Input parameter violated a constraint. Validate your parameter before calling
//   the API operation again.
//
//   * ResourceNotFoundException
//   The resource specified in the request cannot be found.
//
//   * ProvisionedThroughputExceededException
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Rekognition.
//
func (c *Rekognition) UpdateStreamProcessor(input *UpdateStreamProcessorInput) (*UpdateStreamProcessorOutput, error) {
	req, out := c.UpdateStreamProcessorRequest(input)
	return out, req.Send()
}

// UpdateStreamProcessorWithContext is the same as UpdateStreamProcessor with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStreamProcessor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Rekognition) UpdateStreamProcessorWithContext(ctx aws.Context, input *UpdateStreamProcessorInput, opts ...request.Option) (*UpdateStreamProcessorOutput, error) {
	req, out := c.UpdateStreamProcessorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You are not authorized to perform the action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Structure containing the estimated age range, in years, for a face.
//
// Amazon Rekognition estimates an age range for faces detected in the input
// image. Estimated age ranges can overlap. A face of a 5-year-old might have
// an estimated range of 4-6, while the face of a 6-year-old might have an estimated
// range of 4-8.
type AgeRange struct {
	_ struct{} `type:"structure"`

	// The highest estimated age.
	High *int64 `type:"integer"`

	// The lowest estimated age.
	Low *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgeRange) GoString() string {
	return s.String()
}

// SetHigh sets the High field's value.
func (s *AgeRange) SetHigh(v int64) *AgeRange {
	s.High = &v
	return s
}

// SetLow sets the Low field's value.
func (s *AgeRange) SetLow(v int64) *AgeRange {
	s.Low = &v
	return s
}

// Assets are the images that you use to train and evaluate a model version.
// Assets can also contain validation information that you use to debug a failed
// model training.
type Asset struct {
	_ struct{} `type:"structure"`

	// The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest
	// file.
	GroundTruthManifest *GroundTruthManifest `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Asset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Asset) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Asset) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Asset"}
	if s.GroundTruthManifest != nil {
		if err := s.GroundTruthManifest.Validate(); err != nil {
			invalidParams.AddNested("GroundTruthManifest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroundTruthManifest sets the GroundTruthManifest field's value.
func (s *Asset) SetGroundTruthManifest(v *GroundTruthManifest) *Asset {
	s.GroundTruthManifest = v
	return s
}

// Metadata information about an audio stream. An array of AudioMetadata objects
// for the audio streams found in a stored video is returned by GetSegmentDetection.
type AudioMetadata struct {
	_ struct{} `type:"structure"`

	// The audio codec used to encode or decode the audio stream.
	Codec *string `type:"string"`

	// The duration of the audio stream in milliseconds.
	DurationMillis *int64 `type:"long"`

	// The number of audio channels in the segment.
	NumberOfChannels *int64 `type:"long"`

	// The sample rate for the audio stream.
	SampleRate *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioMetadata) GoString() string {
	return s.String()
}

// SetCodec sets the Codec field's value.
func (s *AudioMetadata) SetCodec(v string) *AudioMetadata {
	s.Codec = &v
	return s
}

// SetDurationMillis sets the DurationMillis field's value.
func (s *AudioMetadata) SetDurationMillis(v int64) *AudioMetadata {
	s.DurationMillis = &v
	return s
}

// SetNumberOfChannels sets the NumberOfChannels field's value.
func (s *AudioMetadata) SetNumberOfChannels(v int64) *AudioMetadata {
	s.NumberOfChannels = &v
	return s
}

// SetSampleRate sets the SampleRate field's value.
func (s *AudioMetadata) SetSampleRate(v int64) *AudioMetadata {
	s.SampleRate = &v
	return s
}

// Indicates whether or not the face has a beard, and the confidence level in
// the determination.
type Beard struct {
	_ struct{} `type:"structure"`

	// Level of confidence in the determination.
	Confidence *float64 `type:"float"`

	// Boolean value that indicates whether the face has beard or not.
	Value *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Beard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Beard) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *Beard) SetConfidence(v float64) *Beard {
	s.Confidence = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Beard) SetValue(v bool) *Beard {
	s.Value = &v
	return s
}

// A filter that allows you to control the black frame detection by specifying
// the black levels and pixel coverage of black pixels in a frame. As videos
// can come from multiple sources, formats, and time periods, they may contain
// different standards and varying noise levels for black frames that need to
// be accounted for. For more information, see StartSegmentDetection.
type BlackFrame struct {
	_ struct{} `type:"structure"`

	// A threshold used to determine the maximum luminance value for a pixel to
	// be considered black. In a full color range video, luminance values range
	// from 0-255. A pixel value of 0 is pure black, and the most strict filter.
	// The maximum black pixel value is computed as follows: max_black_pixel_value
	// = minimum_luminance + MaxPixelThreshold *luminance_range.
	//
	// For example, for a full range video with BlackPixelThreshold = 0.1, max_black_pixel_value
	// is 0 + 0.1 * (255-0) = 25.5.
	//
	// The default value of MaxPixelThreshold is 0.2, which maps to a max_black_pixel_value
	// of 51 for a full range video. You can lower this threshold to be more strict
	// on black levels.
	MaxPixelThreshold *float64 `type:"float"`

	// The minimum percentage of pixels in a frame that need to have a luminance
	// below the max_black_pixel_value for a frame to be considered a black frame.
	// Luminance is calculated using the BT.709 matrix.
	//
	// The default value is 99, which means at least 99% of all pixels in the frame
	// are black pixels as per the MaxPixelThreshold set. You can reduce this value
	// to allow more noise on the black frame.
	MinCoveragePercentage *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlackFrame) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlackFrame) GoString() string {
	return s.String()
}

// SetMaxPixelThreshold sets the MaxPixelThreshold field's value.
func (s *BlackFrame) SetMaxPixelThreshold(v float64) *BlackFrame {
	s.MaxPixelThreshold = &v
	return s
}

// SetMinCoveragePercentage sets the MinCoveragePercentage field's value.
func (s *BlackFrame) SetMinCoveragePercentage(v float64) *BlackFrame {
	s.MinCoveragePercentage = &v
	return s
}

// Identifies the bounding box around the label, face, text, object of interest,
// or personal protective equipment. The left (x-coordinate) and top (y-coordinate)
// are coordinates representing the top and left sides of the bounding box.
// Note that the upper-left corner of the image is the origin (0,0).
//
// The top and left values returned are ratios of the overall image size. For
// example, if the input image is 700x200 pixels, and the top-left coordinate
// of the bounding box is 350x50 pixels, the API returns a left value of 0.5
// (350/700) and a top value of 0.25 (50/200).
//
// The width and height values represent the dimensions of the bounding box
// as a ratio of the overall image dimension. For example, if the input image
// is 700x200 pixels, and the bounding box width is 70 pixels, the width returned
// is 0.1.
//
// The bounding box coordinates can have negative values. For example, if Amazon
// Rekognition is able to detect a face that is at the image edge and is only
// partially visible, the service can return coordinates that are outside the
// image bounds and, depending on the image edge, you might get negative values
// or values greater than 1 for the left or top values.
type BoundingBox struct {
	_ struct{} `type:"structure"`

	// Height of the bounding box as a ratio of the overall image height.
	Height *float64 `type:"float"`

	// Left coordinate of the bounding box as a ratio of overall image width.
	Left *float64 `type:"float"`

	// Top coordinate of the bounding box as a ratio of overall image height.
	Top *float64 `type:"float"`

	// Width of the bounding box as a ratio of the overall image width.
	Width *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoundingBox) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoundingBox) GoString() string {
	return s.String()
}

// SetHeight sets the Height field's value.
func (s *BoundingBox) SetHeight(v float64) *BoundingBox {
	s.Height = &v
	return s
}

// SetLeft sets the Left field's value.
func (s *BoundingBox) SetLeft(v float64) *BoundingBox {
	s.Left = &v
	return s
}

// SetTop sets the Top field's value.
func (s *BoundingBox) SetTop(v float64) *BoundingBox {
	s.Top = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *BoundingBox) SetWidth(v float64) *BoundingBox {
	s.Width = &v
	return s
}

// Provides information about a celebrity recognized by the RecognizeCelebrities
// operation.
type Celebrity struct {
	_ struct{} `type:"structure"`

	// Provides information about the celebrity's face, such as its location on
	// the image.
	Face *ComparedFace `type:"structure"`

	// A unique identifier for the celebrity.
	Id *string `type:"string"`

	// The known gender identity for the celebrity that matches the provided ID.
	// The known gender identity can be Male, Female, Nonbinary, or Unlisted.
	KnownGender *KnownGender `type:"structure"`

	// The confidence, in percentage, that Amazon Rekognition has that the recognized
	// face is the celebrity.
	MatchConfidence *float64 `type:"float"`

	// The name of the celebrity.
	Name *string `type:"string"`

	// An array of URLs pointing to additional information about the celebrity.
	// If there is no additional information about the celebrity, this list is empty.
	Urls []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Celebrity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Celebrity) GoString() string {
	return s.String()
}

// SetFace sets the Face field's value.
func (s *Celebrity) SetFace(v *ComparedFace) *Celebrity {
	s.Face = v
	return s
}

// SetId sets the Id field's value.
func (s *Celebrity) SetId(v string) *Celebrity {
	s.Id = &v
	return s
}

// SetKnownGender sets the KnownGender field's value.
func (s *Celebrity) SetKnownGender(v *KnownGender) *Celebrity {
	s.KnownGender = v
	return s
}

// SetMatchConfidence sets the MatchConfidence field's value.
func (s *Celebrity) SetMatchConfidence(v float64) *Celebrity {
	s.MatchConfidence = &v
	return s
}

// SetName sets the Name field's value.
func (s *Celebrity) SetName(v string) *Celebrity {
	s.Name = &v
	return s
}

// SetUrls sets the Urls field's value.
func (s *Celebrity) SetUrls(v []*string) *Celebrity {
	s.Urls = v
	return s
}

// Information about a recognized celebrity.
type CelebrityDetail struct {
	_ struct{} `type:"structure"`

	// Bounding box around the body of a celebrity.
	BoundingBox *BoundingBox `type:"structure"`

	// The confidence, in percentage, that Amazon Rekognition has that the recognized
	// face is the celebrity.
	Confidence *float64 `type:"float"`

	// Face details for the recognized celebrity.
	Face *FaceDetail `type:"structure"`

	// The unique identifier for the celebrity.
	Id *string `type:"string"`

	// Retrieves the known gender for the celebrity.
	KnownGender *KnownGender `type:"structure"`

	// The name of the celebrity.
	Name *string `type:"string"`

	// An array of URLs pointing to additional celebrity information.
	Urls []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CelebrityDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CelebrityDetail) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *CelebrityDetail) SetBoundingBox(v *BoundingBox) *CelebrityDetail {
	s.BoundingBox = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *CelebrityDetail) SetConfidence(v float64) *CelebrityDetail {
	s.Confidence = &v
	return s
}

// SetFace sets the Face field's value.
func (s *CelebrityDetail) SetFace(v *FaceDetail) *CelebrityDetail {
	s.Face = v
	return s
}

// SetId sets the Id field's value.
func (s *CelebrityDetail) SetId(v string) *CelebrityDetail {
	s.Id = &v
	return s
}

// SetKnownGender sets the KnownGender field's value.
func (s *CelebrityDetail) SetKnownGender(v *KnownGender) *CelebrityDetail {
	s.KnownGender = v
	return s
}

// SetName sets the Name field's value.
func (s *CelebrityDetail) SetName(v string) *CelebrityDetail {
	s.Name = &v
	return s
}

// SetUrls sets the Urls field's value.
func (s *CelebrityDetail) SetUrls(v []*string) *CelebrityDetail {
	s.Urls = v
	return s
}

// Information about a detected celebrity and the time the celebrity was detected
// in a stored video. For more information, see GetCelebrityRecognition in the
// Amazon Rekognition Developer Guide.
type CelebrityRecognition struct {
	_ struct{} `type:"structure"`

	// Information about a recognized celebrity.
	Celebrity *CelebrityDetail `type:"structure"`

	// The time, in milliseconds from the start of the video, that the celebrity
	// was recognized.
	Timestamp *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CelebrityRecognition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CelebrityRecognition) GoString() string {
	return s.String()
}

// SetCelebrity sets the Celebrity field's value.
func (s *CelebrityRecognition) SetCelebrity(v *CelebrityDetail) *CelebrityRecognition {
	s.Celebrity = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *CelebrityRecognition) SetTimestamp(v int64) *CelebrityRecognition {
	s.Timestamp = &v
	return s
}

type CompareFacesInput struct {
	_ struct{} `type:"structure"`

	// A filter that specifies a quality bar for how much filtering is done to identify
	// faces. Filtered faces aren't compared. If you specify AUTO, Amazon Rekognition
	// chooses the quality bar. If you specify LOW, MEDIUM, or HIGH, filtering removes
	// all faces that don’t meet the chosen quality bar. The quality bar is based
	// on a variety of common use cases. Low-quality detections can occur for a
	// number of reasons. Some examples are an object that's misidentified as a
	// face, a face that's too blurry, or a face with a pose that's too extreme
	// to use. If you specify NONE, no filtering is performed. The default value
	// is NONE.
	//
	// To use quality filtering, the collection you are using must be associated
	// with version 3 of the face model or higher.
	QualityFilter *string `type:"string" enum:"QualityFilter"`

	// The minimum level of confidence in the face matches that a match must meet
	// to be included in the FaceMatches array.
	SimilarityThreshold *float64 `type:"float"`

	// The input image as base64-encoded bytes or an S3 object. If you use the AWS
	// CLI to call Amazon Rekognition operations, passing base64-encoded image bytes
	// is not supported.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// SourceImage is a required field
	SourceImage *Image `type:"structure" required:"true"`

	// The target image as base64-encoded bytes or an S3 object. If you use the
	// AWS CLI to call Amazon Rekognition operations, passing base64-encoded image
	// bytes is not supported.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// TargetImage is a required field
	TargetImage *Image `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareFacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareFacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompareFacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompareFacesInput"}
	if s.SourceImage == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceImage"))
	}
	if s.TargetImage == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetImage"))
	}
	if s.SourceImage != nil {
		if err := s.SourceImage.Validate(); err != nil {
			invalidParams.AddNested("SourceImage", err.(request.ErrInvalidParams))
		}
	}
	if s.TargetImage != nil {
		if err := s.TargetImage.Validate(); err != nil {
			invalidParams.AddNested("TargetImage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQualityFilter sets the QualityFilter field's value.
func (s *CompareFacesInput) SetQualityFilter(v string) *CompareFacesInput {
	s.QualityFilter = &v
	return s
}

// SetSimilarityThreshold sets the SimilarityThreshold field's value.
func (s *CompareFacesInput) SetSimilarityThreshold(v float64) *CompareFacesInput {
	s.SimilarityThreshold = &v
	return s
}

// SetSourceImage sets the SourceImage field's value.
func (s *CompareFacesInput) SetSourceImage(v *Image) *CompareFacesInput {
	s.SourceImage = v
	return s
}

// SetTargetImage sets the TargetImage field's value.
func (s *CompareFacesInput) SetTargetImage(v *Image) *CompareFacesInput {
	s.TargetImage = v
	return s
}

// Provides information about a face in a target image that matches the source
// image face analyzed by CompareFaces. The Face property contains the bounding
// box of the face in the target image. The Similarity property is the confidence
// that the source image face matches the face in the bounding box.
type CompareFacesMatch struct {
	_ struct{} `type:"structure"`

	// Provides face metadata (bounding box and confidence that the bounding box
	// actually contains a face).
	Face *ComparedFace `type:"structure"`

	// Level of confidence that the faces match.
	Similarity *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareFacesMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareFacesMatch) GoString() string {
	return s.String()
}

// SetFace sets the Face field's value.
func (s *CompareFacesMatch) SetFace(v *ComparedFace) *CompareFacesMatch {
	s.Face = v
	return s
}

// SetSimilarity sets the Similarity field's value.
func (s *CompareFacesMatch) SetSimilarity(v float64) *CompareFacesMatch {
	s.Similarity = &v
	return s
}

type CompareFacesOutput struct {
	_ struct{} `type:"structure"`

	// An array of faces in the target image that match the source image face. Each
	// CompareFacesMatch object provides the bounding box, the confidence level
	// that the bounding box contains a face, and the similarity score for the face
	// in the bounding box and the face in the source image.
	FaceMatches []*CompareFacesMatch `type:"list"`

	// The face in the source image that was used for comparison.
	SourceImageFace *ComparedSourceImageFace `type:"structure"`

	// The value of SourceImageOrientationCorrection is always null.
	//
	// If the input image is in .jpeg format, it might contain exchangeable image
	// file format (Exif) metadata that includes the image's orientation. Amazon
	// Rekognition uses this orientation information to perform image correction.
	// The bounding box coordinates are translated to represent object locations
	// after the orientation information in the Exif metadata is used to correct
	// the image orientation. Images in .png format don't contain Exif metadata.
	//
	// Amazon Rekognition doesn’t perform image correction for images in .png
	// format and .jpeg images without orientation information in the image Exif
	// metadata. The bounding box coordinates aren't translated and represent the
	// object locations before the image is rotated.
	SourceImageOrientationCorrection *string `type:"string" enum:"OrientationCorrection"`

	// The value of TargetImageOrientationCorrection is always null.
	//
	// If the input image is in .jpeg format, it might contain exchangeable image
	// file format (Exif) metadata that includes the image's orientation. Amazon
	// Rekognition uses this orientation information to perform image correction.
	// The bounding box coordinates are translated to represent object locations
	// after the orientation information in the Exif metadata is used to correct
	// the image orientation. Images in .png format don't contain Exif metadata.
	//
	// Amazon Rekognition doesn’t perform image correction for images in .png
	// format and .jpeg images without orientation information in the image Exif
	// metadata. The bounding box coordinates aren't translated and represent the
	// object locations before the image is rotated.
	TargetImageOrientationCorrection *string `type:"string" enum:"OrientationCorrection"`

	// An array of faces in the target image that did not match the source image
	// face.
	UnmatchedFaces []*ComparedFace `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareFacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompareFacesOutput) GoString() string {
	return s.String()
}

// SetFaceMatches sets the FaceMatches field's value.
func (s *CompareFacesOutput) SetFaceMatches(v []*CompareFacesMatch) *CompareFacesOutput {
	s.FaceMatches = v
	return s
}

// SetSourceImageFace sets the SourceImageFace field's value.
func (s *CompareFacesOutput) SetSourceImageFace(v *ComparedSourceImageFace) *CompareFacesOutput {
	s.SourceImageFace = v
	return s
}

// SetSourceImageOrientationCorrection sets the SourceImageOrientationCorrection field's value.
func (s *CompareFacesOutput) SetSourceImageOrientationCorrection(v string) *CompareFacesOutput {
	s.SourceImageOrientationCorrection = &v
	return s
}

// SetTargetImageOrientationCorrection sets the TargetImageOrientationCorrection field's value.
func (s *CompareFacesOutput) SetTargetImageOrientationCorrection(v string) *CompareFacesOutput {
	s.TargetImageOrientationCorrection = &v
	return s
}

// SetUnmatchedFaces sets the UnmatchedFaces field's value.
func (s *CompareFacesOutput) SetUnmatchedFaces(v []*ComparedFace) *CompareFacesOutput {
	s.UnmatchedFaces = v
	return s
}

// Provides face metadata for target image faces that are analyzed by CompareFaces
// and RecognizeCelebrities.
type ComparedFace struct {
	_ struct{} `type:"structure"`

	// Bounding box of the face.
	BoundingBox *BoundingBox `type:"structure"`

	// Level of confidence that what the bounding box contains is a face.
	Confidence *float64 `type:"float"`

	// The emotions that appear to be expressed on the face, and the confidence
	// level in the determination. Valid values include "Happy", "Sad", "Angry",
	// "Confused", "Disgusted", "Surprised", "Calm", "Unknown", and "Fear".
	Emotions []*Emotion `type:"list"`

	// An array of facial landmarks.
	Landmarks []*Landmark `type:"list"`

	// Indicates the pose of the face as determined by its pitch, roll, and yaw.
	Pose *Pose `type:"structure"`

	// Identifies face image brightness and sharpness.
	Quality *ImageQuality `type:"structure"`

	// Indicates whether or not the face is smiling, and the confidence level in
	// the determination.
	Smile *Smile `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComparedFace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComparedFace) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *ComparedFace) SetBoundingBox(v *BoundingBox) *ComparedFace {
	s.BoundingBox = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *ComparedFace) SetConfidence(v float64) *ComparedFace {
	s.Confidence = &v
	return s
}

// SetEmotions sets the Emotions field's value.
func (s *ComparedFace) SetEmotions(v []*Emotion) *ComparedFace {
	s.Emotions = v
	return s
}

// SetLandmarks sets the Landmarks field's value.
func (s *ComparedFace) SetLandmarks(v []*Landmark) *ComparedFace {
	s.Landmarks = v
	return s
}

// SetPose sets the Pose field's value.
func (s *ComparedFace) SetPose(v *Pose) *ComparedFace {
	s.Pose = v
	return s
}

// SetQuality sets the Quality field's value.
func (s *ComparedFace) SetQuality(v *ImageQuality) *ComparedFace {
	s.Quality = v
	return s
}

// SetSmile sets the Smile field's value.
func (s *ComparedFace) SetSmile(v *Smile) *ComparedFace {
	s.Smile = v
	return s
}

// Type that describes the face Amazon Rekognition chose to compare with the
// faces in the target. This contains a bounding box for the selected face and
// confidence level that the bounding box contains a face. Note that Amazon
// Rekognition selects the largest face in the source image for this comparison.
type ComparedSourceImageFace struct {
	_ struct{} `type:"structure"`

	// Bounding box of the face.
	BoundingBox *BoundingBox `type:"structure"`

	// Confidence level that the selected bounding box contains a face.
	Confidence *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComparedSourceImageFace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComparedSourceImageFace) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *ComparedSourceImageFace) SetBoundingBox(v *BoundingBox) *ComparedSourceImageFace {
	s.BoundingBox = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *ComparedSourceImageFace) SetConfidence(v float64) *ComparedSourceImageFace {
	s.Confidence = &v
	return s
}

// Label detection settings to use on a streaming video. Defining the settings
// is required in the request parameter for CreateStreamProcessor. Including
// this setting in the CreateStreamProcessor request enables you to use the
// stream processor for label detection. You can then select what you want the
// stream processor to detect, such as people or pets. When the stream processor
// has started, one notification is sent for each object class specified. For
// example, if packages and pets are selected, one SNS notification is published
// the first time a package is detected and one SNS notification is published
// the first time a pet is detected, as well as an end-of-session summary.
type ConnectedHomeSettings struct {
	_ struct{} `type:"structure"`

	// Specifies what you want to detect in the video, such as people, packages,
	// or pets. The current valid labels you can include in this list are: "PERSON",
	// "PET", "PACKAGE", and "ALL".
	//
	// Labels is a required field
	Labels []*string `min:"1" type:"list" required:"true"`

	// The minimum confidence required to label an object in the video.
	MinConfidence *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectedHomeSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectedHomeSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectedHomeSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectedHomeSettings"}
	if s.Labels == nil {
		invalidParams.Add(request.NewErrParamRequired("Labels"))
	}
	if s.Labels != nil && len(s.Labels) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Labels", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabels sets the Labels field's value.
func (s *ConnectedHomeSettings) SetLabels(v []*string) *ConnectedHomeSettings {
	s.Labels = v
	return s
}

// SetMinConfidence sets the MinConfidence field's value.
func (s *ConnectedHomeSettings) SetMinConfidence(v float64) *ConnectedHomeSettings {
	s.MinConfidence = &v
	return s
}

// The label detection settings you want to use in your stream processor. This
// includes the labels you want the stream processor to detect and the minimum
// confidence level allowed to label objects.
type ConnectedHomeSettingsForUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies what you want to detect in the video, such as people, packages,
	// or pets. The current valid labels you can include in this list are: "PERSON",
	// "PET", "PACKAGE", and "ALL".
	Labels []*string `min:"1" type:"list"`

	// The minimum confidence required to label an object in the video.
	MinConfidence *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectedHomeSettingsForUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectedHomeSettingsForUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectedHomeSettingsForUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectedHomeSettingsForUpdate"}
	if s.Labels != nil && len(s.Labels) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Labels", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabels sets the Labels field's value.
func (s *ConnectedHomeSettingsForUpdate) SetLabels(v []*string) *ConnectedHomeSettingsForUpdate {
	s.Labels = v
	return s
}

// SetMinConfidence sets the MinConfidence field's value.
func (s *ConnectedHomeSettingsForUpdate) SetMinConfidence(v float64) *ConnectedHomeSettingsForUpdate {
	s.MinConfidence = &v
	return s
}

// Information about an inappropriate, unwanted, or offensive content label
// detection in a stored video.
type ContentModerationDetection struct {
	_ struct{} `type:"structure"`

	// The content moderation label detected by in the stored video.
	ModerationLabel *ModerationLabel `type:"structure"`

	// Time, in milliseconds from the beginning of the video, that the content moderation
	// label was detected.
	Timestamp *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentModerationDetection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentModerationDetection) GoString() string {
	return s.String()
}

// SetModerationLabel sets the ModerationLabel field's value.
func (s *ContentModerationDetection) SetModerationLabel(v *ModerationLabel) *ContentModerationDetection {
	s.ModerationLabel = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *ContentModerationDetection) SetTimestamp(v int64) *ContentModerationDetection {
	s.Timestamp = &v
	return s
}

// Information about an item of Personal Protective Equipment covering a corresponding
// body part. For more information, see DetectProtectiveEquipment.
type CoversBodyPart struct {
	_ struct{} `type:"structure"`

	// The confidence that Amazon Rekognition has in the value of Value.
	Confidence *float64 `type:"float"`

	// True if the PPE covers the corresponding body part, otherwise false.
	Value *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoversBodyPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CoversBodyPart) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *CoversBodyPart) SetConfidence(v float64) *CoversBodyPart {
	s.Confidence = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CoversBodyPart) SetValue(v bool) *CoversBodyPart {
	s.Value = &v
	return s
}

type CreateCollectionInput struct {
	_ struct{} `type:"structure"`

	// ID for the collection that you are creating.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`

	// A set of tags (key-value pairs) that you want to attach to the collection.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCollectionInput"}
	if s.CollectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionId sets the CollectionId field's value.
func (s *CreateCollectionInput) SetCollectionId(v string) *CreateCollectionInput {
	s.CollectionId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCollectionInput) SetTags(v map[string]*string) *CreateCollectionInput {
	s.Tags = v
	return s
}

type CreateCollectionOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the collection. You can use this to manage
	// permissions on your resources.
	CollectionArn *string `type:"string"`

	// Version number of the face detection model associated with the collection
	// you are creating.
	FaceModelVersion *string `type:"string"`

	// HTTP status code indicating the result of the operation.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCollectionOutput) GoString() string {
	return s.String()
}

// SetCollectionArn sets the CollectionArn field's value.
func (s *CreateCollectionOutput) SetCollectionArn(v string) *CreateCollectionOutput {
	s.CollectionArn = &v
	return s
}

// SetFaceModelVersion sets the FaceModelVersion field's value.
func (s *CreateCollectionOutput) SetFaceModelVersion(v string) *CreateCollectionOutput {
	s.FaceModelVersion = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *CreateCollectionOutput) SetStatusCode(v int64) *CreateCollectionOutput {
	s.StatusCode = &v
	return s
}

type CreateDatasetInput struct {
	_ struct{} `type:"structure"`

	// The source files for the dataset. You can specify the ARN of an existing
	// dataset or specify the Amazon S3 bucket location of an Amazon Sagemaker format
	// manifest file. If you don't specify datasetSource, an empty dataset is created.
	// To add labeled images to the dataset, You can use the console or call UpdateDatasetEntries.
	DatasetSource *DatasetSource `type:"structure"`

	// The type of the dataset. Specify train to create a training dataset. Specify
	// test to create a test dataset.
	//
	// DatasetType is a required field
	DatasetType *string `type:"string" required:"true" enum:"DatasetType"`

	// The ARN of the Amazon Rekognition Custom Labels project to which you want
	// to asssign the dataset.
	//
	// ProjectArn is a required field
	ProjectArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatasetInput"}
	if s.DatasetType == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetType"))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 20))
	}
	if s.DatasetSource != nil {
		if err := s.DatasetSource.Validate(); err != nil {
			invalidParams.AddNested("DatasetSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetSource sets the DatasetSource field's value.
func (s *CreateDatasetInput) SetDatasetSource(v *DatasetSource) *CreateDatasetInput {
	s.DatasetSource = v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *CreateDatasetInput) SetDatasetType(v string) *CreateDatasetInput {
	s.DatasetType = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateDatasetInput) SetProjectArn(v string) *CreateDatasetInput {
	s.ProjectArn = &v
	return s
}

type CreateDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the created Amazon Rekognition Custom Labels dataset.
	DatasetArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *CreateDatasetOutput) SetDatasetArn(v string) *CreateDatasetOutput {
	s.DatasetArn = &v
	return s
}

type CreateProjectInput struct {
	_ struct{} `type:"structure"`

	// The name of the project to create.
	//
	// ProjectName is a required field
	ProjectName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectInput"}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateProjectInput) SetProjectName(v string) *CreateProjectInput {
	s.ProjectName = &v
	return s
}

type CreateProjectOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new project. You can use the ARN to
	// configure IAM access to the project.
	ProjectArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateProjectOutput) SetProjectArn(v string) *CreateProjectOutput {
	s.ProjectArn = &v
	return s
}

type CreateProjectVersionInput struct {
	_ struct{} `type:"structure"`

	// The identifier for your AWS Key Management Service key (AWS KMS key). You
	// can supply the Amazon Resource Name (ARN) of your KMS key, the ID of your
	// KMS key, an alias for your KMS key, or an alias ARN. The key is used to encrypt
	// training and test images copied into the service for model training. Your
	// source images are unaffected. The key is also used to encrypt training results
	// and manifest files written to the output Amazon S3 bucket (OutputConfig).
	//
	// If you choose to use your own KMS key, you need the following permissions
	// on the KMS key.
	//
	//    * kms:CreateGrant
	//
	//    * kms:DescribeKey
	//
	//    * kms:GenerateDataKey
	//
	//    * kms:Decrypt
	//
	// If you don't specify a value for KmsKeyId, images copied into the service
	// are encrypted using a key that AWS owns and manages.
	KmsKeyId *string `min:"1" type:"string"`

	// The Amazon S3 bucket location to store the results of training. The S3 bucket
	// can be in any AWS account as long as the caller has s3:PutObject permissions
	// on the S3 bucket.
	//
	// OutputConfig is a required field
	OutputConfig *OutputConfig `type:"structure" required:"true"`

	// The ARN of the Amazon Rekognition Custom Labels project that manages the
	// model that you want to train.
	//
	// ProjectArn is a required field
	ProjectArn *string `min:"20" type:"string" required:"true"`

	// A set of tags (key-value pairs) that you want to attach to the model.
	Tags map[string]*string `type:"map"`

	// Specifies an external manifest that the service uses to test the model. If
	// you specify TestingData you must also specify TrainingData. The project must
	// not have any associated datasets.
	TestingData *TestingData `type:"structure"`

	// Specifies an external manifest that the services uses to train the model.
	// If you specify TrainingData you must also specify TestingData. The project
	// must not have any associated datasets.
	TrainingData *TrainingData `type:"structure"`

	// A name for the version of the model. This value must be unique.
	//
	// VersionName is a required field
	VersionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProjectVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProjectVersionInput"}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.OutputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfig"))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 20))
	}
	if s.VersionName == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionName"))
	}
	if s.VersionName != nil && len(*s.VersionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionName", 1))
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.TestingData != nil {
		if err := s.TestingData.Validate(); err != nil {
			invalidParams.AddNested("TestingData", err.(request.ErrInvalidParams))
		}
	}
	if s.TrainingData != nil {
		if err := s.TrainingData.Validate(); err != nil {
			invalidParams.AddNested("TrainingData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateProjectVersionInput) SetKmsKeyId(v string) *CreateProjectVersionInput {
	s.KmsKeyId = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *CreateProjectVersionInput) SetOutputConfig(v *OutputConfig) *CreateProjectVersionInput {
	s.OutputConfig = v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *CreateProjectVersionInput) SetProjectArn(v string) *CreateProjectVersionInput {
	s.ProjectArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProjectVersionInput) SetTags(v map[string]*string) *CreateProjectVersionInput {
	s.Tags = v
	return s
}

// SetTestingData sets the TestingData field's value.
func (s *CreateProjectVersionInput) SetTestingData(v *TestingData) *CreateProjectVersionInput {
	s.TestingData = v
	return s
}

// SetTrainingData sets the TrainingData field's value.
func (s *CreateProjectVersionInput) SetTrainingData(v *TrainingData) *CreateProjectVersionInput {
	s.TrainingData = v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *CreateProjectVersionInput) SetVersionName(v string) *CreateProjectVersionInput {
	s.VersionName = &v
	return s
}

type CreateProjectVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the model version that was created. Use DescribeProjectVersion
	// to get the current status of the training operation.
	ProjectVersionArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProjectVersionOutput) GoString() string {
	return s.String()
}

// SetProjectVersionArn sets the ProjectVersionArn field's value.
func (s *CreateProjectVersionOutput) SetProjectVersionArn(v string) *CreateProjectVersionOutput {
	s.ProjectVersionArn = &v
	return s
}

type CreateStreamProcessorInput struct {
	_ struct{} `type:"structure"`

	// Shows whether you are sharing data with Rekognition to improve model performance.
	// You can choose this option at the account level or on a per-stream basis.
	// Note that if you opt out at the account level this setting is ignored on
	// individual streams.
	DataSharingPreference *StreamProcessorDataSharingPreference `type:"structure"`

	// Kinesis video stream stream that provides the source streaming video. If
	// you are using the AWS CLI, the parameter name is StreamProcessorInput. This
	// is required for both face search and label detection stream processors.
	//
	// Input is a required field
	Input *StreamProcessorInput `type:"structure" required:"true"`

	// The identifier for your AWS Key Management Service key (AWS KMS key). This
	// is an optional parameter for label detection stream processors and should
	// not be used to create a face search stream processor. You can supply the
	// Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key, an alias
	// for your KMS key, or an alias ARN. The key is used to encrypt results and
	// data published to your Amazon S3 bucket, which includes image frames and
	// hero images. Your source images are unaffected.
	KmsKeyId *string `min:"1" type:"string"`

	// An identifier you assign to the stream processor. You can use Name to manage
	// the stream processor. For example, you can get the current status of the
	// stream processor by calling DescribeStreamProcessor. Name is idempotent.
	// This is required for both face search and label detection stream processors.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Simple Notification Service topic to which Amazon Rekognition
	// publishes the object detection results and completion status of a video analysis
	// operation.
	//
	// Amazon Rekognition publishes a notification the first time an object of interest
	// or a person is detected in the video stream. For example, if Amazon Rekognition
	// detects a person at second 2, a pet at second 4, and a person again at second
	// 5, Amazon Rekognition sends 2 object class detected notifications, one for
	// a person at second 2 and one for a pet at second 4.
	//
	// Amazon Rekognition also publishes an an end-of-session notification with
	// a summary when the stream processing session is complete.
	NotificationChannel *StreamProcessorNotificationChannel `type:"structure"`

	// Kinesis data stream stream or Amazon S3 bucket location to which Amazon Rekognition
	// Video puts the analysis results. If you are using the AWS CLI, the parameter
	// name is StreamProcessorOutput. This must be a S3Destination of an Amazon
	// S3 bucket that you own for a label detection stream processor or a Kinesis
	// data stream ARN for a face search stream processor.
	//
	// Output is a required field
	Output *StreamProcessorOutput `type:"structure" required:"true"`

	// Specifies locations in the frames where Amazon Rekognition checks for objects
	// or people. You can specify up to 10 regions of interest. This is an optional
	// parameter for label detection stream processors and should not be used to
	// create a face search stream processor.
	RegionsOfInterest []*RegionOfInterest `type:"list"`

	// The Amazon Resource Number (ARN) of the IAM role that allows access to the
	// stream processor. The IAM role provides Rekognition read permissions for
	// a Kinesis stream. It also provides write permissions to an Amazon S3 bucket
	// and Amazon Simple Notification Service topic for a label detection stream
	// processor. This is required for both face search and label detection stream
	// processors.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// Input parameters used in a streaming video analyzed by a stream processor.
	// You can use FaceSearch to recognize faces in a streaming video, or you can
	// use ConnectedHome to detect labels.
	//
	// Settings is a required field
	Settings *StreamProcessorSettings `type:"structure" required:"true"`

	// A set of tags (key-value pairs) that you want to attach to the stream processor.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamProcessorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamProcessorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamProcessorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamProcessorInput"}
	if s.Input == nil {
		invalidParams.Add(request.NewErrParamRequired("Input"))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Output == nil {
		invalidParams.Add(request.NewErrParamRequired("Output"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Settings == nil {
		invalidParams.Add(request.NewErrParamRequired("Settings"))
	}
	if s.DataSharingPreference != nil {
		if err := s.DataSharingPreference.Validate(); err != nil {
			invalidParams.AddNested("DataSharingPreference", err.(request.ErrInvalidParams))
		}
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.Output != nil {
		if err := s.Output.Validate(); err != nil {
			invalidParams.AddNested("Output", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSharingPreference sets the DataSharingPreference field's value.
func (s *CreateStreamProcessorInput) SetDataSharingPreference(v *StreamProcessorDataSharingPreference) *CreateStreamProcessorInput {
	s.DataSharingPreference = v
	return s
}

// SetInput sets the Input field's value.
func (s *CreateStreamProcessorInput) SetInput(v *StreamProcessorInput) *CreateStreamProcessorInput {
	s.Input = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateStreamProcessorInput) SetKmsKeyId(v string) *CreateStreamProcessorInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateStreamProcessorInput) SetName(v string) *CreateStreamProcessorInput {
	s.Name = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *CreateStreamProcessorInput) SetNotificationChannel(v *StreamProcessorNotificationChannel) *CreateStreamProcessorInput {
	s.NotificationChannel = v
	return s
}

// SetOutput sets the Output field's value.
func (s *CreateStreamProcessorInput) SetOutput(v *StreamProcessorOutput) *CreateStreamProcessorInput {
	s.Output = v
	return s
}

// SetRegionsOfInterest sets the RegionsOfInterest field's value.
func (s *CreateStreamProcessorInput) SetRegionsOfInterest(v []*RegionOfInterest) *CreateStreamProcessorInput {
	s.RegionsOfInterest = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateStreamProcessorInput) SetRoleArn(v string) *CreateStreamProcessorInput {
	s.RoleArn = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *CreateStreamProcessorInput) SetSettings(v *StreamProcessorSettings) *CreateStreamProcessorInput {
	s.Settings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStreamProcessorInput) SetTags(v map[string]*string) *CreateStreamProcessorInput {
	s.Tags = v
	return s
}

type CreateStreamProcessorOutput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Number for the newly created stream processor.
	StreamProcessorArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamProcessorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStreamProcessorOutput) GoString() string {
	return s.String()
}

// SetStreamProcessorArn sets the StreamProcessorArn field's value.
func (s *CreateStreamProcessorOutput) SetStreamProcessorArn(v string) *CreateStreamProcessorOutput {
	s.StreamProcessorArn = &v
	return s
}

// A custom label detected in an image by a call to DetectCustomLabels.
type CustomLabel struct {
	_ struct{} `type:"structure"`

	// The confidence that the model has in the detection of the custom label. The
	// range is 0-100. A higher value indicates a higher confidence.
	Confidence *float64 `type:"float"`

	// The location of the detected object on the image that corresponds to the
	// custom label. Includes an axis aligned coarse bounding box surrounding the
	// object and a finer grain polygon for more accurate spatial information.
	Geometry *Geometry `type:"structure"`

	// The name of the custom label.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLabel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomLabel) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *CustomLabel) SetConfidence(v float64) *CustomLabel {
	s.Confidence = &v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *CustomLabel) SetGeometry(v *Geometry) *CustomLabel {
	s.Geometry = v
	return s
}

// SetName sets the Name field's value.
func (s *CustomLabel) SetName(v string) *CustomLabel {
	s.Name = &v
	return s
}

// Describes updates or additions to a dataset. A Single update or addition
// is an entry (JSON Line) that provides information about a single image. To
// update an existing entry, you match the source-ref field of the update entry
// with the source-ref filed of the entry that you want to update. If the source-ref
// field doesn't match an existing entry, the entry is added to dataset as a
// new entry.
type DatasetChanges struct {
	_ struct{} `type:"structure"`

	// A Base64-encoded binary data object containing one or JSON lines that either
	// update the dataset or are additions to the dataset. You change a dataset
	// by calling UpdateDatasetEntries. If you are using an AWS SDK to call UpdateDatasetEntries,
	// you don't need to encode Changes as the SDK encodes the data for you.
	//
	// For example JSON lines, see Image-Level labels in manifest files and and
	// Object localization in manifest files in the Amazon Rekognition Custom Labels
	// Developer Guide.
	// GroundTruth is automatically base64 encoded/decoded by the SDK.
	//
	// GroundTruth is a required field
	GroundTruth []byte `min:"1" type:"blob" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetChanges) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetChanges) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetChanges) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetChanges"}
	if s.GroundTruth == nil {
		invalidParams.Add(request.NewErrParamRequired("GroundTruth"))
	}
	if s.GroundTruth != nil && len(s.GroundTruth) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroundTruth", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroundTruth sets the GroundTruth field's value.
func (s *DatasetChanges) SetGroundTruth(v []byte) *DatasetChanges {
	s.GroundTruth = v
	return s
}

// A description for a dataset. For more information, see DescribeDataset.
//
// The status fields Status, StatusMessage, and StatusMessageCode reflect the
// last operation on the dataset.
type DatasetDescription struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for the time and date that the dataset was created.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The status message code for the dataset.
	DatasetStats *DatasetStats `type:"structure"`

	// The Unix timestamp for the date and time that the dataset was last updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp"`

	// The status of the dataset.
	Status *string `type:"string" enum:"DatasetStatus"`

	// The status message for the dataset.
	StatusMessage *string `type:"string"`

	// The status message code for the dataset operation. If a service error occurs,
	// try the API call again later. If a client error occurs, check the input parameters
	// to the dataset API call that failed.
	StatusMessageCode *string `type:"string" enum:"DatasetStatusMessageCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetDescription) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *DatasetDescription) SetCreationTimestamp(v time.Time) *DatasetDescription {
	s.CreationTimestamp = &v
	return s
}

// SetDatasetStats sets the DatasetStats field's value.
func (s *DatasetDescription) SetDatasetStats(v *DatasetStats) *DatasetDescription {
	s.DatasetStats = v
	return s
}

// SetLastUpdatedTimestamp sets the LastUpdatedTimestamp field's value.
func (s *DatasetDescription) SetLastUpdatedTimestamp(v time.Time) *DatasetDescription {
	s.LastUpdatedTimestamp = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetDescription) SetStatus(v string) *DatasetDescription {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DatasetDescription) SetStatusMessage(v string) *DatasetDescription {
	s.StatusMessage = &v
	return s
}

// SetStatusMessageCode sets the StatusMessageCode field's value.
func (s *DatasetDescription) SetStatusMessageCode(v string) *DatasetDescription {
	s.StatusMessageCode = &v
	return s
}

// Describes a dataset label. For more information, see ListDatasetLabels.
type DatasetLabelDescription struct {
	_ struct{} `type:"structure"`

	// The name of the label.
	LabelName *string `min:"1" type:"string"`

	// Statistics about the label.
	LabelStats *DatasetLabelStats `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetLabelDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetLabelDescription) GoString() string {
	return s.String()
}

// SetLabelName sets the LabelName field's value.
func (s *DatasetLabelDescription) SetLabelName(v string) *DatasetLabelDescription {
	s.LabelName = &v
	return s
}

// SetLabelStats sets the LabelStats field's value.
func (s *DatasetLabelDescription) SetLabelStats(v *DatasetLabelStats) *DatasetLabelDescription {
	s.LabelStats = v
	return s
}

// Statistics about a label used in a dataset. For more information, see DatasetLabelDescription.
type DatasetLabelStats struct {
	_ struct{} `type:"structure"`

	// The total number of images that have the label assigned to a bounding box.
	BoundingBoxCount *int64 `type:"integer"`

	// The total number of images that use the label.
	EntryCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetLabelStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetLabelStats) GoString() string {
	return s.String()
}

// SetBoundingBoxCount sets the BoundingBoxCount field's value.
func (s *DatasetLabelStats) SetBoundingBoxCount(v int64) *DatasetLabelStats {
	s.BoundingBoxCount = &v
	return s
}

// SetEntryCount sets the EntryCount field's value.
func (s *DatasetLabelStats) SetEntryCount(v int64) *DatasetLabelStats {
	s.EntryCount = &v
	return s
}

// Summary information for an Amazon Rekognition Custom Labels dataset. For
// more information, see ProjectDescription.
type DatasetMetadata struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for the date and time that the dataset was created.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) for the dataset.
	DatasetArn *string `min:"20" type:"string"`

	// The type of the dataset.
	DatasetType *string `type:"string" enum:"DatasetType"`

	// The status for the dataset.
	Status *string `type:"string" enum:"DatasetStatus"`

	// The status message for the dataset.
	StatusMessage *string `type:"string"`

	// The status message code for the dataset operation. If a service error occurs,
	// try the API call again later. If a client error occurs, check the input parameters
	// to the dataset API call that failed.
	StatusMessageCode *string `type:"string" enum:"DatasetStatusMessageCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetMetadata) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *DatasetMetadata) SetCreationTimestamp(v time.Time) *DatasetMetadata {
	s.CreationTimestamp = &v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DatasetMetadata) SetDatasetArn(v string) *DatasetMetadata {
	s.DatasetArn = &v
	return s
}

// SetDatasetType sets the DatasetType field's value.
func (s *DatasetMetadata) SetDatasetType(v string) *DatasetMetadata {
	s.DatasetType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DatasetMetadata) SetStatus(v string) *DatasetMetadata {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DatasetMetadata) SetStatusMessage(v string) *DatasetMetadata {
	s.StatusMessage = &v
	return s
}

// SetStatusMessageCode sets the StatusMessageCode field's value.
func (s *DatasetMetadata) SetStatusMessageCode(v string) *DatasetMetadata {
	s.StatusMessageCode = &v
	return s
}

// The source that Amazon Rekognition Custom Labels uses to create a dataset.
// To use an Amazon Sagemaker format manifest file, specify the S3 bucket location
// in the GroundTruthManifest field. The S3 bucket must be in your AWS account.
// To create a copy of an existing dataset, specify the Amazon Resource Name
// (ARN) of an existing dataset in DatasetArn.
//
// You need to specify a value for DatasetArn or GroundTruthManifest, but not
// both. if you supply both values, or if you don't specify any values, an InvalidParameterException
// exception occurs.
//
// For more information, see CreateDataset.
type DatasetSource struct {
	_ struct{} `type:"structure"`

	// The ARN of an Amazon Rekognition Custom Labels dataset that you want to copy.
	DatasetArn *string `min:"20" type:"string"`

	// The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest
	// file.
	GroundTruthManifest *GroundTruthManifest `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetSource"}
	if s.DatasetArn != nil && len(*s.DatasetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetArn", 20))
	}
	if s.GroundTruthManifest != nil {
		if err := s.GroundTruthManifest.Validate(); err != nil {
			invalidParams.AddNested("GroundTruthManifest", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DatasetSource) SetDatasetArn(v string) *DatasetSource {
	s.DatasetArn = &v
	return s
}

// SetGroundTruthManifest sets the GroundTruthManifest field's value.
func (s *DatasetSource) SetGroundTruthManifest(v *GroundTruthManifest) *DatasetSource {
	s.GroundTruthManifest = v
	return s
}

// Provides statistics about a dataset. For more information, see DescribeDataset.
type DatasetStats struct {
	_ struct{} `type:"structure"`

	// The total number of entries that contain at least one error.
	ErrorEntries *int64 `type:"integer"`

	// The total number of images in the dataset that have labels.
	LabeledEntries *int64 `type:"integer"`

	// The total number of images in the dataset.
	TotalEntries *int64 `type:"integer"`

	// The total number of labels declared in the dataset.
	TotalLabels *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetStats) GoString() string {
	return s.String()
}

// SetErrorEntries sets the ErrorEntries field's value.
func (s *DatasetStats) SetErrorEntries(v int64) *DatasetStats {
	s.ErrorEntries = &v
	return s
}

// SetLabeledEntries sets the LabeledEntries field's value.
func (s *DatasetStats) SetLabeledEntries(v int64) *DatasetStats {
	s.LabeledEntries = &v
	return s
}

// SetTotalEntries sets the TotalEntries field's value.
func (s *DatasetStats) SetTotalEntries(v int64) *DatasetStats {
	s.TotalEntries = &v
	return s
}

// SetTotalLabels sets the TotalLabels field's value.
func (s *DatasetStats) SetTotalLabels(v int64) *DatasetStats {
	s.TotalLabels = &v
	return s
}

type DeleteCollectionInput struct {
	_ struct{} `type:"structure"`

	// ID of the collection to delete.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCollectionInput"}
	if s.CollectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionId sets the CollectionId field's value.
func (s *DeleteCollectionInput) SetCollectionId(v string) *DeleteCollectionInput {
	s.CollectionId = &v
	return s
}

type DeleteCollectionOutput struct {
	_ struct{} `type:"structure"`

	// HTTP status code that indicates the result of the operation.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCollectionOutput) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *DeleteCollectionOutput) SetStatusCode(v int64) *DeleteCollectionOutput {
	s.StatusCode = &v
	return s
}

type DeleteDatasetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Rekognition Custom Labels dataset that you want to
	// delete.
	//
	// DatasetArn is a required field
	DatasetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatasetInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}
	if s.DatasetArn != nil && len(*s.DatasetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DeleteDatasetInput) SetDatasetArn(v string) *DeleteDatasetInput {
	s.DatasetArn = &v
	return s
}

type DeleteDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDatasetOutput) GoString() string {
	return s.String()
}

type DeleteFacesInput struct {
	_ struct{} `type:"structure"`

	// Collection from which to remove the specific faces.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`

	// An array of face IDs to delete.
	//
	// FaceIds is a required field
	FaceIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFacesInput"}
	if s.CollectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionId", 1))
	}
	if s.FaceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("FaceIds"))
	}
	if s.FaceIds != nil && len(s.FaceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FaceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionId sets the CollectionId field's value.
func (s *DeleteFacesInput) SetCollectionId(v string) *DeleteFacesInput {
	s.CollectionId = &v
	return s
}

// SetFaceIds sets the FaceIds field's value.
func (s *DeleteFacesInput) SetFaceIds(v []*string) *DeleteFacesInput {
	s.FaceIds = v
	return s
}

type DeleteFacesOutput struct {
	_ struct{} `type:"structure"`

	// An array of strings (face IDs) of the faces that were deleted.
	DeletedFaces []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFacesOutput) GoString() string {
	return s.String()
}

// SetDeletedFaces sets the DeletedFaces field's value.
func (s *DeleteFacesOutput) SetDeletedFaces(v []*string) *DeleteFacesOutput {
	s.DeletedFaces = v
	return s
}

type DeleteProjectInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project that you want to delete.
	//
	// ProjectArn is a required field
	ProjectArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectInput"}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectArn sets the ProjectArn field's value.
func (s *DeleteProjectInput) SetProjectArn(v string) *DeleteProjectInput {
	s.ProjectArn = &v
	return s
}

type DeleteProjectOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the delete project operation.
	Status *string `type:"string" enum:"ProjectStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteProjectOutput) SetStatus(v string) *DeleteProjectOutput {
	s.Status = &v
	return s
}

type DeleteProjectVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the model version that you want to delete.
	//
	// ProjectVersionArn is a required field
	ProjectVersionArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProjectVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProjectVersionInput"}
	if s.ProjectVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectVersionArn"))
	}
	if s.ProjectVersionArn != nil && len(*s.ProjectVersionArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectVersionArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectVersionArn sets the ProjectVersionArn field's value.
func (s *DeleteProjectVersionInput) SetProjectVersionArn(v string) *DeleteProjectVersionInput {
	s.ProjectVersionArn = &v
	return s
}

type DeleteProjectVersionOutput struct {
	_ struct{} `type:"structure"`

	// The status of the deletion operation.
	Status *string `type:"string" enum:"ProjectVersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProjectVersionOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DeleteProjectVersionOutput) SetStatus(v string) *DeleteProjectVersionOutput {
	s.Status = &v
	return s
}

type DeleteStreamProcessorInput struct {
	_ struct{} `type:"structure"`

	// The name of the stream processor you want to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamProcessorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamProcessorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamProcessorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamProcessorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteStreamProcessorInput) SetName(v string) *DeleteStreamProcessorInput {
	s.Name = &v
	return s
}

type DeleteStreamProcessorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamProcessorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStreamProcessorOutput) GoString() string {
	return s.String()
}

type DescribeCollectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the collection to describe.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCollectionInput"}
	if s.CollectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionId sets the CollectionId field's value.
func (s *DescribeCollectionInput) SetCollectionId(v string) *DescribeCollectionInput {
	s.CollectionId = &v
	return s
}

type DescribeCollectionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the collection.
	CollectionARN *string `type:"string"`

	// The number of milliseconds since the Unix epoch time until the creation of
	// the collection. The Unix epoch time is 00:00:00 Coordinated Universal Time
	// (UTC), Thursday, 1 January 1970.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The number of faces that are indexed into the collection. To index faces
	// into a collection, use IndexFaces.
	FaceCount *int64 `type:"long"`

	// The version of the face model that's used by the collection for face detection.
	//
	// For more information, see Model versioning in the Amazon Rekognition Developer
	// Guide.
	FaceModelVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCollectionOutput) GoString() string {
	return s.String()
}

// SetCollectionARN sets the CollectionARN field's value.
func (s *DescribeCollectionOutput) SetCollectionARN(v string) *DescribeCollectionOutput {
	s.CollectionARN = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *DescribeCollectionOutput) SetCreationTimestamp(v time.Time) *DescribeCollectionOutput {
	s.CreationTimestamp = &v
	return s
}

// SetFaceCount sets the FaceCount field's value.
func (s *DescribeCollectionOutput) SetFaceCount(v int64) *DescribeCollectionOutput {
	s.FaceCount = &v
	return s
}

// SetFaceModelVersion sets the FaceModelVersion field's value.
func (s *DescribeCollectionOutput) SetFaceModelVersion(v string) *DescribeCollectionOutput {
	s.FaceModelVersion = &v
	return s
}

type DescribeDatasetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset that you want to describe.
	//
	// DatasetArn is a required field
	DatasetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDatasetInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}
	if s.DatasetArn != nil && len(*s.DatasetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *DescribeDatasetInput) SetDatasetArn(v string) *DescribeDatasetInput {
	s.DatasetArn = &v
	return s
}

type DescribeDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The description for the dataset.
	DatasetDescription *DatasetDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDatasetOutput) GoString() string {
	return s.String()
}

// SetDatasetDescription sets the DatasetDescription field's value.
func (s *DescribeDatasetOutput) SetDatasetDescription(v *DatasetDescription) *DescribeDatasetOutput {
	s.DatasetDescription = v
	return s
}

type DescribeProjectVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 100. If you specify a value greater than 100, a ValidationException
	// error occurs. The default value is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in
	// the response. You can use this pagination token to retrieve the next set
	// of results.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the project that contains the models you
	// want to describe.
	//
	// ProjectArn is a required field
	ProjectArn *string `min:"20" type:"string" required:"true"`

	// A list of model version names that you want to describe. You can add up to
	// 10 model version names to the list. If you don't specify a value, all model
	// descriptions are returned. A version name is part of a model (ProjectVersion)
	// ARN. For example, my-model.2020-01-21T09.10.15 is the version name in the
	// following ARN. arn:aws:rekognition:us-east-1:123456789012:project/getting-started/version/my-model.2020-01-21T09.10.15/1234567890123.
	VersionNames []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProjectVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ProjectArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectArn"))
	}
	if s.ProjectArn != nil && len(*s.ProjectArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectArn", 20))
	}
	if s.VersionNames != nil && len(s.VersionNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeProjectVersionsInput) SetMaxResults(v int64) *DescribeProjectVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeProjectVersionsInput) SetNextToken(v string) *DescribeProjectVersionsInput {
	s.NextToken = &v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *DescribeProjectVersionsInput) SetProjectArn(v string) *DescribeProjectVersionsInput {
	s.ProjectArn = &v
	return s
}

// SetVersionNames sets the VersionNames field's value.
func (s *DescribeProjectVersionsInput) SetVersionNames(v []*string) *DescribeProjectVersionsInput {
	s.VersionNames = v
	return s
}

type DescribeProjectVersionsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in
	// the response. You can use this pagination token to retrieve the next set
	// of results.
	NextToken *string `type:"string"`

	// A list of model descriptions. The list is sorted by the creation date and
	// time of the model versions, latest to earliest.
	ProjectVersionDescriptions []*ProjectVersionDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeProjectVersionsOutput) SetNextToken(v string) *DescribeProjectVersionsOutput {
	s.NextToken = &v
	return s
}

// SetProjectVersionDescriptions sets the ProjectVersionDescriptions field's value.
func (s *DescribeProjectVersionsOutput) SetProjectVersionDescriptions(v []*ProjectVersionDescription) *DescribeProjectVersionsOutput {
	s.ProjectVersionDescriptions = v
	return s
}

type DescribeProjectsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 100. If you specify a value greater than 100, a ValidationException
	// error occurs. The default value is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in
	// the response. You can use this pagination token to retrieve the next set
	// of results.
	NextToken *string `type:"string"`

	// A list of the projects that you want Amazon Rekognition Custom Labels to
	// describe. If you don't specify a value, the response includes descriptions
	// for all the projects in your AWS account.
	ProjectNames []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProjectsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ProjectNames != nil && len(s.ProjectNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeProjectsInput) SetMaxResults(v int64) *DescribeProjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeProjectsInput) SetNextToken(v string) *DescribeProjectsInput {
	s.NextToken = &v
	return s
}

// SetProjectNames sets the ProjectNames field's value.
func (s *DescribeProjectsInput) SetProjectNames(v []*string) *DescribeProjectsInput {
	s.ProjectNames = v
	return s
}

type DescribeProjectsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in
	// the response. You can use this pagination token to retrieve the next set
	// of results.
	NextToken *string `type:"string"`

	// A list of project descriptions. The list is sorted by the date and time the
	// projects are created.
	ProjectDescriptions []*ProjectDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProjectsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeProjectsOutput) SetNextToken(v string) *DescribeProjectsOutput {
	s.NextToken = &v
	return s
}

// SetProjectDescriptions sets the ProjectDescriptions field's value.
func (s *DescribeProjectsOutput) SetProjectDescriptions(v []*ProjectDescription) *DescribeProjectsOutput {
	s.ProjectDescriptions = v
	return s
}

type DescribeStreamProcessorInput struct {
	_ struct{} `type:"structure"`

	// Name of the stream processor for which you want information.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamProcessorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamProcessorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStreamProcessorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStreamProcessorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeStreamProcessorInput) SetName(v string) *DescribeStreamProcessorInput {
	s.Name = &v
	return s
}

type DescribeStreamProcessorOutput struct {
	_ struct{} `type:"structure"`

	// Date and time the stream processor was created
	CreationTimestamp *time.Time `type:"timestamp"`

	// Shows whether you are sharing data with Rekognition to improve model performance.
	// You can choose this option at the account level or on a per-stream basis.
	// Note that if you opt out at the account level this setting is ignored on
	// individual streams.
	DataSharingPreference *StreamProcessorDataSharingPreference `type:"structure"`

	// Kinesis video stream that provides the source streaming video.
	Input *StreamProcessorInput `type:"structure"`

	// The identifier for your AWS Key Management Service key (AWS KMS key). This
	// is an optional parameter for label detection stream processors.
	KmsKeyId *string `min:"1" type:"string"`

	// The time, in Unix format, the stream processor was last updated. For example,
	// when the stream processor moves from a running state to a failed state, or
	// when the user starts or stops the stream processor.
	LastUpdateTimestamp *time.Time `type:"timestamp"`

	// Name of the stream processor.
	Name *string `min:"1" type:"string"`

	// The Amazon Simple Notification Service topic to which Amazon Rekognition
	// publishes the object detection results and completion status of a video analysis
	// operation.
	//
	// Amazon Rekognition publishes a notification the first time an object of interest
	// or a person is detected in the video stream. For example, if Amazon Rekognition
	// detects a person at second 2, a pet at second 4, and a person again at second
	// 5, Amazon Rekognition sends 2 object class detected notifications, one for
	// a person at second 2 and one for a pet at second 4.
	//
	// Amazon Rekognition also publishes an an end-of-session notification with
	// a summary when the stream processing session is complete.
	NotificationChannel *StreamProcessorNotificationChannel `type:"structure"`

	// Kinesis data stream to which Amazon Rekognition Video puts the analysis results.
	Output *StreamProcessorOutput `type:"structure"`

	// Specifies locations in the frames where Amazon Rekognition checks for objects
	// or people. This is an optional parameter for label detection stream processors.
	RegionsOfInterest []*RegionOfInterest `type:"list"`

	// ARN of the IAM role that allows access to the stream processor.
	RoleArn *string `type:"string"`

	// Input parameters used in a streaming video analyzed by a stream processor.
	// You can use FaceSearch to recognize faces in a streaming video, or you can
	// use ConnectedHome to detect labels.
	Settings *StreamProcessorSettings `type:"structure"`

	// Current status of the stream processor.
	Status *string `type:"string" enum:"StreamProcessorStatus"`

	// Detailed status message about the stream processor.
	StatusMessage *string `type:"string"`

	// ARN of the stream processor.
	StreamProcessorArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamProcessorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeStreamProcessorOutput) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *DescribeStreamProcessorOutput) SetCreationTimestamp(v time.Time) *DescribeStreamProcessorOutput {
	s.CreationTimestamp = &v
	return s
}

// SetDataSharingPreference sets the DataSharingPreference field's value.
func (s *DescribeStreamProcessorOutput) SetDataSharingPreference(v *StreamProcessorDataSharingPreference) *DescribeStreamProcessorOutput {
	s.DataSharingPreference = v
	return s
}

// SetInput sets the Input field's value.
func (s *DescribeStreamProcessorOutput) SetInput(v *StreamProcessorInput) *DescribeStreamProcessorOutput {
	s.Input = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DescribeStreamProcessorOutput) SetKmsKeyId(v string) *DescribeStreamProcessorOutput {
	s.KmsKeyId = &v
	return s
}

// SetLastUpdateTimestamp sets the LastUpdateTimestamp field's value.
func (s *DescribeStreamProcessorOutput) SetLastUpdateTimestamp(v time.Time) *DescribeStreamProcessorOutput {
	s.LastUpdateTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeStreamProcessorOutput) SetName(v string) *DescribeStreamProcessorOutput {
	s.Name = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *DescribeStreamProcessorOutput) SetNotificationChannel(v *StreamProcessorNotificationChannel) *DescribeStreamProcessorOutput {
	s.NotificationChannel = v
	return s
}

// SetOutput sets the Output field's value.
func (s *DescribeStreamProcessorOutput) SetOutput(v *StreamProcessorOutput) *DescribeStreamProcessorOutput {
	s.Output = v
	return s
}

// SetRegionsOfInterest sets the RegionsOfInterest field's value.
func (s *DescribeStreamProcessorOutput) SetRegionsOfInterest(v []*RegionOfInterest) *DescribeStreamProcessorOutput {
	s.RegionsOfInterest = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribeStreamProcessorOutput) SetRoleArn(v string) *DescribeStreamProcessorOutput {
	s.RoleArn = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *DescribeStreamProcessorOutput) SetSettings(v *StreamProcessorSettings) *DescribeStreamProcessorOutput {
	s.Settings = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeStreamProcessorOutput) SetStatus(v string) *DescribeStreamProcessorOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DescribeStreamProcessorOutput) SetStatusMessage(v string) *DescribeStreamProcessorOutput {
	s.StatusMessage = &v
	return s
}

// SetStreamProcessorArn sets the StreamProcessorArn field's value.
func (s *DescribeStreamProcessorOutput) SetStreamProcessorArn(v string) *DescribeStreamProcessorOutput {
	s.StreamProcessorArn = &v
	return s
}

type DetectCustomLabelsInput struct {
	_ struct{} `type:"structure"`

	// Provides the input image either as bytes or an S3 object.
	//
	// You pass image bytes to an Amazon Rekognition API operation by using the
	// Bytes property. For example, you would use the Bytes property to pass an
	// image loaded from a local file system. Image bytes passed by using the Bytes
	// property must be base64-encoded. Your code may not need to encode image bytes
	// if you are using an AWS SDK to call Amazon Rekognition API operations.
	//
	// For more information, see Analyzing an Image Loaded from a Local File System
	// in the Amazon Rekognition Developer Guide.
	//
	// You pass images stored in an S3 bucket to an Amazon Rekognition API operation
	// by using the S3Object property. Images stored in an S3 bucket do not need
	// to be base64-encoded.
	//
	// The region for the S3 bucket containing the S3 object must match the region
	// you use for Amazon Rekognition operations.
	//
	// If you use the AWS CLI to call Amazon Rekognition operations, passing image
	// bytes using the Bytes property is not supported. You must first upload the
	// image to an Amazon S3 bucket and then call the operation using the S3Object
	// property.
	//
	// For Amazon Rekognition to process an S3 object, the user must have permission
	// to access the S3 object. For more information, see How Amazon Rekognition
	// works with IAM in the Amazon Rekognition Developer Guide.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`

	// Maximum number of results you want the service to return in the response.
	// The service returns the specified number of highest confidence labels ranked
	// from highest confidence to lowest.
	MaxResults *int64 `type:"integer"`

	// Specifies the minimum confidence level for the labels to return. DetectCustomLabels
	// doesn't return any labels with a confidence value that's lower than this
	// specified value. If you specify a value of 0, DetectCustomLabels returns
	// all labels, regardless of the assumed threshold applied to each label. If
	// you don't specify a value for MinConfidence, DetectCustomLabels returns labels
	// based on the assumed threshold of each label.
	MinConfidence *float64 `type:"float"`

	// The ARN of the model version that you want to use.
	//
	// ProjectVersionArn is a required field
	ProjectVersionArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectCustomLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectCustomLabelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectCustomLabelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectCustomLabelsInput"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.ProjectVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectVersionArn"))
	}
	if s.ProjectVersionArn != nil && len(*s.ProjectVersionArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectVersionArn", 20))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImage sets the Image field's value.
func (s *DetectCustomLabelsInput) SetImage(v *Image) *DetectCustomLabelsInput {
	s.Image = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DetectCustomLabelsInput) SetMaxResults(v int64) *DetectCustomLabelsInput {
	s.MaxResults = &v
	return s
}

// SetMinConfidence sets the MinConfidence field's value.
func (s *DetectCustomLabelsInput) SetMinConfidence(v float64) *DetectCustomLabelsInput {
	s.MinConfidence = &v
	return s
}

// SetProjectVersionArn sets the ProjectVersionArn field's value.
func (s *DetectCustomLabelsInput) SetProjectVersionArn(v string) *DetectCustomLabelsInput {
	s.ProjectVersionArn = &v
	return s
}

type DetectCustomLabelsOutput struct {
	_ struct{} `type:"structure"`

	// An array of custom labels detected in the input image.
	CustomLabels []*CustomLabel `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectCustomLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectCustomLabelsOutput) GoString() string {
	return s.String()
}

// SetCustomLabels sets the CustomLabels field's value.
func (s *DetectCustomLabelsOutput) SetCustomLabels(v []*CustomLabel) *DetectCustomLabelsOutput {
	s.CustomLabels = v
	return s
}

type DetectFacesInput struct {
	_ struct{} `type:"structure"`

	// An array of facial attributes you want to be returned. This can be the default
	// list of attributes or all attributes. If you don't specify a value for Attributes
	// or if you specify ["DEFAULT"], the API returns the following subset of facial
	// attributes: BoundingBox, Confidence, Pose, Quality, and Landmarks. If you
	// provide ["ALL"], all facial attributes are returned, but the operation takes
	// longer to complete.
	//
	// If you provide both, ["ALL", "DEFAULT"], the service uses a logical AND operator
	// to determine which attributes to return (in this case, all attributes).
	Attributes []*string `type:"list" enum:"Attribute"`

	// The input image as base64-encoded bytes or an S3 object. If you use the AWS
	// CLI to call Amazon Rekognition operations, passing base64-encoded image bytes
	// is not supported.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectFacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectFacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectFacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectFacesInput"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *DetectFacesInput) SetAttributes(v []*string) *DetectFacesInput {
	s.Attributes = v
	return s
}

// SetImage sets the Image field's value.
func (s *DetectFacesInput) SetImage(v *Image) *DetectFacesInput {
	s.Image = v
	return s
}

type DetectFacesOutput struct {
	_ struct{} `type:"structure"`

	// Details of each face found in the image.
	FaceDetails []*FaceDetail `type:"list"`

	// The value of OrientationCorrection is always null.
	//
	// If the input image is in .jpeg format, it might contain exchangeable image
	// file format (Exif) metadata that includes the image's orientation. Amazon
	// Rekognition uses this orientation information to perform image correction.
	// The bounding box coordinates are translated to represent object locations
	// after the orientation information in the Exif metadata is used to correct
	// the image orientation. Images in .png format don't contain Exif metadata.
	//
	// Amazon Rekognition doesn’t perform image correction for images in .png
	// format and .jpeg images without orientation information in the image Exif
	// metadata. The bounding box coordinates aren't translated and represent the
	// object locations before the image is rotated.
	OrientationCorrection *string `type:"string" enum:"OrientationCorrection"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectFacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectFacesOutput) GoString() string {
	return s.String()
}

// SetFaceDetails sets the FaceDetails field's value.
func (s *DetectFacesOutput) SetFaceDetails(v []*FaceDetail) *DetectFacesOutput {
	s.FaceDetails = v
	return s
}

// SetOrientationCorrection sets the OrientationCorrection field's value.
func (s *DetectFacesOutput) SetOrientationCorrection(v string) *DetectFacesOutput {
	s.OrientationCorrection = &v
	return s
}

type DetectLabelsInput struct {
	_ struct{} `type:"structure"`

	// The input image as base64-encoded bytes or an S3 object. If you use the AWS
	// CLI to call Amazon Rekognition operations, passing image bytes is not supported.
	// Images stored in an S3 Bucket do not need to be base64-encoded.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`

	// Maximum number of labels you want the service to return in the response.
	// The service returns the specified number of highest confidence labels.
	MaxLabels *int64 `type:"integer"`

	// Specifies the minimum confidence level for the labels to return. Amazon Rekognition
	// doesn't return any labels with confidence lower than this specified value.
	//
	// If MinConfidence is not specified, the operation returns labels with a confidence
	// values greater than or equal to 55 percent.
	MinConfidence *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectLabelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectLabelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectLabelsInput"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImage sets the Image field's value.
func (s *DetectLabelsInput) SetImage(v *Image) *DetectLabelsInput {
	s.Image = v
	return s
}

// SetMaxLabels sets the MaxLabels field's value.
func (s *DetectLabelsInput) SetMaxLabels(v int64) *DetectLabelsInput {
	s.MaxLabels = &v
	return s
}

// SetMinConfidence sets the MinConfidence field's value.
func (s *DetectLabelsInput) SetMinConfidence(v float64) *DetectLabelsInput {
	s.MinConfidence = &v
	return s
}

type DetectLabelsOutput struct {
	_ struct{} `type:"structure"`

	// Version number of the label detection model that was used to detect labels.
	LabelModelVersion *string `type:"string"`

	// An array of labels for the real-world objects detected.
	Labels []*Label `type:"list"`

	// The value of OrientationCorrection is always null.
	//
	// If the input image is in .jpeg format, it might contain exchangeable image
	// file format (Exif) metadata that includes the image's orientation. Amazon
	// Rekognition uses this orientation information to perform image correction.
	// The bounding box coordinates are translated to represent object locations
	// after the orientation information in the Exif metadata is used to correct
	// the image orientation. Images in .png format don't contain Exif metadata.
	//
	// Amazon Rekognition doesn’t perform image correction for images in .png
	// format and .jpeg images without orientation information in the image Exif
	// metadata. The bounding box coordinates aren't translated and represent the
	// object locations before the image is rotated.
	OrientationCorrection *string `type:"string" enum:"OrientationCorrection"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectLabelsOutput) GoString() string {
	return s.String()
}

// SetLabelModelVersion sets the LabelModelVersion field's value.
func (s *DetectLabelsOutput) SetLabelModelVersion(v string) *DetectLabelsOutput {
	s.LabelModelVersion = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *DetectLabelsOutput) SetLabels(v []*Label) *DetectLabelsOutput {
	s.Labels = v
	return s
}

// SetOrientationCorrection sets the OrientationCorrection field's value.
func (s *DetectLabelsOutput) SetOrientationCorrection(v string) *DetectLabelsOutput {
	s.OrientationCorrection = &v
	return s
}

type DetectModerationLabelsInput struct {
	_ struct{} `type:"structure"`

	// Sets up the configuration for human evaluation, including the FlowDefinition
	// the image will be sent to.
	HumanLoopConfig *HumanLoopConfig `type:"structure"`

	// The input image as base64-encoded bytes or an S3 object. If you use the AWS
	// CLI to call Amazon Rekognition operations, passing base64-encoded image bytes
	// is not supported.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`

	// Specifies the minimum confidence level for the labels to return. Amazon Rekognition
	// doesn't return any labels with a confidence level lower than this specified
	// value.
	//
	// If you don't specify MinConfidence, the operation returns labels with confidence
	// values greater than or equal to 50 percent.
	MinConfidence *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectModerationLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectModerationLabelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectModerationLabelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectModerationLabelsInput"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.HumanLoopConfig != nil {
		if err := s.HumanLoopConfig.Validate(); err != nil {
			invalidParams.AddNested("HumanLoopConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHumanLoopConfig sets the HumanLoopConfig field's value.
func (s *DetectModerationLabelsInput) SetHumanLoopConfig(v *HumanLoopConfig) *DetectModerationLabelsInput {
	s.HumanLoopConfig = v
	return s
}

// SetImage sets the Image field's value.
func (s *DetectModerationLabelsInput) SetImage(v *Image) *DetectModerationLabelsInput {
	s.Image = v
	return s
}

// SetMinConfidence sets the MinConfidence field's value.
func (s *DetectModerationLabelsInput) SetMinConfidence(v float64) *DetectModerationLabelsInput {
	s.MinConfidence = &v
	return s
}

type DetectModerationLabelsOutput struct {
	_ struct{} `type:"structure"`

	// Shows the results of the human in the loop evaluation.
	HumanLoopActivationOutput *HumanLoopActivationOutput `type:"structure"`

	// Array of detected Moderation labels and the time, in milliseconds from the
	// start of the video, they were detected.
	ModerationLabels []*ModerationLabel `type:"list"`

	// Version number of the moderation detection model that was used to detect
	// unsafe content.
	ModerationModelVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectModerationLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectModerationLabelsOutput) GoString() string {
	return s.String()
}

// SetHumanLoopActivationOutput sets the HumanLoopActivationOutput field's value.
func (s *DetectModerationLabelsOutput) SetHumanLoopActivationOutput(v *HumanLoopActivationOutput) *DetectModerationLabelsOutput {
	s.HumanLoopActivationOutput = v
	return s
}

// SetModerationLabels sets the ModerationLabels field's value.
func (s *DetectModerationLabelsOutput) SetModerationLabels(v []*ModerationLabel) *DetectModerationLabelsOutput {
	s.ModerationLabels = v
	return s
}

// SetModerationModelVersion sets the ModerationModelVersion field's value.
func (s *DetectModerationLabelsOutput) SetModerationModelVersion(v string) *DetectModerationLabelsOutput {
	s.ModerationModelVersion = &v
	return s
}

type DetectProtectiveEquipmentInput struct {
	_ struct{} `type:"structure"`

	// The image in which you want to detect PPE on detected persons. The image
	// can be passed as image bytes or you can reference an image stored in an Amazon
	// S3 bucket.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`

	// An array of PPE types that you want to summarize.
	SummarizationAttributes *ProtectiveEquipmentSummarizationAttributes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectProtectiveEquipmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectProtectiveEquipmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectProtectiveEquipmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectProtectiveEquipmentInput"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(request.ErrInvalidParams))
		}
	}
	if s.SummarizationAttributes != nil {
		if err := s.SummarizationAttributes.Validate(); err != nil {
			invalidParams.AddNested("SummarizationAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImage sets the Image field's value.
func (s *DetectProtectiveEquipmentInput) SetImage(v *Image) *DetectProtectiveEquipmentInput {
	s.Image = v
	return s
}

// SetSummarizationAttributes sets the SummarizationAttributes field's value.
func (s *DetectProtectiveEquipmentInput) SetSummarizationAttributes(v *ProtectiveEquipmentSummarizationAttributes) *DetectProtectiveEquipmentInput {
	s.SummarizationAttributes = v
	return s
}

type DetectProtectiveEquipmentOutput struct {
	_ struct{} `type:"structure"`

	// An array of persons detected in the image (including persons not wearing
	// PPE).
	Persons []*ProtectiveEquipmentPerson `type:"list"`

	// The version number of the PPE detection model used to detect PPE in the image.
	ProtectiveEquipmentModelVersion *string `type:"string"`

	// Summary information for the types of PPE specified in the SummarizationAttributes
	// input parameter.
	Summary *ProtectiveEquipmentSummary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectProtectiveEquipmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectProtectiveEquipmentOutput) GoString() string {
	return s.String()
}

// SetPersons sets the Persons field's value.
func (s *DetectProtectiveEquipmentOutput) SetPersons(v []*ProtectiveEquipmentPerson) *DetectProtectiveEquipmentOutput {
	s.Persons = v
	return s
}

// SetProtectiveEquipmentModelVersion sets the ProtectiveEquipmentModelVersion field's value.
func (s *DetectProtectiveEquipmentOutput) SetProtectiveEquipmentModelVersion(v string) *DetectProtectiveEquipmentOutput {
	s.ProtectiveEquipmentModelVersion = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *DetectProtectiveEquipmentOutput) SetSummary(v *ProtectiveEquipmentSummary) *DetectProtectiveEquipmentOutput {
	s.Summary = v
	return s
}

// A set of optional parameters that you can use to set the criteria that the
// text must meet to be included in your response. WordFilter looks at a word’s
// height, width, and minimum confidence. RegionOfInterest lets you set a specific
// region of the image to look for text in.
type DetectTextFilters struct {
	_ struct{} `type:"structure"`

	// A Filter focusing on a certain area of the image. Uses a BoundingBox object
	// to set the region of the image.
	RegionsOfInterest []*RegionOfInterest `type:"list"`

	// A set of parameters that allow you to filter out certain results from your
	// returned results.
	WordFilter *DetectionFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectTextFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectTextFilters) GoString() string {
	return s.String()
}

// SetRegionsOfInterest sets the RegionsOfInterest field's value.
func (s *DetectTextFilters) SetRegionsOfInterest(v []*RegionOfInterest) *DetectTextFilters {
	s.RegionsOfInterest = v
	return s
}

// SetWordFilter sets the WordFilter field's value.
func (s *DetectTextFilters) SetWordFilter(v *DetectionFilter) *DetectTextFilters {
	s.WordFilter = v
	return s
}

type DetectTextInput struct {
	_ struct{} `type:"structure"`

	// Optional parameters that let you set the criteria that the text must meet
	// to be included in your response.
	Filters *DetectTextFilters `type:"structure"`

	// The input image as base64-encoded bytes or an Amazon S3 object. If you use
	// the AWS CLI to call Amazon Rekognition operations, you can't pass image bytes.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectTextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectTextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectTextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectTextInput"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DetectTextInput) SetFilters(v *DetectTextFilters) *DetectTextInput {
	s.Filters = v
	return s
}

// SetImage sets the Image field's value.
func (s *DetectTextInput) SetImage(v *Image) *DetectTextInput {
	s.Image = v
	return s
}

type DetectTextOutput struct {
	_ struct{} `type:"structure"`

	// An array of text that was detected in the input image.
	TextDetections []*TextDetection `type:"list"`

	// The model version used to detect text.
	TextModelVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectTextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectTextOutput) GoString() string {
	return s.String()
}

// SetTextDetections sets the TextDetections field's value.
func (s *DetectTextOutput) SetTextDetections(v []*TextDetection) *DetectTextOutput {
	s.TextDetections = v
	return s
}

// SetTextModelVersion sets the TextModelVersion field's value.
func (s *DetectTextOutput) SetTextModelVersion(v string) *DetectTextOutput {
	s.TextModelVersion = &v
	return s
}

// A set of parameters that allow you to filter out certain results from your
// returned results.
type DetectionFilter struct {
	_ struct{} `type:"structure"`

	// Sets the minimum height of the word bounding box. Words with bounding box
	// heights lesser than this value will be excluded from the result. Value is
	// relative to the video frame height.
	MinBoundingBoxHeight *float64 `type:"float"`

	// Sets the minimum width of the word bounding box. Words with bounding boxes
	// widths lesser than this value will be excluded from the result. Value is
	// relative to the video frame width.
	MinBoundingBoxWidth *float64 `type:"float"`

	// Sets the confidence of word detection. Words with detection confidence below
	// this will be excluded from the result. Values should be between 0 and 100.
	// The default MinConfidence is 80.
	MinConfidence *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectionFilter) GoString() string {
	return s.String()
}

// SetMinBoundingBoxHeight sets the MinBoundingBoxHeight field's value.
func (s *DetectionFilter) SetMinBoundingBoxHeight(v float64) *DetectionFilter {
	s.MinBoundingBoxHeight = &v
	return s
}

// SetMinBoundingBoxWidth sets the MinBoundingBoxWidth field's value.
func (s *DetectionFilter) SetMinBoundingBoxWidth(v float64) *DetectionFilter {
	s.MinBoundingBoxWidth = &v
	return s
}

// SetMinConfidence sets the MinConfidence field's value.
func (s *DetectionFilter) SetMinConfidence(v float64) *DetectionFilter {
	s.MinConfidence = &v
	return s
}

// A training dataset or a test dataset used in a dataset distribution operation.
// For more information, see DistributeDatasetEntries.
type DistributeDataset struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset that you want to use.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DistributeDataset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DistributeDataset) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DistributeDataset) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DistributeDataset"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DistributeDataset) SetArn(v string) *DistributeDataset {
	s.Arn = &v
	return s
}

type DistributeDatasetEntriesInput struct {
	_ struct{} `type:"structure"`

	// The ARNS for the training dataset and test dataset that you want to use.
	// The datasets must belong to the same project. The test dataset must be empty.
	//
	// Datasets is a required field
	Datasets []*DistributeDataset `min:"2" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DistributeDatasetEntriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DistributeDatasetEntriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DistributeDatasetEntriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DistributeDatasetEntriesInput"}
	if s.Datasets == nil {
		invalidParams.Add(request.NewErrParamRequired("Datasets"))
	}
	if s.Datasets != nil && len(s.Datasets) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Datasets", 2))
	}
	if s.Datasets != nil {
		for i, v := range s.Datasets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Datasets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasets sets the Datasets field's value.
func (s *DistributeDatasetEntriesInput) SetDatasets(v []*DistributeDataset) *DistributeDatasetEntriesInput {
	s.Datasets = v
	return s
}

type DistributeDatasetEntriesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DistributeDatasetEntriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DistributeDatasetEntriesOutput) GoString() string {
	return s.String()
}

// The emotions that appear to be expressed on the face, and the confidence
// level in the determination. The API is only making a determination of the
// physical appearance of a person's face. It is not a determination of the
// person’s internal emotional state and should not be used in such a way.
// For example, a person pretending to have a sad face might not be sad emotionally.
type Emotion struct {
	_ struct{} `type:"structure"`

	// Level of confidence in the determination.
	Confidence *float64 `type:"float"`

	// Type of emotion detected.
	Type *string `type:"string" enum:"EmotionName"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Emotion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Emotion) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *Emotion) SetConfidence(v float64) *Emotion {
	s.Confidence = &v
	return s
}

// SetType sets the Type field's value.
func (s *Emotion) SetType(v string) *Emotion {
	s.Type = &v
	return s
}

// Information about an item of Personal Protective Equipment (PPE) detected
// by DetectProtectiveEquipment. For more information, see DetectProtectiveEquipment.
type EquipmentDetection struct {
	_ struct{} `type:"structure"`

	// A bounding box surrounding the item of detected PPE.
	BoundingBox *BoundingBox `type:"structure"`

	// The confidence that Amazon Rekognition has that the bounding box (BoundingBox)
	// contains an item of PPE.
	Confidence *float64 `type:"float"`

	// Information about the body part covered by the detected PPE.
	CoversBodyPart *CoversBodyPart `type:"structure"`

	// The type of detected PPE.
	Type *string `type:"string" enum:"ProtectiveEquipmentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EquipmentDetection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EquipmentDetection) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *EquipmentDetection) SetBoundingBox(v *BoundingBox) *EquipmentDetection {
	s.BoundingBox = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *EquipmentDetection) SetConfidence(v float64) *EquipmentDetection {
	s.Confidence = &v
	return s
}

// SetCoversBodyPart sets the CoversBodyPart field's value.
func (s *EquipmentDetection) SetCoversBodyPart(v *CoversBodyPart) *EquipmentDetection {
	s.CoversBodyPart = v
	return s
}

// SetType sets the Type field's value.
func (s *EquipmentDetection) SetType(v string) *EquipmentDetection {
	s.Type = &v
	return s
}

// The evaluation results for the training of a model.
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// The F1 score for the evaluation of all labels. The F1 score metric evaluates
	// the overall precision and recall performance of the model as a single value.
	// A higher value indicates better precision and recall performance. A lower
	// score indicates that precision, recall, or both are performing poorly.
	F1Score *float64 `type:"float"`

	// The S3 bucket that contains the training summary.
	Summary *Summary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EvaluationResult) GoString() string {
	return s.String()
}

// SetF1Score sets the F1Score field's value.
func (s *EvaluationResult) SetF1Score(v float64) *EvaluationResult {
	s.F1Score = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *EvaluationResult) SetSummary(v *Summary) *EvaluationResult {
	s.Summary = v
	return s
}

// Indicates whether or not the eyes on the face are open, and the confidence
// level in the determination.
type EyeOpen struct {
	_ struct{} `type:"structure"`

	// Level of confidence in the determination.
	Confidence *float64 `type:"float"`

	// Boolean value that indicates whether the eyes on the face are open.
	Value *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EyeOpen) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EyeOpen) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *EyeOpen) SetConfidence(v float64) *EyeOpen {
	s.Confidence = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EyeOpen) SetValue(v bool) *EyeOpen {
	s.Value = &v
	return s
}

// Indicates whether or not the face is wearing eye glasses, and the confidence
// level in the determination.
type Eyeglasses struct {
	_ struct{} `type:"structure"`

	// Level of confidence in the determination.
	Confidence *float64 `type:"float"`

	// Boolean value that indicates whether the face is wearing eye glasses or not.
	Value *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Eyeglasses) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Eyeglasses) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *Eyeglasses) SetConfidence(v float64) *Eyeglasses {
	s.Confidence = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Eyeglasses) SetValue(v bool) *Eyeglasses {
	s.Value = &v
	return s
}

// Describes the face properties such as the bounding box, face ID, image ID
// of the input image, and external image ID that you assigned.
type Face struct {
	_ struct{} `type:"structure"`

	// Bounding box of the face.
	BoundingBox *BoundingBox `type:"structure"`

	// Confidence level that the bounding box contains a face (and not a different
	// object such as a tree).
	Confidence *float64 `type:"float"`

	// Identifier that you assign to all the faces in the input image.
	ExternalImageId *string `min:"1" type:"string"`

	// Unique identifier that Amazon Rekognition assigns to the face.
	FaceId *string `type:"string"`

	// Unique identifier that Amazon Rekognition assigns to the input image.
	ImageId *string `type:"string"`

	// The version of the face detect and storage model that was used when indexing
	// the face vector.
	IndexFacesModelVersion *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Face) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Face) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *Face) SetBoundingBox(v *BoundingBox) *Face {
	s.BoundingBox = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *Face) SetConfidence(v float64) *Face {
	s.Confidence = &v
	return s
}

// SetExternalImageId sets the ExternalImageId field's value.
func (s *Face) SetExternalImageId(v string) *Face {
	s.ExternalImageId = &v
	return s
}

// SetFaceId sets the FaceId field's value.
func (s *Face) SetFaceId(v string) *Face {
	s.FaceId = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *Face) SetImageId(v string) *Face {
	s.ImageId = &v
	return s
}

// SetIndexFacesModelVersion sets the IndexFacesModelVersion field's value.
func (s *Face) SetIndexFacesModelVersion(v string) *Face {
	s.IndexFacesModelVersion = &v
	return s
}

// Structure containing attributes of the face that the algorithm detected.
//
// A FaceDetail object contains either the default facial attributes or all
// facial attributes. The default attributes are BoundingBox, Confidence, Landmarks,
// Pose, and Quality.
//
// GetFaceDetection is the only Amazon Rekognition Video stored video operation
// that can return a FaceDetail object with all attributes. To specify which
// attributes to return, use the FaceAttributes input parameter for StartFaceDetection.
// The following Amazon Rekognition Video operations return only the default
// attributes. The corresponding Start operations don't have a FaceAttributes
// input parameter.
//
//    * GetCelebrityRecognition
//
//    * GetPersonTracking
//
//    * GetFaceSearch
//
// The Amazon Rekognition Image DetectFaces and IndexFaces operations can return
// all facial attributes. To specify which attributes to return, use the Attributes
// input parameter for DetectFaces. For IndexFaces, use the DetectAttributes
// input parameter.
type FaceDetail struct {
	_ struct{} `type:"structure"`

	// The estimated age range, in years, for the face. Low represents the lowest
	// estimated age and High represents the highest estimated age.
	AgeRange *AgeRange `type:"structure"`

	// Indicates whether or not the face has a beard, and the confidence level in
	// the determination.
	Beard *Beard `type:"structure"`

	// Bounding box of the face. Default attribute.
	BoundingBox *BoundingBox `type:"structure"`

	// Confidence level that the bounding box contains a face (and not a different
	// object such as a tree). Default attribute.
	Confidence *float64 `type:"float"`

	// The emotions that appear to be expressed on the face, and the confidence
	// level in the determination. The API is only making a determination of the
	// physical appearance of a person's face. It is not a determination of the
	// person’s internal emotional state and should not be used in such a way.
	// For example, a person pretending to have a sad face might not be sad emotionally.
	Emotions []*Emotion `type:"list"`

	// Indicates whether or not the face is wearing eye glasses, and the confidence
	// level in the determination.
	Eyeglasses *Eyeglasses `type:"structure"`

	// Indicates whether or not the eyes on the face are open, and the confidence
	// level in the determination.
	EyesOpen *EyeOpen `type:"structure"`

	// The predicted gender of a detected face.
	Gender *Gender `type:"structure"`

	// Indicates the location of landmarks on the face. Default attribute.
	Landmarks []*Landmark `type:"list"`

	// Indicates whether or not the mouth on the face is open, and the confidence
	// level in the determination.
	MouthOpen *MouthOpen `type:"structure"`

	// Indicates whether or not the face has a mustache, and the confidence level
	// in the determination.
	Mustache *Mustache `type:"structure"`

	// Indicates the pose of the face as determined by its pitch, roll, and yaw.
	// Default attribute.
	Pose *Pose `type:"structure"`

	// Identifies image brightness and sharpness. Default attribute.
	Quality *ImageQuality `type:"structure"`

	// Indicates whether or not the face is smiling, and the confidence level in
	// the determination.
	Smile *Smile `type:"structure"`

	// Indicates whether or not the face is wearing sunglasses, and the confidence
	// level in the determination.
	Sunglasses *Sunglasses `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaceDetail) GoString() string {
	return s.String()
}

// SetAgeRange sets the AgeRange field's value.
func (s *FaceDetail) SetAgeRange(v *AgeRange) *FaceDetail {
	s.AgeRange = v
	return s
}

// SetBeard sets the Beard field's value.
func (s *FaceDetail) SetBeard(v *Beard) *FaceDetail {
	s.Beard = v
	return s
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *FaceDetail) SetBoundingBox(v *BoundingBox) *FaceDetail {
	s.BoundingBox = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *FaceDetail) SetConfidence(v float64) *FaceDetail {
	s.Confidence = &v
	return s
}

// SetEmotions sets the Emotions field's value.
func (s *FaceDetail) SetEmotions(v []*Emotion) *FaceDetail {
	s.Emotions = v
	return s
}

// SetEyeglasses sets the Eyeglasses field's value.
func (s *FaceDetail) SetEyeglasses(v *Eyeglasses) *FaceDetail {
	s.Eyeglasses = v
	return s
}

// SetEyesOpen sets the EyesOpen field's value.
func (s *FaceDetail) SetEyesOpen(v *EyeOpen) *FaceDetail {
	s.EyesOpen = v
	return s
}

// SetGender sets the Gender field's value.
func (s *FaceDetail) SetGender(v *Gender) *FaceDetail {
	s.Gender = v
	return s
}

// SetLandmarks sets the Landmarks field's value.
func (s *FaceDetail) SetLandmarks(v []*Landmark) *FaceDetail {
	s.Landmarks = v
	return s
}

// SetMouthOpen sets the MouthOpen field's value.
func (s *FaceDetail) SetMouthOpen(v *MouthOpen) *FaceDetail {
	s.MouthOpen = v
	return s
}

// SetMustache sets the Mustache field's value.
func (s *FaceDetail) SetMustache(v *Mustache) *FaceDetail {
	s.Mustache = v
	return s
}

// SetPose sets the Pose field's value.
func (s *FaceDetail) SetPose(v *Pose) *FaceDetail {
	s.Pose = v
	return s
}

// SetQuality sets the Quality field's value.
func (s *FaceDetail) SetQuality(v *ImageQuality) *FaceDetail {
	s.Quality = v
	return s
}

// SetSmile sets the Smile field's value.
func (s *FaceDetail) SetSmile(v *Smile) *FaceDetail {
	s.Smile = v
	return s
}

// SetSunglasses sets the Sunglasses field's value.
func (s *FaceDetail) SetSunglasses(v *Sunglasses) *FaceDetail {
	s.Sunglasses = v
	return s
}

// Information about a face detected in a video analysis request and the time
// the face was detected in the video.
type FaceDetection struct {
	_ struct{} `type:"structure"`

	// The face properties for the detected face.
	Face *FaceDetail `type:"structure"`

	// Time, in milliseconds from the start of the video, that the face was detected.
	Timestamp *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaceDetection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaceDetection) GoString() string {
	return s.String()
}

// SetFace sets the Face field's value.
func (s *FaceDetection) SetFace(v *FaceDetail) *FaceDetection {
	s.Face = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *FaceDetection) SetTimestamp(v int64) *FaceDetection {
	s.Timestamp = &v
	return s
}

// Provides face metadata. In addition, it also provides the confidence in the
// match of this face with the input face.
type FaceMatch struct {
	_ struct{} `type:"structure"`

	// Describes the face properties such as the bounding box, face ID, image ID
	// of the source image, and external image ID that you assigned.
	Face *Face `type:"structure"`

	// Confidence in the match of this face with the input face.
	Similarity *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaceMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaceMatch) GoString() string {
	return s.String()
}

// SetFace sets the Face field's value.
func (s *FaceMatch) SetFace(v *Face) *FaceMatch {
	s.Face = v
	return s
}

// SetSimilarity sets the Similarity field's value.
func (s *FaceMatch) SetSimilarity(v float64) *FaceMatch {
	s.Similarity = &v
	return s
}

// Object containing both the face metadata (stored in the backend database),
// and facial attributes that are detected but aren't stored in the database.
type FaceRecord struct {
	_ struct{} `type:"structure"`

	// Describes the face properties such as the bounding box, face ID, image ID
	// of the input image, and external image ID that you assigned.
	Face *Face `type:"structure"`

	// Structure containing attributes of the face that the algorithm detected.
	FaceDetail *FaceDetail `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaceRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaceRecord) GoString() string {
	return s.String()
}

// SetFace sets the Face field's value.
func (s *FaceRecord) SetFace(v *Face) *FaceRecord {
	s.Face = v
	return s
}

// SetFaceDetail sets the FaceDetail field's value.
func (s *FaceRecord) SetFaceDetail(v *FaceDetail) *FaceRecord {
	s.FaceDetail = v
	return s
}

// Input face recognition parameters for an Amazon Rekognition stream processor.
// Includes the collection to use for face recognition and the face attributes
// to detect. Defining the settings is required in the request parameter for
// CreateStreamProcessor.
type FaceSearchSettings struct {
	_ struct{} `type:"structure"`

	// The ID of a collection that contains faces that you want to search for.
	CollectionId *string `min:"1" type:"string"`

	// Minimum face match confidence score that must be met to return a result for
	// a recognized face. The default is 80. 0 is the lowest confidence. 100 is
	// the highest confidence. Values between 0 and 100 are accepted, and values
	// lower than 80 are set to 80.
	FaceMatchThreshold *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaceSearchSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FaceSearchSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FaceSearchSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FaceSearchSettings"}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionId sets the CollectionId field's value.
func (s *FaceSearchSettings) SetCollectionId(v string) *FaceSearchSettings {
	s.CollectionId = &v
	return s
}

// SetFaceMatchThreshold sets the FaceMatchThreshold field's value.
func (s *FaceSearchSettings) SetFaceMatchThreshold(v float64) *FaceSearchSettings {
	s.FaceMatchThreshold = &v
	return s
}

// The predicted gender of a detected face.
//
// Amazon Rekognition makes gender binary (male/female) predictions based on
// the physical appearance of a face in a particular image. This kind of prediction
// is not designed to categorize a person’s gender identity, and you shouldn't
// use Amazon Rekognition to make such a determination. For example, a male
// actor wearing a long-haired wig and earrings for a role might be predicted
// as female.
//
// Using Amazon Rekognition to make gender binary predictions is best suited
// for use cases where aggregate gender distribution statistics need to be analyzed
// without identifying specific users. For example, the percentage of female
// users compared to male users on a social media platform.
//
// We don't recommend using gender binary predictions to make decisions that
// impact an individual's rights, privacy, or access to services.
type Gender struct {
	_ struct{} `type:"structure"`

	// Level of confidence in the prediction.
	Confidence *float64 `type:"float"`

	// The predicted gender of the face.
	Value *string `type:"string" enum:"GenderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Gender) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Gender) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *Gender) SetConfidence(v float64) *Gender {
	s.Confidence = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Gender) SetValue(v string) *Gender {
	s.Value = &v
	return s
}

// Information about where an object (DetectCustomLabels) or text (DetectText)
// is located on an image.
type Geometry struct {
	_ struct{} `type:"structure"`

	// An axis-aligned coarse representation of the detected item's location on
	// the image.
	BoundingBox *BoundingBox `type:"structure"`

	// Within the bounding box, a fine-grained polygon around the detected item.
	Polygon []*Point `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Geometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Geometry) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *Geometry) SetBoundingBox(v *BoundingBox) *Geometry {
	s.BoundingBox = v
	return s
}

// SetPolygon sets the Polygon field's value.
func (s *Geometry) SetPolygon(v []*Point) *Geometry {
	s.Polygon = v
	return s
}

type GetCelebrityInfoInput struct {
	_ struct{} `type:"structure"`

	// The ID for the celebrity. You get the celebrity ID from a call to the RecognizeCelebrities
	// operation, which recognizes celebrities in an image.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCelebrityInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCelebrityInfoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCelebrityInfoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCelebrityInfoInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetCelebrityInfoInput) SetId(v string) *GetCelebrityInfoInput {
	s.Id = &v
	return s
}

type GetCelebrityInfoOutput struct {
	_ struct{} `type:"structure"`

	// Retrieves the known gender for the celebrity.
	KnownGender *KnownGender `type:"structure"`

	// The name of the celebrity.
	Name *string `type:"string"`

	// An array of URLs pointing to additional celebrity information.
	Urls []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCelebrityInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCelebrityInfoOutput) GoString() string {
	return s.String()
}

// SetKnownGender sets the KnownGender field's value.
func (s *GetCelebrityInfoOutput) SetKnownGender(v *KnownGender) *GetCelebrityInfoOutput {
	s.KnownGender = v
	return s
}

// SetName sets the Name field's value.
func (s *GetCelebrityInfoOutput) SetName(v string) *GetCelebrityInfoOutput {
	s.Name = &v
	return s
}

// SetUrls sets the Urls field's value.
func (s *GetCelebrityInfoOutput) SetUrls(v []*string) *GetCelebrityInfoOutput {
	s.Urls = v
	return s
}

type GetCelebrityRecognitionInput struct {
	_ struct{} `type:"structure"`

	// Job identifier for the required celebrity recognition analysis. You can get
	// the job identifer from a call to StartCelebrityRecognition.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000. If you specify a value greater than 1000, a maximum
	// of 1000 results is returned. The default value is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more recognized
	// celebrities to retrieve), Amazon Rekognition Video returns a pagination token
	// in the response. You can use this pagination token to retrieve the next set
	// of celebrities.
	NextToken *string `type:"string"`

	// Sort to use for celebrities returned in Celebrities field. Specify ID to
	// sort by the celebrity identifier, specify TIMESTAMP to sort by the time the
	// celebrity was recognized.
	SortBy *string `type:"string" enum:"CelebrityRecognitionSortBy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCelebrityRecognitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCelebrityRecognitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCelebrityRecognitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCelebrityRecognitionInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetCelebrityRecognitionInput) SetJobId(v string) *GetCelebrityRecognitionInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetCelebrityRecognitionInput) SetMaxResults(v int64) *GetCelebrityRecognitionInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCelebrityRecognitionInput) SetNextToken(v string) *GetCelebrityRecognitionInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetCelebrityRecognitionInput) SetSortBy(v string) *GetCelebrityRecognitionInput {
	s.SortBy = &v
	return s
}

type GetCelebrityRecognitionOutput struct {
	_ struct{} `type:"structure"`

	// Array of celebrities recognized in the video.
	Celebrities []*CelebrityRecognition `type:"list"`

	// The current status of the celebrity recognition job.
	JobStatus *string `type:"string" enum:"VideoJobStatus"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of celebrities.
	NextToken *string `type:"string"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// Information about a video that Amazon Rekognition Video analyzed. Videometadata
	// is returned in every page of paginated responses from a Amazon Rekognition
	// Video operation.
	VideoMetadata *VideoMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCelebrityRecognitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCelebrityRecognitionOutput) GoString() string {
	return s.String()
}

// SetCelebrities sets the Celebrities field's value.
func (s *GetCelebrityRecognitionOutput) SetCelebrities(v []*CelebrityRecognition) *GetCelebrityRecognitionOutput {
	s.Celebrities = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetCelebrityRecognitionOutput) SetJobStatus(v string) *GetCelebrityRecognitionOutput {
	s.JobStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCelebrityRecognitionOutput) SetNextToken(v string) *GetCelebrityRecognitionOutput {
	s.NextToken = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetCelebrityRecognitionOutput) SetStatusMessage(v string) *GetCelebrityRecognitionOutput {
	s.StatusMessage = &v
	return s
}

// SetVideoMetadata sets the VideoMetadata field's value.
func (s *GetCelebrityRecognitionOutput) SetVideoMetadata(v *VideoMetadata) *GetCelebrityRecognitionOutput {
	s.VideoMetadata = v
	return s
}

type GetContentModerationInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the inappropriate, unwanted, or offensive content moderation
	// job. Use JobId to identify the job in a subsequent call to GetContentModeration.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000. If you specify a value greater than 1000, a maximum
	// of 1000 results is returned. The default value is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Rekognition returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of content moderation labels.
	NextToken *string `type:"string"`

	// Sort to use for elements in the ModerationLabelDetections array. Use TIMESTAMP
	// to sort array elements by the time labels are detected. Use NAME to alphabetically
	// group elements for a label together. Within each label group, the array element
	// are sorted by detection confidence. The default sort is by TIMESTAMP.
	SortBy *string `type:"string" enum:"ContentModerationSortBy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentModerationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentModerationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContentModerationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContentModerationInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetContentModerationInput) SetJobId(v string) *GetContentModerationInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetContentModerationInput) SetMaxResults(v int64) *GetContentModerationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetContentModerationInput) SetNextToken(v string) *GetContentModerationInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetContentModerationInput) SetSortBy(v string) *GetContentModerationInput {
	s.SortBy = &v
	return s
}

type GetContentModerationOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the content moderation analysis job.
	JobStatus *string `type:"string" enum:"VideoJobStatus"`

	// The detected inappropriate, unwanted, or offensive content moderation labels
	// and the time(s) they were detected.
	ModerationLabels []*ContentModerationDetection `type:"list"`

	// Version number of the moderation detection model that was used to detect
	// inappropriate, unwanted, or offensive content.
	ModerationModelVersion *string `type:"string"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of content
	// moderation labels.
	NextToken *string `type:"string"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// Information about a video that Amazon Rekognition analyzed. Videometadata
	// is returned in every page of paginated responses from GetContentModeration.
	VideoMetadata *VideoMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentModerationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetContentModerationOutput) GoString() string {
	return s.String()
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetContentModerationOutput) SetJobStatus(v string) *GetContentModerationOutput {
	s.JobStatus = &v
	return s
}

// SetModerationLabels sets the ModerationLabels field's value.
func (s *GetContentModerationOutput) SetModerationLabels(v []*ContentModerationDetection) *GetContentModerationOutput {
	s.ModerationLabels = v
	return s
}

// SetModerationModelVersion sets the ModerationModelVersion field's value.
func (s *GetContentModerationOutput) SetModerationModelVersion(v string) *GetContentModerationOutput {
	s.ModerationModelVersion = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetContentModerationOutput) SetNextToken(v string) *GetContentModerationOutput {
	s.NextToken = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetContentModerationOutput) SetStatusMessage(v string) *GetContentModerationOutput {
	s.StatusMessage = &v
	return s
}

// SetVideoMetadata sets the VideoMetadata field's value.
func (s *GetContentModerationOutput) SetVideoMetadata(v *VideoMetadata) *GetContentModerationOutput {
	s.VideoMetadata = v
	return s
}

type GetFaceDetectionInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the face detection job. The JobId is returned from
	// StartFaceDetection.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000. If you specify a value greater than 1000, a maximum
	// of 1000 results is returned. The default value is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more faces to
	// retrieve), Amazon Rekognition Video returns a pagination token in the response.
	// You can use this pagination token to retrieve the next set of faces.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFaceDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFaceDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFaceDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFaceDetectionInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetFaceDetectionInput) SetJobId(v string) *GetFaceDetectionInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetFaceDetectionInput) SetMaxResults(v int64) *GetFaceDetectionInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFaceDetectionInput) SetNextToken(v string) *GetFaceDetectionInput {
	s.NextToken = &v
	return s
}

type GetFaceDetectionOutput struct {
	_ struct{} `type:"structure"`

	// An array of faces detected in the video. Each element contains a detected
	// face's details and the time, in milliseconds from the start of the video,
	// the face was detected.
	Faces []*FaceDetection `type:"list"`

	// The current status of the face detection job.
	JobStatus *string `type:"string" enum:"VideoJobStatus"`

	// If the response is truncated, Amazon Rekognition returns this token that
	// you can use in the subsequent request to retrieve the next set of faces.
	NextToken *string `type:"string"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// Information about a video that Amazon Rekognition Video analyzed. Videometadata
	// is returned in every page of paginated responses from a Amazon Rekognition
	// video operation.
	VideoMetadata *VideoMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFaceDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFaceDetectionOutput) GoString() string {
	return s.String()
}

// SetFaces sets the Faces field's value.
func (s *GetFaceDetectionOutput) SetFaces(v []*FaceDetection) *GetFaceDetectionOutput {
	s.Faces = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetFaceDetectionOutput) SetJobStatus(v string) *GetFaceDetectionOutput {
	s.JobStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFaceDetectionOutput) SetNextToken(v string) *GetFaceDetectionOutput {
	s.NextToken = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetFaceDetectionOutput) SetStatusMessage(v string) *GetFaceDetectionOutput {
	s.StatusMessage = &v
	return s
}

// SetVideoMetadata sets the VideoMetadata field's value.
func (s *GetFaceDetectionOutput) SetVideoMetadata(v *VideoMetadata) *GetFaceDetectionOutput {
	s.VideoMetadata = v
	return s
}

type GetFaceSearchInput struct {
	_ struct{} `type:"structure"`

	// The job identifer for the search request. You get the job identifier from
	// an initial call to StartFaceSearch.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000. If you specify a value greater than 1000, a maximum
	// of 1000 results is returned. The default value is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more search results
	// to retrieve), Amazon Rekognition Video returns a pagination token in the
	// response. You can use this pagination token to retrieve the next set of search
	// results.
	NextToken *string `type:"string"`

	// Sort to use for grouping faces in the response. Use TIMESTAMP to group faces
	// by the time that they are recognized. Use INDEX to sort by recognized faces.
	SortBy *string `type:"string" enum:"FaceSearchSortBy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFaceSearchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFaceSearchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFaceSearchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFaceSearchInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetFaceSearchInput) SetJobId(v string) *GetFaceSearchInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetFaceSearchInput) SetMaxResults(v int64) *GetFaceSearchInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFaceSearchInput) SetNextToken(v string) *GetFaceSearchInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetFaceSearchInput) SetSortBy(v string) *GetFaceSearchInput {
	s.SortBy = &v
	return s
}

type GetFaceSearchOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the face search job.
	JobStatus *string `type:"string" enum:"VideoJobStatus"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of search
	// results.
	NextToken *string `type:"string"`

	// An array of persons, PersonMatch, in the video whose face(s) match the face(s)
	// in an Amazon Rekognition collection. It also includes time information for
	// when persons are matched in the video. You specify the input collection in
	// an initial call to StartFaceSearch. Each Persons element includes a time
	// the person was matched, face match details (FaceMatches) for matching faces
	// in the collection, and person information (Person) for the matched person.
	Persons []*PersonMatch `type:"list"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// Information about a video that Amazon Rekognition analyzed. Videometadata
	// is returned in every page of paginated responses from a Amazon Rekognition
	// Video operation.
	VideoMetadata *VideoMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFaceSearchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFaceSearchOutput) GoString() string {
	return s.String()
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetFaceSearchOutput) SetJobStatus(v string) *GetFaceSearchOutput {
	s.JobStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFaceSearchOutput) SetNextToken(v string) *GetFaceSearchOutput {
	s.NextToken = &v
	return s
}

// SetPersons sets the Persons field's value.
func (s *GetFaceSearchOutput) SetPersons(v []*PersonMatch) *GetFaceSearchOutput {
	s.Persons = v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetFaceSearchOutput) SetStatusMessage(v string) *GetFaceSearchOutput {
	s.StatusMessage = &v
	return s
}

// SetVideoMetadata sets the VideoMetadata field's value.
func (s *GetFaceSearchOutput) SetVideoMetadata(v *VideoMetadata) *GetFaceSearchOutput {
	s.VideoMetadata = v
	return s
}

type GetLabelDetectionInput struct {
	_ struct{} `type:"structure"`

	// Job identifier for the label detection operation for which you want results
	// returned. You get the job identifer from an initial call to StartlabelDetection.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000. If you specify a value greater than 1000, a maximum
	// of 1000 results is returned. The default value is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more labels to
	// retrieve), Amazon Rekognition Video returns a pagination token in the response.
	// You can use this pagination token to retrieve the next set of labels.
	NextToken *string `type:"string"`

	// Sort to use for elements in the Labels array. Use TIMESTAMP to sort array
	// elements by the time labels are detected. Use NAME to alphabetically group
	// elements for a label together. Within each label group, the array element
	// are sorted by detection confidence. The default sort is by TIMESTAMP.
	SortBy *string `type:"string" enum:"LabelDetectionSortBy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLabelDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLabelDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLabelDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLabelDetectionInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetLabelDetectionInput) SetJobId(v string) *GetLabelDetectionInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetLabelDetectionInput) SetMaxResults(v int64) *GetLabelDetectionInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetLabelDetectionInput) SetNextToken(v string) *GetLabelDetectionInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetLabelDetectionInput) SetSortBy(v string) *GetLabelDetectionInput {
	s.SortBy = &v
	return s
}

type GetLabelDetectionOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the label detection job.
	JobStatus *string `type:"string" enum:"VideoJobStatus"`

	// Version number of the label detection model that was used to detect labels.
	LabelModelVersion *string `type:"string"`

	// An array of labels detected in the video. Each element contains the detected
	// label and the time, in milliseconds from the start of the video, that the
	// label was detected.
	Labels []*LabelDetection `type:"list"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of labels.
	NextToken *string `type:"string"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// Information about a video that Amazon Rekognition Video analyzed. Videometadata
	// is returned in every page of paginated responses from a Amazon Rekognition
	// video operation.
	VideoMetadata *VideoMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLabelDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLabelDetectionOutput) GoString() string {
	return s.String()
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetLabelDetectionOutput) SetJobStatus(v string) *GetLabelDetectionOutput {
	s.JobStatus = &v
	return s
}

// SetLabelModelVersion sets the LabelModelVersion field's value.
func (s *GetLabelDetectionOutput) SetLabelModelVersion(v string) *GetLabelDetectionOutput {
	s.LabelModelVersion = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *GetLabelDetectionOutput) SetLabels(v []*LabelDetection) *GetLabelDetectionOutput {
	s.Labels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetLabelDetectionOutput) SetNextToken(v string) *GetLabelDetectionOutput {
	s.NextToken = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetLabelDetectionOutput) SetStatusMessage(v string) *GetLabelDetectionOutput {
	s.StatusMessage = &v
	return s
}

// SetVideoMetadata sets the VideoMetadata field's value.
func (s *GetLabelDetectionOutput) SetVideoMetadata(v *VideoMetadata) *GetLabelDetectionOutput {
	s.VideoMetadata = v
	return s
}

type GetPersonTrackingInput struct {
	_ struct{} `type:"structure"`

	// The identifier for a job that tracks persons in a video. You get the JobId
	// from a call to StartPersonTracking.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000. If you specify a value greater than 1000, a maximum
	// of 1000 results is returned. The default value is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more persons to
	// retrieve), Amazon Rekognition Video returns a pagination token in the response.
	// You can use this pagination token to retrieve the next set of persons.
	NextToken *string `type:"string"`

	// Sort to use for elements in the Persons array. Use TIMESTAMP to sort array
	// elements by the time persons are detected. Use INDEX to sort by the tracked
	// persons. If you sort by INDEX, the array elements for each person are sorted
	// by detection confidence. The default sort is by TIMESTAMP.
	SortBy *string `type:"string" enum:"PersonTrackingSortBy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPersonTrackingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPersonTrackingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPersonTrackingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPersonTrackingInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetPersonTrackingInput) SetJobId(v string) *GetPersonTrackingInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetPersonTrackingInput) SetMaxResults(v int64) *GetPersonTrackingInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetPersonTrackingInput) SetNextToken(v string) *GetPersonTrackingInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *GetPersonTrackingInput) SetSortBy(v string) *GetPersonTrackingInput {
	s.SortBy = &v
	return s
}

type GetPersonTrackingOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the person tracking job.
	JobStatus *string `type:"string" enum:"VideoJobStatus"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of persons.
	NextToken *string `type:"string"`

	// An array of the persons detected in the video and the time(s) their path
	// was tracked throughout the video. An array element will exist for each time
	// a person's path is tracked.
	Persons []*PersonDetection `type:"list"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// Information about a video that Amazon Rekognition Video analyzed. Videometadata
	// is returned in every page of paginated responses from a Amazon Rekognition
	// Video operation.
	VideoMetadata *VideoMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPersonTrackingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPersonTrackingOutput) GoString() string {
	return s.String()
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetPersonTrackingOutput) SetJobStatus(v string) *GetPersonTrackingOutput {
	s.JobStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetPersonTrackingOutput) SetNextToken(v string) *GetPersonTrackingOutput {
	s.NextToken = &v
	return s
}

// SetPersons sets the Persons field's value.
func (s *GetPersonTrackingOutput) SetPersons(v []*PersonDetection) *GetPersonTrackingOutput {
	s.Persons = v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetPersonTrackingOutput) SetStatusMessage(v string) *GetPersonTrackingOutput {
	s.StatusMessage = &v
	return s
}

// SetVideoMetadata sets the VideoMetadata field's value.
func (s *GetPersonTrackingOutput) SetVideoMetadata(v *VideoMetadata) *GetPersonTrackingOutput {
	s.VideoMetadata = v
	return s
}

type GetSegmentDetectionInput struct {
	_ struct{} `type:"structure"`

	// Job identifier for the text detection operation for which you want results
	// returned. You get the job identifer from an initial call to StartSegmentDetection.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of text.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSegmentDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSegmentDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSegmentDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSegmentDetectionInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetSegmentDetectionInput) SetJobId(v string) *GetSegmentDetectionInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetSegmentDetectionInput) SetMaxResults(v int64) *GetSegmentDetectionInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetSegmentDetectionInput) SetNextToken(v string) *GetSegmentDetectionInput {
	s.NextToken = &v
	return s
}

type GetSegmentDetectionOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects. There can be multiple audio streams. Each AudioMetadata
	// object contains metadata for a single audio stream. Audio information in
	// an AudioMetadata objects includes the audio codec, the number of audio channels,
	// the duration of the audio stream, and the sample rate. Audio metadata is
	// returned in each page of information returned by GetSegmentDetection.
	AudioMetadata []*AudioMetadata `type:"list"`

	// Current status of the segment detection job.
	JobStatus *string `type:"string" enum:"VideoJobStatus"`

	// If the previous response was incomplete (because there are more labels to
	// retrieve), Amazon Rekognition Video returns a pagination token in the response.
	// You can use this pagination token to retrieve the next set of text.
	NextToken *string `type:"string"`

	// An array of segments detected in a video. The array is sorted by the segment
	// types (TECHNICAL_CUE or SHOT) specified in the SegmentTypes input parameter
	// of StartSegmentDetection. Within each segment type the array is sorted by
	// timestamp values.
	Segments []*SegmentDetection `type:"list"`

	// An array containing the segment types requested in the call to StartSegmentDetection.
	SelectedSegmentTypes []*SegmentTypeInfo `type:"list"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// Currently, Amazon Rekognition Video returns a single object in the VideoMetadata
	// array. The object contains information about the video stream in the input
	// file that Amazon Rekognition Video chose to analyze. The VideoMetadata object
	// includes the video codec, video format and other information. Video metadata
	// is returned in each page of information returned by GetSegmentDetection.
	VideoMetadata []*VideoMetadata `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSegmentDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSegmentDetectionOutput) GoString() string {
	return s.String()
}

// SetAudioMetadata sets the AudioMetadata field's value.
func (s *GetSegmentDetectionOutput) SetAudioMetadata(v []*AudioMetadata) *GetSegmentDetectionOutput {
	s.AudioMetadata = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetSegmentDetectionOutput) SetJobStatus(v string) *GetSegmentDetectionOutput {
	s.JobStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetSegmentDetectionOutput) SetNextToken(v string) *GetSegmentDetectionOutput {
	s.NextToken = &v
	return s
}

// SetSegments sets the Segments field's value.
func (s *GetSegmentDetectionOutput) SetSegments(v []*SegmentDetection) *GetSegmentDetectionOutput {
	s.Segments = v
	return s
}

// SetSelectedSegmentTypes sets the SelectedSegmentTypes field's value.
func (s *GetSegmentDetectionOutput) SetSelectedSegmentTypes(v []*SegmentTypeInfo) *GetSegmentDetectionOutput {
	s.SelectedSegmentTypes = v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetSegmentDetectionOutput) SetStatusMessage(v string) *GetSegmentDetectionOutput {
	s.StatusMessage = &v
	return s
}

// SetVideoMetadata sets the VideoMetadata field's value.
func (s *GetSegmentDetectionOutput) SetVideoMetadata(v []*VideoMetadata) *GetSegmentDetectionOutput {
	s.VideoMetadata = v
	return s
}

type GetTextDetectionInput struct {
	_ struct{} `type:"structure"`

	// Job identifier for the text detection operation for which you want results
	// returned. You get the job identifer from an initial call to StartTextDetection.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// Maximum number of results to return per paginated call. The largest value
	// you can specify is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more labels to
	// retrieve), Amazon Rekognition Video returns a pagination token in the response.
	// You can use this pagination token to retrieve the next set of text.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTextDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTextDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTextDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTextDetectionInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetTextDetectionInput) SetJobId(v string) *GetTextDetectionInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetTextDetectionInput) SetMaxResults(v int64) *GetTextDetectionInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTextDetectionInput) SetNextToken(v string) *GetTextDetectionInput {
	s.NextToken = &v
	return s
}

type GetTextDetectionOutput struct {
	_ struct{} `type:"structure"`

	// Current status of the text detection job.
	JobStatus *string `type:"string" enum:"VideoJobStatus"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of text.
	NextToken *string `type:"string"`

	// If the job fails, StatusMessage provides a descriptive error message.
	StatusMessage *string `type:"string"`

	// An array of text detected in the video. Each element contains the detected
	// text, the time in milliseconds from the start of the video that the text
	// was detected, and where it was detected on the screen.
	TextDetections []*TextDetectionResult `type:"list"`

	// Version number of the text detection model that was used to detect text.
	TextModelVersion *string `type:"string"`

	// Information about a video that Amazon Rekognition analyzed. Videometadata
	// is returned in every page of paginated responses from a Amazon Rekognition
	// video operation.
	VideoMetadata *VideoMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTextDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTextDetectionOutput) GoString() string {
	return s.String()
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetTextDetectionOutput) SetJobStatus(v string) *GetTextDetectionOutput {
	s.JobStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTextDetectionOutput) SetNextToken(v string) *GetTextDetectionOutput {
	s.NextToken = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetTextDetectionOutput) SetStatusMessage(v string) *GetTextDetectionOutput {
	s.StatusMessage = &v
	return s
}

// SetTextDetections sets the TextDetections field's value.
func (s *GetTextDetectionOutput) SetTextDetections(v []*TextDetectionResult) *GetTextDetectionOutput {
	s.TextDetections = v
	return s
}

// SetTextModelVersion sets the TextModelVersion field's value.
func (s *GetTextDetectionOutput) SetTextModelVersion(v string) *GetTextDetectionOutput {
	s.TextModelVersion = &v
	return s
}

// SetVideoMetadata sets the VideoMetadata field's value.
func (s *GetTextDetectionOutput) SetVideoMetadata(v *VideoMetadata) *GetTextDetectionOutput {
	s.VideoMetadata = v
	return s
}

// The S3 bucket that contains an Amazon Sagemaker Ground Truth format manifest
// file.
type GroundTruthManifest struct {
	_ struct{} `type:"structure"`

	// Provides the S3 bucket name and object name.
	//
	// The region for the S3 bucket containing the S3 object must match the region
	// you use for Amazon Rekognition operations.
	//
	// For Amazon Rekognition to process an S3 object, the user must have permission
	// to access the S3 object. For more information, see How Amazon Rekognition
	// works with IAM in the Amazon Rekognition Developer Guide.
	S3Object *S3Object `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroundTruthManifest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroundTruthManifest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroundTruthManifest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GroundTruthManifest"}
	if s.S3Object != nil {
		if err := s.S3Object.Validate(); err != nil {
			invalidParams.AddNested("S3Object", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Object sets the S3Object field's value.
func (s *GroundTruthManifest) SetS3Object(v *S3Object) *GroundTruthManifest {
	s.S3Object = v
	return s
}

// Shows the results of the human in the loop evaluation. If there is no HumanLoopArn,
// the input did not trigger human review.
type HumanLoopActivationOutput struct {
	_ struct{} `type:"structure"`

	// Shows the result of condition evaluations, including those conditions which
	// activated a human review.
	HumanLoopActivationConditionsEvaluationResults aws.JSONValue `type:"jsonvalue"`

	// Shows if and why human review was needed.
	HumanLoopActivationReasons []*string `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the HumanLoop created.
	HumanLoopArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopActivationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopActivationOutput) GoString() string {
	return s.String()
}

// SetHumanLoopActivationConditionsEvaluationResults sets the HumanLoopActivationConditionsEvaluationResults field's value.
func (s *HumanLoopActivationOutput) SetHumanLoopActivationConditionsEvaluationResults(v aws.JSONValue) *HumanLoopActivationOutput {
	s.HumanLoopActivationConditionsEvaluationResults = v
	return s
}

// SetHumanLoopActivationReasons sets the HumanLoopActivationReasons field's value.
func (s *HumanLoopActivationOutput) SetHumanLoopActivationReasons(v []*string) *HumanLoopActivationOutput {
	s.HumanLoopActivationReasons = v
	return s
}

// SetHumanLoopArn sets the HumanLoopArn field's value.
func (s *HumanLoopActivationOutput) SetHumanLoopArn(v string) *HumanLoopActivationOutput {
	s.HumanLoopArn = &v
	return s
}

// Sets up the flow definition the image will be sent to if one of the conditions
// is met. You can also set certain attributes of the image before review.
type HumanLoopConfig struct {
	_ struct{} `type:"structure"`

	// Sets attributes of the input data.
	DataAttributes *HumanLoopDataAttributes `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow definition. You can create a flow
	// definition by using the Amazon Sagemaker CreateFlowDefinition (https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateFlowDefinition.html)
	// Operation.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`

	// The name of the human review used for this image. This should be kept unique
	// within a region.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanLoopConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HumanLoopConfig"}
	if s.FlowDefinitionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowDefinitionArn"))
	}
	if s.HumanLoopName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanLoopName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAttributes sets the DataAttributes field's value.
func (s *HumanLoopConfig) SetDataAttributes(v *HumanLoopDataAttributes) *HumanLoopConfig {
	s.DataAttributes = v
	return s
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *HumanLoopConfig) SetFlowDefinitionArn(v string) *HumanLoopConfig {
	s.FlowDefinitionArn = &v
	return s
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *HumanLoopConfig) SetHumanLoopName(v string) *HumanLoopConfig {
	s.HumanLoopName = &v
	return s
}

// Allows you to set attributes of the image. Currently, you can declare an
// image as free of personally identifiable information.
type HumanLoopDataAttributes struct {
	_ struct{} `type:"structure"`

	// Sets whether the input image is free of personally identifiable information.
	ContentClassifiers []*string `type:"list" enum:"ContentClassifier"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopDataAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopDataAttributes) GoString() string {
	return s.String()
}

// SetContentClassifiers sets the ContentClassifiers field's value.
func (s *HumanLoopDataAttributes) SetContentClassifiers(v []*string) *HumanLoopDataAttributes {
	s.ContentClassifiers = v
	return s
}

// The number of in-progress human reviews you have has exceeded the number
// allowed.
type HumanLoopQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The quota code.
	QuotaCode *string `type:"string"`

	// The resource type.
	ResourceType *string `type:"string"`

	// The service code.
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorHumanLoopQuotaExceededException(v protocol.ResponseMetadata) error {
	return &HumanLoopQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *HumanLoopQuotaExceededException) Code() string {
	return "HumanLoopQuotaExceededException"
}

// Message returns the exception's message.
func (s *HumanLoopQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *HumanLoopQuotaExceededException) OrigErr() error {
	return nil
}

func (s *HumanLoopQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *HumanLoopQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *HumanLoopQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A ClientRequestToken input parameter was reused with an operation, but at
// least one of the other input parameters is different from the previous call
// to the operation.
type IdempotentParameterMismatchException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotentParameterMismatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotentParameterMismatchException) GoString() string {
	return s.String()
}

func newErrorIdempotentParameterMismatchException(v protocol.ResponseMetadata) error {
	return &IdempotentParameterMismatchException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IdempotentParameterMismatchException) Code() string {
	return "IdempotentParameterMismatchException"
}

// Message returns the exception's message.
func (s *IdempotentParameterMismatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IdempotentParameterMismatchException) OrigErr() error {
	return nil
}

func (s *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IdempotentParameterMismatchException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IdempotentParameterMismatchException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides the input image either as bytes or an S3 object.
//
// You pass image bytes to an Amazon Rekognition API operation by using the
// Bytes property. For example, you would use the Bytes property to pass an
// image loaded from a local file system. Image bytes passed by using the Bytes
// property must be base64-encoded. Your code may not need to encode image bytes
// if you are using an AWS SDK to call Amazon Rekognition API operations.
//
// For more information, see Analyzing an Image Loaded from a Local File System
// in the Amazon Rekognition Developer Guide.
//
// You pass images stored in an S3 bucket to an Amazon Rekognition API operation
// by using the S3Object property. Images stored in an S3 bucket do not need
// to be base64-encoded.
//
// The region for the S3 bucket containing the S3 object must match the region
// you use for Amazon Rekognition operations.
//
// If you use the AWS CLI to call Amazon Rekognition operations, passing image
// bytes using the Bytes property is not supported. You must first upload the
// image to an Amazon S3 bucket and then call the operation using the S3Object
// property.
//
// For Amazon Rekognition to process an S3 object, the user must have permission
// to access the S3 object. For more information, see How Amazon Rekognition
// works with IAM in the Amazon Rekognition Developer Guide.
type Image struct {
	_ struct{} `type:"structure"`

	// Blob of image bytes up to 5 MBs.
	// Bytes is automatically base64 encoded/decoded by the SDK.
	Bytes []byte `min:"1" type:"blob"`

	// Identifies an S3 object as the image source.
	S3Object *S3Object `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Image) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Image) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Image"}
	if s.Bytes != nil && len(s.Bytes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bytes", 1))
	}
	if s.S3Object != nil {
		if err := s.S3Object.Validate(); err != nil {
			invalidParams.AddNested("S3Object", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBytes sets the Bytes field's value.
func (s *Image) SetBytes(v []byte) *Image {
	s.Bytes = v
	return s
}

// SetS3Object sets the S3Object field's value.
func (s *Image) SetS3Object(v *S3Object) *Image {
	s.S3Object = v
	return s
}

// Identifies face image brightness and sharpness.
type ImageQuality struct {
	_ struct{} `type:"structure"`

	// Value representing brightness of the face. The service returns a value between
	// 0 and 100 (inclusive). A higher value indicates a brighter face image.
	Brightness *float64 `type:"float"`

	// Value representing sharpness of the face. The service returns a value between
	// 0 and 100 (inclusive). A higher value indicates a sharper face image.
	Sharpness *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageQuality) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageQuality) GoString() string {
	return s.String()
}

// SetBrightness sets the Brightness field's value.
func (s *ImageQuality) SetBrightness(v float64) *ImageQuality {
	s.Brightness = &v
	return s
}

// SetSharpness sets the Sharpness field's value.
func (s *ImageQuality) SetSharpness(v float64) *ImageQuality {
	s.Sharpness = &v
	return s
}

// The input image size exceeds the allowed limit. If you are calling DetectProtectiveEquipment,
// the image size or resolution exceeds the allowed limit. For more information,
// see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
// Developer Guide.
type ImageTooLargeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageTooLargeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImageTooLargeException) GoString() string {
	return s.String()
}

func newErrorImageTooLargeException(v protocol.ResponseMetadata) error {
	return &ImageTooLargeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ImageTooLargeException) Code() string {
	return "ImageTooLargeException"
}

// Message returns the exception's message.
func (s *ImageTooLargeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ImageTooLargeException) OrigErr() error {
	return nil
}

func (s *ImageTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ImageTooLargeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ImageTooLargeException) RequestID() string {
	return s.RespMetadata.RequestID
}

type IndexFacesInput struct {
	_ struct{} `type:"structure"`

	// The ID of an existing collection to which you want to add the faces that
	// are detected in the input images.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`

	// An array of facial attributes that you want to be returned. This can be the
	// default list of attributes or all attributes. If you don't specify a value
	// for Attributes or if you specify ["DEFAULT"], the API returns the following
	// subset of facial attributes: BoundingBox, Confidence, Pose, Quality, and
	// Landmarks. If you provide ["ALL"], all facial attributes are returned, but
	// the operation takes longer to complete.
	//
	// If you provide both, ["ALL", "DEFAULT"], the service uses a logical AND operator
	// to determine which attributes to return (in this case, all attributes).
	DetectionAttributes []*string `type:"list" enum:"Attribute"`

	// The ID you want to assign to all the faces detected in the image.
	ExternalImageId *string `min:"1" type:"string"`

	// The input image as base64-encoded bytes or an S3 object. If you use the AWS
	// CLI to call Amazon Rekognition operations, passing base64-encoded image bytes
	// isn't supported.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`

	// The maximum number of faces to index. The value of MaxFaces must be greater
	// than or equal to 1. IndexFaces returns no more than 100 detected faces in
	// an image, even if you specify a larger value for MaxFaces.
	//
	// If IndexFaces detects more faces than the value of MaxFaces, the faces with
	// the lowest quality are filtered out first. If there are still more faces
	// than the value of MaxFaces, the faces with the smallest bounding boxes are
	// filtered out (up to the number that's needed to satisfy the value of MaxFaces).
	// Information about the unindexed faces is available in the UnindexedFaces
	// array.
	//
	// The faces that are returned by IndexFaces are sorted by the largest face
	// bounding box size to the smallest size, in descending order.
	//
	// MaxFaces can be used with a collection associated with any version of the
	// face model.
	MaxFaces *int64 `min:"1" type:"integer"`

	// A filter that specifies a quality bar for how much filtering is done to identify
	// faces. Filtered faces aren't indexed. If you specify AUTO, Amazon Rekognition
	// chooses the quality bar. If you specify LOW, MEDIUM, or HIGH, filtering removes
	// all faces that don’t meet the chosen quality bar. The default value is
	// AUTO. The quality bar is based on a variety of common use cases. Low-quality
	// detections can occur for a number of reasons. Some examples are an object
	// that's misidentified as a face, a face that's too blurry, or a face with
	// a pose that's too extreme to use. If you specify NONE, no filtering is performed.
	//
	// To use quality filtering, the collection you are using must be associated
	// with version 3 of the face model or higher.
	QualityFilter *string `type:"string" enum:"QualityFilter"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexFacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexFacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IndexFacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IndexFacesInput"}
	if s.CollectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionId", 1))
	}
	if s.ExternalImageId != nil && len(*s.ExternalImageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalImageId", 1))
	}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.MaxFaces != nil && *s.MaxFaces < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxFaces", 1))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionId sets the CollectionId field's value.
func (s *IndexFacesInput) SetCollectionId(v string) *IndexFacesInput {
	s.CollectionId = &v
	return s
}

// SetDetectionAttributes sets the DetectionAttributes field's value.
func (s *IndexFacesInput) SetDetectionAttributes(v []*string) *IndexFacesInput {
	s.DetectionAttributes = v
	return s
}

// SetExternalImageId sets the ExternalImageId field's value.
func (s *IndexFacesInput) SetExternalImageId(v string) *IndexFacesInput {
	s.ExternalImageId = &v
	return s
}

// SetImage sets the Image field's value.
func (s *IndexFacesInput) SetImage(v *Image) *IndexFacesInput {
	s.Image = v
	return s
}

// SetMaxFaces sets the MaxFaces field's value.
func (s *IndexFacesInput) SetMaxFaces(v int64) *IndexFacesInput {
	s.MaxFaces = &v
	return s
}

// SetQualityFilter sets the QualityFilter field's value.
func (s *IndexFacesInput) SetQualityFilter(v string) *IndexFacesInput {
	s.QualityFilter = &v
	return s
}

type IndexFacesOutput struct {
	_ struct{} `type:"structure"`

	// The version number of the face detection model that's associated with the
	// input collection (CollectionId).
	FaceModelVersion *string `type:"string"`

	// An array of faces detected and added to the collection. For more information,
	// see Searching Faces in a Collection in the Amazon Rekognition Developer Guide.
	FaceRecords []*FaceRecord `type:"list"`

	// If your collection is associated with a face detection model that's later
	// than version 3.0, the value of OrientationCorrection is always null and no
	// orientation information is returned.
	//
	// If your collection is associated with a face detection model that's version
	// 3.0 or earlier, the following applies:
	//
	//    * If the input image is in .jpeg format, it might contain exchangeable
	//    image file format (Exif) metadata that includes the image's orientation.
	//    Amazon Rekognition uses this orientation information to perform image
	//    correction - the bounding box coordinates are translated to represent
	//    object locations after the orientation information in the Exif metadata
	//    is used to correct the image orientation. Images in .png format don't
	//    contain Exif metadata. The value of OrientationCorrection is null.
	//
	//    * If the image doesn't contain orientation information in its Exif metadata,
	//    Amazon Rekognition returns an estimated orientation (ROTATE_0, ROTATE_90,
	//    ROTATE_180, ROTATE_270). Amazon Rekognition doesn’t perform image correction
	//    for images. The bounding box coordinates aren't translated and represent
	//    the object locations before the image is rotated.
	//
	// Bounding box information is returned in the FaceRecords array. You can get
	// the version of the face detection model by calling DescribeCollection.
	OrientationCorrection *string `type:"string" enum:"OrientationCorrection"`

	// An array of faces that were detected in the image but weren't indexed. They
	// weren't indexed because the quality filter identified them as low quality,
	// or the MaxFaces request parameter filtered them out. To use the quality filter,
	// you specify the QualityFilter request parameter.
	UnindexedFaces []*UnindexedFace `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexFacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IndexFacesOutput) GoString() string {
	return s.String()
}

// SetFaceModelVersion sets the FaceModelVersion field's value.
func (s *IndexFacesOutput) SetFaceModelVersion(v string) *IndexFacesOutput {
	s.FaceModelVersion = &v
	return s
}

// SetFaceRecords sets the FaceRecords field's value.
func (s *IndexFacesOutput) SetFaceRecords(v []*FaceRecord) *IndexFacesOutput {
	s.FaceRecords = v
	return s
}

// SetOrientationCorrection sets the OrientationCorrection field's value.
func (s *IndexFacesOutput) SetOrientationCorrection(v string) *IndexFacesOutput {
	s.OrientationCorrection = &v
	return s
}

// SetUnindexedFaces sets the UnindexedFaces field's value.
func (s *IndexFacesOutput) SetUnindexedFaces(v []*UnindexedFace) *IndexFacesOutput {
	s.UnindexedFaces = v
	return s
}

// An instance of a label returned by Amazon Rekognition Image (DetectLabels)
// or by Amazon Rekognition Video (GetLabelDetection).
type Instance struct {
	_ struct{} `type:"structure"`

	// The position of the label instance on the image.
	BoundingBox *BoundingBox `type:"structure"`

	// The confidence that Amazon Rekognition has in the accuracy of the bounding
	// box.
	Confidence *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Instance) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *Instance) SetBoundingBox(v *BoundingBox) *Instance {
	s.BoundingBox = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *Instance) SetConfidence(v float64) *Instance {
	s.Confidence = &v
	return s
}

// Amazon Rekognition experienced a service issue. Try your call again.
type InternalServerError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) GoString() string {
	return s.String()
}

func newErrorInternalServerError(v protocol.ResponseMetadata) error {
	return &InternalServerError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerError) Code() string {
	return "InternalServerError"
}

// Message returns the exception's message.
func (s *InternalServerError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerError) OrigErr() error {
	return nil
}

func (s *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerError) RequestID() string {
	return s.RespMetadata.RequestID
}

// The provided image format is not supported.
type InvalidImageFormatException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidImageFormatException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidImageFormatException) GoString() string {
	return s.String()
}

func newErrorInvalidImageFormatException(v protocol.ResponseMetadata) error {
	return &InvalidImageFormatException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidImageFormatException) Code() string {
	return "InvalidImageFormatException"
}

// Message returns the exception's message.
func (s *InvalidImageFormatException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidImageFormatException) OrigErr() error {
	return nil
}

func (s *InvalidImageFormatException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidImageFormatException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidImageFormatException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Pagination token in the request is not valid.
type InvalidPaginationTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidPaginationTokenException(v protocol.ResponseMetadata) error {
	return &InvalidPaginationTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPaginationTokenException) Code() string {
	return "InvalidPaginationTokenException"
}

// Message returns the exception's message.
func (s *InvalidPaginationTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPaginationTokenException) OrigErr() error {
	return nil
}

func (s *InvalidPaginationTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPaginationTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPaginationTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Input parameter violated a constraint. Validate your parameter before calling
// the API operation again.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Amazon Rekognition is unable to access the S3 object specified in the request.
type InvalidS3ObjectException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3ObjectException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3ObjectException) GoString() string {
	return s.String()
}

func newErrorInvalidS3ObjectException(v protocol.ResponseMetadata) error {
	return &InvalidS3ObjectException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidS3ObjectException) Code() string {
	return "InvalidS3ObjectException"
}

// Message returns the exception's message.
func (s *InvalidS3ObjectException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidS3ObjectException) OrigErr() error {
	return nil
}

func (s *InvalidS3ObjectException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidS3ObjectException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidS3ObjectException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Kinesis data stream Amazon Rekognition to which the analysis results
// of a Amazon Rekognition stream processor are streamed. For more information,
// see CreateStreamProcessor in the Amazon Rekognition Developer Guide.
type KinesisDataStream struct {
	_ struct{} `type:"structure"`

	// ARN of the output Amazon Kinesis Data Streams stream.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisDataStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisDataStream) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *KinesisDataStream) SetArn(v string) *KinesisDataStream {
	s.Arn = &v
	return s
}

// Kinesis video stream stream that provides the source streaming video for
// a Amazon Rekognition Video stream processor. For more information, see CreateStreamProcessor
// in the Amazon Rekognition Developer Guide.
type KinesisVideoStream struct {
	_ struct{} `type:"structure"`

	// ARN of the Kinesis video stream stream that streams the source video.
	Arn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisVideoStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisVideoStream) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *KinesisVideoStream) SetArn(v string) *KinesisVideoStream {
	s.Arn = &v
	return s
}

// Specifies the starting point in a Kinesis stream to start processing. You
// can use the producer timestamp or the fragment number. For more information,
// see Fragment (https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html).
type KinesisVideoStreamStartSelector struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the fragment. This value monotonically increases
	// based on the ingestion order.
	FragmentNumber *string `min:"1" type:"string"`

	// The timestamp from the producer corresponding to the fragment.
	ProducerTimestamp *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisVideoStreamStartSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisVideoStreamStartSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisVideoStreamStartSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisVideoStreamStartSelector"}
	if s.FragmentNumber != nil && len(*s.FragmentNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FragmentNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFragmentNumber sets the FragmentNumber field's value.
func (s *KinesisVideoStreamStartSelector) SetFragmentNumber(v string) *KinesisVideoStreamStartSelector {
	s.FragmentNumber = &v
	return s
}

// SetProducerTimestamp sets the ProducerTimestamp field's value.
func (s *KinesisVideoStreamStartSelector) SetProducerTimestamp(v int64) *KinesisVideoStreamStartSelector {
	s.ProducerTimestamp = &v
	return s
}

// The known gender identity for the celebrity that matches the provided ID.
// The known gender identity can be Male, Female, Nonbinary, or Unlisted.
type KnownGender struct {
	_ struct{} `type:"structure"`

	// A string value of the KnownGender info about the Celebrity.
	Type *string `type:"string" enum:"KnownGenderType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnownGender) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnownGender) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *KnownGender) SetType(v string) *KnownGender {
	s.Type = &v
	return s
}

// Structure containing details about the detected label, including the name,
// detected instances, parent labels, and level of confidence.
type Label struct {
	_ struct{} `type:"structure"`

	// Level of confidence.
	Confidence *float64 `type:"float"`

	// If Label represents an object, Instances contains the bounding boxes for
	// each instance of the detected object. Bounding boxes are returned for common
	// object labels such as people, cars, furniture, apparel or pets.
	Instances []*Instance `type:"list"`

	// The name (label) of the object or scene.
	Name *string `type:"string"`

	// The parent labels for a label. The response includes all ancestor labels.
	Parents []*Parent `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Label) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Label) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *Label) SetConfidence(v float64) *Label {
	s.Confidence = &v
	return s
}

// SetInstances sets the Instances field's value.
func (s *Label) SetInstances(v []*Instance) *Label {
	s.Instances = v
	return s
}

// SetName sets the Name field's value.
func (s *Label) SetName(v string) *Label {
	s.Name = &v
	return s
}

// SetParents sets the Parents field's value.
func (s *Label) SetParents(v []*Parent) *Label {
	s.Parents = v
	return s
}

// Information about a label detected in a video analysis request and the time
// the label was detected in the video.
type LabelDetection struct {
	_ struct{} `type:"structure"`

	// Details about the detected label.
	Label *Label `type:"structure"`

	// Time, in milliseconds from the start of the video, that the label was detected.
	Timestamp *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelDetection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LabelDetection) GoString() string {
	return s.String()
}

// SetLabel sets the Label field's value.
func (s *LabelDetection) SetLabel(v *Label) *LabelDetection {
	s.Label = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *LabelDetection) SetTimestamp(v int64) *LabelDetection {
	s.Timestamp = &v
	return s
}

// Indicates the location of the landmark on the face.
type Landmark struct {
	_ struct{} `type:"structure"`

	// Type of landmark.
	Type *string `type:"string" enum:"LandmarkType"`

	// The x-coordinate of the landmark expressed as a ratio of the width of the
	// image. The x-coordinate is measured from the left-side of the image. For
	// example, if the image is 700 pixels wide and the x-coordinate of the landmark
	// is at 350 pixels, this value is 0.5.
	X *float64 `type:"float"`

	// The y-coordinate of the landmark expressed as a ratio of the height of the
	// image. The y-coordinate is measured from the top of the image. For example,
	// if the image height is 200 pixels and the y-coordinate of the landmark is
	// at 50 pixels, this value is 0.25.
	Y *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Landmark) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Landmark) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *Landmark) SetType(v string) *Landmark {
	s.Type = &v
	return s
}

// SetX sets the X field's value.
func (s *Landmark) SetX(v float64) *Landmark {
	s.X = &v
	return s
}

// SetY sets the Y field's value.
func (s *Landmark) SetY(v float64) *Landmark {
	s.Y = &v
	return s
}

// An Amazon Rekognition service limit was exceeded. For example, if you start
// too many Amazon Rekognition Video jobs concurrently, calls to start operations
// (StartLabelDetection, for example) will raise a LimitExceededException exception
// (HTTP status code: 400) until the number of concurrently running jobs is
// below the Amazon Rekognition service limit.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCollectionsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of collection IDs to return.
	MaxResults *int64 `type:"integer"`

	// Pagination token from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectionsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCollectionsInput) SetMaxResults(v int64) *ListCollectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollectionsInput) SetNextToken(v string) *ListCollectionsInput {
	s.NextToken = &v
	return s
}

type ListCollectionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of collection IDs.
	CollectionIds []*string `type:"list"`

	// Version numbers of the face detection models associated with the collections
	// in the array CollectionIds. For example, the value of FaceModelVersions[2]
	// is the version number for the face detection model used by the collection
	// in CollectionId[2].
	FaceModelVersions []*string `type:"list"`

	// If the result is truncated, the response provides a NextToken that you can
	// use in the subsequent request to fetch the next set of collection IDs.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCollectionsOutput) GoString() string {
	return s.String()
}

// SetCollectionIds sets the CollectionIds field's value.
func (s *ListCollectionsOutput) SetCollectionIds(v []*string) *ListCollectionsOutput {
	s.CollectionIds = v
	return s
}

// SetFaceModelVersions sets the FaceModelVersions field's value.
func (s *ListCollectionsOutput) SetFaceModelVersions(v []*string) *ListCollectionsOutput {
	s.FaceModelVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCollectionsOutput) SetNextToken(v string) *ListCollectionsOutput {
	s.NextToken = &v
	return s
}

type ListDatasetEntriesInput struct {
	_ struct{} `type:"structure"`

	// Specifies a label filter for the response. The response includes an entry
	// only if one or more of the labels in ContainsLabels exist in the entry.
	ContainsLabels []*string `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) for the dataset that you want to use.
	//
	// DatasetArn is a required field
	DatasetArn *string `min:"20" type:"string" required:"true"`

	// Specifies an error filter for the response. Specify True to only include
	// entries that have errors.
	HasErrors *bool `type:"boolean"`

	// Specify true to get only the JSON Lines where the image is labeled. Specify
	// false to get only the JSON Lines where the image isn't labeled. If you don't
	// specify Labeled, ListDatasetEntries returns JSON Lines for labeled and unlabeled
	// images.
	Labeled *bool `type:"boolean"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 100. If you specify a value greater than 100, a ValidationException
	// error occurs. The default value is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in
	// the response. You can use this pagination token to retrieve the next set
	// of results.
	NextToken *string `type:"string"`

	// If specified, ListDatasetEntries only returns JSON Lines where the value
	// of SourceRefContains is part of the source-ref field. The source-ref field
	// contains the Amazon S3 location of the image. You can use SouceRefContains
	// for tasks such as getting the JSON Line for a single image, or gettting JSON
	// Lines for all images within a specific folder.
	SourceRefContains *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetEntriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetEntriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetEntriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetEntriesInput"}
	if s.ContainsLabels != nil && len(s.ContainsLabels) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContainsLabels", 1))
	}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}
	if s.DatasetArn != nil && len(*s.DatasetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetArn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SourceRefContains != nil && len(*s.SourceRefContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceRefContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainsLabels sets the ContainsLabels field's value.
func (s *ListDatasetEntriesInput) SetContainsLabels(v []*string) *ListDatasetEntriesInput {
	s.ContainsLabels = v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *ListDatasetEntriesInput) SetDatasetArn(v string) *ListDatasetEntriesInput {
	s.DatasetArn = &v
	return s
}

// SetHasErrors sets the HasErrors field's value.
func (s *ListDatasetEntriesInput) SetHasErrors(v bool) *ListDatasetEntriesInput {
	s.HasErrors = &v
	return s
}

// SetLabeled sets the Labeled field's value.
func (s *ListDatasetEntriesInput) SetLabeled(v bool) *ListDatasetEntriesInput {
	s.Labeled = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetEntriesInput) SetMaxResults(v int64) *ListDatasetEntriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetEntriesInput) SetNextToken(v string) *ListDatasetEntriesInput {
	s.NextToken = &v
	return s
}

// SetSourceRefContains sets the SourceRefContains field's value.
func (s *ListDatasetEntriesInput) SetSourceRefContains(v string) *ListDatasetEntriesInput {
	s.SourceRefContains = &v
	return s
}

type ListDatasetEntriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of entries (images) in the dataset.
	DatasetEntries []*string `type:"list"`

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in
	// the response. You can use this pagination token to retrieve the next set
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetEntriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetEntriesOutput) GoString() string {
	return s.String()
}

// SetDatasetEntries sets the DatasetEntries field's value.
func (s *ListDatasetEntriesOutput) SetDatasetEntries(v []*string) *ListDatasetEntriesOutput {
	s.DatasetEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetEntriesOutput) SetNextToken(v string) *ListDatasetEntriesOutput {
	s.NextToken = &v
	return s
}

type ListDatasetLabelsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the dataset that you want to use.
	//
	// DatasetArn is a required field
	DatasetArn *string `min:"20" type:"string" required:"true"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 100. If you specify a value greater than 100, a ValidationException
	// error occurs. The default value is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in
	// the response. You can use this pagination token to retrieve the next set
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetLabelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetLabelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDatasetLabelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDatasetLabelsInput"}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}
	if s.DatasetArn != nil && len(*s.DatasetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetArn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *ListDatasetLabelsInput) SetDatasetArn(v string) *ListDatasetLabelsInput {
	s.DatasetArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDatasetLabelsInput) SetMaxResults(v int64) *ListDatasetLabelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetLabelsInput) SetNextToken(v string) *ListDatasetLabelsInput {
	s.NextToken = &v
	return s
}

type ListDatasetLabelsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the labels in the dataset.
	DatasetLabelDescriptions []*DatasetLabelDescription `type:"list"`

	// If the previous response was incomplete (because there is more results to
	// retrieve), Amazon Rekognition Custom Labels returns a pagination token in
	// the response. You can use this pagination token to retrieve the next set
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetLabelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDatasetLabelsOutput) GoString() string {
	return s.String()
}

// SetDatasetLabelDescriptions sets the DatasetLabelDescriptions field's value.
func (s *ListDatasetLabelsOutput) SetDatasetLabelDescriptions(v []*DatasetLabelDescription) *ListDatasetLabelsOutput {
	s.DatasetLabelDescriptions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDatasetLabelsOutput) SetNextToken(v string) *ListDatasetLabelsOutput {
	s.NextToken = &v
	return s
}

type ListFacesInput struct {
	_ struct{} `type:"structure"`

	// ID of the collection from which to list the faces.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`

	// Maximum number of faces to return.
	MaxResults *int64 `type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Rekognition returns a pagination token in the response. You can use
	// this pagination token to retrieve the next set of faces.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFacesInput"}
	if s.CollectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionId sets the CollectionId field's value.
func (s *ListFacesInput) SetCollectionId(v string) *ListFacesInput {
	s.CollectionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFacesInput) SetMaxResults(v int64) *ListFacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFacesInput) SetNextToken(v string) *ListFacesInput {
	s.NextToken = &v
	return s
}

type ListFacesOutput struct {
	_ struct{} `type:"structure"`

	// Version number of the face detection model associated with the input collection
	// (CollectionId).
	FaceModelVersion *string `type:"string"`

	// An array of Face objects.
	Faces []*Face `type:"list"`

	// If the response is truncated, Amazon Rekognition returns this token that
	// you can use in the subsequent request to retrieve the next set of faces.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFacesOutput) GoString() string {
	return s.String()
}

// SetFaceModelVersion sets the FaceModelVersion field's value.
func (s *ListFacesOutput) SetFaceModelVersion(v string) *ListFacesOutput {
	s.FaceModelVersion = &v
	return s
}

// SetFaces sets the Faces field's value.
func (s *ListFacesOutput) SetFaces(v []*Face) *ListFacesOutput {
	s.Faces = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFacesOutput) SetNextToken(v string) *ListFacesOutput {
	s.NextToken = &v
	return s
}

type ListStreamProcessorsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of stream processors you want Amazon Rekognition Video to
	// return in the response. The default is 1000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more stream processors
	// to retrieve), Amazon Rekognition Video returns a pagination token in the
	// response. You can use this pagination token to retrieve the next set of stream
	// processors.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamProcessorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamProcessorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamProcessorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamProcessorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStreamProcessorsInput) SetMaxResults(v int64) *ListStreamProcessorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamProcessorsInput) SetNextToken(v string) *ListStreamProcessorsInput {
	s.NextToken = &v
	return s
}

type ListStreamProcessorsOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon Rekognition Video returns this token
	// that you can use in the subsequent request to retrieve the next set of stream
	// processors.
	NextToken *string `type:"string"`

	// List of stream processors that you have created.
	StreamProcessors []*StreamProcessor `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamProcessorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStreamProcessorsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamProcessorsOutput) SetNextToken(v string) *ListStreamProcessorsOutput {
	s.NextToken = &v
	return s
}

// SetStreamProcessors sets the StreamProcessors field's value.
func (s *ListStreamProcessorsOutput) SetStreamProcessors(v []*StreamProcessor) *ListStreamProcessorsOutput {
	s.StreamProcessors = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the model, collection, or stream processor
	// that contains the tags that you want a list of.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of key-value tags assigned to the resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Provides information about a single type of inappropriate, unwanted, or offensive
// content found in an image or video. Each type of moderated content has a
// label within a hierarchical taxonomy. For more information, see Content moderation
// in the Amazon Rekognition Developer Guide.
type ModerationLabel struct {
	_ struct{} `type:"structure"`

	// Specifies the confidence that Amazon Rekognition has that the label has been
	// correctly identified.
	//
	// If you don't specify the MinConfidence parameter in the call to DetectModerationLabels,
	// the operation returns labels with a confidence value greater than or equal
	// to 50 percent.
	Confidence *float64 `type:"float"`

	// The label name for the type of unsafe content detected in the image.
	Name *string `type:"string"`

	// The name for the parent label. Labels at the top level of the hierarchy have
	// the parent label "".
	ParentName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModerationLabel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModerationLabel) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *ModerationLabel) SetConfidence(v float64) *ModerationLabel {
	s.Confidence = &v
	return s
}

// SetName sets the Name field's value.
func (s *ModerationLabel) SetName(v string) *ModerationLabel {
	s.Name = &v
	return s
}

// SetParentName sets the ParentName field's value.
func (s *ModerationLabel) SetParentName(v string) *ModerationLabel {
	s.ParentName = &v
	return s
}

// Indicates whether or not the mouth on the face is open, and the confidence
// level in the determination.
type MouthOpen struct {
	_ struct{} `type:"structure"`

	// Level of confidence in the determination.
	Confidence *float64 `type:"float"`

	// Boolean value that indicates whether the mouth on the face is open or not.
	Value *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MouthOpen) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MouthOpen) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *MouthOpen) SetConfidence(v float64) *MouthOpen {
	s.Confidence = &v
	return s
}

// SetValue sets the Value field's value.
func (s *MouthOpen) SetValue(v bool) *MouthOpen {
	s.Value = &v
	return s
}

// Indicates whether or not the face has a mustache, and the confidence level
// in the determination.
type Mustache struct {
	_ struct{} `type:"structure"`

	// Level of confidence in the determination.
	Confidence *float64 `type:"float"`

	// Boolean value that indicates whether the face has mustache or not.
	Value *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Mustache) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Mustache) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *Mustache) SetConfidence(v float64) *Mustache {
	s.Confidence = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Mustache) SetValue(v bool) *Mustache {
	s.Value = &v
	return s
}

// The Amazon Simple Notification Service topic to which Amazon Rekognition
// publishes the completion status of a video analysis operation. For more information,
// see Calling Amazon Rekognition Video operations (https://docs.aws.amazon.com/rekognition/latest/dg/api-video.html).
// Note that the Amazon SNS topic must have a topic name that begins with AmazonRekognition
// if you are using the AmazonRekognitionServiceRole permissions policy to access
// the topic. For more information, see Giving access to multiple Amazon SNS
// topics (https://docs.aws.amazon.com/rekognition/latest/dg/api-video-roles.html#api-video-roles-all-topics).
type NotificationChannel struct {
	_ struct{} `type:"structure"`

	// The ARN of an IAM role that gives Amazon Rekognition publishing permissions
	// to the Amazon SNS topic.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// The Amazon SNS topic to which Amazon Rekognition posts the completion status.
	//
	// SNSTopicArn is a required field
	SNSTopicArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationChannel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationChannel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationChannel"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SNSTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SNSTopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *NotificationChannel) SetRoleArn(v string) *NotificationChannel {
	s.RoleArn = &v
	return s
}

// SetSNSTopicArn sets the SNSTopicArn field's value.
func (s *NotificationChannel) SetSNSTopicArn(v string) *NotificationChannel {
	s.SNSTopicArn = &v
	return s
}

// The S3 bucket and folder location where training output is placed.
type OutputConfig struct {
	_ struct{} `type:"structure"`

	// The S3 bucket where training output is placed.
	S3Bucket *string `min:"3" type:"string"`

	// The prefix applied to the training output files.
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputConfig"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *OutputConfig) SetS3Bucket(v string) *OutputConfig {
	s.S3Bucket = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *OutputConfig) SetS3KeyPrefix(v string) *OutputConfig {
	s.S3KeyPrefix = &v
	return s
}

// A parent label for a label. A label can have 0, 1, or more parents.
type Parent struct {
	_ struct{} `type:"structure"`

	// The name of the parent label.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parent) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Parent) SetName(v string) *Parent {
	s.Name = &v
	return s
}

// Details about a person detected in a video analysis request.
type PersonDetail struct {
	_ struct{} `type:"structure"`

	// Bounding box around the detected person.
	BoundingBox *BoundingBox `type:"structure"`

	// Face details for the detected person.
	Face *FaceDetail `type:"structure"`

	// Identifier for the person detected person within a video. Use to keep track
	// of the person throughout the video. The identifier is not stored by Amazon
	// Rekognition.
	Index *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PersonDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PersonDetail) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *PersonDetail) SetBoundingBox(v *BoundingBox) *PersonDetail {
	s.BoundingBox = v
	return s
}

// SetFace sets the Face field's value.
func (s *PersonDetail) SetFace(v *FaceDetail) *PersonDetail {
	s.Face = v
	return s
}

// SetIndex sets the Index field's value.
func (s *PersonDetail) SetIndex(v int64) *PersonDetail {
	s.Index = &v
	return s
}

// Details and path tracking information for a single time a person's path is
// tracked in a video. Amazon Rekognition operations that track people's paths
// return an array of PersonDetection objects with elements for each time a
// person's path is tracked in a video.
//
// For more information, see GetPersonTracking in the Amazon Rekognition Developer
// Guide.
type PersonDetection struct {
	_ struct{} `type:"structure"`

	// Details about a person whose path was tracked in a video.
	Person *PersonDetail `type:"structure"`

	// The time, in milliseconds from the start of the video, that the person's
	// path was tracked.
	Timestamp *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PersonDetection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PersonDetection) GoString() string {
	return s.String()
}

// SetPerson sets the Person field's value.
func (s *PersonDetection) SetPerson(v *PersonDetail) *PersonDetection {
	s.Person = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *PersonDetection) SetTimestamp(v int64) *PersonDetection {
	s.Timestamp = &v
	return s
}

// Information about a person whose face matches a face(s) in an Amazon Rekognition
// collection. Includes information about the faces in the Amazon Rekognition
// collection (FaceMatch), information about the person (PersonDetail), and
// the time stamp for when the person was detected in a video. An array of PersonMatch
// objects is returned by GetFaceSearch.
type PersonMatch struct {
	_ struct{} `type:"structure"`

	// Information about the faces in the input collection that match the face of
	// a person in the video.
	FaceMatches []*FaceMatch `type:"list"`

	// Information about the matched person.
	Person *PersonDetail `type:"structure"`

	// The time, in milliseconds from the beginning of the video, that the person
	// was matched in the video.
	Timestamp *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PersonMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PersonMatch) GoString() string {
	return s.String()
}

// SetFaceMatches sets the FaceMatches field's value.
func (s *PersonMatch) SetFaceMatches(v []*FaceMatch) *PersonMatch {
	s.FaceMatches = v
	return s
}

// SetPerson sets the Person field's value.
func (s *PersonMatch) SetPerson(v *PersonDetail) *PersonMatch {
	s.Person = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *PersonMatch) SetTimestamp(v int64) *PersonMatch {
	s.Timestamp = &v
	return s
}

// The X and Y coordinates of a point on an image or video frame. The X and
// Y values are ratios of the overall image size or video resolution. For example,
// if an input image is 700x200 and the values are X=0.5 and Y=0.25, then the
// point is at the (350,50) pixel coordinate on the image.
//
// An array of Point objects makes up a Polygon. A Polygon is returned by DetectText
// and by DetectCustomLabels Polygon represents a fine-grained polygon around
// a detected item. For more information, see Geometry in the Amazon Rekognition
// Developer Guide.
type Point struct {
	_ struct{} `type:"structure"`

	// The value of the X coordinate for a point on a Polygon.
	X *float64 `type:"float"`

	// The value of the Y coordinate for a point on a Polygon.
	Y *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Point) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Point) GoString() string {
	return s.String()
}

// SetX sets the X field's value.
func (s *Point) SetX(v float64) *Point {
	s.X = &v
	return s
}

// SetY sets the Y field's value.
func (s *Point) SetY(v float64) *Point {
	s.Y = &v
	return s
}

// Indicates the pose of the face as determined by its pitch, roll, and yaw.
type Pose struct {
	_ struct{} `type:"structure"`

	// Value representing the face rotation on the pitch axis.
	Pitch *float64 `type:"float"`

	// Value representing the face rotation on the roll axis.
	Roll *float64 `type:"float"`

	// Value representing the face rotation on the yaw axis.
	Yaw *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Pose) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Pose) GoString() string {
	return s.String()
}

// SetPitch sets the Pitch field's value.
func (s *Pose) SetPitch(v float64) *Pose {
	s.Pitch = &v
	return s
}

// SetRoll sets the Roll field's value.
func (s *Pose) SetRoll(v float64) *Pose {
	s.Roll = &v
	return s
}

// SetYaw sets the Yaw field's value.
func (s *Pose) SetYaw(v float64) *Pose {
	s.Yaw = &v
	return s
}

// A description of an Amazon Rekognition Custom Labels project. For more information,
// see DescribeProjects.
type ProjectDescription struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp for the date and time that the project was created.
	CreationTimestamp *time.Time `type:"timestamp"`

	// Information about the training and test datasets in the project.
	Datasets []*DatasetMetadata `type:"list"`

	// The Amazon Resource Name (ARN) of the project.
	ProjectArn *string `min:"20" type:"string"`

	// The current status of the project.
	Status *string `type:"string" enum:"ProjectStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectDescription) GoString() string {
	return s.String()
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *ProjectDescription) SetCreationTimestamp(v time.Time) *ProjectDescription {
	s.CreationTimestamp = &v
	return s
}

// SetDatasets sets the Datasets field's value.
func (s *ProjectDescription) SetDatasets(v []*DatasetMetadata) *ProjectDescription {
	s.Datasets = v
	return s
}

// SetProjectArn sets the ProjectArn field's value.
func (s *ProjectDescription) SetProjectArn(v string) *ProjectDescription {
	s.ProjectArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProjectDescription) SetStatus(v string) *ProjectDescription {
	s.Status = &v
	return s
}

// A description of a version of an Amazon Rekognition Custom Labels model.
type ProjectVersionDescription struct {
	_ struct{} `type:"structure"`

	// The duration, in seconds, that you were billed for a successful training
	// of the model version. This value is only returned if the model version has
	// been successfully trained.
	BillableTrainingTimeInSeconds *int64 `type:"long"`

	// The Unix datetime for the date and time that training started.
	CreationTimestamp *time.Time `type:"timestamp"`

	// The training results. EvaluationResult is only returned if training is successful.
	EvaluationResult *EvaluationResult `type:"structure"`

	// The identifer for the AWS Key Management Service key (AWS KMS key) that was
	// used to encrypt the model during training.
	KmsKeyId *string `min:"1" type:"string"`

	// The location of the summary manifest. The summary manifest provides aggregate
	// data validation results for the training and test datasets.
	ManifestSummary *GroundTruthManifest `type:"structure"`

	// The minimum number of inference units used by the model. For more information,
	// see StartProjectVersion.
	MinInferenceUnits *int64 `min:"1" type:"integer"`

	// The location where training results are saved.
	OutputConfig *OutputConfig `type:"structure"`

	// The Amazon Resource Name (ARN) of the model version.
	ProjectVersionArn *string `min:"20" type:"string"`

	// The current status of the model version.
	Status *string `type:"string" enum:"ProjectVersionStatus"`

	// A descriptive message for an error or warning that occurred.
	StatusMessage *string `type:"string"`

	// Contains information about the testing results.
	TestingDataResult *TestingDataResult `type:"structure"`

	// Contains information about the training results.
	TrainingDataResult *TrainingDataResult `type:"structure"`

	// The Unix date and time that training of the model ended.
	TrainingEndTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectVersionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProjectVersionDescription) GoString() string {
	return s.String()
}

// SetBillableTrainingTimeInSeconds sets the BillableTrainingTimeInSeconds field's value.
func (s *ProjectVersionDescription) SetBillableTrainingTimeInSeconds(v int64) *ProjectVersionDescription {
	s.BillableTrainingTimeInSeconds = &v
	return s
}

// SetCreationTimestamp sets the CreationTimestamp field's value.
func (s *ProjectVersionDescription) SetCreationTimestamp(v time.Time) *ProjectVersionDescription {
	s.CreationTimestamp = &v
	return s
}

// SetEvaluationResult sets the EvaluationResult field's value.
func (s *ProjectVersionDescription) SetEvaluationResult(v *EvaluationResult) *ProjectVersionDescription {
	s.EvaluationResult = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ProjectVersionDescription) SetKmsKeyId(v string) *ProjectVersionDescription {
	s.KmsKeyId = &v
	return s
}

// SetManifestSummary sets the ManifestSummary field's value.
func (s *ProjectVersionDescription) SetManifestSummary(v *GroundTruthManifest) *ProjectVersionDescription {
	s.ManifestSummary = v
	return s
}

// SetMinInferenceUnits sets the MinInferenceUnits field's value.
func (s *ProjectVersionDescription) SetMinInferenceUnits(v int64) *ProjectVersionDescription {
	s.MinInferenceUnits = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *ProjectVersionDescription) SetOutputConfig(v *OutputConfig) *ProjectVersionDescription {
	s.OutputConfig = v
	return s
}

// SetProjectVersionArn sets the ProjectVersionArn field's value.
func (s *ProjectVersionDescription) SetProjectVersionArn(v string) *ProjectVersionDescription {
	s.ProjectVersionArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProjectVersionDescription) SetStatus(v string) *ProjectVersionDescription {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ProjectVersionDescription) SetStatusMessage(v string) *ProjectVersionDescription {
	s.StatusMessage = &v
	return s
}

// SetTestingDataResult sets the TestingDataResult field's value.
func (s *ProjectVersionDescription) SetTestingDataResult(v *TestingDataResult) *ProjectVersionDescription {
	s.TestingDataResult = v
	return s
}

// SetTrainingDataResult sets the TrainingDataResult field's value.
func (s *ProjectVersionDescription) SetTrainingDataResult(v *TrainingDataResult) *ProjectVersionDescription {
	s.TrainingDataResult = v
	return s
}

// SetTrainingEndTimestamp sets the TrainingEndTimestamp field's value.
func (s *ProjectVersionDescription) SetTrainingEndTimestamp(v time.Time) *ProjectVersionDescription {
	s.TrainingEndTimestamp = &v
	return s
}

// Information about a body part detected by DetectProtectiveEquipment that
// contains PPE. An array of ProtectiveEquipmentBodyPart objects is returned
// for each person detected by DetectProtectiveEquipment.
type ProtectiveEquipmentBodyPart struct {
	_ struct{} `type:"structure"`

	// The confidence that Amazon Rekognition has in the detection accuracy of the
	// detected body part.
	Confidence *float64 `type:"float"`

	// An array of Personal Protective Equipment items detected around a body part.
	EquipmentDetections []*EquipmentDetection `type:"list"`

	// The detected body part.
	Name *string `type:"string" enum:"BodyPart"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectiveEquipmentBodyPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectiveEquipmentBodyPart) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *ProtectiveEquipmentBodyPart) SetConfidence(v float64) *ProtectiveEquipmentBodyPart {
	s.Confidence = &v
	return s
}

// SetEquipmentDetections sets the EquipmentDetections field's value.
func (s *ProtectiveEquipmentBodyPart) SetEquipmentDetections(v []*EquipmentDetection) *ProtectiveEquipmentBodyPart {
	s.EquipmentDetections = v
	return s
}

// SetName sets the Name field's value.
func (s *ProtectiveEquipmentBodyPart) SetName(v string) *ProtectiveEquipmentBodyPart {
	s.Name = &v
	return s
}

// A person detected by a call to DetectProtectiveEquipment. The API returns
// all persons detected in the input image in an array of ProtectiveEquipmentPerson
// objects.
type ProtectiveEquipmentPerson struct {
	_ struct{} `type:"structure"`

	// An array of body parts detected on a person's body (including body parts
	// without PPE).
	BodyParts []*ProtectiveEquipmentBodyPart `type:"list"`

	// A bounding box around the detected person.
	BoundingBox *BoundingBox `type:"structure"`

	// The confidence that Amazon Rekognition has that the bounding box contains
	// a person.
	Confidence *float64 `type:"float"`

	// The identifier for the detected person. The identifier is only unique for
	// a single call to DetectProtectiveEquipment.
	Id *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectiveEquipmentPerson) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectiveEquipmentPerson) GoString() string {
	return s.String()
}

// SetBodyParts sets the BodyParts field's value.
func (s *ProtectiveEquipmentPerson) SetBodyParts(v []*ProtectiveEquipmentBodyPart) *ProtectiveEquipmentPerson {
	s.BodyParts = v
	return s
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *ProtectiveEquipmentPerson) SetBoundingBox(v *BoundingBox) *ProtectiveEquipmentPerson {
	s.BoundingBox = v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *ProtectiveEquipmentPerson) SetConfidence(v float64) *ProtectiveEquipmentPerson {
	s.Confidence = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProtectiveEquipmentPerson) SetId(v int64) *ProtectiveEquipmentPerson {
	s.Id = &v
	return s
}

// Specifies summary attributes to return from a call to DetectProtectiveEquipment.
// You can specify which types of PPE to summarize. You can also specify a minimum
// confidence value for detections. Summary information is returned in the Summary
// (ProtectiveEquipmentSummary) field of the response from DetectProtectiveEquipment.
// The summary includes which persons in an image were detected wearing the
// requested types of person protective equipment (PPE), which persons were
// detected as not wearing PPE, and the persons in which a determination could
// not be made. For more information, see ProtectiveEquipmentSummary.
type ProtectiveEquipmentSummarizationAttributes struct {
	_ struct{} `type:"structure"`

	// The minimum confidence level for which you want summary information. The
	// confidence level applies to person detection, body part detection, equipment
	// detection, and body part coverage. Amazon Rekognition doesn't return summary
	// information with a confidence than this specified value. There isn't a default
	// value.
	//
	// Specify a MinConfidence value that is between 50-100% as DetectProtectiveEquipment
	// returns predictions only where the detection confidence is between 50% -
	// 100%. If you specify a value that is less than 50%, the results are the same
	// specifying a value of 50%.
	//
	// MinConfidence is a required field
	MinConfidence *float64 `type:"float" required:"true"`

	// An array of personal protective equipment types for which you want summary
	// information. If a person is detected wearing a required requipment type,
	// the person's ID is added to the PersonsWithRequiredEquipment array field
	// returned in ProtectiveEquipmentSummary by DetectProtectiveEquipment.
	//
	// RequiredEquipmentTypes is a required field
	RequiredEquipmentTypes []*string `type:"list" required:"true" enum:"ProtectiveEquipmentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectiveEquipmentSummarizationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectiveEquipmentSummarizationAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProtectiveEquipmentSummarizationAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProtectiveEquipmentSummarizationAttributes"}
	if s.MinConfidence == nil {
		invalidParams.Add(request.NewErrParamRequired("MinConfidence"))
	}
	if s.RequiredEquipmentTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("RequiredEquipmentTypes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMinConfidence sets the MinConfidence field's value.
func (s *ProtectiveEquipmentSummarizationAttributes) SetMinConfidence(v float64) *ProtectiveEquipmentSummarizationAttributes {
	s.MinConfidence = &v
	return s
}

// SetRequiredEquipmentTypes sets the RequiredEquipmentTypes field's value.
func (s *ProtectiveEquipmentSummarizationAttributes) SetRequiredEquipmentTypes(v []*string) *ProtectiveEquipmentSummarizationAttributes {
	s.RequiredEquipmentTypes = v
	return s
}

// Summary information for required items of personal protective equipment (PPE)
// detected on persons by a call to DetectProtectiveEquipment. You specify the
// required type of PPE in the SummarizationAttributes (ProtectiveEquipmentSummarizationAttributes)
// input parameter. The summary includes which persons were detected wearing
// the required personal protective equipment (PersonsWithRequiredEquipment),
// which persons were detected as not wearing the required PPE (PersonsWithoutRequiredEquipment),
// and the persons in which a determination could not be made (PersonsIndeterminate).
//
// To get a total for each category, use the size of the field array. For example,
// to find out how many people were detected as wearing the specified PPE, use
// the size of the PersonsWithRequiredEquipment array. If you want to find out
// more about a person, such as the location (BoundingBox) of the person on
// the image, use the person ID in each array element. Each person ID matches
// the ID field of a ProtectiveEquipmentPerson object returned in the Persons
// array by DetectProtectiveEquipment.
type ProtectiveEquipmentSummary struct {
	_ struct{} `type:"structure"`

	// An array of IDs for persons where it was not possible to determine if they
	// are wearing personal protective equipment.
	PersonsIndeterminate []*int64 `type:"list"`

	// An array of IDs for persons who are wearing detected personal protective
	// equipment.
	PersonsWithRequiredEquipment []*int64 `type:"list"`

	// An array of IDs for persons who are not wearing all of the types of PPE specified
	// in the RequiredEquipmentTypes field of the detected personal protective equipment.
	PersonsWithoutRequiredEquipment []*int64 `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectiveEquipmentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectiveEquipmentSummary) GoString() string {
	return s.String()
}

// SetPersonsIndeterminate sets the PersonsIndeterminate field's value.
func (s *ProtectiveEquipmentSummary) SetPersonsIndeterminate(v []*int64) *ProtectiveEquipmentSummary {
	s.PersonsIndeterminate = v
	return s
}

// SetPersonsWithRequiredEquipment sets the PersonsWithRequiredEquipment field's value.
func (s *ProtectiveEquipmentSummary) SetPersonsWithRequiredEquipment(v []*int64) *ProtectiveEquipmentSummary {
	s.PersonsWithRequiredEquipment = v
	return s
}

// SetPersonsWithoutRequiredEquipment sets the PersonsWithoutRequiredEquipment field's value.
func (s *ProtectiveEquipmentSummary) SetPersonsWithoutRequiredEquipment(v []*int64) *ProtectiveEquipmentSummary {
	s.PersonsWithoutRequiredEquipment = v
	return s
}

// The number of requests exceeded your throughput limit. If you want to increase
// this limit, contact Amazon Rekognition.
type ProvisionedThroughputExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedThroughputExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedThroughputExceededException) GoString() string {
	return s.String()
}

func newErrorProvisionedThroughputExceededException(v protocol.ResponseMetadata) error {
	return &ProvisionedThroughputExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ProvisionedThroughputExceededException) Code() string {
	return "ProvisionedThroughputExceededException"
}

// Message returns the exception's message.
func (s *ProvisionedThroughputExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ProvisionedThroughputExceededException) OrigErr() error {
	return nil
}

func (s *ProvisionedThroughputExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ProvisionedThroughputExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ProvisionedThroughputExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RecognizeCelebritiesInput struct {
	_ struct{} `type:"structure"`

	// The input image as base64-encoded bytes or an S3 object. If you use the AWS
	// CLI to call Amazon Rekognition operations, passing base64-encoded image bytes
	// is not supported.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeCelebritiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeCelebritiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecognizeCelebritiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecognizeCelebritiesInput"}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImage sets the Image field's value.
func (s *RecognizeCelebritiesInput) SetImage(v *Image) *RecognizeCelebritiesInput {
	s.Image = v
	return s
}

type RecognizeCelebritiesOutput struct {
	_ struct{} `type:"structure"`

	// Details about each celebrity found in the image. Amazon Rekognition can detect
	// a maximum of 64 celebrities in an image. Each celebrity object includes the
	// following attributes: Face, Confidence, Emotions, Landmarks, Pose, Quality,
	// Smile, Id, KnownGender, MatchConfidence, Name, Urls.
	CelebrityFaces []*Celebrity `type:"list"`

	//
	// Support for estimating image orientation using the the OrientationCorrection
	// field has ceased as of August 2021. Any returned values for this field included
	// in an API response will always be NULL.
	//
	// The orientation of the input image (counterclockwise direction). If your
	// application displays the image, you can use this value to correct the orientation.
	// The bounding box coordinates returned in CelebrityFaces and UnrecognizedFaces
	// represent face locations before the image orientation is corrected.
	//
	// If the input image is in .jpeg format, it might contain exchangeable image
	// (Exif) metadata that includes the image's orientation. If so, and the Exif
	// metadata for the input image populates the orientation field, the value of
	// OrientationCorrection is null. The CelebrityFaces and UnrecognizedFaces bounding
	// box coordinates represent face locations after Exif metadata is used to correct
	// the image orientation. Images in .png format don't contain Exif metadata.
	OrientationCorrection *string `type:"string" enum:"OrientationCorrection"`

	// Details about each unrecognized face in the image.
	UnrecognizedFaces []*ComparedFace `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeCelebritiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecognizeCelebritiesOutput) GoString() string {
	return s.String()
}

// SetCelebrityFaces sets the CelebrityFaces field's value.
func (s *RecognizeCelebritiesOutput) SetCelebrityFaces(v []*Celebrity) *RecognizeCelebritiesOutput {
	s.CelebrityFaces = v
	return s
}

// SetOrientationCorrection sets the OrientationCorrection field's value.
func (s *RecognizeCelebritiesOutput) SetOrientationCorrection(v string) *RecognizeCelebritiesOutput {
	s.OrientationCorrection = &v
	return s
}

// SetUnrecognizedFaces sets the UnrecognizedFaces field's value.
func (s *RecognizeCelebritiesOutput) SetUnrecognizedFaces(v []*ComparedFace) *RecognizeCelebritiesOutput {
	s.UnrecognizedFaces = v
	return s
}

// Specifies a location within the frame that Rekognition checks for objects
// of interest such as text, labels, or faces. It uses a BoundingBox or object
// or Polygon to set a region of the screen.
//
// A word, face, or label is included in the region if it is more than half
// in that region. If there is more than one region, the word, face, or label
// is compared with all regions of the screen. Any object of interest that is
// more than half in a region is kept in the results.
type RegionOfInterest struct {
	_ struct{} `type:"structure"`

	// The box representing a region of interest on screen.
	BoundingBox *BoundingBox `type:"structure"`

	// Specifies a shape made up of up to 10 Point objects to define a region of
	// interest.
	Polygon []*Point `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegionOfInterest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegionOfInterest) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *RegionOfInterest) SetBoundingBox(v *BoundingBox) *RegionOfInterest {
	s.BoundingBox = v
	return s
}

// SetPolygon sets the Polygon field's value.
func (s *RegionOfInterest) SetPolygon(v []*Point) *RegionOfInterest {
	s.Polygon = v
	return s
}

// A resource with the specified ID already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource is already being used.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource specified in the request cannot be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The requested resource isn't ready. For example, this exception occurs when
// you call DetectCustomLabels with a model version that isn't deployed.
type ResourceNotReadyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotReadyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotReadyException) GoString() string {
	return s.String()
}

func newErrorResourceNotReadyException(v protocol.ResponseMetadata) error {
	return &ResourceNotReadyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotReadyException) Code() string {
	return "ResourceNotReadyException"
}

// Message returns the exception's message.
func (s *ResourceNotReadyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotReadyException) OrigErr() error {
	return nil
}

func (s *ResourceNotReadyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotReadyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotReadyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed
// inference results of a video analysis operation. These results include the
// name of the stream processor resource, the session ID of the stream processing
// session, and labeled timestamps and bounding boxes for detected labels.
type S3Destination struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket you want to associate with the streaming
	// video project. You must be the owner of the Amazon S3 bucket.
	Bucket *string `min:"3" type:"string"`

	// The prefix value of the location within the bucket that you want the information
	// to be published to. For more information, see Using prefixes (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html).
	KeyPrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Destination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Destination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Destination"}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Destination) SetBucket(v string) *S3Destination {
	s.Bucket = &v
	return s
}

// SetKeyPrefix sets the KeyPrefix field's value.
func (s *S3Destination) SetKeyPrefix(v string) *S3Destination {
	s.KeyPrefix = &v
	return s
}

// Provides the S3 bucket name and object name.
//
// The region for the S3 bucket containing the S3 object must match the region
// you use for Amazon Rekognition operations.
//
// For Amazon Rekognition to process an S3 object, the user must have permission
// to access the S3 object. For more information, see How Amazon Rekognition
// works with IAM in the Amazon Rekognition Developer Guide.
type S3Object struct {
	_ struct{} `type:"structure"`

	// Name of the S3 bucket.
	Bucket *string `min:"3" type:"string"`

	// S3 object key name.
	Name *string `min:"1" type:"string"`

	// If the bucket is versioning enabled, you can specify the object version.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Object) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Object) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Object"}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Object) SetBucket(v string) *S3Object {
	s.Bucket = &v
	return s
}

// SetName sets the Name field's value.
func (s *S3Object) SetName(v string) *S3Object {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *S3Object) SetVersion(v string) *S3Object {
	s.Version = &v
	return s
}

type SearchFacesByImageInput struct {
	_ struct{} `type:"structure"`

	// ID of the collection to search.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`

	// (Optional) Specifies the minimum confidence in the face match to return.
	// For example, don't return any matches where confidence in matches is less
	// than 70%. The default value is 80%.
	FaceMatchThreshold *float64 `type:"float"`

	// The input image as base64-encoded bytes or an S3 object. If you use the AWS
	// CLI to call Amazon Rekognition operations, passing base64-encoded image bytes
	// is not supported.
	//
	// If you are using an AWS SDK to call Amazon Rekognition, you might not need
	// to base64-encode image bytes passed using the Bytes field. For more information,
	// see Images in the Amazon Rekognition developer guide.
	//
	// Image is a required field
	Image *Image `type:"structure" required:"true"`

	// Maximum number of faces to return. The operation returns the maximum number
	// of faces with the highest confidence in the match.
	MaxFaces *int64 `min:"1" type:"integer"`

	// A filter that specifies a quality bar for how much filtering is done to identify
	// faces. Filtered faces aren't searched for in the collection. If you specify
	// AUTO, Amazon Rekognition chooses the quality bar. If you specify LOW, MEDIUM,
	// or HIGH, filtering removes all faces that don’t meet the chosen quality
	// bar. The quality bar is based on a variety of common use cases. Low-quality
	// detections can occur for a number of reasons. Some examples are an object
	// that's misidentified as a face, a face that's too blurry, or a face with
	// a pose that's too extreme to use. If you specify NONE, no filtering is performed.
	// The default value is NONE.
	//
	// To use quality filtering, the collection you are using must be associated
	// with version 3 of the face model or higher.
	QualityFilter *string `type:"string" enum:"QualityFilter"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFacesByImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFacesByImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchFacesByImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchFacesByImageInput"}
	if s.CollectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionId", 1))
	}
	if s.Image == nil {
		invalidParams.Add(request.NewErrParamRequired("Image"))
	}
	if s.MaxFaces != nil && *s.MaxFaces < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxFaces", 1))
	}
	if s.Image != nil {
		if err := s.Image.Validate(); err != nil {
			invalidParams.AddNested("Image", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionId sets the CollectionId field's value.
func (s *SearchFacesByImageInput) SetCollectionId(v string) *SearchFacesByImageInput {
	s.CollectionId = &v
	return s
}

// SetFaceMatchThreshold sets the FaceMatchThreshold field's value.
func (s *SearchFacesByImageInput) SetFaceMatchThreshold(v float64) *SearchFacesByImageInput {
	s.FaceMatchThreshold = &v
	return s
}

// SetImage sets the Image field's value.
func (s *SearchFacesByImageInput) SetImage(v *Image) *SearchFacesByImageInput {
	s.Image = v
	return s
}

// SetMaxFaces sets the MaxFaces field's value.
func (s *SearchFacesByImageInput) SetMaxFaces(v int64) *SearchFacesByImageInput {
	s.MaxFaces = &v
	return s
}

// SetQualityFilter sets the QualityFilter field's value.
func (s *SearchFacesByImageInput) SetQualityFilter(v string) *SearchFacesByImageInput {
	s.QualityFilter = &v
	return s
}

type SearchFacesByImageOutput struct {
	_ struct{} `type:"structure"`

	// An array of faces that match the input face, along with the confidence in
	// the match.
	FaceMatches []*FaceMatch `type:"list"`

	// Version number of the face detection model associated with the input collection
	// (CollectionId).
	FaceModelVersion *string `type:"string"`

	// The bounding box around the face in the input image that Amazon Rekognition
	// used for the search.
	SearchedFaceBoundingBox *BoundingBox `type:"structure"`

	// The level of confidence that the searchedFaceBoundingBox, contains a face.
	SearchedFaceConfidence *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFacesByImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFacesByImageOutput) GoString() string {
	return s.String()
}

// SetFaceMatches sets the FaceMatches field's value.
func (s *SearchFacesByImageOutput) SetFaceMatches(v []*FaceMatch) *SearchFacesByImageOutput {
	s.FaceMatches = v
	return s
}

// SetFaceModelVersion sets the FaceModelVersion field's value.
func (s *SearchFacesByImageOutput) SetFaceModelVersion(v string) *SearchFacesByImageOutput {
	s.FaceModelVersion = &v
	return s
}

// SetSearchedFaceBoundingBox sets the SearchedFaceBoundingBox field's value.
func (s *SearchFacesByImageOutput) SetSearchedFaceBoundingBox(v *BoundingBox) *SearchFacesByImageOutput {
	s.SearchedFaceBoundingBox = v
	return s
}

// SetSearchedFaceConfidence sets the SearchedFaceConfidence field's value.
func (s *SearchFacesByImageOutput) SetSearchedFaceConfidence(v float64) *SearchFacesByImageOutput {
	s.SearchedFaceConfidence = &v
	return s
}

type SearchFacesInput struct {
	_ struct{} `type:"structure"`

	// ID of the collection the face belongs to.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`

	// ID of a face to find matches for in the collection.
	//
	// FaceId is a required field
	FaceId *string `type:"string" required:"true"`

	// Optional value specifying the minimum confidence in the face match to return.
	// For example, don't return any matches where confidence in matches is less
	// than 70%. The default value is 80%.
	FaceMatchThreshold *float64 `type:"float"`

	// Maximum number of faces to return. The operation returns the maximum number
	// of faces with the highest confidence in the match.
	MaxFaces *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchFacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchFacesInput"}
	if s.CollectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionId", 1))
	}
	if s.FaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("FaceId"))
	}
	if s.MaxFaces != nil && *s.MaxFaces < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxFaces", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionId sets the CollectionId field's value.
func (s *SearchFacesInput) SetCollectionId(v string) *SearchFacesInput {
	s.CollectionId = &v
	return s
}

// SetFaceId sets the FaceId field's value.
func (s *SearchFacesInput) SetFaceId(v string) *SearchFacesInput {
	s.FaceId = &v
	return s
}

// SetFaceMatchThreshold sets the FaceMatchThreshold field's value.
func (s *SearchFacesInput) SetFaceMatchThreshold(v float64) *SearchFacesInput {
	s.FaceMatchThreshold = &v
	return s
}

// SetMaxFaces sets the MaxFaces field's value.
func (s *SearchFacesInput) SetMaxFaces(v int64) *SearchFacesInput {
	s.MaxFaces = &v
	return s
}

type SearchFacesOutput struct {
	_ struct{} `type:"structure"`

	// An array of faces that matched the input face, along with the confidence
	// in the match.
	FaceMatches []*FaceMatch `type:"list"`

	// Version number of the face detection model associated with the input collection
	// (CollectionId).
	FaceModelVersion *string `type:"string"`

	// ID of the face that was searched for matches in a collection.
	SearchedFaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SearchFacesOutput) GoString() string {
	return s.String()
}

// SetFaceMatches sets the FaceMatches field's value.
func (s *SearchFacesOutput) SetFaceMatches(v []*FaceMatch) *SearchFacesOutput {
	s.FaceMatches = v
	return s
}

// SetFaceModelVersion sets the FaceModelVersion field's value.
func (s *SearchFacesOutput) SetFaceModelVersion(v string) *SearchFacesOutput {
	s.FaceModelVersion = &v
	return s
}

// SetSearchedFaceId sets the SearchedFaceId field's value.
func (s *SearchFacesOutput) SetSearchedFaceId(v string) *SearchFacesOutput {
	s.SearchedFaceId = &v
	return s
}

// A technical cue or shot detection segment detected in a video. An array of
// SegmentDetection objects containing all segments detected in a stored video
// is returned by GetSegmentDetection.
type SegmentDetection struct {
	_ struct{} `type:"structure"`

	// The duration of a video segment, expressed in frames.
	DurationFrames *int64 `type:"long"`

	// The duration of the detected segment in milliseconds.
	DurationMillis *int64 `type:"long"`

	// The duration of the timecode for the detected segment in SMPTE format.
	DurationSMPTE *string `type:"string"`

	// The frame number at the end of a video segment, using a frame index that
	// starts with 0.
	EndFrameNumber *int64 `type:"long"`

	// The frame-accurate SMPTE timecode, from the start of a video, for the end
	// of a detected segment. EndTimecode is in HH:MM:SS:fr format (and ;fr for
	// drop frame-rates).
	EndTimecodeSMPTE *string `type:"string"`

	// The end time of the detected segment, in milliseconds, from the start of
	// the video. This value is rounded down.
	EndTimestampMillis *int64 `type:"long"`

	// If the segment is a shot detection, contains information about the shot detection.
	ShotSegment *ShotSegment `type:"structure"`

	// The frame number of the start of a video segment, using a frame index that
	// starts with 0.
	StartFrameNumber *int64 `type:"long"`

	// The frame-accurate SMPTE timecode, from the start of a video, for the start
	// of a detected segment. StartTimecode is in HH:MM:SS:fr format (and ;fr for
	// drop frame-rates).
	StartTimecodeSMPTE *string `type:"string"`

	// The start time of the detected segment in milliseconds from the start of
	// the video. This value is rounded down. For example, if the actual timestamp
	// is 100.6667 milliseconds, Amazon Rekognition Video returns a value of 100
	// millis.
	StartTimestampMillis *int64 `type:"long"`

	// If the segment is a technical cue, contains information about the technical
	// cue.
	TechnicalCueSegment *TechnicalCueSegment `type:"structure"`

	// The type of the segment. Valid values are TECHNICAL_CUE and SHOT.
	Type *string `type:"string" enum:"SegmentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SegmentDetection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SegmentDetection) GoString() string {
	return s.String()
}

// SetDurationFrames sets the DurationFrames field's value.
func (s *SegmentDetection) SetDurationFrames(v int64) *SegmentDetection {
	s.DurationFrames = &v
	return s
}

// SetDurationMillis sets the DurationMillis field's value.
func (s *SegmentDetection) SetDurationMillis(v int64) *SegmentDetection {
	s.DurationMillis = &v
	return s
}

// SetDurationSMPTE sets the DurationSMPTE field's value.
func (s *SegmentDetection) SetDurationSMPTE(v string) *SegmentDetection {
	s.DurationSMPTE = &v
	return s
}

// SetEndFrameNumber sets the EndFrameNumber field's value.
func (s *SegmentDetection) SetEndFrameNumber(v int64) *SegmentDetection {
	s.EndFrameNumber = &v
	return s
}

// SetEndTimecodeSMPTE sets the EndTimecodeSMPTE field's value.
func (s *SegmentDetection) SetEndTimecodeSMPTE(v string) *SegmentDetection {
	s.EndTimecodeSMPTE = &v
	return s
}

// SetEndTimestampMillis sets the EndTimestampMillis field's value.
func (s *SegmentDetection) SetEndTimestampMillis(v int64) *SegmentDetection {
	s.EndTimestampMillis = &v
	return s
}

// SetShotSegment sets the ShotSegment field's value.
func (s *SegmentDetection) SetShotSegment(v *ShotSegment) *SegmentDetection {
	s.ShotSegment = v
	return s
}

// SetStartFrameNumber sets the StartFrameNumber field's value.
func (s *SegmentDetection) SetStartFrameNumber(v int64) *SegmentDetection {
	s.StartFrameNumber = &v
	return s
}

// SetStartTimecodeSMPTE sets the StartTimecodeSMPTE field's value.
func (s *SegmentDetection) SetStartTimecodeSMPTE(v string) *SegmentDetection {
	s.StartTimecodeSMPTE = &v
	return s
}

// SetStartTimestampMillis sets the StartTimestampMillis field's value.
func (s *SegmentDetection) SetStartTimestampMillis(v int64) *SegmentDetection {
	s.StartTimestampMillis = &v
	return s
}

// SetTechnicalCueSegment sets the TechnicalCueSegment field's value.
func (s *SegmentDetection) SetTechnicalCueSegment(v *TechnicalCueSegment) *SegmentDetection {
	s.TechnicalCueSegment = v
	return s
}

// SetType sets the Type field's value.
func (s *SegmentDetection) SetType(v string) *SegmentDetection {
	s.Type = &v
	return s
}

// Information about the type of a segment requested in a call to StartSegmentDetection.
// An array of SegmentTypeInfo objects is returned by the response from GetSegmentDetection.
type SegmentTypeInfo struct {
	_ struct{} `type:"structure"`

	// The version of the model used to detect segments.
	ModelVersion *string `type:"string"`

	// The type of a segment (technical cue or shot detection).
	Type *string `type:"string" enum:"SegmentType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SegmentTypeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SegmentTypeInfo) GoString() string {
	return s.String()
}

// SetModelVersion sets the ModelVersion field's value.
func (s *SegmentTypeInfo) SetModelVersion(v string) *SegmentTypeInfo {
	s.ModelVersion = &v
	return s
}

// SetType sets the Type field's value.
func (s *SegmentTypeInfo) SetType(v string) *SegmentTypeInfo {
	s.Type = &v
	return s
}

// The size of the collection exceeds the allowed limit. For more information,
// see Guidelines and quotas in Amazon Rekognition in the Amazon Rekognition
// Developer Guide.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a shot detection segment detected in a video. For more
// information, see SegmentDetection.
type ShotSegment struct {
	_ struct{} `type:"structure"`

	// The confidence that Amazon Rekognition Video has in the accuracy of the detected
	// segment.
	Confidence *float64 `min:"50" type:"float"`

	// An Identifier for a shot detection segment detected in a video.
	Index *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShotSegment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShotSegment) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *ShotSegment) SetConfidence(v float64) *ShotSegment {
	s.Confidence = &v
	return s
}

// SetIndex sets the Index field's value.
func (s *ShotSegment) SetIndex(v int64) *ShotSegment {
	s.Index = &v
	return s
}

// Indicates whether or not the face is smiling, and the confidence level in
// the determination.
type Smile struct {
	_ struct{} `type:"structure"`

	// Level of confidence in the determination.
	Confidence *float64 `type:"float"`

	// Boolean value that indicates whether the face is smiling or not.
	Value *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Smile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Smile) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *Smile) SetConfidence(v float64) *Smile {
	s.Confidence = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Smile) SetValue(v bool) *Smile {
	s.Value = &v
	return s
}

type StartCelebrityRecognitionInput struct {
	_ struct{} `type:"structure"`

	// Idempotent token used to identify the start request. If you use the same
	// token with multiple StartCelebrityRecognition requests, the same JobId is
	// returned. Use ClientRequestToken to prevent the same job from being accidently
	// started more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// An identifier you specify that's returned in the completion notification
	// that's published to your Amazon Simple Notification Service topic. For example,
	// you can use JobTag to group related jobs and identify them in the completion
	// notification.
	JobTag *string `min:"1" type:"string"`

	// The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish
	// the completion status of the celebrity recognition analysis to. The Amazon
	// SNS topic must have a topic name that begins with AmazonRekognition if you
	// are using the AmazonRekognitionServiceRole permissions policy.
	NotificationChannel *NotificationChannel `type:"structure"`

	// The video in which you want to recognize celebrities. The video must be stored
	// in an Amazon S3 bucket.
	//
	// Video is a required field
	Video *Video `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCelebrityRecognitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCelebrityRecognitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCelebrityRecognitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCelebrityRecognitionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartCelebrityRecognitionInput) SetClientRequestToken(v string) *StartCelebrityRecognitionInput {
	s.ClientRequestToken = &v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartCelebrityRecognitionInput) SetJobTag(v string) *StartCelebrityRecognitionInput {
	s.JobTag = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartCelebrityRecognitionInput) SetNotificationChannel(v *NotificationChannel) *StartCelebrityRecognitionInput {
	s.NotificationChannel = v
	return s
}

// SetVideo sets the Video field's value.
func (s *StartCelebrityRecognitionInput) SetVideo(v *Video) *StartCelebrityRecognitionInput {
	s.Video = v
	return s
}

type StartCelebrityRecognitionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the celebrity recognition analysis job. Use JobId to identify
	// the job in a subsequent call to GetCelebrityRecognition.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCelebrityRecognitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCelebrityRecognitionOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartCelebrityRecognitionOutput) SetJobId(v string) *StartCelebrityRecognitionOutput {
	s.JobId = &v
	return s
}

type StartContentModerationInput struct {
	_ struct{} `type:"structure"`

	// Idempotent token used to identify the start request. If you use the same
	// token with multiple StartContentModeration requests, the same JobId is returned.
	// Use ClientRequestToken to prevent the same job from being accidently started
	// more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// An identifier you specify that's returned in the completion notification
	// that's published to your Amazon Simple Notification Service topic. For example,
	// you can use JobTag to group related jobs and identify them in the completion
	// notification.
	JobTag *string `min:"1" type:"string"`

	// Specifies the minimum confidence that Amazon Rekognition must have in order
	// to return a moderated content label. Confidence represents how certain Amazon
	// Rekognition is that the moderated content is correctly identified. 0 is the
	// lowest confidence. 100 is the highest confidence. Amazon Rekognition doesn't
	// return any moderated content labels with a confidence level lower than this
	// specified value. If you don't specify MinConfidence, GetContentModeration
	// returns labels with confidence values greater than or equal to 50 percent.
	MinConfidence *float64 `type:"float"`

	// The Amazon SNS topic ARN that you want Amazon Rekognition Video to publish
	// the completion status of the content analysis to. The Amazon SNS topic must
	// have a topic name that begins with AmazonRekognition if you are using the
	// AmazonRekognitionServiceRole permissions policy to access the topic.
	NotificationChannel *NotificationChannel `type:"structure"`

	// The video in which you want to detect inappropriate, unwanted, or offensive
	// content. The video must be stored in an Amazon S3 bucket.
	//
	// Video is a required field
	Video *Video `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartContentModerationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartContentModerationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartContentModerationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartContentModerationInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartContentModerationInput) SetClientRequestToken(v string) *StartContentModerationInput {
	s.ClientRequestToken = &v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartContentModerationInput) SetJobTag(v string) *StartContentModerationInput {
	s.JobTag = &v
	return s
}

// SetMinConfidence sets the MinConfidence field's value.
func (s *StartContentModerationInput) SetMinConfidence(v float64) *StartContentModerationInput {
	s.MinConfidence = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartContentModerationInput) SetNotificationChannel(v *NotificationChannel) *StartContentModerationInput {
	s.NotificationChannel = v
	return s
}

// SetVideo sets the Video field's value.
func (s *StartContentModerationInput) SetVideo(v *Video) *StartContentModerationInput {
	s.Video = v
	return s
}

type StartContentModerationOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the content analysis job. Use JobId to identify the job
	// in a subsequent call to GetContentModeration.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartContentModerationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartContentModerationOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartContentModerationOutput) SetJobId(v string) *StartContentModerationOutput {
	s.JobId = &v
	return s
}

type StartFaceDetectionInput struct {
	_ struct{} `type:"structure"`

	// Idempotent token used to identify the start request. If you use the same
	// token with multiple StartFaceDetection requests, the same JobId is returned.
	// Use ClientRequestToken to prevent the same job from being accidently started
	// more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// The face attributes you want returned.
	//
	// DEFAULT - The following subset of facial attributes are returned: BoundingBox,
	// Confidence, Pose, Quality and Landmarks.
	//
	// ALL - All facial attributes are returned.
	FaceAttributes *string `type:"string" enum:"FaceAttributes"`

	// An identifier you specify that's returned in the completion notification
	// that's published to your Amazon Simple Notification Service topic. For example,
	// you can use JobTag to group related jobs and identify them in the completion
	// notification.
	JobTag *string `min:"1" type:"string"`

	// The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video
	// to publish the completion status of the face detection operation. The Amazon
	// SNS topic must have a topic name that begins with AmazonRekognition if you
	// are using the AmazonRekognitionServiceRole permissions policy.
	NotificationChannel *NotificationChannel `type:"structure"`

	// The video in which you want to detect faces. The video must be stored in
	// an Amazon S3 bucket.
	//
	// Video is a required field
	Video *Video `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFaceDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFaceDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFaceDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFaceDetectionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartFaceDetectionInput) SetClientRequestToken(v string) *StartFaceDetectionInput {
	s.ClientRequestToken = &v
	return s
}

// SetFaceAttributes sets the FaceAttributes field's value.
func (s *StartFaceDetectionInput) SetFaceAttributes(v string) *StartFaceDetectionInput {
	s.FaceAttributes = &v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartFaceDetectionInput) SetJobTag(v string) *StartFaceDetectionInput {
	s.JobTag = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartFaceDetectionInput) SetNotificationChannel(v *NotificationChannel) *StartFaceDetectionInput {
	s.NotificationChannel = v
	return s
}

// SetVideo sets the Video field's value.
func (s *StartFaceDetectionInput) SetVideo(v *Video) *StartFaceDetectionInput {
	s.Video = v
	return s
}

type StartFaceDetectionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the face detection job. Use JobId to identify the job
	// in a subsequent call to GetFaceDetection.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFaceDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFaceDetectionOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartFaceDetectionOutput) SetJobId(v string) *StartFaceDetectionOutput {
	s.JobId = &v
	return s
}

type StartFaceSearchInput struct {
	_ struct{} `type:"structure"`

	// Idempotent token used to identify the start request. If you use the same
	// token with multiple StartFaceSearch requests, the same JobId is returned.
	// Use ClientRequestToken to prevent the same job from being accidently started
	// more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// ID of the collection that contains the faces you want to search for.
	//
	// CollectionId is a required field
	CollectionId *string `min:"1" type:"string" required:"true"`

	// The minimum confidence in the person match to return. For example, don't
	// return any matches where confidence in matches is less than 70%. The default
	// value is 80%.
	FaceMatchThreshold *float64 `type:"float"`

	// An identifier you specify that's returned in the completion notification
	// that's published to your Amazon Simple Notification Service topic. For example,
	// you can use JobTag to group related jobs and identify them in the completion
	// notification.
	JobTag *string `min:"1" type:"string"`

	// The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video
	// to publish the completion status of the search. The Amazon SNS topic must
	// have a topic name that begins with AmazonRekognition if you are using the
	// AmazonRekognitionServiceRole permissions policy to access the topic.
	NotificationChannel *NotificationChannel `type:"structure"`

	// The video you want to search. The video must be stored in an Amazon S3 bucket.
	//
	// Video is a required field
	Video *Video `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFaceSearchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFaceSearchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFaceSearchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFaceSearchInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.CollectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionId"))
	}
	if s.CollectionId != nil && len(*s.CollectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionId", 1))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartFaceSearchInput) SetClientRequestToken(v string) *StartFaceSearchInput {
	s.ClientRequestToken = &v
	return s
}

// SetCollectionId sets the CollectionId field's value.
func (s *StartFaceSearchInput) SetCollectionId(v string) *StartFaceSearchInput {
	s.CollectionId = &v
	return s
}

// SetFaceMatchThreshold sets the FaceMatchThreshold field's value.
func (s *StartFaceSearchInput) SetFaceMatchThreshold(v float64) *StartFaceSearchInput {
	s.FaceMatchThreshold = &v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartFaceSearchInput) SetJobTag(v string) *StartFaceSearchInput {
	s.JobTag = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartFaceSearchInput) SetNotificationChannel(v *NotificationChannel) *StartFaceSearchInput {
	s.NotificationChannel = v
	return s
}

// SetVideo sets the Video field's value.
func (s *StartFaceSearchInput) SetVideo(v *Video) *StartFaceSearchInput {
	s.Video = v
	return s
}

type StartFaceSearchOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the search job. Use JobId to identify the job in a subsequent
	// call to GetFaceSearch.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFaceSearchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartFaceSearchOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartFaceSearchOutput) SetJobId(v string) *StartFaceSearchOutput {
	s.JobId = &v
	return s
}

type StartLabelDetectionInput struct {
	_ struct{} `type:"structure"`

	// Idempotent token used to identify the start request. If you use the same
	// token with multiple StartLabelDetection requests, the same JobId is returned.
	// Use ClientRequestToken to prevent the same job from being accidently started
	// more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// An identifier you specify that's returned in the completion notification
	// that's published to your Amazon Simple Notification Service topic. For example,
	// you can use JobTag to group related jobs and identify them in the completion
	// notification.
	JobTag *string `min:"1" type:"string"`

	// Specifies the minimum confidence that Amazon Rekognition Video must have
	// in order to return a detected label. Confidence represents how certain Amazon
	// Rekognition is that a label is correctly identified.0 is the lowest confidence.
	// 100 is the highest confidence. Amazon Rekognition Video doesn't return any
	// labels with a confidence level lower than this specified value.
	//
	// If you don't specify MinConfidence, the operation returns labels with confidence
	// values greater than or equal to 50 percent.
	MinConfidence *float64 `type:"float"`

	// The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the
	// completion status of the label detection operation to. The Amazon SNS topic
	// must have a topic name that begins with AmazonRekognition if you are using
	// the AmazonRekognitionServiceRole permissions policy.
	NotificationChannel *NotificationChannel `type:"structure"`

	// The video in which you want to detect labels. The video must be stored in
	// an Amazon S3 bucket.
	//
	// Video is a required field
	Video *Video `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLabelDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLabelDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartLabelDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartLabelDetectionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartLabelDetectionInput) SetClientRequestToken(v string) *StartLabelDetectionInput {
	s.ClientRequestToken = &v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartLabelDetectionInput) SetJobTag(v string) *StartLabelDetectionInput {
	s.JobTag = &v
	return s
}

// SetMinConfidence sets the MinConfidence field's value.
func (s *StartLabelDetectionInput) SetMinConfidence(v float64) *StartLabelDetectionInput {
	s.MinConfidence = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartLabelDetectionInput) SetNotificationChannel(v *NotificationChannel) *StartLabelDetectionInput {
	s.NotificationChannel = v
	return s
}

// SetVideo sets the Video field's value.
func (s *StartLabelDetectionInput) SetVideo(v *Video) *StartLabelDetectionInput {
	s.Video = v
	return s
}

type StartLabelDetectionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the label detection job. Use JobId to identify the job
	// in a subsequent call to GetLabelDetection.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLabelDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartLabelDetectionOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartLabelDetectionOutput) SetJobId(v string) *StartLabelDetectionOutput {
	s.JobId = &v
	return s
}

type StartPersonTrackingInput struct {
	_ struct{} `type:"structure"`

	// Idempotent token used to identify the start request. If you use the same
	// token with multiple StartPersonTracking requests, the same JobId is returned.
	// Use ClientRequestToken to prevent the same job from being accidently started
	// more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// An identifier you specify that's returned in the completion notification
	// that's published to your Amazon Simple Notification Service topic. For example,
	// you can use JobTag to group related jobs and identify them in the completion
	// notification.
	JobTag *string `min:"1" type:"string"`

	// The Amazon SNS topic ARN you want Amazon Rekognition Video to publish the
	// completion status of the people detection operation to. The Amazon SNS topic
	// must have a topic name that begins with AmazonRekognition if you are using
	// the AmazonRekognitionServiceRole permissions policy.
	NotificationChannel *NotificationChannel `type:"structure"`

	// The video in which you want to detect people. The video must be stored in
	// an Amazon S3 bucket.
	//
	// Video is a required field
	Video *Video `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPersonTrackingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPersonTrackingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPersonTrackingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPersonTrackingInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartPersonTrackingInput) SetClientRequestToken(v string) *StartPersonTrackingInput {
	s.ClientRequestToken = &v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartPersonTrackingInput) SetJobTag(v string) *StartPersonTrackingInput {
	s.JobTag = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartPersonTrackingInput) SetNotificationChannel(v *NotificationChannel) *StartPersonTrackingInput {
	s.NotificationChannel = v
	return s
}

// SetVideo sets the Video field's value.
func (s *StartPersonTrackingInput) SetVideo(v *Video) *StartPersonTrackingInput {
	s.Video = v
	return s
}

type StartPersonTrackingOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the person detection job. Use JobId to identify the job
	// in a subsequent call to GetPersonTracking.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPersonTrackingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPersonTrackingOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartPersonTrackingOutput) SetJobId(v string) *StartPersonTrackingOutput {
	s.JobId = &v
	return s
}

type StartProjectVersionInput struct {
	_ struct{} `type:"structure"`

	// The minimum number of inference units to use. A single inference unit represents
	// 1 hour of processing and can support up to 5 Transaction Pers Second (TPS).
	// Use a higher number to increase the TPS throughput of your model. You are
	// charged for the number of inference units that you use.
	//
	// MinInferenceUnits is a required field
	MinInferenceUnits *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Name(ARN) of the model version that you want to start.
	//
	// ProjectVersionArn is a required field
	ProjectVersionArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProjectVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProjectVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartProjectVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartProjectVersionInput"}
	if s.MinInferenceUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("MinInferenceUnits"))
	}
	if s.MinInferenceUnits != nil && *s.MinInferenceUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinInferenceUnits", 1))
	}
	if s.ProjectVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectVersionArn"))
	}
	if s.ProjectVersionArn != nil && len(*s.ProjectVersionArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectVersionArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMinInferenceUnits sets the MinInferenceUnits field's value.
func (s *StartProjectVersionInput) SetMinInferenceUnits(v int64) *StartProjectVersionInput {
	s.MinInferenceUnits = &v
	return s
}

// SetProjectVersionArn sets the ProjectVersionArn field's value.
func (s *StartProjectVersionInput) SetProjectVersionArn(v string) *StartProjectVersionInput {
	s.ProjectVersionArn = &v
	return s
}

type StartProjectVersionOutput struct {
	_ struct{} `type:"structure"`

	// The current running status of the model.
	Status *string `type:"string" enum:"ProjectVersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProjectVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartProjectVersionOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *StartProjectVersionOutput) SetStatus(v string) *StartProjectVersionOutput {
	s.Status = &v
	return s
}

// Filters applied to the technical cue or shot detection segments. For more
// information, see StartSegmentDetection.
type StartSegmentDetectionFilters struct {
	_ struct{} `type:"structure"`

	// Filters that are specific to shot detections.
	ShotFilter *StartShotDetectionFilter `type:"structure"`

	// Filters that are specific to technical cues.
	TechnicalCueFilter *StartTechnicalCueDetectionFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSegmentDetectionFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSegmentDetectionFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSegmentDetectionFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSegmentDetectionFilters"}
	if s.ShotFilter != nil {
		if err := s.ShotFilter.Validate(); err != nil {
			invalidParams.AddNested("ShotFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TechnicalCueFilter != nil {
		if err := s.TechnicalCueFilter.Validate(); err != nil {
			invalidParams.AddNested("TechnicalCueFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShotFilter sets the ShotFilter field's value.
func (s *StartSegmentDetectionFilters) SetShotFilter(v *StartShotDetectionFilter) *StartSegmentDetectionFilters {
	s.ShotFilter = v
	return s
}

// SetTechnicalCueFilter sets the TechnicalCueFilter field's value.
func (s *StartSegmentDetectionFilters) SetTechnicalCueFilter(v *StartTechnicalCueDetectionFilter) *StartSegmentDetectionFilters {
	s.TechnicalCueFilter = v
	return s
}

type StartSegmentDetectionInput struct {
	_ struct{} `type:"structure"`

	// Idempotent token used to identify the start request. If you use the same
	// token with multiple StartSegmentDetection requests, the same JobId is returned.
	// Use ClientRequestToken to prevent the same job from being accidently started
	// more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// Filters for technical cue or shot detection.
	Filters *StartSegmentDetectionFilters `type:"structure"`

	// An identifier you specify that's returned in the completion notification
	// that's published to your Amazon Simple Notification Service topic. For example,
	// you can use JobTag to group related jobs and identify them in the completion
	// notification.
	JobTag *string `min:"1" type:"string"`

	// The ARN of the Amazon SNS topic to which you want Amazon Rekognition Video
	// to publish the completion status of the segment detection operation. Note
	// that the Amazon SNS topic must have a topic name that begins with AmazonRekognition
	// if you are using the AmazonRekognitionServiceRole permissions policy to access
	// the topic.
	NotificationChannel *NotificationChannel `type:"structure"`

	// An array of segment types to detect in the video. Valid values are TECHNICAL_CUE
	// and SHOT.
	//
	// SegmentTypes is a required field
	SegmentTypes []*string `min:"1" type:"list" required:"true" enum:"SegmentType"`

	// Video file stored in an Amazon S3 bucket. Amazon Rekognition video start
	// operations such as StartLabelDetection use Video to specify a video for analysis.
	// The supported file formats are .mp4, .mov and .avi.
	//
	// Video is a required field
	Video *Video `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSegmentDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSegmentDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSegmentDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSegmentDetectionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.SegmentTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentTypes"))
	}
	if s.SegmentTypes != nil && len(s.SegmentTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SegmentTypes", 1))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartSegmentDetectionInput) SetClientRequestToken(v string) *StartSegmentDetectionInput {
	s.ClientRequestToken = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *StartSegmentDetectionInput) SetFilters(v *StartSegmentDetectionFilters) *StartSegmentDetectionInput {
	s.Filters = v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartSegmentDetectionInput) SetJobTag(v string) *StartSegmentDetectionInput {
	s.JobTag = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartSegmentDetectionInput) SetNotificationChannel(v *NotificationChannel) *StartSegmentDetectionInput {
	s.NotificationChannel = v
	return s
}

// SetSegmentTypes sets the SegmentTypes field's value.
func (s *StartSegmentDetectionInput) SetSegmentTypes(v []*string) *StartSegmentDetectionInput {
	s.SegmentTypes = v
	return s
}

// SetVideo sets the Video field's value.
func (s *StartSegmentDetectionInput) SetVideo(v *Video) *StartSegmentDetectionInput {
	s.Video = v
	return s
}

type StartSegmentDetectionOutput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for the segment detection job. The JobId is returned from
	// StartSegmentDetection.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSegmentDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSegmentDetectionOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartSegmentDetectionOutput) SetJobId(v string) *StartSegmentDetectionOutput {
	s.JobId = &v
	return s
}

// Filters for the shot detection segments returned by GetSegmentDetection.
// For more information, see StartSegmentDetectionFilters.
type StartShotDetectionFilter struct {
	_ struct{} `type:"structure"`

	// Specifies the minimum confidence that Amazon Rekognition Video must have
	// in order to return a detected segment. Confidence represents how certain
	// Amazon Rekognition is that a segment is correctly identified. 0 is the lowest
	// confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't
	// return any segments with a confidence level lower than this specified value.
	//
	// If you don't specify MinSegmentConfidence, the GetSegmentDetection returns
	// segments with confidence values greater than or equal to 50 percent.
	MinSegmentConfidence *float64 `min:"50" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartShotDetectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartShotDetectionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartShotDetectionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartShotDetectionFilter"}
	if s.MinSegmentConfidence != nil && *s.MinSegmentConfidence < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MinSegmentConfidence", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMinSegmentConfidence sets the MinSegmentConfidence field's value.
func (s *StartShotDetectionFilter) SetMinSegmentConfidence(v float64) *StartShotDetectionFilter {
	s.MinSegmentConfidence = &v
	return s
}

type StartStreamProcessorInput struct {
	_ struct{} `type:"structure"`

	// The name of the stream processor to start processing.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies the starting point in the Kinesis stream to start processing. You
	// can use the producer timestamp or the fragment number. For more information,
	// see Fragment (https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_reader_Fragment.html).
	//
	// This is a required parameter for label detection stream processors and should
	// not be used to start a face search stream processor.
	StartSelector *StreamProcessingStartSelector `type:"structure"`

	// Specifies when to stop processing the stream. You can specify a maximum amount
	// of time to process the video.
	//
	// This is a required parameter for label detection stream processors and should
	// not be used to start a face search stream processor.
	StopSelector *StreamProcessingStopSelector `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamProcessorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamProcessorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartStreamProcessorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartStreamProcessorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.StartSelector != nil {
		if err := s.StartSelector.Validate(); err != nil {
			invalidParams.AddNested("StartSelector", err.(request.ErrInvalidParams))
		}
	}
	if s.StopSelector != nil {
		if err := s.StopSelector.Validate(); err != nil {
			invalidParams.AddNested("StopSelector", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartStreamProcessorInput) SetName(v string) *StartStreamProcessorInput {
	s.Name = &v
	return s
}

// SetStartSelector sets the StartSelector field's value.
func (s *StartStreamProcessorInput) SetStartSelector(v *StreamProcessingStartSelector) *StartStreamProcessorInput {
	s.StartSelector = v
	return s
}

// SetStopSelector sets the StopSelector field's value.
func (s *StartStreamProcessorInput) SetStopSelector(v *StreamProcessingStopSelector) *StartStreamProcessorInput {
	s.StopSelector = v
	return s
}

type StartStreamProcessorOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the stream processing session.
	SessionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamProcessorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartStreamProcessorOutput) GoString() string {
	return s.String()
}

// SetSessionId sets the SessionId field's value.
func (s *StartStreamProcessorOutput) SetSessionId(v string) *StartStreamProcessorOutput {
	s.SessionId = &v
	return s
}

// Filters for the technical segments returned by GetSegmentDetection. For more
// information, see StartSegmentDetectionFilters.
type StartTechnicalCueDetectionFilter struct {
	_ struct{} `type:"structure"`

	// A filter that allows you to control the black frame detection by specifying
	// the black levels and pixel coverage of black pixels in a frame. Videos can
	// come from multiple sources, formats, and time periods, with different standards
	// and varying noise levels for black frames that need to be accounted for.
	BlackFrame *BlackFrame `type:"structure"`

	// Specifies the minimum confidence that Amazon Rekognition Video must have
	// in order to return a detected segment. Confidence represents how certain
	// Amazon Rekognition is that a segment is correctly identified. 0 is the lowest
	// confidence. 100 is the highest confidence. Amazon Rekognition Video doesn't
	// return any segments with a confidence level lower than this specified value.
	//
	// If you don't specify MinSegmentConfidence, GetSegmentDetection returns segments
	// with confidence values greater than or equal to 50 percent.
	MinSegmentConfidence *float64 `min:"50" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTechnicalCueDetectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTechnicalCueDetectionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTechnicalCueDetectionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTechnicalCueDetectionFilter"}
	if s.MinSegmentConfidence != nil && *s.MinSegmentConfidence < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MinSegmentConfidence", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlackFrame sets the BlackFrame field's value.
func (s *StartTechnicalCueDetectionFilter) SetBlackFrame(v *BlackFrame) *StartTechnicalCueDetectionFilter {
	s.BlackFrame = v
	return s
}

// SetMinSegmentConfidence sets the MinSegmentConfidence field's value.
func (s *StartTechnicalCueDetectionFilter) SetMinSegmentConfidence(v float64) *StartTechnicalCueDetectionFilter {
	s.MinSegmentConfidence = &v
	return s
}

// Set of optional parameters that let you set the criteria text must meet to
// be included in your response. WordFilter looks at a word's height, width
// and minimum confidence. RegionOfInterest lets you set a specific region of
// the screen to look for text in.
type StartTextDetectionFilters struct {
	_ struct{} `type:"structure"`

	// Filter focusing on a certain area of the frame. Uses a BoundingBox object
	// to set the region of the screen.
	RegionsOfInterest []*RegionOfInterest `type:"list"`

	// Filters focusing on qualities of the text, such as confidence or size.
	WordFilter *DetectionFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTextDetectionFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTextDetectionFilters) GoString() string {
	return s.String()
}

// SetRegionsOfInterest sets the RegionsOfInterest field's value.
func (s *StartTextDetectionFilters) SetRegionsOfInterest(v []*RegionOfInterest) *StartTextDetectionFilters {
	s.RegionsOfInterest = v
	return s
}

// SetWordFilter sets the WordFilter field's value.
func (s *StartTextDetectionFilters) SetWordFilter(v *DetectionFilter) *StartTextDetectionFilters {
	s.WordFilter = v
	return s
}

type StartTextDetectionInput struct {
	_ struct{} `type:"structure"`

	// Idempotent token used to identify the start request. If you use the same
	// token with multiple StartTextDetection requests, the same JobId is returned.
	// Use ClientRequestToken to prevent the same job from being accidentaly started
	// more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// Optional parameters that let you set criteria the text must meet to be included
	// in your response.
	Filters *StartTextDetectionFilters `type:"structure"`

	// An identifier returned in the completion status published by your Amazon
	// Simple Notification Service topic. For example, you can use JobTag to group
	// related jobs and identify them in the completion notification.
	JobTag *string `min:"1" type:"string"`

	// The Amazon Simple Notification Service topic to which Amazon Rekognition
	// publishes the completion status of a video analysis operation. For more information,
	// see Calling Amazon Rekognition Video operations (https://docs.aws.amazon.com/rekognition/latest/dg/api-video.html).
	// Note that the Amazon SNS topic must have a topic name that begins with AmazonRekognition
	// if you are using the AmazonRekognitionServiceRole permissions policy to access
	// the topic. For more information, see Giving access to multiple Amazon SNS
	// topics (https://docs.aws.amazon.com/rekognition/latest/dg/api-video-roles.html#api-video-roles-all-topics).
	NotificationChannel *NotificationChannel `type:"structure"`

	// Video file stored in an Amazon S3 bucket. Amazon Rekognition video start
	// operations such as StartLabelDetection use Video to specify a video for analysis.
	// The supported file formats are .mp4, .mov and .avi.
	//
	// Video is a required field
	Video *Video `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTextDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTextDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTextDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTextDetectionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartTextDetectionInput) SetClientRequestToken(v string) *StartTextDetectionInput {
	s.ClientRequestToken = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *StartTextDetectionInput) SetFilters(v *StartTextDetectionFilters) *StartTextDetectionInput {
	s.Filters = v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartTextDetectionInput) SetJobTag(v string) *StartTextDetectionInput {
	s.JobTag = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartTextDetectionInput) SetNotificationChannel(v *NotificationChannel) *StartTextDetectionInput {
	s.NotificationChannel = v
	return s
}

// SetVideo sets the Video field's value.
func (s *StartTextDetectionInput) SetVideo(v *Video) *StartTextDetectionInput {
	s.Video = v
	return s
}

type StartTextDetectionOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for the text detection job. Use JobId to identify the job in a
	// subsequent call to GetTextDetection.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTextDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTextDetectionOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartTextDetectionOutput) SetJobId(v string) *StartTextDetectionOutput {
	s.JobId = &v
	return s
}

type StopProjectVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the model version that you want to delete.
	//
	// This operation requires permissions to perform the rekognition:StopProjectVersion
	// action.
	//
	// ProjectVersionArn is a required field
	ProjectVersionArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopProjectVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopProjectVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopProjectVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopProjectVersionInput"}
	if s.ProjectVersionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectVersionArn"))
	}
	if s.ProjectVersionArn != nil && len(*s.ProjectVersionArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ProjectVersionArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectVersionArn sets the ProjectVersionArn field's value.
func (s *StopProjectVersionInput) SetProjectVersionArn(v string) *StopProjectVersionInput {
	s.ProjectVersionArn = &v
	return s
}

type StopProjectVersionOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the stop operation.
	Status *string `type:"string" enum:"ProjectVersionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopProjectVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopProjectVersionOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *StopProjectVersionOutput) SetStatus(v string) *StopProjectVersionOutput {
	s.Status = &v
	return s
}

type StopStreamProcessorInput struct {
	_ struct{} `type:"structure"`

	// The name of a stream processor created by CreateStreamProcessor.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamProcessorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamProcessorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStreamProcessorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopStreamProcessorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopStreamProcessorInput) SetName(v string) *StopStreamProcessorInput {
	s.Name = &v
	return s
}

type StopStreamProcessorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamProcessorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopStreamProcessorOutput) GoString() string {
	return s.String()
}

type StreamProcessingStartSelector struct {
	_ struct{} `type:"structure"`

	// Specifies the starting point in the stream to start processing. This can
	// be done with a timestamp or a fragment number in a Kinesis stream.
	KVSStreamStartSelector *KinesisVideoStreamStartSelector `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessingStartSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessingStartSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamProcessingStartSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamProcessingStartSelector"}
	if s.KVSStreamStartSelector != nil {
		if err := s.KVSStreamStartSelector.Validate(); err != nil {
			invalidParams.AddNested("KVSStreamStartSelector", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKVSStreamStartSelector sets the KVSStreamStartSelector field's value.
func (s *StreamProcessingStartSelector) SetKVSStreamStartSelector(v *KinesisVideoStreamStartSelector) *StreamProcessingStartSelector {
	s.KVSStreamStartSelector = v
	return s
}

// Specifies when to stop processing the stream. You can specify a maximum amount
// of time to process the video.
type StreamProcessingStopSelector struct {
	_ struct{} `type:"structure"`

	// Specifies the maximum amount of time in seconds that you want the stream
	// to be processed. The largest amount of time is 2 minutes. The default is
	// 10 seconds.
	MaxDurationInSeconds *int64 `min:"1" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessingStopSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessingStopSelector) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamProcessingStopSelector) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamProcessingStopSelector"}
	if s.MaxDurationInSeconds != nil && *s.MaxDurationInSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxDurationInSeconds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxDurationInSeconds sets the MaxDurationInSeconds field's value.
func (s *StreamProcessingStopSelector) SetMaxDurationInSeconds(v int64) *StreamProcessingStopSelector {
	s.MaxDurationInSeconds = &v
	return s
}

// An object that recognizes faces or labels in a streaming video. An Amazon
// Rekognition stream processor is created by a call to CreateStreamProcessor.
// The request parameters for CreateStreamProcessor describe the Kinesis video
// stream source for the streaming video, face recognition parameters, and where
// to stream the analysis resullts.
type StreamProcessor struct {
	_ struct{} `type:"structure"`

	// Name of the Amazon Rekognition stream processor.
	Name *string `min:"1" type:"string"`

	// Current status of the Amazon Rekognition stream processor.
	Status *string `type:"string" enum:"StreamProcessorStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessor) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *StreamProcessor) SetName(v string) *StreamProcessor {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StreamProcessor) SetStatus(v string) *StreamProcessor {
	s.Status = &v
	return s
}

// Allows you to opt in or opt out to share data with Rekognition to improve
// model performance. You can choose this option at the account level or on
// a per-stream basis. Note that if you opt out at the account level this setting
// is ignored on individual streams.
type StreamProcessorDataSharingPreference struct {
	_ struct{} `type:"structure"`

	// If this option is set to true, you choose to share data with Rekognition
	// to improve model performance.
	//
	// OptIn is a required field
	OptIn *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorDataSharingPreference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorDataSharingPreference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamProcessorDataSharingPreference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamProcessorDataSharingPreference"}
	if s.OptIn == nil {
		invalidParams.Add(request.NewErrParamRequired("OptIn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOptIn sets the OptIn field's value.
func (s *StreamProcessorDataSharingPreference) SetOptIn(v bool) *StreamProcessorDataSharingPreference {
	s.OptIn = &v
	return s
}

// Information about the source streaming video.
type StreamProcessorInput struct {
	_ struct{} `type:"structure"`

	// The Kinesis video stream input stream for the source streaming video.
	KinesisVideoStream *KinesisVideoStream `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorInput) GoString() string {
	return s.String()
}

// SetKinesisVideoStream sets the KinesisVideoStream field's value.
func (s *StreamProcessorInput) SetKinesisVideoStream(v *KinesisVideoStream) *StreamProcessorInput {
	s.KinesisVideoStream = v
	return s
}

// The Amazon Simple Notification Service topic to which Amazon Rekognition
// publishes the object detection results and completion status of a video analysis
// operation.
//
// Amazon Rekognition publishes a notification the first time an object of interest
// or a person is detected in the video stream. For example, if Amazon Rekognition
// detects a person at second 2, a pet at second 4, and a person again at second
// 5, Amazon Rekognition sends 2 object class detected notifications, one for
// a person at second 2 and one for a pet at second 4.
//
// Amazon Rekognition also publishes an an end-of-session notification with
// a summary when the stream processing session is complete.
type StreamProcessorNotificationChannel struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the Amazon Amazon Simple Notification
	// Service topic to which Amazon Rekognition posts the completion status.
	//
	// SNSTopicArn is a required field
	SNSTopicArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorNotificationChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorNotificationChannel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamProcessorNotificationChannel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamProcessorNotificationChannel"}
	if s.SNSTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SNSTopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSNSTopicArn sets the SNSTopicArn field's value.
func (s *StreamProcessorNotificationChannel) SetSNSTopicArn(v string) *StreamProcessorNotificationChannel {
	s.SNSTopicArn = &v
	return s
}

// Information about the Amazon Kinesis Data Streams stream to which a Amazon
// Rekognition Video stream processor streams the results of a video analysis.
// For more information, see CreateStreamProcessor in the Amazon Rekognition
// Developer Guide.
type StreamProcessorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Kinesis Data Streams stream to which the Amazon Rekognition stream
	// processor streams the analysis results.
	KinesisDataStream *KinesisDataStream `type:"structure"`

	// The Amazon S3 bucket location to which Amazon Rekognition publishes the detailed
	// inference results of a video analysis operation.
	S3Destination *S3Destination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorOutput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamProcessorOutput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamProcessorOutput"}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKinesisDataStream sets the KinesisDataStream field's value.
func (s *StreamProcessorOutput) SetKinesisDataStream(v *KinesisDataStream) *StreamProcessorOutput {
	s.KinesisDataStream = v
	return s
}

// SetS3Destination sets the S3Destination field's value.
func (s *StreamProcessorOutput) SetS3Destination(v *S3Destination) *StreamProcessorOutput {
	s.S3Destination = v
	return s
}

// Input parameters used in a streaming video analyzed by a Amazon Rekognition
// stream processor. You can use FaceSearch to recognize faces in a streaming
// video, or you can use ConnectedHome to detect labels.
type StreamProcessorSettings struct {
	_ struct{} `type:"structure"`

	// Label detection settings to use on a streaming video. Defining the settings
	// is required in the request parameter for CreateStreamProcessor. Including
	// this setting in the CreateStreamProcessor request enables you to use the
	// stream processor for label detection. You can then select what you want the
	// stream processor to detect, such as people or pets. When the stream processor
	// has started, one notification is sent for each object class specified. For
	// example, if packages and pets are selected, one SNS notification is published
	// the first time a package is detected and one SNS notification is published
	// the first time a pet is detected, as well as an end-of-session summary.
	ConnectedHome *ConnectedHomeSettings `type:"structure"`

	// Face search settings to use on a streaming video.
	FaceSearch *FaceSearchSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamProcessorSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamProcessorSettings"}
	if s.ConnectedHome != nil {
		if err := s.ConnectedHome.Validate(); err != nil {
			invalidParams.AddNested("ConnectedHome", err.(request.ErrInvalidParams))
		}
	}
	if s.FaceSearch != nil {
		if err := s.FaceSearch.Validate(); err != nil {
			invalidParams.AddNested("FaceSearch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectedHome sets the ConnectedHome field's value.
func (s *StreamProcessorSettings) SetConnectedHome(v *ConnectedHomeSettings) *StreamProcessorSettings {
	s.ConnectedHome = v
	return s
}

// SetFaceSearch sets the FaceSearch field's value.
func (s *StreamProcessorSettings) SetFaceSearch(v *FaceSearchSettings) *StreamProcessorSettings {
	s.FaceSearch = v
	return s
}

// The stream processor settings that you want to update. ConnectedHome settings
// can be updated to detect different labels with a different minimum confidence.
type StreamProcessorSettingsForUpdate struct {
	_ struct{} `type:"structure"`

	// The label detection settings you want to use for your stream processor.
	ConnectedHomeForUpdate *ConnectedHomeSettingsForUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorSettingsForUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StreamProcessorSettingsForUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamProcessorSettingsForUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamProcessorSettingsForUpdate"}
	if s.ConnectedHomeForUpdate != nil {
		if err := s.ConnectedHomeForUpdate.Validate(); err != nil {
			invalidParams.AddNested("ConnectedHomeForUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectedHomeForUpdate sets the ConnectedHomeForUpdate field's value.
func (s *StreamProcessorSettingsForUpdate) SetConnectedHomeForUpdate(v *ConnectedHomeSettingsForUpdate) *StreamProcessorSettingsForUpdate {
	s.ConnectedHomeForUpdate = v
	return s
}

// The S3 bucket that contains the training summary. The training summary includes
// aggregated evaluation metrics for the entire testing dataset and metrics
// for each individual label.
//
// You get the training summary S3 bucket location by calling DescribeProjectVersions.
type Summary struct {
	_ struct{} `type:"structure"`

	// Provides the S3 bucket name and object name.
	//
	// The region for the S3 bucket containing the S3 object must match the region
	// you use for Amazon Rekognition operations.
	//
	// For Amazon Rekognition to process an S3 object, the user must have permission
	// to access the S3 object. For more information, see How Amazon Rekognition
	// works with IAM in the Amazon Rekognition Developer Guide.
	S3Object *S3Object `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Summary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Summary) GoString() string {
	return s.String()
}

// SetS3Object sets the S3Object field's value.
func (s *Summary) SetS3Object(v *S3Object) *Summary {
	s.S3Object = v
	return s
}

// Indicates whether or not the face is wearing sunglasses, and the confidence
// level in the determination.
type Sunglasses struct {
	_ struct{} `type:"structure"`

	// Level of confidence in the determination.
	Confidence *float64 `type:"float"`

	// Boolean value that indicates whether the face is wearing sunglasses or not.
	Value *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sunglasses) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Sunglasses) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *Sunglasses) SetConfidence(v float64) *Sunglasses {
	s.Confidence = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Sunglasses) SetValue(v bool) *Sunglasses {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the model, collection, or stream processor
	// that you want to assign the tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// The key-value tags to assign to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Information about a technical cue segment. For more information, see SegmentDetection.
type TechnicalCueSegment struct {
	_ struct{} `type:"structure"`

	// The confidence that Amazon Rekognition Video has in the accuracy of the detected
	// segment.
	Confidence *float64 `min:"50" type:"float"`

	// The type of the technical cue.
	Type *string `type:"string" enum:"TechnicalCueType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TechnicalCueSegment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TechnicalCueSegment) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *TechnicalCueSegment) SetConfidence(v float64) *TechnicalCueSegment {
	s.Confidence = &v
	return s
}

// SetType sets the Type field's value.
func (s *TechnicalCueSegment) SetType(v string) *TechnicalCueSegment {
	s.Type = &v
	return s
}

// The dataset used for testing. Optionally, if AutoCreate is set, Amazon Rekognition
// Custom Labels uses the training dataset to create a test dataset with a temporary
// split of the training dataset.
type TestingData struct {
	_ struct{} `type:"structure"`

	// The assets used for testing.
	Assets []*Asset `type:"list"`

	// If specified, Amazon Rekognition Custom Labels temporarily splits the training
	// dataset (80%) to create a test dataset (20%) for the training job. After
	// training completes, the test dataset is not stored and the training dataset
	// reverts to its previous size.
	AutoCreate *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestingData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestingData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestingData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestingData"}
	if s.Assets != nil {
		for i, v := range s.Assets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Assets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssets sets the Assets field's value.
func (s *TestingData) SetAssets(v []*Asset) *TestingData {
	s.Assets = v
	return s
}

// SetAutoCreate sets the AutoCreate field's value.
func (s *TestingData) SetAutoCreate(v bool) *TestingData {
	s.AutoCreate = &v
	return s
}

// Sagemaker Groundtruth format manifest files for the input, output and validation
// datasets that are used and created during testing.
type TestingDataResult struct {
	_ struct{} `type:"structure"`

	// The testing dataset that was supplied for training.
	Input *TestingData `type:"structure"`

	// The subset of the dataset that was actually tested. Some images (assets)
	// might not be tested due to file formatting and other issues.
	Output *TestingData `type:"structure"`

	// The location of the data validation manifest. The data validation manifest
	// is created for the test dataset during model training.
	Validation *ValidationData `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestingDataResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestingDataResult) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *TestingDataResult) SetInput(v *TestingData) *TestingDataResult {
	s.Input = v
	return s
}

// SetOutput sets the Output field's value.
func (s *TestingDataResult) SetOutput(v *TestingData) *TestingDataResult {
	s.Output = v
	return s
}

// SetValidation sets the Validation field's value.
func (s *TestingDataResult) SetValidation(v *ValidationData) *TestingDataResult {
	s.Validation = v
	return s
}

// Information about a word or line of text detected by DetectText.
//
// The DetectedText field contains the text that Amazon Rekognition detected
// in the image.
//
// Every word and line has an identifier (Id). Each word belongs to a line and
// has a parent identifier (ParentId) that identifies the line of text in which
// the word appears. The word Id is also an index for the word within a line
// of words.
//
// For more information, see Detecting text in the Amazon Rekognition Developer
// Guide.
type TextDetection struct {
	_ struct{} `type:"structure"`

	// The confidence that Amazon Rekognition has in the accuracy of the detected
	// text and the accuracy of the geometry points around the detected text.
	Confidence *float64 `type:"float"`

	// The word or line of text recognized by Amazon Rekognition.
	DetectedText *string `type:"string"`

	// The location of the detected text on the image. Includes an axis aligned
	// coarse bounding box surrounding the text and a finer grain polygon for more
	// accurate spatial information.
	Geometry *Geometry `type:"structure"`

	// The identifier for the detected text. The identifier is only unique for a
	// single call to DetectText.
	Id *int64 `type:"integer"`

	// The Parent identifier for the detected text identified by the value of ID.
	// If the type of detected text is LINE, the value of ParentId is Null.
	ParentId *int64 `type:"integer"`

	// The type of text that was detected.
	Type *string `type:"string" enum:"TextTypes"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextDetection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextDetection) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *TextDetection) SetConfidence(v float64) *TextDetection {
	s.Confidence = &v
	return s
}

// SetDetectedText sets the DetectedText field's value.
func (s *TextDetection) SetDetectedText(v string) *TextDetection {
	s.DetectedText = &v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *TextDetection) SetGeometry(v *Geometry) *TextDetection {
	s.Geometry = v
	return s
}

// SetId sets the Id field's value.
func (s *TextDetection) SetId(v int64) *TextDetection {
	s.Id = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *TextDetection) SetParentId(v int64) *TextDetection {
	s.ParentId = &v
	return s
}

// SetType sets the Type field's value.
func (s *TextDetection) SetType(v string) *TextDetection {
	s.Type = &v
	return s
}

// Information about text detected in a video. Incudes the detected text, the
// time in milliseconds from the start of the video that the text was detected,
// and where it was detected on the screen.
type TextDetectionResult struct {
	_ struct{} `type:"structure"`

	// Details about text detected in a video.
	TextDetection *TextDetection `type:"structure"`

	// The time, in milliseconds from the start of the video, that the text was
	// detected.
	Timestamp *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextDetectionResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextDetectionResult) GoString() string {
	return s.String()
}

// SetTextDetection sets the TextDetection field's value.
func (s *TextDetectionResult) SetTextDetection(v *TextDetection) *TextDetectionResult {
	s.TextDetection = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *TextDetectionResult) SetTimestamp(v int64) *TextDetectionResult {
	s.Timestamp = &v
	return s
}

// Amazon Rekognition is temporarily unable to process the request. Try your
// call again.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The dataset used for training.
type TrainingData struct {
	_ struct{} `type:"structure"`

	// A Sagemaker GroundTruth manifest file that contains the training images (assets).
	Assets []*Asset `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrainingData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrainingData"}
	if s.Assets != nil {
		for i, v := range s.Assets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Assets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssets sets the Assets field's value.
func (s *TrainingData) SetAssets(v []*Asset) *TrainingData {
	s.Assets = v
	return s
}

// Sagemaker Groundtruth format manifest files for the input, output and validation
// datasets that are used and created during testing.
type TrainingDataResult struct {
	_ struct{} `type:"structure"`

	// The training assets that you supplied for training.
	Input *TrainingData `type:"structure"`

	// The images (assets) that were actually trained by Amazon Rekognition Custom
	// Labels.
	Output *TrainingData `type:"structure"`

	// The location of the data validation manifest. The data validation manifest
	// is created for the training dataset during model training.
	Validation *ValidationData `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDataResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDataResult) GoString() string {
	return s.String()
}

// SetInput sets the Input field's value.
func (s *TrainingDataResult) SetInput(v *TrainingData) *TrainingDataResult {
	s.Input = v
	return s
}

// SetOutput sets the Output field's value.
func (s *TrainingDataResult) SetOutput(v *TrainingData) *TrainingDataResult {
	s.Output = v
	return s
}

// SetValidation sets the Validation field's value.
func (s *TrainingDataResult) SetValidation(v *ValidationData) *TrainingDataResult {
	s.Validation = v
	return s
}

// A face that IndexFaces detected, but didn't index. Use the Reasons response
// attribute to determine why a face wasn't indexed.
type UnindexedFace struct {
	_ struct{} `type:"structure"`

	// The structure that contains attributes of a face that IndexFacesdetected,
	// but didn't index.
	FaceDetail *FaceDetail `type:"structure"`

	// An array of reasons that specify why a face wasn't indexed.
	//
	//    * EXTREME_POSE - The face is at a pose that can't be detected. For example,
	//    the head is turned too far away from the camera.
	//
	//    * EXCEEDS_MAX_FACES - The number of faces detected is already higher than
	//    that specified by the MaxFaces input parameter for IndexFaces.
	//
	//    * LOW_BRIGHTNESS - The image is too dark.
	//
	//    * LOW_SHARPNESS - The image is too blurry.
	//
	//    * LOW_CONFIDENCE - The face was detected with a low confidence.
	//
	//    * SMALL_BOUNDING_BOX - The bounding box around the face is too small.
	Reasons []*string `type:"list" enum:"Reason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnindexedFace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnindexedFace) GoString() string {
	return s.String()
}

// SetFaceDetail sets the FaceDetail field's value.
func (s *UnindexedFace) SetFaceDetail(v *FaceDetail) *UnindexedFace {
	s.FaceDetail = v
	return s
}

// SetReasons sets the Reasons field's value.
func (s *UnindexedFace) SetReasons(v []*string) *UnindexedFace {
	s.Reasons = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the model, collection, or stream processor
	// that you want to remove the tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`

	// A list of the tags that you want to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDatasetEntriesInput struct {
	_ struct{} `type:"structure"`

	// The changes that you want to make to the dataset.
	//
	// Changes is a required field
	Changes *DatasetChanges `type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the dataset that you want to update.
	//
	// DatasetArn is a required field
	DatasetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetEntriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetEntriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatasetEntriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatasetEntriesInput"}
	if s.Changes == nil {
		invalidParams.Add(request.NewErrParamRequired("Changes"))
	}
	if s.DatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DatasetArn"))
	}
	if s.DatasetArn != nil && len(*s.DatasetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DatasetArn", 20))
	}
	if s.Changes != nil {
		if err := s.Changes.Validate(); err != nil {
			invalidParams.AddNested("Changes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChanges sets the Changes field's value.
func (s *UpdateDatasetEntriesInput) SetChanges(v *DatasetChanges) *UpdateDatasetEntriesInput {
	s.Changes = v
	return s
}

// SetDatasetArn sets the DatasetArn field's value.
func (s *UpdateDatasetEntriesInput) SetDatasetArn(v string) *UpdateDatasetEntriesInput {
	s.DatasetArn = &v
	return s
}

type UpdateDatasetEntriesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetEntriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDatasetEntriesOutput) GoString() string {
	return s.String()
}

type UpdateStreamProcessorInput struct {
	_ struct{} `type:"structure"`

	// Shows whether you are sharing data with Rekognition to improve model performance.
	// You can choose this option at the account level or on a per-stream basis.
	// Note that if you opt out at the account level this setting is ignored on
	// individual streams.
	DataSharingPreferenceForUpdate *StreamProcessorDataSharingPreference `type:"structure"`

	// Name of the stream processor that you want to update.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of parameters you want to delete from the stream processor.
	ParametersToDelete []*string `type:"list" enum:"StreamProcessorParameterToDelete"`

	// Specifies locations in the frames where Amazon Rekognition checks for objects
	// or people. This is an optional parameter for label detection stream processors.
	RegionsOfInterestForUpdate []*RegionOfInterest `type:"list"`

	// The stream processor settings that you want to update. Label detection settings
	// can be updated to detect different labels with a different minimum confidence.
	SettingsForUpdate *StreamProcessorSettingsForUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamProcessorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamProcessorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStreamProcessorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStreamProcessorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.DataSharingPreferenceForUpdate != nil {
		if err := s.DataSharingPreferenceForUpdate.Validate(); err != nil {
			invalidParams.AddNested("DataSharingPreferenceForUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.SettingsForUpdate != nil {
		if err := s.SettingsForUpdate.Validate(); err != nil {
			invalidParams.AddNested("SettingsForUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSharingPreferenceForUpdate sets the DataSharingPreferenceForUpdate field's value.
func (s *UpdateStreamProcessorInput) SetDataSharingPreferenceForUpdate(v *StreamProcessorDataSharingPreference) *UpdateStreamProcessorInput {
	s.DataSharingPreferenceForUpdate = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStreamProcessorInput) SetName(v string) *UpdateStreamProcessorInput {
	s.Name = &v
	return s
}

// SetParametersToDelete sets the ParametersToDelete field's value.
func (s *UpdateStreamProcessorInput) SetParametersToDelete(v []*string) *UpdateStreamProcessorInput {
	s.ParametersToDelete = v
	return s
}

// SetRegionsOfInterestForUpdate sets the RegionsOfInterestForUpdate field's value.
func (s *UpdateStreamProcessorInput) SetRegionsOfInterestForUpdate(v []*RegionOfInterest) *UpdateStreamProcessorInput {
	s.RegionsOfInterestForUpdate = v
	return s
}

// SetSettingsForUpdate sets the SettingsForUpdate field's value.
func (s *UpdateStreamProcessorInput) SetSettingsForUpdate(v *StreamProcessorSettingsForUpdate) *UpdateStreamProcessorInput {
	s.SettingsForUpdate = v
	return s
}

type UpdateStreamProcessorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamProcessorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStreamProcessorOutput) GoString() string {
	return s.String()
}

// Contains the Amazon S3 bucket location of the validation data for a model
// training job.
//
// The validation data includes error information for individual JSON Lines
// in the dataset. For more information, see Debugging a Failed Model Training
// in the Amazon Rekognition Custom Labels Developer Guide.
//
// You get the ValidationData object for the training dataset (TrainingDataResult)
// and the test dataset (TestingDataResult) by calling DescribeProjectVersions.
//
// The assets array contains a single Asset object. The GroundTruthManifest
// field of the Asset object contains the S3 bucket location of the validation
// data.
type ValidationData struct {
	_ struct{} `type:"structure"`

	// The assets that comprise the validation data.
	Assets []*Asset `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationData) GoString() string {
	return s.String()
}

// SetAssets sets the Assets field's value.
func (s *ValidationData) SetAssets(v []*Asset) *ValidationData {
	s.Assets = v
	return s
}

// Video file stored in an Amazon S3 bucket. Amazon Rekognition video start
// operations such as StartLabelDetection use Video to specify a video for analysis.
// The supported file formats are .mp4, .mov and .avi.
type Video struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket name and file name for the video.
	S3Object *S3Object `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Video) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Video) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Video) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Video"}
	if s.S3Object != nil {
		if err := s.S3Object.Validate(); err != nil {
			invalidParams.AddNested("S3Object", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Object sets the S3Object field's value.
func (s *Video) SetS3Object(v *S3Object) *Video {
	s.S3Object = v
	return s
}

// Information about a video that Amazon Rekognition analyzed. Videometadata
// is returned in every page of paginated responses from a Amazon Rekognition
// video operation.
type VideoMetadata struct {
	_ struct{} `type:"structure"`

	// Type of compression used in the analyzed video.
	Codec *string `type:"string"`

	// A description of the range of luminance values in a video, either LIMITED
	// (16 to 235) or FULL (0 to 255).
	ColorRange *string `type:"string" enum:"VideoColorRange"`

	// Length of the video in milliseconds.
	DurationMillis *int64 `type:"long"`

	// Format of the analyzed video. Possible values are MP4, MOV and AVI.
	Format *string `type:"string"`

	// Vertical pixel dimension of the video.
	FrameHeight *int64 `type:"long"`

	// Number of frames per second in the video.
	FrameRate *float64 `type:"float"`

	// Horizontal pixel dimension of the video.
	FrameWidth *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoMetadata) GoString() string {
	return s.String()
}

// SetCodec sets the Codec field's value.
func (s *VideoMetadata) SetCodec(v string) *VideoMetadata {
	s.Codec = &v
	return s
}

// SetColorRange sets the ColorRange field's value.
func (s *VideoMetadata) SetColorRange(v string) *VideoMetadata {
	s.ColorRange = &v
	return s
}

// SetDurationMillis sets the DurationMillis field's value.
func (s *VideoMetadata) SetDurationMillis(v int64) *VideoMetadata {
	s.DurationMillis = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *VideoMetadata) SetFormat(v string) *VideoMetadata {
	s.Format = &v
	return s
}

// SetFrameHeight sets the FrameHeight field's value.
func (s *VideoMetadata) SetFrameHeight(v int64) *VideoMetadata {
	s.FrameHeight = &v
	return s
}

// SetFrameRate sets the FrameRate field's value.
func (s *VideoMetadata) SetFrameRate(v float64) *VideoMetadata {
	s.FrameRate = &v
	return s
}

// SetFrameWidth sets the FrameWidth field's value.
func (s *VideoMetadata) SetFrameWidth(v int64) *VideoMetadata {
	s.FrameWidth = &v
	return s
}

// The file size or duration of the supplied media is too large. The maximum
// file size is 10GB. The maximum duration is 6 hours.
type VideoTooLargeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoTooLargeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoTooLargeException) GoString() string {
	return s.String()
}

func newErrorVideoTooLargeException(v protocol.ResponseMetadata) error {
	return &VideoTooLargeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *VideoTooLargeException) Code() string {
	return "VideoTooLargeException"
}

// Message returns the exception's message.
func (s *VideoTooLargeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *VideoTooLargeException) OrigErr() error {
	return nil
}

func (s *VideoTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *VideoTooLargeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *VideoTooLargeException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AttributeDefault is a Attribute enum value
	AttributeDefault = "DEFAULT"

	// AttributeAll is a Attribute enum value
	AttributeAll = "ALL"
)

// Attribute_Values returns all elements of the Attribute enum
func Attribute_Values() []string {
	return []string{
		AttributeDefault,
		AttributeAll,
	}
}

const (
	// BodyPartFace is a BodyPart enum value
	BodyPartFace = "FACE"

	// BodyPartHead is a BodyPart enum value
	BodyPartHead = "HEAD"

	// BodyPartLeftHand is a BodyPart enum value
	BodyPartLeftHand = "LEFT_HAND"

	// BodyPartRightHand is a BodyPart enum value
	BodyPartRightHand = "RIGHT_HAND"
)

// BodyPart_Values returns all elements of the BodyPart enum
func BodyPart_Values() []string {
	return []string{
		BodyPartFace,
		BodyPartHead,
		BodyPartLeftHand,
		BodyPartRightHand,
	}
}

const (
	// CelebrityRecognitionSortById is a CelebrityRecognitionSortBy enum value
	CelebrityRecognitionSortById = "ID"

	// CelebrityRecognitionSortByTimestamp is a CelebrityRecognitionSortBy enum value
	CelebrityRecognitionSortByTimestamp = "TIMESTAMP"
)

// CelebrityRecognitionSortBy_Values returns all elements of the CelebrityRecognitionSortBy enum
func CelebrityRecognitionSortBy_Values() []string {
	return []string{
		CelebrityRecognitionSortById,
		CelebrityRecognitionSortByTimestamp,
	}
}

const (
	// ContentClassifierFreeOfPersonallyIdentifiableInformation is a ContentClassifier enum value
	ContentClassifierFreeOfPersonallyIdentifiableInformation = "FreeOfPersonallyIdentifiableInformation"

	// ContentClassifierFreeOfAdultContent is a ContentClassifier enum value
	ContentClassifierFreeOfAdultContent = "FreeOfAdultContent"
)

// ContentClassifier_Values returns all elements of the ContentClassifier enum
func ContentClassifier_Values() []string {
	return []string{
		ContentClassifierFreeOfPersonallyIdentifiableInformation,
		ContentClassifierFreeOfAdultContent,
	}
}

const (
	// ContentModerationSortByName is a ContentModerationSortBy enum value
	ContentModerationSortByName = "NAME"

	// ContentModerationSortByTimestamp is a ContentModerationSortBy enum value
	ContentModerationSortByTimestamp = "TIMESTAMP"
)

// ContentModerationSortBy_Values returns all elements of the ContentModerationSortBy enum
func ContentModerationSortBy_Values() []string {
	return []string{
		ContentModerationSortByName,
		ContentModerationSortByTimestamp,
	}
}

const (
	// DatasetStatusCreateInProgress is a DatasetStatus enum value
	DatasetStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// DatasetStatusCreateComplete is a DatasetStatus enum value
	DatasetStatusCreateComplete = "CREATE_COMPLETE"

	// DatasetStatusCreateFailed is a DatasetStatus enum value
	DatasetStatusCreateFailed = "CREATE_FAILED"

	// DatasetStatusUpdateInProgress is a DatasetStatus enum value
	DatasetStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// DatasetStatusUpdateComplete is a DatasetStatus enum value
	DatasetStatusUpdateComplete = "UPDATE_COMPLETE"

	// DatasetStatusUpdateFailed is a DatasetStatus enum value
	DatasetStatusUpdateFailed = "UPDATE_FAILED"

	// DatasetStatusDeleteInProgress is a DatasetStatus enum value
	DatasetStatusDeleteInProgress = "DELETE_IN_PROGRESS"
)

// DatasetStatus_Values returns all elements of the DatasetStatus enum
func DatasetStatus_Values() []string {
	return []string{
		DatasetStatusCreateInProgress,
		DatasetStatusCreateComplete,
		DatasetStatusCreateFailed,
		DatasetStatusUpdateInProgress,
		DatasetStatusUpdateComplete,
		DatasetStatusUpdateFailed,
		DatasetStatusDeleteInProgress,
	}
}

const (
	// DatasetStatusMessageCodeSuccess is a DatasetStatusMessageCode enum value
	DatasetStatusMessageCodeSuccess = "SUCCESS"

	// DatasetStatusMessageCodeServiceError is a DatasetStatusMessageCode enum value
	DatasetStatusMessageCodeServiceError = "SERVICE_ERROR"

	// DatasetStatusMessageCodeClientError is a DatasetStatusMessageCode enum value
	DatasetStatusMessageCodeClientError = "CLIENT_ERROR"
)

// DatasetStatusMessageCode_Values returns all elements of the DatasetStatusMessageCode enum
func DatasetStatusMessageCode_Values() []string {
	return []string{
		DatasetStatusMessageCodeSuccess,
		DatasetStatusMessageCodeServiceError,
		DatasetStatusMessageCodeClientError,
	}
}

const (
	// DatasetTypeTrain is a DatasetType enum value
	DatasetTypeTrain = "TRAIN"

	// DatasetTypeTest is a DatasetType enum value
	DatasetTypeTest = "TEST"
)

// DatasetType_Values returns all elements of the DatasetType enum
func DatasetType_Values() []string {
	return []string{
		DatasetTypeTrain,
		DatasetTypeTest,
	}
}

const (
	// EmotionNameHappy is a EmotionName enum value
	EmotionNameHappy = "HAPPY"

	// EmotionNameSad is a EmotionName enum value
	EmotionNameSad = "SAD"

	// EmotionNameAngry is a EmotionName enum value
	EmotionNameAngry = "ANGRY"

	// EmotionNameConfused is a EmotionName enum value
	EmotionNameConfused = "CONFUSED"

	// EmotionNameDisgusted is a EmotionName enum value
	EmotionNameDisgusted = "DISGUSTED"

	// EmotionNameSurprised is a EmotionName enum value
	EmotionNameSurprised = "SURPRISED"

	// EmotionNameCalm is a EmotionName enum value
	EmotionNameCalm = "CALM"

	// EmotionNameUnknown is a EmotionName enum value
	EmotionNameUnknown = "UNKNOWN"

	// EmotionNameFear is a EmotionName enum value
	EmotionNameFear = "FEAR"
)

// EmotionName_Values returns all elements of the EmotionName enum
func EmotionName_Values() []string {
	return []string{
		EmotionNameHappy,
		EmotionNameSad,
		EmotionNameAngry,
		EmotionNameConfused,
		EmotionNameDisgusted,
		EmotionNameSurprised,
		EmotionNameCalm,
		EmotionNameUnknown,
		EmotionNameFear,
	}
}

const (
	// FaceAttributesDefault is a FaceAttributes enum value
	FaceAttributesDefault = "DEFAULT"

	// FaceAttributesAll is a FaceAttributes enum value
	FaceAttributesAll = "ALL"
)

// FaceAttributes_Values returns all elements of the FaceAttributes enum
func FaceAttributes_Values() []string {
	return []string{
		FaceAttributesDefault,
		FaceAttributesAll,
	}
}

const (
	// FaceSearchSortByIndex is a FaceSearchSortBy enum value
	FaceSearchSortByIndex = "INDEX"

	// FaceSearchSortByTimestamp is a FaceSearchSortBy enum value
	FaceSearchSortByTimestamp = "TIMESTAMP"
)

// FaceSearchSortBy_Values returns all elements of the FaceSearchSortBy enum
func FaceSearchSortBy_Values() []string {
	return []string{
		FaceSearchSortByIndex,
		FaceSearchSortByTimestamp,
	}
}

const (
	// GenderTypeMale is a GenderType enum value
	GenderTypeMale = "Male"

	// GenderTypeFemale is a GenderType enum value
	GenderTypeFemale = "Female"
)

// GenderType_Values returns all elements of the GenderType enum
func GenderType_Values() []string {
	return []string{
		GenderTypeMale,
		GenderTypeFemale,
	}
}

// A list of enum string of possible gender values that Celebrity returns.
const (
	// KnownGenderTypeMale is a KnownGenderType enum value
	KnownGenderTypeMale = "Male"

	// KnownGenderTypeFemale is a KnownGenderType enum value
	KnownGenderTypeFemale = "Female"

	// KnownGenderTypeNonbinary is a KnownGenderType enum value
	KnownGenderTypeNonbinary = "Nonbinary"

	// KnownGenderTypeUnlisted is a KnownGenderType enum value
	KnownGenderTypeUnlisted = "Unlisted"
)

// KnownGenderType_Values returns all elements of the KnownGenderType enum
func KnownGenderType_Values() []string {
	return []string{
		KnownGenderTypeMale,
		KnownGenderTypeFemale,
		KnownGenderTypeNonbinary,
		KnownGenderTypeUnlisted,
	}
}

const (
	// LabelDetectionSortByName is a LabelDetectionSortBy enum value
	LabelDetectionSortByName = "NAME"

	// LabelDetectionSortByTimestamp is a LabelDetectionSortBy enum value
	LabelDetectionSortByTimestamp = "TIMESTAMP"
)

// LabelDetectionSortBy_Values returns all elements of the LabelDetectionSortBy enum
func LabelDetectionSortBy_Values() []string {
	return []string{
		LabelDetectionSortByName,
		LabelDetectionSortByTimestamp,
	}
}

const (
	// LandmarkTypeEyeLeft is a LandmarkType enum value
	LandmarkTypeEyeLeft = "eyeLeft"

	// LandmarkTypeEyeRight is a LandmarkType enum value
	LandmarkTypeEyeRight = "eyeRight"

	// LandmarkTypeNose is a LandmarkType enum value
	LandmarkTypeNose = "nose"

	// LandmarkTypeMouthLeft is a LandmarkType enum value
	LandmarkTypeMouthLeft = "mouthLeft"

	// LandmarkTypeMouthRight is a LandmarkType enum value
	LandmarkTypeMouthRight = "mouthRight"

	// LandmarkTypeLeftEyeBrowLeft is a LandmarkType enum value
	LandmarkTypeLeftEyeBrowLeft = "leftEyeBrowLeft"

	// LandmarkTypeLeftEyeBrowRight is a LandmarkType enum value
	LandmarkTypeLeftEyeBrowRight = "leftEyeBrowRight"

	// LandmarkTypeLeftEyeBrowUp is a LandmarkType enum value
	LandmarkTypeLeftEyeBrowUp = "leftEyeBrowUp"

	// LandmarkTypeRightEyeBrowLeft is a LandmarkType enum value
	LandmarkTypeRightEyeBrowLeft = "rightEyeBrowLeft"

	// LandmarkTypeRightEyeBrowRight is a LandmarkType enum value
	LandmarkTypeRightEyeBrowRight = "rightEyeBrowRight"

	// LandmarkTypeRightEyeBrowUp is a LandmarkType enum value
	LandmarkTypeRightEyeBrowUp = "rightEyeBrowUp"

	// LandmarkTypeLeftEyeLeft is a LandmarkType enum value
	LandmarkTypeLeftEyeLeft = "leftEyeLeft"

	// LandmarkTypeLeftEyeRight is a LandmarkType enum value
	LandmarkTypeLeftEyeRight = "leftEyeRight"

	// LandmarkTypeLeftEyeUp is a LandmarkType enum value
	LandmarkTypeLeftEyeUp = "leftEyeUp"

	// LandmarkTypeLeftEyeDown is a LandmarkType enum value
	LandmarkTypeLeftEyeDown = "leftEyeDown"

	// LandmarkTypeRightEyeLeft is a LandmarkType enum value
	LandmarkTypeRightEyeLeft = "rightEyeLeft"

	// LandmarkTypeRightEyeRight is a LandmarkType enum value
	LandmarkTypeRightEyeRight = "rightEyeRight"

	// LandmarkTypeRightEyeUp is a LandmarkType enum value
	LandmarkTypeRightEyeUp = "rightEyeUp"

	// LandmarkTypeRightEyeDown is a LandmarkType enum value
	LandmarkTypeRightEyeDown = "rightEyeDown"

	// LandmarkTypeNoseLeft is a LandmarkType enum value
	LandmarkTypeNoseLeft = "noseLeft"

	// LandmarkTypeNoseRight is a LandmarkType enum value
	LandmarkTypeNoseRight = "noseRight"

	// LandmarkTypeMouthUp is a LandmarkType enum value
	LandmarkTypeMouthUp = "mouthUp"

	// LandmarkTypeMouthDown is a LandmarkType enum value
	LandmarkTypeMouthDown = "mouthDown"

	// LandmarkTypeLeftPupil is a LandmarkType enum value
	LandmarkTypeLeftPupil = "leftPupil"

	// LandmarkTypeRightPupil is a LandmarkType enum value
	LandmarkTypeRightPupil = "rightPupil"

	// LandmarkTypeUpperJawlineLeft is a LandmarkType enum value
	LandmarkTypeUpperJawlineLeft = "upperJawlineLeft"

	// LandmarkTypeMidJawlineLeft is a LandmarkType enum value
	LandmarkTypeMidJawlineLeft = "midJawlineLeft"

	// LandmarkTypeChinBottom is a LandmarkType enum value
	LandmarkTypeChinBottom = "chinBottom"

	// LandmarkTypeMidJawlineRight is a LandmarkType enum value
	LandmarkTypeMidJawlineRight = "midJawlineRight"

	// LandmarkTypeUpperJawlineRight is a LandmarkType enum value
	LandmarkTypeUpperJawlineRight = "upperJawlineRight"
)

// LandmarkType_Values returns all elements of the LandmarkType enum
func LandmarkType_Values() []string {
	return []string{
		LandmarkTypeEyeLeft,
		LandmarkTypeEyeRight,
		LandmarkTypeNose,
		LandmarkTypeMouthLeft,
		LandmarkTypeMouthRight,
		LandmarkTypeLeftEyeBrowLeft,
		LandmarkTypeLeftEyeBrowRight,
		LandmarkTypeLeftEyeBrowUp,
		LandmarkTypeRightEyeBrowLeft,
		LandmarkTypeRightEyeBrowRight,
		LandmarkTypeRightEyeBrowUp,
		LandmarkTypeLeftEyeLeft,
		LandmarkTypeLeftEyeRight,
		LandmarkTypeLeftEyeUp,
		LandmarkTypeLeftEyeDown,
		LandmarkTypeRightEyeLeft,
		LandmarkTypeRightEyeRight,
		LandmarkTypeRightEyeUp,
		LandmarkTypeRightEyeDown,
		LandmarkTypeNoseLeft,
		LandmarkTypeNoseRight,
		LandmarkTypeMouthUp,
		LandmarkTypeMouthDown,
		LandmarkTypeLeftPupil,
		LandmarkTypeRightPupil,
		LandmarkTypeUpperJawlineLeft,
		LandmarkTypeMidJawlineLeft,
		LandmarkTypeChinBottom,
		LandmarkTypeMidJawlineRight,
		LandmarkTypeUpperJawlineRight,
	}
}

const (
	// OrientationCorrectionRotate0 is a OrientationCorrection enum value
	OrientationCorrectionRotate0 = "ROTATE_0"

	// OrientationCorrectionRotate90 is a OrientationCorrection enum value
	OrientationCorrectionRotate90 = "ROTATE_90"

	// OrientationCorrectionRotate180 is a OrientationCorrection enum value
	OrientationCorrectionRotate180 = "ROTATE_180"

	// OrientationCorrectionRotate270 is a OrientationCorrection enum value
	OrientationCorrectionRotate270 = "ROTATE_270"
)

// OrientationCorrection_Values returns all elements of the OrientationCorrection enum
func OrientationCorrection_Values() []string {
	return []string{
		OrientationCorrectionRotate0,
		OrientationCorrectionRotate90,
		OrientationCorrectionRotate180,
		OrientationCorrectionRotate270,
	}
}

const (
	// PersonTrackingSortByIndex is a PersonTrackingSortBy enum value
	PersonTrackingSortByIndex = "INDEX"

	// PersonTrackingSortByTimestamp is a PersonTrackingSortBy enum value
	PersonTrackingSortByTimestamp = "TIMESTAMP"
)

// PersonTrackingSortBy_Values returns all elements of the PersonTrackingSortBy enum
func PersonTrackingSortBy_Values() []string {
	return []string{
		PersonTrackingSortByIndex,
		PersonTrackingSortByTimestamp,
	}
}

const (
	// ProjectStatusCreating is a ProjectStatus enum value
	ProjectStatusCreating = "CREATING"

	// ProjectStatusCreated is a ProjectStatus enum value
	ProjectStatusCreated = "CREATED"

	// ProjectStatusDeleting is a ProjectStatus enum value
	ProjectStatusDeleting = "DELETING"
)

// ProjectStatus_Values returns all elements of the ProjectStatus enum
func ProjectStatus_Values() []string {
	return []string{
		ProjectStatusCreating,
		ProjectStatusCreated,
		ProjectStatusDeleting,
	}
}

const (
	// ProjectVersionStatusTrainingInProgress is a ProjectVersionStatus enum value
	ProjectVersionStatusTrainingInProgress = "TRAINING_IN_PROGRESS"

	// ProjectVersionStatusTrainingCompleted is a ProjectVersionStatus enum value
	ProjectVersionStatusTrainingCompleted = "TRAINING_COMPLETED"

	// ProjectVersionStatusTrainingFailed is a ProjectVersionStatus enum value
	ProjectVersionStatusTrainingFailed = "TRAINING_FAILED"

	// ProjectVersionStatusStarting is a ProjectVersionStatus enum value
	ProjectVersionStatusStarting = "STARTING"

	// ProjectVersionStatusRunning is a ProjectVersionStatus enum value
	ProjectVersionStatusRunning = "RUNNING"

	// ProjectVersionStatusFailed is a ProjectVersionStatus enum value
	ProjectVersionStatusFailed = "FAILED"

	// ProjectVersionStatusStopping is a ProjectVersionStatus enum value
	ProjectVersionStatusStopping = "STOPPING"

	// ProjectVersionStatusStopped is a ProjectVersionStatus enum value
	ProjectVersionStatusStopped = "STOPPED"

	// ProjectVersionStatusDeleting is a ProjectVersionStatus enum value
	ProjectVersionStatusDeleting = "DELETING"
)

// ProjectVersionStatus_Values returns all elements of the ProjectVersionStatus enum
func ProjectVersionStatus_Values() []string {
	return []string{
		ProjectVersionStatusTrainingInProgress,
		ProjectVersionStatusTrainingCompleted,
		ProjectVersionStatusTrainingFailed,
		ProjectVersionStatusStarting,
		ProjectVersionStatusRunning,
		ProjectVersionStatusFailed,
		ProjectVersionStatusStopping,
		ProjectVersionStatusStopped,
		ProjectVersionStatusDeleting,
	}
}

const (
	// ProtectiveEquipmentTypeFaceCover is a ProtectiveEquipmentType enum value
	ProtectiveEquipmentTypeFaceCover = "FACE_COVER"

	// ProtectiveEquipmentTypeHandCover is a ProtectiveEquipmentType enum value
	ProtectiveEquipmentTypeHandCover = "HAND_COVER"

	// ProtectiveEquipmentTypeHeadCover is a ProtectiveEquipmentType enum value
	ProtectiveEquipmentTypeHeadCover = "HEAD_COVER"
)

// ProtectiveEquipmentType_Values returns all elements of the ProtectiveEquipmentType enum
func ProtectiveEquipmentType_Values() []string {
	return []string{
		ProtectiveEquipmentTypeFaceCover,
		ProtectiveEquipmentTypeHandCover,
		ProtectiveEquipmentTypeHeadCover,
	}
}

const (
	// QualityFilterNone is a QualityFilter enum value
	QualityFilterNone = "NONE"

	// QualityFilterAuto is a QualityFilter enum value
	QualityFilterAuto = "AUTO"

	// QualityFilterLow is a QualityFilter enum value
	QualityFilterLow = "LOW"

	// QualityFilterMedium is a QualityFilter enum value
	QualityFilterMedium = "MEDIUM"

	// QualityFilterHigh is a QualityFilter enum value
	QualityFilterHigh = "HIGH"
)

// QualityFilter_Values returns all elements of the QualityFilter enum
func QualityFilter_Values() []string {
	return []string{
		QualityFilterNone,
		QualityFilterAuto,
		QualityFilterLow,
		QualityFilterMedium,
		QualityFilterHigh,
	}
}

const (
	// ReasonExceedsMaxFaces is a Reason enum value
	ReasonExceedsMaxFaces = "EXCEEDS_MAX_FACES"

	// ReasonExtremePose is a Reason enum value
	ReasonExtremePose = "EXTREME_POSE"

	// ReasonLowBrightness is a Reason enum value
	ReasonLowBrightness = "LOW_BRIGHTNESS"

	// ReasonLowSharpness is a Reason enum value
	ReasonLowSharpness = "LOW_SHARPNESS"

	// ReasonLowConfidence is a Reason enum value
	ReasonLowConfidence = "LOW_CONFIDENCE"

	// ReasonSmallBoundingBox is a Reason enum value
	ReasonSmallBoundingBox = "SMALL_BOUNDING_BOX"

	// ReasonLowFaceQuality is a Reason enum value
	ReasonLowFaceQuality = "LOW_FACE_QUALITY"
)

// Reason_Values returns all elements of the Reason enum
func Reason_Values() []string {
	return []string{
		ReasonExceedsMaxFaces,
		ReasonExtremePose,
		ReasonLowBrightness,
		ReasonLowSharpness,
		ReasonLowConfidence,
		ReasonSmallBoundingBox,
		ReasonLowFaceQuality,
	}
}

const (
	// SegmentTypeTechnicalCue is a SegmentType enum value
	SegmentTypeTechnicalCue = "TECHNICAL_CUE"

	// SegmentTypeShot is a SegmentType enum value
	SegmentTypeShot = "SHOT"
)

// SegmentType_Values returns all elements of the SegmentType enum
func SegmentType_Values() []string {
	return []string{
		SegmentTypeTechnicalCue,
		SegmentTypeShot,
	}
}

const (
	// StreamProcessorParameterToDeleteConnectedHomeMinConfidence is a StreamProcessorParameterToDelete enum value
	StreamProcessorParameterToDeleteConnectedHomeMinConfidence = "ConnectedHomeMinConfidence"

	// StreamProcessorParameterToDeleteRegionsOfInterest is a StreamProcessorParameterToDelete enum value
	StreamProcessorParameterToDeleteRegionsOfInterest = "RegionsOfInterest"
)

// StreamProcessorParameterToDelete_Values returns all elements of the StreamProcessorParameterToDelete enum
func StreamProcessorParameterToDelete_Values() []string {
	return []string{
		StreamProcessorParameterToDeleteConnectedHomeMinConfidence,
		StreamProcessorParameterToDeleteRegionsOfInterest,
	}
}

const (
	// StreamProcessorStatusStopped is a StreamProcessorStatus enum value
	StreamProcessorStatusStopped = "STOPPED"

	// StreamProcessorStatusStarting is a StreamProcessorStatus enum value
	StreamProcessorStatusStarting = "STARTING"

	// StreamProcessorStatusRunning is a StreamProcessorStatus enum value
	StreamProcessorStatusRunning = "RUNNING"

	// StreamProcessorStatusFailed is a StreamProcessorStatus enum value
	StreamProcessorStatusFailed = "FAILED"

	// StreamProcessorStatusStopping is a StreamProcessorStatus enum value
	StreamProcessorStatusStopping = "STOPPING"

	// StreamProcessorStatusUpdating is a StreamProcessorStatus enum value
	StreamProcessorStatusUpdating = "UPDATING"
)

// StreamProcessorStatus_Values returns all elements of the StreamProcessorStatus enum
func StreamProcessorStatus_Values() []string {
	return []string{
		StreamProcessorStatusStopped,
		StreamProcessorStatusStarting,
		StreamProcessorStatusRunning,
		StreamProcessorStatusFailed,
		StreamProcessorStatusStopping,
		StreamProcessorStatusUpdating,
	}
}

const (
	// TechnicalCueTypeColorBars is a TechnicalCueType enum value
	TechnicalCueTypeColorBars = "ColorBars"

	// TechnicalCueTypeEndCredits is a TechnicalCueType enum value
	TechnicalCueTypeEndCredits = "EndCredits"

	// TechnicalCueTypeBlackFrames is a TechnicalCueType enum value
	TechnicalCueTypeBlackFrames = "BlackFrames"

	// TechnicalCueTypeOpeningCredits is a TechnicalCueType enum value
	TechnicalCueTypeOpeningCredits = "OpeningCredits"

	// TechnicalCueTypeStudioLogo is a TechnicalCueType enum value
	TechnicalCueTypeStudioLogo = "StudioLogo"

	// TechnicalCueTypeSlate is a TechnicalCueType enum value
	TechnicalCueTypeSlate = "Slate"

	// TechnicalCueTypeContent is a TechnicalCueType enum value
	TechnicalCueTypeContent = "Content"
)

// TechnicalCueType_Values returns all elements of the TechnicalCueType enum
func TechnicalCueType_Values() []string {
	return []string{
		TechnicalCueTypeColorBars,
		TechnicalCueTypeEndCredits,
		TechnicalCueTypeBlackFrames,
		TechnicalCueTypeOpeningCredits,
		TechnicalCueTypeStudioLogo,
		TechnicalCueTypeSlate,
		TechnicalCueTypeContent,
	}
}

const (
	// TextTypesLine is a TextTypes enum value
	TextTypesLine = "LINE"

	// TextTypesWord is a TextTypes enum value
	TextTypesWord = "WORD"
)

// TextTypes_Values returns all elements of the TextTypes enum
func TextTypes_Values() []string {
	return []string{
		TextTypesLine,
		TextTypesWord,
	}
}

const (
	// VideoColorRangeFull is a VideoColorRange enum value
	VideoColorRangeFull = "FULL"

	// VideoColorRangeLimited is a VideoColorRange enum value
	VideoColorRangeLimited = "LIMITED"
)

// VideoColorRange_Values returns all elements of the VideoColorRange enum
func VideoColorRange_Values() []string {
	return []string{
		VideoColorRangeFull,
		VideoColorRangeLimited,
	}
}

const (
	// VideoJobStatusInProgress is a VideoJobStatus enum value
	VideoJobStatusInProgress = "IN_PROGRESS"

	// VideoJobStatusSucceeded is a VideoJobStatus enum value
	VideoJobStatusSucceeded = "SUCCEEDED"

	// VideoJobStatusFailed is a VideoJobStatus enum value
	VideoJobStatusFailed = "FAILED"
)

// VideoJobStatus_Values returns all elements of the VideoJobStatus enum
func VideoJobStatus_Values() []string {
	return []string{
		VideoJobStatusInProgress,
		VideoJobStatusSucceeded,
		VideoJobStatusFailed,
	}
}
