// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chimesdkmediapipelines

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateMediaCapturePipeline = "CreateMediaCapturePipeline"

// CreateMediaCapturePipelineRequest generates a "aws/request.Request" representing the
// client's request for the CreateMediaCapturePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMediaCapturePipeline for more information on using the CreateMediaCapturePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMediaCapturePipelineRequest method.
//    req, resp := client.CreateMediaCapturePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) CreateMediaCapturePipelineRequest(input *CreateMediaCapturePipelineInput) (req *request.Request, output *CreateMediaCapturePipelineOutput) {
	op := &request.Operation{
		Name:       opCreateMediaCapturePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/sdk-media-capture-pipelines",
	}

	if input == nil {
		input = &CreateMediaCapturePipelineInput{}
	}

	output = &CreateMediaCapturePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMediaCapturePipeline API operation for Amazon Chime SDK Media Pipelines.
//
// Creates a media capture pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation CreateMediaCapturePipeline for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) CreateMediaCapturePipeline(input *CreateMediaCapturePipelineInput) (*CreateMediaCapturePipelineOutput, error) {
	req, out := c.CreateMediaCapturePipelineRequest(input)
	return out, req.Send()
}

// CreateMediaCapturePipelineWithContext is the same as CreateMediaCapturePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMediaCapturePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) CreateMediaCapturePipelineWithContext(ctx aws.Context, input *CreateMediaCapturePipelineInput, opts ...request.Option) (*CreateMediaCapturePipelineOutput, error) {
	req, out := c.CreateMediaCapturePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMediaCapturePipeline = "DeleteMediaCapturePipeline"

// DeleteMediaCapturePipelineRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMediaCapturePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMediaCapturePipeline for more information on using the DeleteMediaCapturePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMediaCapturePipelineRequest method.
//    req, resp := client.DeleteMediaCapturePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) DeleteMediaCapturePipelineRequest(input *DeleteMediaCapturePipelineInput) (req *request.Request, output *DeleteMediaCapturePipelineOutput) {
	op := &request.Operation{
		Name:       opDeleteMediaCapturePipeline,
		HTTPMethod: "DELETE",
		HTTPPath:   "/sdk-media-capture-pipelines/{mediaPipelineId}",
	}

	if input == nil {
		input = &DeleteMediaCapturePipelineInput{}
	}

	output = &DeleteMediaCapturePipelineOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMediaCapturePipeline API operation for Amazon Chime SDK Media Pipelines.
//
// Deletes the media capture pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation DeleteMediaCapturePipeline for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/DeleteMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) DeleteMediaCapturePipeline(input *DeleteMediaCapturePipelineInput) (*DeleteMediaCapturePipelineOutput, error) {
	req, out := c.DeleteMediaCapturePipelineRequest(input)
	return out, req.Send()
}

// DeleteMediaCapturePipelineWithContext is the same as DeleteMediaCapturePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMediaCapturePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) DeleteMediaCapturePipelineWithContext(ctx aws.Context, input *DeleteMediaCapturePipelineInput, opts ...request.Option) (*DeleteMediaCapturePipelineOutput, error) {
	req, out := c.DeleteMediaCapturePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMediaCapturePipeline = "GetMediaCapturePipeline"

// GetMediaCapturePipelineRequest generates a "aws/request.Request" representing the
// client's request for the GetMediaCapturePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMediaCapturePipeline for more information on using the GetMediaCapturePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMediaCapturePipelineRequest method.
//    req, resp := client.GetMediaCapturePipelineRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) GetMediaCapturePipelineRequest(input *GetMediaCapturePipelineInput) (req *request.Request, output *GetMediaCapturePipelineOutput) {
	op := &request.Operation{
		Name:       opGetMediaCapturePipeline,
		HTTPMethod: "GET",
		HTTPPath:   "/sdk-media-capture-pipelines/{mediaPipelineId}",
	}

	if input == nil {
		input = &GetMediaCapturePipelineInput{}
	}

	output = &GetMediaCapturePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMediaCapturePipeline API operation for Amazon Chime SDK Media Pipelines.
//
// Gets an existing media capture pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation GetMediaCapturePipeline for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/GetMediaCapturePipeline
func (c *ChimeSDKMediaPipelines) GetMediaCapturePipeline(input *GetMediaCapturePipelineInput) (*GetMediaCapturePipelineOutput, error) {
	req, out := c.GetMediaCapturePipelineRequest(input)
	return out, req.Send()
}

// GetMediaCapturePipelineWithContext is the same as GetMediaCapturePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See GetMediaCapturePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) GetMediaCapturePipelineWithContext(ctx aws.Context, input *GetMediaCapturePipelineInput, opts ...request.Option) (*GetMediaCapturePipelineOutput, error) {
	req, out := c.GetMediaCapturePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMediaCapturePipelines = "ListMediaCapturePipelines"

// ListMediaCapturePipelinesRequest generates a "aws/request.Request" representing the
// client's request for the ListMediaCapturePipelines operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMediaCapturePipelines for more information on using the ListMediaCapturePipelines
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMediaCapturePipelinesRequest method.
//    req, resp := client.ListMediaCapturePipelinesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaCapturePipelines
func (c *ChimeSDKMediaPipelines) ListMediaCapturePipelinesRequest(input *ListMediaCapturePipelinesInput) (req *request.Request, output *ListMediaCapturePipelinesOutput) {
	op := &request.Operation{
		Name:       opListMediaCapturePipelines,
		HTTPMethod: "GET",
		HTTPPath:   "/sdk-media-capture-pipelines",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMediaCapturePipelinesInput{}
	}

	output = &ListMediaCapturePipelinesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMediaCapturePipelines API operation for Amazon Chime SDK Media Pipelines.
//
// Returns a list of media capture pipelines.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation ListMediaCapturePipelines for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListMediaCapturePipelines
func (c *ChimeSDKMediaPipelines) ListMediaCapturePipelines(input *ListMediaCapturePipelinesInput) (*ListMediaCapturePipelinesOutput, error) {
	req, out := c.ListMediaCapturePipelinesRequest(input)
	return out, req.Send()
}

// ListMediaCapturePipelinesWithContext is the same as ListMediaCapturePipelines with the addition of
// the ability to pass a context and additional request options.
//
// See ListMediaCapturePipelines for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) ListMediaCapturePipelinesWithContext(ctx aws.Context, input *ListMediaCapturePipelinesInput, opts ...request.Option) (*ListMediaCapturePipelinesOutput, error) {
	req, out := c.ListMediaCapturePipelinesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMediaCapturePipelinesPages iterates over the pages of a ListMediaCapturePipelines operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMediaCapturePipelines method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMediaCapturePipelines operation.
//    pageNum := 0
//    err := client.ListMediaCapturePipelinesPages(params,
//        func(page *chimesdkmediapipelines.ListMediaCapturePipelinesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKMediaPipelines) ListMediaCapturePipelinesPages(input *ListMediaCapturePipelinesInput, fn func(*ListMediaCapturePipelinesOutput, bool) bool) error {
	return c.ListMediaCapturePipelinesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMediaCapturePipelinesPagesWithContext same as ListMediaCapturePipelinesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) ListMediaCapturePipelinesPagesWithContext(ctx aws.Context, input *ListMediaCapturePipelinesInput, fn func(*ListMediaCapturePipelinesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMediaCapturePipelinesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMediaCapturePipelinesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMediaCapturePipelinesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListTagsForResource
func (c *ChimeSDKMediaPipelines) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Chime SDK Media Pipelines.
//
// Lists the tags applied to an Amazon Chime SDK media capture pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/ListTagsForResource
func (c *ChimeSDKMediaPipelines) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/TagResource
func (c *ChimeSDKMediaPipelines) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=tag-resource",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Chime SDK Media Pipelines.
//
// Applies the specified tags to the specified Amazon Chime SDK media capture
// pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/TagResource
func (c *ChimeSDKMediaPipelines) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UntagResource
func (c *ChimeSDKMediaPipelines) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags?operation=untag-resource",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Chime SDK Media Pipelines.
//
// Removes the specified tags from the specified Amazon Chime SDK media capture
// pipeline.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Media Pipelines's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/UntagResource
func (c *ChimeSDKMediaPipelines) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMediaPipelines) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The configuration for the artifacts.
type ArtifactsConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for the audio artifacts.
	//
	// Audio is a required field
	Audio *AudioArtifactsConfiguration `type:"structure" required:"true"`

	// The configuration for the content artifacts.
	//
	// Content is a required field
	Content *ContentArtifactsConfiguration `type:"structure" required:"true"`

	// The configuration for the video artifacts.
	//
	// Video is a required field
	Video *VideoArtifactsConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ArtifactsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ArtifactsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ArtifactsConfiguration"}
	if s.Audio == nil {
		invalidParams.Add(request.NewErrParamRequired("Audio"))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Video == nil {
		invalidParams.Add(request.NewErrParamRequired("Video"))
	}
	if s.Audio != nil {
		if err := s.Audio.Validate(); err != nil {
			invalidParams.AddNested("Audio", err.(request.ErrInvalidParams))
		}
	}
	if s.Content != nil {
		if err := s.Content.Validate(); err != nil {
			invalidParams.AddNested("Content", err.(request.ErrInvalidParams))
		}
	}
	if s.Video != nil {
		if err := s.Video.Validate(); err != nil {
			invalidParams.AddNested("Video", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudio sets the Audio field's value.
func (s *ArtifactsConfiguration) SetAudio(v *AudioArtifactsConfiguration) *ArtifactsConfiguration {
	s.Audio = v
	return s
}

// SetContent sets the Content field's value.
func (s *ArtifactsConfiguration) SetContent(v *ContentArtifactsConfiguration) *ArtifactsConfiguration {
	s.Content = v
	return s
}

// SetVideo sets the Video field's value.
func (s *ArtifactsConfiguration) SetVideo(v *VideoArtifactsConfiguration) *ArtifactsConfiguration {
	s.Video = v
	return s
}

// The audio artifact configuration object.
type AudioArtifactsConfiguration struct {
	_ struct{} `type:"structure"`

	// The MUX type of the audio artifact configuration object.
	//
	// MuxType is a required field
	MuxType *string `type:"string" required:"true" enum:"AudioMuxType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioArtifactsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioArtifactsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudioArtifactsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudioArtifactsConfiguration"}
	if s.MuxType == nil {
		invalidParams.Add(request.NewErrParamRequired("MuxType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMuxType sets the MuxType field's value.
func (s *AudioArtifactsConfiguration) SetMuxType(v string) *AudioArtifactsConfiguration {
	s.MuxType = &v
	return s
}

// The input parameters don't match the service's restrictions.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration object of the Amazon Chime SDK meeting for a specified
// media capture pipeline. SourceType must be ChimeSdkMeeting.
type ChimeSdkMeetingConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration for the artifacts in an Amazon Chime SDK meeting.
	ArtifactsConfiguration *ArtifactsConfiguration `type:"structure"`

	// The source configuration for a specified media capture pipline.
	SourceConfiguration *SourceConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChimeSdkMeetingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChimeSdkMeetingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChimeSdkMeetingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChimeSdkMeetingConfiguration"}
	if s.ArtifactsConfiguration != nil {
		if err := s.ArtifactsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ArtifactsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactsConfiguration sets the ArtifactsConfiguration field's value.
func (s *ChimeSdkMeetingConfiguration) SetArtifactsConfiguration(v *ArtifactsConfiguration) *ChimeSdkMeetingConfiguration {
	s.ArtifactsConfiguration = v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *ChimeSdkMeetingConfiguration) SetSourceConfiguration(v *SourceConfiguration) *ChimeSdkMeetingConfiguration {
	s.SourceConfiguration = v
	return s
}

// The content artifact object.
type ContentArtifactsConfiguration struct {
	_ struct{} `type:"structure"`

	// The MUX type of the artifact configuration.
	MuxType *string `type:"string" enum:"ContentMuxType"`

	// Indicates whether the content artifact is enabled or disabled.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ArtifactsState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentArtifactsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentArtifactsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentArtifactsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentArtifactsConfiguration"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMuxType sets the MuxType field's value.
func (s *ContentArtifactsConfiguration) SetMuxType(v string) *ContentArtifactsConfiguration {
	s.MuxType = &v
	return s
}

// SetState sets the State field's value.
func (s *ContentArtifactsConfiguration) SetState(v string) *ContentArtifactsConfiguration {
	s.State = &v
	return s
}

type CreateMediaCapturePipelineInput struct {
	_ struct{} `type:"structure"`

	// The configuration for a specified media capture pipeline. SourceType must
	// be ChimeSdkMeeting.
	ChimeSdkMeetingConfiguration *ChimeSdkMeetingConfiguration `type:"structure"`

	// The token assigned to the client making the pipeline request.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMediaCapturePipelineInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The ARN of the sink type.
	//
	// SinkArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMediaCapturePipelineInput's
	// String and GoString methods.
	//
	// SinkArn is a required field
	SinkArn *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Destination type to which the media artifacts are saved. You must use an
	// S3 bucket.
	//
	// SinkType is a required field
	SinkType *string `type:"string" required:"true" enum:"MediaPipelineSinkType"`

	// ARN of the source from which the media artifacts are captured.
	//
	// SourceArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMediaCapturePipelineInput's
	// String and GoString methods.
	//
	// SourceArn is a required field
	SourceArn *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Source type from which the media artifacts are captured. A Chime SDK Meeting
	// is the only supported source.
	//
	// SourceType is a required field
	SourceType *string `type:"string" required:"true" enum:"MediaPipelineSourceType"`

	// The list of tags.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaCapturePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaCapturePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMediaCapturePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMediaCapturePipelineInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.SinkArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SinkArn"))
	}
	if s.SinkArn != nil && len(*s.SinkArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SinkArn", 1))
	}
	if s.SinkType == nil {
		invalidParams.Add(request.NewErrParamRequired("SinkType"))
	}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 1))
	}
	if s.SourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceType"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ChimeSdkMeetingConfiguration != nil {
		if err := s.ChimeSdkMeetingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChimeSdkMeetingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChimeSdkMeetingConfiguration sets the ChimeSdkMeetingConfiguration field's value.
func (s *CreateMediaCapturePipelineInput) SetChimeSdkMeetingConfiguration(v *ChimeSdkMeetingConfiguration) *CreateMediaCapturePipelineInput {
	s.ChimeSdkMeetingConfiguration = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMediaCapturePipelineInput) SetClientRequestToken(v string) *CreateMediaCapturePipelineInput {
	s.ClientRequestToken = &v
	return s
}

// SetSinkArn sets the SinkArn field's value.
func (s *CreateMediaCapturePipelineInput) SetSinkArn(v string) *CreateMediaCapturePipelineInput {
	s.SinkArn = &v
	return s
}

// SetSinkType sets the SinkType field's value.
func (s *CreateMediaCapturePipelineInput) SetSinkType(v string) *CreateMediaCapturePipelineInput {
	s.SinkType = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *CreateMediaCapturePipelineInput) SetSourceArn(v string) *CreateMediaCapturePipelineInput {
	s.SourceArn = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateMediaCapturePipelineInput) SetSourceType(v string) *CreateMediaCapturePipelineInput {
	s.SourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMediaCapturePipelineInput) SetTags(v []*Tag) *CreateMediaCapturePipelineInput {
	s.Tags = v
	return s
}

type CreateMediaCapturePipelineOutput struct {
	_ struct{} `type:"structure"`

	// A media capture pipeline object, the ID, source type, source ARN, sink type,
	// and sink ARN of a media capture pipeline object.
	MediaCapturePipeline *MediaCapturePipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaCapturePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMediaCapturePipelineOutput) GoString() string {
	return s.String()
}

// SetMediaCapturePipeline sets the MediaCapturePipeline field's value.
func (s *CreateMediaCapturePipelineOutput) SetMediaCapturePipeline(v *MediaCapturePipeline) *CreateMediaCapturePipelineOutput {
	s.MediaCapturePipeline = v
	return s
}

type DeleteMediaCapturePipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the media capture pipeline being deleted.
	//
	// MediaPipelineId is a required field
	MediaPipelineId *string `location:"uri" locationName:"mediaPipelineId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaCapturePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaCapturePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMediaCapturePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMediaCapturePipelineInput"}
	if s.MediaPipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaPipelineId"))
	}
	if s.MediaPipelineId != nil && len(*s.MediaPipelineId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MediaPipelineId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *DeleteMediaCapturePipelineInput) SetMediaPipelineId(v string) *DeleteMediaCapturePipelineInput {
	s.MediaPipelineId = &v
	return s
}

type DeleteMediaCapturePipelineOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaCapturePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMediaCapturePipelineOutput) GoString() string {
	return s.String()
}

// The client is permanently forbidden from making the request.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetMediaCapturePipelineInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the pipeline that you want to get.
	//
	// MediaPipelineId is a required field
	MediaPipelineId *string `location:"uri" locationName:"mediaPipelineId" min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaCapturePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaCapturePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMediaCapturePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMediaCapturePipelineInput"}
	if s.MediaPipelineId == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaPipelineId"))
	}
	if s.MediaPipelineId != nil && len(*s.MediaPipelineId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("MediaPipelineId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *GetMediaCapturePipelineInput) SetMediaPipelineId(v string) *GetMediaCapturePipelineInput {
	s.MediaPipelineId = &v
	return s
}

type GetMediaCapturePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The media capture pipeline object.
	MediaCapturePipeline *MediaCapturePipeline `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaCapturePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMediaCapturePipelineOutput) GoString() string {
	return s.String()
}

// SetMediaCapturePipeline sets the MediaCapturePipeline field's value.
func (s *GetMediaCapturePipelineOutput) SetMediaCapturePipeline(v *MediaCapturePipeline) *GetMediaCapturePipelineOutput {
	s.MediaCapturePipeline = v
	return s
}

type ListMediaCapturePipelinesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in a single call. Valid Range: 1
	// - 99.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token used to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaCapturePipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaCapturePipelinesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMediaCapturePipelinesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMediaCapturePipelinesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMediaCapturePipelinesInput) SetMaxResults(v int64) *ListMediaCapturePipelinesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMediaCapturePipelinesInput) SetNextToken(v string) *ListMediaCapturePipelinesInput {
	s.NextToken = &v
	return s
}

type ListMediaCapturePipelinesOutput struct {
	_ struct{} `type:"structure"`

	// The media capture pipeline objects in the list.
	MediaCapturePipelines []*MediaCapturePipelineSummary `type:"list"`

	// The token used to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaCapturePipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMediaCapturePipelinesOutput) GoString() string {
	return s.String()
}

// SetMediaCapturePipelines sets the MediaCapturePipelines field's value.
func (s *ListMediaCapturePipelinesOutput) SetMediaCapturePipelines(v []*MediaCapturePipelineSummary) *ListMediaCapturePipelinesOutput {
	s.MediaCapturePipelines = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMediaCapturePipelinesOutput) SetNextToken(v string) *ListMediaCapturePipelinesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `location:"querystring" locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tag key-value pairs.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A media capture pipeline object consisting of an ID, source type, source
// ARN, a sink type, a sink ARN, and a configuration object.
type MediaCapturePipeline struct {
	_ struct{} `type:"structure"`

	// The configuration for a specified media capture pipeline. SourceType must
	// be ChimeSdkMeeting.
	ChimeSdkMeetingConfiguration *ChimeSdkMeetingConfiguration `type:"structure"`

	// The time at which the capture pipeline was created, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The ARN of a media capture pipeline.
	MediaPipelineArn *string `min:"1" type:"string"`

	// The ID of a media capture pipeline.
	MediaPipelineId *string `min:"36" type:"string"`

	// ARN of the destination to which the media artifacts are saved.
	//
	// SinkArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MediaCapturePipeline's
	// String and GoString methods.
	SinkArn *string `min:"1" type:"string" sensitive:"true"`

	// Destination type to which the media artifacts are saved. You must use an
	// S3 Bucket.
	SinkType *string `type:"string" enum:"MediaPipelineSinkType"`

	// ARN of the source from which the media artifacts are saved.
	//
	// SourceArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MediaCapturePipeline's
	// String and GoString methods.
	SourceArn *string `min:"1" type:"string" sensitive:"true"`

	// Source type from which media artifacts are saved. You must use ChimeMeeting.
	SourceType *string `type:"string" enum:"MediaPipelineSourceType"`

	// The status of the media capture pipeline.
	Status *string `type:"string" enum:"MediaPipelineStatus"`

	// The time at which the capture pipeline was updated, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaCapturePipeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaCapturePipeline) GoString() string {
	return s.String()
}

// SetChimeSdkMeetingConfiguration sets the ChimeSdkMeetingConfiguration field's value.
func (s *MediaCapturePipeline) SetChimeSdkMeetingConfiguration(v *ChimeSdkMeetingConfiguration) *MediaCapturePipeline {
	s.ChimeSdkMeetingConfiguration = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *MediaCapturePipeline) SetCreatedTimestamp(v time.Time) *MediaCapturePipeline {
	s.CreatedTimestamp = &v
	return s
}

// SetMediaPipelineArn sets the MediaPipelineArn field's value.
func (s *MediaCapturePipeline) SetMediaPipelineArn(v string) *MediaCapturePipeline {
	s.MediaPipelineArn = &v
	return s
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *MediaCapturePipeline) SetMediaPipelineId(v string) *MediaCapturePipeline {
	s.MediaPipelineId = &v
	return s
}

// SetSinkArn sets the SinkArn field's value.
func (s *MediaCapturePipeline) SetSinkArn(v string) *MediaCapturePipeline {
	s.SinkArn = &v
	return s
}

// SetSinkType sets the SinkType field's value.
func (s *MediaCapturePipeline) SetSinkType(v string) *MediaCapturePipeline {
	s.SinkType = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *MediaCapturePipeline) SetSourceArn(v string) *MediaCapturePipeline {
	s.SourceArn = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *MediaCapturePipeline) SetSourceType(v string) *MediaCapturePipeline {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *MediaCapturePipeline) SetStatus(v string) *MediaCapturePipeline {
	s.Status = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *MediaCapturePipeline) SetUpdatedTimestamp(v time.Time) *MediaCapturePipeline {
	s.UpdatedTimestamp = &v
	return s
}

// A summary of a media capture pipeline.
type MediaCapturePipelineSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of a media capture pipeline.
	MediaPipelineArn *string `min:"1" type:"string"`

	// The ID of a media capture pipeline.
	MediaPipelineId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaCapturePipelineSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaCapturePipelineSummary) GoString() string {
	return s.String()
}

// SetMediaPipelineArn sets the MediaPipelineArn field's value.
func (s *MediaCapturePipelineSummary) SetMediaPipelineArn(v string) *MediaCapturePipelineSummary {
	s.MediaPipelineArn = &v
	return s
}

// SetMediaPipelineId sets the MediaPipelineId field's value.
func (s *MediaCapturePipelineSummary) SetMediaPipelineId(v string) *MediaCapturePipelineSummary {
	s.MediaPipelineId = &v
	return s
}

// One or more of the resources in the request does not exist in the system.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request exceeds the resource limit.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The video streams to capture for a specified media capture pipeline. The
// total number of video streams can't exceed 25.
type SelectedVideoStreams struct {
	_ struct{} `type:"structure"`

	// The attendee IDs of the streams selected for a media capture pipeline.
	AttendeeIds []*string `min:"1" type:"list"`

	// The external user IDs of the streams selected for a media capture pipeline.
	ExternalUserIds []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelectedVideoStreams) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelectedVideoStreams) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectedVideoStreams) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelectedVideoStreams"}
	if s.AttendeeIds != nil && len(s.AttendeeIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttendeeIds", 1))
	}
	if s.ExternalUserIds != nil && len(s.ExternalUserIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalUserIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendeeIds sets the AttendeeIds field's value.
func (s *SelectedVideoStreams) SetAttendeeIds(v []*string) *SelectedVideoStreams {
	s.AttendeeIds = v
	return s
}

// SetExternalUserIds sets the ExternalUserIds field's value.
func (s *SelectedVideoStreams) SetExternalUserIds(v []*string) *SelectedVideoStreams {
	s.ExternalUserIds = v
	return s
}

// The service encountered an unexpected error.
type ServiceFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceFailureException) GoString() string {
	return s.String()
}

func newErrorServiceFailureException(v protocol.ResponseMetadata) error {
	return &ServiceFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceFailureException) Code() string {
	return "ServiceFailureException"
}

// Message returns the exception's message.
func (s *ServiceFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceFailureException) OrigErr() error {
	return nil
}

func (s *ServiceFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is currently unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Source configuration for a specified media capture pipeline.
type SourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The selected video streams to capture for a specified media capture pipeline.
	// The number of video streams can't exceed 25.
	SelectedVideoStreams *SelectedVideoStreams `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceConfiguration"}
	if s.SelectedVideoStreams != nil {
		if err := s.SelectedVideoStreams.Validate(); err != nil {
			invalidParams.AddNested("SelectedVideoStreams", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSelectedVideoStreams sets the SelectedVideoStreams field's value.
func (s *SourceConfiguration) SetSelectedVideoStreams(v *SelectedVideoStreams) *SourceConfiguration {
	s.SelectedVideoStreams = v
	return s
}

// Describes a tag applied to a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tag key-value pairs.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The client exceeded its request rate limit.
type ThrottledClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottledClientException) GoString() string {
	return s.String()
}

func newErrorThrottledClientException(v protocol.ResponseMetadata) error {
	return &ThrottledClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottledClientException) Code() string {
	return "ThrottledClientException"
}

// Message returns the exception's message.
func (s *ThrottledClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottledClientException) OrigErr() error {
	return nil
}

func (s *ThrottledClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottledClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottledClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The client is not currently authorized to make the request.
type UnauthorizedClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedClientException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedClientException(v protocol.ResponseMetadata) error {
	return &UnauthorizedClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedClientException) Code() string {
	return "UnauthorizedClientException"
}

// Message returns the exception's message.
func (s *UnauthorizedClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedClientException) OrigErr() error {
	return nil
}

func (s *UnauthorizedClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// The video artifact configuration object.
type VideoArtifactsConfiguration struct {
	_ struct{} `type:"structure"`

	// The MUX type of the video artifact configuration object.
	MuxType *string `type:"string" enum:"VideoMuxType"`

	// Indicates whether the video artifact is enabled or disabled.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"ArtifactsState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoArtifactsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VideoArtifactsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VideoArtifactsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VideoArtifactsConfiguration"}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMuxType sets the MuxType field's value.
func (s *VideoArtifactsConfiguration) SetMuxType(v string) *VideoArtifactsConfiguration {
	s.MuxType = &v
	return s
}

// SetState sets the State field's value.
func (s *VideoArtifactsConfiguration) SetState(v string) *VideoArtifactsConfiguration {
	s.State = &v
	return s
}

const (
	// ArtifactsStateEnabled is a ArtifactsState enum value
	ArtifactsStateEnabled = "Enabled"

	// ArtifactsStateDisabled is a ArtifactsState enum value
	ArtifactsStateDisabled = "Disabled"
)

// ArtifactsState_Values returns all elements of the ArtifactsState enum
func ArtifactsState_Values() []string {
	return []string{
		ArtifactsStateEnabled,
		ArtifactsStateDisabled,
	}
}

const (
	// AudioMuxTypeAudioOnly is a AudioMuxType enum value
	AudioMuxTypeAudioOnly = "AudioOnly"

	// AudioMuxTypeAudioWithActiveSpeakerVideo is a AudioMuxType enum value
	AudioMuxTypeAudioWithActiveSpeakerVideo = "AudioWithActiveSpeakerVideo"
)

// AudioMuxType_Values returns all elements of the AudioMuxType enum
func AudioMuxType_Values() []string {
	return []string{
		AudioMuxTypeAudioOnly,
		AudioMuxTypeAudioWithActiveSpeakerVideo,
	}
}

const (
	// ContentMuxTypeContentOnly is a ContentMuxType enum value
	ContentMuxTypeContentOnly = "ContentOnly"
)

// ContentMuxType_Values returns all elements of the ContentMuxType enum
func ContentMuxType_Values() []string {
	return []string{
		ContentMuxTypeContentOnly,
	}
}

const (
	// ErrorCodeBadRequest is a ErrorCode enum value
	ErrorCodeBadRequest = "BadRequest"

	// ErrorCodeForbidden is a ErrorCode enum value
	ErrorCodeForbidden = "Forbidden"

	// ErrorCodeNotFound is a ErrorCode enum value
	ErrorCodeNotFound = "NotFound"

	// ErrorCodeResourceLimitExceeded is a ErrorCode enum value
	ErrorCodeResourceLimitExceeded = "ResourceLimitExceeded"

	// ErrorCodeServiceFailure is a ErrorCode enum value
	ErrorCodeServiceFailure = "ServiceFailure"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeThrottling is a ErrorCode enum value
	ErrorCodeThrottling = "Throttling"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeBadRequest,
		ErrorCodeForbidden,
		ErrorCodeNotFound,
		ErrorCodeResourceLimitExceeded,
		ErrorCodeServiceFailure,
		ErrorCodeServiceUnavailable,
		ErrorCodeThrottling,
	}
}

const (
	// MediaPipelineSinkTypeS3bucket is a MediaPipelineSinkType enum value
	MediaPipelineSinkTypeS3bucket = "S3Bucket"
)

// MediaPipelineSinkType_Values returns all elements of the MediaPipelineSinkType enum
func MediaPipelineSinkType_Values() []string {
	return []string{
		MediaPipelineSinkTypeS3bucket,
	}
}

const (
	// MediaPipelineSourceTypeChimeSdkMeeting is a MediaPipelineSourceType enum value
	MediaPipelineSourceTypeChimeSdkMeeting = "ChimeSdkMeeting"
)

// MediaPipelineSourceType_Values returns all elements of the MediaPipelineSourceType enum
func MediaPipelineSourceType_Values() []string {
	return []string{
		MediaPipelineSourceTypeChimeSdkMeeting,
	}
}

const (
	// MediaPipelineStatusInitializing is a MediaPipelineStatus enum value
	MediaPipelineStatusInitializing = "Initializing"

	// MediaPipelineStatusInProgress is a MediaPipelineStatus enum value
	MediaPipelineStatusInProgress = "InProgress"

	// MediaPipelineStatusFailed is a MediaPipelineStatus enum value
	MediaPipelineStatusFailed = "Failed"

	// MediaPipelineStatusStopping is a MediaPipelineStatus enum value
	MediaPipelineStatusStopping = "Stopping"

	// MediaPipelineStatusStopped is a MediaPipelineStatus enum value
	MediaPipelineStatusStopped = "Stopped"
)

// MediaPipelineStatus_Values returns all elements of the MediaPipelineStatus enum
func MediaPipelineStatus_Values() []string {
	return []string{
		MediaPipelineStatusInitializing,
		MediaPipelineStatusInProgress,
		MediaPipelineStatusFailed,
		MediaPipelineStatusStopping,
		MediaPipelineStatusStopped,
	}
}

const (
	// VideoMuxTypeVideoOnly is a VideoMuxType enum value
	VideoMuxTypeVideoOnly = "VideoOnly"
)

// VideoMuxType_Values returns all elements of the VideoMuxType enum
func VideoMuxType_Values() []string {
	return []string{
		VideoMuxTypeVideoOnly,
	}
}
