// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package speech aliases all exported identifiers in package
// "cloud.google.com/go/speech/apiv2/speechpb".
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package speech

import (
	src "cloud.google.com/go/speech/apiv2/speechpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/speech/apiv2/speechpb
const (
	CustomClass_ACTIVE                                       = src.CustomClass_ACTIVE
	CustomClass_DELETED                                      = src.CustomClass_DELETED
	CustomClass_STATE_UNSPECIFIED                            = src.CustomClass_STATE_UNSPECIFIED
	ExplicitDecodingConfig_ALAW                              = src.ExplicitDecodingConfig_ALAW
	ExplicitDecodingConfig_AUDIO_ENCODING_UNSPECIFIED        = src.ExplicitDecodingConfig_AUDIO_ENCODING_UNSPECIFIED
	ExplicitDecodingConfig_LINEAR16                          = src.ExplicitDecodingConfig_LINEAR16
	ExplicitDecodingConfig_MULAW                             = src.ExplicitDecodingConfig_MULAW
	PhraseSet_ACTIVE                                         = src.PhraseSet_ACTIVE
	PhraseSet_DELETED                                        = src.PhraseSet_DELETED
	PhraseSet_STATE_UNSPECIFIED                              = src.PhraseSet_STATE_UNSPECIFIED
	RecognitionFeatures_MULTI_CHANNEL_MODE_UNSPECIFIED       = src.RecognitionFeatures_MULTI_CHANNEL_MODE_UNSPECIFIED
	RecognitionFeatures_SEPARATE_RECOGNITION_PER_CHANNEL     = src.RecognitionFeatures_SEPARATE_RECOGNITION_PER_CHANNEL
	Recognizer_ACTIVE                                        = src.Recognizer_ACTIVE
	Recognizer_DELETED                                       = src.Recognizer_DELETED
	Recognizer_STATE_UNSPECIFIED                             = src.Recognizer_STATE_UNSPECIFIED
	StreamingRecognizeResponse_END_OF_SINGLE_UTTERANCE       = src.StreamingRecognizeResponse_END_OF_SINGLE_UTTERANCE
	StreamingRecognizeResponse_SPEECH_ACTIVITY_BEGIN         = src.StreamingRecognizeResponse_SPEECH_ACTIVITY_BEGIN
	StreamingRecognizeResponse_SPEECH_ACTIVITY_END           = src.StreamingRecognizeResponse_SPEECH_ACTIVITY_END
	StreamingRecognizeResponse_SPEECH_EVENT_TYPE_UNSPECIFIED = src.StreamingRecognizeResponse_SPEECH_EVENT_TYPE_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/speech/apiv2/speechpb
var (
	CustomClass_State_name                           = src.CustomClass_State_name
	CustomClass_State_value                          = src.CustomClass_State_value
	ExplicitDecodingConfig_AudioEncoding_name        = src.ExplicitDecodingConfig_AudioEncoding_name
	ExplicitDecodingConfig_AudioEncoding_value       = src.ExplicitDecodingConfig_AudioEncoding_value
	File_google_cloud_speech_v2_cloud_speech_proto   = src.File_google_cloud_speech_v2_cloud_speech_proto
	PhraseSet_State_name                             = src.PhraseSet_State_name
	PhraseSet_State_value                            = src.PhraseSet_State_value
	RecognitionFeatures_MultiChannelMode_name        = src.RecognitionFeatures_MultiChannelMode_name
	RecognitionFeatures_MultiChannelMode_value       = src.RecognitionFeatures_MultiChannelMode_value
	Recognizer_State_name                            = src.Recognizer_State_name
	Recognizer_State_value                           = src.Recognizer_State_value
	StreamingRecognizeResponse_SpeechEventType_name  = src.StreamingRecognizeResponse_SpeechEventType_name
	StreamingRecognizeResponse_SpeechEventType_value = src.StreamingRecognizeResponse_SpeechEventType_value
)

// Automatically detected decoding parameters. Supported for the following
// encodings: * WAV_LINEAR16: 16-bit signed little-endian PCM samples in a WAV
// container. * WAV_MULAW: 8-bit companded mulaw samples in a WAV container. *
// WAV_ALAW: 8-bit companded alaw samples in a WAV container. * RFC4867_5_AMR:
// AMR frames with an rfc4867.5 header. * RFC4867_5_AMRWB: AMR-WB frames with
// an rfc4867.5 header. * FLAC: FLAC frames in the "native FLAC" container
// format. * MP3: MPEG audio frames with optional (ignored) ID3 metadata. *
// OGG_OPUS: Opus audio frames in an Ogg container. * WEBM_OPUS: Opus audio
// frames in a WebM container.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type AutoDetectDecodingConfig = src.AutoDetectDecodingConfig

// Metadata about a single file in a batch for BatchRecognize.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type BatchRecognizeFileMetadata = src.BatchRecognizeFileMetadata
type BatchRecognizeFileMetadata_Uri = src.BatchRecognizeFileMetadata_Uri

// Final results for a single file.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type BatchRecognizeFileResult = src.BatchRecognizeFileResult

// Operation metadata for
// [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize].
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type BatchRecognizeMetadata = src.BatchRecognizeMetadata

// Request message for the
// [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type BatchRecognizeRequest = src.BatchRecognizeRequest

// Response message for
// [BatchRecognize][google.cloud.speech.v2.Speech.BatchRecognize] that is
// packaged into a longrunning [Operation][google.longrunning.Operation].
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type BatchRecognizeResponse = src.BatchRecognizeResponse

// Metadata about transcription for a single file (for example, progress
// percent).
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type BatchRecognizeTranscriptionMetadata = src.BatchRecognizeTranscriptionMetadata

// Message representing the config for the Speech-to-Text API. This includes
// an optional [KMS
// key](https://cloud.google.com/kms/docs/resource-hierarchy#keys) with which
// incoming data will be encrypted.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type Config = src.Config

// Request message for the
// [CreateCustomClass][google.cloud.speech.v2.Speech.CreateCustomClass] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type CreateCustomClassRequest = src.CreateCustomClassRequest

// Request message for the
// [CreatePhraseSet][google.cloud.speech.v2.Speech.CreatePhraseSet] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type CreatePhraseSetRequest = src.CreatePhraseSetRequest

// Request message for the
// [CreateRecognizer][google.cloud.speech.v2.Speech.CreateRecognizer] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type CreateRecognizerRequest = src.CreateRecognizerRequest

// CustomClass for biasing in speech recognition. Used to define a set of
// words or phrases that represents a common concept or theme likely to appear
// in your audio, for example a list of passenger ship names.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type CustomClass = src.CustomClass

// An item of the class.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type CustomClass_ClassItem = src.CustomClass_ClassItem

// Set of states that define the lifecycle of a CustomClass.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type CustomClass_State = src.CustomClass_State

// Request message for the
// [DeleteCustomClass][google.cloud.speech.v2.Speech.DeleteCustomClass] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type DeleteCustomClassRequest = src.DeleteCustomClassRequest

// Request message for the
// [DeletePhraseSet][google.cloud.speech.v2.Speech.DeletePhraseSet] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type DeletePhraseSetRequest = src.DeletePhraseSetRequest

// Request message for the
// [DeleteRecognizer][google.cloud.speech.v2.Speech.DeleteRecognizer] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type DeleteRecognizerRequest = src.DeleteRecognizerRequest

// Explicitly specified decoding parameters.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type ExplicitDecodingConfig = src.ExplicitDecodingConfig

// Supported audio data encodings.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type ExplicitDecodingConfig_AudioEncoding = src.ExplicitDecodingConfig_AudioEncoding

// Request message for the
// [GetConfig][google.cloud.speech.v2.Speech.GetConfig] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type GetConfigRequest = src.GetConfigRequest

// Request message for the
// [GetCustomClass][google.cloud.speech.v2.Speech.GetCustomClass] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type GetCustomClassRequest = src.GetCustomClassRequest

// Request message for the
// [GetPhraseSet][google.cloud.speech.v2.Speech.GetPhraseSet] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type GetPhraseSetRequest = src.GetPhraseSetRequest

// Request message for the
// [GetRecognizer][google.cloud.speech.v2.Speech.GetRecognizer] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type GetRecognizerRequest = src.GetRecognizerRequest

// Request message for the
// [ListCustomClasses][google.cloud.speech.v2.Speech.ListCustomClasses] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type ListCustomClassesRequest = src.ListCustomClassesRequest

// Response message for the
// [ListCustomClasses][google.cloud.speech.v2.Speech.ListCustomClasses] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type ListCustomClassesResponse = src.ListCustomClassesResponse

// Request message for the
// [ListPhraseSets][google.cloud.speech.v2.Speech.ListPhraseSets] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type ListPhraseSetsRequest = src.ListPhraseSetsRequest

// Response message for the
// [ListPhraseSets][google.cloud.speech.v2.Speech.ListPhraseSets] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type ListPhraseSetsResponse = src.ListPhraseSetsResponse

// Request message for the
// [ListRecognizers][google.cloud.speech.v2.Speech.ListRecognizers] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type ListRecognizersRequest = src.ListRecognizersRequest

// Response message for the
// [ListRecognizers][google.cloud.speech.v2.Speech.ListRecognizers] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type ListRecognizersResponse = src.ListRecognizersResponse

// Represents the metadata of a long-running operation.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type OperationMetadata = src.OperationMetadata
type OperationMetadata_BatchRecognizeMetadata = src.OperationMetadata_BatchRecognizeMetadata
type OperationMetadata_BatchRecognizeRequest = src.OperationMetadata_BatchRecognizeRequest
type OperationMetadata_CreateCustomClassRequest = src.OperationMetadata_CreateCustomClassRequest
type OperationMetadata_CreatePhraseSetRequest = src.OperationMetadata_CreatePhraseSetRequest
type OperationMetadata_CreateRecognizerRequest = src.OperationMetadata_CreateRecognizerRequest
type OperationMetadata_DeleteCustomClassRequest = src.OperationMetadata_DeleteCustomClassRequest
type OperationMetadata_DeletePhraseSetRequest = src.OperationMetadata_DeletePhraseSetRequest
type OperationMetadata_DeleteRecognizerRequest = src.OperationMetadata_DeleteRecognizerRequest
type OperationMetadata_UndeleteCustomClassRequest = src.OperationMetadata_UndeleteCustomClassRequest
type OperationMetadata_UndeletePhraseSetRequest = src.OperationMetadata_UndeletePhraseSetRequest
type OperationMetadata_UndeleteRecognizerRequest = src.OperationMetadata_UndeleteRecognizerRequest
type OperationMetadata_UpdateConfigRequest = src.OperationMetadata_UpdateConfigRequest
type OperationMetadata_UpdateCustomClassRequest = src.OperationMetadata_UpdateCustomClassRequest
type OperationMetadata_UpdatePhraseSetRequest = src.OperationMetadata_UpdatePhraseSetRequest
type OperationMetadata_UpdateRecognizerRequest = src.OperationMetadata_UpdateRecognizerRequest

// PhraseSet for biasing in speech recognition. A PhraseSet is used to provide
// "hints" to the speech recognizer to favor specific words and phrases in the
// results.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type PhraseSet = src.PhraseSet

// A Phrase contains words and phrase "hints" so that the speech recognition
// is more likely to recognize them. This can be used to improve the accuracy
// for specific words and phrases, for example, if specific commands are
// typically spoken by the user. This can also be used to add additional words
// to the vocabulary of the recognizer. List items can also include CustomClass
// references containing groups of words that represent common concepts that
// occur in natural language.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type PhraseSet_Phrase = src.PhraseSet_Phrase

// Set of states that define the lifecycle of a PhraseSet.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type PhraseSet_State = src.PhraseSet_State

// Provides information to the Recognizer that specifies how to process the
// recognition request.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type RecognitionConfig = src.RecognitionConfig
type RecognitionConfig_AutoDecodingConfig = src.RecognitionConfig_AutoDecodingConfig
type RecognitionConfig_ExplicitDecodingConfig = src.RecognitionConfig_ExplicitDecodingConfig

// Available recognition features.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type RecognitionFeatures = src.RecognitionFeatures

// Options for how to recognize multi-channel audio.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type RecognitionFeatures_MultiChannelMode = src.RecognitionFeatures_MultiChannelMode

// Metadata about the recognition request and response.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type RecognitionResponseMetadata = src.RecognitionResponseMetadata

// Request message for the
// [Recognize][google.cloud.speech.v2.Speech.Recognize] method. Either
// `content` or `uri` must be supplied. Supplying both or neither returns
// [INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. See [content
// limits](https://cloud.google.com/speech-to-text/quotas#content).
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type RecognizeRequest = src.RecognizeRequest
type RecognizeRequest_Content = src.RecognizeRequest_Content
type RecognizeRequest_Uri = src.RecognizeRequest_Uri

// Response message for the
// [Recognize][google.cloud.speech.v2.Speech.Recognize] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type RecognizeResponse = src.RecognizeResponse

// A Recognizer message. Stores recognition configuration and metadata.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type Recognizer = src.Recognizer

// Set of states that define the lifecycle of a Recognizer.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type Recognizer_State = src.Recognizer_State

// Configuration to enable speaker diarization.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type SpeakerDiarizationConfig = src.SpeakerDiarizationConfig

// Provides "hints" to the speech recognizer to favor specific words and
// phrases in the results. Phrase sets can be specified as an inline resource,
// or a reference to an existing phrase set resource.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type SpeechAdaptation = src.SpeechAdaptation

// A biasing phrase set, which can be either a string referencing the name of
// an existing phrase set resource, or an inline definition of a phrase set.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type SpeechAdaptation_AdaptationPhraseSet = src.SpeechAdaptation_AdaptationPhraseSet
type SpeechAdaptation_AdaptationPhraseSet_InlinePhraseSet = src.SpeechAdaptation_AdaptationPhraseSet_InlinePhraseSet
type SpeechAdaptation_AdaptationPhraseSet_PhraseSet = src.SpeechAdaptation_AdaptationPhraseSet_PhraseSet

// SpeechClient is the client API for Speech service. For semantics around ctx
// use and closing/ending streaming RPCs, please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type SpeechClient = src.SpeechClient

// Alternative hypotheses (a.k.a. n-best list).
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type SpeechRecognitionAlternative = src.SpeechRecognitionAlternative

// A speech recognition result corresponding to a portion of the audio.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type SpeechRecognitionResult = src.SpeechRecognitionResult

// SpeechServer is the server API for Speech service.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type SpeechServer = src.SpeechServer
type Speech_StreamingRecognizeClient = src.Speech_StreamingRecognizeClient
type Speech_StreamingRecognizeServer = src.Speech_StreamingRecognizeServer

// Provides configuration information for the StreamingRecognize request.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type StreamingRecognitionConfig = src.StreamingRecognitionConfig

// Available recognition features specific to streaming recognition requests.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type StreamingRecognitionFeatures = src.StreamingRecognitionFeatures

// Events that a timeout can be set on for voice activity.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type StreamingRecognitionFeatures_VoiceActivityTimeout = src.StreamingRecognitionFeatures_VoiceActivityTimeout

// A streaming speech recognition result corresponding to a portion of the
// audio that is currently being processed.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type StreamingRecognitionResult = src.StreamingRecognitionResult

// Request message for the
// [StreamingRecognize][google.cloud.speech.v2.Speech.StreamingRecognize]
// method. Multiple
// [StreamingRecognizeRequest][google.cloud.speech.v2.StreamingRecognizeRequest]
// messages are sent. The first message must contain a
// [recognizer][google.cloud.speech.v2.StreamingRecognizeRequest.recognizer]
// and optionally a
// [streaming_config][google.cloud.speech.v2.StreamingRecognizeRequest.streaming_config]
// message and must not contain
// [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio]. All
// subsequent messages must contain
// [audio][google.cloud.speech.v2.StreamingRecognizeRequest.audio] and must not
// contain a
// [streaming_config][google.cloud.speech.v2.StreamingRecognizeRequest.streaming_config]
// message.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type StreamingRecognizeRequest = src.StreamingRecognizeRequest
type StreamingRecognizeRequest_Audio = src.StreamingRecognizeRequest_Audio
type StreamingRecognizeRequest_StreamingConfig = src.StreamingRecognizeRequest_StreamingConfig

// `StreamingRecognizeResponse` is the only message returned to the client by
// `StreamingRecognize`. A series of zero or more `StreamingRecognizeResponse`
// messages are streamed back to the client. If there is no recognizable audio
// then no messages are streamed back to the client. Here are some examples of
// `StreamingRecognizeResponse`s that might be returned while processing audio:
// 1. results { alternatives { transcript: "tube" } stability: 0.01 } 2.
// results { alternatives { transcript: "to be a" } stability: 0.01 } 3.
// results { alternatives { transcript: "to be" } stability: 0.9 } results {
// alternatives { transcript: " or not to be" } stability: 0.01 } 4. results {
// alternatives { transcript: "to be or not to be" confidence: 0.92 }
// alternatives { transcript: "to bee or not to bee" } is_final: true } 5.
// results { alternatives { transcript: " that's" } stability: 0.01 } 6.
// results { alternatives { transcript: " that is" } stability: 0.9 } results {
// alternatives { transcript: " the question" } stability: 0.01 } 7. results {
// alternatives { transcript: " that is the question" confidence: 0.98 }
// alternatives { transcript: " that was the question" } is_final: true }
// Notes: - Only two of the above responses #4 and #7 contain final results;
// they are indicated by `is_final: true`. Concatenating these together
// generates the full transcript: "to be or not to be that is the question". -
// The others contain interim `results`. #3 and #6 contain two interim
// `results`: the first portion has a high stability and is less likely to
// change; the second portion has a low stability and is very likely to change.
// A UI designer might choose to show only high stability `results`. - The
// specific `stability` and `confidence` values shown above are only for
// illustrative purposes. Actual values may vary. - In each response, only one
// of these fields will be set: `error`, `speech_event_type`, or one or more
// (repeated) `results`.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type StreamingRecognizeResponse = src.StreamingRecognizeResponse

// Indicates the type of speech event.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type StreamingRecognizeResponse_SpeechEventType = src.StreamingRecognizeResponse_SpeechEventType

// Request message for the
// [UndeleteCustomClass][google.cloud.speech.v2.Speech.UndeleteCustomClass]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type UndeleteCustomClassRequest = src.UndeleteCustomClassRequest

// Request message for the
// [UndeletePhraseSet][google.cloud.speech.v2.Speech.UndeletePhraseSet] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type UndeletePhraseSetRequest = src.UndeletePhraseSetRequest

// Request message for the
// [UndeleteRecognizer][google.cloud.speech.v2.Speech.UndeleteRecognizer]
// method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type UndeleteRecognizerRequest = src.UndeleteRecognizerRequest

// UnimplementedSpeechServer can be embedded to have forward compatible
// implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type UnimplementedSpeechServer = src.UnimplementedSpeechServer

// Request message for the
// [UpdateConfig][google.cloud.speech.v2.Speech.UpdateConfig] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type UpdateConfigRequest = src.UpdateConfigRequest

// Request message for the
// [UpdateCustomClass][google.cloud.speech.v2.Speech.UpdateCustomClass] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type UpdateCustomClassRequest = src.UpdateCustomClassRequest

// Request message for the
// [UpdatePhraseSet][google.cloud.speech.v2.Speech.UpdatePhraseSet] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type UpdatePhraseSetRequest = src.UpdatePhraseSetRequest

// Request message for the
// [UpdateRecognizer][google.cloud.speech.v2.Speech.UpdateRecognizer] method.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type UpdateRecognizerRequest = src.UpdateRecognizerRequest

// Word-specific information for recognized words.
//
// Deprecated: Please use types in: cloud.google.com/go/speech/apiv2/speechpb
type WordInfo = src.WordInfo

// Deprecated: Please use funcs in: cloud.google.com/go/speech/apiv2/speechpb
func NewSpeechClient(cc grpc.ClientConnInterface) SpeechClient { return src.NewSpeechClient(cc) }

// Deprecated: Please use funcs in: cloud.google.com/go/speech/apiv2/speechpb
func RegisterSpeechServer(s *grpc.Server, srv SpeechServer) { src.RegisterSpeechServer(s, srv) }
